(function($) {

//file
$.fn.createFilePane = function(tree){
	var right = this;
	var filePane = $("<div></div>");
	var fileHeader = $("<div class='title'>/ļб</div>").appendTo(filePane);

	var fileTable = $('<table></table>').addClass("table").appendTo(filePane);
	var tableHead = $('<thead></thead>').appendTo(fileTable);
	var tableHR = $('<tr></tr>').appendTo(tableHead);
	var tableHD = $('<th/><th>/ļ</th><th>ʱ</th><th>Ƿ</th>').appendTo(tableHR);
	filePane.tableBody = $('<tbody></tbody>').appendTo(fileTable);

	var fileButton1 = {
		text: "ӱ/ļ",
		handler: function(){
			FR.showDialog("ӱ/ļ",500,-1,SC.addReportDialog(tree));
		}//handler
	};
	var fileButton2 = {
		text: "ɾ/ļ",
		handler: function(){
			var currentItem = tree.getTCT();
			var childNodes = currentItem.ChildNodes;
			if(!childNodes){
				return;
			}
			var checklist = [];
			for(var i=0;i<childNodes.length;i++){
				if(childNodes[i].checked){
					checklist.push(childNodes[i].id);
				}
			}
			if(checklist.length==0){
				return;
			}
			var confirm = window.confirm("ȷɾѡļ");
			if(confirm){
				var reportIds = [];
				for(var i=0; i<checklist.length; i++){
					reportIds[i]=checklist[i];
				}//ûȥǰ
				$.get(
					"${scheduleServletURL}",
					{
					action: "delReports",
					reportIds: reportIds.toString()
					},
					function callback(){//Ӧ
						tree.delNodes(currentItem,checklist);
					}//callback
				);
			}
		}//handler
	};
	SC.buttonTable([fileButton1,fileButton2]).appendTo(filePane);

	return filePane;
}//createFilePane

//task
$.fn.createTaskPane = function(){
	var right = this;
	var taskPane = $("<div></div>");
	var taskHeader = $("<div class='title'>ʱб</div>").appendTo(taskPane);

	var taskTable = $('<table class="table"></table>').appendTo(taskPane);
	var tableHead = $('<thead></thead>').appendTo(taskTable);
	var tableHR = $('<tr></tr>').appendTo(tableHead);
	var tableHD = $('<th/><th></th><th>༭</th><th>״̬</th>').appendTo(tableHR);
	taskPane.tableBody = $('<tbody></tbody>').appendTo(taskTable);

	var taskButtonTable = $("<table></table>").appendTo(taskPane);
	var taskButtons = $("<tr></tr>").appendTo(taskButtonTable);
	var taskButton1 = {
		text: "Ӷʱ",
		handler: function(){
			right.processPane.populate(taskPane.report, "new");
			right.processPane.showPane();
		}
	};
	var taskButton2 = {
		text: "ɾʱ",
		handler: function(){
			var tasks = taskPane.report.tasks;
			var checklist = [];
			for(var i=0;i<tasks.length;i++){
				if(tasks[i].checked){
					checklist.push(tasks[i].id);
				}
			}
			if(checklist.length==0){
				return;
			}
			var confirm = window.confirm("ȷɾѡĶʱ");
			if(confirm){
				$.get(
					"${scheduleServletURL}",
					{
					action: "delTasks",
					taskIds: checklist.toString()
					},
					function callback(){//Ӧ
						right.loadTask(report);
					}//callback
				);
			}
		}//handler
	};
	var taskButton3 = {
		text: "ر",
		handler: function(){
			right.filePane.showPane();
		}//handler
	};
	SC.buttonTable([taskButton1,taskButton2,taskButton3]).appendTo(taskPane);
	
	taskPane.populate = function(report){
		taskPane.report = report;
	}

	return taskPane;
}//createTaskPane

//process
$.fn.createProcessPane = function(tree){
	var right = this;
	var processPane = $('<div class="rightPane"></div>');

	processPane.finish = function(){
		if(!processPane.checkvalid()){
			return;
		}
		processPane.update(processPane.task);
		$.get(
			"${scheduleServletURL}",
			{
				action: "aouTask",
				taskJason: FR.cjkEncode(JSON.stringify(processPane.task))
			},
			function callback(jasonA){
					right.loadTask(processPane.report);
			}//callback
		);
	}
	processPane.cancel = function(){
		right.taskPane.showPane();
	}
	
	var basicPane = basicPane().appendTo(processPane);
	var itriggerPane = itriggerPane().appendTo(processPane).hide();
	var parameterPane = parameterPane().appendTo(processPane).hide();
	var outputPane = outputPane().appendTo(processPane).hide();
	
	function basicPane(){
		var basicPane = $("<div id='basicPane' class='stepPane'>һ</div>");
		var stepFrame = $('<iframe src="${scheduleServletURL}?action=getbasicpane"></iframe>').appendTo(basicPane);
		var taskgroup = {};
		var taskname = {};
		var taskdesc = {};
		basicPane.populate = function (task){
			taskgroup = stepFrame[0].contentWindow.contentPane.curLGP.form.getWidgetByName("taskgroup");
			taskname = stepFrame[0].contentWindow.contentPane.curLGP.form.getWidgetByName("taskname");
			taskdesc = stepFrame[0].contentWindow.contentPane.curLGP.form.getWidgetByName("taskdesc");
			taskgroup.setValue(processPane.report.text);
			taskname.setValue((task.name)? task.name : "");
			taskdesc.setValue((task.description)? task.description : "");
		}
		basicPane.update = function(task){
			task.groupId = processPane.report.id.substr(1);//ȥǰ
			task.name = taskname.getValue();
			task.description = taskdesc.getValue();
		}
		basicPane.checkvalid = function() {
			if(!taskname.getValue()){
				basicPane.showPane();
				alert("д");
				return false;
			}
			return true;
		}
		return basicPane;
	}//outputPane
	
	function itriggerPane(){
		var itriggerPane = $("<div id='itriggerPane' class='stepPane'>ڶʱ</div>");
		var stepFrame = $('<iframe src="${scheduleServletURL}?action=getitriggerpane"></iframe>').appendTo(itriggerPane);
		
		var starttable = $('<table></table>').appendTo(itriggerPane);
		var immediately = $('<tr><td>ʼ:</td><td><input type="radio" name="start" value=1 id="immediately"/>ִ</td></tr>').appendTo(starttable);
		var on =  $('<tr><td></td><td><input type="radio" name="start" value=2 id="on"/>ʼʱ䣺</td></tr>').appendTo(starttable);
		var starttimediv = $('<div></div>');
		starttimediv.wrap($('<td></td>')).parent().appendTo(on);
		var timeConfig = {
			width : 150,
			allowBlank : false,
			format : "yyyy-MM-dd HH:mm:ss"
		};
		var starttime = starttimediv.asComponent("datetime", timeConfig);

		var recurrenceType = $('<p>ѭʽ</p>').appendTo(itriggerPane);
		var recurrenceRadios = $('<div><div>').appendTo(itriggerPane);
		var recurrencePane = $('<div></div>').appendTo(itriggerPane);

		var oncePane = oncePane().appendTo(recurrencePane).hide();
		var simplePane = simplePane().appendTo(recurrencePane).hide();
		var calendarPane = calendarPane().appendTo(recurrencePane).hide();
		
		var onceRadio = $('<input type="radio" name="recurrenceType" value="once" id="once">')
		.click(function(){
			oncePane.showPane();
		}).appendTo(recurrenceRadios);
		$('<span>ѭ</span>').appendTo(recurrenceRadios);
		var simpleRadio = $('<input type="radio" name="recurrenceType" value="simple" id="simple">')
		.click(function(){
			simplePane.showPane();
		}).appendTo(recurrenceRadios);
		$('<span>ѭ</span>').appendTo(recurrenceRadios);
		var calendarRadio = $('<input type="radio" name="recurrenceType" value="calendar" id="calendar">')
		.click(function(){
			calendarPane.showPane();
		}).appendTo(recurrenceRadios);
		$('<span>Զѭ</span>').appendTo(recurrenceRadios);

		function oncePane(){
			var oncePane = $("<div></div>");
			return oncePane;
		}//oncePane
		
		function simplePane(){
			var simplePane = $("<div></div>");
			var occurtable = $('<table></table>').appendTo(simplePane);
			var indifinitely = $('<tr><td>:</td><td><input type="radio" name="occur" value="indifinitely" id="indifinitely"/></td><td></td></tr>').appendTo(occurtable);
			var until =  $('<tr><td></td><td><input type="radio" name="occur" value="until" id="until"/></td></tr>').appendTo(occurtable);
			var untiltimediv = $('<div></div>');
			untiltimediv.wrap($('<td></td>')).parent().appendTo(until);
			var untiltime = untiltimediv.asComponent("datetime", timeConfig);
			var repeat =  $('<tr><td></td><td><input type="radio" name="occur" value="repeat" id="repeat"/></td><td><input id="repeatCount"/></td></tr>').appendTo(occurtable);
			var frequencetable = $('<table></table>').appendTo(simplePane);
			var frequencetr = $('<tr><td>Ƶʣÿ<input id="recurrenceInterval"/></td></tr>').appendTo(frequencetable);
			var frequencetypecombo = $('<div></div>');
			frequencetypecombo.wrap($('<td></td>')).parent().appendTo(frequencetr);
			var frequencetypeConfig = {
				editable : false,
				allowBlank : false,
				width: 50,
				mode: 'local',
				items: [{value: 1, text: ""},
						{value: 2, text: "Сʱ"},
						{value: 3, text: ""},
						{value: 4, text: ""}]
			};
			var frequencetype = frequencetypecombo.asComponent("combo", frequencetypeConfig);
			
			simplePane.populate = function(iTrigger){
				if(iTrigger.endTime){
					$('#until').attr('checked',true);
					untiltime.setValue(iTrigger.endTime);
					$('#repeatCount').attr('value','');
				}else if(!iTrigger.repeatCount || iTrigger.repeatCount == -1){
					$('#indifinitely').attr('checked',true);
					$('#repeatCount').attr('value','');
					untiltime.setValue("");
				}else {
					$('#repeat').attr('checked',true);
					$('#repeatCount').attr('value',iTrigger.repeatCount);
					untiltime.setValue("");
				}
				$('#recurrenceInterval').val((iTrigger.recurrenceInterval)? iTrigger.recurrenceInterval : 1);
				frequencetype.setValue((iTrigger.recurrenceIntervalUnit)? iTrigger.recurrenceIntervalUnit : 1);
			}
			simplePane.update = function(iTrigger){
				if($('input[@name="occur"][@checked]').val()== "indifinitely"){
					iTrigger.repeatCount = -1;
					delete iTrigger.endTime;
				}else if($('input[@name="occur"][@checked]').val()== "until"){
					iTrigger.endTime = untiltime.getValue();
					delete iTrigger.repeatCount;
				}else if($('input[@name="occur"][@checked]').val()== "repeat"){
					iTrigger.repeatCount = $('#repeatCount').val();
					delete iTrigger.endTime;
				}
				iTrigger.recurrenceInterval = $('#recurrenceInterval').val();
				iTrigger.recurrenceIntervalUnit = frequencetype.getValue();
			}
			simplePane.checkvalid = function(){
				if($('input[@name="occur"][@checked]').val()== "until"){
					var time = untiltime.getValue();
					if(!(/^(\d{4})-(0[1-9]|1[0-2])-(0[1-9]|[12]\d|3[01])\s([01]\d|2[0-3])(:[0-5]\d){2}$/).test(time)){
						itriggerPane.showPane();
						alert("ȷʽʱ䣺yyyy-MM-dd HH:mm:ss");
						return false;
					}
				}else if($('input[@name="occur"][@checked]').val()== "repeat"){
					var count = $('#repeatCount').val()
					if(!(/^\d+$/).test(count)){
						itriggerPane.showPane();
						$('#repeatCount').focus();
						alert("ȷд");
						return false;
					}
				}
				var interval = $('#recurrenceInterval').val();
				if(!(/^\d+$/).test(interval)){
					itriggerPane.showPane();
					$('#recurrenceInterval').focus();
					alert("ʱ");
					return false;
				}
				return true;
			}
			
			return simplePane;
		}//simplePane
		
		function calendarPane(){
			var calendarPane = $("<div></div>");
			var endtimediv = $('<div>ʱ䣺</div>').appendTo(calendarPane);
			var endtime = endtimediv.asComponent("datetime", timeConfig);
			var minutes = $('<div>ӣ<input id="minutes"/></div>').appendTo(calendarPane);
			var hours = $('<div>Сʱ<input id="hours"/></div>').appendTo(calendarPane);
			var daystable = $('<table></table>').appendTo(calendarPane);
			var everyday = $('<tr><td>죺</td><td><input type="radio" name="days" value=1 id="everyday"/></td><td>ÿ</td></tr>').appendTo(daystable);
			var weekdaystr1 = $('<tr><td></td><td valign="top"><input type="radio" name="days" value=2 id="weekday"/></td></tr>').appendTo(daystable);
			var weekdaystable = $('<table><tr><td>һ</td><td>ܶ</td><td></td><td></td><td></td><td></td><td></td></tr></table>');
			weekdaystable.wrap($('<td>ÿܵ</td>')).parent().appendTo(weekdaystr1);
			var weekdaystr2 = $('<tr></tr>').appendTo(weekdaystable);
			var weekdays = new Array(7);
			for(var i=0; i<weekdays.length; i++){
				weekdays[i] = $('<input type="checkbox"/>');
				weekdays[i].wrap($('<td></td>')).parent().appendTo(weekdaystr2);
			}
			var monthdays = $('<tr><td></td><td><input type="radio" name="days" value=3 id="monthday"/></td><td>ÿµ<input id="monthdays"/></td></tr>').appendTo(daystable);
			var monthstable = $('<table></table>').appendTo(calendarPane);
			var allmonthstr = $('<tr><td>£</td></tr>').appendTo(monthstable);
			var allmonths = $('<input type="checkbox"/>')
			.click(function(){
				if(this.checked){
					for(var i=0; i<months.length; i++){
						months[i][0].checked = true;
					}
				}
			});
			allmonths.appendTo($('<td><td>')).parent().appendTo(allmonthstr);
			$('<td></td>').appendTo(allmonthstr);
			var monthsnametr = $('<tr><td></td><td>һ</td><td></td><td></td><td></td><td></td><td></td>' +
					'<td></td><td></td><td></td><td>ʮ</td><td>ʮһ</td><td>ʮ</td></tr>').appendTo(monthstable);
			var monthstr = $('<tr><td></td></tr>').appendTo(monthstable);
			var months = new Array(12);
			for(var i=0; i<months.length; i++){
				months[i] = $('<input type="checkbox"/>')
				.click(function(){
					if(!this.checked){
						allmonths[0].checked = false;
					}
				});
				months[i].wrap($('<td></td>')).parent().appendTo(monthstr);
			}

			calendarPane.populate = function(iTrigger){
				endtime.setValue((iTrigger.endTime)? iTrigger.endTime : "");
				$('#minutes').val((iTrigger.minutes)? iTrigger.minutes : 0);
				$('#hours').val((iTrigger.hours)? iTrigger.hours : 0);
				if(!iTrigger.dayType || iTrigger.dayType == 1){
					$('#everyday').attr('checked',true);
					for(var i=0; i<weekdays.length; i++){
						weekdays[i][0].checked = false;
					}
					$('#monthdays').val("");
				}else if(iTrigger.dayType == 2){
					$('#weekday').attr('checked',true);
					var checkeddays = iTrigger.weekDays.split(",");
					for(var j=0; j<checkeddays.length; j++){
						for(var i=0; i<weekdays.length; i++){
							if(checkeddays[j] == i+1){
								weekdays[i][0].checked = true;
								break;
							}
						}
					}
					$('#monthdays').val("");
				}else if(iTrigger.dayType == 3){
					$('#monthday').attr('checked',true);
					for(var i=0; i<weekdays.length; i++){
						weekdays[i][0].checked = false;
					}
					$('#monthdays').val(iTrigger.monthDays);
				}
				if(iTrigger.months){
					var checkedmonths = iTrigger.months.split(",");
					allmonths[0].checked = (checkedmonths.length == months.length);
					for(var j=0; j<checkedmonths.length; j++){
						for(var i=0; i<months.length; i++){
							if(checkedmonths[j] == i+1){
								months[i][0].checked = true;
								break;
							}
						}
					}
				}else{
					allmonths[0].checked = false;
					for(var i=0; i<months.length; i++){
						months[i][0].checked = false;
					}
				}

			}
			calendarPane.update = function(iTrigger){
				iTrigger.endTime = endtime.getValue();
				iTrigger.minutes = $('#minutes').val();
				iTrigger.hours = $('#hours').val();
				iTrigger.dayType = $('input[@name="days"][@checked]').val();
				if($('input[@name="days"][@checked]').val()==2){
					var checkeddays = [];
					for(var i=0; i<weekdays.length; i++){
						if(weekdays[i][0].checked){
							checkeddays.push(i+1);
						}
					}
					iTrigger.weekDays = checkeddays.toString();
				}else if($('input[@name="days"][@checked]').val()==3){
					iTrigger.monthDays = $('#monthdays').val();
				}
				var checkedmonths = [];
				for(var i=0; i<months.length; i++){
					if(months[i][0].checked){
						checkedmonths.push(i+1);
					}
				}
				iTrigger.months = checkedmonths.toString();
			}
			calendarPane.checkvalid = function(){
				var time = endtime.getValue();
				if(!(/^(\d{4})-(0[1-9]|1[0-2])-(0[1-9]|[12]\d|3[01])\s([01]\d|2[0-3])(:[0-5]\d){2}$/).test(time)){
					itriggerPane.showPane();
					alert("ȷʽʱ䣺yyyy-MM-dd HH:mm:ss");
					return false;
				}
				var minutes = $('#minutes').val();
				if(!(/^((0)?\d|[1-5]\d)$/).test(minutes)){
					itriggerPane.showPane();
					$('#minutes').focus();
					alert("ִʱķ");
					return false;
				}
				var hours = $('#hours').val();
				if(!(/^((0)?\d|1\d|2[0-3])$/).test(hours)){
					itriggerPane.showPane();
					$('#hours').focus();
					alert("ִʱСʱ");
					return false;
				}
				if($('input[@name="days"][@checked]').val()==2){
					var daychecked = false;
					for(var i=0; i<weekdays.length; i++){
						if(weekdays[i][0].checked){
							daychecked = true;
							break;
						}
					}
					if(!daychecked){
						itriggerPane.showPane();
						alert("ѡ");
						return false;
					}
				}else if($('input[@name="days"][@checked]').val()==3){
					var days = $('#monthdays').val();
					if(!(/^((0)?[1-9]|[12]\d|3[01])(,((0)?[1-9]|[12]\d|3[01]))*$/).test(days)){
						itriggerPane.showPane();
						$('#monthdays').focus();
						alert("ȷʽ");
						return false;
					}
				}
				var monthchecked = false;
				for(var i=0; i<months.length; i++){
					if(months[i][0].checked){
						monthchecked = true;
						break;
					}
				}
				if(!monthchecked){
					itriggerPane.showPane();
					alert("ѡִ");
					return false;
				}
				return true;
			}
			
			return calendarPane;
		}//calendarPane
		
		itriggerPane.populate = function (iTrigger){
			if(iTrigger.startType && iTrigger.startType == 2){
				$('#on').attr('checked',true);
				if(iTrigger.startTime){
					starttime.setValue(iTrigger.startTime);
				}else{
					starttime.setValue("");
				}
			}else{
				$('#immediately').attr('checked',true);
				starttime.setValue("");
			}
			if(!iTrigger.recurrenceType || iTrigger.recurrenceType == "once"){
				$("#once").click();
				simplePane.populate({});
				calendarPane.populate({});
			}else if(iTrigger.recurrenceType == "simple"){
				$("#simple").click();
				simplePane.populate(iTrigger);
				calendarPane.populate({});
			}else if(iTrigger.recurrenceType == "calendar"){
				$("#calendar").click();
				calendarPane.populate(iTrigger);
				simplePane.populate({});
			}
		}
		itriggerPane.update = function(iTrigger){
			var d = new Date();
			var gmtHours = d.getTimezoneOffset()/60;
			iTrigger.timeZoneID = "Etc/GMT"+gmtHours;
			iTrigger.startType = $('input[@name="start"][@checked]').val();
			if($('input[@name="start"][@checked]').val()==2){
				iTrigger.startTime = starttime.getValue();
			}
			iTrigger.recurrenceType = $('input[@name="recurrenceType"][@checked]').val();
			if($('input[@name="recurrenceType"][@checked]').val() == "simple"){
				simplePane.update(iTrigger);
			}else if($('input[@name="recurrenceType"][@checked]').val() == "calendar"){
				calendarPane.update(iTrigger);
			}
		}
		itriggerPane.checkvalid = function (){
			if($('input[@name="start"][@checked]').val()==2){
				var time = starttime.getValue();
				if(!(/^(\d{4})-(0[1-9]|1[0-2])-(0[1-9]|[12]\d|3[01])\s([01]\d|2[0-3])(:[0-5]\d){2}$/).test(time)){
					itriggerPane.showPane();
					alert("ȷʽʱ䣺yyyy-MM-dd HH:mm:ss");
					return false;
				}
			}
			if($('input[@name="recurrenceType"][@checked]').val() == "simple"){
				return simplePane.checkvalid();
			}else if($('input[@name="recurrenceType"][@checked]').val() == "calendar"){
				return calendarPane.checkvalid();
			}
			return true;
		}
		var pastbutton = {
			text : "һ",
			handler : function(){
				basicPane.showPane();
			}
		}
		var nextbutton = {
			text : "һ",
			handler : function(){
				if(itriggerPane.checkvalid()){
					parameterPane.showPane();
				}
			}
		}
		return itriggerPane;
	}//itriggerPane
	
	function parameterPane(){
		var parameterPane = $("<div></div>");
		
		var parameters = [];
		
		var addbutton = {
			text : "",
			handler : function(){
				FR.showDialog("Ӳ",500,-1,SC.editParameterDialog(parameterPane,{},parameters,true));
			}
		}
		var delbutton = {
			text : "ɾ",
			handler : function(){
				var checked = false;
				for(var i=0;i<parameters.length;i++){
					if(parameters[i].checked){
						checked = true;
						break;
					}
				}
				if(!checked){
					return;
				}
				var confirm = window.confirm("ȷɾѡ");
				if(confirm){
					var newparameters = [];
					for(var i=0;i<parameters.length;i++){
						if(!(parameters[i].checked)){
							newparameters.push(parameters[i]);
						}
					}
					parameters = newparameters;
					parameterPane.loadParameter(parameters);
				}
			}
		}
		var generatebutton = {
			text : "ɲ",
			handler : function(){
				var groupId = processPane.report.id.substr(1);//ȥǰ
				$.get(
					"${scheduleServletURL}",
					{
					asyn : false,
					action: "genParameter",
					reportId: groupId
					},
					function callback(jasonA){
						parameters = JSON.parse(jasonA);
						parameterPane.loadParameter(parameters);
					}
				);
			}
		}
		SC.buttonTable([addbutton, delbutton, generatebutton]).appendTo(parameterPane);
		
		var parameterTable = $('<table></table>').addClass("table").appendTo(parameterPane);
		var tableHead = $('<thead><tr><th/><th></th><th></th><th>ֵ</th></tr></thead>').appendTo(parameterTable);
		parameterPane.tableBody = $('<tbody></tbody>').appendTo(parameterTable);

		parameterPane.populate = function(taskParameters){
			parameters = taskParameters;
			parameterPane.loadParameter(parameters);
		}
		parameterPane.update = function(){
			return parameters;
		}
		parameterPane.checkvalid = function(){
			return true;
		}

		var pastbutton = {
			text : "һ",
			handler : function(){
				itriggerPane.showPane();
			}
		}
		var nextbutton = {
			text : "һ",
			handler : function(){
				if(parameterPane.checkvalid()){
					outputPane.showPane();
				}
			}
		}
		return parameterPane;		
	}//parameterPane

	function outputPane(){
		var outputPane = $("<div>Ĳ</div>");
		
		var baseFileName = $('<p>ļ*</p><input id="baseFileName"/>').appendTo(outputPane);
		var description = $('<p>ļ</p><textarea id="description" cols="30" rows="3"></textarea>').appendTo(outputPane);
		var folderEntryId = 0;
		var folderEntryPane = folderEntryPane().appendTo(outputPane);
		var outputFileFormatPane = outputFileFormatPane().appendTo(outputPane);
		var isemail = $('<input id="isemail" type="checkbox"/input>')
		.click(function(){
			if(this.checked) {
				emailNotificationPane.show();
			}else {
				emailNotificationPane.hide();
			}
		}).appendTo($("<p>Ƿʼ֪ͨ</p>")).parent().appendTo(outputPane);
		var emailNotificationPane = emailNotificationPane().appendTo(outputPane);
		
		function folderEntryPane(){
			var folderEntryPane = $('<div><p>ļ·*</p></div>');
			var pathTable =$('<table></table>').appendTo(folderEntryPane);
			var pathTR = $('<tr></tr>').appendTo(pathTable);
			var treePane = $('<div></div>').addClass("tree").appendTo(folderEntryPane).hide();//
			var pathTD = $('<input id="outputPath" class="pathInput" readonly="true"/>').wrap($('<td></td>')).parent().appendTo(pathTR);
			var selectButton = $('<div></div>');
			selectButton.wrap($("<td></td>")).parent().appendTo(pathTR);
			selectButton.asComponent("button", {
				text: "ѡ",
				handler: function() {
					treePane.toggle();
				}//handler
			});
			folderEntryPane.populate = function(folderEntryId){
				var treedata = tree.getData();
				var o = {
					data: treedata,
					onlyfolder: true,
					onnodeclick: function(){
						var currentItem = treePane.getTCT();
						var path = treePane.getPath(currentItem);
						$("#outputPath").attr("value", path);
						folderEntryPane.folderEntryId = currentItem.id;
					}
				};
				treePane.empty().hide();
				treePane.treeview(o);
				folderEntryPane.folderEntryId = folderEntryId;
				if(folderEntryPane.folderEntryId){
					var node = treePane.getNode(folderEntryPane.folderEntryId);
					node.click();
				}else{
					$('#outputPath').attr("value", "");
				}
			}
			folderEntryPane.update = function(){
				return folderEntryPane.folderEntryId.substr(1);//ȥǰ
			}
			folderEntryPane.checkvalid = function(){
				if(!$("#outputPath").attr("value")){
					outputPane.showPane();
					$("#outputPath").focus();
					alert("ѡ񵼳ļ·");
					return false;
				}
				return true;
			}
			return folderEntryPane;
		}
		
		function outputFileFormatPane(){
			var outputFileFormatPane = $('<p>ļͣ*</p><div>' +
				'<input type="checkbox" id="isConvertToCpt">cpt' +
				'<input type="checkbox" id="isConvertToExcel">excel' +
				'<input type="checkbox" id="isConvertToPdf">pdf' +
				'<input type="checkbox" id="isConvertToWord">word' +
				'</div>');
			outputFileFormatPane.populate = function(outputFileFormat){
				$('#isConvertToCpt').attr("checked", (outputFileFormat.isConvertToCpt)? outputFileFormat.isConvertToCpt : false);
				$('#isConvertToExcel').attr("checked", (outputFileFormat.isConvertToExcel)? outputFileFormat.isConvertToExcel : false);
				$('#isConvertToPdf').attr("checked", (outputFileFormat.isConvertToPdf)? outputFileFormat.isConvertToPdf : false);
				$('#isConvertToWord').attr("checked", (outputFileFormat.isConvertToWord)? outputFileFormat.isConvertToWord : false);
			}
			outputFileFormatPane.update = function(outputFileFormat){
				outputFileFormat.isConvertToCpt = $('#isConvertToCpt').attr("checked");
				outputFileFormat.isConvertToExcel = $('#isConvertToExcel').attr("checked");
				outputFileFormat.isConvertToPdf = $('#isConvertToPdf').attr("checked");
				outputFileFormat.isConvertToWord = $('#isConvertToWord').attr("checked");
			}
			outputFileFormatPane.checkvalid = function(outputFileFormat){
				if(!($('#isConvertToCpt').attr("checked")||$('#isConvertToExcel').attr("checked")||$('#isConvertToPdf').attr("checked")||$('#isConvertToWord').attr("checked"))){
					outputPane.showPane();
					alert("ѡ񵼳ļ");
					return false;
				}
				return true;
			}
			return outputFileFormatPane;
		}//outputFileFormatPane
		
		function emailNotificationPane(){
			var emailNotificationPane = $("<div></div>");
			var toAddress = $('<p>ͣ*<input id="emailNotification_toAddress"/></p>').appendTo(emailNotificationPane);
			var ccAddress = $('<p>ͣ<input id="emailNotification_ccAddress"/></p>').appendTo(emailNotificationPane);
			var bccAddress = $('<p>ͣ<input id="emailNotification_bccAddress"/></p>').appendTo(emailNotificationPane);
			var subject = $('<p>⣺<input id="emailNotification_subject"/></p>').appendTo(emailNotificationPane);
			var bodyContent = $('<p>ݣ</p><textarea id="emailNotification_bodyContent" cols="30" rows="3"></textarea>').appendTo(emailNotificationPane);
			emailNotificationPane.populate = function(emailNotification){
				$("#emailNotification_toAddress").attr({value:(emailNotification.toAddress)? emailNotification.toAddress : ""});
				$("#emailNotification_ccAddress").attr({value:(emailNotification.ccAddress)? emailNotification.ccAddress : ""});
				$("#emailNotification_bccAddress").attr({value:(emailNotification.bccAddress)? emailNotification.bccAddress : ""});
				$("#emailNotification_subject").attr({value:(emailNotification.subject)? emailNotification.subject : ""});
				$("#emailNotification_bodyContent").attr({value:(emailNotification.bodyContent)? emailNotification.bodyContent : ""});
			}
			emailNotificationPane.update = function(emailNotification){
				emailNotification.toAddress = $("#emailNotification_toAddress").attr("value");
				emailNotification.ccAddress = $("#emailNotification_ccAddress").attr("value");
				emailNotification.bccAddress = $("#emailNotification_bccAddress").attr("value");
				emailNotification.subject = $("#emailNotification_subject").attr("value");
				emailNotification.bodyContent = $("#emailNotification_bodyContent").attr("value");
			}
			emailNotificationPane.checkvalid = function(){
				var emailString = $("#emailNotification_toAddress").attr("value");
				if(!((/^\w+((-\w+)|(\.\w+))*\@[A-Za-z0-9]+((\.|-)[A-Za-z0-9]+)*\.[A-Za-z0-9]+$/).test(emailString))){
					outputPane.showPane();
					$("#emailNotification_toAddress").focus();
					alert("ʼ͵ַϷ");
					return false;
				}
				return true;
			}
			return emailNotificationPane;
		}//emailNotificationPane
		
		outputPane.populate = function (scheduledOutput){
			$("#baseFileName").attr({value:(scheduledOutput.baseFileName)? scheduledOutput.baseFileName : ""});
			$("#description").attr({value:(scheduledOutput.description)? scheduledOutput.description : ""});
			folderEntryPane.populate(scheduledOutput.folderEntryId);			
			if(!scheduledOutput.outputFileFormat){
				scheduledOutput.outputFileFormat = {};
			}
			outputFileFormatPane.populate(scheduledOutput.outputFileFormat);
			if(!scheduledOutput.emailNotification || !(scheduledOutput.emailNotification.toAddress)){
				scheduledOutput.emailNotification = {};
				$('#isemail').attr("checked", false);
				emailNotificationPane.hide();
			}else {
				$('#isemail').attr("checked", true);
				emailNotificationPane.show();
			}
			emailNotificationPane.populate(scheduledOutput.emailNotification);
		}
		outputPane.update = function(scheduledOutput){
			scheduledOutput.baseFileName = $("#baseFileName").attr("value");
			scheduledOutput.description = $("#description").attr("value");
			scheduledOutput.folderEntryId = folderEntryPane.update();
			outputFileFormatPane.update(scheduledOutput.outputFileFormat);
			if($('#isemail').attr("checked")){
				emailNotificationPane.update(scheduledOutput.emailNotification);
			}else {
				delete scheduledOutput.emailNotification;
			}
		}
		outputPane.checkvalid = function(){
			if(!$("#baseFileName").attr("value")){
				outputPane.showPane();
				$("#baseFileName").focus();
				alert("뵼ļ");
				return false;
			}
			return folderEntryPane.checkvalid() && outputFileFormatPane.checkvalid()
				&& ($('#isemail').attr("checked")? emailNotificationPane.checkvalid() : true);
		}
		var pastbutton = {
			text : "һ",
			handler : function(){
				parameterPane.showPane();
			}
		}
		return outputPane;
	}//outputPane
	
	processPane.populate = function(report, task){
		if(task=="new"){
			task = {};
		}
		processPane.report = report;
		processPane.task = task;
		basicPane.populate(task);
		if(!task.iTrigger){
			task.iTrigger = {};
		}
		itriggerPane.populate(task.iTrigger);
		if(!task.taskParameters){
			task.taskParameters = [];
		}
		parameterPane.populate(task.taskParameters);
		if(!task.scheduledOutput){
			task.scheduledOutput = {};
		}
		outputPane.populate(task.scheduledOutput);
		basicPane.showPane();
	}
	processPane.update = function(task){
		basicPane.update(task);
		itriggerPane.update(task.iTrigger);
		task.taskParameters = parameterPane.update();
		outputPane.update(task.scheduledOutput);
	}
	processPane.checkvalid = function(){
		return basicPane.checkvalid() && itriggerPane.checkvalid()
		&& parameterPane.checkvalid() && outputPane.checkvalid();
	}

	return processPane;
}//createProcessPane

$.fn.createViewPane = function(){//չʾ
	var right = this;
	var viewPane = $('<div class="rightPane"></div>');
	var returnButton = {
		text: "",
		handler: function(){
			right.filePane.showPane();
		}
	}
	var buttonTable = SC.buttonTable([returnButton]).appendTo(viewPane);
	var viewFrame = $('<iframe name=viewFrame></iframe>').appendTo(viewPane);
	
	return viewPane;
}//createViewPane

})(jQuery);