/// <reference path="../intellisense/jquery-1.2.6-vsdoc-cn.js" />
/****************************************
author:xuanye.wan@gmail.com
***************************************/
(function($) {
    $.fn.swapClass = function(c1, c2) {
        return this.removeClass(c1).addClass(c2);
    }
    $.fn.treeview = function(settings) {
        var dfop =
            {
                method: "POST",
                datatype: "json",
                url: false,
                onnodeclick: null,
                data: null,
                clicktoggle: true, //ڵչӽڵ
                theme: "bbit-tree-lines" //bbit-tree-lines ,bbit-tree-no-lines,bbit-tree-arrows
            }

        $.extend(dfop, settings);
        if (!dfop.data) {
        	dfop.data = [];
        }
        var treenodes = dfop.data;
        var treenodespath = 0;
        var me = this;
        var id = me.attr("id");
        if (id == null || id == "") {
            id = "bbtree" + new Date().getTime();
            me.attr("id", id);
        }

        var html = [];

        buildtree(dfop.data, html);
        me.addClass("bbit-tree").html(html.join(""));
        InitEvent(me);
        html = null;

        function buildtree(data, ht) {
            ht.push("<div class='bbit-tree-bwrap'>"); // Wrap ;
            ht.push("<div class='bbit-tree-body'>"); // body ;
            ht.push("<ul class='bbit-tree-root ", dfop.theme, "'>"); //root
            if (data) {
            	treenodespath = data.length;
            	var l = getFolderNodesLength(data);
			    for (var i = 0; i < data.length; i++) {
			    	if (verifyNeedFolderNode(data[i])) {
			    		l--;
			        	buildnode(data[i], ht, 0, i, l == 0);
			        }
			    } 
            }
            ht.push("</ul>"); // root and;
            ht.push("</div>"); // body end;
            ht.push("</div>"); // Wrap end;
        }
        //endregion
        function buildnode(nd, ht, deep, path, isend) {
            ht.push("<li class='bbit-tree-node'>");
            ht.push("<div id='", id, "_", nd.id, "' tpath='", path, "' unselectable='on'");
            var cs = [];
            cs.push("bbit-tree-node-el");
            if (nd.hasChildren) {
                cs.push(nd.isexpand ? "bbit-tree-node-expanded" : "bbit-tree-node-collapsed");
            }
            else {
                cs.push("bbit-tree-node-leaf");
            }
            if (nd.classes) { cs.push(nd.classes); }

            ht.push(" class='", cs.join(" "), "'>");
            //span indent
            ht.push("<span class='bbit-tree-node-indent'>");
            if (deep == 1) {
                ht.push("<img class='bbit-tree-icon' src='${servletURL}?op=resource&resource=/com/fr/schedule/web/css/images/s.gif'/>");
            }
            else if (deep > 1) {
                ht.push("<img class='bbit-tree-icon' src='${servletURL}?op=resource&resource=/com/fr/schedule/web/css/images/s.gif'/>");
                for (var j = 1; j < deep; j++) {
                    ht.push("<img class='bbit-tree-elbow-line' src='${servletURL}?op=resource&resource=/com/fr/schedule/web/css/images/s.gif'/>");
                }
            }
            ht.push("</span>");
            //img
            cs.length = 0;
            if (nd.hasChildren) {
                if (nd.isexpand) {
                    cs.push(isend ? "bbit-tree-elbow-end-minus" : "bbit-tree-elbow-minus");
                }
                else {
                    cs.push(isend ? "bbit-tree-elbow-end-plus" : "bbit-tree-elbow-plus");
                }
            }
            else {
                cs.push(isend ? "bbit-tree-elbow-end" : "bbit-tree-elbow");
            }
            ht.push("<img class='bbit-tree-ec-icon ", cs.join(" "), "' src='${servletURL}?op=resource&resource=/com/fr/schedule/web/css/images/s.gif'/>");
            ht.push("<img class='bbit-tree-node-icon' src='${servletURL}?op=resource&resource=/com/fr/schedule/web/css/images/s.gif'/>");
            //a
            ht.push("<a hideFocus class='bbit-tree-node-anchor' tabIndex=1 href='javascript:void(0);'>");
            ht.push("<span unselectable='on'>", nd.text, "</span>");
            ht.push("</a>");
            ht.push("</div>");
            //Child
            if (nd.hasChildren) {
                if (nd.isexpand) {
                    ht.push("<ul  class='bbit-tree-node-ct'  style='z-index: 0; position: static; visibility: visible; top: auto; left: auto;'>");
                    if (nd.ChildNodes) {
		                var l = getFolderNodesLength(nd.ChildNodes);
		                deep++;
			            for (var i = 0; i < nd.ChildNodes.length; i++) {
			                	nd.ChildNodes[i].parent = nd;
			                	if (verifyNeedFolderNode(nd.ChildNodes[i])) {
			                		l--;
			                		buildnode(nd.ChildNodes[i], ht, deep, path + "." + i, l == 0);
			               	 	}
			           	}
                    }
                    ht.push("</ul>");
                }
                else {
                    ht.push("<ul style='display:none;'></ul>");
                }
            }
            ht.push("</li>");
            nd.render = true;
        }
        
        function filterData(data) {
        	if (dfop.onlyfolder) {
        		
        	} 
        }
        
        function getFolderNodesLength(data) {
        	 var filter = [];		
            //ֻļ folder.type == 0
            if (dfop.onlyfolder) {
            	$.each(data, function(i) {      
            		if (data[i].type == 0) {
            			filter.push(data[i]);
            		}
            	});           		
            } else {
            	filter = data;
            }
            return filter.length;
        }
        
        function verifyNeedFolderNode(data) {
        	if ((dfop.onlyfolder && data.type == 0) || !dfop.onlyfolder) {
        		return true;
        	} 
        	return false;
        }
        
        function getItem(path) {
            var ap = path.split(".");
            var t = treenodes;
            for (var i = 0; i < ap.length; i++) {
                if (i == 0) {
                    t = t[ap[i]];
                }
                else {
                    t = t.ChildNodes[ap[i]];
                }
            }
            return t;
        }
        
		function setCurrentItem(item) {
			if (dfop.citem) {
		        $("#" + id + "_" + dfop.citem.id).removeClass("bbit-tree-selected");
            }
            dfop.citem = item;
            if (item) {
            	$("#" + id + "_" + dfop.citem.id).addClass("bbit-tree-selected");
            	if (dfop.onnodeclick) {
	               dfop.onnodeclick.call();
	         	}
            }
		}
		
        function nodeclick(e) {
            var path = $(this).attr("tpath");
            var et = e.target || e.srcElement;
            var item = getItem(path);

            //debugger;
            if (et.tagName == "IMG") {
                // +Ҫչ
                if ($(et).hasClass("bbit-tree-elbow-plus") || $(et).hasClass("bbit-tree-elbow-end-plus")) {
                    var ul = $(this).next(); //"bbit-tree-node-ct"
                    if (ul.hasClass("bbit-tree-node-ct")) {
                        ul.show();
                    }
                    else {
                        var deep = path.split(".").length;
                        if (item.complete) {
                            item.ChildNodes != null && asnybuild(item.ChildNodes, deep, path, ul, item);
                        }
                        else {
                            $(this).addClass("bbit-tree-node-loading");
                            asnyloadc(ul, item, function(data) {
                                item.complete = true;
                                item.ChildNodes = data;
                                asnybuild(data, deep, path, ul, item);
                            });
                        }
                    }
                    if ($(et).hasClass("bbit-tree-elbow-plus")) {
                        $(et).swapClass("bbit-tree-elbow-plus", "bbit-tree-elbow-minus");
                    }
                    else {
                        $(et).swapClass("bbit-tree-elbow-end-plus", "bbit-tree-elbow-end-minus");
                    }
                    $(this).swapClass("bbit-tree-node-collapsed", "bbit-tree-node-expanded");
                }
                else if ($(et).hasClass("bbit-tree-elbow-minus") || $(et).hasClass("bbit-tree-elbow-end-minus")) {  //- Ҫ                    
                    $(this).next().hide();
                    if ($(et).hasClass("bbit-tree-elbow-minus")) {
                        $(et).swapClass("bbit-tree-elbow-minus", "bbit-tree-elbow-plus");
                    }
                    else {
                        $(et).swapClass("bbit-tree-elbow-end-minus", "bbit-tree-elbow-end-plus");
                    }
                    $(this).swapClass("bbit-tree-node-expanded", "bbit-tree-node-collapsed");
                }
            }
            else {
                setCurrentItem(item);
            }
        }
        
        function asnybuild(nodes, deep, path, ul, pnode) {
            var l = getFolderNodesLength(nodes);
            var ht = [];
            for (var i = 0; i < nodes.length; i++) {
                nodes[i].parent = pnode;
                if (verifyNeedFolderNode(nodes[i])) {
                	l--;
                	buildnode(nodes[i], ht, deep, path + "." + i, l == 0);
                }
            }
            ul.html(ht.join(""));
            ht = null;
            InitEvent(ul);
            ul.addClass("bbit-tree-node-ct").css({ "z-index": 0, position: "static", visibility: "visible", top: "auto", left: "auto", display: "" });
            ul.prev().removeClass("bbit-tree-node-loading");
        }
        
        function addRootNode(rt, ul) {
        	var html = [];
        	buildnode(rt, html, 0, treenodespath, true);
        	treenodespath++;
        	var root = $(html.join(""));
        	ul.append(root);
        	treenodes.push(rt);
            html = null;
            InitEvent(ul);
        }
        
        function asnyloadc(pul, pnode, callback) {
            if (dfop.url) {
                var param = builparam(pnode);
                $.ajax({
                    type: dfop.method,
                    url: dfop.url,
                    data: param,
                    dataType: dfop.datatype,
                    success: callback,
                    error: function(e) { alert("error occur!"); }
                });
            }
        }
        
        function builparam(node) {
            var p = [{ name: "id", value: encodeURIComponent(node.id) }
                    , { name: "text", value: encodeURIComponent(node.text) }
                    , { name: "value", value: encodeURIComponent(node.value) }];
            return p;
        }
        
        function InitEvent(parent) {
            var nodes = $("li.bbit-tree-node>div", parent);
            nodes.each(function(e) {
                $(this).hover(
					function() {
						$(this).addClass("bbit-tree-node-over");
					},
					function() {
						$(this).removeClass("bbit-tree-node-over");
					}
				)//hover
                .click(nodeclick);
            });
        }
        
       	function delItem(pitem,id) {//ɾһӽڵ
			var items = pitem.ChildNodes;
			for(var i=0;i<items.length;i++){
 		  		if(items[i].id == id){
//  		 			for(var j=i;j+1<items.length;j++){
//  		 				items[j]=items[j+1];
//  		 			}
//   					items.pop();
					items.splice(i, 1);
   					break;
      			}//if
 		  	}
		}
		
		function delRoot(node) {
			var rootDiv = $("div#" + id + "_" + node.id);
			setCurrentItem(undefined);
			treenodespath--;
			$.each(treenodes, function(i) {
				if (treenodes[i] == node) {
					treenodes.splice(i, 1);
					return false;
				}
			});
			if (rootDiv.length == 1) {
				rootDiv.parent("li").remove();
			} else {
				$.each(rootDiv, function(i) {
					if (rootDiv[i].parent().parent() == $(".bbit-tree-root")) {
						rootDiv[i].parent().remove();
					}
				});
			}
		}
		
        me[0].t = {
            getCurrentItem: function() {
                return dfop.citem;
            },
            
            addNode : function(pitem,item) {
            	if (!pitem) {
            		var ul = $(".bbit-tree-root");
            		addRootNode(item, ul);
            		return;
            	}
            	if(!pitem.ChildNodes){
            		pitem.ChildNodes = [];
            	}
            	pitem.ChildNodes.push(item);
            	var pnode = $("#" + id + "_" + pitem.id);
            	var path = pnode.attr("tpath");
            	var deep = path.split(".").length;
            	var ul = pnode.next();
            	asnybuild(pitem.ChildNodes, deep, path, ul, pitem);
            	pnode.click();
            },
            delNodes : function(pitem,ids) {
            	if (!ids) {
            		delRoot(pitem);
            		return;
            	}
            	for(var i=0;i<ids.length;i++){
            		delItem(pitem,ids[i]);
            	}
            	var pnode = $("#" + id + "_" + pitem.id);
            	var path = pnode.attr("tpath");
            	var deep = path.split(".").length;
            	var ul = pnode.next();
            	asnybuild(pitem.ChildNodes, deep, path, ul, pitem);
            	pnode.click();
            },
            getData : function() {
            	return dfop.data;
            },
            getNode : function(cid) {
            	var node = $("#" + id + "_" + cid);
            	return node;
            }
        };
        
        //b:Ĭѡеһڵ
        if (treenodes.length > 0) {
        	if (dfop.onlyfolder) {
            	$.each(treenodes, function(i) {      
            		if (treenodes[i].type == 0) {
            			setCurrentItem(treenodes[i]);
            			return false;
            		}
            	});           		
            } else {
            	setCurrentItem(treenodes[0]);
            }
        }
    }
//ȡѡеĽڵItem
    $.fn.getTCT = function() {
        if (this[0].t) {
            return this[0].t.getCurrentItem();
        }
        return null;
    }
	$.fn.addNode = function(pitem,item) {
		if (this[0].t) {
            this[0].t.addNode(pitem,item);
        }
	}
	$.fn.delNode = function(item) {
		if (this[0].t) {
			if (item.parent) {
				this[0].t.delNodes(item.parent,[item.id]);
			} else {
				this[0].t.delNodes(item);
			}
		}
	}
	$.fn.delNodes = function(pitem,ids) {
		if (this[0].t) {
			this[0].t.delNodes(pitem,ids);
		}
	}
	$.fn.getData = function() {
		if (this[0].t) {
			return this[0].t.getData();
		}
		return null;
	}
	$.fn.getNode = function(cid) {
		if (this[0].t) {
			return this[0].t.getNode(cid);
		}
		return null;
	}
	$.fn.getPath = function(item) {
		var path = "\/"+item.text;
		if(item.parent){
			path = this.getPath(item.parent) + path;
		}
		return path;
	}

})(jQuery);