FR.ADHOCCONFIG = {};
$(function() {	
	$.extend(FR.ADHOCCONFIG, {
		northContent : $('<div/>').addClass('adhoc_data_north'),
		
		centerContent : $('<div/>').addClass('adhoc_data_center'),
		
		_initNorth : function() {
			$.extend(this.northContent, {
				logoImg : function() {
					return $('<div/>').addClass('adhoc_data_logo').append($('<img/>').attr('src', "${servletURL}?op=resource&resource=/com/fr/web/adhoc/images/logo_title.png"));
				},
				
				viewDesign : function() {
					var self = this;
					var data = $('<li/>').addClass('adhoc_data_design_module').click(function(e) {
						self.dataFaceShow();
						self.embellishState().createDelegate(this);
					});
					var img = $('<img/>').addClass('adhoc_data_design_img').attr('src', '${servletURL}?op=resource&resource=/com/fr/web/adhoc/images/data_design.png');
					return data.append(img).append($('<span/>').addClass('adhoc_data_modulefont').text('Դ'));
				},
				
				defaultState : function() {
					this.vd.addClass('adhoc_module_selected');
//					this.dataFaceShow();
				},
				
				embellishState : function() {
					this.siblings.removeClass('adhoc_module_selected');
					this.addClass('adhoc_module_selected');
				},
				
				dataFaceShow : function() {
//					FR.ADHOCCONFIG.centerContent.dataFace.visible();
				},
				
				adhocModules : function() {
					this.vd = this.viewDesign();
					return $('<div/>').addClass('adhoc_data_module').append($('<ul/>').addClass('adhoc_data_moduleul').append(this.vd));
				},
				
				_init : function() {
					this.append(this.logoImg()).append(this.adhocModules());	
					this.defaultState();
				}
			});
			
			this.northContent._init();
		},
		
		_initCenter : function() {
			$.extend(this.centerContent, {
					dataFace : {
						_init : function() {
							this.content = $('<div/>').addClass('adhoc_data_design');
							this.ba = this.dataToolbar.getContent();
							this.nl = this.dataNameList.getContent();
							this.pf = this.propertiesFace.getContent();
						},
						
						getContent : function() {
							if (!this.content) {
								this._init();
							}
							return this.content;
						},
						
						borderPane : function() {
							var self = this;
							var content = this.content;
							content.asComponent("borderlayout", {items:[{
									region : 'north',
									el : self.ba
								},{
									region : 'west',
									el : self.nl
								}, {
									region : 'center',
									el : self.pf
								}]});
							content.doLayout();
							var oldresize = window.onresize;
							window.onresize = function() {
								oldresize();
								content.doLayout();
							};
						},
						
						dataToolbar : function() {
							var self = this;
							var bar = $('<div/>').addClass('adhoc_data_design_toolbar');
							var additems = [{
								src : 'SQLͼ',
								handler : function() {
									FR.ADHOCCONFIG.centerContent.dataFace.addSQLData();
								}
							}, {
								src : 'ݼ',
								handler : function() {
									FR.ADHOCCONFIG.centerContent.dataFace.addNamedData();
								}
							}];
							var addConfig = {
								img : '${servletURL}?op=resource&resource=/com/fr/web/adhoc/images/adhoc_data_add.png',
								text : '½',
								css : 'adhoc_data_add',
								action : function(e) {
									FR.showMenuByEvent({items: additems}, e||window.event, true);
								}
							};
							
							var editConfig = {
								img : '${servletURL}?op=resource&resource=/com/fr/web/adhoc/images/adhoc_data_edit.png',
								text : '༭',
								css : 'adhoc_data_edit',
								action : function(e) {
									FR.ADHOCCONFIG.centerContent.dataFace.editSelectedData();
								}
							};
								
							var deleteConfig = {
								img : '${servletURL}?op=resource&resource=/com/fr/web/adhoc/images/adhoc_data_delete.png',
								text : 'ɾ',
								css : 'adhoc_data_remove',
								action : function() {
									FR.ADHOCCONFIG.centerContent.dataFace.removeSelectedData();
								}
							};
							
							var addButton = $('<div/>');
							addButton.generateIconButton(addConfig);
							addButton.setEnable(true);
							
							var editButton = $('<div/>');
							editButton.generateIconButton(editConfig);
							
							var removeButton = $('<div/>');
							removeButton.generateIconButton(deleteConfig);
	
							return {					
								setButtonEnable : function(enable) {
									editButton.setEnable(enable);
									removeButton.setEnable(enable);
								},
								
								createButtonTable : function(buttons) {
									var tr = $('<tr/>');
									$.each(buttons, function(i) {
										tr.append($('<td/>').append(buttons[i]));
									});
									return $('<table/>').attr({'cellpadding': 0, 'cellspacing': 0}).addClass('adhoc_data_design_toolbar_buttons').append(tr);
								},
								
								getContent : function() {
									return bar.append(this.createButtonTable([addButton, editButton, removeButton]));
								}
							};
						}(),
					
					
					
						dataNameList : {
								_init : function() {
									this.content = $('<div/>').addClass('adhoc_design_list');
									config = {};
									config.data = [];
									config.onnodeclick  = function() {
										this.clickNode();
									}.createDelegate(this);
									config.operation = {};
									config.operation.addaction = function() {
										this.addaction();
									}.createDelegate(this);
									config.operation.deleteaction = function(item, newItem) {
										this.removeaction(item, newItem);
									}.createDelegate(this);
									config.operation.renameaction = function(item, newItem) {
										this.editaction(item, newItem);
									}.createDelegate(this);
									this.content.jlist(config);
									this.popuNames();
								},
								
								getContent : function() {
									if (!this.content) {
										this._init();
									}
									return this.content;
								},
								
								popuNames : function() {
									var self = this;
									$.ajax({
										url: '${servletURL}?op=adhoc_getdatanames',
										type: 'POST',
										complete : function(res, status) {
											try {
												var names = FR.jsonDecode(res.responseText);
												self.content.addItems(names);
											} catch(e) {
												
											}
										}
									});
								},
								
								popuData : function(name) {
									var data = {};
									$.ajax({
										url: '${servletURL}?op=adhoc_getdata',
										type: 'POST',
										data: {dataname: name},
										complete : function(res, status) {
											try {
												data = FR.jsonDecode(res.responseText);
												FR.ADHOCCONFIG.centerContent.dataFace.propertiesFace.popu(data);
											} catch(e) {
												
											}
										}
									});
									return data;
								},							
								
								clickNode : function() {	
									var item = this.content.getListItem();	
									if (!item) {
										return;
									}
									
									FR.ADHOCCONFIG.centerContent.dataFace.dataToolbar.setButtonEnable(true);							
									this.popuData(item); 						
								},
								
								addaction : function(item) {
									//may be seleteItem do here
								},
								
								addDialogContent : function(fix) {
									var dialogContent = $('<div/>').addClass('adhoc_dataset_addDialog');
									var sp = $('<span/>').addClass('adhoc_dataset_addDialog_title').text('Դƣ');
									var nameContent = $('<input/>').attr('type', 'text').addClass('adhoc_dataset_addDialog_text');
									sp.append(nameContent);
									
									var button = $('<div/>').addClass('adhoc_dataset_addDialog_submit');
									var bt = $('<div/>');
									dialogContent.append(sp);
									dialogContent.append(button.append(bt));
									
									var self = this;
									bt.asComponent('button', {
											text : 'ȷ',
											handler : function() {								
												self.addNN(nameContent.val(), fix);
												FR.closeDialog();
											}
										});

									return dialogContent;
								},	
								
								
								
								addNN : function(name, fix) {
									if (!name) {
										return;
									}
									if (this.content.hasSameName(name)) {
										var i = 0;
										while(this.content.hasSameName(name + i)) {
											i++;
										}
									}

									var node = {text: name};
									var type = 0;
									if (fix == 'sql') {
										type = 1;
									}

									this.createEmptyNode(node, type);
									this.addNode(node, name);	
								},
								
								addNewNode : function(fix) {
									FR.showDialog("Դ", 270, 120, this.addDialogContent (fix));								
								},	
								
								createEmptyNode : function(data, type) {
									data.type = type;
								},
								
								addNode : function(data, name) {
									var self = this;
									$.ajax({
										url: '${servletURL}?op=adhoc_adddata',
										type: 'POST',
										data : {namedata: FR.cjkEncode(FR.jsonEncode(data))},
										complete : function(res, status) {
											self.content.addListItem(name);
										}
									});
								},							
								
								removeNode : function() {
									var confirm = window.confirm("ȷɾ");
									if (confirm) {
										this.content.removeListItem();
									}	
								},			
								
								removeaction : function(item, newItem) {
									this.removeData(item);
									if (!newItem) {
										FR.ADHOCCONFIG.centerContent.dataFace.dataToolbar.setButtonEnable(false);
										FR.ADHOCCONFIG.centerContent.dataFace.propertiesFace.showInforFace();
									} else {
										this.popuData(newItem);
									}									
								},
								
								removeData : function(name) {
									$.ajax({
										url: '${servletURL}?op=adhoc_removedata',
										type: 'POST',
										data : {dataname: name},
										complete : function(res, status) {
											
										}
									});
								},
								
								editNode : function() {
									this.content.editListItem();
								},
								
								editaction : function(name, oldname) {								
									FR.ADHOCCONFIG.centerContent.dataFace.propertiesFace.popu(this.editData(name, oldname));
								},
								
								editData : function(name, on) {
									var data = {};
									$.ajax({
										url: '${servletURL}?op=adhoc_editdata',
										type: 'POST',
										data: {oldname: on, newname: name},
										async : false,
										complete : function(res, status) {
											try {
												data = FR.jsonDecode(res.responseText);
											} catch(e) {
												
											}
										}
									});
									
									return data;
								}
						},
						
						propertiesFace : {
							_init : function() {
								this.content = $('<div/>').addClass('adhoc_design_face');
								this.content.append(this.basicInforFace.getContent());
								this.content.append(this.dataPane.getContent());	
								this.dataPane.unvisible();														
							},
							
							getContent : function() {
								if (!this.content) {
									this._init();
								}
								return this.content;
							},
							
							basicInforFace : {
								_init : function() {
									this.content = $('<div/>').addClass('adhoc_design_introduce');
									this.generateInforFace();
								},
								
								getContent : function() {
									if (!this.content) {
										this._init();				
									}
									return this.content;
								},
								
								generateInforFace : function() {
									var info = this.getIntro();
									this.content.append($('<p/>').addClass('adhoc_design_intro_title').text(info.title));
									var ul = $('<ul/>').addClass('adhoc_design_intro_ul');
									$.each(info.description, function(i) {
										var li = $('<li/>').addClass('adhoc_design_intro_li').append($('<p/>').text(info.description[i]));
										ul.append(li);
									});
									this.content.append(ul);
								},
																
								getIntro : function() {
									var infor = {};
									infor.title = 'ڴҳʹӡ༭ɾüϯõԴ';
									infor.description = [];
									infor.description.push("ϯԴʱΪ࣬һͨ" +
											"ѡӺдSQLԴһֱʹǵķݼ");
									infor.description.push("ÿԶԼϯԴֶ滻Ӷûݡ");
									infor.description.push("дûƼϯʱݵ;");
									
									return infor;
								},
								
								visible : function() {
									this.content.show();
								},
								
								unvisible : function() {
									this.content.hide();
								}
							},
							
							dataPane : {
									_init : function() {
										this.content = $('<div>').addClass('adhoc_design_dataPane');
										this.title = $('<p/>').addClass('adhoc_design_dataPane_title');
										this.content.append(this.title);
										this.content.append(this.generateBasicTable());
										this.content.append(this.generatePropertiesTable());
										this.content.append(this.generateSubmitButton());
									},
									
									generateSubmitButton : function() {
										this.submitButton = $('<div/>').addClass('adhoc_design_dataPane_submitButton');
										
										var container =  $('<div/>').addClass('adhoc_design_dataPane_submitButton_container').append(this.submitButton);
										var self = this;
										this.submitButton.asComponent('button', {
											text : '',
											handler : function() {
												var data = FR.ADHOCCONFIG.centerContent.dataFace.propertiesFace.createADHOCData();
												self.addData(data);
											}
										});
										return container;				
									},
									
									addData : function(data) {
										$.ajax({
											url : '${servletURL}?op=adhoc_adddata',
											type : 'POST',
											data : {namedata: FR.cjkEncode(FR.jsonEncode(data))},
											complete : function(res, status) {
												if (res.responseText == 'success') {
													FR.Msg.alert(FR.i18n.Info, "ύɹ");
												} else {
													FR.Msg.alert(FR.i18n.Info, "ύʧܣ");
												}
											}
										});
									},
									
									generateBasicTable : function() {
										var table = $('<table/>').addClass('adhoc_design_dataPane_table');
										this.viewName = $('<input/>').addClass('adhoc_design_dataPane_name').attr('readonly', 'true');
										this.description = $('<textarea/>').addClass('adhoc_design_dataPane_descrip').attr({cols : '40', rows : '5'});
										table.append(this.generateNameTR()).append(this.generateDesTR());
										return table;
									},
									
									generateNameTR : function() {
										var tr = $('<tr/>').addClass('adhoc_design_dataPane_table_nametr');
										var ntd = $('<td/>').addClass('adhoc_design_dataPane_table_nametd').text('Դ');
										var vtd = $('<td/>').append(this.viewName);
										return tr.append(ntd).append(vtd);
									},
									
									generateDesTR : function() {
										var tr = $('<tr/>').addClass('adhoc_design_dataPane_table_descriptd');
										var ntd = $('<td/>').addClass('adhoc_design_dataPane_table_nametr').text('Դ');
										var dtd =$('<td/>').append(this.description);
										return tr.append(ntd).append(dtd);
									},
									
									generatePropertiesTable : function() {										
										var face = FR.ADHOCCONFIG.centerContent.dataFace.propertiesFace;
										var table = $('<table/>').addClass('adhoc_design_dataPane_propertiestable');
										var tr = $('<tr/>').addClass('adhoc_design_dataPane_propertiestable_tr');
										var dataTD = $('<td/>').addClass('adhoc_design_dataPane_propertiestable_datatd')
											.append(face.sqlFace.getContent()).append(face.namedFace.getContent());
										var semanTD = $('<td/>').addClass('adhoc_design_dataPane_propertiestable_semantd')
											.append(face.semantic.getContent());
										tr.append(dataTD).append(semanTD);
										return table.append(tr);
									},
									
									setName : function(name) {
										this.viewName.val(name);
									},
									
									getName : function() {
										return this.viewName.val();
									},
									
									setDes : function(des) {
										this.description.val(des);
									},
									
									getDes : function() {
										return this.description.val();
									},
									
									getContent : function() {
										if (!this.content) {
											this._init();
										}
										return this.content;
									},
									
									visible : function() {
										this.content.show();
									},
									
									unvisible : function() {
										this.content.hide();
									},
									
									setTitle : function(value) {
										this.title.val(value);
									}
							},
							
							semantic : {
								_init : function() {
									this.content = $('<div/>').addClass('adhoc_design_semantic');
									var table = $('<table/>').addClass('adhoc_design_semantic_table');
									table.append(this.generateTitleTR());
									table.append(this.generateDataLinkTR());
									table.append(this.generateTableTR());
									table.append(this.generateOTR());
									table.append(this.generateETR());
									this.content.append(table);
								},
								
								generateTitleTR : function() {
									return $('<tr/>').append($('<td colspan="2"></td>').addClass('adhoc_design_semantic_title'));
								},
								
								generateDataLinkTR : function() {
									var tr = $('<tr/>');
									var std = $('<td/>').addClass('adhoc_design_semantic_font').text(':');
									var link = $('<div/>').addClass('adhoc_design_semantic_link');
									var itd = $('<td/>').append(link);
									var listener = {};
									var self = this;
									listener.eventName = FR.Events.AFTEREDIT;
									listener.action = function() {
										self.changeTableComboSource();
									};
									
									var config = {
										editable : false,
										allowBlank : true,
										mode: 'remote',
										widgetUrl : '${servletURL}?op=adhoc_getdatasourcenames',
										listeners : [listener]
									};
									this.linkCombo = link.asComponent('combo', config);
									return tr.append(std).append(itd);
								},
								
								changeTableComboSource : function() {
									if (!this.linkCombo || !this.tableNameCombo) {
										return;
									}
									if (!this.linkCombo.getValue()) {
										return;
									}
									this.tableNameCombo.options.mode = 'remote';
									this.tableNameCombo.options.widgetUrl = '${servletURL}?op=adhoc_gettablenames&datalink=' + this.linkCombo.getValue();
								},
								
								generateTableTR : function() {
									var tr = $('<tr/>');
									var std = $('<td/>').addClass('adhoc_design_semantic_font').text(':');
									var tn = $('<div/>').addClass('adhoc_design_semantic_tablename');
									var ttd = $('<td/>').append(tn);
									var config = {
										editable : false,
										allowBlank : true,
										mode: 'remote',
										widgetUrl : '${servletURL}?op=adhoc_gettablenames'
									};
									this.tableNameCombo = tn.asComponent('combo', config);
									return tr.append(std).append(ttd);
								},
								
								generateOTR : function() {
									var tr = $('<tr/>');
									var std= $('<td/>').addClass('adhoc_design_semantic_font').text('ԭֶΣУ:');
									var otext = $('<div/>').addClass('adhoc_design_semantic_otext');
									var otd = $('<td/>').append(otext);
									var config = {
										allowDecimals : false,
           								allowNegative : false
           							};
									this.oinput = otext.asComponent('number', config);
									return tr.append(std).append(otd);
								},
								
								generateETR : function() {
									var tr = $('<tr/>');
									var std= $('<td/>').addClass('adhoc_design_semantic_font').text('תֶΣУ:');
									var etext = $('<div/>').addClass('adhoc_design_semantic_etext');
									var etd = $('<td/>').append(etext);
									var config = {
										allowDecimals : false,
           								allowNegative : false
           							};
									this.einput = etext.asComponent('number', config);
									return tr.append(std).append(etd);
								},
								
								getContent : function() {
									if (!this.content) {
										this._init();
									}
									return this.content;
								},
								
								popu : function(data) {
									if (!data.semantic) {
										this.cleanState();
										return;
									}
									this.oinput.setValue(data.semantic.keyIndex);
									this.einput.setValue(data.semantic.valueIndex);
									this.linkCombo.setValue(data.semantic.databaseName);
									this.tableNameCombo.setValue(data.semantic.tableName);
									if (data.semantic.databaseName) {
										this.tableNameCombo.options.widgetUrl = '${servletURL}?op=adhoc_getdatanames&datalink=' + data.semantic.databaseName;
									}
								},
								
								cleanState : function() {
									this.oinput.setValue('');
									this.einput.setValue('');
									this.linkCombo.setValue('');
									this.tableNameCombo.setValue('');
								},
								
								getSemantic : function() {
									var semantic = {};
									semantic.databaseName = this.linkCombo.getValue();
									semantic.tableName = this.tableNameCombo.getValue();
									semantic.keyIndex = this.oinput.getValue();
									semantic.valueIndex = this.einput.getValue();
									if (semantic.databaseName != null 
										&& semantic.tableName != null
										&& semantic.keyIndex != null
										&& semantic.valueIndex != null
										&& semantic.databaseName != "" 
										&& semantic.tableName != ""
										&& semantic.keyIndex != ""
										&& semantic.valueIndex != "") {
										return semantic;
									} else {
										return;
									}									
								}
							},

							sqlFace : {
								_init : function() {
									this.content = $('<div/>').addClass('adhoc_design_sqlface');
									this.content.append(this.generateTable());
								},
								
								generateTable : function() {
									var table = $('<table/>').addClass('adhoc_design_sqlface_table');
									table.append(this.generateDataLinkTR());
									table.append(this.generateSQLTR());
									return table;
								},
								
								generateDataLinkTR : function() {
									var tr = $('<tr/>');
									var std = $('<td/>').addClass('adhoc_design_sqlface_font').text(':');
									var link = $('<div/>').addClass('adhoc_design_sqlface_link');
									var itd = $('<td/>').append(link);
									
									var config = {
										editable : false,
										allowBlank : true,
										mode: 'remote',
										widgetUrl : '${servletURL}?op=adhoc_getdatasourcenames'
									};
									this.linkCombo = link.asComponent('combo', config);
									return tr.append(std).append(itd);
								},
								
								generateSQLTR : function() {
									var tr = $('<tr/>');
									var std = $('<td/>').addClass('adhoc_sqlface_font').text('SQL:');
									this.sql = $('<textarea/>').addClass('adhoc_design_sqlface_').attr({cols : '36', rows : '5'});
									var sqltd = $('<td/>').append(this.sql);

									return tr.append(std).append(sqltd);
								},
								
								getContent : function() {
									if (!this.content) {
										this._init();
									}
									this.unvisible();
									return this.content;
								},
								
								isvisible : function() {
									return this.isshow;
								},
								
								visible : function() {
									this.isshow = true;
									this.content.show();
								},
																						
								unvisible : function() {
									this.isshow = false;
									this.content.hide();
								},
								
								getSQL : function() {
									return this.sql.val();
								},
								
								getConnectionName : function() {
									return this.linkCombo.getValue();
								},
								
								popuData : function(data) {
									this.linkCombo.setValue(data.dbConnectionName ? data.dbConnectionName : '');
									this.sql.val(data.query ? data.query : '');
								}
							},
							
							namedFace : {
								_init : function() {
									this.content = $('<div/>').addClass('adhoc_design_namedface');
									this.content.append($('<table/>').addClass('adhoc_design_namedface_table').append(this.generateDataLinkTR()));
								},
								
								generateDataLinkTR : function() {
									var tr = $('<tr/>');
									var std = $('<td/>').addClass('adhoc_design_namedface_font').text('ѡݼ:');
									var link = $('<div/>').addClass('adhoc_design_namedface_link');
									var itd = $('<td/>').append(link);
									
									var config = {
										editable : false,
										allowBlank : true,
										mode: 'remote',
										widgetUrl : '${servletURL}?op=adhoc_gettabledatanames'
									};
									
									this.linkCombo = link.asComponent('combo', config);
									return tr.append(std).append(itd);
								},
								
								getContent : function() {
									if (!this.content) {
										this._init();
									}
									this.unvisible();
									return this.content;
								},
								
								isvisible : function() {
									return this.isshow;
								},
								
								visible : function() {
									this.isshow = true;
									this.content.show();
								},
																						
								unvisible : function() {
									this.isshow = false;
									this.content.hide();
								},
								
								getTableDataName : function() {
									return this.linkCombo.getValue();
								},
								
								popuData : function(data) {
									this.linkCombo.setValue(data.dbTableDataName ? data.dbTableDataName : '');
								}
							},
																					
							popu : function(data) {
								if (!data) {
									this.showInforFace();
									return;									
								}
								this.showDesignFace();
								this.setViewName(data.text);
								this.setDescription(data.description ? data.description : '');
								this.setTitleInfo(data.type);
								if (data.type == 0) {
									this.namedFace.visible();
									this.namedFace.popuData(data);
									this.sqlFace.unvisible();									
								} else if (data.type == 1) {
									this.namedFace.unvisible();
									this.sqlFace.visible();
									this.sqlFace.popuData(data);
								}
								this.semantic.popu(data);
							},
							
							setTitleInfo : function(type) {
								if (type == 1) {
									this.dataPane.setTitle('SQLԴ');
								} else if (type == 0) {
									this.dataPane.setTitle('ݼԴ');
								}
							},
														
							setViewName : function(name) {
								this.dataPane.setName(name);
							},
							
							setDescription : function(description) {
								this.dataPane.setDes(description);
							},
							
							createADHOCData : function() {
								var data = {};
								data.description = this.dataPane.getDes();
								data.text = this.dataPane.getName();
								if (this.semantic.getSemantic() != null) {
									data.semantic = this.semantic.getSemantic();
								}
								
								if (this.sqlFace.isvisible()) {
									data.type = 1;
									data.query = this.sqlFace.getSQL();
									data.dbConnectionName = this.sqlFace.getConnectionName();
								} else if (this.namedFace.isvisible()) {
									data.type = 0;
									data.dbTableDataName = this.namedFace.getTableDataName();
								}
								return data;
							},
							
							showInforFace : function() {
								this.basicInforFace.visible();
								this.dataPane.unvisible();
							},
							
							showDesignFace : function() {
								this.basicInforFace.unvisible();
								this.dataPane.visible();
							}
							
						},
						
						addSQLData : function(config) {
							this.dataNameList.addNewNode('sql');
						},
						
						addNamedData : function(config) {
							this.dataNameList.addNewNode('sever');
						},
						
						editSelectedData : function() {
							this.dataNameList.editNode();
						},
						
						removeSelectedData : function() {
							this.dataNameList.removeNode();
						},
										
						visible : function() {
							this.content.show();
						}
				}
			});
			//b:ԺģҪ
			this.centerContent.append(this.centerContent.dataFace.getContent());
			//b:borderlayout
			this.centerContent.dataFace.borderPane();
		},
		
		_init : function() {			
			this._initNorth();
			var content = $("body").append(this.northContent).append(this.centerContent);
			content.asComponent("borderlayout", {items: [
				{
					region : 'north',
					el : this.northContent
				}, 
				{
					region : 'center',
					el : this.centerContent
				}]});	
			content.doLayout();

			window.onresize = function() {
				content.doLayout();
			};
			this._initCenter();
		}
	});	
});