FR.ADHOCDESIGN = {};
$(function() {
	$.extend(FR.ADHOCDESIGN, {
		_init : function() {
			FR.ADHOCDESIGN.initNorth();
		
			FR.ADHOCDESIGN.initCenter();
			
			var content = $('body');
			
			content.asComponent('borderlayout', {items:[{
					region : 'north',
					el : FR.ADHOCDESIGN.northDesign
				},{
					region : 'west',
					el : FR.ADHOCDESIGN.centerDesign.designSteps.getContent()
				}, {
					region : 'center',
					el : FR.ADHOCDESIGN.centerDesign.designFaces.getContent()
				}]});
			content.doLayout();
						
			window.onresize = function() {
				content.doLayout();
			};
		},
		
		northDesign : $('<div/>').addClass('adhoc_design_north'),
		
		initNorth : function() {			
			var logoImg = $('<div/>').addClass('adhoc_data_logo').append($('<img/>').attr('src', "${servletURL}?op=resource&resource=/com/fr/web/adhoc/images/logo_title.png"));
			this.northDesign.append(logoImg);
		},
		
		centerDesign : $('<div/>').addClass('adhoc_design_center'),
		
		initCenter : function() {
			$.extend(this.centerDesign, {
				designSteps : {
					_init : function() {
						this.content = $('<div/>').addClass('adhoc_design_steps');
						this.content.append(this.createButtonTable());
					},
					
					getContent : function() {
						if (!this.content) {
							this._init();
						}
						return this.content;
					},
					
					createStepData : function() {
						var data = [];
						var self = this;
						var cs = 'addhoc_design_step_button';
						var chooseDataConfig = {text:'ѡԴ', 
							css:cs,
							img : '${servletURL}?op=resource&resource=/com/fr/web/adhoc/images/adhoc_design_chooseview.png',
							action : function() {								
								FR.ADHOCDESIGN.centerDesign.designFaces.defaultState();
								FR.ADHOCDESIGN.centerDesign.designFaces.viewDataFace.visible();
								self.embellishButton(this);
							}.createDelegate(self.buttons[0])};
						data.push(chooseDataConfig);
						
						var filterDataConfig = {text:'Դ', 
							css:cs,
							img : '${servletURL}?op=resource&resource=/com/fr/web/adhoc/images/adhoc_design_filterdata.png',
							action : function() {								
								FR.ADHOCDESIGN.centerDesign.designFaces.defaultState();
								FR.ADHOCDESIGN.centerDesign.designFaces.filterDataFace.visible();
								self.embellishButton(this);
							}.createDelegate(self.buttons[1])};
						data.push(filterDataConfig);
						
						var defineReportConfig = {text:'屨',
							css: cs,
							img : '${servletURL}?op=resource&resource=/com/fr/web/adhoc/images/adhoc_design_definereport.png',
							action : function() {								
								FR.ADHOCDESIGN.centerDesign.designFaces.defaultState();

								FR.ADHOCDESIGN.centerDesign.designFaces.defineReportFace.visible();
								self.embellishButton(this);
							}.createDelegate(self.buttons[2])};
						data.push(defineReportConfig);
						
						
						var chooseStyleConfig = {text:'ѡʽ', 
							css: cs,
							img : '${servletURL}?op=resource&resource=/com/fr/web/adhoc/images/adhoc_design_choosestyle.png',				
							action : function() {
								FR.ADHOCDESIGN.centerDesign.designFaces.defaultState();
								FR.ADHOCDESIGN.centerDesign.designFaces.chooseStyleFace.visible();
								self.embellishButton(this);
							}.createDelegate(self.buttons[3])};
						data.push(chooseStyleConfig);
						
						var viewReportConfig = {text:'Ԥ', 
							css: cs,
							img : '${servletURL}?op=resource&resource=/com/fr/web/adhoc/images/adhoc_design_viewreport.png',
							action : function() {
								FR.ADHOCDESIGN.centerDesign.designFaces.defaultState();
								if (FR.ADHOCDESIGN.centerDesign.designFaces.viewReportFace.showReport()) {
									self.embellishButton(this);
								}								
							}.createDelegate(self.buttons[4])};
						data.push(viewReportConfig);
						
						return data;
					},
					
					embellishButton : function(button) {
						for(var i = 0, len = this.buttons.length; i < len; i++) {
							this.buttons[i].removeClass('adhoc_designstep_selected');
						}
						button.addClass('adhoc_designstep_selected');
					},
					
					embellishSelfButton : function(index) {
						this.embellishButton(this.buttons[index]);
					},
					
					createButtons : function() {
						this.buttons = [];
						for (var i = 0, len = 5; i < len; i++) {
							this.buttons.push($('<div/>'));
						}
						var data = this.createStepData();
						for (var i = 0, len = data.length; i < len; i++) {
							this.buttons[i].generateIconButton(data[i]);
							this.buttons[i].setEnable(true);
						}
						return this.buttons;
					},
					
					createButtonTable : function() {
						var table = $('<table/>').addClass('adhoc_design_steps_table');
						var buttons = this.createButtons();
						$.each(buttons, function(i) {
							var td = $('<td/>').addClass('adhoc_design_steps_td').append(buttons[i]);
							table.append($('<tr/>').append(td));
							if (i < buttons.length - 1) {
								table.append($('<tr/>').append($('<td/>').addClass('adhoc_design_steps_blanktr')));
							}
						});
						return table;
					}
				},
				
				designFaces : {
					_init : function() {
						this.content = $('<div/>').addClass('adhoc_designfaces');
						this.content.append(this.viewDataFace.getContent());
						this.content.append(this.filterDataFace.getContent());
						this.content.append(this.defineReportFace.getContent());
						this.content.append(this.chooseStyleFace.getContent());
						this.content.append(this.viewReportFace.getContent());
						this.content.append(this.basicInforFace.getContent());
						this.defaultState();
						this.basicInforFace.visible();
					},
					
					getContent : function() {
						if (!this.content) {
							this._init();
						}
						return this.content;
					},
					
					defaultState : function() {
						this.basicInforFace.invisible();
						this.viewDataFace.invisible();
						this.filterDataFace.invisible();
						this.defineReportFace.invisible();
						this.chooseStyleFace.invisible();
						this.viewReportFace.invisible();
					},
					
					basicInforFace : {
								_init : function() {
									this.content = $('<div/>').addClass('adhoc_design_introduceface');
									this.generateInforFace();
								},
								
								getContent : function() {
									if (!this.content) {
										this._init();				
									}
									return this.content;
								},
								
								generateInforFace : function() {
									var info = this.getIntro();
									this.content.append($('<p/>').addClass('adhoc_design_intro_title').text(info.title));
									var ul = $('<ul/>').addClass('adhoc_design_intro_ul');
									$.each(info.description, function(i) {
										var li = $('<li/>').addClass('adhoc_design_intro_li').append($('<p/>').text(info.description[i]));
										ul.append(li);
									});
									this.content.append(ul);
								},
																
								getIntro : function() {
									var infor = {};
									infor.title = 'ӭʹüϯͨ򵥵ѡҪݻϡ';
									infor.description = [];
									infor.description.push("ѡͼѡԭʼݡ");
									infor.description.push("ݹ˿Զݽгɸѡ");
									infor.description.push("屨ṩ򵥱ͽ汨ͣѡӦýмüɡ");
									infor.description.push("ѡʽѡ񱨱չʽ");
									infor.description.push("鿴Ĺǡʱ鿴ɵõҪĽ");
									return infor;
								},
								
								visible : function() {
									this.content.show();
								},
								
								invisible : function() {
									this.content.hide();
								}
							},
					
					viewDataFace : {
						_init : function() {
							this.content = $('<div/>').addClass('adhoc_design_viewdata');
							this.content.append(this.listFace.getContent());
							this.content.append(this.dataIntroFace.getContent());
						},
						
						getContent : function() {
							if (!this.content) {
								this._init();
							}
							return this.content;
						},
						
						getViewName : function() {
							return this.listFace.getSelectedName();
						},
						
						checkValid : function() {
							if (this.getViewName() != null) {
								return true;
							}
							FR.ADHOCDESIGN.centerDesign.designSteps.embellishSelfButton(0);
							this.visible();
							FR.Msg.alert(FR.i18n.Info, "ѡͼΪԴ");
														
							return false;
						},
												
						listFace : {
								_init : function() {
									this.content = $('<div/>').addClass('adhoc_design_viewdata_list');
									config = {};
									config.data = this.getNames();
									config.title = "ѡԴ";
									config.titleClass = 'adhoc_design_viewreport_listtitle'
									var self = this;
									config.onnodeclick  = function() {
										self.clickNode();
									};
	
								 	this.content.jlist(config);	
								},
									
								getContent : function() {
									if (!this.content) {
										this._init();
									}
									return this.content;
								},
								
								getSelectedName : function() {
									return this.content.getListItem();
								}, 
									
								getNames : function() {
									var names = [];
									$.ajax({
										url: '${servletURL}?op=adhoc_getdatanames',
										type: 'POST',
										async : false,
										complete : function(res, status) {
											try {
												names = FR.jsonDecode(res.responseText);
											} catch(e) {
													
											}
										}
									});
									return names;
								},
								
								getData : function(name) {
									var data = {};
									$.ajax({
										url: '${servletURL}?op=adhoc_getdetail',
										type: 'POST',
										async : false,
										data: {dataname: name},
										complete : function(res, status) {
											try {
												data = FR.jsonDecode(res.responseText);
											} catch(e) {
												
											}
										}
									});
									return data;
								},
									
								clickNode : function(item) {	
									var item = 	this.getSelectedName();							
									FR.ADHOCDESIGN.centerDesign.designFaces.viewDataFace.dataIntroFace.popu(this.getData(item));
								}
							},
						
						dataIntroFace : {
							_init : function() {
								this.content = $('<div/>').addClass('adhoc_design_viewdata_di');
								this.tableContent = $('<div/>').addClass('adhoc_design_viewdata_tv'); 
								this.content.append(this.tableContent);
						
								this.des = $('<p/>').addClass('adhoc_design_viewdata_p').text('ʾݡ');
								this.area = $('<textarea/>').addClass('adhoc_design_viewdata_ta').attr({cols : '40', rows : '2', readonly : 'true'});
							},
							
							getContent : function() {
								if (!this.content) {
									this._init();
								}
								return this.content;
							},

							
							createDetailTable : function(tabledata) {
								var table = $('<table/>').attr('cellpadding', '0').attr('cellspacing', '0').addClass('adhoc_design_viewdata_table');
								table.append(this.createThead(tabledata)).append(this.createTbody(tabledata));
								this.tableContent.table = table;
								this.embellishBackground();
								return table;
							},
							
							createThead : function(tabledata) {
								var tr = $('<tr/>').addClass('adhoc_design_viewdata_tableheadtr');
								for (var i = 0, len = tabledata.length; i < len; i++) {
									tr.append($('<th/>').addClass('adhoc_design_viewdata_tableheadth').text(tabledata[i][0]));
								}
								return $('<thead/>').append(tr);
							},
							
							createTbody : function(tabledata) {
								var tbody = $('<tbody/>').addClass('adhoc_design_viewdata_tablebody');
								for (var i = 1, len = tabledata[0].length; i < len; i++) {
									var tr = $('<tr/>').addClass('adhoc_design_viewdata_tabletr');
									for (var j = 0, jen = tabledata.length; j < jen; j++) {
										tr.append($('<td/>').addClass('adhoc_design_viewdata_tabletd').text(tabledata[j][i]));
									}
									tbody.append(tr);
								}
								return tbody;
							},
							
							embellishBackground : function() {
								var trs = this.tableContent.table.children('tbody').children('tr');
								$.each(trs, function(i) {
									if (i%2 == 0) {
										$(trs[i]).addClass('adhoc_design_viewdata_treven');
									} else {
										$(trs[i]).addClass('adhoc_design_viewdata_trodd');
									}
								});
							},
							
							popu : function(data) {
								if (data.description) {
									this.area.val(data.description);
								}
								if (data.tabledata) {
									this.tableContent.empty();
									this.tableContent.append(this.createDetailTable(data.tabledata));
								}
								this.content.append(this.des);
								this.content.append(this.area);
							}
						},
						
						visible : function() {
							this.content.show();
						},
						
						invisible : function() {
							this.content.hide();
						}
					},
					
					filterDataFace : {
							_init : function() {
								this.content = $('<div/>').addClass('adhoc_design_filterdata');
								this.content.append(this.filterFace.getContent());
								this.content.append(this.filterShow.getContent());
							},
							
							getContent : function() {
								if (!this.content) {
									this._init();
								}
								return this.content;
							},
							
							filterFace : {
									_init : function() {
										this.content = $('<div/>').addClass('adhoc_design_filterdata_ff');
										this.content.append(this.createDesignTable());
									},
								
									getContent : function() {
										if (!this.content) {
											this._init();
										}
										return this.content;
									},
									
									createDesignTable : function() {
										var table = $('<table/>').addClass('adhoc_design_filterdata_table');
										table.append(this.generateExplanTR());
										table.append(this.generateFilterTR());
										return table;
									},
									
									generateExplanTR : function() {
										return $('<tr/>').addClass('adhoc_design_filterdata_explantr')
											.append($('<td/>').addClass('adhoc_design_filterface_explantd').text('ѡֶΣ'))
											.append($('<td/>').addClass('adhoc_design_filterface_explantd').text(''))
											.append($('<td/>').addClass('adhoc_design_filterface_explantd').text('ͣ'))
											.append($('<td/>').addClass('adhoc_design_filterface_explantd').text('ֵ'))
											.append($('<td/>').addClass('adhoc_design_filterface_explantd'));
									},
									
									generateFilterTR : function() {
										return $('<tr/>').addClass('adhoc_design_filterdata_filtertr')
											.append($('<td/>').addClass('adhoc_design_filterface_fieldstd').append(this.generateFieldCombo()))
											.append($('<td/>').addClass('adhoc_design_filterface_fieldstd').append(this.generateOPCombo()))
											.append($('<td/>').addClass('adhoc_design_filterface_fieldstd').append(this.generateTypeCombo()))
											.append($('<td/>').addClass('adhoc_design_filterface_fieldstd').append(this.valuePane.getContent()))
											.append($('<td/>').addClass('adhoc_design_filterface_fieldstd').append(this.generateButtonsTable()))
									},
									
									generateFieldCombo : function() {
										var listener = {};
										var self = this;
										listener.eventName = FR.Events.CLICK;
										listener.action = function() {
											self.changeSource();
										};
										
										var config = {
											editable : false,
											allowBlank : true,
											mode: 'remote',
											widgetUrl : '${servletURL}?op=adhoc_getdatafields',
											listeners : [listener]
										};	
										
										var combo = $('<div/>').addClass('adhoc_design_fieldscombo');
										this.fieldsCombo = combo.asComponent('combo', config);	
										return combo;
									},
									
									changeSource : function() {
										if (!this.fieldsCombo) {
											return;
										}
										var viewname = FR.ADHOCDESIGN.centerDesign.designFaces.viewDataFace.getViewName();
										this.fieldsCombo.options.mode = 'remote';
										this.fieldsCombo.options.widgetUrl = '${servletURL}?op=adhoc_getdatafields&viewname=' + viewname;
									},
									
									generateOPCombo : function() {									
										var config = {
											editable : false,
											allowBlank : true,
											mode: 'local'
										};	
										config.items = this.opData();
										var combo = $('<div/>').addClass('adhoc_design_opcombo');
										this.opCombo = combo.asComponent('combo', config);	
										return combo;
									},
									
									opData : function() {
										var item = [];
										item.push({text: '', value: ''});
										item.push({text: '', value: ''});
										item.push({text: '', value: ''});
										item.push({text: 'С', value: 'С'});
										item.push({text: 'ڵ', value: 'ڵ'});										
										item.push({text: 'Сڵ', value: 'Сڵ'});
										return item;
									},
									
									generateTypeCombo : function() {
										var listener = {};
										var self = this;
										listener.eventName = FR.Events.AFTEREDIT;
										listener.action = function() {
											self.valuePane.showTypePane(self.typeCombo.getValue());
										};
										var config = {
											editable : false,
											allowBlank : true,
											mode: 'local',
											listeners : [listener]
										};	
										config.items = this.typeData();
										var combo = $('<div/>').addClass('adhoc_design_typecombo');
										this.typeCombo = combo.asComponent('combo', config);	
										return combo;
									},
																		
									typeData : function() {
										var item = [];
										item.push({text: 'ַ', value: 'string'});
										item.push({text: '', value: 'number'});
										item.push({text: '', value: 'date'});
										return item;
									},
									
									valuePane : {
										_init : function() {
											this.content = $('<div/>').addClass('adhoc_design_valuepane');
											this.content.append(this.generateText())
												.append(this.generateNumber())
												.append(this.generateDate());
										},
										
										getContent : function() {
											if (!this.content) {
												this._init();
											}
											return this.content;
										},
										
										generateText : function() {
											var config = {};
											config.invisible = true;
											config.editable = true;
											var text = $('<div/>').addClass('adhoc_design_valuepane_text');
											this.text = text.asComponent('text', config);
											return text;
										},
										
										generateNumber : function() {
											var config = {};
											config.invisible = true;
											config.editable = true;
											var number = $('<div/>').addClass('adhoc_design_valuepane_number');
											this.number = number.asComponent('number', config);
											return number;
										},
										
										generateDate : function() {
											var config = {};
											config.invisible = true;
											config.editable = true;
											var date = $('<div/>').addClass('adhoc_design_valuepane_date');
											this.date = date.asComponent('datetime', config);
											return date;
										},
										
										showTypePane : function(type) {
											//b:0-string, 1-number, 2-date
											if (type == "string") {
												this.text.visible();
												this.number.invisible();
												this.date.invisible();
											} else if (type == "number") {
												this.text.invisible();
												this.number.visible();
												this.date.invisible();
											} else if (type == "date") {
												this.text.invisible();
												this.number.invisible();
												this.date.visible();
											}
										},
										
										getValue : function() {
											if (this.text.isVisible()) {
												return this.text.getValue();
											} else if (this.number.isVisible()) {
												return this.number.getValue();
											} else if (this.date.isVisible()) {
												return this.date.getValue();
											}
										},
										
										getType : function() {
											if (this.text.isVisible()) {
												return "string";
											} else if (this.number.isVisible()) {
												return "number";
											} else if (this.date.isVisible()) {
												return "date";
											}
										}
									},
									
									generateButtonsTable : function() {
										var table = $('<table/>').addClass('adhoc_design_filterdata_buttonstable');
										var buttons = this.generateOPButtons();
										var tr = $('<tr/>');
										$.each(buttons, function(i) {
											var td = $('<td/>').addClass('adhoc_design_filterdata_buttonstd');
											td.append(buttons[i]);
											tr.append(td);
										});
										return table.append(tr);
									},
									
									generateOPButtons : function() {	
										var self = this;	
										var cs = 'adhoc_design_condition_button';						
										var addConfig = {
											img : '${servletURL}?op=resource&resource=/com/fr/web/adhoc/images/adhoc_design_condition_add.png',
											text : '½',
											css : cs,
											action : function(e) {
												self.addNameCondition();
											}
										};
										this.addButton = $('<div/>');
										this.addButton.generateIconButton(addConfig);
										this.addButton.setEnable(true);
										var deleteConfig = {
											img : '${servletURL}?op=resource&resource=/com/fr/web/adhoc/images/adhoc_design_condition_remove.png',
											text : 'ɾ',
											css : cs,
											action : function(e) {
												self.removeNameCondition();
											}
										};
										this.deleteButton = $('<div/>');
										this.deleteButton.generateIconButton(deleteConfig);
										this.deleteButton.setEnable(true);
										return [this.addButton, this.deleteButton];
									},
																
									
									createNameCondition : function() {
										var nc = {};
										nc.text = this.fieldsCombo.getValue() + this.opCombo.getValue() + this.valuePane.getValue();
										var ct = {};
										ct.columnname = this.fieldsCombo.getValue();
										var compare = {};
										compare.op = this.opCombo.getValue();
										compare.type = this.valuePane.getType();
										compare.value = this.valuePane.getValue();
										ct.compare = compare;
										nc.value = ct;
										return nc;
									},
									
									addNameCondition : function() {
										var nc = this.createNameCondition();
										FR.ADHOCDESIGN.centerDesign.designFaces.filterDataFace.filterShow.addNameCondition(nc);
									},
									
									removeNameCondition : function() {
										FR.ADHOCDESIGN.centerDesign.designFaces.filterDataFace.filterShow.removeNameCondition();
									},
									
									setDeleteButtonState : function(state) {
										this.deletebutton.setEnable(state);
									}
								},
							
							filterShow : {
										_init : function() {
											this.content = $('<div/>').addClass('adhoc_design_filterdata_fs');
											var self = this;
											config = {};
											config.data = [];
											config.onnodeclick  = function() {
												 self.clickNode();
											};
											config.operation = {};
											config.operation.deleteaction = function() {
												self.removeaction();
											};
										 	this.content.jlist(config);	
										},
										
										getContent : function() {
											if (!this.content) {
												this._init();
											}
											return this.content;
										},
										
										clickNode : function() {
//											filterFace.setDeleteButtonState(true);
										},
										
										removeaction : function(item, newItem) {
//											if (!newItem) {
//												filterFace.setDeleteButtonState(false);
//											}
										},
										
										addNameCondition : function(nc) {
											this.content.addListItem(nc);
										},
										
										removeNameCondition : function() {
											this.content.removeListItem();
										},
										
										getConditions : function() {
											var data = this.content.getAllData();
											var cs = [];
											for(var i = 0, len = data.length; i < len; i++) {
												cs.push(data[i].value);
											}
											return cs;
										}						
									},
								
								checkValid : function() {
									return true;
								},
								
								getConditions : function() {
									return this.filterShow.getConditions();
								},
								
								visible : function() {
									this.content.show();
								},
								
								invisible : function() {
									this.content.hide();
								}
							},
					
					defineReportFace : {
							_init : function() {
								this.content = $('<div/>').addClass('adhoc_design_definereport');
								this.content.append(this.chooseReport.getContent());
								this.content.append(this.simpleReport.getContent());
								this.content.append(this.crossReport.getContent());
								this.simpleReport.invisible();
								this.crossReport.invisible();
							},
							
							getContent : function() {
								if (!this.content) {
									this._init();
								}
								return this.content;
							},
							
							chooseReport : {
									_init : function() {
										this.content = $('<div/>').addClass('adhoc_design_definereport_choosereport');
										this.content.append(this.generateTitleTable());
										this.content.append(this.generateReportTypeTable());
										this.content.append(this.generateReportShowFace());
										this.content.append(this.generateSubmitButton());
										this.defaultState();
									},
									
									getContent : function() {
										if (!this.content) {
											this._init();
										}
										return this.content;
									},
									
									generateTitleTable : function() {
										var table = $('<table/>').addClass('adhoc_design_definereport_titletable');
										this.title = $('<input/>').addClass('adhoc_design_definereport_title').attr('type', 'text');
										this.subtitle = $('<input/>').addClass('adhoc_design_definereport_subtitle').attr('type', 'text');
										table.append(this.generateTitleTR()).append(this.generateSubTitleTR());
										return table;
									},
									
									generateTitleTR : function() {
										var tds = $('<td/>').addClass('adhoc_design_definereport_titletable_font').text(':');
										var tdv = $('<td/>').append(this.title);
										return $('<tr/>').append(tds).append(tdv);
									},
									
									generateSubTitleTR : function() {
										var tds = $('<td/>').addClass('adhoc_design_definereport_titletable_font').text(':');
										var tdv = $('<td/>').append(this.subtitle);
										return $('<tr/>').append(tds).append(tdv);
									},
									
									generateReportTypeTable : function() {
										var table = $('<table/>').addClass('adhoc_design_definereport_reporttypetable');
										var tr = $('<tr/>');
										var self = this;
										this.simpleRadio = $('<input/>').attr({type: 'radio', name : 'reporttype'}).click(function() {
											self.showSimpleReport();
											self.setStyleSource(0);
										});
										this.crossRadio = $('<input/>').attr({type: 'radio', name : 'reporttype'}).click(function() {
											self.showCrossReport();
											self.setStyleSource(1);
										});
										tr.append($('<td/>').append(this.simpleRadio)).append($('<td/>').addClass('adhoc_design_definereport_reporttypetable_font').text('򵥱'))
											.append($('<td/>').append(this.crossRadio)).append($('<td/>').addClass('adhoc_design_definereport_reporttypetable_font').text('汨'));
										return table.append(tr);
									},
									
									setStyleSource : function(type) {
										FR.ADHOCDESIGN.centerDesign.designFaces.chooseStyleFace.styleView.changeSource(type);
									},
									
									defaultState : function() {
										this.simpleRadio.attr('checked', true);
										this.showSimpleReport();
									},
									
									generateReportShowFace : function() {
										var div = $('<div/>').addClass('adhoc_design_definereport_imgcontainer');
										this.img = $('<img/>').addClass('adhoc_design_definereport_img');
										return div.append(this.img);
									},
									
									showSimpleReport : function() {
										this.img.attr('src', '${servletURL}?op=resource&resource=/com/fr/web/adhoc/images/adhoc_design_definereport_simple.png');
									},
									
									showCrossReport : function() {
										this.img.attr('src', '${servletURL}?op=resource&resource=/com/fr/web/adhoc/images/adhoc_design_definereport_cross.png');
									},
									
									generateSubmitButton : function() {
											this.nextButton = $('<div/>').addClass('adhoc_design_definereport_nextButton');
	
											var container =  $('<div/>').addClass('adhoc_design_definereport_nextButton_container').append(this.nextButton);
											var self = this;
											this.nextButton.asComponent('button', {
												text : 'һ',
												handler : function() {
													self.showNextPane();
												}
											});
											return container;				
									},
									
									showNextPane : function() {
										this.invisible();
										var simpleReport = FR.ADHOCDESIGN.centerDesign.designFaces.defineReportFace.simpleReport;
										var crossReport = FR.ADHOCDESIGN.centerDesign.designFaces.defineReportFace.crossReport;
										if (this.simpleRadio.attr('checked')) {
											simpleReport.popuView(FR.ADHOCDESIGN.centerDesign.designFaces.viewDataFace.getViewName());
											simpleReport.visible();
											crossReport.invisible();
										} else if (this.crossRadio.attr('checked')) {
											crossReport.popuView(FR.ADHOCDESIGN.centerDesign.designFaces.viewDataFace.getViewName());
											simpleReport.invisible();
											crossReport.visible();
										}
									},
									
									getReportType : function() {
										if (this.simpleRadio.attr('checked')) {
											return 0;
										} else {
											return 1;
										}
									},
									
									visible : function() {
										this.content.show();
									},
									
									invisible : function() {
										this.content.hide();
									},
									
									getTitle : function() {
										return this.title.val();
									},
									
									getSubTitle : function() {
										return this.subtitle.val();
									}
								},
							
							simpleReport : {
									_init : function() {
										this.content = $('<div/>').addClass('adhoc_design_definereport_simpleReport');
										this.content.append(this.generateExplanPane());
										var mainContent = $('<div/>').addClass('adhoc_design_definereport_simplemain');
										mainContent.append(this.fieldsListPane.getContent())
											.append(this.columnsSetPane.getContent())
											.append(this.generateButtonPane());
										this.content.append(mainContent);
									},
									
									getContent : function() {
										if (!this.content) {
											this._init();
										}
										return this.content;
									},
									
									generateExplanPane : function() {
										return $('<p/>').addClass('adhoc_design_definereport_reportexplan').text('ΪݣݿԽϵá');
									},
									
									popuView : function(name) {
										this.fieldsListPane.popuView(name);
										this.columnsSetPane.popuView(name);
									},
									
									fieldsListPane : {
										_init : function() {
											this.content = $('<div/>').addClass('adhoc_design_definereport_simplefieldslist');
											var config = {};
											config.title = 'ѡֶ';
											config.titleClass = 'adhoc_design_definereport_simplelisttitle';	
											this.content.jlist(config);									
										},
										
										getContent : function() {
											if (!this.content) {
												this._init();
											}
											return this.content;
										},
										
										//b:jlistҪĽֱupdate data
										popuView : function(viewName) {
											if (this.viewName == viewName) {
												return;
											}
											var items = this.getData(viewName);
											this.content.clearList();
											this.content.addItems(items);
										},									
										
										getData : function(name) {
											var data;
											$.ajax({
												url: '${servletURL}?op=adhoc_design_viewlist',
												type: 'POST',
												data: {viewname: FR.cjkEncode(name)},
												async : false,
												complete: function(res, status) {
													data = FR.jsonDecode(res.responseText);
												}
											});
											return data;
										},
										
										getSelectedItem : function() {
											return this.content.getListItem();
										}
									},
									
									columnsSetPane : {
											_init : function() {
												this.content = $('<div/>').addClass('adhoc_design_definereport_columnspane');
												this.content.append(this.generateTable());
											},
											
											getContent : function() {
												if (!this.content) {
													this._init();
												}
												return this.content;
											},
											
											popuView : function(name) {
												if (this.viewName == name) {
													return;
												}
												this.viewName = name;
												this.detailColumnBoard.clear();
												this.groupColumnBoard.clear();
												this.summaryColumnBoard.clear();
												this.sortColumnBoard.clear();
											},
											
											generateTable : function() {
												var table = $('<table/>').addClass('adhoc_design_definereport_simpletable');
												table.append(this.generateDetailTR())
													.append(this.generateGroupTR())
													.append(this.generateSummaryTR())
													.append(this.generateSortTR());
												return table;
											},
											
											generateDetailTR : function() {
												var td = $('<td/>').addClass('adhoc_design_definereport_simpledetailtd')
													.append(this.detailColumnBoard.getContent());
												return $('<tr/>').append(td);
											},
											
											generateGroupTR : function() {
												var td = $('<td/>').addClass('adhoc_design_definereport_simplegrouptd')
													.append(this.groupColumnBoard.getContent());
												return $('<tr/>').append(td);
											},
											
											generateSummaryTR : function() {
												var td = $('<td/>').addClass('adhoc_design_definereport_simplesummarytd')
													.append(this.summaryColumnBoard.getContent());
												return $('<tr/>').append(td);
											},
											
											generateSortTR : function() {
												var td = $('<td/>').addClass('adhoc_design_definereport_simplesorttd')
													.append(this.sortColumnBoard.getContent());
												return $('<tr/>').append(td);
											},
											
											detailColumnBoard : {
												_init : function() {
													this.content = $('<div/>').addClass('adhoc_design_definereport_simpledetail');
													this.columns = [];
													this.content.append(this.generateTable());
												},
												
												getContent : function() {
													if (!this.content) {
														this._init();
													}
													return this.content;
												},
												
												generateTable : function() {
													var rightdiv = $('<div/>').addClass('adhoc_design_definereport_simpledetailright');
													rightdiv.append(this.createTitle());
													this.table = $('<table/>').addClass('adhoc_design_definereport_simpledetailtable');
													rightdiv.append($('<div/>').addClass('adhoc_design_definereport_simpledetailtablecontainer').append(this.table));
													
													var table = $('<table/>').addClass('adhoc_design_definereport_simpledetailwholetable');
													var td = $('<td/>').addClass('adhoc_design_definereport_simpledetailicontd');
													td.append(this.generateMoveButton());
													var dtd = $('<td/>').addClass('adhoc_design_definereport_simpledetailrighttd');
													dtd.append(rightdiv);
													return table.append($('<tr/>').append(td).append(dtd));
												},
												
												generateMoveButton : function() {
													var button = $('<div/>');
													var imgurl = '${servletURL}?op=resource&resource=/com/fr/web/adhoc/images/simplecolumnmove.png';
													var cs = 'adhoc_design_definereport_simplemovebutton';
													var self = this;
													var config = {text : 'ƶֶ', css : cs, img : imgurl,
														action : function() {
															self.addColumn();
														}};
													button.generateIconButton(config);
													button.setEnable(true);
													return button;
												},
												
												createTitle : function() {
													return $('<p/>').addClass('adhoc_design_definereport_simpledetailtitle').text('ϸֶ');
												},
												
												getItem : function() {
													return FR.ADHOCDESIGN.centerDesign.designFaces.defineReportFace.simpleReport.fieldsListPane.getSelectedItem();
												},
												
												//b:add&deletereafactortableĽ
												addColumn : function() {
													var column = {columnname: this.getItem()};
													if (this.isExist(column)) {
														return;
													}
													this.columns.push(column);
													this.refactorTable();
												},
												
												isExist : function(column) {
													for (var i = 0, len = this.columns.length; i < len; i++) {
														if (column.columnname == this.columns[i].columnname) {
															return true;
														}
													}
													return false;
												},
												
												removeColumn : function(column) {
													this.columns.remove(column);
													this.refactorTable();
												},
												
												refactorTable : function() {
													this.table.empty();
													for (var i = 0, len = this.columns.length; i < len; i++) {
														var tr = this.generateColumnTR(this.columns[i]);
														this.table.append(tr);
													}
												},
												
												generateColumnTR : function(column) {
													var imgurl = '${servletURL}?op=resource&resource=/com/fr/web/adhoc/images/columnremove.png';
													var cs = 'adhoc_design_definereport_simpledeletebutton';
													var button = $('<div/>').data('column', column);
													var self = this;
													var config = {text : 'ɾģ', css : cs, img : imgurl,
														action : function() {
															self.removeColumn(this.data('column'))
														}.createDelegate(button)};
													button.generateIconButton(config);
													button.setEnable(true);
													var td = $('<td/>').addClass('adhoc_design_definereport_simplefont').text(column.columnname);
													var btd = $('<td/>').append(button);
													return $('<tr/>').append(td).append(btd);
												},
												
												getColumns : function() {													
													return this.columns.length ? this.columns : null;
												},
												
												clear : function() {
													this.columns = [];
													this.refactorTable();
												}
											},
											
											groupColumnBoard : {
												_init : function() {
													this.content = $('<div/>').addClass('adhoc_design_definereport_simplegroup');
													this.columns = [];
													this.content.append(this.generateTable());
												},
												
												getContent : function() {
													if (!this.content) {
														this._init();
													}
													return this.content;
												},
												
												generateTable : function() {
													var rightdiv = $('<div/>').addClass('adhoc_design_definereport_simplegroupright');
													rightdiv.append(this.createTitle());
													this.table = $('<table/>').addClass('adhoc_design_definereport_simplegrouptable').attr({'cellpadding': 0, 'cellspacing': 0});
													rightdiv.append($('<div/>').addClass('adhoc_design_definereport_simplegrouptablecontainer').append(this.table));
													
													var table = $('<table/>').addClass('adhoc_design_definereport_simplegroupwholetable');
													var td = $('<td/>').addClass('adhoc_design_definereport_simplegroupicontd');
													td.append(this.generateMoveButton());
													var dtd = $('<td/>').addClass('adhoc_design_definereport_simplegrouprighttd');
													dtd.append(rightdiv);
													return table.append($('<tr/>').append(td).append(dtd));
												},
												
												generateMoveButton : function() {
													var button = $('<div/>');
													var imgurl = '${servletURL}?op=resource&resource=/com/fr/web/adhoc/images/simplecolumnmove.png';
													var cs = 'adhoc_design_definereport_simplemovebutton';
													var self = this;
													var config = {text : 'ƶֶ', css : cs, img : imgurl,
														action : function() {
															self.addColumn();
														}};
													button.generateIconButton(config);
													button.setEnable(true);
													return button;
												},
												
												createTitle : function() {
													return $('<p/>').addClass('adhoc_design_definereport_simpledetailtitle').text('ֶ');
												},
												
												getItem : function() {
													return FR.ADHOCDESIGN.centerDesign.designFaces.defineReportFace.simpleReport.fieldsListPane.getSelectedItem();
												},
												
												addColumn : function() {
													var column = {columnname: this.getItem(), sort: 0};
													if (this.isExist(column)) {
														return;
													}
													this.columns.push(column);
													this.refactorTable();
												},
												
												isExist : function(column) {
													for (var i = 0, len = this.columns.length; i < len; i++) {
														if (column.columnname == this.columns[i].columnname) {
															return true;
														}
													}
													return false;
												},
												
												removeColumn : function(column) {
													this.columns.remove(column);
													this.refactorTable();
												},
												
												refactorTable : function() {
													this.table.empty();
													for (var i = 0, len = this.columns.length; i < len; i++) {
														var tr = this.generateColumnTR(this.columns[i]);
														this.table.append(tr);
													}
												},
												
												generateColumnTR : function(column) {
													var imgurl = '${servletURL}?op=resource&resource=/com/fr/web/adhoc/images/columnremove.png';
													var cs = 'adhoc_design_definereport_simpledeletebutton';
													var button = $('<div/>').data('column', column);
													var self = this;
													var config = {text : 'ɾģ', css : cs, img : imgurl,
														action : function() {
															self.removeColumn(this.data('column'))
														}.createDelegate(button)};
													button.generateIconButton(config);
													button.setEnable(true);
													
													var sortCombo = $('<div/>').addClass('adhoc_design_definereport_simplesort');
													var listener = {};
													listener.eventName = FR.Events.AFTEREDIT;
													listener.action = function() {
														self.changeColumn(sortCombo.data('column'), self.sortCombobox.getValue());
													}.createDelegate(sortCombo);
													var config = {
														width : 70,
														editable : false,
														allowBlank : true,
														mode: 'local',
														listeners : [listener]
													};	
													config.items = this.createData();
													this.sortCombobox = sortCombo.asComponent('combo', config);
													sortCombo.data('column', column);
													
													var td = $('<td/>').addClass('adhoc_design_definereport_simplefont').text(column.columnname);
													
													var ctd = $('<td/>').append(sortCombo);
													if (column.sort != null) {
														this.sortCombobox.setValue(column.sort);
													}
													var btd = $('<td/>').append(button);
													return $('<tr/>').append(td).append(ctd).append(btd);
												},
												
												createData : function() {
													var data = [];
													data.push({text: '', value: 0});
													data.push({text: '', value: 1});
													data.push({text: '', value: 2});
													return data;
												},
												
												changeColumn : function(column, sort) {
													for (var i = 0, len = this.columns.length; i < len; i++) {
														if (column.columnname == this.columns[i].columnname) {
															this.columns[i].sort = sort;
														}
													}
												},
												
												getColumns : function() {													
													return this.columns.length ? this.columns : null;
												},
												
												clear : function() {
													this.columns = [];
													this.refactorTable();
												}
											},
											
											summaryColumnBoard : {
												_init : function() {
													this.content = $('<div/>').addClass('adhoc_design_definereport_simplesummary');
													this.columns = [];
													this.content.append(this.generateTable());
												},
												
												getContent : function() {
													if (!this.content) {
														this._init();
													}
													return this.content;
												},
												
												generateTable : function() {
													var rightdiv = $('<div/>').addClass('adhoc_design_definereport_simplesummaryright');
													rightdiv.append(this.createTitle());
													this.table = $('<table/>').addClass('adhoc_design_definereport_simplesummarytable').attr({'cellpadding': 0, 'cellspacing': 0});
													rightdiv.append($('<div/>').addClass('adhoc_design_definereport_simplesummarytablecontainer').append(this.table));
													
													var table = $('<table/>').addClass('adhoc_design_definereport_simplesummarywholetable');
													var td = $('<td/>').addClass('adhoc_design_definereport_simplesummaryicontd');
													td.append(this.generateMoveButton());
													var dtd = $('<td/>').addClass('adhoc_design_definereport_simplesummaryrighttd');
													dtd.append(rightdiv);
													return table.append($('<tr/>').append(td).append(dtd));
												},
												
												generateMoveButton : function() {
													var button = $('<div/>');
													var imgurl = '${servletURL}?op=resource&resource=/com/fr/web/adhoc/images/simplecolumnmove.png';
													var cs = 'adhoc_design_definereport_simplemovebutton';
													var self = this;
													var config = {text : 'ƶֶ', css : cs, img : imgurl,
														action : function() {
															self.addColumn();
														}};
													button.generateIconButton(config);
													button.setEnable(true);
													return button;
												},
												
												createTitle : function() {
													return $('<p/>').addClass('adhoc_design_definereport_simpledetailtitle').text('ֶ');
												},
												
												getItem : function() {
													return FR.ADHOCDESIGN.centerDesign.designFaces.defineReportFace.simpleReport.fieldsListPane.getSelectedItem();
												},
												
												addColumn : function() {
													if (this.columns.length > 0) {
														FR.Msg.alert(FR.i18n.Info, "ֻһΪֶΡ");
														return;
													}
													var column = {columnname: this.getItem(), funname: 'sum'};
													if (this.isExist(column)) {
														return;
													}
													this.columns.push(column);
													this.refactorTable();
												},
												
												isExist : function(column) {
													for (var i = 0, len = this.columns.length; i < len; i++) {
														if (column.columnname == this.columns[i].columnname) {
															return true;
														}
													}
													return false;
												},
												
												removeColumn : function(column) {
													this.columns.remove(column);
													this.refactorTable();
												},
												
												refactorTable : function() {
													this.table.empty();
													for (var i = 0, len = this.columns.length; i < len; i++) {
														var tr = this.generateColumnTR(this.columns[i]);
														this.table.append(tr);
													}
												},
												
												generateColumnTR : function(column) {
													var imgurl = '${servletURL}?op=resource&resource=/com/fr/web/adhoc/images/columnremove.png';
													var cs = 'adhoc_design_definereport_simpledeletebutton';
													var button = $('<div/>').data('column', column);
													var self = this;
													var config = {text : 'ɾģ', css : cs, img : imgurl,
														action : function() {
															self.removeColumn(this.data('column'))
														}.createDelegate(button)};
													button.generateIconButton(config);
													button.setEnable(true);

													var funCombo = $('<div/>').addClass('adhoc_design_definereport_simplesort');
													var listener = {};
													listener.eventName = FR.Events.AFTEREDIT;
													listener.action = function() {
														self.changeColumn(funCombo.data('column'), self.funCombobox.getValue());
													}.createDelegate(funCombo);
													var config = {
														width : 70,
														editable : false,
														allowBlank : true,
														mode: 'local',
														listeners : [listener]
													};	
													config.items = this.createData();
													this.funCombobox = funCombo.asComponent('combo', config);
													funCombo.data('column', column);
													
													var td = $('<td/>').addClass('adhoc_design_definereport_simplefont').text(column.columnname);
													
													var ctd = $('<td/>').append(funCombo);
													if (column.funname) {
														this.funCombobox.setValue(column.funname);
													}
													var btd = $('<td/>').append(button);
													return $('<tr/>').append(td).append(ctd).append(btd);
												},
												
												createData : function() {
													var data = [];
													data.push({text: '', value: 'sum'});
													data.push({text: 'ƽ', value: 'ave'});
													data.push({text: 'ֵ', value: 'max'});
													data.push({text: 'Сֵ', value: 'min'});
													data.push({text: '', value: 'count'});
													return data;
												},
												
												changeColumn : function(column, funname) {
													for (var i = 0, len = this.columns.length; i < len; i++) {
														if (column.columnname == this.columns[i].columnname) {
															this.columns[i].funname = funname;
														}
													}
												},
												
												getColumns : function() {													
													return this.columns.length ? this.columns : null;
												},
												
												clear : function() {
													this.columns = [];
													this.refactorTable();
												}
											},
											
											sortColumnBoard : {
												_init : function() {
													this.content = $('<div/>').addClass('adhoc_design_definereport_simplesort');
													this.columns = [];
													this.content.append(this.generateTable());
												},
												
												getContent : function() {
													if (!this.content) {
														this._init();
													}
													return this.content;
												},
												
												generateTable : function() {
													var rightdiv = $('<div/>').addClass('adhoc_design_definereport_simplesortright');
													rightdiv.append(this.createTitle());
													this.table = $('<table/>').addClass('adhoc_design_definereport_simplesorttable').attr({'cellpadding': 0, 'cellspacing': 0});
													rightdiv.append($('<div/>').addClass('adhoc_design_definereport_simplesorttablecontainer').append(this.table));
													
													var table = $('<table/>').addClass('adhoc_design_definereport_simplesortwholetable');
													var td = $('<td/>').addClass('adhoc_design_definereport_simplesorticontd');
													td.append(this.generateMoveButton());
													var dtd = $('<td/>').addClass('adhoc_design_definereport_simplesortrighttd');
													dtd.append(rightdiv);
													return table.append($('<tr/>').append(td).append(dtd));
												},
												
												generateMoveButton : function() {
													var button = $('<div/>');
													var imgurl = '${servletURL}?op=resource&resource=/com/fr/web/adhoc/images/simplecolumnmove.png';
													var cs = 'adhoc_design_definereport_simplemovebutton';
													var self = this;
													var config = {text : 'ƶֶ', css : cs, img : imgurl,
														action : function() {
															self.addColumn();
														}};
													button.generateIconButton(config);
													button.setEnable(true);
													return button;
												},
												
												createTitle : function() {
													return $('<p/>').addClass('adhoc_design_definereport_simpledetailtitle').text('ֶ');
												},
												
												getItem : function() {
													return FR.ADHOCDESIGN.centerDesign.designFaces.defineReportFace.simpleReport.fieldsListPane.getSelectedItem();
												},
												
												addColumn : function() {
													if (this.columns.length > 0) {
														FR.Msg.alert(FR.i18n.Info, "ֻһΪֶΡ");
														return;
													}
													var column = {columnname: this.getItem(), sort: 0};
													if (this.isExist(column)) {
														return;
													}
													this.columns.push(column);
													this.refactorTable();
												},
												
												isExist : function(column) {
													for (var i = 0, len = this.columns.length; i < len; i++) {
														if (column.columnname == this.columns[i].columnname) {
															return true;
														}
													}
													return false;
												},
												
												removeColumn : function(column) {
													this.columns.remove(column);
													this.refactorTable();
												},
												
												refactorTable : function() {
													this.table.empty();
													for (var i = 0, len = this.columns.length; i < len; i++) {
														var tr = this.generateColumnTR(this.columns[i]);
														this.table.append(tr);
													}
												},
												
												generateColumnTR : function(column) {
													var imgurl = '${servletURL}?op=resource&resource=/com/fr/web/adhoc/images/columnremove.png';
													var cs = 'adhoc_design_definereport_simpledeletebutton';
													var button = $('<div/>').data('column', column);
													var self = this;
													var config = {text : 'ɾģ', css : cs, img : imgurl,
														action : function() {
															self.removeColumn(this.data('column'))
														}.createDelegate(button)};
													button.generateIconButton(config);
													button.setEnable(true);
										
													var sortCombo = $('<div/>').addClass('adhoc_design_definereport_simplesort');
													var listener = {};
													listener.eventName = FR.Events.AFTEREDIT;
													listener.action = function() {
														self.changeColumn(sortCombo.data('column'), self.sortCombobox.getValue());
													}.createDelegate(sortCombo);
													var config = {
														width : 70,
														editable : false,
														allowBlank : true,
														mode: 'local',
														listeners : [listener]
													};	
													config.items = this.createData();
													this.sortCombobox = sortCombo.asComponent('combo', config);
													sortCombo.data('column', column);
													
													var td = $('<td/>').addClass('adhoc_design_definereport_simplefont').text(column.columnname);
													
													var ctd = $('<td/>').append(sortCombo);
													if (column.sort != null) {
														this.sortCombobox.setValue(column.sort);
													}
													var btd = $('<td/>').append(button);
													return $('<tr/>').append(td).append(ctd).append(btd);
												},
												
												createData : function() {
													var data = [];
													data.push({text: '', value: 0});
													data.push({text: '', value: 1});
													data.push({text: '', value: 2});
													return data;
												},
												
												changeColumn : function(column, sort) {
													for (var i = 0, len = this.columns.length; i < len; i++) {
														if (column.columnname == this.columns[i].columnname) {
															this.columns[i].sort = sort;
														}
													}
												},
												
												getColumns : function() {													
													return this.columns.length ? this.columns : null;
												},
												
												clear : function() {
													this.columns = [];
													this.refactorTable();
												}
											},
											
											getReport : function() {
												var report = {};
												if (this.summaryColumnBoard.getColumns() != null && this.summaryColumnBoard.getColumns().length > 0) {
													report.summaryColumn = this.summaryColumnBoard.getColumns();
												}
												if (this.detailColumnBoard.getColumns() != null && this.detailColumnBoard.getColumns().length > 0) {
													report.displaycolumns = this.detailColumnBoard.getColumns();
												}
												if (this.groupColumnBoard.getColumns() != null && this.groupColumnBoard.getColumns().length > 0) {
													report.groupcolumns = this.groupColumnBoard.getColumns();
												}
												if (this.sortColumnBoard.getColumns() != null && this.sortColumnBoard.getColumns().length > 0) {
													report.sortcolumn = this.sortColumnBoard.getColumns();
												}
																
												report.reporttype = 0;
												return report;
											},
											
											checkValid : function() {
												if (!this.summaryColumnBoard.getColumns() && !this.detailColumnBoard.getColumns() && !this.groupColumnBoard.getColumns() && !this.sortColumnBoard.getColumns()) {
													FR.ADHOCDESIGN.centerDesign.designSteps.embellishSelfButton(2);
													FR.ADHOCDESIGN.centerDesign.designFaces.defineReportFace.simpleReport.popuView(FR.ADHOCDESIGN.centerDesign.designFaces.viewDataFace.getViewName());
													FR.ADHOCDESIGN.centerDesign.designFaces.defineReportFace.showSimpleReport();
													FR.Msg.alert(FR.i18n.Info, "ѡֶΪϸֶΡֶΡֶΡ");
																				
													return false;
												}
												return true;
											}
										},
									
									generateButtonPane : function() {
											this.nextButton = $('<div/>').addClass('adhoc_design_definereport_backButton');
	
											var container =  $('<div/>').addClass('adhoc_design_definereport_backButton_container').append(this.nextButton);
											var self = this;
											this.nextButton.asComponent('button', {
												text : 'һ',
												handler : function() {
													self.showBackPane();
												}
											});
											return container;										
									},
									
									showBackPane : function() {
										this.invisible();
										FR.ADHOCDESIGN.centerDesign.designFaces.defineReportFace.chooseReport.visible();
									},
									
									getReport : function() {
										return this.columnsSetPane.getReport();
									},
									
									visible : function() {
										this.showing = true;
										this.content.show();
									},
									
									invisible : function() {
										this.showing = false;
										this.content.hide();
									},
									
									isVisible : function() {
										return this.showing;
									},
									
									checkValid : function() {
										return this.columnsSetPane.checkValid();
									}	
								},
							
							crossReport : {
									_init : function() {
										this.content = $('<div/>').addClass('adhoc_design_definereport_crossreport');
										this.borderPanes();
									},
							
									getContent : function() {
										if (!this.content) {
											this._init();
										}
										return this.content;
									},
									
									//b:table
									borderPanes : function() {
										this.content.append($('<p/>').addClass('adhoc_design_definereport_reportexplan').text('ΪݣݿԽϵá'));
										var table = $('<table/>').addClass('adhoc_design_definereport_crosstable');
										table.append($('<tr/>').append(this.generateListTD()).append(this.generateColumnTD()))
											.append($('<tr/>').append(this.generateRowTD()).append(this.generateSummaryTD()));
										this.content.append(table);
										this.content.append(this.generateButtonPane());
									},
									
									generateListTD : function() {
										var td = $('<td/>').addClass('adhoc_design_definereport_crosslisttd');
										td.append(this.fieldsListPane.getContent());
										return td;
									},
									
									generateColumnTD : function() {
										var td = $('<td/>').addClass('adhoc_design_definereport_crosscolumntd');
										td.append(this.columnColumnBoard.getContent());
										return td;
									},
									
									generateRowTD : function() {
										var td = $('<td/>').addClass('adhoc_design_definereport_crossrowtd');
										td.append(this.rowColumnBoard.getContent());
										return td;
									},
									
									generateSummaryTD : function() {
										var td = $('<td/>').addClass('adhoc_design_definereport_crosssummarytd');
										td.append(this.summaryColumnBoard.getContent());
										return td;
									},
									
									popuView : function(name) {
										if (this.viewName == name) {
											return;
										}
										this.viewName = name;
										this.fieldsListPane.popuView(name);
										this.clearBoard();
									},
									
									clearBoard : function() {
										this.columnColumnBoard.clear();
										this.rowColumnBoard.clear();
										this.summaryColumnBoard.clear();
									},
									
									fieldsListPane : {										
										_init : function() {
											this.content = $('<div/>').addClass('adhoc_design_definereport_crossfieldslist');
											var config = {};
											config.title = 'ѡֶ';
											config.titleClass = 'adhoc_design_definereport_simplelisttitle';	
											this.content.jlist(config);									
										},
										
										getContent : function() {
											if (!this.content) {
												this._init();
											}
											return this.content;
										},
										
										//b:jlistҪĽֱupdate data
										popuView : function(viewName) {
											if (this.viewName == viewName) {
												return;
											}
											var items = this.getData(viewName);
											this.content.clearList();
											this.content.addItems(items);
										},									
										
										getData : function(name) {
											var data;
											$.ajax({
												url: '${servletURL}?op=adhoc_design_viewlist',
												type: 'POST',
												data: {viewname: FR.cjkEncode(name)},
												async : false,
												complete: function(res, status) {
													data = FR.jsonDecode(res.responseText);
												}
											});
											return data;
										},
										
										getSelectedItem : function() {
											return this.content.getListItem();
										}
									},
									
									columnColumnBoard : {
												_init : function() {
													this.content = $('<div/>').addClass('adhoc_design_definereport_crosscolumns');
													this.columns = [];
													this.content.append(this.generateTable());
												},
												
												getContent : function() {
													if (!this.content) {
														this._init();
													}
													return this.content;
												},
												
												generateTable : function() {
													var rightdiv = $('<div/>').addClass('adhoc_design_definereport_crosscolumnsright');
													rightdiv.append(this.createTitle());
													this.table = $('<table/>').addClass('adhoc_design_definereport_crosscolumnsttable').attr({'cellpadding': 0, 'cellspacing': 0});
													rightdiv.append($('<div/>').addClass('adhoc_design_definereport_crosscolumnstablecontainer').append(this.table));
													
													var table = $('<table/>').addClass('adhoc_design_definereport_crosscolumnswholetable');
													var td = $('<td/>').addClass('adhoc_design_definereport_crosscolumnsicontd');
													td.append(this.generateMoveButton());
													var dtd = $('<td/>').addClass('adhoc_design_definereport_crosscolumnsrighttd');
													dtd.append(rightdiv);
													return table.append($('<tr/>').append(td).append(dtd));
												},
												
												generateMoveButton : function() {
													var button = $('<div/>');
													var imgurl = '${servletURL}?op=resource&resource=/com/fr/web/adhoc/images/simplecolumnmove.png';
													var cs = 'adhoc_design_definereport_crosscolumnsbutton';
													var self = this;
													var config = {text : 'ƶֶ', css : cs, img : imgurl,
														action : function() {
															self.addColumn();
														}};
													button.generateIconButton(config);
													button.setEnable(true);
													return button;
												},
												
												createTitle : function() {
													return $('<p/>').addClass('adhoc_design_definereport_simpledetailtitle').text('ֶ');
												},
												
												getItem : function() {
													return FR.ADHOCDESIGN.centerDesign.designFaces.defineReportFace.crossReport.fieldsListPane.getSelectedItem();
												},
												
												addColumn : function() {
													var column = {columnname: this.getItem(), sort: 0};
													if (this.isExist(column)) {
														return;
													}
													this.columns.push(column);
													this.refactorTable();
												},
												
												isExist : function(column) {
													for (var i = 0, len = this.columns.length; i < len; i++) {
														if (column.columnname == this.columns[i].columnname) {
															return true;
														}
													}
													return false;
												},
												
												removeColumn : function(column) {
													this.columns.remove(column);
													this.refactorTable();
												},
												
												refactorTable : function() {
													this.table.empty();
													for (var i = 0, len = this.columns.length; i < len; i++) {
														var tr = this.generateColumnTR(this.columns[i]);
														this.table.append(tr);
													}
												},
												
												generateColumnTR : function(column) {
													var imgurl = '${servletURL}?op=resource&resource=/com/fr/web/adhoc/images/columnremove.png';
													var cs = 'adhoc_design_definereport_simpledeletebutton';
													var button = $('<div/>').data('column', column);
													var self = this;
													var config = {text : 'ɾģ', css : cs, img : imgurl,
														action : function() {
															self.removeColumn(this.data('column'))
														}.createDelegate(button)};
													button.generateIconButton(config);
													button.setEnable(true);

													var sortCombo = $('<div/>').addClass('adhoc_design_definereport_crosssort');
													var listener = {};
													listener.eventName = FR.Events.AFTEREDIT;
													listener.action = function() {
														self.changeColumn(sortCombo.data('column'), self.sortCombobox.getValue());
													}.createDelegate(sortCombo);
													var config = {
														width : 70,
														editable : false,
														allowBlank : true,
														mode: 'local',
														listeners : [listener]
													};	
													config.items = this.createData();
													this.sortCombobox = sortCombo.asComponent('combo', config);
													sortCombo.data('column', column);
													
													var td = $('<td/>').addClass('adhoc_design_definereport_simplefont').text(column.columnname);
													
													var ctd = $('<td/>').append(sortCombo);
													if (column.sort != null) {
														this.sortCombobox.setValue(column.sort);
													}
													var btd = $('<td/>').append(button);
													return $('<tr/>').append(td).append(ctd).append(btd);
												},
												
												createData : function() {
													var data = [];
													data.push({text: '', value: 0});
													data.push({text: '', value: 1});
													data.push({text: '', value: 2});
													return data;
												},
												
												changeColumn : function(column, sort) {
													for (var i = 0, len = this.columns.length; i < len; i++) {
														if (column.columnname == this.columns[i].columnname) {
															this.columns[i].sort = sort;
														}
													}
												},
												
												getColumns : function() {													
													return this.columns.length ? this.columns : null;
												},
												
												clear : function() {
													this.columns = [];
													this.refactorTable();
												}
									},
									
									rowColumnBoard : {
												_init : function() {
													this.content = $('<div/>').addClass('adhoc_design_definereport_crossrows');
													this.columns = [];
													this.content.append(this.generateTable());
												},
												
												getContent : function() {
													if (!this.content) {
														this._init();
													}
													return this.content;
												},
												
												generateTable : function() {
													var rightdiv = $('<div/>').addClass('adhoc_design_definereport_crossrowsright');
													rightdiv.append(this.createTitle());
													this.table = $('<table/>').addClass('adhoc_design_definereport_crossrowstable').attr({'cellpadding': 0, 'cellspacing': 0});
													rightdiv.append($('<div/>').addClass('adhoc_design_definereport_crossrowstablecontainer').append(this.table));
													
													var table = $('<table/>').addClass('adhoc_design_definereport_crossrowswholetable');
													var td = $('<td/>').addClass('adhoc_design_definereport_crossrowsicontd');
													td.append(this.generateMoveButton());
													var dtd = $('<td/>').addClass('adhoc_design_definereport_crossrowsrighttd');
													dtd.append(rightdiv);
													return table.append($('<tr/>').append(td).append(dtd));
												},
												
												generateMoveButton : function() {
													var button = $('<div/>');
													var imgurl = '${servletURL}?op=resource&resource=/com/fr/web/adhoc/images/simplecolumnmove.png';
													var cs = 'adhoc_design_definereport_simplemovebutton';
													var self = this;
													var config = {text : 'ƶֶ', css : cs, img : imgurl,
														action : function() {
															self.addColumn();
														}};
													button.generateIconButton(config);
													button.setEnable(true);
													return button;
												},
												
												createTitle : function() {
													return $('<p/>').addClass('adhoc_design_definereport_simpledetailtitle').text('ֶ');
												},
												
												getItem : function() {
													return FR.ADHOCDESIGN.centerDesign.designFaces.defineReportFace.crossReport.fieldsListPane.getSelectedItem();
												},
												
												addColumn : function() {
													var column = {columnname: this.getItem(), sort: 0};
													if (this.isExist(column)) {
														return;
													}
													this.columns.push(column);
													this.refactorTable();
												},
												
												isExist : function(column) {
													for (var i = 0, len = this.columns.length; i < len; i++) {
														if (column.columnname == this.columns[i].columnname) {
															return true;
														}
													}
													return false;
												},
												
												removeColumn : function(column) {
													this.columns.remove(column);
													this.refactorTable();
												},
												
												refactorTable : function() {
													this.table.empty();
													for (var i = 0, len = this.columns.length; i < len; i++) {
														var tr = this.generateColumnTR(this.columns[i]);
														this.table.append(tr);
													}
												},
												
												generateColumnTR : function(column) {
													var imgurl = '${servletURL}?op=resource&resource=/com/fr/web/adhoc/images/columnremove.png';
													var cs = 'adhoc_design_definereport_simpledeletebutton';
													var button = $('<div/>').data('column', column);
													var self = this;
													var config = {text : 'ɾģ', css : cs, img : imgurl,
														action : function() {
															self.removeColumn(this.data('column'))
														}.createDelegate(button)};
													button.generateIconButton(config);
													button.setEnable(true);
							
													var sortCombo = $('<div/>').addClass('adhoc_design_definereport_crossrows');
													var listener = {};
													listener.eventName = FR.Events.AFTEREDIT;
													listener.action = function() {
														self.changeColumn(sortCombo.data('column'), self.sortCombobox.getValue());
													}.createDelegate(sortCombo);
													var config = {
														width : 70,
														editable : false,
														allowBlank : true,
														mode: 'local',
														listeners : [listener]
													};	
													config.items = this.createData();
													this.sortCombobox = sortCombo.asComponent('combo', config);
													sortCombo.data('column', column);
													
													var td = $('<td/>').addClass('adhoc_design_definereport_simplefont').text(column.columnname);
													
													var ctd = $('<td/>').append(sortCombo);
													if (column.sort != null) {
														this.sortCombobox.setValue(column.sort);
													}
													var btd = $('<td/>').append(button);
													return $('<tr/>').append(td).append(ctd).append(btd);
												},
												
												createData : function() {
													var data = [];
													data.push({text: '', value: 0});
													data.push({text: '', value: 1});
													data.push({text: '', value: 2});
													return data;
												},
												
												changeColumn : function(column, sort) {
													for (var i = 0, len = this.columns.length; i < len; i++) {
														if (column.columnname == this.columns[i].columnname) {
															this.columns[i].sort = sort;
														}
													}
												},
												
												getColumns : function() {													
													return this.columns.length ? this.columns : null;
												},
												
												clear : function() {
													this.columns = [];
													this.refactorTable();
												}
									},
									
									summaryColumnBoard : {
												_init : function() {
													this.content = $('<div/>').addClass('adhoc_design_definereport_crosssummary');
													this.columns = [];
													this.content.append(this.generateTable());
												},
												
												getContent : function() {
													if (!this.content) {
														this._init();
													}
													return this.content;
												},
												
												generateTable : function() {
													var rightdiv = $('<div/>').addClass('adhoc_design_definereport_crosssummaryright');
													rightdiv.append(this.createTitle());
													this.table = $('<table/>').addClass('adhoc_design_definereport_crosssummarytable').attr({'cellpadding': 0, 'cellspacing': 0});
													rightdiv.append($('<div/>').addClass('adhoc_design_definereport_crosssummarytablecontainer').append(this.table));
													
													var table = $('<table/>').addClass('adhoc_design_definereport_crosssummarywholetable');
													var td = $('<td/>').addClass('adhoc_design_definereport_crosssummaryicontd');
													td.append(this.generateMoveButton());
													var dtd = $('<td/>').addClass('adhoc_design_definereport_crosssummaryrighttd');
													dtd.append(rightdiv);
													return table.append($('<tr/>').append(td).append(dtd));
												},
												
												generateMoveButton : function() {
													var button = $('<div/>');
													var imgurl = '${servletURL}?op=resource&resource=/com/fr/web/adhoc/images/simplecolumnmove.png';
													var cs = 'adhoc_design_definereport_simplemovebutton';
													var self = this;
													var config = {text : 'ƶֶ', css : cs, img : imgurl,
														action : function() {
															self.addColumn();
														}};
													button.generateIconButton(config);
													button.setEnable(true);
													return button;
												},
												
												createTitle : function() {
													return $('<p/>').addClass('adhoc_design_definereport_simpledetailtitle').text('ֶ');
												},
												
												getItem : function() {
													return FR.ADHOCDESIGN.centerDesign.designFaces.defineReportFace.crossReport.fieldsListPane.getSelectedItem();
												},
												
												addColumn : function() {
													if (this.columns.length > 0) {
														FR.Msg.alert(FR.i18n.Info, "ֻһΪֶΡ");
														return;
													}
													var column = {columnname: this.getItem(), funname: 'sum'};
													if (this.isExist(column)) {
														return;
													}
													this.columns.push(column);
													this.refactorTable();
												},
												
												isExist : function(column) {
													for (var i = 0, len = this.columns.length; i < len; i++) {
														if (column.columnname == this.columns[i].columnname) {
															return true;
														}
													}
													return false;
												},
												
												removeColumn : function(column) {
													this.columns.remove(column);
													this.refactorTable();
												},
												
												refactorTable : function() {
													this.table.empty();
													for (var i = 0, len = this.columns.length; i < len; i++) {
														var tr = this.generateColumnTR(this.columns[i]);
														this.table.append(tr);
													}
												},
												
												generateColumnTR : function(column) {
													var imgurl = '${servletURL}?op=resource&resource=/com/fr/web/adhoc/images/columnremove.png';
													var cs = 'adhoc_design_definereport_simpledeletebutton';
													var button = $('<div/>').data('column', column);
													var self = this;
													var config = {text : 'ɾģ', css : cs, img : imgurl,
														action : function() {
															self.removeColumn(this.data('column'))
														}.createDelegate(button)};
													button.generateIconButton(config);
													button.setEnable(true);

													var funCombo = $('<div/>').addClass('adhoc_design_definereport_crossfun');
													var listener = {};
													listener.eventName = FR.Events.AFTEREDIT;
													listener.action = function() {
														self.changeColumn(funCombo.data('column'), self.funCombobox.getValue());
													}.createDelegate(funCombo);
													var config = {
														width : 70,
														editable : false,
														allowBlank : true,
														mode: 'local',
														listeners : [listener]
													};	
													config.items = this.createData();
													this.funCombobox = funCombo.asComponent('combo', config);
													funCombo.data('column', column);
													
													var td = $('<td/>').addClass('adhoc_design_definereport_simplefont').text(column.columnname);
													
													var ctd = $('<td/>').append(funCombo);
													if (column.funname) {
														this.funCombobox.setValue(column.funname);
													}
													var btd = $('<td/>').append(button);
													return $('<tr/>').append(td).append(ctd).append(btd);
												},
												
												createData : function() {
													var data = [];
													data.push({text: '', value: 'sum'});
													data.push({text: 'ƽ', value: 'ave'});
													data.push({text: 'ֵ', value: 'max'});
													data.push({text: 'Сֵ', value: 'min'});
													data.push({text: '', value: 'count'});
													return data;
												},
												
												changeColumn : function(column, funname) {
													for (var i = 0, len = this.columns.length; i < len; i++) {
														if (column.columnname == this.columns[i].columnname) {
															this.columns[i].funname = funname;
														}
													}
												},
												
												getColumns : function() {													
													return this.columns.length ? this.columns : null;
												},
												
												clear : function() {
													this.columns = [];
													this.refactorTable();
												}
									},
									
									generateButtonPane : function() {
											this.nextButton = $('<div/>').addClass('adhoc_design_definereport_backButton');
			
											var container =  $('<div/>').addClass('adhoc_design_definereport_backButton_container').append(this.nextButton);
											var self = this;
											this.nextButton.asComponent('button', {
												text : 'һ',
												handler : function() {
													self.showBackPane();
												}
											});
											return container;										
									},
											
									showBackPane : function() {
										this.invisible();
										FR.ADHOCDESIGN.centerDesign.designFaces.defineReportFace.chooseReport.visible();	
									},
									
									getReport : function() {
										var report = {};
										if (this.summaryColumnBoard.getColumns() != null && this.summaryColumnBoard.getColumns().length > 0) {
											report.summaryColumn = this.summaryColumnBoard.getColumns();
										}
										if (this.rowColumnBoard.getColumns() != null && this.rowColumnBoard.getColumns().length > 0) {
											report.rows = this.rowColumnBoard.getColumns();
										}
										
										if (this.columnColumnBoard.getColumns() != null && this.columnColumnBoard.getColumns().length > 0) {
											report.columns = this.columnColumnBoard.getColumns();
										}
															
										report.reporttype = 1;
										return report;
									},
									
									isVisible : function() {
										return this.showing;
									},
									
									visible : function() {
										this.showing = true;
										this.content.show();
									},
									
									invisible : function() {
										this.showing = false;
										this.content.hide();
									},
									
									checkValid : function() {
										if (!this.summaryColumnBoard.getColumns() || !this.rowColumnBoard.getColumns() || !this.columnColumnBoard.getColumns()) {
											FR.ADHOCDESIGN.centerDesign.designSteps.embellishSelfButton(2);
											FR.ADHOCDESIGN.centerDesign.designFaces.defineReportFace.crossReport.popuView(FR.ADHOCDESIGN.centerDesign.designFaces.viewDataFace.getViewName());
											FR.ADHOCDESIGN.centerDesign.designFaces.defineReportFace.showCrossReport();
											FR.Msg.alert(FR.i18n.Info, "ѡֶΪֶΡֶΡֶΡ");
																				
											return false;
										}
										return true;
									}
								},
								
							showSimpleReport : function() {
								this.visible();
								this.simpleReport.visible();
								this.chooseReport.invisible();
								this.crossReport.invisible();
							},
							
							showCrossReport : function() {
								this.visible();
								this.simpleReport.invisible();
								this.chooseReport.invisible();
								this.crossReport.visible();
							},
							
							checkValid : function() {
								if (this.chooseReport.getReportType() == 0) {
									return this.simpleReport.checkValid();
								} else {
									return this.crossReport.checkValid();
								}
							},
							
							getReport : function() {
								var report = {};
	
								if (this.chooseReport.getReportType() == 0) {
									report = this.simpleReport.getReport();
								} else {
									report = this.crossReport.getReport();
								}
								
								report.title = this.chooseReport.getTitle();
								report.subtitle = this.chooseReport.getSubTitle();
								return report;
							},
							
							visible : function() {
								if (this.simpleReport.isVisible()) {
									this.simpleReport.popuView(FR.ADHOCDESIGN.centerDesign.designFaces.viewDataFace.getViewName());
								} else if (this.crossReport.isVisible()) {
									this.crossReport.popuView(FR.ADHOCDESIGN.centerDesign.designFaces.viewDataFace.getViewName());
								}
								this.content.show();
							},
							
							invisible : function() {
								this.content.hide();
							}
						},
					
					chooseStyleFace :  {
							_init : function() {
								this.content = $('<div/>').addClass('adhoc_design_choosestyle');
								this.content.append(this.styleList.getContent());
								this.content.append(this.styleView.getContent());
							},
							
							getContent : function() {
								if (!this.content) {
									this._init();
								}
								return this.content;							
							},
							
							defaultState : function() {
								this.styleList.defaultState();
							},
							
							styleList : {
										_init : function() {
											this.content = $('<div/>').addClass('adhoc_design_choosestyle_list');
											var config = {};
											var self = this;
											config.data = this.createStyleData();
											config.onnodeclick  = function() {
												self.clickNode()
											};
											config.title = 'ѡʽ';
											config.titleClass = 'adhoc_design_choosestyle_listtitle';
											this.content.jlist(config);
										},
										
										getContent : function() {
											if (!this.content) {
												this._init();
											}
											return this.content;
										},
										
										defaultState : function() {
											this.content.setSelectedItem(this.createStyleData()[0]);
										},
										
										clickNode : function() {
											FR.ADHOCDESIGN.centerDesign.designFaces.chooseStyleFace.styleView.showStyle(this.getSelectedIndex());
										},
										
										createStyleData : function() {
											var styles = [];
											styles.push('ͨ');
											styles.push('');
											styles.push('');
											styles.push('');
											return styles;
										},
										
										getSelectedIndex : function() {
											return this.content.getSelectedIndex();
										}
									},
								
								styleView : {
									_init : function() {
										this.content = $('<div/>').addClass('adhoc_design_view');
										this.img = $('<img/>').addClass('adhoc_design_view_img');
//										this.content.append(this.generateTitle());
										this.content.append(this.img);
										this.invisible();
									},
									
									getContent : function() {
										if (!this.content) {
											this._init();
										}
										return this.content;
									},
									
									generateTitle : function() {
										return $('<div/>').addClass('adhoc_design_view_title').append($('<p/>').text('Ԥ'));
									},
									
									showStyle : function(style) {
										this.visible();
										this.changeStyle(style);
									},
									
									changeStyle : function(style) {
										var source = this.getStyleSource(style);
										this.img.attr('src', source);
									},
									
									
									getStyleSource : function(style) {
										if (!this.sources) {
											this.setSource(0);
										}
										
										return this.sources[style];
									},
									
									changeSource : function(type) {
										this.setSource(type);
										this.changeStyle(FR.ADHOCDESIGN.centerDesign.designFaces.chooseStyleFace.styleList.getSelectedIndex());
									},
									
									setSource : function(type) {
										if (type == 0) {
											this.sources = this.createSimpleSources();
										} else {
											this.sources = this.createCrossSources();
										}
									},
									
									createSimpleSources : function() {
										var sources = [];
										var img  = '${servletURL}?op=resource&resource=/com/fr/web/adhoc/images/adhoc_design_choosestyle_simple';
										for (var i = 1; i < 5; i++) {
											sources.push(img + i + '.png');
										}

										return sources;
									},
									
									createCrossSources : function() {
										var sources = [];
										var img  = '${servletURL}?op=resource&resource=/com/fr/web/adhoc/images/adhoc_design_choosestyle_cross';
										for (var i = 1; i < 5; i++) {
											sources.push(img + i + '.png');
										}

										return sources;
									},
									
									visible : function() {
										this.content.show();
									},
									
									invisible : function() {
										this.content.hide();
									}
								},
								
								getStyle : function() {
									return this.styleList.getSelectedIndex();
								},
								
								checkValid : function() {
									if (this.getStyle() < 0) {
										FR.ADHOCDESIGN.centerDesign.designSteps.embellishSelfButton(3);
										this.visible();
										FR.Msg.alert(FR.i18n.Info, "ѡʽ");
																				
										return false;
									}
									return true;
								},
								
								visible : function() {
									this.content.show();
								},
								
								invisible : function() {
									this.content.hide();
								}
							},
					
					viewReportFace : {
							_init : function() {
								this.content = $('<div/>').addClass('adhoc_design_viewreport');
								this.iframe = $('<iframe/>').addClass('adhoc_design_viewreport_iframe');
								this.content.append(this.iframe);
							},
							
							getContent : function() {
								if (!this.content) {
									this._init();
								}
								return this.content;
							},
							
							viewReport : function() {
								var report = this.generateCompleteReport();
								if (this.report == report) {
									return;
								}
								this.report = report;
								this.iframe.attr('src', this.createSource(report));
							},
							
							createSource : function(report) {
								return '${servletURL}?reportlet=adhocreport&adhocconfig=' + FR.cjkEncode(FR.jsonEncode(report));
							},
							
							generateCompleteReport : function() {
								var report = {};
								report.viewname = FR.ADHOCDESIGN.centerDesign.designFaces.viewDataFace.getViewName();
								
								report.condition = {commonconditions: FR.ADHOCDESIGN.centerDesign.designFaces.filterDataFace.getConditions()};
								
								$.extend(report, FR.ADHOCDESIGN.centerDesign.designFaces.defineReportFace.getReport());
								
								if (FR.ADHOCDESIGN.centerDesign.designFaces.defineReportFace.chooseReport.getReportType() == 0) {
									report.simplestyle = FR.ADHOCDESIGN.centerDesign.designFaces.chooseStyleFace.getStyle();
								} else if (FR.ADHOCDESIGN.centerDesign.designFaces.defineReportFace.chooseReport.getReportType() == 1) {
									report.crossedstyle = FR.ADHOCDESIGN.centerDesign.designFaces.chooseStyleFace.getStyle();
								}
								
								return report;
							},
							
							checkValid : function() {
								return FR.ADHOCDESIGN.centerDesign.designFaces.viewDataFace.checkValid() 
									&& FR.ADHOCDESIGN.centerDesign.designFaces.filterDataFace.checkValid()
									&& FR.ADHOCDESIGN.centerDesign.designFaces.defineReportFace.checkValid()
									&& FR.ADHOCDESIGN.centerDesign.designFaces.chooseStyleFace.checkValid();;
							},
							
							showReport : function() {
								if (!this.checkValid()) {
									return false;
								}
								this.viewReport();
								this.content.show();
								return true;
							},
							
							invisible : function() {
								this.content.hide();
							}
						}
				}
			});
		}
	});
});