FR.ADHOCUI = {};


$.extend(FR.ADHOCUI, {
		createStepButton : function(button, config) {
			var newconfig = {};
			$.extend(newconfig, config, {editable : true});
			$.extend(button, {
			_initButton : function() {
				var self  = this;
	
				this.text(newconfig.text).addClass(newconfig.css).click(function(e) {
					if (!this.isEnable()) {
						return;
					}
					this.activeState();
					newconfig.action(e);
				}.createDelegate(self));
				this.setEnable(newconfig.editable);
			},
			
			activeState : function() {
				this.addClass('adhoc_active_button');
			},
			
			removeActiveState : function() {
				this.removeClass('adhoc_active_button');
			},
			
			setEnable : function(editable) {
				this.editable = editable;
				editable ? this.removeClass('adhoc_button_disable') : this.addClass('adhoc_button_disable');
			},
			
			isEnable : function() {
				return this.editable;
			}
			});
		button._initButton();
	}
});


$.fn.generateIconButton = function(config) {
	this.config = {};
	$.extend(this.config, config, {editable : false});

	$.extend(this, {
		_initIconButton : function() {
			var self  = this;
			var img = $('<img/>').attr('src', this.config.img).attr('alt', this.config.text);
			this.attr('title', this.config.text).addClass(this.config.css).append(img).click(function(e) {
				if (!this.isEnable()) {
					return;
				}
				this.config.action(e);
			}.createDelegate(self));
			this.setEnable(this.config.editable);
		},
		
		setEnable : function(editable) {
			this.editable = editable;
			editable ? this.removeClass('adhoc_iconbutton_disable') : this.addClass('adhoc_iconbutton_disable');
		},
		
		isEnable : function() {
			return this.editable;
		}
	});
	this._initIconButton();
};

	$.fn.jlist = function(opts){
		var op = {
			onnodeclick:false,
			cpPrefix: "_list_",
			url:false,
			operation: {addaction:false, deleteaction:false, renameaction:false},
			data:[]
		}
		$.extend(op, opts);
		if (op.url){
			$.ajax({
				url : op.url,
				type : "POST",
				async : false,
				dataType : "json",
				success: function(res){
					op.data = res;
				},
                error: function(e) { alert("error occur!"); }
			});
		}
		
		var me = $(this);
        var meid = me.attr("id");
        if (meid == null || meid == "") {
            meid = "jquery_jlist" + new Date().getTime();
            me.attr("id", meid);
        }

        var html = [];
        buildControlList(op.data, html);
        me.addClass("bbit-cp-bwrap").html(html.join(""));	
        initEvent(me);
        
        function buildControlList(data, ht){
        	ht.push("<div class='bbit-cp-body'>");
        	ht.push("<ul class='available bbit-cp-content'>");
        	ht.push(buildListHead());
        	var len = data.length;
        	for (var i = 0; i < len; i ++){
        		addItem(data[i], ht, i);
        	} 
        	ht.push("</ul>");
        	ht.push("</div>");     	
        }
        
        function buildListHead() {
        	var head = "";
        	if (op.title != null) {
        		head = "<li class='bbit-cp-headnode " + op.titleClass + "'>" + op.title + "</li>";
        	}
        	return head;
        }
        
		function addItem(item, ht, index){
			ht.push("<li class='bbit-cp-node' id='", meid, op.cpPrefix,index,"'>");
			ht.push("<div class='bbit-cp-node-el'>");
			//ht.push("<img class='bbit-cp-node-icon' src='", op.iconpath, "'>");
			ht.push("<a hideFocus class='bbit-cp-node-anchor' tabIndex=1>");
            ht.push("<span unselectable='on'>", item.text ? item.text : item, "</span>");
            ht.push("</a>");
			ht.push("</div>");
			ht.push("</li>");
		}
		
		function initEvent(parent){
			var nodes = $("li.bbit-cp-node", me);
			nodes.each(function(i, item){
				$(this).hover(function(){
					$(this).addClass("bbit-cp-node-over");
				}, function(){
					$(this).removeClass("bbit-cp-node-over");
				}).unbind("click", doSelected).bind("click", doSelected)
			});
		}
		
		function doSelected(e){
			var id = $(this).attr("id");  
			var index = getItemIndex(id);
			if (op.cindex == index) {
				return;
			}    
            if (op.cindex){
            	$("#"+ meid + op.cpPrefix + op.cindex).removeClass("bbit-cp-node-selected");
            }
            var oldItem = op.cindex ? op.data[op.cindex] : null; 
            
            var newItem = op.data[index];
            
            op.cindex = index;
            $(this).addClass("bbit-cp-node-selected");
            if (op.onnodeclick){
            	op.onnodeclick(newItem);
            }                
		}
		
		function selectedItem(item) { 
			var index = getItemObIndex(item);
			if (index == null) {
				op.cindex = null;
				return;
			}

			if (op.cindex == index) {
				return;
			} 
            if (op.cindex != null){
            	$("#"+ meid + op.cpPrefix + op.cindex).removeClass("bbit-cp-node-selected");
            }
             
            
            op.cindex = index;
            $("#"+ meid + op.cpPrefix + op.cindex).addClass("bbit-cp-node-selected");
            if (op.onnodeclick){
            	op.onnodeclick(item);
            }  
		}
		
		function getItemObIndex(item) {
			if (!item) {
				return;
			}
			var index = 0;
			$.each(op.data, function(i) {
				if (op.data[i] == item || op.data[i].text == item) {
					index = i;
					return false;
				}
			});
			return index;
		}
		
		function getItemIndex(id){			
			id = id.replace(meid + op.cpPrefix, "");
			return id;
		}
		
		function getAllData() {
			return op.data;
		}
		
		function doAddItems(items) {
			for (var i = 0, len = items.length; i < len; i++) {
				var item = items[i];
				op.data.push(item);
				var ht = [];
				addItem(item, ht, op.data.length - 1);
				$("ul.bbit-cp-content", me).append(ht.join(""));
				initEvent(me);
			}			
		}

		function doAddItem(item){
			op.data.push(item);
			var ht = [];
			addItem(item, ht, op.data.length - 1);
			$("ul.bbit-cp-content", me).append(ht.join(""));
			initEvent(me);
			
			if (op.operation.addaction){
				op.operation.addaction.call(this, item);
			}
			selectedItem(item);					
		}
		// ɾ
		function doDeleteItem(){
			var currentIndex = getSelectedIndex();
			var item = getSelectedItem();
			if (currentIndex == -1){
				FR.Msg.alert(FR.i18n.Info, FR.i18n.Privilege_Selected_None_Of_Any_Items + "!");
				return false;
			}
			var orgLen = op.data.length;
			// richer:ɾԪ
			op.data.splice(currentIndex, 1);
			// richer:idҪӦı仯
			$("#" + meid + op.cpPrefix + currentIndex, me).remove();
			for (var i = currentIndex; i < orgLen; i ++){
				var cid = meid + op.cpPrefix + i;
				var nid = meid + op.cpPrefix + (i - 1);
				$("#" + cid, me).attr("id", nid);
			}
//			var next = $("#" + meid + op.cpPrefix + currentIndex);		
//			if (next.length != 0){
//				next.addClass("bbit-cp-node-selected");
//			}
			var newItem;
			if (op.data.length > currentIndex) {
				newItem = op.data[currentIndex];
			} else if (op.data.length > 0) {
				newItem = op.data[op.data.length - 1]
			}
			selectedItem(newItem);
			if (op.operation.deleteaction){
				op.operation.deleteaction.call(this, item, newItem);
			}
		}
		// ༭
		function doEditItem() {
			var oldname = getSelectedItem();
			FR.showDialog("", 270, 120, eidtDialogContent(oldname));
		}
		
		function reName(item) {
			var oldname = getSelectedItem();
			// richer:Ҫıʾֵ
			var li = $("#" + meid + op.cpPrefix + getSelectedIndex());
			$("span", li).text(item);
			if (op.operation.renameaction && oldname != item){
				op.operation.renameaction.call(this, item, oldname);
			}
			setSelectedItem(item);
		}
		
		function eidtDialogContent(name) {
			var dialogContent = $('<div/>').addClass('adhoc_dataset_editDialog');
			var sp = $('<span/>').addClass('adhoc_dataset_editDialog_title').text('Դƣ');
			var nameContent = $('<input/>').attr('type', 'text').addClass('adhoc_dataset_editDialog_text');
			sp.append(nameContent);
			nameContent.val(name);
			var button = $('<div/>').addClass('adhoc_dataset_editDialog_submit');
			var bt = $('<div/>');
			dialogContent.append(sp);
			dialogContent.append(button.append(bt));
									
			var self = this;
			bt.asComponent('button', {
				text : 'ȷ',
				handler : function() {								
					reName(nameContent.val());
					FR.closeDialog();
				}
			});

			return dialogContent;
		}
		
		function doClear(){
			op.data = [];
			$(".bbit-cp-node", me).remove();
		}
		
		// null:none selected
		function getSelectedItem(){
			var index = getSelectedIndex();
			return index != -1 ? op.data[index] : null;
		}
		
		function setSelectedItem(item) {
			var index = getSelectedIndex();
			op.data[index] = item;
		}
		
		// -1:none selected
		function getSelectedIndex(){
			var currentLi = $("li.bbit-cp-node-selected", me);
			var index = currentLi.length != 0 ? currentLi.attr("id").replace(meid + op.cpPrefix, "") : -1;
			return index;
		}
		
		function hasSameName(name) {
			var same = false;
			$.each(op.data, function(i) {
				if (op.data[i] == name) {
					same = true;
					return false;
				}
			});
			return same;
		}

		me[0].t = {
			hasSameName : function(name) {
				hasSameName(name);
			},
			addItems : function(items) {
				doAddItems(items);
			},
			addItem : function(item){
				doAddItem(item);
			},
			removeItem : function() {
				doDeleteItem();
			},
			editItem : function() {
				doEditItem();
			},
			clear : function(){
				doClear();
			},
			getText : function(){
				var item = getSelectedItem();
				return item != null ? item : null;
			},
			getValue : function(){
				var item = getSelectedItem();
				return item != null ? FR.jsonDecode(item) : null;
			},
			getItem : function(){
				var item = getSelectedItem();
				return item;
			},
			getAllData : function() {
				return getAllData();
			},
			getSelectedIndex : function() {
				return getSelectedIndex();
			},
			setSelectedItem : function(item) {
				selectedItem(item);
			}
		};
		
		return me;
	}
	$.fn.getSelectedIndex = function() {
		if (this[0].t) {
			return this[0].t.getSelectedIndex();
		}
	};
	
	$.fn.setSelectedItem = function(item) {
		if (this[0].t) {
			return this[0].t.setSelectedItem(item);
		}
	};
	
	$.fn.hasSameName = function(name) {
		if (this[0].t) {
			return this[0].t.hasSameName(name);
		}
	}
	
    $.fn.getListItem = function() {
        if (this[0].t) {
            return this[0].t.getItem();
        }
        return null;
    }
    
    $.fn.addItems = function(items) {
    	if (this[0].t) {
    		return this[0].t.addItems(items);
    	} 
    }
    
    $.fn.addListItem = function(item){
    	if (this[0].t) {
    		return this[0].t.addItem(item);
    	}
    }
    $.fn.removeListItem = function(){
    	if (this[0].t) {
    		return this[0].t.removeItem();
    	}
    }
    $.fn.editListItem = function(item){
    	if (this[0].t) {
    		return this[0].t.editItem(item);
    	}
    }
    
    $.fn.getAllData = function(){
    	if (this[0].t) {
    		return this[0].t.getAllData();
    	}
    }

    $.fn.clearList = function(){
    	if (this[0].t){
    		this[0].t.clear();
    	}
    }


