// Edit.JS
;FR.EDIT = {};

$.extend(FR.EDIT, {	
	_init : function() {
		this.$mainpane = $('body').children('#fr-edit-main:eq(0)');
		var $toolBar = this._initToolBar();
		this._init_vp();
		this._init_sheetcontrol();
		this.$nousepane = this.$mainpane.children('#fr-edit-unusepane:eq(0)');
		this.$contentpane = this.$mainpane.children('#fr-edit-contentpane:eq(0)');
		this.$popbox = this.$mainpane.children('#fr-edit-popbox:eq(0)');
	},
		
	_initToolBar : function() {
		this.$northpane = this.$mainpane.children("#fr-edit-north:eq(0)");
		var $start = $("#fr-edit-button-start:eq(0)", this.$northpane);
		var self = this;
		
		var $td_container = $("<td></td>");
		this.$button_undo = $("<div></div>").appendTo($td_container)
		.asComponent("editiconbutton", {name : "undo", title : "Undo", render : false, handler : function() {
			self.undo();
		}});
		this.$button_undo.disable();
		$start.after($td_container);
		$start = $td_container;
		
		$td_container = $("<td></td>");
		this.$button_redo = $("<div></div>").appendTo($td_container)
		.asComponent("editiconbutton", {name : "redo", title : "Redo", render : false, handler : function() {
			self.redo();
		}});
		this.$button_redo.disable();
		$start.after($td_container);
		$start = $td_container;
		
		$td_container = $("<td></td>");
		this.$button_save = $("<div></div>").appendTo($td_container)
		.asComponent("editiconbutton", {name : "save", title : "Save", render : false, handler : function() {
			self.saveReport();
		}});
		$start.after($td_container);
		$start = $td_container;
		
		$td_container = $("<td></td>");
		this.$button_export = $("<div></div>").appendTo($td_container)
		.asComponent("editiconbutton", {name : "export", title : "Export", render : false, handler : function() {
			self.popExportMenu();
		}});
		$start.after($td_container);
		$start = $td_container;
		
		$td_container = $("<td></td>");
		this.$button_print = $("<div></div>").appendTo($td_container)
		.asComponent("editiconbutton", {name : "print", title : "Print", render : false, handler : function() {
			self.printPreview();
		}});
		$start.after($td_container);
		$start = $td_container;
			
        $('#fr-edit-toolbar-fc-td:eq(0)', this.$northpane).asComponent("editcolormenubutton", {cfn : "FontColor", left : 398, handler : function(){
        	var color = self.$colorpicker.color;
        	this.$inner_box.css("border-color", color).attr("clr", color);
        	self._setFontColor(color);
        }});
		$('#fr-edit-toolbar-bc-td:eq(0)', this.$northpane).asComponent("editcolormenubutton", {cfn : "BackgroundColor", left : 598, handler : function(){
        	var color = self.$colorpicker.color;
        	this.$inner_box.css("border-color", color).attr("clr", color);
        	self._setBackgroundColor(color);
        }});
		
        $.each($start.parent().children('td[tf]'), function(idx, item){
        	var $item = $(item);
        	var tf = $item.attr('tf');
        	$item.asComponent("editfontbutton", {handler : function(){
        		self['_setFont_' + tf]();
        	}});
        });
        
        $('#fr-edit-toolbar-br-td:eq(0)', this.$northpane).asComponent("editmenubutton", {handler : function(){
        	self._popBorderMenu();
        }});
        
        $('#fr-edit-toolbar-al-td:eq(0)', this.$northpane).asComponent("editmenubutton", {handler : function(){
        	self._popAlignMenu();
        }});
	},
		
	_create_toolbar_separator : function() {
		return $("<div class='fr-edit-toolbar-separator edit-inline-block'></div>");
	},
	
	_init_vp : function() {
		var $vp = this.$northpane.children("#fr-edit-vppane:eq(0)");
		this.$vp_position = $("#fr-edit-vp-position:eq(0)", $vp);
		this.$vp_editor = $("#fr-edit-vp-text:eq(0)", $vp).asComponent("vpeditor", {});
		return $vp;
	},
	
	_init_sheetcontrol : function() {
		this.$sheetscrollpane = this.$mainpane.children("#fr-edit-sheetscrollpane:eq(0)");
		this.$sheetbuttonbox = $("#fr-edit-sheettablist-buttonbox:eq(0)", this.$sheetscrollpane);
		var $container = $("#fr-edit-sc-bt:eq(0)", this.$sheetscrollpane);
		var $table = $("table:eq(0)", this.$sheetbuttonbox);
		$table.data("ml", 0);
		var box_length = this.$sheetscrollpane.width() - 500 - 72;
		this.$sheetbuttonbox.width(box_length);
		var self = this;
		var $td = $("<td></td>").append().appendTo($container);
		$("<div></div>").appendTo($td).asComponent("sheetcontrolbutton", {name: "arrow1", render : false, handler : function() {
			$table.css("margin-left", 0);
			$table.data("ml", 0);
		}});
		
		$td = $("<td></td>").append().appendTo($container);
		$("<div></div>").appendTo($td).asComponent("sheetcontrolbutton", {name: "arrow2", render : false, handler : function() {
			var ml = $table.data("ml");
			ml = ml + 72;
			if (ml > 0) ml = 0;
			$table.css("margin-left", ml);
			$table.data("ml", ml);
		}});
		
		$td = $("<td></td>").append().appendTo($container);
		$("<div></div>").appendTo($td).asComponent("sheetcontrolbutton", {name: "arrow3", render : false, handler : function() {
			if (!self.contentPane.tab_length) return;
			var ml = $table.data("ml");
			ml = ml - 72;
			if (box_length - ml > self.contentPane.tab_length) {
				ml = box_length - self.contentPane.tab_length;
				if (ml > 0) ml = 0;
			}
			$table.css("margin-left", ml);
			$table.data("ml", ml);
		}});
		
		$td = $("<td></td>").append().appendTo($container);
		$("<div></div>").appendTo($td).asComponent("sheetcontrolbutton", {name: "arrow4", render : false, handler : function() {
			if (!self.contentPane.tab_length) return;
			var ml = box_length - self.contentPane.tab_length;
			if (ml > 0) ml = 0;
			$table.css("margin-left", ml);
			$table.data("ml", ml);
		}});
	},
	
	undo : function() {
		var pane = this.contentPane.curLGP;
		if (pane.do_idx > pane.undo_fn_array.length -1) return;
		var fO = pane.undo_fn_array[pane.do_idx];
		if (fO != null) {
			if (FR.isArray(fO)) {
				$.each(fO, function(idx, item) {
					item.fn.apply(item.scope, item.args);
				});
			} else {
				fO.fn.apply(fO.scope, fO.args);
			}
			pane.do_idx ++;
		}
		
		this.checkUnDoReDoEnable(pane);
	},
	
	redo : function() {
		var pane = this.contentPane.curLGP;
		if (pane.do_idx < 1) return;
		var fO = pane.redo_fn_array[pane.do_idx - 1];
		if (fO != null) {
			if (FR.isArray(fO)) {
				$.each(fO, function(idx, item) {
					item.fn.apply(item.scope, item.args);
				});
			} else {
				fO.fn.apply(fO.scope, fO.args);
			}
			pane.do_idx --;
		}
		
		this.checkUnDoReDoEnable(pane);
	},
	
	addAction : function(undo_fn, redo_fn) {
		if (undo_fn == null || redo_fn == null) return;
		var pane = this.contentPane.curLGP;
		if (pane.do_idx > 0) {
			for (var i = 0; i < pane.do_idx; i++) {
				pane.undo_fn_array.shift();
				pane.redo_fn_array.shift();
			}
			pane.do_idx = 0;
		}
		pane.undo_fn_array.unshift(undo_fn);
		pane.redo_fn_array.unshift(redo_fn);
		
		// ֻ30
		if (pane.undo_fn_array.length > 30) {
			for (var i = 0; i < pane.undo_fn_array - 50; i++) {
				pane.undo_fn_array.pop();
				pane.redo_fn_array.pop();
			}
		}
		
		this.checkUnDoReDoEnable(pane);
	},
	
	checkUnDoReDoEnable : function(pane) {
		if (pane.do_idx > 0) {
			this.$button_redo.enable();
		} else {
			this.$button_redo.disable();
		}
		
		if (pane.do_idx < pane.undo_fn_array.length) {
			this.$button_undo.enable();
		} else {
			this.$button_undo.disable();
		}
	},
	
	printPreview : function() {
		var self = this;
        this.saveData({fn:function(res, status) {
            window.open(self.contentPane.servletURL + "?op=printpreview&__pi__=false&sessionID=" + self.contentPane.currentSessionID ,"_blank", "Scrollbar=yes,Resizable=yes,fullscreean=yes");
        }});
    },
    
    exportReportToPDF:function(extype) {
    	var self = this;
        this.saveData({fn:function(res, status) {
            window.location = self.contentPane.servletURL + "?op=export&sessionID=" + self.contentPane.currentSessionID + "&format=pdf&extype=" + extype;
        }});
    },
    
    exportReportToExcel:function(extype) {
    	var self = this;
        this.saveData({fn:function(res, status) {
            window.location = self.contentPane.servletURL + "?op=export&sessionID=" + self.contentPane.currentSessionID + "&format=excel&extype=" + extype;
        }});
    },
    
    exportReportToWord:function() {
    	var self = this;
        this.saveData({fn:function(res, status) {
            window.location = self.contentPane.servletURL + "?op=export&sessionID=" + self.contentPane.currentSessionID + "&format=word";
        }});
    },
    
    popExportMenu : function() {
    	if (!this.export_menu) {
    		var self = this;
    		this.export_menu = [];
    		this.export_menu[0] = {iconSrc : "css:x-emb-pdf", showIconSrc : true, showTextSrc : true, src : 'PDF', handler : function(){
    			self.exportReportToPDF('ori');
    		}};
    		this.export_menu[1] = {iconSrc : "css:x-emb-excel", showIconSrc : true, showTextSrc : true, src : "Excel(ҳ)", handler : function(){
    			self.exportReportToExcel('page');
    		}};
    		this.export_menu[2] = {iconSrc : "css:x-emb-excel", showIconSrc : true, showTextSrc : true, src : "Excel(ԭ)", handler : function(){
    			self.exportReportToExcel('simple');
    		}};
    		this.export_menu[3] = {iconSrc : "css:x-emb-word", showIconSrc : true, showTextSrc : true, src : "Word", handler : function(){
    			self.exportReportToWord();
    		}};
    	}
    	FR.showMenuByEl({
			destroyOnClose : true,
			items : this.export_menu,
			minWidth: 175
		}, this.$button_export.element);
    },
	
	_resize : function() {
		this.$container.doLayout();
		this.contentPane._setScrollBar();
		var box_length = parseInt(this.$sheetscrollpane.css("width")) - 500 - 72;
		this.$sheetbuttonbox.width(box_length);
	},
	
	_popFontFamilyMenu : function() {
		this._initPopFontFamilyMenu();
		$(document).bind("mousedown", this.ff_hide);
		
		this.$font_family_pop_menu.show();
	},
	
	_initPopFontFamilyMenu : function() {
		if (!this.$font_family_pop_menu) {
			this.font_familys = [
			{fn : 'Arial', sfn : 'Arial', cls : 'fnar'}, 
			{fn : 'Courier New', sfn : 'Courier New', cls : 'fncn'},
			{fn : 'Comic Sans MS', sfn : 'Comic Sans MS', cls : 'fncs'},
			{fn : 'Georgia', sfn : 'Georgia', cls : 'fnga'},
			{fn : 'Garamond', sfn : 'Garamond', cls : 'fngd'},
			{fn : 'Lucida Console', sfn : 'Lucida Console', cls : 'fnlc'},
			{fn : 'MS Sans Serif', sfn : 'MS Sans Serif', cls : 'fnms'},
			{fn : 'Times New Roman', sfn : 'Times New Roman', cls : 'fntn'},
			{fn : 'Tahoma', sfn : 'Tahoma', cls : 'fnta'},
			{fn : 'Verdana', sfn : 'Verdana', cls : 'fnva'},
			{fn : 'SimHei', sfn : '', cls : 'fnsh'},
			{fn : 'Microsoft YaHei', sfn : '΢ź', cls : 'fnyh'},
			{fn : 'SimSun', sfn : '', cls : 'fnss'},
			{fn : 'KaiTi', sfn : '', cls : 'fnkt'}
			];
			
			this.$font_family_pop_menu = $('#fr-edit-pop-fontfamily:eq(0)', this.$popbox);
			this.$font_family_pop_menu.css({top : 28, left : 225 + ($.browser.msie ? 5 : 0)});
			var $tbody = $('tbody:eq(0)', this.$font_family_pop_menu);
			this.$font_family_pop_items = [];
			var self = this;
			$.each(this.font_familys, function(idx, item) {
				self.$font_family_pop_items[idx] = $('<tr><td></td><td><p class="fr-edit-pop-ff ' + self.font_familys[idx].cls + '">' + self.font_familys[idx].sfn + '</p></td></tr>').appendTo($tbody);
				self.$font_family_pop_items[idx].mousedown(function(e){
					self._showFontFamily(idx);
					self._setFontFamily(idx);
				});
			});
			
			this.$popbox_ff_selected_item = $('<div class="fr-edit-pop-selected-outterbox"><div class="fr-edit-pop-edit-selected-fixbox"><div class="fr-edit-pop-edit-selected"></div></div></div>');
			this.$font_family_text = $('#fr-edit-toolbar-font:eq(0)', this.$northpane);
			
			this.ff_hide = function(e) {
				var src = $(e.target);
				if (src.parent("#fr-edit-pop-fontfamily:eq(0)").length <= 0) {
					if (FR.EDIT.$font_family_pop_menu.css('display') != 'none') {
						FR.EDIT.$font_family_pop_menu.hide();
						$(document).unbind("mousedown", self.ff_hide);
					}
				}
			};
		}
	},
	
	_popFontSizeMenu : function() {
		this._initPopFontSizeMenu();
		$(document).bind("mousedown", this.fs_hide);
		
		this.$font_size_pop_menu.show();;
	},
	
	_initPopFontSizeMenu : function() {
		if (!this.$font_size_pop_menu) {
			this.font_sizes = [8,9,10,11,12,13,14,16,18,20,24,26];
			
			this.$font_size_pop_menu = $('#fr-edit-pop-fontsize:eq(0)', this.$popbox);
			this.$font_size_pop_menu.css({top : 28, left : 332});
			var $tbody = $('tbody:eq(0)', this.$font_size_pop_menu);
			this.$font_size_pop_items = [];
			var self = this;
			$.each(this.font_sizes, function(idx, item) {
				self.$font_size_pop_items[idx] = $('<tr><td></td><td><p class="fr-edit-pop-fs">' + self.font_sizes[idx] + '</p></td></tr>').appendTo($tbody);
				self.$font_size_pop_items[idx].mousedown(function(e){
					self._showFontSize(idx);
					self._setFontSize(idx);
				});
			});
			
			this.$popbox_fs_selected_item = $('<div class="fr-edit-pop-selected-outterbox"><div class="fr-edit-pop-edit-selected-fixbox"><div class="fr-edit-pop-edit-selected"></div></div></div>');
			this.$font_size_text = $('#fr-edit-toolbar-fontsize:eq(0)', this.$northpane);
			var self = this;
			this.fs_hide = function(e) {
				var src = $(e.target);
				if (src.parent("#fr-edit-pop-fontsize:eq(0)").length <= 0) {
					if (FR.EDIT.$font_size_pop_menu.css('display') != 'none') {
						FR.EDIT.$font_size_pop_menu.hide();
						$(document).unbind("mousedown", self.fs_hide);
					}
				}
			};
		}
	},
	
	_showFontFamily : function(idx, cell) {
		this._initPopFontFamilyMenu();
		var self = this;
		if (cell) {
			idx = null;
			var ff = cell.css('font-family');
			if (ff) {
				if (ff.startWith("'")) ff = ff.substring(1, ff.length - 1);
				$.each(this.font_familys, function(index, item){
					if (item.fn == ff) {
						idx = index; 
						return false;
					}
				});
				
				if (idx == null) {
					this.$font_family_text.text(ff);
				}
			}
		}
		
		if (idx != null) {
			this.$font_family_text.text(this.font_familys[idx].sfn);
			if (!this.$font_family_pop_items[idx].setd) {
				this.$font_family_pop_items[idx].setd = $('td:eq(0)', this.$font_family_pop_items[idx]);
			}
			this.$font_family_pop_items[idx].setd.append(this.$popbox_ff_selected_item);
		} else {
			this.$nousepane.append(this.$popbox_ff_selected_item);
		}
	},
	
	_setFontFamily : function(idx, cells) {
		var ff = idx;
		if (typeof idx == 'number') {
			ff = this.font_familys[idx].fn;
		}
		var self = this;
		var curPane = this.contentPane.curLGP;
		var cell;
		var action = true;
		if (cells == null) {
			cells = curPane.currentTDCells;
		} else {
			action = false;
		}
		var undo_fns = [];
		var redo_fns = [];
		if (cells) {
			$.each(cells, function(index, item) {
				self._setCellFontFamily(item, ff, action, undo_fns, redo_fns, curPane);
			});
		} else {
			cell = curPane.currentTDCell;
			if (cell) {
				this._setCellFontFamily(cell, ff, action, undo_fns, redo_fns, curPane);
			}
		}
		
		if (action) {
			this.addAction(undo_fns, redo_fns);
		}
		
		curPane.displayFD(curPane.currentTDCell, false);
	},
	
	_setCellFontFamily : function(tdCell, ff, action, undo_fns, redo_fns, curPane) {
		var cell = tdCell.cell;
		if (action) {
			undo_fns.push({fn : this._setFontFamily, scope : this, args : [cell.css('font-family'), [tdCell]]});
			redo_fns.push({fn : this._setFontFamily, scope : this, args : [ff, [tdCell]]});
		}
		cell.css('font-family', ff);
		cell.attr('ff', ff);
		cell.ff = ff;
		cell.dirty = true;
		curPane.shrink2FitRowHeight(tdCell);
	},
	
	_showFontSize : function(idx, cell) {
		this._initPopFontSizeMenu();
		var self = this;
		if (cell) {
			idx = null;
			var fs = cell.css('font-size');
			if (fs) {
				fs = parseInt(fs);
				$.each(this.font_sizes, function(index, item){
					if (item == fs) {
						idx = index; 
						return false;
					}
				});
				
				if (idx == null) {
					this.$font_size_text.text(fs);
				}
			}
		}
		
		if (idx != null) {
			this.$font_size_text.text(this.font_sizes[idx]);
			if (!this.$font_size_pop_items[idx].setd) {
				this.$font_size_pop_items[idx].setd = $('td:eq(0)', this.$font_size_pop_items[idx]);
			}
			this.$font_size_pop_items[idx].setd.append(this.$popbox_fs_selected_item);
		} else {
			this.$nousepane.append(this.$popbox_fs_selected_item);
		}
	},
	
	_setFontSize : function(idx, cells) {
		var fs = idx;
		if (typeof fs == 'number') {
			fs = this.font_sizes[idx];
		}
		var self = this;
		var curPane = this.contentPane.curLGP;
		var cell;
		var action = true;
		if (cells == null) {
			cells = curPane.currentTDCells;
		} else {
			action = false;
		}
		var undo_fns = [];
		var redo_fns = [];
		if (cells) {
			$.each(cells, function(index, item) {
				self._setCellFontSize(item, fs, action, undo_fns, redo_fns, curPane);
			});
		} else {
			cell = curPane.currentTDCell;
			if (cell) {
				this._setCellFontSize(cell, fs, action, undo_fns, redo_fns, curPane);
			}
		}
		
		if (action) {
			this.addAction(undo_fns, redo_fns);
		}
		
		curPane.displayFD(curPane.currentTDCell, false);
	},
	
	_setCellFontSize : function(tdCell, fs, action, undo_fns, redo_fns, curPane) {
		var cell = tdCell.cell;
		if (action) {
			undo_fns.push({fn : this._setFontSize, scope : this, args : [cell.css('font-size'), [tdCell]]});
			redo_fns.push({fn : this._setFontSize, scope : this, args : [fs + '', [tdCell]]});
		}
		cell.css('font-size', fs);
		cell.attr('fs', fs);
		cell.fs = fs;
		cell.dirty = true;
		curPane.shrink2FitRowHeight(tdCell);
	},
	
	_initColorBox : function() {
		this.$colorbox = $('#fr-edit-pop-colorpicker-box:eq(0)', this.$popbox);
		this.$colorinput = $('#fr-edit-color-input:eq(0)', this.$popbox);
		this.$colorpicker = $('#fr-edit-pop-colorpicker:eq(0)', this.$colorbox).farbtastic(this.$colorinput);
		this.$colorpicker = this.$colorpicker.data('fb');
		this.$colorbutton = $('#fr-edit-color-button:eq(0)', this.colorbox);
		
		var self = this;
		this.color_hide = function(){
			self.$colorbox.css('left', -1000);
			$(document).unbind('mousedown', self.color_mouse_hide);
		};
		this.color_mouse_hide = function(e) {
			var src = $(e.target);
			if (src[0] != self.$colorbutton[0] && src.parent('#fr-edit-pop-colorpicker-box:eq(0)').length <= 0) {
				self.color_hide();
			}
		};
		this.$colorbutton.click(function(e){
			self.$colorpicker.color_handler();
			self.color_hide();
		});
	},
	
	_setFontColor : function(color, cells) {
		var self = this;
		var cell;
		var action = true;
		var curPane = this.contentPane.curLGP;
		if (cells == null) {
			cells = curPane.currentTDCells;
		} else {
			action = false;
		}
		var undo_fns = [];
		var redo_fns = [];
		if (cells) {
			$.each(cells, function(idx, item) {
				self._setCellFontColor(item, color, action, undo_fns, redo_fns, curPane);
			});
		} else {
			cell = curPane.currentTDCell;
			if (cell) {
				this._setCellFontColor(cell, color, action, undo_fns, redo_fns, curPane);
			}
		}
		
		if (action) {
			this.addAction(undo_fns, redo_fns);
		}
	},
	
	_setCellFontColor : function(tdCell, color, action, undo_fns, redo_fns, curPane) {
		var cell = tdCell.cell;
		if (action) {
			undo_fns.push({fn : this._setFontColor, scope : this, args : [cell.css('color'), [tdCell]]});
			redo_fns.push({fn : this._setFontColor, scope : this, args : [color, [tdCell]]});
		}
		cell.css('color', color);
		cell.attr('fc', color);
		cell.fc = color;
		cell.dirty = true;
	},
	
	_setBackgroundColor : function(color, cells) {
		var self = this;
		var cell;
		var action = true;
		var curPane = this.contentPane.curLGP;
		if (cells == null) {
			cells = curPane.currentTDCells;
		} else {
			action = false;
		}
		var undo_fns = [];
		var redo_fns = [];
		if (cells) {
			$.each(cells, function(idx, item) {
				self._setCellBackgroundColor(item, color, action, undo_fns, redo_fns, curPane);
			});
		} else {
			cell = curPane.currentTDCell;
			if (cell) {
				this._setCellBackgroundColor(cell, color, action, undo_fns, redo_fns, curPane);
			}
		}
		
		if (action) {
			this.addAction(undo_fns, redo_fns);
		}
	},
	
	_setCellBackgroundColor : function(tdCell, color, action, undo_fns, redo_fns, curPane) {
		var cell = tdCell.cell;
		if (action) {
			undo_fns.push({fn : this._setBackgroundColor, scope : this, args : [cell.css('background-color'), [tdCell]]});
			redo_fns.push({fn : this._setBackgroundColor, scope : this, args : [color, [tdCell]]});
		}
		cell.css('background-color', color);
		cell.attr('bg', color);
		cell.bg = color;
		cell.dirty = true;
	},
	
	_setFont_B : function(cells) {
		var self = this;
		var cell;
		var b = true;
		var action = true;
		var curPane = this.contentPane.curLGP;
		if (cells == null) {
			cells = curPane.currentTDCells;
		} else {
			action = false;
		}
		var undo_fns = [];
		var redo_fns = [];
		if (cells) {
			cell = cells[0].cell;
			if (cell.css('font-weight') == 'bold') {
				b = false;
			}
			$.each(cells, function(idx, item) {
				self._setCellFont_B(item, b, action, undo_fns, redo_fns, curPane);
			});
		} else {
			cell = curPane.currentTDCell;
			if (cell) {
				if (cell.cell.css('font-weight') == 'bold') {
					b = false;
				}
				this._setCellFont_B(cell, b, action, undo_fns, redo_fns, curPane);
			}
		}
		
		curPane.displayFD(curPane.currentTDCell, false);
		
		if (action) {
			this.addAction(undo_fns, redo_fns);
		}
	},
	
	_setCellFont_B : function(tdCell, b, action, undo_fns, redo_fns, curPane) {
		var cell = tdCell.cell;
		if (action) {
			undo_fns.push({fn : this._setFont_B, scope : this, args : [[tdCell]]});
			redo_fns.push({fn : this._setFont_B, scope : this, args : [[tdCell]]});
		}
		if (cell.ft == null) cell.ft = 0;
		if (b) {
			cell.css('font-weight', 'bold');
			cell.ft |= 2;
		} else {
			cell.css('font-weight', 'normal');
			cell.ft &= ~2;
		}
		cell.attr('ft', cell.ft);
		cell.dirty = true;
		curPane.shrink2FitRowHeight(tdCell);
	},
	
	_setFont_I : function(cells) {
		var self = this;
		var cell;
		var b = true;
		var action = true;
		var curPane = this.contentPane.curLGP;
		if (cells == null) {
			cells = curPane.currentTDCells;
		} else {
			action = false;
		}
		var undo_fns = [];
		var redo_fns = [];
		if (cells) {
			cell = cells[0].cell;
			if (cell.css('font-style') == 'italic') {
				b = false;
			}
			$.each(cells, function(idx, item) {
				self._setCellFont_I(item, b, action, undo_fns, redo_fns, curPane);
			});
		} else {
			cell = curPane.currentTDCell;
			if (cell) {
				if (cell.cell.css('font-style') == 'italic') {
					b = false;
				}
				this._setCellFont_I(cell, b, action, undo_fns, redo_fns, curPane);
			}
		}
		
		if (action) {
			this.addAction(undo_fns, redo_fns);
		}
	},
	
	_setCellFont_I : function(tdCell, b, action, undo_fns, redo_fns, curPane) {
		var cell = tdCell.cell;
		if (action) {
			undo_fns.push({fn : this._setFont_I, scope : this, args : [[tdCell]]});
			redo_fns.push({fn : this._setFont_I, scope : this, args : [[tdCell]]});
		}
		if (cell.ft == null) cell.ft = 0;
		if (b) {
			cell.css('font-style', 'italic');
			cell.ft |= 4;
		} else {
			cell.css('font-style', 'normal');
			cell.ft &= ~4;
		}
		cell.attr('ft', cell.ft);
		cell.dirty = true;
	},
	
	_setFont_U : function() {
		this._setFont_D('underline');
	},
	
	_setFont_D : function(textD, cells) {
		var self = this;
		var cell;
		var action = true;
		var curPane = this.contentPane.curLGP;
		if (cells == null) {
			cells = curPane.currentTDCells;
		} else {
			action = false;
		}
		var undo_fns = [];
		var redo_fns = [];
		if (cells) {
			cell = cells[0].cell;
			if (cell.css('text-decoration') == textD) { // ǰĺõһǾͱnone
				textD = 'none'
			}
			$.each(cells, function(idx, item) {
				self._setCellFont_D(item, textD, action, undo_fns, redo_fns, curPane);
			});
		} else {
			cell = curPane.currentTDCell;
			if (cell) {
				if (cell.cell.css('text-decoration') == textD) { // ǰĺõһǾͱnone
					textD = 'none'
				}
				this._setCellFont_D(cell, textD, action, undo_fns, redo_fns, curPane);
			}
		}
		
		if (action) {
			this.addAction(undo_fns, redo_fns);
		}
	},
	
	_setCellFont_D : function(tdCell, textD, action, undo_fns, redo_fns, curPane) {
		var cell = tdCell.cell;
		var cssD = cell.css('text-decoration');
		if (action) {
			undo_fns.push({fn : this._setFont_D, scope : this, args : [cssD, [tdCell]]});
			redo_fns.push({fn : this._setFont_D, scope : this, args : [textD, [tdCell]]});
		}
		if (cell.ft == null) cell.ft = 0;
		if (textD == 'none') {
			if (cssD == 'line-through') {
				cell.ft &= ~16;
			} else if (cssD == 'underline'){
				cell.ft &= ~8;
			}
			cell.css('text-decoration', 'none');
		} else {
			if (textD == 'line-through') {
				cell.css('text-decoration', 'line-through');
				cell.ft |= 16;
			} else if (textD == 'underline') {
				cell.css('text-decoration', 'underline');
				cell.ft |= 8;
			}
		}
		cell.attr('ft', cell.ft);
		cell.dirty = true;
	},
	
	_setFont_ABC : function() {
		this._setFont_D('line-through');
	},
	
	_popBorderMenu : function() {
		if (!this.$pop_border) {
			this.$pop_border = this.$popbox.children('#fr-edit-pop-border:eq(0)');
			var $td;			
			var self = this;
			this.border_hide = function(){
				self.$pop_border.css('left', -1000);
				$(document).unbind('mousedown', self.border_mouse_hide);
			};
			this.border_mouse_hide = function(e) {
				var src = $(e.target);
				if (src.parent('#fr-edit-pop-border:eq(0)').length <= 0) {
					self.border_hide();
				}
			};
			var M = {
				onMouseOver : function(e) {
					this.css("background-color", "#6688EE");
				},
				onMouseOut : function(e) {
					this.css("background-color", "#ffffff");
				},
				onMouseDown : function(e) {
					self._setBorderStyle(parseInt(this.attr("bt")));
					self.border_hide();
				}
			};
			$.each($('td', this.$pop_border), function(idx, td) {
				$td = $(td);
				$td.mouseover(M.onMouseOver.createDelegate($td))
					.mouseout(M.onMouseOut.createDelegate($td))
					.mousedown(M.onMouseDown.createDelegate($td));
			});
		}
		
		$(document).bind('mousedown', this.border_mouse_hide);
		this.$pop_border.css('left', 635);
	},
	
	_setBorderStyle : function(bt, pcell, doRefresh) {
		var self = this;
		var action = true;
		var curPane = this.contentPane.curLGP;
		var cells = curPane.currentTDCells;
		if (pcell != null) {
			cells = null;
			action = false;
		}
		var undo_fns = [];
		var redo_fns = [];
		if (bt == 0) { // clear
			var cell;
			if (cells) {
				var length = cells.length;
				for (var i = 0; i < length; i++) {
					this._setNoBorderStyle4Cell(cells[i], action, undo_fns, redo_fns, i == length - 1);
				}
			} else {
				if (pcell == null) pcell = curPane.currentTDCell;
				if (pcell) {
					this._setNoBorderStyle4Cell(pcell, action, undo_fns, redo_fns, true);
				}
			}
		} else {
			var br = [];
			br[0] = (bt & 2) != 0;
			br[1] = (bt & 4) != 0;
			br[2] = (bt & 8) != 0;
			br[3] = (bt & 16) != 0;
			br[4] = (bt & 32) != 0;
			br[5] = (bt & 64) != 0;
			var cell;
			var cell_range = curPane.currentTDCellRange;
			if (cells) {
				var length = cells.length;
				for (var i = 0; i < length; i++) {
					this._setBorderStyle4CellRange(cells[i], cell_range, br, action, undo_fns, redo_fns, i == length - 1);
				}
			} else {
				if (pcell == null) pcell = curPane.currentTDCell;
				if (pcell) {
					this._setBorderStyle4Cell(pcell, br[0], br[1], br[2], br[3], action, undo_fns, redo_fns, true);
				}
			}
		}
		
		if (action) {
			this.addAction(undo_fns, redo_fns);
		}
		
		if (doRefresh != false) {
			// carl:ͨķʽcollapse
			if (this.contentPane.curLGP.$sheet_container.css('border-collapse') != 'collapse') {
				this.contentPane.curLGP.$sheet_container.css('border-collapse', 'collapse');
			} else {
				this.contentPane.curLGP.$sheet_container.css('border-collapse', '');
			}
		}
	},
	
	_setNoBorderStyle4Cell : function(tdCell, action, undo_fns, redo_fns, doRefresh) {
		var cell = tdCell.cell;
		var old_br = this._getCellBr(cell);
		if (action) {
			undo_fns.push({fn : this._setBorderStyle, scope : this, args : [old_br, tdCell, doRefresh]});
			redo_fns.push({fn : this._setBorderStyle, scope : this, args : [0, tdCell, doRefresh]});
		}
		cell.dirty = true;
		cell.css('border', 0);
		cell.attr('br', 1);
		cell.br = 1;
	},
	
	_setBorderStyle4CellRange : function(cell, cell_range, br, action, undo_fns, redo_fns, doRefresh) {
		var top, right, bottom, left;
		if (br[0] && cell.row == cell_range.row) { // top
			top = true;
		}
		if (br[1] && (cell.col + cell.cell[0].colSpan) == (cell_range.col + cell_range.colSpan)) {// right
			right = true;
		}
		if (br[2] && (cell.row + cell.cell[0].rowSpan) == (cell_range.row + cell_range.rowSpan)) {// bottom
			bottom = true;
		}
		if (br[3] && cell.col == cell_range.col) {// left
			left = true;
		}
		if (br[4]) {
			if (!top && cell.row > cell_range.row){
				top = true;
			}
			if (!bottom && (cell.row + cell.cell[0].rowSpan) < (cell_range.row + cell_range.rowSpan)) {
				bottom = true;
			}
		}
		if (br[5]) {
			if (!left && cell.col > cell_range.col){
				left = true;
			}
			if (!right && (cell.col + cell.cell[0].colSpan) < (cell_range.col + cell_range.colSpan)) {
				right = true;
			}
		}
		
		this._setBorderStyle4Cell(cell, top, right, bottom, left, action, undo_fns, redo_fns, doRefresh)
	},
	
	_setBorderStyle4Cell : function(tdCell, top, right, bottom, left, action, undo_fns, redo_fns, doRefresh) {
		var cell = tdCell.cell;
		cell.dirty = true;
		var br;
		var old_br = this._getCellBr(cell);
		if (cell.br == null) {
			br = 0;
		}
		
		if (top) {
			cell.css('border-top-width', 1);
			cell.css('border-top-style', 'solid');
			br |= 2;
		}
		if (right) {
			cell.css('border-right', 1);
			cell.css('border-right-style', 'solid');
			br |= 4;
		}
		if (bottom) {
			cell.css('border-bottom', 1);
			cell.css('border-bottom-style', 'solid');
			br |= 8;
		}
		if (left) {
			cell.css('border-left', 1);
			cell.css('border-left-style', 'solid');
			br |= 16;
		}
		
		if (action) {
			undo_fns.push({fn : this._setBorderStyle, scope : this, args : [old_br, tdCell, doRefresh]});
			redo_fns.push({fn : this._setBorderStyle, scope : this, args : [br, tdCell, doRefresh]});
		}
		
		cell.attr('br', br);
		cell.br = br;
	},
	
	_getCellBr : function(cell) {
		if (cell == null) return null;
		var br = 0;
		if (parseInt(cell.css('border-top-width')) > 0) {
			br |= 2;
		}
		if (parseInt(cell.css('border-right-width')) > 0) {
			br |= 4;
		}
		if (parseInt(cell.css('border-bottom-width')) > 0) {
			br |= 8;
		}
		if (parseInt(cell.css('border-left-width')) > 0) {
			br |= 16;
		}
		return br;
	},
	
	_popAlignMenu : function() {
		if (!this.$pop_align) {
			this.$pop_align = this.$popbox.children('#fr-edit-pop-align:eq(0)');
			var $td;			
			var self = this;
			this.align_hide = function(){
				self.$pop_align.css('left', -1000);
				$(document).unbind('mousedown', self.align_mouse_hide);
			};
			this.align_mouse_hide = function(e) {
				var src = $(e.target);
				if (src.parent('#fr-edit-pop-align:eq(0)').length <= 0) {
					self.align_hide();
				}
			};
			var M = {
				onMouseOver : function(e) {
					this.css("background-color", "#6688EE");
				},
				onMouseOut : function(e) {
					this.css("background-color", "#ffffff");
				}
			};
			$.each($('td', this.$pop_align), function(idx, td) {
				$td = $(td);
				$td.mouseover(M.onMouseOver.createDelegate($td))
					.mouseout(M.onMouseOut.createDelegate($td))
					.mousedown(function(e){
						self._setAlignStyle(idx);
						self.align_hide();
					});
			});
		}
		
		$(document).bind('mousedown', this.align_mouse_hide);
		this.$pop_align.css('left', 675);
	},
	
	_setAlignStyle : function(idx, cells) {
		var self = this;
		var cell;
		var action = true;
		var curPane = this.contentPane.curLGP;
		if (cells == null) {
			cells = curPane.currentTDCells;
		} else {
			action = false;
		}
		var undo_fns = [];
		var redo_fns = [];
		if (cells) {
			var length = cells.length;
			for (var i = 0; i < length; i ++) {
				self._setAlignStyle4Cell(cells[i], idx, action, undo_fns, redo_fns);
			};
		} else {
			cell = curPane.currentTDCell;
			if (cell) {
				this._setAlignStyle4Cell(cell, idx, action, undo_fns, redo_fns);
			}
		}
		
		if (action) {
			this.addAction(undo_fns, redo_fns);
		}
	},
	
	_setAlignStyle4Cell : function(tdCell, idx, action, undo_fns, redo_fns) {
		var cell = tdCell.cell;
		var old_align = 0;
		if (idx < 3) {
			if (cell.css('text-align') == 'center') {
				old_align = 1;
			} else if (cell.css('text-align') == 'right') {
				old_align = 2;
			}
		} else {
			old_align = 3;
			if (cell.css('vertical-align') == 'middle') {
				old_align = 4;
			} else if (cell.css('vertical-align') == 'bottom') {
				old_align = 5;
			}
		}
		if (action) {
			undo_fns.push({fn : this._setAlignStyle, scope : this, args : [old_align, [tdCell]]});
			redo_fns.push({fn : this._setAlignStyle, scope : this, args : [idx, [tdCell]]});
		}
		cell.dirty = true;
		if (idx == 0) {
			cell.css('text-align', 'left');
			cell.attr('ta', 0);
			cell.ta = 0;
		} else if (idx == 1) {
			cell.css('text-align', 'center');
			cell.attr('ta', 1);
			cell.ta = 1;
		} else if (idx == 2) {
			cell.css('text-align', 'right');
			cell.attr('ta', 2);
			cell.ta = 2;
		} else if (idx == 3) {
			cell.css('vertical-align', 'top');
			cell.attr('va', 0);
			cell.va = 0;
		} else if (idx == 4) {
			cell.css('vertical-align', 'middle');
			cell.attr('va', 1);
			cell.va = 1;
		} else if (idx == 5) {
			cell.css('vertical-align', 'bottom');
			cell.attr('va', 2);
			cell.va = 2;
		}
	},
	
	saveReport : function() {
        var self = this;
        this.saveData({params:{op:"edit_saveReport"}, fn:function(res, status) {
            FR.Msg.alert(FR.i18n.Info, res.responseText == FR.constant.failure ? FR.i18n.Failed : FR.i18n.Successfully);
         }});
	},
	
	/*
     * alex:XML,ֻдDirtyĸӵֵ
     */
    generateReportXML:function() {
        var xml = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>";
        xml += "<WorkBook>";
        xml += ("<Version>6.5</Version>");//marks:

        //alex:iterate all reports
        var centerPanelCount = this.contentPane.lgps.length;
        for (var i = 0; i < centerPanelCount; i++) {
            var cell_table = this.contentPane.lgps[i].cell_table;
            if (cell_table == null || cell_table.length == 0) {
                continue;
            }
            xml += "<Report class=\"com.fr.report.EditResultWorkSheet\" name=\"" + i + "\">";
            xml += "<CellElementList>";
            
            var rowcount = cell_table.length;
            var colcount;
            var cell;
            for (var r = 0; r < rowcount; r++) {
            	colcount = cell_table[r].length;
            	for (var c = 0; c < colcount; c++) {
            		cell = cell_table[r][c];
            		if (cell.dirty) {
            			xml += "<C c=\"" + c + "\" r=\"" + r + "\" ";
            			if (cell.vd) {
            				xml += "vd=\"1\" ";
            			}
            			if (cell.ff != null) {
            				xml += "ff=\"" + cell.ff + "\" ";
            			}
            			if (cell.fs != null) {
            				xml += "fs=\"" + cell.fs + "\" ";
            			}
            			if (cell.fc != null) {
            				xml += "fc=\"" + cell.fc + "\" ";
            			}
            			if (cell.ft != null) {
            				xml += "ft=\"" + cell.ft + "\" ";
            			}
            			if (cell.br != null) {
            				xml += "br=\"" + cell.br + "\" ";
            			}
            			if (cell.bg != null) {
            				xml += "bg=\"" + cell.bg + "\" ";
            			}
            			if (cell.ta != null) {
            				xml += "ta=\"" + cell.ta + "\" ";
            			}
            			if (cell.va != null) {
            				xml += "va=\"" + cell.va + "\" ";
            			}
            			xml += ">";
            			if (cell.vd && cell.cv != null) {
							xml += this.writeCellValue(cell);
							cell.vd = false;
            			}
						xml += "</C>";
						
						cell.dirty = false;
            		}
            	}
            }

            xml += "</CellElementList>";
            xml += "</Report>";
        }

        xml += "</WorkBook>";

        return xml;
    },
    
    writeCellValue : function(cell) {
    	var formula = cell.attr("fm");
    	var value = cell.cv;
    	if (formula != null) {
        	formula = FR.jsonDecode('"=' + formula + '"');
        	
        	return "<O t=\"Formula\"><Attributes>" + FR.cjkEncode("<![CDATA[" + FR.htmlSpaceDecode(("" + formula).replace(/\n/ig,"\\\nn")) + "]]>")
        		+ "</Attributes>" + this.writeObject(value)
        		+ "</O>";
        }
        
        return this.writeObject(value);
    },
    
    writeObject : function(value) {
        var xmlString = "";
        if (value == null) {
            return xmlString;
        }

		var xtype = "S", xcontent = null;
		if (typeof value == 'number') {
			xcontent = value;
			if (/\./.test("" + value)) {
				xtype = "D";
			// carl:ΪsqltypeʱûBigIntegerԶBigDecimal
			} else if(("" + value).length >= 10) {
				xtype = "BigDecimal";
			} else {
				xtype = "I";
			}
		} 
		// alex:ΪǱattr,ͺAttachmentvalue{}ʽʾ
		else if (typeof value == 'object') {
			if (value.date_milliseconds != null) {
				xtype = "Date";
				xcontent = value.date_milliseconds;
			} else if (value.attach_id != null) {
				xtype = "Attachment";
				xcontent = value.attach_id ;
			}
		} else if (typeof value == 'boolean') {
			xtype = "B";
		}
		
		if (xcontent == null) {
			xcontent = "" + value;
		}
        
        //cjkEncode the value to avoid the disorder value
        //Attention!!! the "<![CDATA[]]>" is also be cjkEncoded
        return "<O t=\"" + xtype + "\">" + 
        /*
         * alex:ǰ滹һhtmlEncode,ᵼ<>,&lt;&lr;
         * 
         * ,ַֻreplace,ûе,Բ֮ǰ,ֱxcontent=xcontent.replace(...)
         * һ,Ҳ֪xcontent=xcontent.replace(...)˭ӵ,ΪʲôҪ?
         */
		FR.cjkEncode("<![CDATA[" + FR.htmlSpaceDecode(("" + xcontent).replace(/\n/ig,"\\\nn")) + "]]>") + 
		"</O>";
    },
    
    /*
     * writeǱ߳
     * ΪʲôȡdoSave,ΪajaxĲreportXML,˱Ȼᱣһ
     * options {
	 * 		params:˴ajaxҪĲ
	 * 		fn:˴ajaxcallback
     * }
     * 
     * saveDataajaxͬ,첽
     */
    saveData : function(options) {
    	// carl:ͬajaxui.dialog.jsڸǲcreateʱsetTimeoutͻbug0002671
    	// ʱûкõĽ취дui.dialogڸǡһжǷӳڸǣϸbug0002671
    	var o = {
    		overlay_immediately : true,
    		text : "Saving..."
    	};
		FR.showLoadingDialog(o);
		this.contentPane.curLGP.stopCellEditing();
		
		$.ajax({
			url : this.contentPane.servletURL,
			type : 'POST',
			async : false,
			data : $.extend({
				op : "edit_saveData",
				sessionID : this.contentPane.currentSessionID,
				editReportXML : this.generateReportXML()
			}, options.params), // ĬopΪ"write_saveContent",Ᵽһ
			complete : (options.fn || FR.emptyFn).createSequence(FR.hideLoadingDialog) // alex:صloadingDialogĶԻ
		});
	}
});

$.widget("FR.EditIconButton");$.shortcut("editiconbutton", "$.FR.EditIconButton")
FR.extend($.FR.EditIconButton, $.FR.Widget, {
	button_container_class : "fr-edit-toolbar-button-container",
	button_si_class : "fr-edit-toolbar-si-button-box",
	button_box_bg_class : "fr-edit-toolbar-button-box-bg",
	button_class_prefix : "fr-edit-toolbar-icon-",
	icon_class : "fr-edit-toolbar-button-icon",
	
	_init : function() {
		$.FR.EditIconButton.superclass._init.apply(this, arguments);
		var o = this.options = $.extend({
			tablable : true,
			render : false
		}, this.options)
		
		// renderΪfalseʱ,䱾һؼ,Ҫӽȥ
		if (o.render === true) {
			this.$btn = $("<div></div>").appendTo(this.element);
		} else {
			this.$btn = this.element;
		}
		
		this.$btn.addClass(this.button_container_class);
		this.$btnbox = $("<div></div>").addClass(this.button_si_class).addClass(this.button_box_bg_class).appendTo(this.$btn);
		if (o.title) {
			this.$btnbox.attr("title", o.title);
		}
		$("<div></div>").addClass(this.button_class_prefix + o.name).addClass(this.icon_class).appendTo(this.$btnbox);
		
		// mouse event
		var self = this;
		var M = {
			onMouseOver : function(e) {
				self.$btnbox.addClass(self.button_box_bg_class + "-hover");
			},
			onMouseOut : function(e) {
				self.$btnbox.removeClass(self.button_box_bg_class + "-hover");
				self.$btnbox.removeClass(self.button_box_bg_class + "-click");
			},
			onMouseDown : function(e) {
				self.$btnbox.removeClass(self.button_box_bg_class + "-hover");
				self.$btnbox.addClass(self.button_box_bg_class + "-click");
				$(document).bind("mouseup", M.onMouseUp);
			},
			onMouseUp : function(e) {
				self.$btnbox.removeClass(self.button_box_bg_class + "-click");
				$(document).unbind("mouseup", M.onMouseUp);
			}
		}
		
		this.$btnbox.mouseover(M.onMouseOver.createInterceptor(this.isEnabled, this))
			.mouseout(M.onMouseOut)
			.mousedown(M.onMouseDown.createInterceptor(this.isEnabled, this))
			.mouseup(M.onMouseUp);
		
		this.$btn.click(function(e) {
			if (self.isEnabled()) {
				self.fireEvent(FR.Events.CLICK, e);
			}
		});
		
		// alex:¼Ļʵhandler
		if ($.isFunction(o.handler)) {
			this.on(FR.Events.CLICK, o.handler.createDelegate(o.scope || this));
		}
		
		this.fireEvent(FR.Events.AFTERINIT);
	},
	
    destroy : function() {
        this.element.empty();
    }
});

$.widget("FR.EditFontButton");$.shortcut("editfontbutton", "$.FR.EditFontButton")
FR.extend($.FR.EditFontButton, $.FR.Widget, {
	button_box_bg_class : 'fr-edit-toolbar-button-box-bg',
	
	_init : function() {
		$.FR.EditFontButton.superclass._init.apply(this, arguments);
		var o = this.options;
		
		this.$btn = $('.fr-edit-toolbar-button-container:eq(0)', this.element);
		this.$btnbox = $('.fr-edit-toolbar-button-font-box:eq(0)', this.$btn);
		
		// mouse event
		var self = this;
		var M = {
			onMouseOver : function(e) {
				self.$btnbox.addClass(self.button_box_bg_class + "-hover");
			},
			onMouseOut : function(e) {
				self.$btnbox.removeClass(self.button_box_bg_class + "-hover");
				self.$btnbox.removeClass(self.button_box_bg_class + "-click");
			},
			onMouseDown : function(e) {
				self.$btnbox.removeClass(self.button_box_bg_class + "-hover");
				self.$btnbox.addClass(self.button_box_bg_class + "-click");
				$(document).bind("mouseup", M.onMouseUp);
			},
			onMouseUp : function(e) {
				self.$btnbox.removeClass(self.button_box_bg_class + "-click");
				$(document).unbind("mouseup", M.onMouseUp);
			}
		}
		
		this.$btnbox.mouseover(M.onMouseOver.createInterceptor(this.isEnabled, this))
			.mouseout(M.onMouseOut)
			.mousedown(M.onMouseDown.createInterceptor(this.isEnabled, this))
			.mouseup(M.onMouseUp);
		
		this.$btn.click(function(e) {
			if (self.isEnabled()) {
				self.fireEvent(FR.Events.CLICK, e);
			}
		});
		
		// alex:¼Ļʵhandler
		if ($.isFunction(o.handler)) {
			this.on(FR.Events.CLICK, o.handler.createDelegate(o.scope || this));
		}
		
		this.fireEvent(FR.Events.AFTERINIT);
	},
	
    destroy : function() {
        this.element.empty();
    }
});

$.widget("FR.SheetControlButton");$.shortcut("sheetcontrolbutton", "$.FR.SheetControlButton")
FR.extend($.FR.SheetControlButton, $.FR.Widget, {
	button_container_class : "fr-edit-sheetcontrol-icon-container",
	button_box_class : "fr-edit-sheetcontrol-icon-box",
	button_fixbox_class : "fr-edit-sheetcontrol-icon-fixbox",
	button_class_prefix : "fr-edit-sheetcontrol-icon-",
	
	_init : function() {
		$.FR.SheetControlButton.superclass._init.apply(this, arguments);
		var o = this.options = $.extend({
			tablable : true,
			render : false
		}, this.options)
		
		// renderΪfalseʱ,䱾һؼ,Ҫӽȥ
		if (o.render === true) {
			this.$btn = $("<div></div>").appendTo(this.element);
		} else {
			this.$btn = this.element;
		}
		
		this.$btn.addClass(this.button_container_class);
		this.$btnbox = $("<div></div>").addClass(this.button_box_class).appendTo(this.$btn);
		if (o.title) {
			this.$btnbox.attr("title", o.title);
		}
		$("<div></div>").addClass(this.button_class_prefix + o.name).appendTo(
			$("<div></div>").addClass(this.button_fixbox_class).appendTo(this.$btnbox));
		
		// mouse event
		var self = this;
		var M = {
			onMouseOver : function(e) {
				self.$btnbox.addClass(self.button_box_class + "-hover");
			},
			onMouseOut : function(e) {
				self.$btnbox.removeClass(self.button_box_class + "-hover");
				self.$btnbox.removeClass(self.button_box_class + "-click");
			},
			onMouseDown : function(e) {
				self.$btnbox.removeClass(self.button_box_class + "-hover");
				self.$btnbox.addClass(self.button_box_class + "-click");
				$(document).bind("mouseup", M.onMouseUp);
			},
			onMouseUp : function(e) {
				self.$btnbox.removeClass(self.button_box_class + "-click");
				$(document).unbind("mouseup", M.onMouseUp);
			}
		}
		
		this.$btnbox.mouseover(M.onMouseOver.createInterceptor(this.isEnabled, this))
			.mouseout(M.onMouseOut)
			.mousedown(M.onMouseDown.createInterceptor(this.isEnabled, this))
			.mouseup(M.onMouseUp);
		
		this.$btn.click(function(e) {
			if (self.isEnabled()) {
				self.fireEvent(FR.Events.CLICK, e);
			}
		});
		
		// alex:¼Ļʵhandler
		if ($.isFunction(o.handler)) {
			this.on(FR.Events.CLICK, o.handler.createDelegate(o.scope || this));
		}
		
		this.fireEvent(FR.Events.AFTERINIT);
	},
	
    destroy : function() {
        this.element.empty();
    }
});

$.widget("FR.EditColorMenuButton");$.shortcut("editcolormenubutton", "$.FR.EditColorMenuButton")
FR.extend($.FR.EditColorMenuButton, $.FR.Widget, {
	left_box_bg_class : 'fr-edit-toolbar-menu-leftbox-bg',
	right_box_bg_class : 'fr-edit-toolbar-menu-rightbox-bg',
	
	_init : function() {
		$.FR.EditColorMenuButton.superclass._init.apply(this, arguments);
		
		this.$left_box = $('.fr-edit-toolbar-complexmenu-leftbox:eq(0)', this.element);
		this.$right_box = $('.fr-edit-toolbar-menu-rightbox:eq(0)', this.element);
		this.$inner_box = $('.fr-edit-toolbar-complexmenu-innerbox:eq(0)', this.$left_box);
		
		// mouse event
		var self = this;
		var M_l = {
			onMouseOver : function(e) {
				self.$left_box.addClass(self.left_box_bg_class + "-over");
				self.$right_box.addClass(self.right_box_bg_class + "-over");
			},
			onMouseOut : function(e) {
				self.$left_box.removeClass(self.left_box_bg_class + "-over");
				self.$right_box.removeClass(self.right_box_bg_class + "-over");
				self.$left_box.removeClass(self.left_box_bg_class + "-click");
			},
			onMouseDown : function(e) {
				self.$left_box.addClass(self.left_box_bg_class + "-click");
				$(document).bind("mouseup", M_l.onMouseUp);
			},
			onMouseUp : function(e) {
				self.$left_box.removeClass(self.left_box_bg_class + "-click");
				$(document).unbind("mouseup", M_l.onMouseUp);
			}
		};
		
		var M_r = {
			onMouseOver : function(e) {
				self.$right_box.addClass(self.right_box_bg_class + "-over");
				self.$left_box.addClass(self.left_box_bg_class + "-over");
			},
			onMouseOut : function(e) {
				self.$right_box.removeClass(self.right_box_bg_class + "-over");
				self.$left_box.removeClass(self.left_box_bg_class + "-over");
				self.$right_box.removeClass(self.right_box_bg_class + "-click");
			},
			onMouseDown : function(e) {
				self.$right_box.addClass(self.right_box_bg_class + "-click");
				$(document).bind("mouseup", M_r.onMouseUp);
			},
			onMouseUp : function(e) {
				self.$right_box.removeClass(self.right_box_bg_class + "-click");
				$(document).unbind("mouseup", M_r.onMouseUp);
			}
		};
		
		this.$left_box.mouseover(M_l.onMouseOver.createInterceptor(this.isEnabled, this))
			.mouseout(M_l.onMouseOut)
			.mousedown(M_l.onMouseDown.createInterceptor(this.isEnabled, this))
			.mouseup(M_l.onMouseUp);
		
		this.$right_box.mouseover(M_r.onMouseOver.createInterceptor(this.isEnabled, this))
			.mouseout(M_r.onMouseOut)
			.mousedown(M_r.onMouseDown.createInterceptor(this.isEnabled, this))
			.mouseup(M_r.onMouseUp);
		
		this.$left_box.click(function(e){
			self.setColor();
		});	
			
		this.$right_box.click(function(e) {
			self.dropdown();
		});
	},
	
	dropdown : function() {
		if (!FR.EDIT.$colorbox) {
			FR.EDIT._initColorBox();
		}
		
		FR.EDIT.$colorpicker.setColor(this.$inner_box.attr('clr'));
		FR.EDIT.$colorbox.css({left : this.options.left, top : 28});
		FR.EDIT.$colorpicker.crEl = this;
		$(document).bind('mousedown', FR.EDIT.color_mouse_hide);
		FR.EDIT.$colorpicker.color_handler = this.options.handler.createDelegate(this);
	},
	
	setColor : function() {
		FR.EDIT["_set" + this.options.cfn](this.$inner_box.attr('clr'));
	},
	
    destroy : function() {
        this.element.empty();
    }
});

$.widget("FR.EditMenuButton");$.shortcut("editmenubutton", "$.FR.EditMenuButton")
FR.extend($.FR.EditMenuButton, $.FR.Widget, {
	button_box_bg_class : 'fr-edit-toolbar-button-box-bg',
	
	_init : function() {
		$.FR.EditMenuButton.superclass._init.apply(this, arguments);
		var o = this.options;
		
		this.$btnbox = $('.fr-edit-toolbar-button-menu-box:eq(0)', this.element);
		
		// mouse event
		var self = this;
		var M = {
			onMouseOver : function(e) {
				self.$btnbox.addClass(self.button_box_bg_class + "-hover");
			},
			onMouseOut : function(e) {
				self.$btnbox.removeClass(self.button_box_bg_class + "-hover");
				self.$btnbox.removeClass(self.button_box_bg_class + "-click");
			},
			onMouseDown : function(e) {
				self.$btnbox.removeClass(self.button_box_bg_class + "-hover");
				self.$btnbox.addClass(self.button_box_bg_class + "-click");
				$(document).bind("mouseup", M.onMouseUp);
			},
			onMouseUp : function(e) {
				self.$btnbox.removeClass(self.button_box_bg_class + "-click");
				$(document).unbind("mouseup", M.onMouseUp);
			}
		}
		
		this.$btnbox.mouseover(M.onMouseOver.createInterceptor(this.isEnabled, this))
			.mouseout(M.onMouseOut)
			.mousedown(M.onMouseDown.createInterceptor(this.isEnabled, this))
			.mouseup(M.onMouseUp);
		
		this.$btnbox.click(function(e) {
			if (self.isEnabled()) {
				self.fireEvent(FR.Events.CLICK, e);
			}
		});
		
		// alex:¼Ļʵhandler
		if ($.isFunction(o.handler)) {
			this.on(FR.Events.CLICK, o.handler.createDelegate(o.scope || this));
		}
		
		this.fireEvent(FR.Events.AFTERINIT);
	},
	
    destroy : function() {
        this.element.empty();
    }
});

$.widget("FR.EditVPEditor");$.shortcut("vpeditor", "$.FR.EditVPEditor")
FR.extend($.FR.EditVPEditor, $.FR.Widget, {
	_init : function() {
		$.FR.EditVPEditor.superclass._init.apply(this, arguments);
		
		this.$editor = $("<textarea></textarea>").attr("id", "fr-edit-vp-textarea").appendTo(this.element);
		
		var self = this;
		this.$editor.focus(function(){
			FR.EDIT.contentPane.curLGP.editTDCell(null, false, true);
		});
		
		this.$editor.valuechange = function() {
	        var value = self.$editor.val();
			// 4ֵĳ
	        var cp = FR.EDIT.contentPane.curLGP;
			cp.editor_fontCheckBox.text(value + "-ʶ");
			if (value.startWith('=')) {
				value = value.substring(1, value.length);
			}
			cp.editorEl.val(value);
			var width = cp.editor_fontCheckBox[0].offsetWidth;
			
			if (width < cp.editorEl.defaultWidth) {
				cp.$editor.width(cp.editorEl.defaultWidth);
				cp.editorEl.width(cp.editorEl.defaultWidth);
			} else {
				cp.$editor.width(width);
				cp.editorEl.width(width);
			}
	    };
	    
	    var EE = $.ui.keyCode;
	    this.$editor.keyup(function(e) {
	    	var k = e.keyCode;
	    	var pane = FR.EDIT.contentPane.curLGP;
	    	if (pane && k == EE.ENTER) {
	    		e.preventDefault();
				e.stopPropagation();
				pane.moveTDCell(2);
				pane.editTDCell(null, false, true);
	    	} else {
				self.$editor.valuechange();
	    	}
		});
			
		return this;
	},
	
	setValue : function(value) {
		this.$editor.val(value);
	},
	
    destroy : function() {
        this.element.empty();
    }
});

//view.js
$.extend($.FR.EditPane.prototype, {
	isLoadingPage:-1,
	selectedIndex : - 1, // alex:ǰѡеWLGP
	scroll_state : 0,
	parampane_height : -1,
		
    pageSetup:function () {
    	this.curLGP.pageSetup();
    },
    
	initContentPane : function() {
		this._initScrollBar();
		this._initParamPaneHeight();
		
        var self = this;
        if (this.tabs && this.tabs.length > 1) {
            //jamesǰFormPanetabchange¼ִtabchange
            this.on(FR.Events.TABCHANGE, function(tabIndex) {
                var lgp = self.lgps[tabIndex];
                self.scroll_state = 0;
                
                if(lgp.loaded === false) {
                    lgp.loadLGPPane();
                } else {
                 	// Carlôܲ
                  	self.curLGP = lgp;
                  	self.scroll_state = 1;
                }
                
                $(this.tabs[self.selectedIndex]).css("display", "none");
                self.selectedIndex = lgp.idx;
                $(this.tabs[self.selectedIndex]).css("display", "block");
                
                self.$contentPane.asComponent("borderlayout", {items:[{
            		region : 'center',
           			el : $(self.tabs[self.selectedIndex])
        		}]});
        		self.$contentPane.doLayout();
        		
        		self._setScrollBar();
            });

            this.lgps = new Array(this.tabs.length);
            for (var i = 0, count = this.tabs.length; i < count; i++) {
                this.lgps[i] = new FR.ELGP({idx:i, $container:$(this.tabs[i]), editPane:this});
            }
            
        } else {
        	this.$contentPane.css("overflow-x", "hidden").css("overflow-y", "scroll");
            this.lgps = [new FR.ELGP({idx:0, $container:this.$contentPane, editPane:this})];
        }
        
        this.selectedIndex = 0;
        
        // ʼճ
        this.$cpTextArea = $("<textarea id='cpTextArea' onkeyup='this.blur()'></textarea>").appendTo($("<div id='cpTextAreaDiv' style='position:absolute;left:-1000px;top:-1000px;'></div>").appendTo($('body')));
	},
	loadContentPane : function() {
		this._showContentPane();
		if(this.lgps == null || this.lgps.length == 0) return;
        $.each(this.lgps, function(idx, lgp) {
            lgp.loaded = false;
        });
        if(this.curLGP == null) this.curLGP = this.lgps[0];
        this.curLGP.loadLGPPane();
        
        if (this.tabs && this.tabs.length > 1) {
	        var self = this;
	        this.$contentPane.asComponent("borderlayout", {items:[{
	            region : 'center',
	           	el : self.curLGP.$container
	        }]});
	        this.$contentPane.doLayout();
        }
        
        this._setScrollBar();
	},
	
	_initParamPaneHeight : function() {
		if (this.parampane_height < 0) {
			var $paramPane = $('body').children('.parameter-container');
			if ($paramPane.length > 0) {
				this.parampane_height = $paramPane.height();
			} else {
				this.parampane_height = 0;
			}
		}
	},
	
	_doReportPaneBorderLayout : function(items) {
		var regions = [];
		if (items.length > 1) {
	    	for (var i = 0; i < items.length; i++) {
	    		var el = items[i];
	    		if (el && el.region == 'north') { // ϲ
	    			regions.push(el);
	    		}
	    	}
		}
		var mainpane = $("#fr-edit-main");
		regions.push({region : 'center', el : mainpane});
		FR.EDIT.$container = $("body").asComponent("borderlayout", {items:regions});
		FR.EDIT.$container.doLayout();
    },
	
    _showContentPane : function() {
    	var content = FR.EDIT;
    	if (content.$northpane.css('display') == 'none') {
	    	content.$northpane.show();
	    	content.$contentpane.show();
	    	content.$sheetscrollpane.show();
	    	regions = [{region:'north', el : content.$northpane}];
			regions.push({region:'center', el : content.$contentpane});
			regions.push({region:'south', el : content.$sheetscrollpane});
			var container = content.$mainpane.asComponent("borderlayout", {items:regions});
			container.doLayout();
			$(window).resize(function() {
				FR.EDIT._resize();
			});
			content.$contentpane.asComponent("borderlayout", {items:[{region:'center', el : this.$contentPane}]});
			content.$contentpane.doLayout();
    	}
    },
    
	/**
	 * carl:ʼtab
	 */
	_initSheetTabPane : function($contentPane, sheetsO) {
		var self = this; 
		self.tabs = [];
		$.each(sheetsO, function(idx, item) {
			self.tabs[idx] = $("<div></div>").attr("id", "fr-edit-tab-" + idx).css("overflow-x", "hidden")
				.css("position", "absolute").css("display", idx == 0 ? "block" : "none").appendTo($contentPane);
			// carl:autoĻieܹ֪Ϊʲô
			if ($.browser.msie) {
				self.tabs[idx].css("overflow-y", "scroll");
			}
		});
		
		var $tr = $("#fr-edit-st:eq(0)", FR.EDIT.$sheetscrollpane);
		
		self.left_tabbuttons = [];
		self.center_tabbuttons = [];
		$.each(sheetsO, function(idx, item) {
			var prefix = null;
			var $box = null;
			if (idx == 0) {
				prefix = "fr-edit-sheettab-left-bg-";
				$box = $("<div></div>").addClass(prefix + "rs").appendTo($("<div></div>").addClass("fr-edit-sheettab-left-fixbox").appendTo($("<td></td>").appendTo($tr)));
				self.left_tabbuttons[0] = self._createIntersectSheetTabItem($box, prefix);
			} else {
				prefix = "fr-edit-sheettab-cover-bg-";
				$box = $("<div></div>").addClass(prefix + "ns").appendTo($("<div></div>").addClass("fr-edit-sheettab-cover-fixbox").appendTo($("<td></td>").appendTo($tr)));
				self.left_tabbuttons[idx] = self._createIntersectSheetTabItem($box, prefix);
			}
			
			prefix = "fr-edit-sheettab-middle-bg-";
			$box = $("<div></div>").addClass(prefix + "unselected").appendTo($("<div></div>").addClass("fr-edit-sheettab-middle-fixbox").appendTo($("<td></td>").appendTo($tr)));
			$("<div></div>").addClass("fr-edit-sheettab-sheetname").text(item.title).appendTo($box);
			self.center_tabbuttons[idx] = self._createSheetTabItem($box, idx, prefix);
			
			if (idx == self.tabs.length - 1) {
				prefix = "fr-edit-sheettab-right-bg-";
				$box = $("<div></div>").addClass(prefix + "ns").appendTo($("<div></div>").addClass("fr-edit-sheettab-right-fixbox").appendTo($("<td></td>").appendTo($tr)));
				self.left_tabbuttons[idx + 1] = self._createIntersectSheetTabItem($box, prefix);
			}
		});
		
		$("<div></div>").addClass("fr-edit-sheettab-blank").appendTo($("<td></td>").appendTo($tr));
		
		this.center_tabbuttons[0].select(true);
		this.left_tabbuttons[1].state(1);
		
		this.tab_length = 72 * this.tabs.length + 25;
	},
	
	_initParameterFormPane : function() {
    	return $("<div>").appendTo($('body')).addClass("parameter-container");
    },
	
	_initScrollBar : function() {
		var self = this;		

		self.$scroll_outterbox = $("#landscape-scroll-outterbox:eq(0)", FR.EDIT.$sheetscrollpane);
		self.$scroll_innerbox = $("#landscape-scroll-innerbox:eq(0)", FR.EDIT.$sheetscrollpane);
		self.scroll_scale = 1;
		self.scroll_ready = true;
		
		self.scroll_with_scrollbox = function(e){
			self.curLGP.$sheet_outter_container.scrollLeft(self.$scroll_outterbox.scrollLeft() * self.scroll_scale);
		};
		
		this.$scroll_outterbox.bind('scroll', self.scroll_with_scrollbox);
	},
	
	_setScrollBar : function(pane) {
		if (this.scroll_state == 0) { // =0ĻȲ㣬ȵڶι㣬Ҫʱи첽ء
			this.scroll_state = 1;
			return;
		}
		this._initScrollBarState(pane);
		this.$scroll_outterbox.scrollLeft(this.curLGP.$sheet_outter_container.scrollLeft() / this.scroll_scale);
		
		this.scroll_state = 2;
	},
	
	_initScrollBarState : function(pane) {
		if (!pane) pane = this.curLGP;
		var outter_width = pane.$sheet_outter_container.width();
		var inner_width = pane.$sheet_inner_container.width() + 17; // Ϲ17px
		
		var scroll_outter_width = this.$scroll_outterbox.width();
		var scroll_inner_width = inner_width / outter_width * scroll_outter_width;
		this.$scroll_innerbox.width(scroll_inner_width);
		
		this.scroll_scale = ((outter_width - inner_width) / (scroll_outter_width -  scroll_inner_width));
	},
	
	_scrollWithContent : function() {
		this.$scroll_outterbox.unbind('scroll', this.scroll_with_scrollbox);
		this.$scroll_outterbox.scrollLeft(this.curLGP.$sheet_outter_container.scrollLeft() / this.scroll_scale);
		setTimeout('FR.EDIT.contentPane._bindScrollEvent();', 50);
	},
	
	_bindScrollEvent : function() {
		this.$scroll_outterbox.bind('scroll', this.scroll_with_scrollbox);
	},
	
	_createSheetTabItem : function($box, idx, prefix) {
		var self = this;
		$box.click(function(e) {
			self.selectTab(idx);
		});
		
		return {
			box : $box,
			select : function(selected) {
				if (selected) {
					this.box.removeClass(prefix + "unselected");
					this.box.addClass(prefix + "selected");
				} else {
					this.box.removeClass(prefix + "selected");
					this.box.addClass(prefix + "unselected");
				}
			}
		};
	},
	
	_createIntersectSheetTabItem : function($box, prefix) {
		return {
			box : $box,
			state : function(state) {
				if (state == 0) { // ѡ
					this.box.removeClass(prefix + "ls");
					this.box.removeClass(prefix + "rs");
					this.box.addClass(prefix + "ns");
				} else if (state == 1) { // ѡ
					this.box.removeClass(prefix + "ns");
					this.box.removeClass(prefix + "rs");
					this.box.addClass(prefix + "ls");
				} else if (state == 2) { // ѡ
					this.box.removeClass(prefix + "ls");
					this.box.removeClass(prefix + "ns");
					this.box.addClass(prefix + "rs");
				}
			}
		};
	},
	
	selectTab : function (idx) {
		if (idx < 0) idx = 0;
		if (idx > this.tabs.length - 1) {
			idx = this.tabs.length - 1;
		}
		if (this.selectedIndex != idx) {
			// ȵsheettabʽ
			this.left_tabbuttons[this.selectedIndex].state(0);
			this.left_tabbuttons[this.selectedIndex + 1].state(0);
			this.center_tabbuttons[this.selectedIndex].select(false);
			
			this.left_tabbuttons[idx].state(2);
			this.left_tabbuttons[idx + 1].state(1);
			this.center_tabbuttons[idx].select(true);
			
			this.fireEvent(FR.Events.TABCHANGE, idx);
		}
	},
	
	// Carl ctrl + v 
    pasteCells : function() {
        var lastSelectedTDCell = this.curLGP.currentTDCell;
        if (lastSelectedTDCell == null) {
            return;
        }
        	
        var value = this.$cpTextArea.val();
        if (value == null || value == '') {
        	return;
        }
        	
        this.curLGP.stopCellEditing();

        var rows = value.split("\n");
        var clos;
        var editorEl;
	    for (i = 0; i< rows.length; i++) {
	        cols = rows[i].split("\t");
	        for (j = 0; j < cols.length; j++) {
	        	var cell = this.curLGP.getTDCellByExactPosition(lastSelectedTDCell.col + j, lastSelectedTDCell.row + i);
	        	if (cell != null && cols[j] != null && cols[j].length > 0) {
	        		this.curLGP.setCellValue(cell, cols[j]);
	        		this.curLGP.displayTDCell(cell, cols[j]);
	        	}
	        }
	    }
	    if (rows.length == 1) {
        	cols = rows[0].split("\t");
        	if (cols.length == 1) {
        		if (this.curLGP.cellEditing == null) {
					this.curLGP.editTDCell(null, true);
				}
        	}
        }
    }
});

/*
 * carl:ȳwrite.js ṹһ
 */
FR.ELGP = function(config) {
    config = config || {};
    this.initialConfig = config;
    $.extend(this, config);

    this.loaded = false;
}

FR.extend(FR.ELGP, $.FR.OB, function() {
	//default IE
    var tadjst = -1, ladjst = -1, wadjst = 3, hadjst = 3, etadjst = 0, eladjst = 1, ewadjst = -1, ehadjst = +2, radjst = 1;
    if ($.browser.mozilla || $.browser.opera) {//firefox or opera
        tadjst = -1,ladjst = -1,wadjst = -3,hadjst = -3,etadjst = 0,eladjst = 0,ewadjst = -1,ehadjst = +1, radjst = 0;
    } else if ($.browser.safari) {//for safari and chrome
    	tadjst = -1,ladjst = -1,wadjst = -3,hadjst = -3,etadjst = 0, eladjst = 0,ewadjst = +1,ehadjst = +3, radjst = 1;
    }
    var UP = 1, DOWN = 2, LEFT = 3, RIGHT = 4, EE = $.ui.keyCode;// KeyCodeд
//    function isCell(dom) {
//    	var $dom = $(dom);
//    	return $dom.is('td') && $dom.attr('id').match(/^[A-Z]+\d+-\d+-\d+$/);
//    }
    
    return {
        $container:null,
        $sheet_inner_container:null,
        $sheet_outter_container:null,
        /**
         * writePane:$.FR.WritePane this lgp belongs to
         */
        editPane:null,
        /*
         * idx in writePane
         */
        idx:0,
        /*
         * ColumnRow -> [TD]
         */
        relationship : {}, // ColumnRow -> [ColumnRow] keyӸı,ЩֱصĸҪı
        relationship2 : {} , // ColumnRow -> [ColumnRow] relationship෴
        
        keyevent : null,
        
        __moving__ : false, // Ƿƶ...
        
        undo_fn_array : [],
		redo_fn_array : [],
		do_idx : 0,
		
        /*
         * Panel
         */
        loadLGPPane : function() {
            if(this.editPane.isLoadingPage == this.idx) {
                return;
            }
 
            this.fireEvent(FR.Events.STARTLOAD);
            this.editPane.isLoadingPage = this.idx;
            
            this.$container.__load__({
                url:this.editPane.servletURL,
                timeout : 600000,
                // richerһ⻺Ӱ
                params:{op:"edit_content", sessionID:this.editPane.currentSessionID, reportIndex:this.idx, iid:Math.random()},
                callback:function(el, success, res, options) {
                    if(success) {
						this.initLGPComponent();
					} else {
						//ɹĻ,ҲҪѱϢдҳ
						this.$container.html(res.responseText);
					}

                    this.editPane.curLGP = this;

                    //fire formPaneafterload¼,thisΪȥ
                    this.editPane.fireEvent(FR.Events.AFTERLOAD, this);
                    
					// alex:this.$containerΪǰformPane.ContentContainer
					this.editPane.$currentContentContainer = this.$container;

                    this.editPane.isLoadingPage = -1;

                    delete this.loaded;
                }.createDelegate(this)
            });
        },
        
        /*
         * ʼLGPComponent
         */
        initLGPComponent:function() {
        	this.$sheet_container = $('.sheet-container:eq(0)', this.$container);
        	
            var $center = this.$sheet_container.children('.frozen-center:eq(0)');
            // richer:жŰlayout
			if ($center.length > 0) {
				this.$container.css('overflow-y', 'hidden');
				// alex:doLayout
				this.$container.asComponent("borderlayout", {items:[{
					region : 'center',
					el : this.$sheet_container
				}]});
				FR.layoutFrozen(this.$sheet_container);
				// alex:겼ֺһdoLayout
				this.$container.doLayout();
				
				this.$sheet_outter_container = $center;
				this.$sheet_inner_container = $(".x-table:eq(0)", $center);
				$center.css("overflow-x", "hidden");
				
				this.$sheet_container.children('.frozen-west:eq(0)').css("overflow-x", "hidden");
			} else {
				this.$sheet_inner_container = this.$sheet_container.children(".fr-edit-sheetcontent-container:eq(0)");
				this.$sheet_outter_container = this.$container;
			}
			// ʼĹ
			this.editPane._setScrollBar(this);
			
            // ʼ༭
	        this.$editor = $("<div></div>").addClass("x-editor").css("position", "absolute")
	            	.css("display", "none").css("z-index", 15).css("padding-left", 0).appendTo(this.$sheet_container);
	        this.editorEl = $("<textarea style='position:absolute;'></textarea>").addClass('fr-edit-editor-input').appendTo(this.$editor);
	        
	        this.editor_fontCheckBox = $("<div style='position:absolute;top:-2000px;'></div>").addClass('fr-edit-editor-input').appendTo(this.$sheet_container);
	        // Ӽ¼
	        var self = this;
	        // ΪҪkeyup¼첻ͳһ__onKeyDown
	        this.editorEl.valuechange = function() {
	        	var value = self.editorEl.val();
				// 4ֵĳ
				self.editor_fontCheckBox.text(value + "-ʶ-");
				if (value.startWith('=')) {
					value = value.substring(1, value.length);
				}
				FR.EDIT.$vp_editor.setValue(value);
				var width = self.editor_fontCheckBox[0].offsetWidth;
				
				if (width < self.editorEl.defaultWidth) {
					self.$editor.width(self.editorEl.defaultWidth);
					self.editorEl.width(self.editorEl.defaultWidth);
				} else {
					self.$editor.width(width);
					self.editorEl.width(width);
				}
	        };
	        this.editorEl.keyup(function(e) {
				self.editorEl.valuechange();
			});
			
	        // ʼѡ
	        this.$fD = {};
	        this.$fD.ftop = $("<div><a style='width:1px;height:1px;overflow:hidden;'></a></div>").addClass('fDtop').appendTo(this.$sheet_container);
	        this.$fD.fleft = $("<div><a style='width:1px;height:1px;overflow:hidden;'></a></div>").addClass('fDleft').appendTo(this.$sheet_container);
	        this.$fD.fbottom = $("<div><a style='width:1px;height:1px;overflow:hidden;'></a></div>").addClass('fDbottom').appendTo(this.$sheet_container);
	        this.$fD.fright = $("<div><a style='width:1px;height:1px;overflow:hidden;'></a></div>").addClass('fDright').appendTo(this.$sheet_container);
	        this.$fD.fdot = $("<div><a style='width:5px;height:5px;overflow:hidden;'></a></div>").addClass('fDdot').appendTo(this.$sheet_container);
			
			this.$fD.fRect = $("<div><a style='width:5px;height:5px;overflow:hidden;'></a></div>").addClass('fRect').appendTo(this.$sheet_container);
            
			// TODO ʼи ff 843 / 3296  IE7 2217 / 3296 ߵ黯Ҫε
			var self = this;
			this.cell_table = [];
			var $table;
		    this.col_ranges = [];
			this.col_ranges[0] = 0;
			this.row_ranges = [];
			this.row_ranges[0] = 0;
			var addTdCell = function(row, col, cell) {
				if (!self.cell_table[row]) self.cell_table[row] = [];
				self.cell_table[row][col] = cell;
			};
			var initCell = function(check) {
				var $trs = $table.find('tbody:eq(0)').children();
				if (check) {
					var $cols = $table.find("colgroup:eq(0)").children();
					var col_idx;
					var $col;
					// carl:пΪ0colǲģҪ긳ֵ
					$.each($cols, function(idx, col) {
						$col = $(col);
						col_idx = parseInt($col.attr("col")) + 1;
						var n = 1;
						while (self.col_ranges[col_idx - n] == null && n <= col_idx) {
							n++;
						}
						for (var i = 1; i < n; i++) {
							self.col_ranges[col_idx - n + i] = self.col_ranges[col_idx - n];
						}
						self.col_ranges[col_idx] = self.col_ranges[col_idx - 1] + parseInt($col.css("width"));
					});
				}
				var se_td;
				var se_row;
				var se_col;
				var $tr;
				var row_size = self.row_ranges.length;
				$.each($trs, function(idx, tr){
					$tr = $(tr);
					if (check) {
						self.row_ranges[idx + row_size] = self.row_ranges[idx + row_size - 1] + tr.offsetHeight;
					}
					$tr.attr('th', tr.offsetHeight);
				});
				$.each($trs, function(idx, tr){
					$tr = $(tr);
					$.each($('td[id]', $tr), function(iidx, td){
						se_td = $(td);
						se_row = parseInt(se_td.attr("row"));
						se_col = parseInt(se_td.attr("col"));
						addTdCell(se_row, se_col, se_td);
						// TODO carl:̨ʱظԪ˴ҪжипǷΪ0
						var offset_rowSpan = 0;
						var offset_colSpan = 0;
						if (td.rowSpan > 1 || td.colSpan > 1) {
							for (var i = 0; i < td.rowSpan + offset_rowSpan; i++) {
								if (self._getRowHeight(se_row + i) == 0) {
									offset_rowSpan++;
									continue;
								}
								for (var j = 0; j < td.colSpan + offset_colSpan; j++) {
									if (self._getColWidth(se_col + j) == 0) {
										offset_colSpan ++;
										continue;
									}
									if (i == 0 && j == 0) continue;
									addTdCell(se_row + i, se_col + j, {first_row : se_row, first_col : se_col});
								}
							}
						}
					});
				});
			};
			// 
			if ($center.length > 0) {
				this.$frozen_corner = this.$sheet_container.children('.frozen-corner:eq(0)');
				$table = $('.x-table:eq(0)', this.$frozen_corner);
				initCell(true);
				// ȡߵı߽
				this.frozen_col = this.col_ranges.length - 1;
				this.frozen_row = this.row_ranges.length - 1;
				this.frozen_x = this.col_ranges[this.frozen_col];
				this.frozen_y = this.row_ranges[this.frozen_row];
				this.$frozen_center = $center;
				$table = $('.x-table:eq(0)', $center);
				initCell(true);
				this.$frozen_north = this.$sheet_container.children('.frozen-north:eq(0)');
				$table = $('.x-table:eq(0)', this.$frozen_north);
				initCell(false);
				this.$frozen_west = this.$sheet_container.children('.frozen-west:eq(0)');
				$table = $('.x-table:eq(0)', this.$frozen_west);
				initCell(false);
				
				$table = $('.x-table:eq(0)', this.$frozen_corner);
				this.frozen_area = 1;
			} else {
	            $table = $('.x-table:eq(0)', this.$sheet_container);
	            initCell(true);
			}
			
			this.tableID = $table.attr("id");
			
			this.table_width = this.col_ranges.length - 1;
			this.table_height = this.row_ranges.length - 1;

            // Ϊ$sheet¼
            this.$sheet_container.mousedown(function(e) {
            	self.onfocus();
            	self.last_move_tar = null;
            	
	            var xy = self.getRealXY(e);
	            
	            var secell = self.findTDCellByclientXY(xy.x, xy.y);
	            
				if (secell) {
					self.currentSelectTDCellPosition = {col:secell.col, row:secell.row};
					self.selectTDCell(secell, true);
					self.last_move_tar = self.currentTDCell;
					
					e.preventDefault();
					e.stopPropagation();
				}
            }).mousemove(function(e){
            	if (self.last_move_tar != null) {
            		e.preventDefault();
					e.stopPropagation();
					
	            	var xy = self.getRealXY(e);
	            	
	            	if (xy.x < self.col_ranges[self.last_move_tar.col + 1] && xy.x >= self.col_ranges[self.last_move_tar.col]
	            			&& xy.y < self.row_ranges[self.last_move_tar.row + 1] && xy.y >= self.row_ranges[self.last_move_tar.row]) {
	            		return;
	            	}
	            	
	            	var secell = self.findTDCellByclientXY(xy.x, xy.y);
	            	
	            	if (secell) {
	            		if (self.frozen_area && self.frozen_area != self.findFrozenArea(secell)) {
	            			return;
	            		}
	            		
	            		self.last_move_tar = secell;
	            		
	            		self.$fD.end_xy = self.getTDCellXYRange(secell);
           	 			
            			var tx, ty, bx, by;
            			if (self.currentTDCell.col > secell.col) {
            				tx = self.$fD.end_xy.tx;
            				bx = self.$fD.begin_xy.bx;
            			} else {
            				tx = self.$fD.begin_xy.tx;
            				bx = self.$fD.end_xy.bx;
            			}
            			
            			if (self.currentTDCell.row > secell.row) {
            				ty = self.$fD.end_xy.ty;
            				by = self.$fD.begin_xy.by;
            			} else {
            				ty = self.$fD.begin_xy.ty;
            				by = self.$fD.end_xy.by;
            			}
            			
            			if (self.frozen_x) {
			            	if (((ty + by)/2) > self.frozen_y) {
			            		ty -= self.frozen_y;
			            		by -= self.frozen_y;
			            	}
			            	if (((tx + bx)/2) > self.frozen_x) {
			            		tx -= self.frozen_x;
			            		bx -= self.frozen_x;
			            	}
			            }
            			
           	 			self.$fD.fRect.css({top : ty, left : tx + radjst, height : by - ty, width : bx + radjst - tx});
	            	}
            	}
            })
            
            .mouseup(function(e){
            	self.dealwithmouseup();
            })
            
            .dblclick(function(e) {
            	self.last_move_tar = null;
	            var xy = self.getRealXY(e);
	            
	            var secell = self.findTDCellByclientXY(xy.x, xy.y);
				if (secell) {
					self.editTDCell(secell);
				}
            });
            
            $(document).mouseup(function(e){
            	if (self.last_move_tar) {
            		self.dealwithmouseup();
            	}
            });
            
            // ʽĶ
            this.calculator = FormulaParser(this);
            
            // TDĹʽϵ
            $('td.fh[fm]', $table).each(function(idx, td) {
            	self.relationship_refresh(td);
            })
            
           	$('td[row]', $table).each(function(idx, td) {
           		se_td = $(td);
           		var setd = self.getTDCellByExactPosition(parseInt(se_td.attr("row")), parseInt(se_td.attr("col")));
	        	if (self.isSelectable(setd)) {
	        		self.currentSelectTDCellPosition = {col:setd.col, row:setd.row};
	        		self.selectTDCell(setd);
	        		return false;
	        	}
	        });
            
            // onfocusļ
            $(document).mousedown(function(e) {
            	self[
	            	$(e.target).parents('#fr-edit-main').length > 0
	            	? 'onfocus' : 'unfocus'
            	]();
            });
            
            // carl:ò̫õĴýʱע¼ʧȥʱƳ¼
            this.keyevent = {scope : this, fn : this._onKeyDown};
            this.onfocus();
        },
        
        findFrozenArea : function(cell) {
        	if (cell.row >= this.frozen_row) {
				if (cell.col >= this.frozen_col) {
					return 4;
				} else {
					return 3;
				}
			} else {
				if (cell.col >= this.frozen_col) {
					return 2;
				} else {
					return 1;
				}
			}
        },
        
        getRealXY : function(e) {
        	var x = e.clientX;
        	if (!this.frozen_x || x >= this.frozen_x) {
        		x += this.$sheet_outter_container.scrollLeft();
        	}
	        var y = e.clientY - 60 - this.editPane.parampane_height;
	        if (!this.frozen_y || y >= this.frozen_y) {
	        	y += this.$sheet_outter_container.scrollTop();
	        }
	        
	        return {x:x, y:y};
        },
        
        getFrozenPane : function(id) {
        	if (id == 4) {
        		return this.$frozen_center;
        	} else if (id == 3) {
        		return this.$frozen_west;
        	} else if (id == 2) {
        		return this.$frozen_north;
        	} else if (id == 1) {
        		return this.$frozen_corner;
        	}
        },
        
        findTDCellByclientXY : function(x, y) {
        	// ҿ TODO ŪɶֲЧ
	        var row;
	        for(row = 0; row < this.row_ranges.length; row++) {
	            if (this.row_ranges[row] > y) {
	            	row = row - 1;
	            	break;
	            }
	        }
	        var col;
	        for(col = 0; col < this.col_ranges.length; col++) {
	            if (this.col_ranges[col] > x) {
	            	col = col - 1;
	            	break;
	            }
	        }
	        
	        return this.getTDCell(col, row);
        },
        
        getTDCellXYRange : function(tdCell) {
        	if (tdCell) {
        		// TODO carl:̨ʱظԪ˴ҪжипǷΪ0
        		var rs = tdCell.cell[0].rowSpan;
        		for (var i = 0; i < rs; i++) {
        			if (this._getRowHeight(tdCell.row + i) == 0) rs++;
        		}
        		var cs = tdCell.cell[0].colSpan;
        		for (var i = 0; i < cs; i++) {
        			if (this._getColWidth(tdCell.col + i) == 0) cs++;
        		}
	        	return {tx : this.col_ranges[tdCell.col], ty : this.row_ranges[tdCell.row],
	        		bx : this.col_ranges[tdCell.col + cs], by : this.row_ranges[tdCell.row + rs]};
        	}
        	
        	return null;
        },
        
        _getColWidth : function(col) {
        	if (col < 0 && (col+1) >= this.col_ranges.length) return -1;
        	return this.col_ranges[col + 1] - this.col_ranges[col];
        },
        
        _getRowHeight : function(row) {
        	if (row < 0 && (row+1) >= this.row_ranges.length) return -1;
        	return this.row_ranges[row + 1] - this.row_ranges[row];
        },
        
        dealwithmouseup : function() {
        	var self = this;
        	var secell = self.last_move_tar;
            if (!secell || secell == self.currentTDCell) {
            	secell = self.currentTDCell;
            	
            	var ty = self.$fD.begin_xy.by;
            	var tx = self.$fD.begin_xy.bx;
            	if (self.frozen_x) {
			        if (ty > self.frozen_y) ty -= self.frozen_y;
			        if (tx > self.frozen_x) tx -= self.frozen_x;
			    }
            		
            	self.$fD.fdot.css({top: ty + tadjst + hadjst + + ($.browser.msie ? 0 : 6) - 5, left: tx + radjst + ladjst + wadjst + + ($.browser.msie ? 0 : 6) - 5});
            	self.currentTDCells = null;
            } else {
				var bx, by, fc, fr, tc, tr;
            	if (self.currentTDCell.col > secell.col) {
            		bx = self.$fD.begin_xy.bx;
            		tc = self.currentTDCell.col;
            		fc = secell.col;
            	} else {
            		bx = self.$fD.end_xy.bx;
            		fc = self.currentTDCell.col;
            		tc = secell.col;
            	}
            			
            	if (self.currentTDCell.row > secell.row) {
            		by = self.$fD.begin_xy.by;
            		tr = self.currentTDCell.row;
            		fr = secell.row;
            	} else {
            		by = self.$fD.end_xy.by;
            		fr = self.currentTDCell.row;
            		tr = secell.row;
            	}
            	
            	if (self.frozen_x) {
			        if (by > self.frozen_y) by -= self.frozen_y;
			        if (bx > self.frozen_x) bx -= self.frozen_x;
			    }
            	
            	self.$fD.fdot.css({top: by + tadjst + hadjst + + ($.browser.msie ? 0 : 6) - 5, left: bx + radjst + ladjst + wadjst + + ($.browser.msie ? 0 : 6) - 5});
            		
				self.currentTDCells = self.getRangeTDCells(fc, fr, tc, tr);
				self.currentTDCellRange = {col : fc, row : fr, colSpan : tc - fc + 1, rowSpan : tr - fr + 1};
			}
				
			self.last_move_tar = null;
        },
        
        onfocus : function() {
        	if (this.keydown_focus) return;
			FR.Keys.reg(this.keyevent);
			this.keydown_focus = true;
        },
        
        unfocus : function() {
        	if (!this.keydown_focus) return;
			FR.Keys.unreg(this.keyevent);
			this.keydown_focus = false;
        },
        
        /*
         * ¼
         */
        _onKeyDown : function(e) {
        	var k = e.keyCode;
			// p: delete.
			if (k == EE.DELETE) {
				if (this.cellEditing == null) {
					var curCell = this.currentTDCell;
					if (curCell != null && $(curCell).attr('editor') != null) {
	                    this.displayTDCell(curCell, "");
						this.setCellValue(curCell, "");
					}
				}
			}
			// ctrl + v
			else if (e.ctrlKey && k == 86) {
				var el;
				if ($.browser.msie) {
					el = e.srcElement;
				} else {
					el = e.target;
				}
				var tag = el.tagName;
				//alert(tag);
				// carl¼ð֮ctrl+vͲ
				if (tag != "INPUT" && tag != "TEXTAREA") {
					var cp = this.editPane.$cpTextArea;
					cp.focus();
					cp.select();
					setTimeout("_g('" + this.editPane.currentSessionID + "').pasteCells()", 50);
				}
			}
			// a-zA-Z0-9ʼ༭(alex:keydown¼,aA65,keypress¼iea97),[96~105]ұߵС̰
			// 229뷨صXX
			else if (k == EE.SPACE || k >= 48 && k <= 57 || k >= 65 && k <= 90 || k >= 96 && k <= 105 || k == 109 || k ==189 || k == 229) {
				if (this.cellEditing == null) {
					this.editTDCell(null, true);
					// alex:ǰո,ǿʼ༭,Ҫѿոд༭
					if (k == EE.SPACE) {
						e.preventDefault();
						e.stopPropagation();
					}
				} else {
					
				}
			} else {
				var direction = 0;
				
				// richer:tab
				if (e.shiftKey && k == EE.TAB) {
					direction = LEFT;
				// shift + enter
				} else if (e.shiftKey && k == EE.ENTER) {
					direction = UP;
				// tab	
				} else if (!e.shiftKey && k == EE.TAB) {
					direction = RIGHT;
				// enter
				} else if (!e.ctrlKey && k == EE.ENTER) {
					direction = DOWN;
				// left
				} else if (!e.ctrlKey && k == EE.LEFT) {
					if (this.cellEditing != null)
						return;
					direction = LEFT;
				// right
				} else if (!e.ctrlKey && k == EE.RIGHT) {
					if (this.cellEditing != null)
						return;
					direction = RIGHT;
				// up
				} else if (!e.ctrlKey && k == EE.UP) {
					direction = UP;
				// down
				} else if (!e.ctrlKey && k == EE.DOWN) {
					direction = DOWN;
				}
	
				if (direction == 0) {
					return;
				}
	
				e.preventDefault();
				e.stopPropagation();
				this.moveTDCell(direction);
			}
		},
		
		/*
         * õcolumnrowӦظ
         */
        relationship_get : function(columnrow) {
        	var ret = this.relationship[columnrow];
        	return ret == null ? [] : ret;
        },
        
        relationship_add : function(sourceColumnRow, relatedColumnRow) {
        	var ret = this.relationship[sourceColumnRow];
        	if (ret == null) {
        		this.relationship[sourceColumnRow] = ret = [];	
        	}
        	if (ret.indexOf(relatedColumnRow) < 0) {
        		ret.push(relatedColumnRow);	
        	}
        },
        
        relationship2_add : function(sourceColumnRow, relatedColumnRow) {
        	var ret = this.relationship2[sourceColumnRow];
        	if (ret == null) {
        		this.relationship2[sourceColumnRow] = ret = [];	
        	}
        	if (ret.indexOf(relatedColumnRow) < 0) {
        		ret.push(relatedColumnRow);	
        	}
        },
        
        /*
         * ˢĳtdظ
         */
        relationship_refresh : function(td) {
        	var columnrowString = this.cut2ColumnRowString(td);
        	var mm = this.relationship2[columnrowString];
        	if (mm != null) {
        		for (var i = 0; i < mm.length; i++) {
        			var xx = mm[i];
        			this.relationship[xx].remove(columnrowString)
        			if (this.relationship[xx].length == 0) {
        				delete this.relationship[xx];	
        			}
        		}
        	}
        	delete this.relationship2[columnrowString];
        	
        	var fm = $(td).attr('fm');
        	if (fm != null) {
        		this.calculator.relatedColumnRow(fm, columnrowString);
        	}
        },
        // ȷҵcell
        getTDCellByExactPosition : function(ccol, crow) {
        	var cellObj = this._getTDCellFromCache(ccol, crow);
        	if (!cellObj || cellObj.cell.first_row != null) {
        		return null;
        	}
        	return cellObj;
        },
        
        _getTDCellFromCache : function(ccol, crow) {
        	if (this.cell_table[crow] && this.cell_table[crow][ccol]) {
        		return {cell : this.cell_table[crow][ccol], row : crow, col : ccol};
        	} else {
        		return null;
        	}
        },
        
        // ģҵcellӸԪеһλҵϲԪ
        getTDCell : function(ccol, crow) {
        	var cellObj = this._getTDCellFromCache(ccol, crow);
        	if (cellObj && cellObj.cell.first_row != null) { // ʾǺϲԪеһ
        		cellObj = this._getTDCellFromCache(cellObj.cell.first_col, cellObj.cell.first_row);
        	}
        	
        	return cellObj;
        },
        
        getDocTDCell : function(ccol, crow) {
        	var cellInfo = this.getTDCellByExactPosition(ccol, crow);
        	return cellInfo != null ? cellInfo.cell[0] : null;
        }, 
        
        getTDCellByStringPosition : function(columnRowStr) {
        	var ob = FR.cellStr2ColumnRow(columnRowStr);
        	if (ob != null) {
        		return this.getTDCellByExactPosition(ob.col, ob.row);
        	}
        	return null;
        },
        
        getDocTDCellByStringPosition : function(columnRowStr) {
        	var cellInfo = this.getTDCellByStringPosition(columnRowStr);
        	return cellInfo != null ? cellInfo.cell[0] : null;
        },
        
        setAndDisplayCellValue : function(cellInfo, value, action) { // undo redo 
        	this.displayTDCell(cellInfo, value);
        	this.setCellValue(cellInfo, value, action);
        },
        
        setCellValue : function(cellInfo, value, action) {
        	if (cellInfo && cellInfo.cell) {
        		if (action != false) {
        			FR.EDIT.addAction(
        				{fn : this.setAndDisplayCellValue, scope : this, args : [cellInfo, this.getCellRealValue(cellInfo), false]},
						{fn : this.setAndDisplayCellValue, scope : this, args : [cellInfo, value, false]}
					);
				}
        		var cell = cellInfo.cell;
        		cell.cv = value;
        		cell.vd = true;
        		cell.dirty = true;
        		
//        		tdCell.cell.attr("cv", FR.jsonEncode(cv));
        		
        		var fm = null;
        		if (typeof value == 'string' && value.match(/^=/)) {
	                //if startwith =
	                fm = value.substring(1);
	            }
        		if (fm == null) {
	            	cell.removeAttr("fm");
	            } else {
	            	cell.attr('fm', fm);
	            }
	            
	            this.relationship_refresh(cell[0]);
	
	            // ¼ ǰ޸ĵĵԪ + ֮صĵԪ
	            this.calculator.recalculate([FR.id2ColumnRowStr(cell.attr("id"))]);
        	}
        },
        
        setCellShowValue : function(cellInfo, value) {
        	if (cellInfo && cellInfo.cell) {
        		cellInfo.cell.cv = value;
        		// ԶʽҲˣҪʱrecalculateʱ
        		cellInfo.cell.dirty = true;
        	}
        },
        
        getCellRealValue : function(cellInfo) {
        	if (cellInfo == null) return null;
        	var fm = cellInfo.cell.attr('fm');
        	if (fm == null) {
        		return this.getCellValue(cellInfo);
        	}
        	return '=' + fm;
        },
        
        getCellValue : function(cellInfo) {
        	if (cellInfo && cellInfo.cell) {
        		var cell = cellInfo.cell;
        		if (cell.cv === undefined) {
        			var json_cv = cell.attr('cv');
        			var cv;
					if (json_cv == null) {
						cv = null;
					} else {
						cv = FR.jsonDecode(json_cv);
					}
					cell.cv = cv;
					return cv;
        		} else {
        			return cell.cv;
        		}
        	}
        	
        	return null;
        },
        
        /*
         * dom tdCellǷɱѡ
         */
        isSelectable : function(tdCell) {
        	if(tdCell == null || tdCell.cell == null) return false;
        	return tdCell.cell.css('display') != 'none' && tdCell.cell[0].offsetHeight > 0 && tdCell.cell[0].offsetWidth > 0;
        },
        
        selectTDCell : function(tdCell, fromMouse) {
        	this.stopCellEditing();
        	if (!tdCell) return;
            this.currentTDCell = tdCell;
            //alex:ע,fire editPane.event,this.event
            this.editPane.fireEvent("cellselect", this.currentTDCell);
            
            this.displayFD(tdCell, fromMouse);
            
            // ٰѡص
            this.$fD.fRect.css({top : -1000, left : -1000, width : 0, height : 0});
            
            // ҪfDoffsetParentcurrentTDCell.offsetParentͬ
            if (this.frozen_area) {
				var c_frozen_area = this.findFrozenArea(this.currentTDCell);
				if (this.frozen_area != c_frozen_area) {
					this.frozenPane = this.getFrozenPane(c_frozen_area);
					this.frozenPane.append(this.$fD.ftop);
            		this.frozenPane.append(this.$fD.fleft);
            		this.frozenPane.append(this.$fD.fbottom);
            		this.frozenPane.append(this.$fD.fright);
            		this.frozenPane.append(this.$fD.fdot);
            		this.frozenPane.append(this.$fD.fRect);
            		
            		this.frozenPane.append(this.$editor);
            		
            		this.frozen_area = c_frozen_area;
				}
			}
            
            var position = this.cut2ColumnRowString(this.currentTDCell.cell[0]);
            FR.EDIT.$vp_position.text(position);
            
            var cv = this.getCellRealValue(this.currentTDCell);
            if (cv == null) {
            	cv = '';
            }
            FR.EDIT.$vp_editor.setValue(cv);
            
            // alex:$scrollable
            this.currentTDCell.cell.__scroll2View__(this.$sheet_outter_container);
            this.editPane._scrollWithContent();
            
            FR.EDIT._showFontFamily(null, this.currentTDCell.cell);
            FR.EDIT._showFontSize(null, this.currentTDCell.cell);
        },
        
        displayFD : function(tdCell, fromMouse) {
        	this.$fD.begin_xy = this.getTDCellXYRange(tdCell);
            var f_top = this.$fD.begin_xy.ty + tadjst;
            var f_left = this.$fD.begin_xy.tx + radjst + ladjst;
            var f_width = tdCell.cell[0].offsetWidth + wadjst + ($.browser.msie ? 0 : 6);
            var f_height = tdCell.cell[0].offsetHeight + hadjst + + ($.browser.msie ? 0 : 6);
            
            if (this.frozen_row) {
            	if (tdCell.row >= this.frozen_row) f_top -= this.frozen_y;
            	if (tdCell.col >= this.frozen_col) f_left -= this.frozen_x;
            }
            
            // carl:5
            this.$fD.ftop.css({top : f_top, left: f_left, width : f_width});
            this.$fD.fleft.css({top: f_top + 3, left : f_left, height : f_height - 6});
            this.$fD.fbottom.css({top: f_top + f_height - 3, left: f_left, width : f_width});
            this.$fD.fright.css({top: f_top + 3, left: f_left + f_width - 3, height : f_height - 6});
            
            if (!fromMouse) { // 갴ʱʾ
            	this.$fD.fdot.css({top: f_top + f_height - 5, left: f_left + f_width - 5});
            } else {
            	this.$fD.fdot.css({top: -1000, left: -1000});
            }
        },
        
        /*
         * ༭dom tdCell
         * 
         * fromKey Ƿ¼edit
         */
        editTDCell : function(tdCell, fromKey, nofocus) {
            if (!tdCell) {
                tdCell = this.currentTDCell;
            }
            //alex:must be TD; check out if the cell in editing; check out editable
            if (this.cellEditing && tdCell == this.cellEditing) {
                return;
            }
            
            this.stopCellEditing();
			
			/*
			 * ȡñ༭Ҫ༭
			 * ҵ˳Ϊ
			 * fm(formula) -> cv(Cell.Value) -> text(TD.text())
			 * ༭͵Ļ,Ҫתֵ(TODO ǷԿǰתŵ༭ڲȥ)
			 */
            var editContent = this.getCellRealValue(tdCell);
            if (editContent == null) {
            	editContent = tdCell.cell.text()
            }
            var val = editContent;
            
			if (typeof val == 'string') {
				val = val.replace(/<br>/g, "\n");
			}
			 
			 // ȡtr,safarichrometdtopȽңtrĻǱȽһµ
            var $tr = tdCell.cell.parent();
            var top = $tr[0].offsetTop - 2;
            var left = tdCell.cell[0].offsetLeft - 2;
            
            this.$editor.css({top : top + etadjst, left : left + eladjst}); 
            
            var el_width = tdCell.cell[0].offsetWidth + ewadjst;
            var el_height = tdCell.cell[0].offsetHeight + ehadjst;
            el_width = el_width > 70 ? el_width + 5 : 75;
            el_height = el_height > 20 ? el_height + 3 : 23;
            
            this.$editor.css({width : el_width, height : el_height});
            this.editorEl.css({width : el_width, height : el_height});
            
            this.editorEl.defaultWidth = el_width + 2;
	        
            if (!fromKey) {
            	this.editorEl.val(val);//jamesǰԪı༭Ѿ˵£Ҫֵı༭Ĭֵ
            } else {
            	this.editorEl.val('');
            }
            
            this.$editor.show();
            if (!nofocus) {
            	// carl:࣬chromeвappendһ£ֻfocusһΣڶα༭ȡ㡣
            	if ($.browser.safari) {
            		if (this.forzenPane) {
            			this.frozenPane.append(this.$editor);
            		} else {
            			this.$sheet_container.append(this.$editor);
            		}
            	}
            	this.editorEl.focus();
            }
            this.editorEl.valuechange();

            this.cellEditing = tdCell;
        },
        
        /*
         * ֵʾTD
         * 
         * cv  {text, value},ֱʾtext, Ҳһַ,dictжǷҪdictһ
         */
        displayTDCell : function(tdCell, cv) {
        	if (tdCell == null) return;
        	var cell = tdCell.cell;
        	// carl : صĵԪʾ
        	if (cell.is('.cehide')) return;
        	
        	if (cv == null) {
        		cv = '';
        	}
        	
        	if (FR.isArray(cv)) {// jamescvArrayĻôĿǰǸѡĽı༭Ŀǰȫֻһֵ
            	var content = '';
            	for (var i = 0; i < cv.length; i++) {
            		if (i != 0) {
            			content += ',';
            		}
            		content += cv[i];
            	}
            	cv = content;
            }
            
            if (typeof cv == 'string'){
            	cv = cv.replace(/\n/gi, "<br/>");
            }
//            // alex:øʽʾֵ
//            var fmt = cell.attr('fmt');
//            if (fmt == null && (cv instanceof Date || cell.attr('editor') == "date")) fmt = 'DMM/dd/yyyy';
				
            // TODO fmt
		    if (cell.is('.celink')) {
				var link_span = $('.linkspan', cell)[0];
				if (link_span) $(link_span).html(cv);
			} else {
				// richer:漰зҪ"\n"תΪ"<br/>"html()
				var content = cv + "";
				content.indexOf("<br/>") == -1 ? cell.text(content) : cell.html(content);
			}
				
			this.shrink2FitRowHeight(tdCell);
        },
        
        shrink2FitRowHeight : function(tdCell) {
        	// и, ݹŴӣҪи
        	var tr = tdCell.cell.parent();
			var tr_height = parseInt(tr.attr('th'));
			if (tr[0].offsetHeight != tr_height) {
				var more_height = tr[0].offsetHeight - tr_height;
				for (var i = tdCell.row + 1; i < this.row_ranges.length; i++) {
					this.row_ranges[i] += more_height;
				}
				tdCell.cell.parent().attr('th', tr_height + more_height);
			}
        },
        
        /*
         * һTDColumnRowString
         */
        cut2ColumnRowString : function(td) {
        	if (td == null) {
        		return null;
        	}
        	
        	var iid = $(td).attr("id");
        	return iid.substring(0, iid.length - ('-' + this.idx).length - ('-' + this.tableID).length);
        },
        
        /*
         * ѡһƬtdCell,ʱҪڹʽA1:C3Ķ
         */
        getRangeTDCells:function(fc, fr, tc, tr) {
            var cells = []
            for (var r = fr; r <= tr; r++) {
                for (var c = fc; c <= tc; c++) {
                    var cellObj = this.getTDCellByExactPosition(c, r);
                    if (cellObj)
                        cells[cells.length] = cellObj;
                }
            }
            return cells
        },
        
        // TODO
        stopCellEditing : function() {
            if (this.editorEl != null) {

                this.$editor.hide();
            }
            
            if (this.cellEditing != null) {
            	var value = this.editorEl.val();
            	value = $.trim(value);
            	// carl:ﲻisNaNжϣ16ƺͿѧڣֻ֧10
            	var re = /^[-\+]?\d+(\.\d+)?$/
            	// carl:ֵתΪ־ͱΪ
            	if (re.test(value)) {
            		value = Number(value);
            	}
            	this.displayTDCell(this.cellEditing, value);
            	this.setCellValue(this.cellEditing, value);
            }
            
            this.cellEditing = null;
            
            this.editorEl.val('');

            return true;
        },
        
        moveTDCell : function(direction) {
        	if (this.currentSelectTDCellPosition == null) {
        		return;
        	}
        	// alex:ƶ,ֱreturn(,Ҳͦʱ)
        	if (this.__moving__ === true) {
        		return;	
        	}
        	this.__moving__ == true;
        	
            var cr = this.currentSelectTDCellPosition;
            var row = cr.row;
            var column = cr.col;

            var tc = column;
            var tr = row;
            var tdCell = null;
            
            switch (direction) {
                case LEFT:
                    while (!this.isSelectable(tdCell) && tc >= 1) {
                        tc--;
                        tdCell = this._getTDCell4Move(tc, tr);
                    }
                    break;

                case RIGHT:
                    tc += this.currentTDCell.cell[0].colSpan - 1;
                    tdCell = this._moveRight(tdCell, tc, tr);                
                    break;
                case UP:
                    while (!this.isSelectable(tdCell) && tr >= 1) {
                        tr--;
                        tdCell = this._getTDCell4Move(tc, tr);
                    }
                    break;

                case DOWN:
                    tr += this.currentTDCell.cell[0].rowSpan - 1;
                    tdCell = this._moveDown(tdCell, tc, tr);
                    break;
            }

            this.selectTDCell(tdCell);
            
            this.__moving__ = false;
        },
        
        _getTDCell4Move : function(ccol, crow) {
        	var cellObj = this.getTDCell(ccol, crow);
        	if (!cellObj || (cellObj.col == this.currentTDCell.col && cellObj.row == this.currentTDCell.row)) {
        		return null;
        	} else {
        		this.currentSelectTDCellPosition.col = ccol;
        		this.currentSelectTDCellPosition.row = crow;
        	}
        	return cellObj;
        },
        
        _moveRight : function(tdCell, col, row){
        	while(!this.isSelectable(tdCell)){
        		// move right
        		if (col < this.table_width - 1){
        			col++;
//        			this.$container[0].scrollLeft += this.table_width;
        		// move down
        		} else if(row < this.table_height - 1){
        			col = 0;
        			row++;
//        			this.$container[0].scrollLeft = 0;
//        			this.$container[0].scrollTop += this.table_height;
        		// move to start
        		} else {
        			col = 0;
        			row = 0; 
//        			this.$container[0].scrollLeft = 0;
//        			this.$container[0].scrollTop = 0;       			
        		}  
        		tdCell = this._getTDCell4Move(col, row);
        	}
        	return tdCell;
        }, 
        
        _moveDown : function(tdCell, col, row) {
        	while(!this.isSelectable(tdCell)){
        		// move down
        		if (row < this.table_height - 1){
        			row ++;
//        			this.$container[0].scrollTop += this.table_height;
        		// move top
        		} else if(col < this.table_width - 1){
        			row = 0;
        			col ++;
//        			this.$container[0].scrollLeft += this.table_width;
//        			this.$container[0].scrollTop = 0;
        		// move to start
        		} else {
        			col = 0;
        			row = 0;      	
//        			this.$container[0].scrollLeft = 0;
//        			this.$container[0].scrollTop = 0;  
        		}  
        		tdCell = this._getTDCell4Move(col, row);
        	}
        	return tdCell;
        }
	};
}());

/*
 * FP:$.FR.EditPane
 */
function FormulaParser(FP) {
    var FR_rules = [
            ["NumberToExp", ["number"]],
            ["TextToExp", ["text"]],
            ["CallNoParm",["name","(",")"]],
            ["CallStart", ["name", "("]],
            ["CallParm", ["call", "exp", ","]],
            ["CallParm", ["call", "range", ","]],
            ["CallLast", ["call", "exp", ")"]],
            ["CallLast", ["call", "range", ")"]],
            ["NameRange", ["name", ":", "name"]],
            ["NameToExp", ["name"]],
            ["Op", ["exp", "op1", "exp"]],
            ["Unari", ["start", "op3", "exp"]],
            ["Unari", ["(", "op3", "exp"]],
            ["Unari", ["call", "op3", "exp"]],
            ["Unari", ["op1", "op3", "exp"]],
            ["Unari", ["op2", "op3", "exp"]],
            ["Unari", ["op3", "op3", "exp"]],
            ["Unari", ["logop", "op3", "exp"]],
            ["BrExpBr", ["(", "exp", ")"]],
            ["BrExpOpExpBr", ["(", "exp", "op1", "exp", ")"]],
            ["BrExpOpExpBr", ["(", "exp", "op2", "exp", ")"]],
            ["BrExpOpExpBr", ["(", "exp", "op3", "exp", ")"]],
            ["BrExpOpExpBr", ["(", "exp", "logop", "exp", ")"]],
            ["Op", ["exp", "op2", "exp"]],
            ["Op", ["exp", "op3", "exp"]],
            ["Op", ["exp", "logop", "exp"]],
            ["Op", ["exp", "logand", "exp"]],
            ["Op", ["exp", "logor", "exp"]],
            ["finish",["?"]]
            ]

    var OP_Unari = 1;
    var OP_DoLeft = 2;
    var OP_Op = 3;
    var OP_GetCell = 4;
    var OP_Call = 5;
    var OP_GETParameter = 6;

    var VAR_CHARS = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ_$![]"

    var evaluated = {}; // evalĵԪ->ֵ
    var evaluating = []; // evalĵԪ TODO alex:Ϊʲô[]{},{}ǿԿЩҵevaluating['B3']Ƿô
    var parsedExpression = {}; // ʷĵʱȽϳ

//    var procedure = {}; // name->value eg:sum(1,2)->{value:3,vt:'number'}
//    var pendingCells = []; // Ҫȥcell

//    var resolvePending = false;//resolvePendingʾһϴ޷ıʽ,ڱѭ
    
    var P = {
    	relatedColumnRow : function(formulaString, currentColumnRow) {
    		var ast = exp2ast(formulaString);
    		
    		if (ast.error == null) {
    			node_relatedColumnRow(ast, ast, currentColumnRow)
    		}
    	},
    	
    	/*
    	 * cellStrsΪnullʱ,и
    	 *  TODO
    	 */
    	recalculate:function(cellStrs) {
    		FP.$container.__loading__(true);
    		
	        if(cellStrs == null) {
	            return;
	        } else {
	        	/*
	        	 * TODO alex:,1,attr('fm')ķҲҪ1,ʱҪ1
	        	 * Ҫѹʽ͵ı,ټ
	        	 */
	        	//var array = [];
	        	related_array = [];
	        	$.each(cellStrs, function(idx, cellStr) {
	        		collectTDArray(cellStr, related_array);
	        	})
	        	$.each(related_array.concat(cellStrs), function(idx, cellStr) {
	        		calculateSingleCell(cellStr);
	        	})
	        }
	
			clearMemonic();
			FP.$container.__loading__(false);
    	}
    };
    
    /*
     * $contextTDɸѡʽfiltersеĵԪص$TD,ȡID,֮
     * 
     * filters ʽ,ΪArray.indexOf,object {ColumnRow : true}
     */
    function collectTDArray(base_cell_string, array) {
    	var related = FP.relationship_get(base_cell_string);
    	var news = [];
    	for (var i = 0; i < related.length; i++) {
    		var cell_string = related[i];
    		if (array.indexOf(cell_string) < 0) {
    			array.push(cell_string);
    			news[news.length] = cell_string;
    		}
    	}
    	
    	for (var i = 0; i < news.length; i++) {
    		collectTDArray(news[i], array);
    	}
    }

    function calculateSingleCell(crStr) {
        var cellInfo = FP.getTDCellByStringPosition(crStr);

        var result = evaluateCell(cellInfo != null ? cellInfo.cell[0] : null)
        dealWithResult(result, cellInfo);
    }

    function clearMemonic() {
        evaluated = {};
        evaluating = [];
        // denny: ֻrelated_arrayеĸӲҪ¼
        related_array = [];
    }

    /*
     * һӵֵ֮,ҪЩʲô?
     */ 
    function dealWithResult(result, cellInfo) {
        //resultnullʱ,ʾtdCell޹ʽ,ôҲֵ
        if (result != null) {
            if (result.value != null) {//alex:Ϊһ޷ĸ,ûvalue,Ҫһж
                result = result.value;
                FP.setCellShowValue(cellInfo, result);
				
                // carl:Ϊʲôô緵һַͲʾˣ
                if (result.toString().length > 0) {
                    FP.displayTDCell(cellInfo, result);
                }
            } else {
            	// carl: 費ҪƷǱߣŪ#value?ǣ
            }
        }
    }

    //Ҫط,һrecaculateʱ,ǰѵԪevalɶӦֵʱ
    //йʽ,㹫ʽresult,򷵻null
    //pendingʱ,{pending, cell, str}
    function evaluateCell(cell) {
        if (cell == null) {
            return null;
        }
        var crStr;
        if(typeof cell == 'string') {
            crStr = cell;
            cell = FP.getDocTDCellByStringPosition(cell);
        }
        var fm = $(cell).attr("fm");
        if (fm != null) {
            if(crStr == null) crStr = FR.id2ColumnRowStr(cell.id);
            //to see if it has been parsed
            var result = evaluated[crStr];
            if (result == null) {
                //to see if it's inParse Array
                if(evaluating.indexOf(crStr) >= 0) {
                    result = 0;
                }
                if(result == null) {
                    //ѵǰڽĵԪӵevaluatingĶ
                    evaluating[evaluating.length] = crStr;
                    result = evaluate(fm);
//                    if(result.pending != null) { //pending,¼crStr,P.recalculateʱҪõ
//                        result.cell = cell;
//                        result.str = crStr;
//                    }
                    evaluating.remove(crStr);
                }
                if (result != null) {
                    evaluated[crStr] = result;
                }
            }
            return result;
        } else {
            return null;
        }
    }
    
    /*
     * һexpressionast
     */
    function exp2ast(exp) {
    	var ast = parsedExpression[exp];

        if (ast == null) {
            try {
                var tokens = tokenize(exp);
                ast = parse(tokens)
            } catch (e) {
                ast = {error:[e.message]};
            }
            
        	parsedExpression[exp] = ast
        }

        
        return ast;
    }

    //alex:evaluate expression֮,{value:value, vt:type},б,{errors:[error]}
    function evaluate(exp) {
        var ast = exp2ast(exp);

        if (ast.error == null) {
            //ΪP.executeıast,Ҫcloneһexecute
            var code = clone(ast);
            var res = {};
            try {
                execute(code);
//                if(code.pending != null) return {pending:code.pending};
                res.value = code.value
                res.vt = code.vt
            } catch (e) {
                res = {error:[e.message]}
            }
            return res;
        } else {
        	return ast;
        }
    }

    function clone(o) {
        var res;
        if (FR.isArray(o)) {
            res = [];
            for(var a = 0, len = o.length; a < len; a++) {
                res[a] = clone(o[a]);
            }
        }
        if(typeof o == 'object') {
            if(res == null)res = {};
            for(var a in o) {
                res[a] = clone(o[a]);
            }
        }
        if(res == null) res = o;
        
        return res;
    }

    function tokenize(exp) {
        var tokens = []
        var currToken
        for (var i = 0; i < exp.length; i++) {
            var c = exp.charAt(i)
            if (currToken && currToken.type == 'text' && c != '"' && c != '\\') {
                currToken.text += c
            } else if (" \t".indexOf(c) >= 0) {
                if (currToken) {
                    tokens[tokens.length] = currToken
                    currToken = null
                }
            } else if (c == '\\' ) {
            	// richer:bug6371
            	i++;
            	currToken.text += exp.charAt(i);
            } else if (c == ',') {
                if (currToken)
                    tokens[tokens.length] = currToken
                currToken = {type:',', start:i, text:c}
                tokens[tokens.length] = currToken
                currToken = null
            } else if ("*/%^():".indexOf(c) >= 0) {
                if (currToken)
                    tokens[tokens.length] = currToken
                currToken = {}
                if ("*/%".indexOf(c) >= 0)
                    currToken.type = 'op2'
                else if (":()".indexOf(c) >= 0)
                    currToken.type = c
                else if ("^".indexOf(c) >= 0)
                    currToken.type = 'op1'
                currToken.start = i
                currToken.text = c
                tokens[tokens.length] = currToken
                currToken = null
            } else if (c == '"') {
                var openString = false //ʶǷstringĿʼ
                if (currToken) { 
                	if (currToken.type == 'text') {
                        //TODO alex:ҸĵдͲתַ,ʱô,ֱΪtextĽʶ
                        tokens[tokens.length] = currToken
                        currToken = null
                        /**
                        alex:irowsԭд,ǿtextĻ,"ͱʾһtextһ",൱תַ,textĽ
                        var isEnd = true
                        if (i < exp.length - 1) {
                            var c2 = exp.charAt(i + 1)
                            if (c2 == '"') {
                                currToken.text += '"'
                                i++
                                isEnd = false
                            }
                        }
                        if (isEnd) {
                            tokens[tokens.length] = currToken
                            currToken = null
                        }
                        **/
                    } else {
                        tokens[tokens.length] = currToken
                        openString = true
                    }
                }
                else
                    openString = true
                if (openString) {
                    currToken = {type:'text', text:'', start:i}
                }
            } else if ("&|<>=!".indexOf(c) >= 0) {
                if (currToken)
                    tokens[tokens.length] = currToken;
                if ("&|".indexOf(c) >= 0) {
                	if (c == '&') {
                		currToken = {type:'logand', text:c};
                	} else {
                		currToken = {type:'logor', text:c};
                	}
                	if (i < exp.length - 1) {
                		var c2 = exp.charAt(i + 1);
                		if (c != c2) {
                			throw {message: "unsupported character found : " + c + c2, tokens:tokens};
                		} else {
                			i++;
                			currToken.text+=c2;
                		}
                	} else {
                		throw {message : "wrong end " + c, tokens:tokens};
                	}
                } else if (i < exp.length - 1) {
                	currToken = {type:'logop', text:c};
                    var c2 = exp.charAt(i + 1)
                    if ((c == '>' && c2 == '=') || (c == '<' && c2 == '=') || (c == '<' && c2 == '>')
                    // alex:=,ҲҪʾ,!=ʾ
                    || (c == '=' && c2 == '=') || (c == '!' && c2 == '=')) {
                        i++
                        currToken.text += c2
                    }
                }
                tokens[tokens.length] = currToken
                currToken = null
            } else if (currToken && currToken.type == 'number') {
                //alex:numberʱirows֧e x b
                if ("0123456789".indexOf(c) >= 0)
                    currToken.text += c
                else if (c == '.') {
                    if (currToken.text.indexOf('.') >= 0) {
                        throw {message : "double dot found in number", tokens:tokens}
                    }
                    currToken.text += c
                }
                else if ("+-".indexOf(c) >= 0) {
                    //TODO alex:+-ɲõifȥ?ͬnameʱ+-
                    tokens[tokens.length] = currToken
                    currToken = {type:'op3', start:i, text:c}
                    tokens[tokens.length] = currToken
                    currToken = null
                } else {
                    throw {message : "unsupported character found in number: " + c, tokens:tokens}
                }
            } else if (currToken && currToken.type == 'name') {
                if ("0123456789.".indexOf(c) >= 0 || VAR_CHARS.indexOf(c) >= 0)
                    currToken.text += c
                else if ("+-".indexOf(c) >= 0) {
                    tokens[tokens.length] = currToken
                    currToken = {type:'op3', start:i, text:c}
                    tokens[tokens.length] = currToken
                    currToken = null
                } else {
                    throw {message : "unsupported character found in name: " + c, tokens:tokens}
                }
            } else if ("+-".indexOf(c) >= 0) {
                if (currToken)
                    tokens[tokens.length] = currToken
                currToken = {type:'op3', start:i, text:c}
                tokens[tokens.length] = currToken
                currToken = null
            } else if (!currToken) {
                currToken = {text:c, start:i};
                if ("0123456789.".indexOf(c) >= 0)
                    currToken.type = 'number'
                else if (VAR_CHARS.indexOf(c) >= 0)
                    currToken.type = 'name'
                else {
                     throw {message : "unsupported character found: " + c, tokens:tokens}
                }
            }
        }
        if (currToken) {
            tokens[tokens.length] = currToken
            if (currToken.type == "text") //alex:˵ûŽ,Ҫ
                throw {message : "text without right quote", tokens:tokens}
        }
        return tokens;
    }

    function parse(tokens) {
        var startToken = {type:'start'}
        var t = []
        t[0] = startToken
        tokenAppend(tokens, t, 0, tokens.length - 1)
        tokens = t
        var hasMatchingRule = true
        var rule_count = FR_rules.length;
        while (hasMatchingRule) {
            var foundMatchingRule = false
            for (var r = 0; r < rule_count; r++) {
                var rule = FR_rules[r]
                var handler = rule[0]
                var types = rule[1]
                var matchedPos = -1

                //alex:һ,Ǿȥ,foundMatchingRulefalse,Ϳѭѭ
                if(handler == "finish") {
                    break;
                }

                for (var i = 0; matchedPos < 0 && i <= tokens.length - types.length; i++) {
                    var matched = true
                    for (var j = 0; matched && j < types.length; j++)
                        matched = (types[j] == tokens[i + j].type)
                    if (matched) {
                        matchedPos = i
                        tokens = eval("rule" + handler + "(tokens, i)")
                    }
                }
                if (matchedPos >= 0) {
                    foundMatchingRule = true
                    break
                }
            }
            hasMatchingRule = foundMatchingRule
        }
        if (tokens.length != 2 || tokens[1].type != 'exp')
            throw {message:'token parsed error', tokens:tokens}

        return tokens[1]
    }
    function tokenAppend(source, target, sourceFromIndex, sourceToIndex) {
        for (var i = sourceFromIndex; i <= sourceToIndex; i++)
            target[target.length] = source[i]
    }


    var ruleNumberToExp = function(tokens, pos) {// ["number"]
        var F = tokens[pos]
        var B = {type:'exp', vt:'number'}
        if (F.text.indexOf('.') >= 0)
            B.value = parseFloat(F.text)
        else
            B.value = parseInt(F.text, 10)
        B.left = F
        tokens[pos] = B
        return tokens
    }
    var ruleTextToExp = function(tokens, pos) {// ["text"]
        var F = tokens[pos]
        var B = {type:'exp', vt:'text', value:F.text}
        B.left = F
        tokens[pos] = B
        return tokens
    }
    var ruleCallNoParm = function(tokens, pos) {// ["name","(",")"]
        var res = []
        tokenAppend(tokens, res, 0, pos - 1)
        var nameToken = tokens[pos]
        res[res.length] = {
            type:'exp',
            op:OP_DoLeft,
            left:{
                type:'call',
                callName:nameToken.text.toLowerCase(),
                start:nameToken.start,
                left:nameToken,
                parms:[],
                op:OP_Call
            }
        }
        tokenAppend(tokens, res, pos + 3, tokens.length - 1)
        return res
    }
    var ruleCallStart = function(tokens, pos) {// ["name", "("]
        var res = []
        tokenAppend(tokens, res, 0, pos - 1)
        var nameToken = tokens[pos]
        res[res.length] = {
            type:'call',
            callName:nameToken.text.toLowerCase(),
            start:nameToken.start,
            left:nameToken,
            parms:[],
            op:OP_Call
        }
        tokenAppend(tokens, res, pos + 2, tokens.length - 1)
        return res
    }
    var ruleCallParm = function(tokens, pos) {// ["call", "exp", ","],["call", "range", ","]
        var res = []
        tokenAppend(tokens, res, 0, pos)
        var callBlock = tokens[pos]
        callBlock.parms[callBlock.parms.length] = tokens[pos + 1]
        tokenAppend(tokens, res, pos + 3, tokens.length - 1)
        return res
    }
    var ruleCallLast = function(tokens, pos) {// ["call", "exp", ")"],["call", "range", ")"]
        var res = []
        tokenAppend(tokens, res, 0, pos - 1)
        var callBlock = tokens[pos]
        callBlock.parms[callBlock.parms.length] = tokens[pos + 1]
        res[res.length] = {
            type:'exp',
            op:OP_DoLeft,
            left:callBlock
        }
        tokenAppend(tokens, res, pos + 3, tokens.length - 1)
        return res
    }
    var ruleNameRange = function(tokens, pos) {// ["name", ":", "name"]
        var startToken = tokens[pos]
        var endToken = tokens[pos + 2]
        
        var nameStart = startToken.text
        var nameEnd = endToken.text
        var startCell = FR.cellStr2ColumnRow(nameStart)
        if (startCell == null)
            throw {message:'startCell:' + nameStart + " not match Cell Lexer", tokens:tokens}
        var endCell = FR.cellStr2ColumnRow(nameEnd)
        if (endCell == null)
            throw {message:'endCell:' + nameEnd + " not match Cell Lexer", tokens:tokens}

        var block = {
            type:'range',
            startRow : Math.min(startCell.row, endCell.row),
            endRow : Math.max(startCell.row, endCell.row),
            startCol : Math.min(startCell.col, endCell.col),
            endCol : Math.max(startCell.col, endCell.col),
            left:startToken,
            right:endToken
        }

        startToken.cellReference = {
            startRow:block.startRow,
            startCol:block.startCol,
            endRow:block.endRow,
            endCol:block.endCol
        }

        var res = []
        tokenAppend(tokens, res, 0, pos - 1)
        res[res.length] = block
        tokenAppend(tokens, res, pos + 3, tokens.length - 1)
        return res
    }
    var ruleNameToExp = function(tokens, pos) {// ["name"]
        var F = tokens[pos]
        var B = {type:'exp'}
        var name = F.text.toLowerCase()
        var value = ""
        var vt = 'nothing'
        if (name == 'pi') {
            value = Math.PI
            vt = 'number'
        }
        else if (name == 'e') {
            value = Math.E
            vt = 'number'
        }
        else if (name == 'true') {
            value = 1
            vt = 'boolean'
        }
        else if (name == 'false') {
            value = 0
            vt = 'boolean'
        }
        else if (name == 'null') {
        	value = null;
        	vt = 'null';
        }
        if (vt != 'nothing') {
            B.value = value; B.vt = vt;
        } else {
            var cellRef = FR.cellStr2ColumnRow(name)
            if (cellRef) {
                F.op = OP_GetCell; F.cellReference = cellRef;
                B.op = OP_DoLeft;
            } else if (name.substring(0,1) == "$") {
            		F.op = OP_GETParameter;
            		F.paramName = name.substring(1);
            		B.op = OP_DoLeft;
            } else {
                throw {message:'unresolved name: ' + name, tokens:tokens}
            }
        }
        B.left = F;
        tokens[pos] = B
        return tokens
    }
    var ruleOp = function(tokens, pos) {
        // ["exp", "op1", "exp"],["exp", "op2", "exp"],["exp", "op3", "exp"],["exp", "logop", "exp"]
        var res = []
        tokenAppend(tokens, res, 0, pos - 1)
        var t1 = tokens[pos]
        var t2 = tokens[pos + 2]
        var tOp = tokens[pos + 1]
        tOp.op = OP_Op; tOp.left = t1; tOp.right = t2;
        res[res.length] = {
            type:'exp',
            op:OP_DoLeft,
            left:tOp
        }
        tokenAppend(tokens, res, pos + 3, tokens.length - 1)
        return res
    }
    var ruleUnari = function(tokens, pos) {
        // ["start", "op3", "exp"],["(", "op3", "exp"],["call", "op3", "exp"],["op1", "op3", "exp"],["op2", "op3", "exp"],["op3", "op3", "exp"],["logop", "op3", "exp"]
        var res = []
        tokenAppend(tokens, res, 0, pos)
        res[res.length] = {
            type:'exp',
            op:OP_Unari,
            left:tokens[pos + 1],
            right:tokens[pos + 2]
        }
        tokenAppend(tokens, res, pos + 3, tokens.length - 1)
        return res
    }
    var ruleBrExpBr = function(tokens, pos) {// ["(", "exp", ")"]
        var res = []
        tokenAppend(tokens, res, 0, pos - 1)
        res[res.length] = tokens[pos + 1]
        tokenAppend(tokens, res, pos + 3, tokens.length - 1)
        return res
    }
    var ruleBrExpOpExpBr = function(tokens, pos) {
        // ["(", "exp", "op1", "exp", ")"],["(", "exp", "op2", "exp", ")"],["(", "exp", "op3", "exp", ")"],["(", "exp", "logop", "exp", ")"]
        var res = []
        tokenAppend(tokens, res, 0, pos - 1)
        tokenAppend(tokens, res, pos + 1, pos + 3)
        tokenAppend(tokens, res, pos + 5, tokens.length - 1)
        return ruleOp(res, pos)
    }
    
    /*
     * ȡnodeмصTD,ŵarrayȥ
     */
    function node_relatedColumnRow(root, node, currentColumnRow) {
        if (node.op == null || node.op == 0) {
        	return;
        }
        var op = node.op
        if (op == OP_Unari) { // +-һԪ
            var oper = node.left
            var nval = node.right
            node_relatedColumnRow(root, nval, currentColumnRow)
        }
        else if (op == OP_DoLeft) {
            var n = node.left
            node_relatedColumnRow(root, n, currentColumnRow)
        }
        else if (op == OP_Op) { //ϵ^*/%+-
            var n1 = node.left
            var n2 = node.right
            node_relatedColumnRow(root, n1, currentColumnRow)
            node_relatedColumnRow(root, n2, currentColumnRow)
        }
        else if (op == OP_GetCell) {
        	FP.relationship_add(node.text.toUpperCase(), currentColumnRow);
        	FP.relationship2_add(currentColumnRow, node.text.toUpperCase());
        }
        else if (op == OP_Call) {
	        var parameters = node.parms
	        for (var i = 0; i < parameters.length; i++) {
	            var p = parameters[i]
	            if (p.type == "range") {
	            	$.each(FP.getRangeTDCells(p.startCol, p.startRow, p.endCol, p.endRow), function(_i, _td) {
	            		_td = _td.cell[0];
        				FP.relationship_add(FP.cut2columnrowString(_td.getAttribute('id')).toUpperCase(), currentColumnRow);
        				FP.relationship2_add(currentColumnRow, FP.cut2columnrowString(_td.getAttribute('id')).toUpperCase());
	            	})
	            } else {
	            	node_relatedColumnRow(root, p, currentColumnRow);
	            }
	        }
        }
    }

    function execute(root) {
        evalNode(root, root)
//        if(root.pending != null) return;
        if (root.vt == "number") {
            root.value = dealWithNumber(root.value)
        }
        else if (root.vt == "boolean")
            root.value = root.value ? "true" : "false" //TODO alex:ﲻȷtrue or "true" or 1
        else if (root.vt == "null")
            root.value = ""
    }

    function evalNode(root, node) {
        if (node.op == null || node.op == 0) {
            return
        }
        var op = node.op
        if (op == OP_Unari) { // +-һԪ
            var oper = node.left
            var nval = node.right
            evalNode(root, nval)
//            if(nval.pending != null) {
//                node.pending = nval.pending;
//                return;
//            }

            var v = 0, vt = 'number'
            if (nval.vt == "number")
                v = nval.value
            else if (nval.vt == "null")
                v = 0
            else if (nval.vt == "text" || nval.vt == "boolean")
                throw {message:"unsupported unary operation: " + oper + " with type: " + nval.vt}
            if (oper.text == "-")
                v = -v
            node.value = v
            node.vt = vt
        }
        else if (op == OP_DoLeft) {
            var n = node.left
            evalNode(root, n)
//            if(n.pending != null) {
//                node.pending = n.pending;
//                return;
//            }

            node.value = n.value
            node.vt = n.vt
        }
        else if (op == OP_Op) { //ϵ^*/%+-
            var n1 = node.left
            var n2 = node.right
            evalNode(root, n1)
//            if(n1.pending != null) {
//                node.pending = n1.pending;
//                return;
//            }
            evalNode(root, n2)
//            if(n2.pending != null) {
//                node.pending = n2.pending;
//                return;
//            }
            
            if (node.type == "logop" || node.type == "logor" || node.type == 'logand')
                relationOp(node, n1, n2)
            else
                mathOp(node, n1, n2)
        }
        else if (op == OP_GetCell) {
            var cell = node.cellReference
            evalCellReference(FP.getTDCellByExactPosition(cell.col, cell.row), node)
//            if(node.pending != null) {
//                return;
//            }
        }
        else if (op == OP_Call) {
            processCall(root, node)
//            if(node.pending != null) return;
        }
        // TODO carl:ﲻҪÿζȥȡ
        else if (op == OP_GETParameter) {
        	remoteCalculate('parameter', node.paramName, node);
        }
        if (node.vt == "null")
            node.value = ""
    }
    
    function remoteCalculate(paramType, content, node) {
    	var pane = FP.editPane;
    	$.ajax({
        	url : pane.servletURL,
        	type : 'POST',
        	async : false,
        	data : {op: pane.rtype + '_calculate', sessionID:pane.currentSessionID, ptype:paramType, pcontent:content, idx:pane.curLGP.idx},
        	timeout : 5000,
        	complete : function(res, status) {
		        var resultArray = FR.jsonDecode(res.responseText);
		        var result = resultArray[0];
		        //alert(result);
		        if(typeof result == 'number') {
		        	result = {value:result, vt:'number'};
		        } else if (typeof result == 'string') {
		        	result = {value:result, vt:'text'};
		        } else if (typeof result == 'boolean') {
		        	result = {value:result, vt:'boolean'}
		        } else if (typeof result == 'object' && result['date']) {
		        	result = {value:new Date(result['date']), vt:'date'}
		        } else if (typeof result == 'object' && result.date_milliseconds) {
		        	result = {value:new Date(result.date_milliseconds), vt:'date'}
		        } else {
		        	result = {value:null, vt:'null'}
		        }
		        node.value = result.value;
		        node.vt = result.vt;
        	}
        });
    }

    /*
     * ÷ط,һOP_GetCellʱ,ǽrangeʱ,Ҳ˵,ֻڽǰԪʽеĵԪʱõ
     * ڴ,ͳƵԪ֮ϵ
     */
    function evalCellReference(cellInfo, node) {
        if (cellInfo == null) {
            return node;
        }

        //alex:һݹ,ﷵصֵҪvt & value,дĻҪerrors
        var result;
        if (related_array.indexOf(node.text) >= 0) {
        	result = evaluateCell(cellInfo.cell[0]);
        }
//        if(result != null && result.pending != null) {
//            node.pending = result.pending;
//            return result;
//        }

        //evaluateCellбĻ,᷵{errors:[error]};evaluateCellnull˵tdCell޹ʽ(evaluate)
        if(result == null || (result.errors != null && result.errors.length > 0)) {
            result = FP.getCellValue(cellInfo);
            
            var type;
            if (result == null) {
            	type = "null";
            } else {
            	if (typeof result == 'number') {
					type = 'number';
            	} else if (typeof result == 'boolean') {
					type = 'boolean';
            	} else if (typeof result == 'object') {
					if (result.date_milliseconds) {
						result = new Date(result.date_milliseconds);
						type = 'date';
					}
            	} else {
            		// TODO alex:͵ʱstring
					type = 'text';result = "" + result;
				}
            }
			result = {value:result, vt:type};
        }

        if(node != null && result != null) {
            node.value = result.value;
            node.vt = result.vt;
        }
        return result;
    }

    function processCall(root, token) {
        var func = token.callName
        var parameters = token.parms

        if (func == "if") {
            ifFunc(root, token)
            return
        }
        var parms = [];//parametersеrangeµargumentĸ
        for (var i = 0; i < parameters.length; i++) {
            var p = parameters[i]
            if (p.type == "range") {
                var tdCells = FP.getRangeTDCells(p.startCol, p.startRow, p.endCol, p.endRow)
                for (var ic = 0, len = tdCells.length; ic < len; ic++) {
                    var cv = evalCellReference(tdCells[ic]);
//                    if(cv.pending != null) {
//                        token.pending = cv.pending;
//                        return;
//                    }
                    parms[parms.length] = {value:cv.value,vt:cv.vt}
                }
            } else
                parms[parms.length] = p
        }
        token.vt = "null"
        //arguments evalһ
        for (var i = 0; i < parms.length; i++) {
            var p = parms[i]
            evalNode(root, p)
//            if(p.pending != null) {
//                token.pending = p.pending;
//                return;
//            }
        }

        if (func == 'ln')
            func = 'log'
        if (func == 'sqrt' || func == 'abs' || func == 'ceil' || func == 'floor' || func == 'int' || func == 'log') {
            if (funcCheck(token, parms, 1, 1, 'N')) {
                if (func == 'int')
                    func = 'floor'
                token.value = eval('Math.' + func + '(' + parms[0].value + ')')
                token.vt = 'number'
            }
        } else if (func == 'sin' || func == 'cos' || func == 'tan') {
            if (funcCheck(token, parms, 1, 1, 'N')) {
                var v = parms[0].value
                v = eval('Math.' + func + '(' + v + ')')
                token.value = v
                token.vt = 'number'
            }
        } else if (func == 'asin' || func == 'acos' || func == 'atan') {
            if (funcCheck(token, parms, 1, 1, 'N')) {
                var v = parms[0].value
                v = eval('Math.' + func + '(' + v + ')')
                token.value = v
                token.vt = 'number'
            }
        } else if (func == 'log10') {
            if (funcCheck(token, parms, 1, 1, 'N')) {
                token.value = eval('Math.log(' + parms[0].value + ')/Math.log(10)')
                token.vt = 'number'
            }
        } else if (func == 'max' || func == 'min' || func == 'average' || func == 'count' || func == 'counta' || func == 'sum' || func == 'product') {
            var min
            var max
            var count = 0
            var sum = 0
            var product = 1
            if (funcCheck(token, parms, 1, -1, '*')) {
                for (var i = 0; i < parms.length; i++) {
                    var p = parms[i]
                    if (p.vt == 'number' || p.vt == 'text') {
                        var v = p.value
                        if (p.vt == 'text') {
                            try {
                                v = parseInt(v, 10);
                            } catch (e) {
                                try {
                                    v = parseFloat(v);
                                } catch(e) {
                                    v = 0;
                                }
                            }
                            // alex:ַᱻNaN,Ӧ0Ŷ
                            if (isNaN(v)) {
                            	v = 0;
                            }
                        }
                        if (!min || min > v)
                            min = v
                        if (!max || max < v)
                            max = v
                        count++
                        sum += v
                        product *= v
                    } else if (p.vt != "null" && func == 'counta' && p.value != "")
                        count++
                }
                if (count == 0)
                    token.value = 0
                else {
                    if (func == 'max')token.value = max
                    else if (func == 'min')token.value = min
                    else if (func == 'count' || func == 'counta')token.value = count
                    else if (func == 'sum')token.value = sum
                    else if (func == 'average')token.value = sum / count
                    else if (func == 'product')token.value = product
                }
                token.vt = 'number'
            }
        } else if (func == 'and' || func == 'or') {
            var count = 0
            var andResult = true
            var orResult = false
            if (funcCheck(token, parms, 1, -1, '*')) {
                for (var i = 0; i < parms.length; i++) {
                    var p = parms[i]
                    if (p.vt == 'number' || p.vt == 'boolean') {
                        count++
                        var b = p.value > 0
                        andResult = andResult && b
                        orResult = orResult || b
                        if ((func == 'and' && !andResult) || (func == "or" && orResult))
                            break
                    }
                }
                if (func == 'and')token.value = andResult ? 1 : 0
                else if (func == 'or')token.value = orResult ? 1 : 0
                token.vt = 'boolean'
            }
        } else if (func == "pi") {
            if (funcCheck(token, parms, 0, 0, 'N')) {
                token.value = Math.PI
                token.vt = 'number'
            }
        } else if (func == "power") {
            if (funcCheck(token, parms, 2, 2, 'N')) {
                token.value = Math.pow(parms[0].value, parms[1].value)
                token.vt = 'number'
            }
        } else if (func == "len" || func == "lower" || func == "upper" || func == "trim") {
            if (funcCheck(token, parms, 1, 1, 'T')) {
                if (func == "len") {
                    token.value = parms[0].value.length
                    token.vt = "number"
                }
                else if (func == "lower") {
                    token.value = parms[0].value.toLowerCase()
                    token.vt = "text"
                }
                else if (func == "upper") {
                    token.value = parms[0].value.toUpperCase()
                    token.vt = "text"
                }
                else if (func == "trim") {
                    token.value = $.trim(parms[0].value);
                    token.vt = "text"
                }
            }
        } else {
            //TODO alex:ĺת,ʱһ,,֪jsû߳sleepķ
            //            token.value = 0; token.vt = "number";
            var remoteExpression = func + '(';
            $.each(parms, function(index, item) {
                if (index > 0) remoteExpression += ',';
                if (item.vt == "number") {
                    remoteExpression += item.value;
                } else if (item.vt == "boolean") {
                    remoteExpression += item.value ? "true" : "false";
                } else if (item.vt == "null") {
                    remoteExpression += 'null';
                } else if (item.vt == 'date') {
                	remoteExpression += item.value.getTime();
                } else {
                    remoteExpression += ('"' + item.value + '"');
                }
            });
            remoteExpression += ')';
            remoteCalculate('expression', remoteExpression, token);
        }
        if (token.vt == 'number') {
            if (isNaN(token.value)) {
                token.value = "NaN";
                token.vt = "text";
            } else if (token.value == "Infinity") {
                token.value = "Infinity";
                token.vt = "text";
            }
        }
    }


    function ifFunc(root, token) {
        var parms = token.parms
        var ok = true
        if (parms.length < 2 || parms.length > 3) {
            throw {message:"2 or 3 arguments allowed in Function[if]"}
        }
        if (parms[0].type == "range" || parms[1].type == "range" || (parms.length == 3 && parms[2].type == "range")) {
            throw {message:"range is not allowed in Function[if]"}
        }
        var vc = false

        var cond = parms[0]
        evalNode(root, cond)
//        if(cond.pending != null) {
//            token.pending = cond.pending;
//            return;
//        }

        if (cond.vt == "null")
            vc = false
        else if (cond.vt == "number" || cond.vt == "boolean")
            vc = cond.value != 0
        else if (cond.vt == "text") {
            throw {message:"condition should not be text in Function[if]"}
        }

        if (vc) {
            var res = parms[1]
            evalNode(root, res)
//            if(res.pending != null) {
//                token.pending = res.pending;
//                return;
//            }
            token.value = res.value
            token.vt = res.vt
        }
        else {
            if (parms.length == 3) {
                var res = parms[2]
                evalNode(root, res)
//                if(res.pending != null) {
//                    token.pending = res.pending;
//                    return;
//                }
                token.value = res.value
                token.vt = res.vt
            }
            else {
                token.value = 0
                token.vt = "boolean"
            }
        }
    }

    function dealWithNumber(value) {
        var sv = "" + value
        if (sv.indexOf('.') < 0)
            return value
        var s = sv.substring(sv.indexOf('.'))
        var l = s.length
        if (l < 10)
            return value
        var l5 = s.substring(l - 5)
        var l5m1 = l5.substring(0, 4)
        if (l5m1 == '9999') {
            var i9 = s.length - 3
            while (s.charAt(i9 - 1) == '9')
                i9--
            s = s.substring(0, i9 + 1)
            var d = '.000000000000000000000000000000000'.substring(0, s.length - 1) + '1'
            var w = sv.substring(0, sv.indexOf('.'))
            if (w == '')
                w = '0'
            var op = '+'
            if (value < 0)
                op = '-'
            value = eval(w + op + '(' + s + '+' + d + ')')
        }
        else
            if (l5m1 == '0000') {
                value = eval(sv.substring(0, sv.length - 4))
            }
        return value
    }

    function mathOp(tOp, t1, t2) {
        var v1 = t1.value
        var v2 = t2.value
        var op = tOp.text
        // alex:+ŵַ⴦
        if (op == '+' && (t1.vt == 'text' || t2.vt == 'text')) {
        	tOp.value = v1.toString() + v2.toString();
        	tOp.vt = 'text';
        	return;
        }
        if (t1.vt == 'null')
            v1 = 0
        if (t2.vt == 'null')
            v2 = 0
        if (t1.vt == 'text' || v1 == '') {
            v1 = new Number(v1);
            v1 = isNaN(v1) ? 0 : v1;
        }
        if (t2.vt == 'text' || v2 == '') {
            v2 = new Number(v2);
        	v2 = isNaN(v2) ? 0 : v2;
        }
        var result = v1
        // carl:ֱĬ
        if (op == '-' && t1.vt == 'date' && t2.vt == 'date') {
        	result = (result - v2)/3600/24/1000;
        }
        else if (op == '+' || op =='-' || op == '*' || op == '/' || op == '%') {
        	// alex:ΪʲôҪv2һ()?Ϊ1 - -10,,1--10ûȷ
        	result = eval(result + op + "(" + v2 + ")");
        }
        // alex:accAddȷ,Ϊٶ̫,50ٶȲ
//        if (op == '+')
//            result = FR.accAdd(result,v2);
//        else if (op == '-')
//            result = FR.accMin(result,v2);
//        else if (op == '*')
//            result = FR.accMul(result,v2);
//        else if (op == '/') {
//            result = FR.accDiv(result,v2);
//        }
//        else if (op == '%') {
//            result = eval(result + '%' + v2)
//        }
        else if (op == '^')
            result = Math.pow(result, v2)

        if (isNaN(result)) {
            tOp.value = "NaN";
            tOp.vt = "text";
        } else if (result == "Infinity") {
            // Infinity
            tOp.value = "";
            tOp.vt = "text";
        } else if (result == "-Infinity") {
        	tOp.value = "-";
            tOp.vt = "text";
        } else {
            tOp.value = result;
            tOp.vt = 'number'
        }
    }

    function relationOp(tOp, t1, t2) {
        var v1 = t1.value
        var v2 = t2.value
        var op = tOp.text
        if (t1.vt != t2.vt) {
            if (t1.vt == 'text' || t2.vt == 'text') {
                if (t1.vt == 'null')v1 = ''
                if (t2.vt == 'null')v2 = ''
                if (t1.vt == 'number')v1 = '' + v1
                if (t2.vt == 'number')v2 = '' + v2
                if (t1.vt == 'boolean')v1 = v1 ? 'true' : 'false'
                if (t2.vt == 'boolean')v2 = v2 ? 'true' : 'false'
            }
            else if (t1.vt == 'number' || t2.vt == 'number' || t1.vt == 'boolean' || t2.vt == 'boolean') {
                if (t1.vt == 'null')v1 = 0
                if (t2.vt == 'null')v2 = 0
            }
        }
        var result = false
        if (op == '==' || op == '=') {
            result = (v1 == v2)
        } else if (op == '<') {
            result = (v1 < v2)
        } else if (op == '>') {
            result = (v1 > v2)
        } else if (op == '>=') {
            result = (v1 >= v2)
        } else if (op == '<=') {
            result = (v1 <= v2)
        } else if (op == '<>' || op == '!=') {
            result = (v1 != v2)
        // carl:ֱӱ
        } else if (op == '||') {
        	if (t1.vt == 'boolean' && t2.vt == 'boolean') {
        		result = (v1 || v2);
        	} else {
        		throw {message: "formula grammar error" + v1 + op + v2};
        	}
        } else if (op == '&&') {
        	if (t1.vt == 'boolean' && t2.vt == 'boolean') {
        		result = (v1 && v2);
        	} else {
        		throw {message: "formula grammar error" + v1 + op + v2};
        	}
        }
        tOp.value = result ? 1 : 0
        tOp.vt = 'boolean'
    }


    /*
    * function name;
    * parameters;
    * minlen of parameters;
    * maxlen of parameters
    * type of parameters(N:Number, T:Text, B:boolean, R:range)
    */
    function funcCheck(func, parms, minlen, maxlen, type) {
        if (parms.length < minlen) {
            throw {message:"argument count in Function[" + func + "] should ge " + minlen}
        }
        if (maxlen > -1 && parms.length > maxlen) {
            throw {message:"argument count in Function[" + func + "] should be " + maxlen}
        }
        for (var i = 0; i < parms.length; i++) {
            var et = type.charAt(Math.min(type.length - 1, i))
            var parm = parms[i]
            if (et == 'N') {
                if (parm.vt == 'null') {
                    parm.value = 0
                    parm.vt = 'number'
                } else if (parm.vt == 'boolean') {
                    parm.value = parm.value ? 1 : 0
                    parm.vt = 'number'
                } else if (parm.vt != 'number') {
                    parm.value = 0
                    parm.vt = 'number'
                }
            } else if (et == 'T') {
                if (parm.vt == 'null') {
                    parm.value = ''
                    parm.vt = 'text'
                } else if (parm.vt == 'number') {
                    parm.value = '' + parm.value
                    parm.vt = 'text'
                } else if (parm.vt == 'boolean') {
                    parm.value = parm.value ? 'true' : 'false'
                    parm.vt = 'text'
                }
            } else if (et == 'B') {
                if (parm.vt == 'null') {
                    parm.value = 0
                    parm.vt = 'boolean'
                } else if (parm.vt == 'number') {
                    parm.value = parm.value == 0 ? 0 : 1
                    parm.vt = 'boolean'
                } else if (parm.vt == 'text') {
                    parm.vt = 'boolean'
                    parm.value = 0
                }
            } else if (et == 'R') {
                if (parm.type != "range") {
                    throw {message:i + "th argument should be range"}
                }
            }
        }
        return true
    }

    return P;
};
