
FR.LayoutContainer = FR.extend(FR.Container, {
	_init : function() {
		FR.LayoutContainer.superclass._init.apply(this, arguments);
	},
	doLayout : function() {
		var renderTo = this.options.renderTo;
		this.element.doLayout();
		var i, widgets = this.options.widgets, len = widgets.length;
		for (i = 0; i < len; i ++) {
			var widget = widgets[i];
			if (widget.doLayout) {
				widget.doLayout();
			}
		}
	}
});

/*
 * CardLayout 
 */
 $.shortcut('card', 'FR.CardLayout');
 FR.CardLayout = FR.extend(FR.LayoutContainer, {
 	_init : function() {
 		FR.CardLayout.superclass._init.apply(this, arguments);
 		//b:
 		this.element.css({width: '100%', height: '100%'});
 		if (!$.isArray(this.options.items)) {
			this.options.items = [];
			return;
		}
		this.contents = [];
		for (var i = 0, len = this.options.items.length; i < len; i++) {
			var config = {};
			$.extend(config, this.options);
			
			config.items = this.options.items[i].items;
			config.renderTo = this.element;
			var type = this.options.items[i].type;
			var elem;
			if (type == 'borderlayout') {
				elem = new FR.BorderLayout(config);
			} else if (type == 'gridlayout') {
				elem = new FR.GridLayout(config);
			} else if (type == 'flowlayout') {
				elem = new FR.FlowLayout(config);
			}
			if (this.options.items[i].showing != true) {
				elem.setVisible(false);
			}
			
			this.contents[i] = elem;
		}
 	},
 	
 	
 	showPane : function(index) {
 		for (var i = 0, len = this.contents.length; i < len; i++) {
 			if (this.contents[i].isVisible()) {
 				if  (i != index) {
 					this.contents[i].setVisible(false);
 					this.contents[index].setVisible(true); 					
 				} else {
					break;
 				}
 			}
 		} 		
 	},
 	
 	doResize : function(give) {
 		for (var i = 0, len = this.contents.length; i < len; i++) {
 			if (this.contents[i].isVisible()) {
 				this.contents[i].doResize(give);
 			}
 		}
	},
	
	doLayout : function() {
		for (var i = 0, len = this.contents.length; i < len; i++) {
 			if (this.contents[i].isVisible()) {
 				this.contents[i].doLayout();
 			}
 		}
	}
 });
 
/**
 * BorderLayout .start
 * , Ӧڷ˵com.fr.report.web.ui.container.BorderLayout
 */
$.shortcut("border", "FR.BorderLayout");
FR.BorderLayout = FR.extend(FR.LayoutContainer, {
	_init : function() {
		FR.BorderLayout.superclass._init.apply(this, arguments);
		var o = this.options = $.extend({
		   baseCls : 'fr-layout-border',
		   fit : true
		}, this.options);
		if (!$.isArray(this.options.items)) {
			this.options.items = [];
		}
		var self = this;
		var cc = this.element;// borderlayout
		if (cc[0].tagName == "BODY") {
			$("html").css({height : "100%", overflow : "hidden"});
			$("body").css({height : "100%", overflow : "hidden",border: "none"});
		}
		cc.addClass(o.baseCls);
		cc.css({margin:0,padding:0});
		o.widgets = [];
		var regionsAvailable = ["center", "north", "south", "east", "west"];
		for (var ri = 0; ri < regionsAvailable.length; ri++) {
			var region = regionsAvailable[ri];
			for (var ii = 0; ii < this.options.items.length; ii++) {
				var itemConfig = this.options.items[ii];
				if (itemConfig.region != region) {
					continue;
				}				
				var panel = this._createPanel(itemConfig);	
				this.element.append(panel.element);
				o[region] = panel;
			}
		}

		$('<div class="fr-layout-border-split-proxy-h"></div>').appendTo(cc);
		$('<div class="fr-layout-border-split-proxy-v"></div>').appendTo(cc);
		this.doResize();
		cc.bind('_resize', function(){			
			self.doReSize();			
			return false;
		});
	},
	// itemɹBorderLayoutĶеPanel
	_createPanel : function(itemConfig) {
		var self = this;
		var cc = this.element;
		var opts = this.options;
		var dir = itemConfig.region;		
    	var toolCls = null;
		if (dir == 'north'){ 
			toolCls = 'fr-layout-border-button-up';			
		} else if (dir == 'south'){
			toolCls = 'fr-layout-border-button-down';		
		} else if (dir == 'east'){
			toolCls = 'fr-layout-border-button-right';			
		} else if (dir == 'west'){
			toolCls = 'fr-layout-border-button-left';			
		}
				
		var cls = 'fr-layout-border-panel fr-layout-border-panel-' + dir;
		if (itemConfig.split == true){
			cls += ' fr-layout-border-split-' + dir;
		}
		var widget = FR.createWidget(itemConfig.el);
		// widgetס,resizedoLayoutʱ
		this.options.widgets.push(widget);
		var pp = new FR.Panel({
			border : itemConfig.border || false,
			width : itemConfig.width,
			height : itemConfig.height,
			autoScroll : itemConfig.autoScroll || false,
			widget : widget,
			cls : cls,
			fit : false,
			title : itemConfig.title,
			collapsible : false,
			tools: [{
					iconCls: toolCls, 
					handler: function(){
						self._collapsePanel(itemConfig);
					}
			}]	
		});
		if (itemConfig.split == true) {
			var panel = pp.element;
			var handles = '';
			if (dir == 'north') handles = 's';
			if (dir == 'south') handles = 'n';
			if (dir == 'east') handles = 'w';
			if (dir == 'west') handles = 'e';
			panel.resizable({
				handles:handles,
				start : function(e) {
						resizing = true;						
						if (dir == 'north' || dir == 'south'){
							var proxy = $('div.fr-layout-border-split-proxy-v', cc);
						} else {
							var proxy = $('div.fr-layout-border-split-proxy-h', cc);
						}
						var top=0,left=0,width=0,height=0;
						var pos = {display: 'block'};
						if (dir == 'north'){
							pos.top = parseInt(panel.css('top')) + panel.outerHeight() - proxy.height();
							pos.left = parseInt(panel.css('left'));
							pos.width = panel.outerWidth();
							pos.height = proxy.height();
						} else if (dir == 'south'){
							pos.top = parseInt(panel.css('top'));
							pos.left = parseInt(panel.css('left'));
							pos.width = panel.outerWidth();
							pos.height = proxy.height();
						} else if (dir == 'east'){
							pos.top = parseInt(panel.css('top')) || 0;
							pos.left = parseInt(panel.css('left')) || 0;
							pos.width = proxy.width();
							pos.height = panel.outerHeight();
						} else if (dir == 'west'){
							pos.top = parseInt(panel.css('top')) || 0;
							pos.left = panel.outerWidth() - proxy.width();
							pos.width = proxy.width();
							pos.height = panel.outerHeight();
						}
						proxy.css(pos);
						
						$('<div class="fr-layout-border-mask"></div>').css({
							left:0,
							top:0,
							width:cc.width(),
							height:cc.height()
						}).appendTo(cc);
				},
				resize : function(e){
					if (dir == 'north' || dir == 'south'){
							var proxy = $('div.fr-layout-border-split-proxy-v', cc);
							proxy.css('top', e.pageY - cc.offset().top - proxy.height()/2);
						} else {
							var proxy = $('div.fr-layout-border-split-proxy-h', cc);
							proxy.css('left', e.pageX - cc.offset().left - proxy.width()/2);
						}
						return false;
				},
				stop : function(e) {
					$('div.fr-layout-border-split-proxy-v', cc).css('display','none');
						$('div.fr-layout-border-split-proxy-h', cc).css('display','none');
						var opts = pp.options;
						opts.width = panel.outerWidth();
						opts.height = panel.outerHeight();
						opts.left = panel.css('left');
						opts.top = panel.css('top');
						pp.doResize();
						self.doResize();
						resizing = false;						
						$('div.fr-layout-border-mask', cc).remove();
				}
			});
		}
		$(cc).bind('_resize', function(){
			var opts = self.options;
			if (opts.fit == true){
				self.doResize();
			}
			return false;
		});
		return pp;		
	},
	_isVisible : function(pp) {
    	if (!pp) return false;
    	return pp.element.is(':visible');
    },
    _setNorthSize : function(cc, pp) {
    	if (!pp) return;
		pp.doResize({
			width: cc.width(),
			height: pp.options.height,
			left: 0,
			top: 0
		});
		this.cpos.top += pp.options.height;
		this.cpos.height -= pp.options.height;
    },
    _setSouthSize : function(cc, pp) {
		if (!pp) return;
		pp.doResize({
				width : cc.width(),
				height : pp.options.height,
				left : 0,
				top : cc.height() - pp.options.height
			});			
		this.cpos.height -= pp.options.height;
	},
	_setEastSize : function(cc, pp) {
		if (!pp) return;
		pp.doResize({
			width: pp.options.width,
			height: this.cpos.height,
			left: cc.width() - pp.options.width,
			top: this.cpos.top
			});			
		this.cpos.width -= pp.options.width;
	},
    _setWestSize : function(cc, pp) {
	    if (!pp) return;
		pp.doResize({
				width: pp.options.width,
				height: this.cpos.height,
				left: 0,
				top: this.cpos.top				
		});			
		this.cpos.left += pp.options.width;
		this.cpos.width -= pp.options.width;
	},	
    _collapsePanel : function(item) {
    	var opts = this.options;
    	var region = item.region;
    	var cc = this.element; 
    	if (region == "east") {
    		opts.center.doResize({
    			width : opts.center.options.width + opts.east.options.width - 28
    		});
    		opts.east.element.animate({left:cc.width()}, function() {
    			opts.east.doClose();
    			opts.expandEast.doOpen();
    			opts.expandEast.doResize({
    			    top: opts.east.options.top,
					left: cc.width() - 28,
					width: 28,
					height: opts.east.options.height});
    		});
    		// ڵʱ½һ
    		if (!opts.expandEast) {
    			opts.expandEast = this._createExpandPanel({region : "east"});
    		}
    	} else if (region == "west") {
    		opts.center.doResize({
				width: opts.center.options.width + opts.west.options.width - 28,
				left: 28
			});
			opts.west.element.animate({left:-opts.west.options.width}, function(){
				opts.west.doClose();
				opts.expandWest.doOpen();
				opts.expandWest.doResize({
					top: opts.west.options.top,
					left: 0,
					width: 28,
					height: opts.west.options.height
				});
			});
			if (!opts.expandWest) {
				opts.expandWest = this._createExpandPanel({region:'west'});
			}   		
    	} else if (region == "north") {
    		var hh = cc.height() - 28;
			if (this._isVisible(opts.expandSouth)){
				hh -= opts.expandSouth.options.height;
			} else if (this._isVisible(opts.south)){
				hh -= opts.south.options.height;
			}
			opts.center.doResize({top:28, height:hh});
			if (opts.east) opts.east.doResize({top:28, height:hh});
			if (opts.east) opts.west.doResize({top:28, height:hh});
			if (this._isVisible(opts.expandEast)) opts.expandEast.doResize({top:28, height:hh});
			if (this._isVisible(opts.expandWest)) opts.expandWest.doResize({top:28, height:hh});
			
			opts.north.element.animate({top:-opts.north.options.height}, function(){
				opts.north.doClose();
				opts.expandNorth.doOpen();
				opts.expandNorth.doResize({
					top: 0,
					left: 0,
					width: cc.width(),
					height: 28
				});
			});
			if (!opts.expandNorth) {
				opts.expandNorth = this._createExpandPanel({region:"north"});
			}
    	} else if (region == 'south'){			
			var hh = cc.height() - 28;
			if (this._isVisible(opts.expandNorth)){
				hh -= opts.expandNorth.options.height;
			} else if (this._isVisible(opts.north)){
				hh -= opts.north.options.height;
			}
			opts.center.doResize({height:hh});
			opts.east.doResize({height:hh});
			opts.west.doResize({height:hh});
			if (this._isVisible(opts.expandEast)) opts.expandEast.doResize({height:hh});
			if (this._isVisible(opts.expandWest)) opts.expandWest.doResize({height:hh});
			
			opts.south.element.animate({top:cc.height()}, function(){
				opts.south.doClose();
				opts.expandSouth.doOpen();
				opts.expandSouth.doResize({
					top: cc.height() - 28,
					left: 0,
					width: cc.width(),
					height: 28
				});
			});
			if (!opts.expandSouth) {
				opts.expandSouth = this._createExpandPanel({region:'south'});
			}
    	}
    },
    _createExpandPanel : function(item) {
    	var dir = item.region;
    	var cc = this.element;
    	var self = this;
    	var icon;
		if (dir == 'east') icon = 'fr-layout-border-button-left'
		else if (dir == 'west') icon = 'fr-layout-border-button-right'
		else if (dir == 'north') icon = 'fr-layout-border-button-down'
		else if (dir == 'south') icon = 'fr-layout-border-button-up';		
		var p = new FR.Panel({
			title : '&nbsp;',
			cls : "fr-layout-border-expand",
			fit : false,
			collapsible : false,
			tools: [{
					iconCls: icon,
					handler:function(){
						self._expandPanel(item);
					}
				}]
			
		});
		cc.append(p.element);
		p.element.hover(
			function(){$(this).addClass('fr-layout-border-expand-over');},
			function(){$(this).removeClass('fr-layout-border-expand-over');}
		);
		return p;  	
    },
    _expandPanel : function(item) {
    	var cc = this.element;
    	var region = item.region;
    	var opts = this.options;
    	var self = this;
    	if (region == 'east' && opts.expandEast){
    		opts.expandEast.doClose();
    		opts.east.element.stop(true, true);
			opts.east.doOpen();
			opts.east.doResize({left : cc.width()});
            opts.east.element.animate({
            	left: cc.width() - opts.east.options.width
            }, function() {
            	self.doResize();
            });
		} else if (region == 'west' && opts.expandWest){
			opts.expandWest.doClose();
			opts.west.element.stop(true,true);
			opts.west.doOpen();
			opts.west.doResize({left: -opts.west.options.width});
			opts.west.element.animate({
				left: 0
			}, function(){
				self.doResize();
			});
		} else if (region == 'north' && opts.expandNorth){
			opts.expandNorth.doClose();
			opts.north.element.stop(true,true);
			opts.north.doOpen();
			opts.north.doResize({top:-opts.north.options.height});
			opts.north.element.animate({top:0}, function(){
				self.doResize();
			});
		} else if (region == 'south' && opts.expandSouth){			
			opts.expandSouth.doClose();
			opts.south.element.stop(true,true);
			opts.south.doOpen();
			opts.south.doResize({top:cc.height()});
			opts.south.element.animate({top:cc.height()-opts.south.options.height}, function(){
				self.doResize();
			});
		}   	
    },
	doResize : function(give) {
		var opts = this.options;
    	var cc = this.element;
    	if (opts.fit == true){
			var p = cc.parent();
			cc.width(p.width()).height(p.height());
		}
		this.cpos = {
			top:0,
			left:0,
			width:cc.width(),
			height:cc.height()
		};
		if (this._isVisible(opts.expandNorth)) {
			this._setNorthSize(cc, opts.expandNorth);
		} else {
			this._setNorthSize(cc, opts.north);		
		}
		if (this._isVisible(opts.expandSouth)) {
			this._setSouthSize(cc, opts.expandSouth)
		} else {
			this._setSouthSize(cc, opts.south);	
		}
		if (this._isVisible(opts.expandEast)) {
			this._setEastSize(cc, opts.expandEast);
		} else {
			this._setEastSize(cc, opts.east);
		}
		if (this._isVisible(opts.expandWest)) {
			this._setWestSize(cc, opts.expandWest);
		} else {
			this._setWestSize(cc, opts.west);
		}
		opts.center.doResize(this.cpos);
	},
	doLayout : function() {
		this.doResize();
		FR.BorderLayout.superclass.doLayout.apply(this, arguments);		
	}
});

// BorderLayout .end

/**
 * FlowLayout .start
 * , Ӧڷ˵com.fr.report.web.ui.container.FlowLayout
 */
$.shortcut("flow", "FR.FlowLayout");
FR.FlowLayout = FR.extend(FR.LayoutContainer, {
	_init : function() {
		FR.FlowLayout.superclass._init.apply(this, arguments);
		var o = this.options = $.extend({
		   alignment : "center",
		   hgap : 5,
		   vgap : 5,
		   baseCls : 'fr-flowlayout'
		}, this.options);
		this.element.addClass(o.baseCls);
		var items = o.items, i, len = items.length;
		o.widgets = [];
		for (i = 0 ; i < len; i ++) {
			var item = items[i];
			var widget = FR.createWidget(item);
			// widgetŵwidgets,ԱdoLayoutʱ򷽱ʹ
			o.widgets.push(widget);
			var element = widget.element;
			// richer:Ѿwidget,ûҪٱԭJSON
			items[i] = element;
			this.element.append(element);
		}
		this.element.data('jlayout', jLayout.flow(o));
	},
	doResize : function(give) {
		FR.FlowLayout.superclass.doResize.apply(this, arguments);
		var opts = this.options;
		this.element.css({width : opts.width, height : opts.height,left: opts.left, top: opts.top});
	}
});
// FlowLayout .end

/**
 * GridLayout .start
 * , Ӧڷ˵com.fr.report.web.ui.container.GridLayout
 */
$.shortcut("grid", "FR.GridLayout");
FR.GridLayout = FR.extend(FR.LayoutContainer, {
	_init : function() {
		FR.GridLayout.superclass._init.apply(this, arguments);
		var o = this.options = $.extend({
		   hgap : 5, 
		   vgap : 5,
		   baseCls : 'fr-gridlayout'
		}, this.options);
		this.element.addClass(o.baseCls);
		var items = o.items, i, len = items.length;
		o.widgets = [];
		for (i = 0 ; i < len; i ++) {
			var item = items[i];
			var widget = FR.createWidget(item);
			// widgetŵwidgets,ԱdoLayoutʱ򷽱ʹ
			o.widgets.push(widget);
			var element = widget.element;
			// richer:Ѿwidget,ûҪٱԭJSON
			items[i] = element;
			this.element.append(element);
		}
		this.element.data('jlayout', jLayout.grid(o));
	},
	doResize : function(give) {
		FR.FlowLayout.superclass.doResize.apply(this, arguments);
		var opts = this.options;
		this.element.css({width : opts.width, height : opts.height,left: opts.left, top: opts.top});
	}
});
// GridLayout .end

FR.FDialog = FR.extend(FR.Container, {
	_init : function() {
		FR.FDialog.superclass._init.apply(this, arguments);
		var o = this.options = $.extend({
			title : "Dialog"
			
		}, this.options);
	}
})

