/**
 * var config = {
 *	     items : [
 *		    {region : "center", border:false},
 *			{region : "north"},
 *			{region : "south", split : true},
 *			{region : "west", split : true},
 *			{region : "esat", split : true}
 *		    ],
 *		 fit : true
 *   };
 * 
 * var borderlayout = $el.asComponent("border", config);
 */
$.widget("FR.BorderLayout1");$.shortcut("border", "$.FR.BorderLayout1")
FR.extend($.FR.BorderLayout1, $.FR.Widget, {
    _init : function() {
    	$.FR.BorderLayout1.superclass._init.apply(this, arguments);
    	var cc = this.element; 
    	var self = this;
    	var o = this.options = $.extend({
    	 	
    	}, this.options);
    	if (cc[0].tagName == 'BODY'){
			$('html').css({height: '100%', overflow: 'hidden'});
			$('body').css({height: '100%',overflow: 'hidden', border: 'none'});
		}
		// ȻҪʹò,ôðoverflowΪhidden
		cc.css({overflow:'hidden'});
		cc.addClass('fr-borderlayout');
		cc.css({margin:0, padding:0});
		var items = o.items;
		$.each(items, function(i, item) {
			o[item.region] = self._createRegion(item);
		})
		$('<div class="fr-borderlayout-split-proxy-h"></div>').appendTo(cc);
		$('<div class="fr-borderlayout-split-proxy-v"></div>').appendTo(cc);
		this._setSize();
		cc.bind('_resize', function(){			
			self._setSize();			
			return false;
		});
		$(window).resize(function(){
			self._setSize();
		});
    	 
    },
    _setSize : function() {
    	var opts = this.options;
    	var cc = this.element;
		this.cpos = {
			top:0,
			left:0,
			width:cc.width(),
			height:cc.height()
		};
		if (this._isVisible(opts.expandNorth)) {
			this._setNorthSize(cc, opts.expandNorth);
		} else {
			this._setNorthSize(cc, opts.north);		
		}
		if (this._isVisible(opts.expandSouth)) {
			this._setSouthSize(cc, opts.expandSouth)
		} else {
			this._setSouthSize(cc, opts.south);	
		}
		if (this._isVisible(opts.expandEast)) {
			this._setEastSize(cc, opts.expandEast);
		} else {
			this._setEastSize(cc, opts.east);
		}
		if (this._isVisible(opts.expandWest)) {
			this._setWestSize(cc, opts.expandWest);
		} else {
			this._setWestSize(cc, opts.west);
		}
		
		opts.center.onResize(this.cpos);		
    },
    _setNorthSize : function(cc, pp) {
    	if (!pp) return;
			pp.onResize({
				width: cc.width(),
				height: pp.options.height,
				left: 0,
				top: 0
			});
		this.cpos.top += pp.options.height;
		this.cpos.height -= pp.options.height;
    },
     _setSouthSize : function(cc, pp) {
		if (!pp) return;
			pp.onResize({
				width : cc.width(),
				height : pp.options.height,
				left : 0,
				top : cc.height() - pp.options.height
			});			
		this.cpos.height -= pp.options.height;
	},
	_setEastSize : function(cc, pp) {
		if (!pp) return;
		    var self = this;
			pp.onResize({
				width: pp.options.width,
				height: self.cpos.height,
				left: cc.width() - pp.options.width,
				top: self.cpos.top
			});			
		this.cpos.width -= pp.options.width;
	},
    _setWestSize : function(cc, pp) {
	    if (!pp) return;
	        var self = this;
			pp.onResize({
				width: pp.options.width,
				height: self.cpos.height,
				left: 0,
				top: self.cpos.top				
			});			
		this.cpos.left += pp.options.width;
		this.cpos.width -= pp.options.width;
	},	
    
    // region = Center/North/South/West/East
    _createRegion : function(item) {
    	var cc = this.element;
    	var pp = item.el;
    	//.addClass("fr-borderlayout-body");
    	var dir = item.region;
    	var toolCls = null;
		if (dir == 'north'){
			toolCls = 'fr-borderlayout-button-up';
		} else if (dir == 'south'){
			toolCls = 'fr-borderlayout-button-down';
		} else if (dir == 'east'){
			toolCls = 'fr-borderlayout-button-right';
		} else if (dir == 'west'){
			toolCls = 'fr-borderlayout-button-left';
		}
			
		var cls = 'fr-borderlayout-panel fr-borderlayout-panel-' + dir;
		if (item.split == true){
			cls += ' fr-borderlayout-split-' + dir;
		}
		var self = this;
		pp = pp.asComponent("basicpane", {
			border: item.border,
			width : item.width,
			height : item.height,
			cls : cls,
			overflow : item.overflow || "hidden",
			noheader : false,
			title : item.title,
			collapsable : false,
			tools: [{
					iconCls: toolCls, 
					handler: function(){
						self._collapsePanel(item);
					}
			}]	
		});
		
		if (item.split == true) {
			var panel = pp.element;
			var handles = '';
			if (dir == 'north') handles = 's';
			if (dir == 'south') handles = 'n';
			if (dir == 'east') handles = 'w';
			if (dir == 'west') handles = 'e';
			panel.resizable({
				handles:handles,
				start : function(e) {
						resizing = true;						
						if (dir == 'north' || dir == 'south'){
							var proxy = $('div.fr-borderlayout-split-proxy-v', cc);
						} else {
							var proxy = $('div.fr-borderlayout-split-proxy-h', cc);
						}
						var top=0,left=0,width=0,height=0;
						var pos = {display: 'block'};
						if (dir == 'north'){
							pos.top = parseInt(panel.css('top')) + panel.outerHeight() - proxy.height();
							pos.left = parseInt(panel.css('left'));
							pos.width = panel.outerWidth();
							pos.height = proxy.height();
						} else if (dir == 'south'){
							pos.top = parseInt(panel.css('top'));
							pos.left = parseInt(panel.css('left'));
							pos.width = panel.outerWidth();
							pos.height = proxy.height();
						} else if (dir == 'east'){
							pos.top = parseInt(panel.css('top')) || 0;
							pos.left = parseInt(panel.css('left')) || 0;
							pos.width = proxy.width();
							pos.height = panel.outerHeight();
						} else if (dir == 'west'){
							pos.top = parseInt(panel.css('top')) || 0;
							pos.left = panel.outerWidth() - proxy.width();
							pos.width = proxy.width();
							pos.height = panel.outerHeight();
						}
						proxy.css(pos);
						
						$('<div class="fr-borderlayout-mask"></div>').css({
							left:0,
							top:0,
							width:cc.width(),
							height:cc.height()
						}).appendTo(cc);
				},
				resize : function(e){
					if (dir == 'north' || dir == 'south'){
							var proxy = $('div.fr-borderlayout-split-proxy-v', cc);
							proxy.css('top', e.pageY - cc.offset().top - proxy.height()/2);
						} else {
							var proxy = $('div.fr-borderlayout-split-proxy-h', cc);
							proxy.css('left', e.pageX - cc.offset().left - proxy.width()/2);
						}
						return false;
				},
				stop : function(e) {
					$('div.fr-borderlayout-split-proxy-v', cc).css('display','none');
						$('div.fr-borderlayout-split-proxy-h', cc).css('display','none');
						var opts = pp.options;
						opts.width = panel.outerWidth();
						opts.height = panel.outerHeight();
						opts.left = panel.css('left');
						opts.top = panel.css('top');
						pp.onResize();
						self._setSize();
						resizing = false;						
						$('div.fr-borderlayout-mask', cc).remove();
				}
			});
		}
		return pp;
    },
    _collapsePanel : function(item) {
    	var opts = this.options;
    	var region = item.region;
    	var cc = this.element; 
    	if (region == "east") {
    		opts.center.onResize({
    			width : opts.center.options.width + opts.east.options.width - 28
    		});
    		opts.east.element.animate({left:cc.width()}, function() {
    			opts.east.onClose();
    			opts.expandEast.onOpen();
    			opts.expandEast.onResize({
    			    top: opts.east.options.top,
					left: cc.width() - 28,
					width: 28,
					height: opts.east.options.height});
    		});
    		// ڵʱ½һ
    		if (!opts.expandEast) {
    			opts.expandEast = this._createExpandPanel({region : "east"});
    		}
    	} else if (region == "west") {
    		opts.center.onResize({
				width: opts.center.options.width + opts.west.options.width - 28,
				left: 28
			});
			opts.west.element.animate({left:-opts.west.options.width}, function(){
				opts.west.onClose();
				opts.expandWest.onOpen();
				opts.expandWest.onResize({
					top: opts.west.options.top,
					left: 0,
					width: 28,
					height: opts.west.options.height
				});
			});
			if (!opts.expandWest) {
				opts.expandWest = this._createExpandPanel({region:'west'});
			}   		
    	} else if (region == "north") {
    		var hh = cc.height() - 28;
			if (this._isVisible(opts.expandSouth)){
				hh -= opts.expandSouth.options.height;
			} else if (this._isVisible(opts.south)){
				hh -= opts.south.options.height;
			}
			opts.center.onResize({top:28, height:hh});
			opts.east.onResize({top:28, height:hh});
			opts.west.onResize({top:28, height:hh});
			if (this._isVisible(opts.expandEast)) opts.expandEast.onResize({top:28, height:hh});
			if (this._isVisible(opts.expandWest)) opts.expandWest.onResize({top:28, height:hh});
			
			opts.north.element.animate({top:-opts.north.options.height}, function(){
				opts.north.onClose();
				opts.expandNorth.onOpen();
				opts.expandNorth.onResize({
					top: 0,
					left: 0,
					width: cc.width(),
					height: 28
				});
			});
			if (!opts.expandNorth) {
				opts.expandNorth = this._createExpandPanel({region:"north"});
			}
    	} else if (region == 'south'){			
			var hh = cc.height() - 28;
			if (this._isVisible(opts.expandNorth)){
				hh -= opts.expandNorth.options.height;
			} else if (this._isVisible(opts.north)){
				hh -= opts.north.options.height;
			}
			opts.center.onResize({height:hh});
			opts.east.onResize({height:hh});
			opts.west.onResize({height:hh});
			if (this._isVisible(opts.expandEast)) opts.expandEast.onResize({height:hh});
			if (this._isVisible(opts.expandWest)) opts.expandWest.onResize({height:hh});
			
			opts.south.element.animate({top:cc.height()}, function(){
				opts.south.onClose();
				opts.expandSouth.onOpen();
				opts.expandSouth.onResize({
					top: cc.height() - 28,
					left: 0,
					width: cc.width(),
					height: 28
				});
			});
			if (!opts.expandSouth) {
				opts.expandSouth = this._createExpandPanel({region:'south'});
			}
    	}
    },
    _createExpandPanel : function(item) {
    	var dir = item.region;
    	var cc = this.element;
    	var self = this;
    	var icon;
		if (dir == 'east') icon = 'fr-borderlayout-button-left'
		else if (dir == 'west') icon = 'fr-borderlayout-button-right'
		else if (dir == 'north') icon = 'fr-borderlayout-button-down'
		else if (dir == 'south') icon = 'fr-borderlayout-button-up';
			
		var p = $('<div class="fr-used"></div>').appendTo(cc).asComponent("basicpane",{
				cls: 'fr-borderlayout-expand',
				title: '&nbsp;',
				closed: true,
				doSize: false,
				tools: [{
					iconCls: icon,
					handler:function(){
						self._expandPanel(item);
					}
				}]
			});
			p.element.hover(
				function(){$(this).addClass('fr-borderlayout-expand-over');},
				function(){$(this).removeClass('fr-borderlayout-expand-over');}
			);
			return p;
    	
    },
    _expandPanel : function(item) {
    	var cc = this.element;
    	var region = item.region;
    	var opts = this.options;
    	var self = this;
    	if (region == 'east' && opts.expandEast){
    		opts.expandEast.onClose();
    		opts.east.element.stop(true, true);
			opts.east.onOpen();
			opts.east.onResize({left : cc.width()});
            opts.east.element.animate({
            	left: cc.width() - opts.east.options.width
            }, function() {
            	self._setSize();
            });
		} else if (region == 'west' && opts.expandWest){
			opts.expandWest.onClose();
			opts.west.element.stop(true,true);
			opts.west.onOpen();
			opts.west.onResize({left: -opts.west.options.width});
			opts.west.element.animate({
				left: 0
			}, function(){
				self._setSize();
			});
		} else if (region == 'north' && opts.expandNorth){
			opts.expandNorth.onClose();
			opts.north.element.stop(true,true);
			opts.north.onOpen();
			opts.north.onResize({top:-opts.north.options.height});
			opts.north.element.animate({top:0}, function(){
				self._setSize();
			});
		} else if (region == 'south' && opts.expandSouth){			
			opts.expandSouth.onClose();
			opts.south.element.stop(true,true);
			opts.south.onOpen();
			opts.south.onResize({top:cc.height()});
			opts.south.element.animate({top:cc.height()-opts.south.options.height}, function(){
				self._setSize();
			});
		}   	
    },
    _isVisible : function(pp) {
    	if (!pp) return false;
    	return pp.element.is(':visible');
    }
});