/**
 * BasePanel
 * Operation include: open/close,expand/collapse
 */
$.widget("FR.BasicPane");$.shortcut("basicpane", "$.FR.BasicPane")
FR.extend($.FR.BasicPane, $.FR.Widget, {
    _init : function() {
        $.FR.BasicPane.superclass._init.apply(this, arguments);
         var o = this.options = $.extend({
         	baseCls: "fr-panel",
         	noheader : false,
         	title:"",
         	cls : "",
         	collapsable:false,
         	closable:true,
         	split:false,
         	border:true,
         	width:"auto",
         	height:"auto",
         	overflow:"auto",
         	fit:false
         }, this.options);
         this._createPanel();        
    },
    _createPanel : function(){
		this.element.addClass("fr-panel");
		var opts = this.options;
		if (opts.width) {
			this.element.width(opts.width);
		}
		if (opts.height) {
			this.element.height(opts.height);
		}
		this._createContent();
		this._createTitle();
		this.setBorder();
		var self = this;
		$(window).resize(function(){
			self._setSize();
		});
	},
	_createTitle : function(){
		var self = this;
		var opts = this.options;
		var panel = this.element;
		// titleżȥ
		if (opts.title && !opts.noheader) {
			var header = $('<div class="fr-panel-header"><div class="fr-panel-title">'+opts.title+'</div></div>').prependTo(panel);
			var tool = $('<div class="fr-panel-tool"></div>').appendTo(header);
			if (opts.collapsable){
				// ť
				$('<div class="fr-panel-tool-collapse"></div>').appendTo(tool)
				.click(function(){
					var cur = this;
				    self.onToggle(cur)
				});
			}
			if (opts.tools){
				for(var i=opts.tools.length-1; i>=0; i--){
					var t = $('<div></div>').addClass(opts.tools[i].iconCls).appendTo(tool);
					if (opts.tools[i].handler){
						t.bind('click', eval(opts.tools[i].handler));
					}
				}
			}
			tool.find('div').hover(
				function(){$(this).addClass('fr-panel-tool-over');},
				function(){$(this).removeClass('fr-panel-tool-over');}
			);
			$('div.fr-panel-body', this.element).removeClass('fr-panel-body-noheader');
		} else {
			$('div.fr-panel-body', this.element).addClass('fr-panel-body-noheader');
		}
	},
	_createContent : function(html){ 
		var opts = this.options;
		var el = this.element;
		el.wrapInner('<div class="fr-borderlayout-body fr-panel-body"></div>'); 
		var body = $("div.fr-panel-body", el);
		body.css("overflow", opts.overflow);
		if (opts.url) {
			this._loadData(opts.url, body);
		} else if (opts.html) {
			body.html(opts.html);
		} 			
	},
	_loadData : function(url, body) {
		var opts = this.options;
		if (!opts.isLoaded) {
			opts.isLoaded = false;
			body.html($('<div class="fr-panel-loading"></div>').html("loading..."));
			body.load(url, null, function(){
				opts.isLoaded = true;
			});
		}
	},
	// layoutʱҪ
	_setSize : function(param){
		var opts = this.options;
		var panel = this.element;
		var header = $("div.fr-panel-header", this.element);
		var body = $("div.fr-panel-body", this.element);
		if (param){
			if (param.width) opts.width = param.width;
			if (param.height) opts.height = param.height;
			if (param.left != null) opts.left = param.left;
			if (param.top != null) opts.top = param.top;
		}
		if (opts.fit == true){
			var p = panel.parent();
			opts.width = p.width();
			opts.height = p.height();
		}
		panel.css({
			left: opts.left,
			top: opts.top
		});
//		panel.css(opts.style);
		panel.addClass(opts.cls);
//		header.addClass(opts.headerCls);
//		body.addClass(opts.bodyCls);
		if (!isNaN(opts.width)){
			if ($.boxModel == true){
				panel.width(opts.width - (panel.outerWidth() - panel.width()));
				header.width(panel.width() - (header.outerWidth() - header.width()));
				body.width(panel.width() - (body.outerWidth() - body.width()));
			} else {
				panel.width(opts.width);
				header.width(panel.width());
				body.width(panel.width());
			}
		} else {
			panel.width('auto');
			pbody.width('auto');
		}
		if (!isNaN(opts.height)){
			if ($.boxModel == true){
				panel.height(opts.height - (panel.outerHeight() - panel.height()));
				body.height(panel.height() - header.outerHeight() - (body.outerHeight() - body.height()));
			} else {
				panel.height(opts.height);
				body.height(panel.height() - header.outerHeight());
			}
		} else {
			body.height('auto');
		}
		panel.css('height', null);
		this.element.triggerHandler('_resize');
	},
	setBorder : function(){
		var opts = this.options;
		var el = this.element;
		if (opts.border == true){
			$('div.fr-panel-header', el).removeClass('fr-panel-header-noborder');
			$('div.fr-panel-body', el).removeClass('fr-panel-body-noborder');
		} else {
			$('div.fr-panel-header', el).addClass('fr-panel-header-noborder');
			$('div.fr-panel-body', el).addClass('fr-panel-body-noborder');
		}
	},
	onResize : function(size){
		this._setSize(size);
	},
	onOpen : function(){
		var opts = this.options;
		this.element.show();
		opts.closed = false;
	},
	onClose : function(){
		var opts = this.options;
		this.element.hide();
		opts.closed = true;
	},
    onToggle : function(e){
    	if ($(e).hasClass('fr-panel-tool-expand')){
				this.expand(true);
			} else {
				this.collapse(true);
			}
		return false;
    },
	expand : function(animate){
		var opts = this.options;
		var body = $('div.fr-panel-body', this.element);
		var tool = $('div.fr-panel-header .fr-panel-tool-collapse', this.element);
		// bodyڻĶҪֹͣ
		body.stop(true, true);
		tool.removeClass('fr-panel-tool-expand');
		if (animate == true){
			body.slideDown("slow", function(){
				opts.collapsed = false;
			});
		} else {
			body.show();
			opts.collapsed = false;
		}
	},
	collapse : function(animate){
		var opts = this.options;
		var body = $('div.fr-panel-body', this.element);
		var tool = $('div.fr-panel-header .fr-panel-tool-collapse', this.element);
		// bodyڻĶҪֹͣ
		body.stop(true, true);
		tool.addClass('fr-panel-tool-expand');
		if (animate == true){
			body.slideUp("slow", function(){
				opts.collapsed = false;
			});
		} else {
			body.hide();
			opts.collapsed = false;
		}
	}
});
 