$.fn.tabs.isSeed = 0;
$.widget("FR.BasicTabs");$.shortcut("basictabs", "$.FR.BasicTabs")
FR.extend($.FR.BasicTabs, $.FR.Widget, {
    _init : function() {
        $.FR.BasicTabs.superclass._init.apply(this, arguments);
         var o = this.options = $.extend({
         	width : "auto",
			height : "auto",
			border : true,
			activeTab:0,
			scrollIncrement: 100,
		    scrollDuration: 400,
			items : [],
			onLoad : function(){},
		    onSelect : function(title){},
		    onClose : function(title){}
         }, this.options);
         this._createTabs();  
         this._setProperties();
         this._setSize();
         this.selectTab();
    },
    _createTabs : function() {
    	var opts = this.options;
    	this.element.addClass("fr-tabs-container");
    	this.element.wrapInner('<div class="fr-tabs-panels"/>');
		$('<div class="fr-tabs-header">'
				+ '<div class="fr-tabs-scroller-left"></div>'
				+ '<div class="fr-tabs-scroller-right"></div>'
				+ '<div class="fr-tabs-wrap">'
				+ '<ul class="fr-tabs"></ul>'
				+ '</div>'
				+ '</div>').prependTo(this.element);
		var header = $('>div.fr-tabs-header', this.element);
		var items = opts.items;
		for (var i = 0, len = items.length; i < len; i ++) {
			this._createTab(items[i], i);
		}	
		$('.fr-tabs-scroller-left, .fr-tabs-scroller-right', header).hover(
			function(){$(this).addClass('fr-tabs-scroller-over');},
			function(){$(this).removeClass('fr-tabs-scroller-over');}
		);
    },
    _setProperties : function() {
    	var opts = this.options;
        var el = this.element;
    	var header = $('>div.fr-tabs-header', el);
		var panels = $('>div.fr-tabs-panels', el);
		var tabs = $('ul.fr-tabs', el);
		if (opts.border == true){
			header.removeClass('fr-tabs-header-noborder');
			panels.removeClass('fr-tabs-panels-noborder');
		} else {
			header.addClass('fr-tabs-header-noborder');
			panels.addClass('fr-tabs-panels-noborder');
		}
		var self = this;
		$('li', tabs).unbind('.fr-tabs').bind('click.fr-tabs', function(){
			$('.fr-tabs-selected', tabs).removeClass('fr-tabs-selected');
			$(this).addClass('fr-tabs-selected');
			$(this).blur();
			$('>div.fr-tabs-panels>div', el).css('display', 'none');
			var wrap = $('.fr-tabs-wrap', header);
			var leftPos = self._getTabLeftPosition(this);
			var left = leftPos - wrap.scrollLeft();
			var right = left + $(this).outerWidth();
			if (left < 0 || right > wrap.innerWidth()) {
				var pos = Math.min(
						leftPos - (wrap.width()-$(this).width()) / 2,
						self._getMaxScrollWidth()
				);
				wrap.animate({scrollLeft:pos}, opts.scrollDuration);
			}
			var tIndex = $(this).attr("tIndex");
			var panel = $('#fr-tabs-panel' + tIndex);
			panel.css('display', 'block');
			var iNum = $(this).attr("num"); 
			var item = opts.items[iNum];
			if (item.url && !item.loaded) {
				panel.html($('<div class="fr-panel-loading"></div>').html("loading..."));
				panel.load(item.url, null, function() {
					item.loaded = true;
				});
			}
		});
		$('a.fr-tabs-close', tabs).unbind('.fr-tabs').bind('click.fr-tabs', function(){
		    // ȡ li
			var elem = $(this).parent()[0];
			var title = $(elem).attr("title");
			self.closeTab(title);
		});
		$('.fr-tabs-scroller-left', header).unbind('.fr-tabs').bind('click.fr-tabs', function(){
			var wrap = $('.fr-tabs-wrap', header);
			var pos = wrap.scrollLeft() - opts.scrollIncrement;
			wrap.animate({scrollLeft:pos}, opts.scrollDuration);
		});
		
		$('.fr-tabs-scroller-right', header).unbind('.fr-tabs').bind('click.fr-tabs', function(){
			var wrap = $('.fr-tabs-wrap', header);
			var pos = Math.min(
					wrap.scrollLeft() + opts.scrollIncrement,
					self._getMaxScrollWidth()
			);
			wrap.animate({scrollLeft:pos}, opts.scrollDuration);
		});
    },
    _createTab : function(item, index) {
    	var header = $('>div.fr-tabs-header', this.element);
		var tabs = $('ul.fr-tabs', header);
		var tab = $('<li></li>').attr("num", index)
		                        .attr("tIndex", $.fn.tabs.isSeed)
		                        .attr("title", item.title);
		var tab_span = $('<span></span>').html(item.title);
		var tab_a = $('<a class="fr-tabs-inner"></a>').attr('href', 'javascript:void(0)').append(tab_span);
		tab.append(tab_a).appendTo(tabs);
		if (item.closable) {
			tab_span.addClass('fr-tabs-closable');
			tab_a.after('<a href="javascript:void(0)" class="fr-tabs-close"></a>');
		}
		if (item.icon) {
			tab_span.addClass('fr-tabs-with-icon');
			tab_span.after($('<span/>').addClass('fr-tabs-icon').addClass(item.icon));
		}
		if (item.selected) {
			tab.addClass('fr-tabs-selected');
		}
		var body = $(">div.fr-tabs-panels", this.element);
		if (item.contentEl) {
			var content = $("<div>").attr("id", "fr-tabs-panel" + $.fn.tabs.isSeed ++ ).appendTo(body);
			content.html($("#" + item.contentEl));
		}
		if (item.url) {
			$("<div>").attr("id", "fr-tabs-panel" + $.fn.tabs.isSeed ++ ).appendTo(body);
		}
    },
    _getTabLeftPosition : function(tab) {
    	var w = 0;
		var b = true;
		$('>div.fr-tabs-header ul.fr-tabs li', this.element).each(function(){
			if (this == tab) {
				b = false;
			}
			if (b == true) {
				w += $(this).outerWidth(true);
			}
		});
		return w;
    },
    _getMaxScrollWidth : function() {
    	var header = $('>div.fr-tabs-header', this.element);
		var tabsWidth = 0;	// all tabs width
		$('ul.fr-tabs li', header).each(function(){
			tabsWidth += $(this).outerWidth(true);
		});
		var wrapWidth = $('.fr-tabs-wrap', header).width();
		var padding = parseInt($('.fr-tabs', header).css('padding-left'));		
		return tabsWidth - wrapWidth + padding;
    },
    _setSize : function() {
    	var opts = this.options;
    	var el = this.element;
    	if (opts.fit == true){
			var p = el.parent();
			opts.width = p.width();
			opts.height = p.height();
		}
		el.width(opts.width).height(opts.height);
		var header = $('>div.fr-tabs-header', el);
		if ($.boxModel == true) {
			var delta = header.outerWidth() - header.width();
			header.width(el.width() - delta);
		} else {
			header.width(el.width());
		}		
		this._setScrollers();
		var panels = $('>div.fr-tabs-panels', this.element);
		var height = opts.height;
		if (!isNaN(height)) {
			if ($.boxModel == true) {
				var delta = panels.outerHeight() - panels.height();
				panels.css('height', (height - header.outerHeight() - delta) || 'auto');
			} else {
				panels.css('height', height - header.outerHeight());
			}
		} else {
			panels.height('auto');
		}
		var width = opts.width;
		if (!isNaN(width)){
			if ($.boxModel == true) {
				var delta = panels.outerWidth() - panels.width();
				panels.width(width - delta);
			} else {
				panels.width(width);
			}
		} else {
			panels.width('auto');
		}
    },
    _setScrollers : function() {
    	var header = $('>div.fr-tabs-header', this.element);
		var tabsWidth = 0;
		$('ul.fr-tabs li', header).each(function(){
			tabsWidth += $(this).outerWidth(true);
		});
		
		if (tabsWidth > header.width()) {
			$('.fr-tabs-scroller-left', header).css('display', 'block');
			$('.fr-tabs-scroller-right', header).css('display', 'block');
			$('.fr-tabs-wrap', header).addClass('fr-tabs-scrolling');
			
			if ($.boxModel == true) {
				$('.fr-tabs-wrap', header).css('left',2);
			} else {
				$('.fr-tabs-wrap', header).css('left',0);
			}
			var width = header.width()
				- $('.fr-tabs-scroller-left', header).outerWidth()
				- $('.fr-tabs-scroller-right', header).outerWidth();
			$('.fr-tabs-wrap', header).width(width);
			
		} else {
			$('.fr-tabs-scroller-left', header).css('display', 'none');
			$('.fr-tabs-scroller-right', header).css('display', 'none');
			$('.fr-tabs-wrap', header).removeClass('fr-tabs-scrolling').scrollLeft(0);
			$('.fr-tabs-wrap', header).width(header.width());
			$('.fr-tabs-wrap', header).css('left',0);			
		}
    },
    _fitContent : function() {
    	var tab = $('>div.fr-tabs-header ul.fr-tabs li.fr-tabs-selected', this.element);
		if (tab.length){
			
		}
    },
    selectTab : function(title) {
    	if (title) {
			var elem = $('>div.fr-tabs-header li:has(a span:contains("' + title + '"))', this.element)[0];
			if (elem) {
				$(elem).trigger('click');
			}
		} else {		
			var tabs = $('>div.fr-tabs-header ul.fr-tabs', this.element);
			if ($('.fr-tabs-selected', tabs).length == 0) {
				$('li:first', tabs).trigger('click');
			} else {
				$('.fr-tabs-selected', tabs).trigger('click');
			}
		}
    },
    closeTab : function(title) {
    	var opts = this.options;
		var elem = $('>div.fr-tabs-header li:has(a span:contains("' + title + '"))', this.element)[0];
		if (!elem) return;
		
		var tIndex = $(elem).attr("tIndex");
		var panel = $('#' + tIndex);
		
		var selected = $(elem).hasClass('fr-tabs-selected');
		$(elem).remove();
		panel.remove();		
		this._setSize();
		if (selected) {
			this.selectTab();
		} else {
			var wrap = $('>div.fr-tabs-header .fr-tabs-wrap', this.element);
			var pos = Math.min(
					wrap.scrollLeft(),
					this._getMaxScrollWidth()
			);
			wrap.animate({scrollLeft:pos}, opts.scrollDuration);
		}
    }
});