(function() {
	var kv = {};  // alex:(༭,text)ֵ(Ҳһַ,$.FR.TextEditor)
	$.shortcut = function(xtype, className) {
		kv[xtype] = className;
	};
	// widget
	FR.createWidget = function(config) {
		var xtype = config.xtype.toLowerCase();
		var className = kv[xtype];
		return new Function("config", "return new " + className + "(config);")(config);
	};
})();

FR.widget = {
   opts : {
   		zIndex : 8000,
   		num : 0   		
   }
};
// FR.OB .start
FR.OB = function(config){
   this.options = $.extend({  	
   }, config);
   this._init();
}
FR.OB.prototype = {
	type : "ob",
	_init : function() {
		var self = this;
		if (this.options.listeners != null) {
			$.each(this.options.listeners, function(i, lis) {
				(lis.target ? lis.target : self)[lis.once ? 'once' : 'on'](lis.eventName, lis.action.createDelegate(self))
			})
			delete this.options.listeners;
		}
	},
	_getEvents : function() {
		if (!FR.isArray(this.events)) {
			this.events = []
		}		
		return this.events;
	},
	fireEvent : function() {
		var eventName = arguments[0].toLowerCase();
    	var fns = this._getEvents()[eventName];
    	if (FR.isArray(fns)) {
    		var args = Array.prototype.slice.call(arguments, 1)
    		for (var i = 0; i < fns.length; i++) {
    			if (fns[i].apply(this, args) === false) {
    				return false;
    			}
    		}
    	}  	
    	return true;
	},
	on : function(eventName, fn) {
		eventName = eventName.toLowerCase();
    	var fns = this._getEvents()[eventName];
    	if (!FR.isArray(fns)) {
    		fns = [];
    		this._getEvents()[eventName] = fns;
    	}
    	fns.push(fn);
	},
	once : function(eventName, fn) {
		var proxy = function() {
    		fn.apply(this, arguments);
    		this.un(eventName, proxy);
    	}
    	this.on(eventName, proxy);
	},
	un : function(eventName, fn) {
		// alex:fnnull,ǰeventNameзun
    	if (fn == null) {
    		delete this._getEvents()[eventName];
    	} else {
	    	var fns = this._getEvents()[eventName];
	    	if (FR.isArray(fns)) {
	    		/*
	    		 * alex:ÿķʽ,spliceֱɾfnsеԪ
	    		 * ΪfireEventʱ,Ӧķonceȥ,ִ֮fnsĳ,ᵼЩfn޷ִ
	    		 * ķʽonceһfn,onһfn,ôfireEventᵼonfnûִ
	    		 */
	    		var newFns = [];
	    		$.each(fns, function(idx, ifn) {
	    			if(ifn != fn) {
	    				newFns.push(ifn);
	    			}
	    		})
	    		this._getEvents()[eventName] = newFns;
	    	} 
    	}
	},
	purgeListeners : function() {
		// alex:events
    	this.events = [];
	}
}
FR.OB.capture = function(o, fn, scope) {
	o.fireEvent = o.fireEvent.createInterceptor(fn, scope);
}
// alex:ͷ¼Ĳ׽
FR.OB.releaseCapture = function(o) {
	o.fireEvent = FR.OB.prototype.fireEvent;
}
// FR.OB .end

// FR.Widget .start
/**
 * disbled : 
 * invisibe : ɼ
 */
FR.Widget = FR.extend(FR.OB, {
	type : "widget",	
	_init : function() {
		FR.Widget.superclass._init.apply(this, arguments);
		var o = this.options = $.extend({
			widgetName : "",
			width : 24,
			height : 24,
			disabled : false,
			invisible : false
		}, this.options);
		this.element = $("<div></div>");
		if (o.widgetName) {
			this.element.attr({widgetName : o.widgetName});
		}
		if (o.renderTo) {
			this.render(o.renderTo);
		}
	},
	render : function(container, position) {
		var ct;
		if (typeof container == "string") {
			ct = container == "body" ? $("body") : $("#" + container);
			
		} else if (typeof container == "object"){
			ct = $(container);
		} else {
			ct = $("body");
		}	
		ct.append(this.element);
	},
	doResize : function(give) {
		var opts = this.options;
		var cc = this.element;
		if (give){
			if (give.width) opts.width = give.width;
			if (give.height) opts.height = give.height;
			if (give.left != null) opts.left = give.left;
			if (give.top != null) opts.top = give.top;
		}
		if (opts.fit == true) {
			var p = cc.parent();
			var p_width = cc.width();
			var p_height = cc.height();
			opts.width = p_width;
			opts.height = p_height;			
		}
	},
	distroy : function() {
		this.element.remove();
		if ($.browser.msie){
			this.element.outerHTML = '';
		}
		if ($.isFunction(this.options.onDistroy)) {
			this.options.onDistroy.call(this);
		}
	},
	isEnabled : function() {
		return !this.options.disabled;
	},
	isVisible : function() {
		return !this.options.invisible;
	},
	// TODO disableʵʱû뵽ϲ,
	setEnable : function() {
		
	},
	setVisible : function(arg) {
		// ֻвΪtrue/falseʱзӦ,һɲκθı
		if (arg == true) {
			this.options.invisible = false;
			this.element.show();
		} else if (arg == false) {
			this.options.invisible = true;
			this.element.hide();
		}		
	}
})
// FR.Widget .end

// FR.Container .start
/**
 * richer:,Ӧڷ˵com.fr.report.web.ui.container.Container
 */
FR.Container = FR.extend(FR.Widget, {
 	_init : function() {
		FR.Container.superclass._init.apply(this, arguments);
	}
})
// FR.Container .end

// FR.Panel .start
/**
 * title : 
 * closable : Ƿɹر
 * maximizable  : Ƿ
 * minimizable  ǷС
 * collapsible  Ƿ
 * autoScroll  Ƿݳֹ
 * closed  ʼ״̬Ƿǹرյ
 * width : ߶
 * height : 
 */
FR.Panel = FR.extend(FR.Container, {
	_init : function() {
		FR.Panel.superclass._init.apply(this, arguments);
		var o = this.options = $.extend({
			baseCls : "fr-panel",// ʽ
			fit : true,// ԶӦС,
			dosize : true,
			border : true, // ߿
			closable : false,
			maximizable : false,// 
			minimizable : false,// С
			collapsible : true, // 
			autoScroll : true, //ݵĶԶʾ
			closed : false,
			width : "auto",
			height : "auto"
		}, this.options);
		this.element.addClass(o.baseCls);
		if (o.width > -1) {
			this.element.css({width : o.width});
		}
		if (o.height > -1) {
			this.element.css({height : o.height});
		}
		// ע,Ҫȵ_addContent(),ٵ_addHeader()
		this._addContent();
		this._addHeader();
		this._addBorder();
		if (o.closed == true) {
			this.doClose();
		}
		if (o.dosize == true) {
			this.doResize();
		}
	},
	_addBorder : function() {
		if (this.options.border == true){
			this.element.find('>div.fr-panel-header').removeClass('fr-panel-header-noborder');
			this.element.find('>div.fr-panel-body').removeClass('fr-panel-body-noborder');
		} else {
			this.element.find('div.fr-panel-header').addClass('fr-panel-header-noborder');
			this.element.find('div.fr-panel-body').addClass('fr-panel-body-noborder');
		}
	},
	/**
	 * autoScroll:ǷʾpanelݵĹ
	 * url:ݼеַ
	 * html:htmlǩ
	 * text:ͨı
	 * url,htmltextݻȡʽֻѡһ
	 */
	_addContent : function() {
		var opts = this.options;
		// ȸpanelcontentһʶ
		this.element.wrapInner('<div class="fr-panel-body"></div>'); 
		var panelBody = $("div.fr-panel-body", this.element);
		if (opts.autoScroll == false) {
			panelBody.css({overflow : "hidden"});
		}
		if (opts.url) {
			this._loadContent(panelBody);
		} else if (opts.widget) {
			panelBody.html(opts.widget.element);
		} else if (opts.html) {
			panelBody.html(opts.html);
		} else if (opts.text) {
			panelBody.text(opts.text);
		}
	},
	_loadContent : function(ct) {
		var opts = this.options;
		opts.isLoaded = false;
		ct.html($('<div class="fr-panel-loading"></div>').html("loading..."));
		$.ajax({
				url : opts.url,
				type : "POST",
				complete : function(res, status) {
					var ht = res.responseText;
					ct.html(ht);
					opts.isLoaded = true;
				}
		});
	},
	/**
	 * title : 
	 * tools  ԶĹ
	 * closable : Ƿɹر
	 * maximizable  Ƿ
	 * minimizable ǷС
	 * collapsibleǷչ
	 */
	_addHeader : function() {
		var self = this;
		var opts = this.options;
		if (opts.title) {
			var header = $('<div class="fr-panel-header"><div class="fr-panel-title">'+opts.title+'</div></div>').prependTo(this.element);
			if (opts.iconCls){
				$('.fr-panel-title', this.element).addClass('fr-panel-with-icon');
				$('<div class="fr-panel-icon"></div>').addClass(opts.iconCls).appendTo(header);
			}
			var tool = $('<div class="fr-panel-tool"></div>').appendTo(header);
			if (opts.closable){
				$('<div class="fr-panel-tool-close"></div>').appendTo(tool).bind('click', onClose);
			}
			if (opts.maximizable){
				$('<div class="fr-panel-tool-max"></div>').appendTo(tool).bind('click', onMax);
			}
			if (opts.minimizable){
				$('<div class="fr-panel-tool-min"></div>').appendTo(tool).bind('click', onMin);
			}
			if (opts.collapsible){
				$('<div class="fr-panel-tool-collapse"></div>').appendTo(tool).bind('click', onToggle);
			}
			if (opts.tools){
				for(var i=opts.tools.length-1; i>=0; i--){
					var t = $('<div></div>').addClass(opts.tools[i].iconCls).appendTo(tool);
					if (opts.tools[i].handler){
						t.bind('click', eval(opts.tools[i].handler));
					}
				}
			}
			tool.find('div').hover(
				function(){$(this).addClass('panel-tool-over');},
				function(){$(this).removeClass('panel-tool-over');}
			);
			this.element.find('>div.fr-panel-body').removeClass('fr-panel-body-noheader');
		} else {
			this.element.find('>div.fr-panel-body').addClass('fr-panel-body-noheader');
		}
		function onToggle(){
			if ($(this).hasClass('fr-panel-tool-expand')){
				self.doExpand();
			} else {
				self.doCollapse();
			}
			return false;
		}
		
		function onMin(){
			self.doMinimize();
			return false;
		}
		
		function onMax(){
			if ($(this).hasClass('fr-panel-tool-restore')){
				self.doRestore();
			} else {
				self.doMaximize();
			}
			return false;
		}
		
		function onClose(){
			self.doClose();
			return false;
		}
	},
	doOpen : function() {
		this.element.show();
		this.options.closed = false;
		if ($.isFunction(this.options.onOpen)) {
			this.options.onOpen.call(this);
		}
		if (this.options.maximized == true) this.doMaximize();
		if (this.options.minimized == true) this.doMinimize();
		if (this.options.collapsed == true) this.doCollapse();
	},
	doClose : function() {
		this.element.hide();
		this.options.closed = true;
		if ($.isFunction(this.options.onClose)) {
			this.options.onClose.call(this);
		}
	},
	doCollapse : function() {
		var opts = this.options;
		var body = this.element.find('>div.fr-panel-body');
		var tool = this.element.find('>div.fr-panel-header .fr-panel-tool-collapse');		
		if (tool.hasClass('fr-panel-tool-expand')) return;
		body.stop(true, true);
		tool.addClass('fr-panel-tool-expand');
		body.slideUp('normal', function(){
				opts.collapsed = true;				
		});
	},
	doExpand : function() {
		var opts = this.options;
		var self = this;
		var body = this.element.find('>div.fr-panel-body');
		var tool = this.element.find('>div.fr-panel-header .fr-panel-tool-collapse');	
		if (!tool.hasClass('fr-panel-tool-expand')) return;
		body.stop(true, true);
		tool.removeClass('fr-panel-tool-expand');
		body.slideDown('normal', function(){
				opts.collapsed = false;
				if (opts.isLoaded == false) {
					self.loadData();
				}
		});
	},
	doMove : function(give) {
		var opts = this.options;
		if (give){
			if (give.left != null) opts.left = give.left;
			if (give.top != null) opts.top = give.top;
		}
		this.element.css({
			left: opts.left,
			top: opts.top
		});
		if ($.isFunction(opts.onMove)) {
			opts.onMove.apply(this, [opts.left, opts.top]);
		}				
	},
	doMaximize : function() {
		var opts = this.options;
		var tool = this.element.find('>div.fr-panel-header .fr-panel-tool-max');		
		if (tool.hasClass('fr-panel-tool-restore')) return;		
		tool.addClass('fr-panel-tool-restore');
		this.options.original = {
			width: opts.width,
			height: opts.height,
			left: opts.left,
			top: opts.top
		};
		opts.left = 0;
		opts.top = 0;
		opts.fit = true;
		this.doResize();
		opts.minimized = false;
		opts.maximized = true;
		if ($.isFunction(opts.onMaximize)) {
			opts.onMaximize.call(this);
		}
	},
	doMinimize : function() {
		var opts = this.options;
		this.element.hide();
		opts.minimized = true;
		opts.maximized = false;
		if ($.isFunction(opts.onMinimize)) {
			opts.onMinimize.call(this);
		}
	},
	doRestore : function() {
		var opts = this.options;
		var tool = this.element.find('>div.fr-panel-header .fr-panel-tool-max');	
		if (!tool.hasClass('fr-panel-tool-restore')) return;		
		this.element.show();
		tool.removeClass('fr-panel-tool-restore');
		var original = this.options.original;
		opts.width = original.width;
		opts.height = original.height;
		opts.left = original.left;
		opts.top = original.top;
		opts.fit = original.fit;
		this.doResize();
		opts.minimized = false;
		opts.maximized = false;
		if ($.isFunction(opts.onRestore)) {
			opts.onRestore.call(this);
		}		
	},
	doResize : function(give) {
		var opts = this.options;
		var panel = this.element;
		var pheader = panel.find('>div.fr-panel-header');
		var pbody = panel.find('>div.fr-panel-body');
		// иĳߴ,ôʹøĳߴС
		if (give){
			if (give.width) opts.width = give.width;
			if (give.height) opts.height = give.height;
			if (give.left != null) opts.left = give.left;
			if (give.top != null) opts.top = give.top;
		}
		// ӦС,ô͸ݸԪصĴСȷpanelĴС
		if (opts.fit == true) {
			var p = panel.parent();
			opts.width = p.width();
			opts.height = p.height();
		}
		this.element.css({left: opts.left, top: opts.top});
		if (opts.cls) {
			panel.addClass(opts.cls);
		}
		if (opts.headerCls) {
			pheader.addClass(opts.headerCls);
		}
		if (opts.bodyCls) {
			pbody.addClass(opts.bodyCls);
		}
		if (!isNaN(opts.width)){
			if ($.boxModel == true){
				panel.width(opts.width - (panel.outerWidth() - panel.width()));
				pheader.width(panel.width() - (pheader.outerWidth() - pheader.width()));
				pbody.width(panel.width() - (pbody.outerWidth() - pbody.width()));
			} else {
				panel.width(opts.width);
				pheader.width(panel.width());
				pbody.width(panel.width());
			}
		} else {
			panel.width('auto');
			pbody.width('auto');
		}
		if (!isNaN(opts.height)){
			if ($.boxModel == true){
				panel.height(opts.height - (panel.outerHeight() - panel.height()));
				pbody.height(panel.height() - pheader.outerHeight() - (pbody.outerHeight() - pbody.height()));
			} else {
				panel.height(opts.height);
				pbody.height(panel.height() - pheader.outerHeight());
			}
		} else {
			pbody.height('auto');
		}
		panel.css('height', null);
		
		if ($.isFunction(opts.onResize)) {
			opts.onResize.apply(this, [opts.width, opts.height]);
		}
		if (opts.widget) {
			opts.widget.doResize({width : opts.width, height : opts.height});			
		}
		// panelresize¼
		panel.find('>div.fr-panel-body>div').triggerHandler('_resize');
	}
})
// FR.Panel .end

// FR.Button .start
/**
 * text : ť
 * iconCls : ťͼʽ
 * iconSrc : ťͼλ
 * plain : Ƿƽ״̬
 * width : 
 * height : ߶
 * handler ¼
 */
$.shortcut("button", "FR.Button");
FR.Button = FR.extend(FR.Widget, {
	type : "button",	
	_init : function() {
		FR.Button.superclass._init.apply(this, arguments);
		 var o = this.options = $.extend({
            baseCls : 'fr-form-field fr-form-btn',
            plain : false,
            width : 80,
            height : 24
        }, this.options);
		this.buttonComp = $("<a href='#'></a>").addClass(o.baseCls).appendTo(this.element);
		if (o.text) {
			this.buttonComp.append(
						'<span class="fr-form-btn-left">' +
						'<span class="fr-form-btn-text">' + 
						o.text +
						'</span>' +
						'</span>'
			);
			var cc = $('.fr-form-btn-text', this.buttonComp);			
			if (o.iconCls) {
				cc.addClass(o.iconCls).css('padding-left', '20px');
			}
		} else {
			this.buttonComp.append(
						'<span class="fr-form-btn-left">' +
						'<span class="fr-form-btn-text">' +
						'<span class="fr-form-btn-empty">' +
						'</span>' +
						'</span>' +
						'</span>'
			);
			if (o.iconCls) {
				$('.fr-form-btn-empty', this.buttonComp).addClass(o.iconCls);
			}	
		}
		if (o.plain) {
			this.plain(true);
		}
		if (o.width > -1) {
			this.element.css({width : o.width});
		}
		if (o.height > -1) {
			this.element.css({height : o.height});
		}
		var self = this;
		this.buttonComp.click(function(e) {
			self.fireEvent(FR.Events.CLICK, e);
		})
		if ($.isFunction(o.handler)) {
			this.on(FR.Events.CLICK, o.handler.createDelegate(o.scope || this));
		}		
		this.fireEvent(FR.Events.AFTERINIT);
	},
	plain : function(toPlain) {
		if (toPlain == true) {
			this.options.plain = true;
			this.buttonComp.addClass("fr-form-btn-plain");
		} else if (toPlain == false) {
			this.options.plain == false;
			this.buttonComp.removeClass("fr-form-btn-plain");
		} else {
			return this.options.plain;
		}
	}
})
// FR.Button .end

// FR.BaseEditor
FR.BaseEditor = FR.extend(FR.Widget, {
	_init : function() {
		FR.BaseEditor.superclass._init.apply(this, arguments);
		var o = this.options = $.extend({
			value : ""
		}, this.options);
		if (o.value) {
			this.setValue(o.value);
		}
	},
	getValue : function() {
		
	},
	setValue : function(value) {
		
	}
})


//FR.IframeEditor.start
/**
 * ҳؼ,ÿؼڲһiframe
 * src : iframeָĵַ
 * width : 
 * height : ߶
 */
$.widget("FR.IframeEditor");$.shortcut("iframe", "$.FR.IframeEditor")
FR.extend($.FR.IframeEditor, $.FR.BaseEditor, {
    _init : function() {
        $.FR.IframeEditor.superclass._init.apply(this, arguments);
        //ؼ
        var o = this.options = $.extend({
            src : "",// iframesrc
            //james-1ʾĬ
            width : 120,     //ؼĿ
            height : 19     //ؼĸ߶
        }, this.options);
        this.$editorComponent = this.element;
        o.iframeName = o.fieldName || "iframe";   
        this.$iframe = $("<iframe id=" + o.iframeName + " name=" + o.iframeName + ">")
        .attr({frameborder : 0, scrolling : "no", width : o.width, height : o.height}).appendTo(this.$editorComponent);
        // richer:iframeȥıiframeָĵַ
        this._getParams(o);
    },
    _getParams : function(o) {
    	var self = this;
    	// richer:iframeҲҪ֧,Ҫȥȡһ²ֵ
    	$.ajax({
        	type : 'POST',
		    url : o.widgetUrl,
		    complete : function(res, status) {
		    	var text = res.responseText;
		    	self._loadIframeByPost(text);
		    }
    	});
    },
    _loadIframeByPost : function(text) {
    	var o = this.options;
    	var paras = FR.jsonDecode(text);
    	if (this.$iframeForm) {
    		this.$iframeForm.html("");
    	} else {
    		this.$iframeForm = ($("<div>").appendTo($(document.body))).css({"display":"none", "position":"absolute"});
    	}
    	// עд$("<form></form>"),IE޷ύ
    	var submitForm = $("<form method='post' target='" + o.iframeName + "' action='" + o.src + "'></form>").appendTo(this.$iframeForm); 
    	var html = "";
    	for (var i = 0, len = paras.length; i < len; i ++) {
    		var p = paras[i];
    		$.each(p, function(name, value) {
    			html += "<input type='hidden' name='" +  name + "' value='" + value + "'/>";
    		})
    	}
    	submitForm.html(html);
    	submitForm.submit(); 
    },
    
    getValue : function(){
        return this.options.src;
    },
    setValue : function(src){
    	this.options.src = src;
        this.$iframe.attr("src", src);
    } 
})

// FR.BaseTextEditor .start
/**
 * ı༭зֵĿؼ
 * editable : ǷԱ༭ñ༭еı
 * width : 
 * height  ߶
 * style : ʽ, "display:none;vertical-align:center" || {display:'none', vertical-align:'center'}
 */
FR.BaseTextEditor = FR.extend(FR.BaseEditor, {
	_init : function() {
		FR.BaseTextEditor.superclass._init.apply(this, arguments);
		var o = this.options = $.extend({
			editable : true,
			value : "",
			width : 120,
			height : 21,
			style : ""
		}, this.options);
		this.editComp = $("<input type='text'/>").appendTo(this.element);
		  /*
         * alex:ieĻ,߶ȼ2,Ȼie±߿ᱻӸǵ,1,
         * bug 6528
         */
        if ($.browser.msie && this.options.height) {
        	this.options.height = this.options.height - 2;
        }
		if (o.width > -1) {
			this.editComp.css({width : o.width});
		}
		if (o.height > -1) {
			this.editComp.css({height : o.height});
		}
		if (o.editable !== true) {
        	this.editComp.attr('readonly', true);
        }
        if (o.disabled == true) {
        	this.editComp.attr("disabled", "disabled");
        }
        if (o.watermark) {
        	FR.$import('${servletURL}?op=resource&resource=/com/fr/web/core/js/jquery.watermark.js', 'js');
        	this.editComp.watermark(o.watermark);
        }
         // alex:styleΪ
        FR.applyStyles(this.editComp, o.style);
        var self = this;
        this.editComp.focus(function() {
        	// TODO ȡӦüһ־
        }).blur(function() {
        	// TODO ʧȥʱ,autoVerifyΪtrueĻԶУ
        	if (o.autoVerify == true) {
        		
        	}
        	// ༭¼Ҳﴥ
        	self.fireEvent(FR.Events.AFTEREDIT, e);
        })
		if (o.value) {
			this.setValue(o.value);
		}
	},
	setValue : function(value) {
    	this.editComp.val(value);    	
    	// alex:ϵֵthis.options.value,жisDirty
    	var oldValue = this.options.value;
    	this.options.value = value;       
    	this.fireEvent(FR.Events.CHANGE, value, oldValue);
    },
    
    getValue : function() {
    	return this.options.value;
    },
    cssFrom : function(dom) {
    	var $dom = $(dom);
		var $comp = this.editComp;
    	$comp.removeClass().addClass($dom.attr("class"));
    	// richer:ʱ༭Ӹͼõ
    	if ($dom.attr("editor").indexOf('"type":"datetime"') > 0){
    		$comp.addClass("dpPicker");
    	}
    	   	  	
		// alex:$domĲstyle
    	$.each(['fontFamily', 'fontVariant', 'fontStyle', 'fontWeight', 'fontSize',
			'paddingTop', 'paddingBottom', 'paddingLeft', 'paddingRight', 'backgroundColor'], function(idx, el) {
    		$comp.css(el, $dom.css(el));
    	})
		if ((/transparent|rgba\(0, 0, 0, 0\)/).test($comp.css('backgroundColor'))) {
			$comp.css('backgroundColor', 'white')
		}
    }
})
// FR.BaseTextEditor .end

// FR.TextEditor .start
/**
 * 
 */
$.shortcut("text", "FR.TextEditor")
FR.TextEditor = FR.extend(FR.BaseTextEditor, {
	type : 'text',
    _init : function() {
        FR.TextEditor.superclass._init.apply(this, arguments);
    },
     isValidate : function(cValue) {
        var allowBlank = this.options.allowBlank != false; // james:ĬΪ

		var minLength = this.options.minLength;

		var value = cValue ? cValue : this.getValue();
		var regex = this.options.regex;
		// richer:жǷΪbug6139
		 if ((!value || value.length <= 0)) {//ֵΪյʱ
            if (allowBlank != false) {//ΪգͷTRUE
            	return true;
            } else {//ΪգǾͼ
            	this.errorMsg = this.options.errorMsg || FR.i18n.NOT_NULL;
            	return false;
            }
        }
		if (regex) {
            if (typeof regex == 'string') {//Stringʱ򣬹һRegExp
                regex = new RegExp(regex);                         
            }
            if (!regex.test(value)) {
            	this.errorMsg = this.options.errorMsg || FR.i18n.Error_Input_Value;
                return false;
            }
        }
             
        return true;
    },
    // richer:ͱ༭isDirtyҪж,ΪֵparserҲ0
    isDirty : function() {
    	if (this.getValue() == 0) {
    		return true;
    	}
    	return !FR.equals(this.options.value, this.getValue()); // Ƚԭʼֵ͵ǰֵ
    }
})
// FR.TextEditor .end

// FR.NumberEditor .start
/**
 * ͱ༭
 */
$.shortcut("number", "FR.NumberEditor")
FR.NumberEditor = FR.extend(FR.TextEditor, {
    _init : function() {
        FR.NumberEditor.superclass._init.apply(this, arguments);

        var o = this.options = $.extend({
            allowDecimals : true,
            allowNegative : true,
            decimalPrecision : -1,
            decimalSeparator : '.'//decimalķָ
            // alex:value:0ΪĬֵ,ᵼBS༭ʱ,д0,isDirty == false,ֵ
        }, this.options);
        var baseChars = '0123456789';

        var allowed = baseChars+'';
        if(o.allowDecimals){
            allowed += '.';
        }
        if(o.allowNegative){
            allowed += "-";
        }
         //b:뷨
        this.editComp.css("ime-mode", "disabled");
        var errorMsg = this.options.errorMsg || FR.i18n.Value_Not_Match;
        this.editComp.keypress(function(e) {
            //james:ǳExt
            var k = e.keyCode;
            if(!$.browser.msie &&
              (FR.isNavKeyPress(e)
                    || FR.isSpecialKey(e)
                    || k == $.ui.keyCode.BACKSPACE
                    || k == $.ui.keyCode.DELETE)){
                return;
            }
            var c = e.charCode || e.keyCode;//jamesIEҪȡkeyCode
            var cc = String.fromCharCode(c);
            if($.browser.msie && (FR.isSpecialKey(e) || !cc)){
	            return;	            
	        }
            
            if(allowed.indexOf(cc) === -1){
            	FR.Msg.alert(FR.i18n.Alert, errorMsg);
            	e.preventDefault();           	
            }
            
            if (this.value.indexOf('.') > -1 && cc == '.') {
            	FR.Msg.alert(FR.i18n.Alert, errorMsg);
            	e.preventDefault();
            }
        });
  	 },
  	 setValue : function(value) {
  	 	// alex:ϵֵthis.options.value,жisDirty
    	var oldValue = this.getValue();       
        value = parseFloat(value);
    	this.editComp.val(
    		isNaN(value) ? '' : String(value).replace(".", this.options.decimalSeparator)
    	);  
    	this.options.value = value;        
    	this.fireEvent(FR.Events.CHANGE, value, oldValue);      
    },
    //jamesֱ༭ķֵûֵͷ''0ͷ0
    //طҪûķǷҪṩõĵط
    getValue : function() {
    	var number = this._fixPrecision(this._parseValue(this.editComp.val()));
        return number;
    },
    /**EXT**/
    _fixPrecision : function(value){
        var nan = isNaN(value);
        if(!this.options.allowDecimals || this.options.decimalPrecision == -1 || nan || !value){
           return nan ? '' : value;
        }
        return parseFloat(parseFloat(value).toFixed(this.options.decimalPrecision));
    },
    /**EXT**/
    _parseValue : function(value){
        value = parseFloat(String(value).replace(this.options.decimalSeparator, "."));
        return isNaN(value) ? '' : value;
    },   
    isValidate : function(cValue) {
        var value = cValue ? cValue : this.editComp.val();     
        // richer:Ϊ
        //b: ȷôû
        if (value == "" || value == null || value == undefined ) {
        	if (this.options.allowBlank != false) {
        		return true;
        	} else {
        		this.errorMsg = this.options.errorMsg || FR.i18n.NOT_NULL;
        		return false;
        	}
        }       
        value = String(value).replace(this.options.decimalSeparator, ".");
        if(isNaN(value)){
            this.errorMsg = this.options.errorMsg || FR.i18n.Value_Must_Be_A_Number;
            return false;
        }
        // ΪС
        if (value.indexOf(this.options.decimalSeparator) > 0) {
        	if (!this.options.allowDecimals ) {
        		this.errorMsg = this.options.errorMsg || FR.i18n.Value_Cannot_Be_Decimal;
        		return false;
        	} else if (this.options.allowDecimals && (value.length - value.indexOf(this.options.decimalSeparator) > this.options.maxDecLength + 1)) {
        		this.errorMsg = this.options.errorMsg || FR.i18n.Value_DecimalNumber_Out;
        		return false;
        	}
        }

        var num = this._parseValue(value);
                // ΪС
        if (num.toString().indexOf(this.options.decimalSeparator) > 0) {
        	if (!this.options.allowDecimals ) {
        		this.errorMsg = this.options.errorMsg || FR.i18n.Value_Cannot_Be_Decimal;
        		return false;
        	} else if (this.options.allowDecimals && (num.toString().length - num.toString().indexOf(this.options.decimalSeparator) > this.options.maxDecLength + 1)) {
        		this.errorMsg = this.options.errorMsg || FR.i18n.Value_DecimalNumber_Out;
        		return false;
        	}
        }
        // Ϊ
        if (!this.options.allowNegative && num < 0){
        	this.errorMsg = this.options.errorMsg || FR.i18n.Value_Cannot_Be_Negative;
        	return false;
        }
        if (this.options.minValue && num < this.options.minValue) {
            this.errorMsg = this.options.errorMsg || FR.i18n.Value_Is_Less_Than_Minimum + this.options.minValue;
            return false;
        }
        if (this.options.maxValue && num > this.options.maxValue) {
            this.errorMsg = this.options.errorMsg || FR.i18n.Value_Is_Larger_Than_Maximum + this.options.maxValue;
            return false;
        }
        return true;
    }
})

// FR.TriggerEditor.start
FR.TriggerEditor = FR.extend(FR.BaseTextEditor, {
	_init : function() {
		FR.TriggerEditor.superclass._init.apply(this, arguments);
		var o = this.options = $.exted({
			iconCls : "fr-form-trigger"
		}, this.options);
		// 17ظtrigger
		this.editComp.wrapAll($('<div>').css({position:'relative', width : o.width})).width(o.width - 17);
		//ȡwrappertriggerӽȥ
		this.$wrapper = this.editComp.parent();
		var triggerFn = this.onTriggerClick.createDelegate(this);
		this.triggerBtn = new FR.Button({
			renderTo : this.$wrapper,
			iconCls : "fr-form-trigger",
			handler : triggerFn
		});
	},
	 onTriggerClick : function() {
    	
    }
})
// FR.TriggerEditor .end

