/*
 * richer:˵
 * 
 * [{type:'menu', text:'edit', onclick:'function(){}', submenu:false},
 *  {type:'menu', text:'file', onclick:'function(){}', submenu:false, sep:false},
 *  {type:'sep'}
 *  ]
 */
;(function($){	
    $.extend({
        frMenu : function(opts){
        	this.$menuRoot = $("<div class='easyui-menu menu'>");
        	this.items = opts.items;
        	this.init();
        	this.minWidth = opts.minWidth || 80;
        	
        	if ($.isArray(this.items)){
        		this.addItems(this.items);
        	}
        	
        	if (this.minWidth && this.minWidth > this.$menuRoot.width()) {
        		this.$menuRoot.width(this.minWidth);
        		this.$menuRoot.children("div").width(this.minWidth - 8);
        	}
        	
        	return this.$menuRoot;
        }
    });
    $.extend($.frMenu, {
    	prototype : {
    		init : function(){
    			var self = this;
    			this.$menuRoot.hover(
    			function(){}, 
    			function(){
    			    self.distroy();
    			});
    			// remove other menus
    			$(".easyui-menu", 'body').remove();
    			
    			this.$menuRoot.appendTo('body');
    		},
    		addItems : function(items){
    			for (var i = 0, len = items.length; i < len; i ++){
    				this.addItem(items[i]);
    			}
    		},
    		addItem : function(menu, $sup){
    			var self = this;
    			var $item = $("<div style='width:80px'>").appendTo(this.$menuRoot);
    			
    			if ($sup){
    				$item.submenu = $item;
    			}
			    // richer:ָ
			    if (menu.type === "sep"){
				   $item.addClass("menu-sep").html("'&nbsp;'");
			    } else {
				   $item.addClass("menu-item")
				   		.each(function(){self.bindMenuItemEvent($(this))})
				   		.click(function(e, item){menu.handler.call(this, e, item); self.distroy();})
				   var $menu_text = $('<div class="menu-text"></div>').html(menu.src).appendTo($item);
				   var text_width = $menu_text.position().left * 2 + $menu_text.width();
				   if (this.minWidth < text_width) {
				   		this.minWidth = text_width;
				   }
				    var icon = menu.iconSrc ? menu.iconSrc.replace("css:", "") : "";
				    // richer:жǷͼ
				    if (icon){
				       $('<div class="menu-icon"></div>').addClass(icon).appendTo($item);
				    }
				// richer:жǷӲ˵
			    if (menu.submenu){
					$('<div class="menu-rightarrow"></div>').appendTo($item);	// has sub menu
					if($.isArray(menu.submenu)){
						this.addItems(menu.submenu, $item);
					}
				}
				if ($.boxModel == true){
					var height = $item.height() || 22;
					$item.height(height - ($item.outerHeight() - $item.height()));
				}
			 }
			//$item.hide();
    		},
    		bindMenuItemEvent : function($item){
    			$item.hover(
    			   function(){
    			   	  $item.siblings().each(function(){
						if (this.submenu){
							hideMenu(this.submenu);
						}
						$(this).removeClass('menu-active');
					  });
    				  $item.addClass('menu-active');
    				  var submenu = $item[0].submenu;
					  if (submenu){
						var left = item.offset().left + item.outerWidth() - 2;
						if (left + submenu.outerWidth() > $(window).width()){
							left = item.offset().left - submenu.outerWidth() + 2;
						}
						showMenu(submenu, {
							left: left,
							top:item.offset().top - 3
						});
					  }
    			   },
    			   function(e){
    				  $item.removeClass('menu-active');
					  var submenu = $item[0].submenu;
					  if (submenu){
						 if (e.pageX>=parseInt(submenu.css('left'))){
							$item.addClass('menu-active');
						 } else {
							 hideMenu(submenu);
						 }
						
					  } else {
						  $item.removeClass('menu-active');
				      }
    			 });
    		},
    		distroy : function(){
    			this.$menuRoot.remove();
    		}
    	}
    });
	
})(jQuery);