
(function() {
	var kv = {};  // alex:(༭,text)ֵ(Ҳһַ,$.FR.TextEditor)
	$.shortcut = function(xtype, className) {
		kv[xtype] = className;
	};
	// widget
	FR.createWidget = function(config) {
		var xtype = config.xtype.toLowerCase();
		var className = kv[xtype];
		return new Function("config", "return new " + className + "(config);")(config);
	};
})();

FR.widget = {
   opts : {
   		zIndex : 8000,
   		num : 0   		
   }
};
// FR.OB .start
FR.OB = function(config){
   this.options = $.extend({
   	
   }, config);
   this._init();
}
FR.OB.prototype = {
	type : "ob",
	
	_init : function() {
		var self = this;
		if (this.options.listeners != null) {
			$.each(this.options.listeners, function(i, lis) {
				(lis.target ? lis.target : self)[lis.once ? 'once' : 'on'](lis.eventName, lis.action.createDelegate(self))
			})
			delete this.options.listeners;
		}
	},
	_getEvents : function() {
		if (!FR.isArray(this.events)) {
			this.events = []
		}
		
		return this.events;
	},
	fireEvent : function() {
		var eventName = arguments[0].toLowerCase();
    	var fns = this._getEvents()[eventName];
    	if (FR.isArray(fns)) {
    		var args = Array.prototype.slice.call(arguments, 1)
    		for (var i = 0; i < fns.length; i++) {
    			if (fns[i].apply(this, args) === false) {
    				return false;
    			}
    		}
    	}  	
    	return true;
	},
	on : function(eventName, fn) {
		eventName = eventName.toLowerCase();
    	var fns = this._getEvents()[eventName];
    	if (!FR.isArray(fns)) {
    		fns = [];
    		this._getEvents()[eventName] = fns;
    	}
    	fns.push(fn);
	},
	once : function(eventName, fn) {
		var proxy = function() {
    		fn.apply(this, arguments);
    		this.un(eventName, proxy);
    	}
    	this.on(eventName, proxy);
	},
	un : function(eventName, fn) {
		// alex:fnnull,ǰeventNameзun
    	if (fn == null) {
    		delete this._getEvents()[eventName];
    	} else {
	    	var fns = this._getEvents()[eventName];
	    	if (FR.isArray(fns)) {
	    		/*
	    		 * alex:ÿķʽ,spliceֱɾfnsеԪ
	    		 * ΪfireEventʱ,Ӧķonceȥ,ִ֮fnsĳ,ᵼЩfn޷ִ
	    		 * ķʽonceһfn,onһfn,ôfireEventᵼonfnûִ
	    		 */
	    		var newFns = [];
	    		$.each(fns, function(idx, ifn) {
	    			if(ifn != fn) {
	    				newFns.push(ifn);
	    			}
	    		})
	    		this._getEvents()[eventName] = newFns;
	    	} 
    	}
	},
	purgeListeners : function() {
		// alex:events
    	this.events = [];
	}
}
FR.OB.capture = function(o, fn, scope) {
	o.fireEvent = o.fireEvent.createInterceptor(fn, scope);
}
// alex:ͷ¼Ĳ׽
FR.OB.releaseCapture = function(o) {
	o.fireEvent = FR.OB.prototype.fireEvent;
}
// FR.OB end


// FR.Widget .start
/**
 * disbled : 
 * invisibe : ɼ
 */
FR.Widget = FR.extend(FR.OB, {
	type : "widget",	
	_init : function() {
		FR.Widget.superclass._init.apply(this, arguments);
		var o = this.options = $.extend({
			widgetName : "",
			disabled : false,
			invisible : false
		}, this.options);
		this.element = $("<div></div>");
		if (o.widgetName) {
			this.element.attr({widgetName : o.widgetName});
		}
		if (o.renderTo) {
			this.render(o.renderTo);
		}
	},
	render : function(container, position) {
		var ct;
		if (typeof container == "string") {
			ct = container == "body" ? $("body") : $("#" + container);
			
		} else if (typeof container == "object"){
			ct = $(container);
		} else {
			ct = $("body");
		}	
		ct.append(this.element);
	},
	doResize : function(give) {
		var opts = this.options;
		var cc = this.element;
		if (give){
			if (give.width) opts.width = give.width;
			if (give.height) opts.height = give.height;
			if (give.left != null) opts.left = give.left;
			if (give.top != null) opts.top = give.top;
		}
		if (opts.fit == true) {
			var p = cc.parent();
			var p_width = cc.width();
			var p_height = cc.height();
			opts.width = p_width;
			opts.height = p_height;			
		}
	},
	distroy : function() {
		this.element.remove();
		if ($.browser.msie){
			this.element.outerHTML = '';
		}
		if ($.isFunction(this.options.onDistroy)) {
			this.options.onDistroy.call(this);
		}
	},
	isEnabled : function() {
		return !this.options.disabled;
	},
	isVisible : function() {
		return !this.options.invisible;
	},
	// TODO disableʵʱû뵽ϲ,
	setEnable : function() {
		
	},
	setVisible : function(arg) {
		// ֻвΪtrue/falseʱзӦ,һɲκθı
		if (arg == true) {
			this.options.invisible = false;
			this.element.show();
		} else if (arg == false) {
			this.options.invisible = true;
			this.element.hide();
		}		
	}
})
// FR.Widget .end

/**
 * richer:,Ӧڷ˵com.fr.report.web.ui.container.Container
 */
FR.Container = FR.extend(FR.Widget, {
 	_init : function() {
		FR.Container.superclass._init.apply(this, arguments);
	}
})

// FR.Panel .start
FR.Panel = FR.extend(FR.Container, {
	_init : function() {
		FR.Panel.superclass._init.apply(this, arguments);
		var o = this.options = $.extend({
			baseCls : "fr-panel",// ʽ
			toolPosition : "right",// right or left
			fit : false,// ԶӦС,
			dosize : false,
			border : true, // ߿
			closable : false,
			maximizable : false,// 
			minimizable : false,// С
			collapsible : true, // 
			autoScroll : true, //ݵĶԶʾ
			closed : false,
			width : "auto",
			height : "auto"
		}, this.options);
		this.element.addClass(o.baseCls);
		if (o.width > -1) {
			this.element.css({width : o.width});
		}
		if (o.height > -1) {
			this.element.css({height : o.height});
		}
		// ע,Ҫȵ_addContent(),ٵ_addHeader()
		this._addContent();
		this._addHeader();
		this._addBorder();
		if (o.closed == true) {
			this.doClose();
		}
		if (o.dosize == true) {
			this.doResize({width : o.width, height : o.height});
		}
	},
	_addBorder : function() {
		if (this.options.border == true){
			this.element.find('>div.fr-panel-header').removeClass('fr-panel-header-noborder');
			this.element.find('>div.fr-panel-body').removeClass('fr-panel-body-noborder');
		} else {
			this.element.find('div.fr-panel-header').addClass('fr-panel-header-noborder');
			this.element.find('div.fr-panel-body').addClass('fr-panel-body-noborder');
		}
	},
	/**
	 * autoScroll:ǷʾpanelݵĹ
	 * url:ݼеַ
	 * html:htmlǩ
	 * text:ͨı
	 * url,htmltextݻȡʽֻѡһ
	 */
	_addContent : function() {
		var opts = this.options;
		// ȸpanelcontentһʶ
		this.element.wrapInner('<div class="fr-panel-body"></div>'); 
		var panelBody = $("div.fr-panel-body", this.element);
		if (opts.autoScroll == false) {
			panelBody.css({overflow : "hidden"});
		}
		if (opts.url) {
			this._loadContent(ct);
		} else if (opts.widget) {
			panelBody.html(opts.widget.element);
		} else if (opts.html) {
			panelBody.html(opts.html);
		} else if (opts.text) {
			panelBody.text(opts.text);
		}
	},
	_loadContent : function(url, ct) {
		var opts = this.options;
		opts.isLoaded = false;
		ct.html($('<div class="fr-panel-loading"></div>').html("loading..."));
		$.ajax({
				url : opts.url,
				type : "POST",
				complete : function(res, status) {
					var ht = res.responseText;
					ct.html(ht);
					opts.isLoaded = true;
				}
		});
	},
	/**
	 * title : 
	 * tools  ԶĹ
	 * closable : Ƿɹر
	 * maximizable  Ƿ
	 * minimizable ǷС
	 * collapsibleǷչ
	 */
	_addHeader : function() {
		var self = this;
		var opts = this.options;
		if (opts.title) {
			var header = $('<div class="fr-panel-header"><div class="fr-panel-title">'+opts.title+'</div></div>').prependTo(this.element);
			if (opts.iconCls){
				$('.fr-panel-title', this.element).addClass('fr-panel-with-icon');
				$('<div class="fr-panel-icon"></div>').addClass(opts.iconCls).appendTo(header);
			}
			var tool = $('<div class="fr-panel-tool fr-panel-tool-' + opts.toolPosition + '"></div>').appendTo(header);
			if (opts.closable){
				$('<div class="fr-panel-tool-close"></div>').appendTo(tool).bind('click', onClose);
			}
			if (opts.maximizable){
				$('<div class="fr-panel-tool-max"></div>').appendTo(tool).bind('click', onMax);
			}
			if (opts.minimizable){
				$('<div class="fr-panel-tool-min"></div>').appendTo(tool).bind('click', onMin);
			}
			if (opts.collapsible){
				$('<div class="fr-panel-tool-collapse"></div>').appendTo(tool).bind('click', onToggle);
			}
			if (opts.tools){
				for(var i=opts.tools.length-1; i>=0; i--){
					var t = $('<div></div>').addClass(opts.tools[i].iconCls).appendTo(tool);
					if (opts.tools[i].handler){
						t.bind('click', eval(opts.tools[i].handler));
					}
				}
			}
			tool.find('div').hover(
				function(){$(this).addClass('panel-tool-over');},
				function(){$(this).removeClass('panel-tool-over');}
			);
			this.element.find('>div.fr-panel-body').removeClass('fr-panel-body-noheader');
		} else {
			this.element.find('>div.fr-panel-body').addClass('fr-panel-body-noheader');
		}
		function onToggle(){
			if ($(this).hasClass('fr-panel-tool-expand')){
				self.doExpand();
			} else {
				self.doCollapse();
			}
			return false;
		}
		
		function onMin(){
			self.doMinimize();
			return false;
		}
		
		function onMax(){
			if ($(this).hasClass('fr-panel-tool-restore')){
				self.doRestore();
			} else {
				self.doMaximize();
			}
			return false;
		}
		
		function onClose(){
			self.doClose();
			return false;
		}
	},
	doOpen : function() {
		this.element.show();
		this.options.closed = false;
		if ($.isFunction(this.options.onOpen)) {
			this.options.onOpen.call(this);
		}
		if (this.options.maximized == true) this.doMaximize();
		if (this.options.minimized == true) this.doMinimize();
		if (this.options.collapsed == true) this.doCollapse();
	},
	doClose : function() {
		this.element.hide();
		this.options.closed = true;
		if ($.isFunction(this.options.onClose)) {
			this.options.onClose.call(this);
		}
	},
	doCollapse : function() {
		var opts = this.options;
		var body = this.element.find('>div.fr-panel-body');
		var tool = this.element.find('>div.fr-panel-header .fr-panel-tool-collapse');		
		if (tool.hasClass('fr-panel-tool-expand')) return;
		body.stop(true, true);
		tool.addClass('fr-panel-tool-expand');
		body.slideUp('normal', function(){
				opts.collapsed = true;				
		});
	},
	doExpand : function() {
		var opts = this.options;
		var self = this;
		var body = this.element.find('>div.fr-panel-body');
		var tool = this.element.find('>div.fr-panel-header .fr-panel-tool-collapse');	
		if (!tool.hasClass('fr-panel-tool-expand')) return;
		body.stop(true, true);
		tool.removeClass('fr-panel-tool-expand');
		body.slideDown('normal', function(){
				opts.collapsed = false;
				if (opts.isLoaded == false) {
					self.loadData();
				}
		});
	},
	doMove : function(give) {
		var opts = this.options;
		if (give){
			if (give.left != null) opts.left = give.left;
			if (give.top != null) opts.top = give.top;
		}
		this.element.css({
			left: opts.left,
			top: opts.top
		});
		if ($.isFunction(opts.onMove)) {
			opts.onMove.apply(this, [opts.left, opts.top]);
		}				
	},
	doMaximize : function() {
		var opts = this.options;
		var tool = this.element.find('>div.fr-panel-header .fr-panel-tool-max');		
		if (tool.hasClass('fr-panel-tool-restore')) return;		
		tool.addClass('fr-panel-tool-restore');
		this.options.original = {
			width: opts.width,
			height: opts.height,
			left: opts.left,
			top: opts.top
		};
		opts.left = 0;
		opts.top = 0;
		opts.fit = true;
		this.doResize();
		opts.minimized = false;
		opts.maximized = true;
		if ($.isFunction(opts.onMaximize)) {
			opts.onMaximize.call(this);
		}
	},
	doMinimize : function() {
		var opts = this.options;
		this.element.hide();
		opts.minimized = true;
		opts.maximized = false;
		if ($.isFunction(opts.onMinimize)) {
			opts.onMinimize.call(this);
		}
	},
	doRestore : function() {
		var opts = this.options;
		var tool = this.element.find('>div.fr-panel-header .fr-panel-tool-max');	
		if (!tool.hasClass('fr-panel-tool-restore')) return;		
		this.element.show();
		tool.removeClass('fr-panel-tool-restore');
		var original = this.options.original;
		opts.width = original.width;
		opts.height = original.height;
		opts.left = original.left;
		opts.top = original.top;
		opts.fit = original.fit;
		this.doResize();
		opts.minimized = false;
		opts.maximized = false;
		if ($.isFunction(opts.onRestore)) {
			opts.onRestore.call(this);
		}		
	},
	doResize : function(give) {
		var opts = this.options;
		var panel = this.element;
		var pheader = panel.find('>div.fr-panel-header');
		var pbody = panel.find('>div.fr-panel-body');
		// иĳߴ,ôʹøĳߴС
		if (give){
			if (give.width) opts.width = give.width;
			if (give.height) opts.height = give.height;
			if (give.left != null) opts.left = give.left;
			if (give.top != null) opts.top = give.top;
		}
		// ӦС,ô͸ݸԪصĴСȷpanelĴС
		if (opts.fit == true) {
			var p = panel.parent();
			opts.width = p.width();
			opts.height = p.height();
		}
		this.element.css({left: opts.left, top: opts.top});
		if (opts.cls) {
			panel.addClass(opts.cls);
		}
		if (opts.headerCls) {
			pheader.addClass(opts.headerCls);
		}
		if (opts.bodyCls) {
			pbody.addClass(opts.bodyCls);
		}
		if (!isNaN(opts.width)){
			if ($.boxModel == true){
				panel.width(opts.width - (panel.outerWidth() - panel.width()));
				pheader.width(panel.width() - (pheader.outerWidth() - pheader.width()));
				pbody.width(panel.width() - (pbody.outerWidth() - pbody.width()));
			} else {
				panel.width(opts.width);
				pheader.width(panel.width());
				pbody.width(panel.width());
			}
		} else {
			panel.width('auto');
			pbody.width('auto');
		}
		if (!isNaN(opts.height)){
			if ($.boxModel == true){
				panel.height(opts.height - (panel.outerHeight() - panel.height()));
				pbody.height(panel.height() - pheader.outerHeight() - (pbody.outerHeight() - pbody.height()));
			} else {
				panel.height(opts.height);
				pbody.height(panel.height() - pheader.outerHeight());
			}
		} else {
			pbody.height('auto');
		}
		panel.css('height', null);
		
		if ($.isFunction(opts.onResize)) {
			opts.onResize.apply(this, [opts.width, opts.height]);
		}
		if (opts.widget) {
			opts.widget.doResize({width : opts.width, height : opts.height});			
		}
		// panelresize¼
		panel.find('>div.fr-panel-body>div').triggerHandler('_resize');
	}
})
// FR.Panel .end

// FR.Window .start

$.shortcut("window", "FR.Window");
FR.Window = FR.extend(FR.Container, {
	_init : function() {
		FR.Window.superclass._init.apply(this, arguments);
		var o = this.options = $.extend({
			baseCls : "fr-window",
			title : "Window",
			shadow: true,
			modal: false,
			closable: true,
			collapsible : false,
			closed : true,
			width : 300,
			height : 200
		}, this.options);
		var self = this;
		var win = new FR.Panel($.extend(o, {
			renderTo : "body",
			width : o.width,
			height : o.height,
			fit : false,
			border : false,
			html : "<p>dwdwdwd</p>",
			dosize : true,
			cls : o.baseCls,
			headerCls: 'fr-window-header',
			bodyCls: 'fr-window-body',
			onClose : function() {
				if (self.shadow) self.shadow.hide();
				if (self.mask) self.mask.hide();
			},
			onOpen : function() {
				if (self.shadow) {
					self.shadow.css({
						display:'block',
						left:o.left,
						top: o.top
					});
				}
				if (self.mask) self.mask.show();				
			},
			onResize : function(width, heigh) {},
			onMove: function(left, top){
				
			}
		}));
		this.element = win.element;
		if (this.mask) {
			this.mask.remove();
		}
		if (o.modal == true){
			this.mask = $('<div class="fr-window-mask"></div>').appendTo('body');
			this.mask.css({
				zIndex: FR.widget.opts.zIndex++,
				width: this._getPageArea().width,
			    height: this._getPageArea().height,
				display: 'none'
			});
		}
		if (this.shadow) this.shadow.remove();
		if (o.shadow == true){
			this.shadow = $('<div class="fr-window-shadow"></div>').insertAfter(this.element);
			this.shadow.css({
				zIndex: FR.widget.opts.zIndex++,
				display: 'none'
			});
		}
		this.element.css({zIndex : FR.widget.opts.zIndex++});
		if (win.options.left == null){
			var width = win.options.width;
			if (isNaN(width)){
				width = this.element.outerWidth();
			}
			win.options.left = ($(window).width() - width) / 2 + $(document).scrollLeft();
		}
		if (win.options.top == null){
			var height = win.options.height;
			if (isNaN(height)){
				height = this.element.outerHeight();
			}
			win.options.top = ($(window).height() - height) / 2 + $(document).scrollTop();
		}
		win.doMove();
		if (o.closed == false) {
			win.doOpen();
		}
		// drag and resize
		this.element.draggable({
			handle: '>div.fr-panel-header',
			disabled: o.draggable == false,
			start : function(e) {
//				if (self.mask) self.mask.css('z-index', FR.widget.opts.zIndex++);
//				if (self.shadow) self.shadow.css('z-index', FR.widget.opts.zIndex++);
//				self.element.css('z-index', FR.widget.opts.zIndex++);
//				
//				self.proxy = $('<div class="fr-window-proxy"></div>').insertAfter(this.element);
//				self.proxy.css({
//					display:'none',
//					zIndex: FR.widget.opts.zIndex++,
//					left: e.data.left,
//					top: e.data.top,
//					width: ($.boxModel==true ? (self.element.outerWidth()-(self.proxy.outerWidth()-self.proxy.width())) : self.element.outerWidth()),
//					height: ($.boxModel==true ? (self.element.outerHeight()-(self.proxy.outerHeight()-self.proxy.height())) : self.element.outerHeight())
//				});
//				setTimeout(function(){
//					self.proxy.show();
//				}, 500);
				//window.console(e.data);
			},
			drag : function(e) {
//				self.proxy.css({
//					display:'block',
//					left: e.data.left,
//					top: e.data.top
//				});
//				return false;
			},
			stop : function(e) {
//				win.options.left = e.data.left;
//				win.options.top = e.data.top;
//				win.doMove();
//				self.proxy.remove();
			}
		});
		this.element.resizable({
			disabled: o.resizable == false,
			start : function(e) {
				
			},
			resize : function(e) {
				
			},
			stop : function(e) {
				
			}
		});
	},
	 _getPageArea : function() {
		if (document.compatMode == 'BackCompat') {
			return {
				width: Math.max(document.body.scrollWidth, document.body.clientWidth),
				height: Math.max(document.body.scrollHeight, document.body.clientHeight)
			}
		} else {
			return {
				width: Math.max(document.documentElement.scrollWidth, document.documentElement.clientWidth),
				height: Math.max(document.documentElement.scrollHeight, document.documentElement.clientHeight)
			}
		}
	},
	// richer: windowֻȾbody
	render : function() {
		this.element.appendTo("body");
	}
});
// FR.Window.end

// FR.FieldSet .start
$.shortcut("fieldset", "FR.FieldSet");
FR.FieldSet = FR.extend(FR.Container, {
	type : "fieldset",
	
	_init : function() {
		FR.FieldSet.superclass._init.apply(this, arguments);
		var o = this.options = $.extend({
			title : "title",
			baseCls : "fr-fieldset",
			width : 120,
			height : 24
		}, this.options);
		this.element.addClass(o.baseCls);
		this.fieldComp = $("<fieldset>").appendTo(this.element);
		$("<legend>").text(o.title).appendTo(this.fieldComp);
		if (o.width > -1) {
			this.fieldComp.css({width : o.width});
			this.element.css({width : o.width});
		}
		if (o.height > -1) {
			this.fieldComp.css({height : o.height});
			this.element.css({height : o.height});
		}		
	},
	doResize : function(give) {
		FR.FieldSet.superclass.doResize.apply(this, arguments);
		var opts = this.options;
		this.fieldComp.css({width : opts.width, height : opts.height,left: opts.left, top: opts.top});
		this.element.css({width : opts.width, height : opts.height,left: opts.left, top: opts.top});
	}
})
// FR.FieldSet .end

// FR.Button .start
$.shortcut("button", "FR.Button");
FR.Button = FR.extend(FR.Widget, {
	type : "button",
	
	_init : function() {
		FR.Button.superclass._init.apply(this, arguments);
		 var o = this.options = $.extend({
            baseCls : 'fr-form-field fr-form-btn',
            prefix : 'x-btn',
            plain : false,
            width : 80,
            height : 24
        }, this.options);
        if (o.prefix) {
        	this.element.addClass(o.prefix);
        }
		this.buttonComp = $("<a href='#'></a>").addClass(o.baseCls).appendTo(this.element);
		if (o.text) {
			this.buttonComp.append(
						'<span class="fr-form-btn-left">' +
						'<span class="fr-form-btn-text">' + 
						o.text +
						'</span>' +
						'</span>'
			);
			var cc = $('.fr-form-btn-text', this.buttonComp);			
			if (o.icon) {
				cc.addClass(o.icon).css('padding-left', '20px');
			}
		} else {
			this.buttonComp.append(
						'<span class="fr-form-btn-left">' +
						'<span class="fr-form-btn-text">' +
						'<span class="fr-form-btn-empty">&nbsp;' +
						'</span>' +
						'</span>' +
						'</span>'
			);
			if (o.icon) {
				$('.fr-form-btn-empty', this.buttonComp).addClass(o.icon);
			}	
		}
		if (o.plain) {
			this.plain(true);
		}
		if (o.width > -1) {
			this.element.css({width : o.width});
		}
		if (o.height > -1) {
			this.element.css({height : o.height});
		}
		var self = this;
		this.buttonComp.click(function(e) {
			self.fireEvent(FR.Events.CLICK, e);
		})
		if ($.isFunction(o.handler)) {
			this.on(FR.Events.CLICK, o.handler.createDelegate(o.scope || this));
		}		
		this.fireEvent(FR.Events.AFTERINIT);
	},
	plain : function(toPlain) {
		if (toPlain == true) {
			this.options.plain = true;
			this.buttonComp.addClass("fr-form-btn-plain");
		} else if (toPlain == false) {
			this.options.plain == false;
			this.buttonComp.removeClass("fr-form-btn-plain");
		} else {
			return this.options.plain;
		}
	}
})
// FR.Button .end

FR.BaseEditor = FR.extend(FR.Widget, {
	_init : function() {
		FR.BaseEditor.superclass._init.apply(this, arguments);
	},
	getValue : function() {
		
	},
	setValue : function() {
		
	}
})

$.shortcut("label", "FR.Label");
FR.Label = FR.extend(FR.BaseEditor, {
	type : "label",
	
	_init : function() {
		FR.Label.superclass._init.apply(this, arguments);
		  //ؼ
        var o = this.options = $.extend({
            cls : 'x-form-field x-form-label',
            baseCls : 'fr-widget-label',
            width : 120,
            height : 24
        }, this.options);
        this.element.addClass(o.baseCls);
        this.labelComp = $("<div></div>").addClass(o.cls).appendTo(this.element);
        if (o.border == true) {
        	this.labelComp.css({border : "1px solid #AAAAAA"});
        }
        if (o.width > -1) {
        	//this.labelComp.css({width : o.width});
        	this.element.css({width : o.width});
        }
        if (o.height > -1) {
        	//this.labelComp.css({height : o.height});
        	this.element.css({height : o.height});
        }
        if (o.text) {
        	this.setValue(o.text);
        }
	},
	setValue : function(value) {
		this.labelComp.text(value);
	},
	getValue : function() {
		return this.labelComp.text();
	}
})


/*
 * alex:!important ڱڱ༭ֵ,editComp.val(),ıĵطһvalue
 * ,Ա֤ȡֵeditCompʵʱı
 * ͬʱҲһЩС,ʾeditCompֵ,ҪһЩֵ
 * NumberEditor֮String2Number, Combo֮Map
 */
//FR.TextEditor.start
/**
* Example:
* config = {
* width : -1,//ؼĳȣ-1ʾĬ
* height : -1,//ؼĸ߶ȣ-1ʾĬ
* minLength : -1,//ַ-1ʾĬ
* maxLength : -1,//ַ-1ʾĬ
* value : '',//Ĭֵ
* allowBlank : true|false,//ǷΪ
* regex : ''//д
* errorMsg : ''//дʱıϢ
* style : "display:none;vertical-align:center" || {display:'none', vertical-align:'center'}
* }
* @param Number width The length of the widget
* @param Number height The height of the widget
* @param Number minLength The minimum length of characters needed
* @param Number maxLength The maximum length of characters needed
* @param Object value The default value of the widget
* @param Boolean allowBlank Does the widget allow blank
* @param String regex The regex used to verify the value of the widget
* @param String errorMsg The error message of the widget
* 
* @event
* contentchange ıڱ༭ʱ¼
* change TextEditorӦvalueı¼
*/
$.shortcut("text", "FR.TextEditor")
FR.TextEditor = FR.extend(FR.BaseEditor, {
	type : 'text',
	
    _init : function() {
        FR.TextEditor.superclass._init.apply(this, arguments);

        /*
         * alex:ieĻ,߶ȼ2,Ȼie±߿ᱻӸǵ,1,
         * bug 6528
         */
        if ($.browser.msie && this.options.height) {
        	this.options.height = this.options.height - 2;
        }
        
        //ؼ
        var o = this.options = $.extend({
            cls : 'x-form-field x-form-text', //ؼcss
            fieldName : "",//ؼ֣Ҫ
            //james-1ʾĬ
            width : 120,     //ؼĿ
            height : 22,     //ؼĸ߶
            editable : true, //james:ǷԱ༭
            autoVerify : false, //ʵʱУ
            multiline : false //Ƿ
        }, this.options);
        
        if(o.passwordText === true) {
        	this.editComp = $("<input type=\"password\"/>").appendTo(this.element);	
        } else {
        	var self = this;
        	var $textarea = $("<textarea style='overflow-y:auto'></textarea>").keydown(function(e){
        	var eel = this;
    		if (e.ctrlKey && e.keyCode == 13){
    				e.ctrlKey = false;
    				eel.value += "\n";  
    				// richer:IE¹			     
    				if(this.createTextRange){  
    				var pos = eel.value.length;
    				var rng = eel.createTextRange(); //½textRange  
                    rng.moveStart('character', pos); //rngĿʼλ  
                    rng.collapse( true ); //ƶΧβ  
                    rng.select();//ѡ  
                    eel.focus();
    		}
    	}});
        this.editComp = (o.multiline === true ? $textarea : $("<input type='text'/>")).appendTo(this.element);
        // richer:ieĪĲһ</div>,ȥ
        if (!this.options.value) {
        	this.editComp.val("");
        }
        }       
        if (o.id) {
            this.editComp.attr('id', o.id);
        }
        if (o.editable !== true) {//ɱ༭Ļֻ
        	this.editComp.attr('readonly', true);
        }
        if (o.disabled == true) {
        	this.editComp.attr("disabled", "disabled");
        }
        
        this.errorMsg = this.options.errorMsg || '';//james:ERROR MessageҪ
        this.editComp.removeClass('x-form-invalid');//ʼʱƳʶ
        this.editComp.removeAttr('title');
        
        this.editComp.attr("name", o.fieldName).addClass(o.cls);
        
        if (o.watermark) {
        	FR.$import('${servletURL}?op=resource&resource=/com/fr/web/core/js/jquery.watermark.js', 'js');
        	this.editComp.watermark(o.watermark);
        }
        
        if (o.width > -1) {
            this.editComp.css("width", o.width);
            this.element.css("width", o.width);
        }
        if (o.height > -1) {
        	this.element.css("height", o.height);
            this.editComp.css("height", o.height); // alex:ȥ±߿ĸ߶
        }
        // alex:styleΪ
        FR.applyStyles(this.editComp, o.style);
        if (o.value) {
        	//james:setValueԼݲֵͬ
        	this.setValue(o.value);
        }

        var self = this;
        //ӿؼԪ
        this.editComp.focus(function() {//ýʱ
//        	self.editComp.removeClass('x-form-text').addClass('x-form-text-focus');
        }).blur(function () {//ʧȥʱ
//	       	self.editComp.removeClass('x-form-text-focus').addClass('x-form-text');
	       	//jamesû壬ǷУ
	       	if (o.autoVerify && !self.isValidate()) {//ԶУֵУδͨ
	       		self.editComp.addClass('x-form-invalid');
	       		self.editComp.attr('title', self.getErrorMsg());
	       		//Уδͨʱʾԭֵ԰ɣӦûʾֵ
	       		//self.editComp.val(o.value);
	       	} else {
				self.editComp.removeClass('x-form-invalid');
				self.editComp.removeAttr('title');
	        }
        }).keyup(function(e) {
			self.fireEvent(FR.Events.AFTEREDIT, e);
        });
    },
    doResize : function(give) {
		FR.TextEditor.superclass.doResize.apply(this, arguments);
		var opts = this.options;
		 if (opts.width > -1) {
            this.editComp.css("width", opts.width);
            this.element.css("width", opts.width);
        }
        if (opts.height > -1) {
        	this.element.css("height", opts.height);
            this.editComp.css("height", opts.height); // alex:ȥ±߿ĸ߶
        }
    },
    /*
     * fire value change
     */
    setValue : function(value) {
    	this.editComp.val(value);
    	
    	// alex:ϵֵthis.options.value,жisDirty
    	var oldValue = this.options.value;
    	this.options.value = value;
        
    	this.fireEvent(FR.Events.CHANGE, value, oldValue); // fire value change event, newValue & oldValue
    },
    
    getValue : function() {
    	return this.editComp.val();
    },
    
    cssFrom : function(dom) {
    	var $dom = $(dom);
		var $comp = this.editComp;
    	$comp.removeClass().addClass($dom.attr("class"));
    	// richer:ʱ༭Ӹͼõ
    	if ($dom.attr("editor").indexOf('"type":"datetime"') > 0){
    		$comp.addClass("dpPicker");
    	}
    	   	  	
		// alex:$domĲstyle
    	$.each(['fontFamily', 'fontVariant', 'fontStyle', 'fontWeight', 'fontSize',
			'paddingTop', 'paddingBottom', 'paddingLeft', 'paddingRight', 'backgroundColor'], function(idx, el) {
    		$comp.css(el, $dom.css(el));
    	})
		if ((/transparent|rgba\(0, 0, 0, 0\)/).test($comp.css('backgroundColor'))) {
			$comp.css('backgroundColor', 'white')
		}
    },

    isValidate : function(cValue) {
        var allowBlank = this.options.allowBlank != false; // james:ĬΪ

		var minLength = this.options.minLength;

		var value = cValue ? cValue : this.getValue();
		var regex = this.options.regex;
		// richer:жǷΪbug6139
		 if ((!value || value.length <= 0)) {//ֵΪյʱ
            if (allowBlank != false) {//ΪգͷTRUE
            	return true;
            } else {//ΪգǾͼ
            	this.errorMsg = this.options.errorMsg || FR.i18n.NOT_NULL;
            	return false;
            }
        }
		if (regex) {
            if (typeof regex == 'string') {//Stringʱ򣬹һRegExp
                regex = new RegExp(regex);                         
            }
            if (!regex.test(value)) {
            	this.errorMsg = this.options.errorMsg || FR.i18n.Error_Input_Value;
                return false;
            }
        }
             
        return true;
    },
    
    getErrorMsg : function() {
    	return this.errorMsg;
    },

    /**
     * Selects text in this field
     * @param {Number} start (optional) The index where the selection should start (defaults to 0)
     * @param {Number} end (optional) The index where the selection should end (defaults to the text length)
     */
    selectText : function(start, end) {
        //james:Ext
        var cv = this.editComp.val();
        if (cv && cv.length > 0) {
            start = start === undefined ? 0 : start;
            end = end === undefined ? cv.length : end;
            var d = this.editComp[0];
            if(d.setSelectionRange){
                d.setSelectionRange(start, end);
            }else if(d.createTextRange){
                var range = d.createTextRange();
                range.moveStart("character", start);
                range.moveEnd("character", end - cv.length);
                range.select();
            }
        }
    },
	// richer:ͱ༭isDirtyҪж,ΪֵparserҲ0
    isDirty : function() {
    	if (this.getValue() == 0) {
    		return true;
    	}
    	return !FR.equals(this.options.value, this.getValue()); // Ƚԭʼֵ͵ǰֵ
    },
	/*
	 * ʼ༭
	 */
	startEditing : function() {
    	this.fireEvent(FR.Events.BEFOREEDIT, this);
		this.editComp.show().focus();
		this.selectText();
	},
	
	/*
	 * ༭
	 */
	stopEditing : function() {
		this.fireEvent(FR.Events.AFTEREDIT, this);
		this.editComp.blur().hide();
	}
});
// FR.TextEditor .end

//FR.NumberEditor.start
$.shortcut("number", "FR.NumberEditor")
FR.NumberEditor = FR.extend(FR.TextEditor, {
    _init : function() {
        FR.NumberEditor.superclass._init.apply(this, arguments);

        var o = this.options = $.extend({
            allowDecimals : true,
            allowNegative : true,
            decimalPrecision : -1,
            decimalSeparator : '.'//decimalķָ
            // alex:value:0ΪĬֵ,ᵼBS༭ʱ,д0,isDirty == false,ֵ
        }, this.options);
        var baseChars = '0123456789';

        var allowed = baseChars+'';
        if(o.allowDecimals){
            allowed += '.';
        }
        if(o.allowNegative){
            allowed += "-";
        }
        
        this.setValue(o.value);
        //b:뷨
        this.editComp.css("ime-mode", "disabled");
        var errorMsg = this.options.errorMsg || FR.i18n.Value_Not_Match;
        this.editComp.keypress(function(e) {
            //james:ǳExt
            var k = e.keyCode;
            if(!$.browser.msie &&
              (FR.isNavKeyPress(e)
                    || FR.isSpecialKey(e)
                    || k == $.ui.keyCode.BACKSPACE
                    || k == $.ui.keyCode.DELETE)){
                return;
            }
            var c = e.charCode || e.keyCode;//jamesIEҪȡkeyCode
            var cc = String.fromCharCode(c);
            if($.browser.msie && (FR.isSpecialKey(e) || !cc)){
	            return;	            
	        }
            
            if(allowed.indexOf(cc) === -1){
            	FR.Msg.alert(FR.i18n.Alert, errorMsg);
            	e.preventDefault();           	
            }
            
            if (this.value.indexOf('.') > -1 && cc == '.') {
            	FR.Msg.alert(FR.i18n.Alert, errorMsg);
            	e.preventDefault();
            }
        });
    },
    
    /*
     * fire value change
     */
    setValue : function(value) {
    	var oldValue = this.getValue();
        
        value = parseFloat(value);
    	this.editComp.val(
    		isNaN(value) ? '' : String(value).replace(".", this.options.decimalSeparator)
    	);
    	
    	// alex:ϵֵthis.options.value,жisDirty
    	var oldValue = this.options.value;
    	this.options.value = value;
        
    	this.fireEvent(FR.Events.CHANGE, value, oldValue); // fire value change event, newValue & oldValue
        
    },
    /**EXT**/
    _fixPrecision : function(value){
        var nan = isNaN(value);
        if(!this.options.allowDecimals || this.options.decimalPrecision == -1 || nan || !value){
           return nan ? '' : value;
        }
        return parseFloat(parseFloat(value).toFixed(this.options.decimalPrecision));
    },
    /**EXT**/
    _parseValue : function(value){
        value = parseFloat(String(value).replace(this.options.decimalSeparator, "."));
        return isNaN(value) ? '' : value;
    },
    //jamesֱ༭ķֵûֵͷ''0ͷ0
    //طҪûķǷҪṩõĵط
    getValue : function() {
    	var number = this._fixPrecision(this._parseValue(this.editComp.val()));
        return number;
    },
    
     verifyDedimals : function() {
	 	if (typeof this.editComp.reg == "undefined") {
			 this.editComp.reg = (this.options.allowNegative ? "\-?" : "") + "\\d+" + (this.options.allowDecimals ? ("(\\.\\d{0," + this.options.maxDecLength + "})?") : "");
	 	}
		var pattern = new RegExp(this.editComp.reg);
	 	var result = pattern.exec(this.editComp.val());
	 	if (result != null) {
	 		return result[0];
 		}
 		return "";
	}, 
	
	recoveryValue : function() {
		this.editComp.val(
    		isNaN(this.options.value) ? '' : String(this.options.value).replace(".", this.options.decimalSeparator)
    	);
	},

    isValidate : function(cValue) {
        var value = cValue ? cValue : this.editComp.val();     
        // richer:Ϊ
        //b: ȷôû
        if (value == "" || value == null || value == undefined ) {
        	if (this.options.allowBlank != false) {
        		return true;
        	} else {
        		this.errorMsg = this.options.errorMsg || FR.i18n.NOT_NULL;
        		return false;
        	}
        }
       
        value = String(value).replace(this.options.decimalSeparator, ".");
        if(isNaN(value)){
            this.errorMsg = this.options.errorMsg || FR.i18n.Value_Must_Be_A_Number;
            return false;
        }
        // ΪС
        if (value.indexOf(this.options.decimalSeparator) > 0) {
        	if (!this.options.allowDecimals ) {
        		this.errorMsg = this.options.errorMsg || FR.i18n.Value_Cannot_Be_Decimal;
        		return false;
        	} else if (this.options.allowDecimals && (value.length - value.indexOf(this.options.decimalSeparator) > this.options.maxDecLength + 1)) {
        		this.errorMsg = this.options.errorMsg || FR.i18n.Value_DecimalNumber_Out;
        		return false;
        	}

        }

        var num = this._parseValue(value);
                // ΪС
        if (num.toString().indexOf(this.options.decimalSeparator) > 0) {
        	if (!this.options.allowDecimals ) {
        		this.errorMsg = this.options.errorMsg || FR.i18n.Value_Cannot_Be_Decimal;
        		return false;
        	} else if (this.options.allowDecimals && (num.toString().length - num.toString().indexOf(this.options.decimalSeparator) > this.options.maxDecLength + 1)) {
        		this.errorMsg = this.options.errorMsg || FR.i18n.Value_DecimalNumber_Out;
        		return false;
        	}

        }
        // Ϊ
        if (!this.options.allowNegative && num < 0){
        	this.errorMsg = this.options.errorMsg || FR.i18n.Value_Cannot_Be_Negative;
        	return false;
        }
        if (this.options.minValue && num < this.options.minValue) {
            this.errorMsg = this.options.errorMsg || FR.i18n.Value_Is_Less_Than_Minimum + this.options.minValue;
            return false;
        }
        if (this.options.maxValue && num > this.options.maxValue) {
            this.errorMsg = this.options.errorMsg || FR.i18n.Value_Is_Larger_Than_Maximum + this.options.maxValue;
            return false;
        }
        return true;
    }
});
//FR.NumberEditor.end

//TriggerEditor.start
FR.TriggerEditor = FR.extend(FR.BaseEditor, {
	_init : function() {
		FR.TriggerEditor.superclass._init.apply(this, arguments);
		var o = this.options = $.extend({
			baseCls : "fr-trigger",
			btn_up : "fr-trigger-btn-up",
			btn_down : "fr-trigger-btn-down",
			width : 80
		}, this.options);
		var dis = $.browser.msie ? 17 : 19; 
		this.triggerComp = $("<div class='" + o.baseCls + "'></div>").appendTo(this.element);
		this.triggerTextComp = $("<div class='fr-trigger-text'></div>").appendTo(this.triggerComp);
		this.editComp = $("<input type='text'/>").appendTo(this.triggerTextComp);
		var triggerFn = this.onTriggerClick.createDelegate(this);
		this.btn =$("<div class='fr-trigger-btn-up'></div>")
		.bind("click", triggerFn)
		.hover(
			function(){
				$(this).switchClass("fr-trigger-btn-up", "fr-trigger-btn-down");
			}, 
			function() {
				$(this).switchClass("fr-trigger-btn-down", "fr-trigger-btn-up");
			})
		.appendTo(this.triggerComp);
		if (o.width > -1) {
			this.triggerComp.css({width : o.width});
			this.triggerTextComp.css({width : o.width - dis});
			this.editComp.css({width : o.width - dis});
		}
		if (o.height > -1) {
			this.triggerComp.css({height : o.height});
			this.triggerTextComp.css({height : o.height});
			this.editComp.css({height : o.height});
		}
    },
    
    /*
     * alex: trigger clickʱ򴥷¼
     */
    onTriggerClick : function() {
    	
    },
    
    // ֧ͨclassͼ
    setIcon : function(cls) {
    	this.btn.attr("class", cls);
    },
    
    isValidate : function(cValue) {
    	var allowBlank = this.options.allowBlank != false; // james:ĬΪ

		var value = cValue ? cValue : this.getValue();
		var regex = this.options.regex;
		// richer:жд
		if (regex) {
            if (typeof regex == 'string') {//Stringʱ򣬹һRegExp
                regex = new RegExp(regex);                         
            }
            if (!regex.test(value)) {
            	this.errorMsg = this.options.errorMsg || FR.i18n.Error_Input_Value;
                return false;
            }
        }
        if ((!value) || FR.isEmptyArray(value)) {//ֵΪյʱ
            if (allowBlank) {//ΪգͷTRUE
            	return true;
            } else {//ΪգǾͼ
            	this.errorMsg = this.options.errorMsg || FR.i18n.NOT_NULL;
            	return false;
            }
        }
        return true;
    },
	/*
	 * ʼ༭
	 */
	startEditing : function() {
    	this.fireEvent(FR.Events.BEFOREEDIT);
    	this.$wrapper.show();
    	FR.TriggerEditor.superclass.startEditing.apply(this, arguments);
	},
	
	/*
	 * ༭
	 */
	stopEditing : function() {
		this.fireEvent(FR.Events.AFTEREDIT);
    	this.$wrapper.hide();
    	FR.TriggerEditor.superclass.stopEditing.apply(this, arguments);
	}
});
//TriggerEditor.end

//FR.ComboBoxEditor.start
/**
* Example:
* config = {
*   allowBlank : true,
*   filter : "",
*   items : [{text:'', value:''},...],//ȼURLݵȻõǰʾ
*   value : "",
*   url : "",//̬ʱãֵӦǡdataĸʽ
* }
*/
$.shortcut("combo", "FR.ComboBoxEditor");
FR.$view_container = $("<div class='view-container'>"); // alex:ͳһذ$view
// TODOJ jamesطĬϾdivӵbodyУð???
$(function() {
	FR.$view_container.appendTo('body');
})
FR.ComboBoxEditor = FR.extend(FR.TriggerEditor, {
	type : 'combo',
	
	_init : function() {
		FR.ComboBoxEditor.superclass._init.apply(this, arguments);

        // ؼ
        var o = this.options = $.extend({
        	maxCount : 10,//һҳʾļ¼
        	mode : 'remote', //[localremote]һʹõʱremoteģҲҪԶȡȡԺ󣬾ΪlocalٴδԶȡ
            url : this.options.url,
            autoMode : true,//james:ɺԶmodeΪfalseǽһֱömodeȡ
            value : '',
            searchTime : 2000//ֶ2ʼȥѯ
        }, this.options);
        
        // ÿComboӦһdiv -> $view
        var self = this;
        this.$view = $('<div>').appendTo(FR.$view_container).height(20);
      	this.editComp.keyup(function(event){
      		// richer:Ҫֱӱ༭ʱṩٶλ
      		if (!FR.isNavKeyPress(event) && self.options.editable){
      			setTimeout(function() {
      				var filter = self.editComp.val();
      				self._ajaxSearch(filter);
      			}, o.searchTime);
      		}
      	});
    	this.$view.hide();//james:
		/*
		 * alex:BUG0001369,ԭûnullж,ᵼitemsʼĻʹitemsΪ[]
		 * ôԭֵΪF,ΪitemsΪnull,Ͳ_getItems,ôeditCompлʾF
		 */ 
    	// alex:ʼo.items
		if (o.items != null) {
    		this._setItems(o.items);
		}
    },
    
    _onKeyDown : function(e) {
    	var self = e.data;
    	switch (e.keyCode) {
    		case $.ui.keyCode.DOWN : {
	    		if (!self.isExpanded()) {
	    			self.onTriggerClick();
	    		} else {
	    			var selected = self._getSelectedIndex();
	    			var nextIndex = 0;
	    			if (selected.length > 0) {
	    				nextIndex = selected[0] + 1;
	    			}
	    			
	    			if (nextIndex < self.options.items.length) {
	    				self._setSelectedIndex(nextIndex);
	    			}
	    		}
	    		e.stopEvent();
    			break;
    		}
    		case $.ui.keyCode.UP : {
    			if (self.isExpanded()) {
    				var selected = self._getSelectedIndex();
    				var nextIndex = 0;
    				if (selected.length > 0) {
    					nextIndex = selected[0] - 1;
    				}
    				
    				if (nextIndex >= 0) {
    					self._setSelectedIndex(nextIndex);
    				}
	    			e.stopEvent();
    			}
    			break;
    		}
    		case $.ui.keyCode.ENTER: case $.ui.keyCode.TAB : {
    			if (self.isExpanded()) {
					self._onEnterPressed();
    				e.stopEvent();
    			}
    			break;
    		}
    	}
    },
    
    onTriggerClick : function() {
    	// richer:һµť¼
    	if (this.fireEvent(FR.Events.CLICK) === false) {
    		return false;
    	}
    	
    	if (!this.isEnabled()) {
    		return;
    	}
    	
    	if (this.isExpanded()) {
    		this.collapse();
    	} else {
    		this.options.autoMode = true;
    		this._createVieList();
    	}
    },
    _createVieList : function(filter) {
		var o = this.options;
		// Ϊ0˵ûмع
		if ($(".x-combo-list-inner").length == 0) {
	       	//jamesãΪ_getOffsetҪ$editorComponentԺ
    		var os = this.editComp.offset();
			this.$view.addClass('x-combo-list x-combo-list-inner')
	   			.css({
	   				position: 'absolute', 
	   				top : parseInt(os.top) + parseInt(o.height), 
	   				left : os.left, 
	   				width: o.width, 
	   				overflow : 'auto',
	   				'z-index' : '1010'
	   			})
		} else {
			$(".x-combo-list-inner").hide();
		}
		if (o.mode == 'local') {
	   			// richer:this.modifyPosition()ʱҪthis.tH治ڣֿ
	   			this.modifyPosition();
	   			this.expand();//localʾѾعˣҪ¼أֱʾͿ
	   		// carl:һ'half-remote'״̬ʾھѾݵûչ
	   	} else if ((o.mode == 'half-remote' || o.mode == 'remote') && o.widgetUrl != null) {
	   			this.$view.empty();//
	            this.$view.height(20).show();//߶ȣʾloadingͼ갡
	            this.$view.__loading__(true);
	            if (o.mode == 'remote') this._getItems(filter);
		    	this.$view.__loading__(false).hide();
	            this._setItems(o.items);
	            this.modifyPosition();
	            if (o.autoMode === true) {//ԶmodeʱŸ
					o.mode = 'local';//modeΪlocalٴμ
				}
				/*
				 * alex:__loading__ʱexpand,expandʱҪpopǰֵ,ԱҪȡ
				 */
				this.expand();
	    	}
		
	},
	 _ajaxSearch : function(filter) {
    	this.setMode("remote");
    	this.options.autoMode = false;
    	this._createVieList(filter);
    },
    // alex:ȡitems
    _getItems : function(filter) {
    	var o = this.options;
    	// carl׼ûչģdependenceŪ
    	// չҪdependenceMapӳ֪Ӧչĸ
    	var depO = {};
    	if(o.dependenceMap){
    		var self = this;
    		$.each(o.dependenceMap, function(key, item){
    			if (self.options.form) {
    				// richer:ͬFR_FORMһ£ֲĴСд
    				var val = self.options.form.resolveVariable(item.toUpperCase());
    				if (val != "fr_primitive") {
    					depO[key] = val;
    				}
    			} else {
    				// richer:״̬
    				depO[key] = contentPane.curLGP.getCellValue(item.toUpperCase().startWith("$") ? item.toUpperCase().substring(1) : item.toUpperCase());
    			}
    		});
    	} else if (FR.isArray(o.dependence)) {
    		for (var idx = 0; idx < o.dependence.length; idx++) {
    			var dep = o.dependence[idx];
    			if (this.options.form) {
    				// richer:ͬFR_FORMһ£ֲĴСд
    				var val = this.options.form.resolveVariable(dep.toUpperCase());
    				if (val != "fr_primitive") {
    					depO[key] = val;
    				}
    			} else {
    				// richer:״̬
    				depO[dep] = contentPane.curLGP.getCellValue(dep.toUpperCase().startWith("$") ? dep.toUpperCase().substring(1) : dep.toUpperCase());
    			}
    		}
    	}
        $.ajax({
        	type : 'POST',
		    url : o.widgetUrl,
		    data : {
		    	// alex:˵ҪcjkEncodeԱ
		    	dependence : FR.cjkEncode(FR.jsonEncode(depO)),
		    	filter : FR.cjkEncode(filter)
		    },
        	cache : false,
			async : false,
	        complete: function(res) {
	        	if (!FR.versionRemind(res.responseText)) return;
	        	o.items = FR.jsonDecode(res.responseText) || [];
	        	//b:ֵʱĴ
	        	$.each(o.items, function(index, value) {
	        		// richer:жһǷvalue.textvalue.value
	        		if (value.text && value.text.indexOf("__time__") > -1) {
	        			value.text = FR.jsonDecode(value.text).format(FR.convertJavaDateFormat2JS("yyyy-MM-dd HH:mm:ss"));
	        		}
	        		if (value.value && value.value.indexOf("__time__") > -1) {
	        			value.value = FR.jsonDecode(value.value);
	        		}
	        	}); 
	        }
	    })
    },
    
    // MODE,ǿ¼
    setMode : function(mode) {
    	if (this.options.autoMode === true) {//autoModeʱָ֧mode޸
    		this.options.mode = (mode == 'local') ? 'local' : 'remote';
    	}
    },
    
    /*
     * 
     */
    _setItems : function(items) {
    	items = items || [];
    	var self = this;
    	if (!(this.options.allowBlank === false)){
    		items = [{value : '', text : this.options.name4Empty == null ? '' : this.options.name4Empty}].concat(items);
    	}
    	if (this.options.name4Empty) {
    	// richer:ֵøʾֵ
    		$.each(items, function(i, item){
    			if (!item.value) {
    				items[i].text = self.options.name4Empty;
    			}
    		});
    	}
    	  	
    	this.$view.empty();
    	
    	// itemsĸ,̬ø߶
    	var sH = 18; // james:߶
    	var count = this.options.maxCount || 10; //Ĭʾ10
    	this.tH = items.length > count ? (sH + 2) * count : (sH + 2) * items.length; // 2padding=Border
		this.$view.height(this.tH);// heightaddItemsʱ
		this.modifyPosition();		
    	$.each(items, function(idx, it) {
    		$('<div>').appendTo(self.$view).height(sH).text(it.text)
    		.attr("title", it.text)
    		.addClass('x-combo-list-item')
    		.mouseover(function() {
    			self._setSelectedIndex(idx);
    		})
    		.click(function() {
				self._onEnterPressed();
    		});
    	});
    },
	
	// alex:ѡĳItem...
	_onEnterPressed : function() {
		// alex:ֻıeditComp.val,setValueıthis.options.value(for isDirtyж)
    	this.editComp.val(this._getSelectedItem().text());
    	this.collapse();
    	
    	//richer:
        this.fireEvent(FR.Events.AFTEREDIT, this._getSelectedItem().text());
	},
    
    // $viewǷڴ״̬
    isExpanded : function() {
    	return this.$view && this.$view.is(":visible");
    },
    
    /*
     * alex:ע,ͨe.dataķʽthis,Ϊjqueryôһ¼ģʽ, differ from Ext
     */
    collapseIf : function(e) {
    	var target = e.target, self = e.data;
    	if (!FR.contains(self.$view[0], target) && !FR.contains(self.$wrapper[0], target)) {
    		self.collapse();
    	}
    },
    
    // $view
    expand : function() {
    	if (this.isExpanded()) {
    		return;
    	}
    	
    	this._showView();
    	
    	$(document).bind('mousedown', this, this.collapseIf).bind('mousewheel', this, this.collapseIf);
    	this.editComp.focus();
    	this.fireEvent(FR.Events.EXPAND);
    },
    
    _showView : function() {
    	this.$view.show(); // show,_setSelectedIndex,Ϊ_setSelectedIndexʱҪscroll,ҲҪshow
    	
    	var currentValue = this.getValue(), self = this;
    	this.$view.children('.x-combo-list-item').each(function(idx, it) {
    		if (currentValue == $(it).data("_value")) {
    			self._setSelectedIndex(idx);
    			return false;
    		}
    	});
    },
    
    _getSelectedItem : function() {
    	return this.$view.children('.x-combo-selected');
    },
    
    _getSelectedIndex : function() {
    	var children = this.$view.children('.x-combo-list-item');
    	return this.$view.children('.x-combo-selected').map(function() {
    		return $.inArray(this, children);
    	});
    },
    
    _setSelectedIndex : function(idx) {
    	/*
    	 * alex:ԭ$view.childrent('eq(0)').addClass().__scroll__().siblings().removeClass()
    	 * ieйһЩ,ĳַʽͲ
    	 */
    	this.$view.children('.x-combo-list-item').removeClass('x-combo-selected');
    	this.$view.children('.x-combo-list-item:eq(' + idx + ")")
    	.addClass('x-combo-selected')
    	.__scroll2View__(this.$view, false)
    },
    
    // $viewص
    collapse : function() {
    	if (!this.isExpanded()) {
    		return;
    	}
    	
    	this.$view.hide();
    	$(document).unbind('mousedown', this.collapseIf).unbind('mousewheel', this.collapseIf);
    	this.editComp.focus();
    	this.fireEvent(FR.Events.COLLAPSE);
    },
    
	// ֵ
	setValue : function(value) {
		var fn = function() {
			var items = this.options.items, dp = value;
			for (var i = 0; i < items.length; i++) {
				if (items[i].value == value) {
					dp = items[i].text;
					break;
				}
			}
			
			this.editComp.val(dp);
    	
	    	// alex:ϵֵthis.options.value,жisDirty
	    	var oldValue = this.options.value;
	    	this.options.value = value;
	        
	    	this.fireEvent(FR.Events.CHANGE, value, oldValue); // fire value change event, newValue & oldValue
		}
		
		// alex:this.options.itemsΪnullʱҪ_getItems
		if (this.options.items == null) {
			this._getItems();
			// carl:һ'half-remote'״̬ʾھѾݵûչ
			if (this.options.mode == 'remote' && this.options.autoMode === true) {
				this.options.mode = 'half-remote';
			}
		} 
		fn.call(this);
	},
	
	// ȡֵ
	getValue : function() {
		var dp = this.editComp.val();				
		var items = this.options.items, val = dp;
		if (dp == this.options.name4Empty){
			val = "";
		}
		
		var index = this._getSelectedIndex()[0];

		// richer:ΪյʱбҲûпֵ
		//b:Ӧȡeditorֵindexı仯һıֵbugstopedtingʱǷΪ
		if (this.options.allowBlank === false) {
			index++;
		}
        // richer:˵ѡǿֵ
		if (index == 0){
			return "";
		} else if (this.options.items) {
			if (typeof index == "number" && !isNaN(index) && this.options.items[index - 1].text == dp) {
				return this.options.items[index - 1].value;
			} else if (FR.isArray(items) && items.length > 0) {
				for (var i = 0, len = items.length; i < len; i++) {
					if (items[i].text == dp) {
						val = items[i].value;
						break;
					}
				}
				return val;
			}
			return val;
		}
	},
	
    reset : function() {
    	// ,ĿǰҪʱ,뵱ǰؼصĿؼֵıʱ,Ҫò
    	FR.ComboBoxEditor.superclass.reset.apply(this, arguments);
    	
    	this.setMode("remote");
    },
    // richer:popupλ
    modifyPosition : function(){
    	var cH = document.body.clientHeight - $(".x-toolbar").height();// ȥĸ߶
    	var eH = this.editComp.offset().top;// ༭ĸ߶
    	var wH = this.options.height;// ༭ĸ߶
    	
    	if (cH < eH + parseInt(wH)) {
    		this.$view[0].style.top = eH - this.tH;
    	}
    	if (this.options.popupWidth) {
    		this.$view.width(this.options.popupWidth);
    	}
    	if (this.options.popupHeight){
    		this.$view.height(this.options.popupHeight);
    	}
    }
});
//FR.ComboBoxEditor.end

//FR.CheckBoxEditor.start
$.shortcut("combocheckbox", "FR.CheckBoxEditor")
FR.CheckBoxEditor = FR.extend(FR.ComboBoxEditor, {
	_init : function() {
		FR.CheckBoxEditor.superclass._init.apply(this, arguments);
		
		this.options = $.extend({
			// ƴַķָ
			delimiter : ',', 
			// richer:ʾʱķָ
			des : ',',
			startSymbol : '',
			endSymbol : ''
		}, this.options);
		// richer:ΪFR.jsonDecode()ȷĽԷ
		this.options.delimiter = this.options.delimiter.replace(/\\r/g, "\n");
	},
	/*
	 * ComboBoxEditorĻ,һSPACE¼
	 */
	_onKeyDown : function(e) {
		$.FR.CheckBoxEditor.superclass._onKeyDown.apply(this, arguments);
		
    	var k = e.keyCode;
    	var self = e.data;
		if (self.isExpanded() && k == $.ui.keyCode.SPACE) {
			var selected = self._getSelectedIndex();
			if (selected.length > 0 && selected[0] >= 0) {
				var ck_el = self.ck_el_array[selected[0]]
				ck_el.selected(!ck_el.selected());
				
				e.stopEvent();
			}
		}
	},
    
    /*
     * 
     */
    _setItems : function(items) {
    	items = items || [];
    	this.options.items = items;
    	
    	this.$view.empty();
		this.ck_el_array = []; // alex:³ʼck_el_array
    	
    	// itemsĸ,̬ø߶
    	var sH = 18; // james:߶
    	var count = this.options.maxCount || 10; //Ĭʾ10
    	var th = items.length > count ? (sH + 2) * count : (sH + 2) * items.length; // 2padding=Border
		if ($.browser.msie) {
			this.$view.height(th + 18);// heightaddItemsʱ
			this.tH = th + 8;
		} else {
			this.$view.height(th + sH);
			this.tH = th + sH;
		}
		this.modifyPosition();
		var self = this;
		// richer:Ϊѡȫѡ
		this.$controlPane = $("<div style='display:inline padding-right:20px'>").addClass('x-checkbox-control').CheckBox({text : FR.i18n.Choose_All + "/" + FR.i18n.Deselect_All})
		var controlBox = $.data(this.$controlPane[0], "CheckBox");
		this.$controlPane.click(function(){
			// ȫѡ
			if (controlBox.selected()) {
				self.doSelectAll(items);
		    // ѡ	
			} else {
				self.deSelectAll(items);
			}
			self.fireEvent(FR.Events.AFTEREDIT);
		});
		
		this.$view.append(this.$controlPane);
		
    	$.each(items, function(idx, it) {
    		self.ck_el_array[idx] = $('<div>').appendTo(self.$view).height(sH)
			.CheckBox({text : it.text})
			.attr("title", it.text)
    		.addClass('x-combo-list-item')
			.CheckBox('on', FR.Events.STATECHANGE, function() {	
				if (!this.selected()) {
					controlBox.selected(false);
				}		
				self._refreshComponentValue();
			}).data("CheckBox");
    	});	
    	var initArray = this.editComp.val().split(this.options.des);
    	// richer:ѡĳʼ
    	$.each(this.ck_el_array, function(idx, item) {
    		if ($.inArray(item.options.text, initArray) > -1){
    			item.selected(true);
    		}
    	});
    },
	
	// alex:ѡĳItem...
	_onEnterPressed : function() {
		// alex:ֻıeditComp.val,setValueıthis.options.value(for isDirtyж)
    	this._refreshComponentValue();
    	this.collapse();
    	//richer:
        this.fireEvent(FR.Events.AFTEREDIT);
	},
	
	/*
	 * ˢeditComp.val
	 */
	_refreshComponentValue : function() {
		var value = $.map($.grep(this.ck_el_array, function(ck_el) {
			return ck_el.selected();
		}), function(ck_el) {
			return ck_el.element.text();
		}).join(this.options.des);

		this.editComp.val(value);
		this.fireEvent(FR.Events.AFTEREDIT);
	},
    
	// richer:Ϊȫѡ͸ѡܣ԰
	// richer:ȫѡ
	doSelectAll : function(items){
		var arr = [];
		$.each(items, function(idx, item){
			arr.push(item.text);
		});
		var self = this;
		this.editComp.val(arr.join(this.options.des));
		$.each(items, function(idx, it) {							
			self.ck_el_array[idx].selected(true, "noFireEvent");
	    });
	},
	
	// ѡ
	deSelectAll : function(items){
		this.editComp.val("");
		var self = this;
		$.each(items, function(idx, it) {							
			self.ck_el_array[idx].selected(false, "noFireEvent");
	    });
	},
	
	// ֵ,value is array
	setValue : function(value) {
		var fn = function() {
			// 鲼items,valuetext
			var value_array = $.makeArray(value);
			
			var items = this.options.items;
			$.each(value_array, function(idx, v) {
				for (var i = 0; i < items.length; i++) {
					if (items[i].value == v) {
						value_array[idx] = items[i].text;
						break;
					}
				}
			})
			
			this.editComp.val(value_array.join(this.options.des));
    	
	    	// alex:ϵֵthis.options.value,жisDirty
	    	var oldValue = this.options.value;
	    	this.options.value = value;
	        
	    	this.fireEvent(FR.Events.CHANGE, value, oldValue); // fire value change event, newValue & oldValue
		}
		
		// alex:this.options.itemsΪnullʱҪ_getItems
		if (this.options.items == null) {
			this._getItems();
			// carl:һ'half-remote'״̬ʾھѾݵûչ
			if (this.options.mode == 'remote' && this.options.autoMode === true) {
				this.options.mode = 'half-remote';
			}
		} 
		fn.call(this);
	},

	// ȡֵ, return an array
	getValue : function() {
		// items,textvalue
		var text_array = this.editComp.val().split(this.options.des)
		
		var items = this.options.items;

		// james_mod:BUG0001640itemsпûУûѡκݵʱǿհ
		if (FR.isArray(items) && items.length > 0) {
			$.each(text_array, function(idx, text) {
				for (var i = 0; i < items.length; i++) {
					if (items[i].text == text) {
						text_array[idx] = items[i].value;
						break;
					}
				}
			})
		}
		if (this.options.returnArray){
			return text_array;
			
		}
		var resultStr = this.options.startSymbol + text_array.join(this.options.delimiter) + this.options.endSymbol;
		return resultStr;
	},
	isValidate : function(){
		var allowBlank = this.options.allowBlank != false;
		if (!allowBlank && !this.editComp.val()) {
			this.errorMsg = this.options.errorMsg || FR.i18n.NOT_NULL;
            return false;
		}
		return true;
	}
});
//FR.CheckBoxEditor.end 

$.shortcut('treecombobox', 'FR.TreeComboBoxEditor');
FR.TreeComboBoxEditor = FR.extend(FR.CheckBoxEditor, {
	_init : function(){
		FR.TreeComboBoxEditor.superclass._init.apply(this, arguments);
		var o = this.options = $.extend({
			width : 120,
			height : 300,
			returnArray : true,
			delimiter : ',',
			startSymbol : '',
			endSymbol : '',
			cascadecheck:true
		}, this.options);
		this.$view.attr("id", o.location);
		
		var self = this;
		this.editComp.keyup(function(event){
      		// ģѯ
      		if (!FR.isNavKeyPress(event) && self.options.editable){
      			
      		}
      	});
	},
	
	/*
     * 
     */
    _setItems : function(nodes) {
    	FR.$import('${servletURL}?op=resource&resource=/com/fr/web/core/js/jquerytree/tree.js', 'js');
    	FR.$import('${servletURL}?op=resource&resource=/com/fr/web/core/js/jquerytree/common.js', 'js');	
    	FR.$import('${servletURL}?op=resource&resource=/com/fr/web/core/js/jquerytree/tree.css', 'css');
    	
    	if(this.options.widgetCss && this.options.widgetCss.length != 0){
    		$.each(this.options.widgetCss, function(i, item){
    			FR.$import(item, 'css', true);
    		});
    	}  

    	nodes = nodes || [];
		
    	this.options.nodes = nodes;
    	
    	this.$view.empty();
    	var self = this;
    	this.$view.width(this.options.popupWidth);
    	this.$view.height(this.options.popupHeight ? this.options.popupHeight : 150);
    	this.tH = 150;
    	this.modifyPosition();
    	var self = this;
    	if (this.options.mutiSelection){
    		this.on(FR.Events.COLLAPSE, function() {
    			self._onEnterPressed()
    		})
    	}
    	var o = this.options;
    	var depO = {};
    	if(o.dependenceMap){
    		var self = thi2s;
    		$.each(o.dependenceMap, function(key, item){
    			if (self.options.form) {
    				// richer:ͬFR_FORMһ£ֲĴСд
    				depO[key] = this.options.form.resolveVariable(item.toUpperCase());
    			}
    		});
    	} else if (FR.isArray(o.dependence)) {
    		for (var idx = 0; idx < o.dependence.length; idx++) {
    			var dep = o.dependence[idx];
    			if (this.options.form) {
    				// richer:ͬFR_FORMһ£ֲĴСд
    				depO[dep] = this.options.form.resolveVariable(dep.toUpperCase());
    			}
    		}
    	}
    	 var o = { 
    	 		showcheck: self.options.mutiSelection,
            	onnodeclick:function(item){self._onEnterPressed()}, 
            	cascadecheck: self.options.cascadecheck,
            	url: this.options.widgetUrl
            };
        o.data = nodes;
    	this.$view.treeview(o);
    },
    
    // richer:Ĺ
    quickSearch : function(value){
    	//this.options.currentValue = value;
    	if (!this.isExpanded()) {
    		this.onTriggerClick();
    	}
    	var children = this.$view.find('.bbit-tree-node-el');
    	$.each(children, function(i, item){
    		var text = $(item).text();
    		if(!value) {
    			$(item).css("display", "block");
    			return;
    		}
    		if (text.indexReg(value, true) > -1 || text == ""){
    			$(item).css("display", "block");
    		} else {
    			$(item).css("display", "none");
    		}
    	});
    },
    _onEnterPressed : function() {
    	if (!this.options.mutiSelection) {
    		var result = this.$view.getTCT();
    		this.options.currentValue = result.value;
    		this.editComp.val(result.text);
    	} else {
    		var result = this.$view.getTSTs();
    		if (FR.isArray(result)){
    			var arr = result.join(this.options.delimiter);
    			this.editComp.val(arr);   	
    		}
    		var current = this.$view.getTSVs();
    		// 
			if (this.options.returnArray){
				this.options.currentValue = current;
			} else {
				var resultStr = this.options.startSymbol + current.join(this.options.delimiter) + this.options.endSymbol;
				this.options.currentValue = resultStr;
			}
    	} 	
 		this.fireEvent(FR.Events.AFTEREDIT);
		this.collapse();
    },
    getValue : function(){
    	return this.options.currentValue;
    },
    _getItems : function(){
    	FR.TreeComboBoxEditor.superclass._getItems.apply(this, arguments);
    },
    reset : function(){
    	// ,ĿǰҪʱ,뵱ǰؼصĿؼֵıʱ,Ҫò
        FR.TreeComboBoxEditor.superclass.reset.apply(this, arguments);   	
    	this.setMode("remote");
    }
});

//FR.TreeEditor.Start
$.shortcut('tree', 'FR.TreeEditor');
FR.TreeEditor = FR.extend(FR.CheckBoxEditor, {
	_init : function(){
		FR.TreeEditor.superclass._init.apply(this, arguments);
		FR.$import('${servletURL}?op=resource&resource=/com/fr/web/core/js/jquerytree/tree.js', 'js');
    	FR.$import('${servletURL}?op=resource&resource=/com/fr/web/core/js/jquerytree/common.js', 'js');	
    	FR.$import('${servletURL}?op=resource&resource=/com/fr/web/core/js/jquerytree/tree.css', 'css');
		// treeĳʼ߶ȺͿ
        var o = this.options = $.extend({
            width : 120,    
            height : 200 
        }, this.options);
		var self = this;
		this.$treeDiv = this.element.attr("id", o.location);
		if (o.width > -1){
			this.$treeDiv.css("width", o.width);
		}
		if (o.height > -1){
			this.$treeDiv.css("height", o.height);
		}
		this._getItems();
		var o = { 
    	 		showcheck: self.options.mutiSelection,
            	onnodeclick:function(item){self._onEnterPressed()}, 
            	url: this.options.widgetUrl,
            	data:o.items
            };
    	this.$treeDiv.treeview(o);
	},	
	
	_onEnterPressed : function(){
		this.fireEvent(FR.Events.CLICK)
	},
	
	getValue : function() {
       return this.$treeDiv.getTCT().value;
    },

    setValue : function(value) {
        //ñ༭ֵ
    },  
    _getItems : function(){
        FR.TreeEditor.superclass._getItems.apply(this, arguments);
    }, 
    reset : function() {
    	// ,ĿǰҪʱ,뵱ǰؼصĿؼֵıʱ,Ҫò
    	this.setValue("");
    }
});
//FR.TreeEditor.End

//FR.TableTree.Start
$.shortcut("tabletree", "FR.TableTree");
FR.TableTree = FR.extend(FR.ComboBoxEditor, {
    _init : function(){
       FR.TableTree.superclass._init.apply(this, arguments);
       FR.$import('${servletURL}?op=resource&resource=/com/fr/web/platform/js/jquery.tabletree.js', 'js');
	   FR.$import('${servletURL}?op=resource&resource=/com/fr/web/platform/css/jquery.tabletree.css', 'css');
	   var o = this.options = $.extend({
            width : 120,    
            height : 200 
        }, this.options);
        
        this.$TableTreeDiv = this.element;
		if (o.width > -1){
			this.$TableTreeDiv.css("width", o.width);
		}
		if (o.height > -1){
			this.$TableTreeDiv.css("height", o.height);
		}
        var self = this;   
        // ȡһֵ    
        this._getItems();
        var cvns = o.items;
        
        o.widgetUrl = o.url;
        this._getItems();
        this.$TableTreeDiv.tabletree({
             data : o.items,
             cvns : cvns
        });
    },
    getValue : function(){
        return this.$TableTreeDiv.getTableTreeValue();
    },
    setValue : function(value){
        this.$TableTreeDiv.setTableTreeValue(value);
    }
});
//FR.TableTree.End

//FR.ListEditor.Start
// б
$.shortcut("list", "FR.ListEditor");
FR.ListEditor = FR.extend(FR.ComboBoxEditor, {
	_init : function(){
		FR.ListEditor.superclass._init.apply(this, arguments);	
		FR.$import('${servletURL}?op=resource&resource=/com/fr/web/platform/js/jquery.jlist.js', 'js');
		FR.$import('${servletURL}?op=resource&resource=/com/fr/web/platform/css/jquery.jlist.css', 'css');
		var o = this.options = $.extend({
            width : 120,    
            height : 200 
        }, this.options);
        
        this.$ListDiv = this.element;
		if (o.width > -1){
			this.$ListDiv.css("width", o.width);
		}
		if (o.height > -1){
			this.$ListDiv.css("height", o.height);
		}
        var self = this;
        this.$ListDiv.__loading__(true);
        this._getItems();
        this.$ListDiv.jlist(
        {
       	    data: o.items,  
       	    needhead:o.needHead,
       	    onnodeclick : function(index, newItem, oldItem){
       	    	self.fireEvent(FR.Events.CLICK, index, newItem, oldItem);
       	    },
       	    initaction : function(){
       	        self.fireEvent(FR.Events.AFTERINIT);
       	    }    	
        }         
       );
	},
	getValue : function(){
		return this.$ListDiv.getListValue();
	},
	
	setValue : function(value, item){
		this.$ListDiv.setListValue(value, item);
	},
	addItem : function(item){
		this.$ListDiv.addListItem(item);
	},
	getAll : function(){
	    return this.$ListDiv.getListAll();
	},
	setAll : function(val){
		this.$ListDiv.setListAll(val);
	},
	clear : function(){
		this.$ListDiv.clearList();
	},
	startEditing : function(){
		this.fireEvent(FR.Events.BEFOREEDIT);
	},
	stopEditing : function(){
		this.fireEvent(FR.Events.AFTEREDIT);
	}
});
//FR.ListEditor.End

// FR.DateTimeEditor .start
$.shortcut("datetime", "FR.DateTimeEditor");
FR.DateTimeEditor = FR.extend(FR.TextEditor, {
	_init : function(){
		FR.DateTimeEditor.superclass._init.apply(this, arguments);
		FR.$import('${servletURL}?op=resource&resource=/com/fr/web/core/js/jsCal/jquery.dynDateTime.js', 'js');
		FR.$import('${servletURL}?op=resource&resource=/com/fr/web/core/js/jsCal/lang/calendar-lang.js', 'js');
		FR.$import('${servletURL}?op=resource&resource=/com/fr/web/core/js/jsCal/css/calendar-blue.css', 'css');
		if(this.options.widgetCss && this.options.widgetCss.length != 0){
    		$.each(this.options.widgetCss, function(i, item){
    			FR.$import(item, 'css', true);
    		});
    	}
		var o = this.options = $.extend({
			format : 'yyyy-MM-dd',
			editable: true			
		}, this.options);
		this.std = new Date(o.startDate);
		this.edd = new Date(o.endDate);
		var self = this;
		this.editComp.addClass("dpPicker");
		
		var isShowTime = (o.format.indexOf("H") != -1 || o.format.indexOf("h") != -1) ? true : false;
		this.editComp.dynDateTime({
				showsTime: isShowTime,
				ifFormat: FR.parseFmt(o.format),
				startDate: o.startDate,
				endDate: o.endDate
		}).keydown(function(e){ 
			if (!e.shiftKey) {
				Calendar.finish();
			}			
		});		
	},
		
	setValue : function(value) {
		var dp = value || '';
		var format = this.options.format;
		if (dp.date_milliseconds){
			dp = new Date(dp.date_milliseconds);
		} else {
			value = value.replace(/-/g, "/");
			dp = new Date(value);
		}
        // richer:ffnew Date("")"Invalid Date"ie"NaN"
		if (dp == "Invalid Date" || dp == "NaN"){
			dp = '';
		} else if (dp instanceof Date) {
			// richer:Ҫͨõjava͵ʱתΪjsʱ
			dp = '' + dp.format(FR.convertJavaDateFormat2JS(format));
			this.options.value = dp;
		} else if ( !Date.parseDate(String(dp), format)) {// formatĻͱΪհ
			dp = '';
		}
		this.editComp.val(dp);
				
		// alex:ϵֵthis.options.value,жisDirty
		var oldValue = this.options.value;
		this.options.value = value;

		this.fireEvent(FR.Events.CHANGE, value, oldValue);
	},
	getValue : function(){
		var format = this.options.format;
		// richer:ֱӱ༭ڵ
		this.currentValue = this.editComp.val();
        //jamesֵǲȷ
		if (!this.currentValue){
			return '';
		}
		if (!this.options.returnDate) {
			return this.currentValue;
		}
        var returnDate = Date.parseDate(this.currentValue, FR.convertJavaDateFormat2JS(format));
        // jamesؼͳһDate͵ֵDateͷؿգûзundefined
        return (returnDate == null) ? '' : returnDate;
	},
	isValidate : function(cValue) {
		var allowBlank = this.options.allowBlank != false; // james:ĬΪ
		var format = this.options.format;
		var startDate = this.std;
		var endDate = this.edd;
		
		var value = cValue ? cValue : this.getValue();
		var regex = this.options.regex;
		// richer:жд
		if (regex) {
            if (typeof regex == 'string') {//Stringʱ򣬹һRegExp
                regex = new RegExp(regex);                         
            }
            if (!regex.test(value)) {
            	this.errorMsg = this.options.errorMsg || FR.i18n.Error_Input_Value;
                return false;
            }
        }
        if ((!value)) {//ֵΪյʱ
            if (allowBlank) {//ΪգͷTRUE
            	return true;
            } else {//ΪգǾͼ
            	this.errorMsg = this.options.errorMsg || FR.i18n.NOT_NULL;
            	return false;
            }
        }

        if (value < startDate) {
        	this.errorMsg = this.options.errorMsg || FR.i18n.Value_Is_Less_Than_Minimum + startDate.format(FR.convertJavaDateFormat2JS(format));
        	return false;
        }
        if (value > endDate){
        	this.errorMsg = this.options.errorMsg || FR.i18n.Value_Is_Larger_Than_Maximum + endDate.format(FR.convertJavaDateFormat2JS(format));
        	return false;
        }
        	
        return true;
	}
});

$.shortcut("file", "FR.FileUploadEditor")
/*
 * url : ļύurlַ
 * callback : ύ֮callback
 */
FileUploadEditor = FR.extend(FR.BaseEditor, {
	_init : function() {
		FR.FileUploadEditor.superclass._init.apply(this, arguments);
        // Ԥ
        var o = this.options = $.extend({
            width : 120,     // ԤĿ
            height : 20     // Ԥĸ߶
        }, this.options);
        
        var self = this;
        // Ԥ
        if (o.render === true) {
			this.$preview = $("<img>").attr("src", "${servletURL}?op=resource&resource=/com/fr/web/images/s.gif")
			.appendTo(this.element)
			.addClass("x-fileupload")
			.bind("click", o.disabled ? "" : function(){self._showDialog()})
        } else {
            this.$preview = this.element;
        }
		
		this.$preview.css({width : o.width, height : o.height});
		if (o.value != null) {
			this.setValue(o.value);
		}
	},
	// richer:ҪжļǷҪ
	isValidate : function(){
		return true;
	},
	
	/*
	 * ʼ༭
	 */
	startEditing : function() {
		this.fireEvent(FR.Events.BEFOREEDIT);
		this.$preview.show();
		// richer:ļenableҪ
		if (this.options.disabled){
			this.$preview.unbind("click");
		} else {
			this._showDialog();
		}		
	},
	
	/*
	 * ༭
	 */
	stopEditing : function() {
		this.fireEvent(FR.Events.AFTEREDIT);
		this.$preview.hide();
		this._focusPreviewPane(false);
	},
	
	/*
	 * ѡļĶԻ
	 */
	_showDialog : function() {
		var self = this;
		// carl:ǵwindowsȺϴڲڼsessionID
		FR.showUploadDialog({url : this.options.url ? this.options.url : "${servletURL}?op=attach_upload", autoUpload : this.options.autoUpload, 
			allowTypes : this.options.allowTypes,
			err : this.options.errorMsg,
			el: self, callback : function(res, status, widget) {
           	 if (status == 'success') {
				self._preview(FR.jsonDecode(res.responseText));
				widget.fireEvent(FR.Events.CALLBACK, res);
			 }
			
			self._focusPreviewPane(true);
		}});
		
		this._focusPreviewPane(false);
	},
	
	/*
	 * alex:$preview߽,Ҳǰ¿ոʱ,ҪԻ
	 */
	_focusPreviewPane : function(b) {
		$(document)[b ? 'bind' : 'unbind']('keydown', this, this._onKeyDown)
	},
	
	/*
	 * ¿ոʱ,ҪԻ
	 */
	_onKeyDown : function(e) {
		var self = e.data;
		if (e.ctrlKey && e.keyCode == $.ui.keyCode.SPACE) {
			self._showDialog();
		}
	},
	
	setValue : function(value) {
    	// alex:ϵֵthis.options.value,жisDirty
    	var oldValue = this.options.value;
    	this.options.value = value;
        
    	this.fireEvent(FR.Events.CHANGE, value, oldValue); // fire value change event, newValue & oldValue
		
		this._preview(value)
	},
	
	getValue : function() {
		return this.$preview.data("_cv")
	},
	
	/*
	 * alex:$previewԤ,Ҫ,һǸı$preview.background,Ҫvalue$preview,ֵܰthis.options.value
	 */
	_preview : function(value) {
		this.$preview.data("_cv", value)
		
		if (value.attach_type != null && value.attach_id != null) {
			FR.previewAttachment(this.$preview, value)
		}
	}	
})

/*
 * alex:ԤAttachment,ͼƬʱʾһͼƬ,ͼƬʱ
 */
$.extend(FR, {
	previewAttachment : function() {
		function download(e) {
			window.open("${servletURL}?op=attach_download&id=" + e.data);
		}
		
		return function(target, attach) {
			var $target = $(target);
			if (attach.attach_type == 'image') {
				var im_url = '${servletURL}?op=attach_image&id=' + attach.attach_id
				// alex:ieҪֶpng͸ͨ
				if ($.browser.msie) {
					$target.css("filter", "progid:DXImageTransform.Microsoft.AlphaImageLoader(src='" + im_url + "')")
				} else {
					$target.css('background', 'transparent url(' + im_url + ") 0 0 no-repeat")
				}
				$target.css("cursor", "default").unbind("click", download)
			} else {
				$target.css('background', 'transparent url(${servletURL}?op=resource&resource=/com/fr/web/images/download.gif) center center no-repeat')
				.css("cursor", "pointer")
				.bind('click', attach.attach_id, download);
			}
		}
	}()
})

$.shortcut("multifile", "FR.MultiFileEditor")
FR.MultiFileEditor = FR.extend(FR.BaseEditor, {
	_init : function() {
		FR.$import('${servletURL}?op=resource&resource=/com/fr/web/core/js/jquery.MultiFile.js', 'js');
		FR.MultiFileEditor.superclass._init.apply(this, arguments);
		
        var o = this.options = $.extend({
        }, this.options);
        
        this.$formDiv = $("<div></div>").appendTo(this.element);
        this.$form = $("<form enctype='multipart/form-data'>"
         	+ "<input type='file' name='file' class='multi' />"
			+ "</form>").appendTo(this.$formDiv);
		
		this.$formDiv.css({width : o.width, height : o.height});
		this.$formDiv.css("font-size", "72%");
		var $fileinput = $("input[type=file].multi", this.$formDiv);
		
		if (o.maxlength != -1) {
			$fileinput.attr("maxlength", o.maxlength);
		}
		if (o.accept) {
			$fileinput.attr("accept", o.accept);
		}
		
		if (o.value != null) {
			this.setValue(o.value);
		}
		
		$(function(){
  			$fileinput.MultiFile();
 		})
	},
	
	/*ϴ*/
	upload: function(path) {
		var actionurl = (this.options.url || "${servletURL}?op=multiattach_upload");
		if (path) {
			actionurl = actionurl + "&path=" + path;
		}
		
		var self = this;		
		FR.domFormSubmit(this.$form , {url : actionurl, timeout : 3000000}, 
			function(res, status) {
				if ($.isFunction(this.options.callback)) this.options.callback(res, status, self.options.el);
			});
	}
})

//FR.TabPane start
$.shortcut("tab", "FR.TabPane")
FR.TabPane = FR.extend(FR.Widget, {
    _init : function() {
    	FR.TabPane.superclass._init.apply(this, arguments);
        var o = this.options = $.extend({
            tabPrefix : 'x-tab-',
            navCls: 'tabs-nav',
            selectedCls: 'tabs-selected',
            disabledCls: 'tabs-disabled',
            containerCls: 'tabs-container',
            hideCls: 'tabs-hide',
            initial : 0,//һʾtab
            position : 'south',// north/south
            tabs : []
        }, this.options);

        //james:׼
        this.$tabControl = $('<div>');//tabĿ
        this.$tabContainer = $('<div>');//tabľ

        var $ul = $('<ul>').addClass(o.navCls).appendTo(this.$tabControl);
        for (var i = 0; i < o.tabs.length; i++) {
            var html = '<li>'
                    + '<a _href=' + i +'>'
                    + '<span>' + FR.htmlEncode(o.tabs[i].title) + '</span>'
                    + '</a>';
            $ul.append($(html));
            //jamesȫأӵʱʾ
            $('<div>').appendTo(this.$tabContainer)
                    .attr('id', o.tabPrefix + i)//Ӹid鿴
                    .addClass(o.containerCls).addClass(o.hideCls);
        }
        // TODO richer:Ҫı俩 
        //ؽؼв
        this.element.asComponent("borderlayout", {items:[{
            region : o.position,
            el : this.$tabControl
        }, {
            region : 'center',
            el : this.$tabContainer
        }]});

        //һЩ¼
        var self = this;
        $('a', this.$tabControl).each(function(idx, tabCtl) {
            $(this).bind('click', function(e) {
                //jamesȡaĸ׽ڵliΪselectedClsliڵ
                var li = $(this).parents('li:eq(0)');
                //james:liڵѾѡл߲ѡУֱ˳
                if (li.is('.' + o.selectedCls) || li.is('.' + o.disabledCls)) {
                    return false;
                }
                
                self._onTabChange(self.showingIndex, $(this).attr('_href'));

                return true;
            });
        });
        
        // ʾo.initialindexPanel
        this._onTabChange(-1, o.initial);
    },
    
    /*
     * Change Tab, from oIdx to nIdx
     */
    _onTabChange : function(oIdx, nIdx) {
    	var o = this.options;
    	this.fireEvent(FR.Events.TABCHANGESTART);
    	// ؾɵTAB & ʾµTAB
    	$("#" + o.tabPrefix + oIdx, this.$tabContainer).addClass(o.hideCls);
    	var $showTab = $("#" + o.tabPrefix + nIdx, this.$tabContainer).removeClass(o.hideCls);
    	
    	// jamesѡеĽڵ㣬վɵѡнڵ
    	$("li:eq(" + nIdx + ")", this.$tabControl).addClass(o.selectedCls).siblings().removeClass(o.selectedCls);
    	
    	this.$tabContainer.asComponent("borderlayout", {items:[{
            region : 'center',
            el : $showTab
        }]});
    	
    	// ִtabchange¼ܶʵʵֵ
    	this.fireEvent(FR.Events.TABCHANGE, this, nIdx);
        
        this.showingIndex = nIdx; // ʶǰʾindexnIdx
    }
});
//FR.TabPane end

// richer:İť
$.extend(FR, {
	dealWidthGroup : function(sessionID, selfWidget) {
		var writePane = _g(sessionID);
		// richer:˵ҳ
		if (writePane.widgetName != "WritePane") {
			return false;
		}
		//b:һformû
		if (!writePane.curLGP.form) {
			return;
		}
		
		var widgets = writePane.curLGP.form.location_widgets;

		$.each(widgets, function(idx, item){
			//richer:
			if (item == selfWidget){
				var location = item.options.location;
				var value = item.getValue();
				if (item.options.allowBlank == false && (!value || FR.isEmptyArray(value))) {
					FR.Msg.alert(FR.i18n.Alert, item.getErrorMessage());
					return false;
				}
				//b:ӸǷʾvalue
				writePane.curLGP.setCellValue(location, null, item.getValue(), true);
				var cell = $("#" + location + "-" + writePane.curLGP.idx)[0];
				writePane.curLGP.fireCellValueChange(cell, value);
			}
		});		
	},
	isEmptyArray : function(array) {
    	if (array instanceof Array) {
    		if (array.length == 0) {
    			return true;
    		} else if (array.length == 1) {
    			return array[0] === "";
    		}
    	}
    	return false;
    }
});

// checkboxgroup start
$.shortcut("checkboxgroup", "FR.CheckBoxGroup")
FR.CheckBoxGroup = FR.extend(FR.BaseEditor, {
	_init : function() {
		FR.CheckBoxGroup.superclass._init.apply(this, arguments);
		var o = this.options = $.extend({
			baseCls : "fr-checkboxgroup",
			row : 1,
			width : 80,
			height : 24
		}, this.options);
		this.element.addClass(o.baseCls);
		var grid = new FR.GridLayout({
			rows : 1,
			columns : 2,
			items : [{xtype : "checkbox", text : "text1", filedName : o.fieldName, width : 100}, {xtype : "checkbox", text : "text2",filedName : o.fieldName, width : 100}]
		});
		this.element.append(grid.element);			
	}
});
// checkboxgroup end

// radiogroup start
$.shortcut("radiogroup", "FR.RadioGroup")
FR.RadioGroup = FR.extend(FR.BaseEditor, {
	lbox_class : 'x-group-box',
	sbox_class : 'x-group-span', 
	
	_init : function() {
		FR.RadioGroup.superclass._init.apply(this, arguments);
		
		var o = this.options;
		
		this.radioArray = [];
		var width = o.width > 0 ? o.width : 0;
		var height = o.height > 0 ? o.height : 0;

		this.$box = $("<div></div>").appendTo(this.element)
			.css("width", width).css("height", height).addClass(this.lbox_class);
		
		this._refreshItems();
	},
	
	reset : function() {
		this._refreshItems();
	},
	
	_refreshItems : function() {
		this.$box.html("");
		var o = this.options;
		var self = this;
    	var depO = {};
    	if(o.dependenceMap){
    		var self = this;
    		$.each(o.dependenceMap, function(key, item){
    			if (self.options.form) {
    				// richer:ͬFR_FORMһ£ֲĴСд
    				depO[key] = this.options.form.resolveVariable(item.toUpperCase());
    			}
    		});
    	} else if (FR.isArray(o.dependence)) {
    		for (var idx = 0; idx < o.dependence.length; idx++) {
    			var dep = o.dependence[idx];
    			if (this.options.form) {
    				depO[dep] = this.options.form.resolveVariable(dep.toUpperCase());
    			}
    		}
    	}
    	var cur_async = (o.sessionID && _g(o.sessionID).rtype == 'form') ? true : false;
        $.ajax({
		    url : o.widgetUrl,
		    data : {
		    	dependence : FR.jsonEncode(depO)
		    },
		    async : cur_async,
        	cache : false,
	        complete: function(res) {
	        	o.items = FR.jsonDecode(res.responseText) || [];
	        	self._setItems(o.items);
	        }
	    });
	},
	
	_setItems : function(items) {
		items = items || [];
		
		this.radioArray = [];
		var rname;
		if (this.options.fieldName) {
			rname = this.options.fieldName;
		} else {
			// ûֵ¸ĬŪһ
			rname = "noNameChild";
		}
		var self = this;
    	$.each(items, function(idx, it) {
    		var outter = $("<span></span>")
   		    .addClass(self.sbox_class)
    		.appendTo(self.$box);
    		self.radioArray[idx] = outter.asComponent("radio", {text : it.text, fieldValue : it.value, sessionID : self.options.sessionID, name : rname});
    		// carl:Ĭֵ
    		if (it.value == self.options.value) {
    		   self.fireEvent(FR.Events.STATECHANGE, idx, true);
    		   self.radioArray[idx].selected(true);
    		 }
    		self.radioArray[idx].on(FR.Events.STATECHANGE, function(){
    			FR.dealWidthGroup(self.options.sessionID, self);
    			self.fireEvent(FR.Events.STATECHANGE, idx, this.selected());
    		})
    	});
	},
	
	startEditing : function() {
    	this.fireEvent(FR.Events.BEFOREEDIT);
    	this.$box.show().focus();
	},
	
	stopEditing : function() {
		this.fireEvent(FR.Events.AFTEREDIT);
		this.$box.blur().hide();
	},
	
	getValue : function() {
		var self = this;
		var value = "";
		var items = this.options.items;
		$.each(self.radioArray, function(idx, it) {
			if (it.selected()) {
				value = items[idx].value;
			}
		});
		return value;
	},
	
	setValue : function(value) {
		var fn = function() {
		    // richer:עҪ0ȥֵʱ		
			if (!value && value != 0) return; 
			// carl:״̬
			for (var i =0; i < this.radioArray.length; i++) {
				this.radioArray[i].reset();
			}
			var items = this.options.items;
			for (var i = 0; i < items.length; i++) {
				if (items[i].value == value) {
					this.radioArray[i].selected(true);
					break;
				}
			}
    	
	    	// alex:ϵֵthis.options.value,жisDirty
	    	var oldValue = this.options.value;
	    	this.options.value = value;
	        
	    	this.fireEvent(FR.Events.CHANGE, value, oldValue); // fire value change event, newValue & oldValue
		}
		
		if (this.options.items == null) {
			this._refreshItems();
		}
		
		fn.call(this);
	},
	
	getErrorMessage : function() {
		return this.options.errorMsg || FR.i18n.NOT_NULL;
	}
});
// radiogroup end

/*
 * ToogleButtonΪ״̬Button,CheckBox, RadioButton, ToogleButton
 * 
 * selected : ʼ״̬Ƿѡ
 * text : ʾı
 * enabled: ʼ״̬趨ǷԸı״̬
 */
FR.ToogleButton = FR.extend(FR.BaseEditor, {
	// ѡѡ״̬Ӧclass
	selected_class : 'x-checkbox-checkon',
	unselected_class : 'x-checkbox-checkoff',
	selected_disable_class : 'x-checkbox-checkon-disable',
	unselected_disable_class : 'x-checkbox-checkoff-disable',
	_init : function() {
		FR.ToogleButton.superclass._init.apply(this, arguments);
		
		var o = this.options = $.extend({
			selected : false,
			scope : this,
			render : true
		}, this.options);
		
		if (o.render == true) {
			/*
			 * alex:ԭ$("<div>"),ieͼ괦ȥȴûдclick¼,ĳspanͿ
			 * $("<span>").text(o.text)ieǲspan
			 */
			this.$btn = $("<span>" + (o.text || "&nbsp;") + "</span>").appendTo(this.element).addClass('x-text')
			.css('cursor', this.isEnabled() ? 'pointer' : 'default').click(function() {
				//james_modֻenabledʱ򣬲ܹı״̬
				 if (this.isEnabled()) {
				 	this.selected(!this.selected())
				 }
			}.createDelegate(this));
		} else {
			this.$btn = this.element;
			if (o.text !== null) {
				$("<span>" + o.text + "</span>").insertAfter(this.$btn);
			}
		}
		
		this.selected(o.selected)
		
		if ($.isFunction(o.handler)) {			
			this.$btn.click(o.handler.createDelegate(o.scope || this)
					.createInterceptor(this.isEnabled, this));
		}
	},
	
	/*
	 * Ƿѡ
	 * ûв,get;в,set
	 */
	selected : function() {
		if (arguments.length == 0) {
			// james:Ӧ״̬¶True
			return this.$btn.is('.' + this.selected_class) || this.$btn.is('.' + this.selected_disable_class);
		} else {
			var b = arguments[0] !== false
			this.$btn[b ? 'addClass' : 'removeClass'](this.isEnabled() ? this.selected_class : this.selected_disable_class)
			[b ? 'removeClass' : 'addClass'](this.isEnabled() ? this.unselected_class : this.unselected_disable_class)
			
			// richer:ݵڶҪҪstatechange¼
			if (arguments[1] != "noFireEvent"){
				// alex:״̬ı,ȻҪfireһ
				 this.fireEvent(FR.Events.STATECHANGE, this.selected());
			}
		}
	},
	
    destroy : function() {
        this.element.empty();
    }
});

//FR.TreeNodeToogleButton start
$.shortcut("treenode", "FR.TreeNodeToogleButton")
FR.TreeNodeToogleButton = FR.extend(FR.ToogleButton, {
	selected_class : 'x-treenode-unexpand',
	unselected_class : 'x-treenode-expand',
	son_array : undefined,
	expand_state : true,
	
	_init : function() {
		FR.TreeNodeToogleButton.superclass._init.apply(this, arguments);
		
		var o = this.options = $.extend({
			expand : false
		}, this.options);
		
		this.$btn.click(function(){
			this.treeNodeClick();
		}.createDelegate(this));
		
		this.fireEvent(FR.Events.AFTERINIT);
	},
	
	// ڵĵ
	treeNodeClick : function() {
		if (!this.options.sonarray) {
			// nothing
		} else {
			this.TreeNodeAction();
		}
		
		this.fireEvent(FR.Events.CLICK);
	},
	
	// 
	TreeNodeAction : function() {
		if (this.options.sonarray.length > 1) {
			var attr;
			// ʾ
			if (this.options.sonarray[0] == -1) {
				var tr;
				for (var i = 1; i < this.options.sonarray.length; i++) {
					tr = $("tr#r-" + this.options.sonarray[i] + "-" + this.options.reportIndex);
					if (!tr) continue;
					attr = tr.attr("nodestate");
					if (attr) {
						// carl:˵ǹŵ״̬Ҫ
						if (!this.expand_state) {
							attr--;
							if (attr <= 0) {
								tr.css("display", "");
								attr = 0;
							}
							tr.attr("nodestate", attr);
							
							// ie
								if ($.browser.msie) {
									var td;
									var td_state;
									$.each($("td", tr), function(index, item){
										td = $(item);
										td_state = td.attr("tdnodestate");
										if (td_state) {
											td_state--;
											td.attr("tdnodestate", td_state);
											if (td_state <= 0) td.css("display", "");
										}
									});
								}
						// carl:˵ǿŵ״̬Ҫص
						} else {
							attr++;
							// Ѿǹ˵״̬ͲҪ
							tr.attr("nodestate", attr);
							if (attr >= 1) {
								tr.css("display", "none");
							}
							
							// ie,ҪtdҲأ߿򲻻ʧ
								if ($.browser.msie) {
									var td;
									var td_state;
									$.each($("td", tr), function(index, item){
										td = $(item);
										td_state = td.attr("tdnodestate");
										if (td_state) {
											td_state++;
											td.attr("tdnodestate", td_state);
											td.css("display", "none");
										}
									});
								}
						}
					} else {
						// ĬصľͲڹϽΧ
						if (tr.css("display") != "none") {
							tr.attr("nodestate", 1).css("display", "none");
						}
						
						// ie,ҪtdҲأ߿򲻻ʧ
							if ($.browser.msie) {
								var td;
								var td_state;
								$.each($("td", tr), function(index, item){
									td = $(item);
									td_state = td.attr("tdnodestate");
									if (td_state) {
										td_state++;
										td.attr("tdnodestate", td_state);
										if (td_state >= 1) td.css("display", "none");
									} else {
										if (td.css("display") != "none") {
											td.attr("tdnodestate", 1).css("display", "none");
										}
									}
								});
							}
					}
				}
			// ʾǺ
			} else {
				var rowcount = this.options.sonarray[0];
				var td;
				for (var i = 1; i < this.options.sonarray.length; i++) {
					for (var j = 0; j < rowcount; j++) {
						td = $("td#" + FR.columnRow2CellStr({col: this.options.sonarray[i], row: j}) + "-" + this.options.reportIndex);
						if (!td) continue;
						attr = td.attr("tdnodestate");
						if (attr) {
							// carl:˵һ
							if (!this.expand_state) {
								attr--;
								if (attr <= 0) {
									td.css("display", "");
								}
								td.attr("tdnodestate", attr);
							} else {
								attr++;
								td.attr("tdnodestate", attr);
								if (attr >= 1) td.css("display", "none");
							}
						} else {
							// ĬصľͲڹϽΧ
							if (td.css("display") != "none") {
								td.attr("tdnodestate", 1).css("display", "none");
							}
						}
					}
				}
			}
		}
		this.expand_state = !this.expand_state;
	}
});

// FR.CheckBox start
$.shortcut("checkbox", "FR.CheckBox")
FR.CheckBox = FR.extend(FR.ToogleButton, {
	// ѡѡ״̬Ӧclass
	selected_class : 'x-checkbox-checkon',
	unselected_class : 'x-checkbox-checkoff',
	
	_init : function() {
		FR.CheckBox.superclass._init.apply(this, arguments);
		
		var o = this.options = $.extend({
			fieldName : ""
		}, this.options);

		this.$btn.css('margin-left', 5);
		// carl:һinput checkboxformύ
		if (o.sessionID){
			if (_g(o.sessionID).rtype == 'form') {
				var $par = $(this.$btn.parent());
				$par.css("background-color", "white");
				this.$box = $("<input type='checkbox'/>").css("display", "none").attr("name", o.fieldName).appendTo($par);
				this.$box.attr("value", o.fieldValue || o.value || '');
			}
		}
		// carl:ѡ鴫ֵfieldValue
		if (o.fieldValue) this.$btn.attr("value", o.fieldValue);
		// carlvalueǷǱߴ  ӵֵⲽҪ
		if (o.value == true || o.value == 'true') this.selected(true);
	},
	
	getValue : function() {
		return '' + this.selected();
	},
	
	setValue : function(state) {
		if (typeof state == 'boolean') {
			this.selected(state);
		} else if (state == 'true') {
			this.selected(true);
		} else if (state == 'false') {
			this.selected(false);
		}
	},
	
	startEditing : function() {
    	this.fireEvent(FR.Events.BEFOREEDIT);
    	this.$btn.show().focus();
	},
	
	stopEditing : function() {
		this.fireEvent(FR.Events.AFTEREDIT);
		this.$btn.blur();//hide();
	},
	
	reset : function() {
		this.selected(false);
	},
	
	selected : function() {
		if (arguments.length != 0) {
			var b = arguments[0] !== false
			if (this.$box) this.$box.attr("checked", b);
		}
		return FR.CheckBox.superclass.selected.apply(this, arguments);
	}
});
// FR.CheckBox end

// FR.Radio start
$.shortcut("radio", "FR.Radio")
$.extend(FR.Radio, {
	RadioButtonGroup : {}
});
FR.Radio = FR.extend(FR.ToogleButton, {
	// ѡѡ״̬Ӧclass
	selected_class : 'x-radio-radioon',
	unselected_class : 'x-radio-radiooff',
	
	_init : function() {
		FR.CheckBox.superclass._init.apply(this, arguments);
		
		var o = this.options = $.extend({
			fieldName : ""
		}, this.options);
		
		if (o.sessionID){
			// carl:һinput radioformύ
			if (_g(o.sessionID).rtype == 'form') {
				var $par = $(this.$btn.parent());
				$par.css("background-color", "white");
				this.$radio = $("<input type='radio'/>").css("display", "none").attr("name", o.name || o.fieldName).appendTo($par);
				this.$radio.attr("value", o.fieldValue || o.value || '');
			}
		}
		// carl:ѡ鴫ֵfieldValue
		if (o.fieldValue) this.$btn.attr("value", o.fieldValue);
		// carlvalueǷǱߴ  ӵֵⲽҪ
		if (o.value == 'true' || o.value == true) this.selected(true);
	},
	
	getValue : function() {
		return '' + this.selected();
	},
	
	setValue : function(state) {
		if (typeof state == 'boolean') {
			this.selected(state);
		} else if (state == 'true') {
			this.selected(true);
		} else if (state == 'false') {
			this.selected(false);
		}
	},
	
	startEditing : function() {
    	this.fireEvent(FR.Events.BEFOREEDIT);
    	this.$btn.show().focus();
	},
	
	stopEditing : function() {
		this.fireEvent(FR.Events.AFTEREDIT);
		this.$btn.blur().hide();
	},
	
	// select(false)ûЧģҪreset
	reset : function() {
		this.$btn.removeClass(this.selected_class).addClass(this.unselected_class);
	},
	
	/*
	 * Ƿѡ
	 * ûв,get;в,set
	 */
	selected : function() {
		if (arguments.length == 0) {
			return this.$btn.is('.' + this.selected_class)
		} else {
			/*
			 * alex:ѡ״̬,ҪԼѡ,Ҫ$.FR.Radio.RadioButtonGroupͬRadioButton䲻ѡ
			 */
			if (arguments[0] !== false) {
				var n = this.options.name;
				if (n != null) {
					$.each(this._belongs(), function(idx, rb_el) {
						rb_el.$btn.removeClass(this.selected_class).addClass(this.unselected_class)
					})
				}
				this.$btn.addClass(this.selected_class).removeClass(this.unselected_class);
				if (this.$radio) this.$radio.attr("checked", true);
			
				// alex:״̬ı,ȻҪfireһ
				this.fireEvent(FR.Events.STATECHANGE);
			} 
			// alex:ǰ״̬ѡ״̬,ù,ֻΪ˳ʼΪfalseʱ
			else if (!this.selected()) {
				this.$btn.addClass(this.unselected_class)
			}
		}
	},
	
	/*
	 * ȡøRadioButtonButtonGroup
	 */
	_belongs : function() {
		var n = this.options.name;
		if (n != null) {
			var g = $.FR.Radio.RadioButtonGroup;
			if (g[n] == null) {
				g[n] = []
			}
			
			if ($.inArray(this, g[n]) < 0) {
				g[n].push(this)
			}
			
			return g[n]
		}
		
		// alex:֤null
		return [];
	}
});
// FR.Radio end

// FR.List
$.shortcut("tlist", "FR.List");
FR.List = FR.extend(FR.BaseEditor, {
	_init : function(){
		FR.List.superclass._init.apply(this, arguments);
		var o = this.options = $.extend({
		  	baseCls : "fr-list",
		  	width : 120,
		  	height : 150
		}, this.options);
		this.element.addClass(o.baseCls);
		if (o.width > -1) {
			this.element.css({width : o.width});
		}
		if (o.height > -1) {
			this.element.css({height : o.height});
		}
		var self = this;
		this.content = new FR.Panel({
			renderTo : this.element,
			width : o.width,
			height : o.height,
			title : "&nbsp",
			toolPosition : "left",
			dosize : true,
			collapsible : false,
			tools : [
			{
				// delete
				iconCls : "fr-panel-tool-close",
				handler : function() {
					var item = $(".fr-list-node-selected", self.element).data("item");
					if (item) {
						self.remove(item);
					}
				}
			},{
				// add
				iconCls : "fr-panel-tool-max",
				handler : function() {
					var len = self.options.items.length;
					var text = prompt("", "item" + (len + 1));
					if (text) {
						self.addItem({text : text, value : text});
					}
				}
			}
			]
		});
		this.listBody = this.content.element.find(">div.fr-panel-body");
		if (!o.items) {
			this.listBody.html($('<div class="fr-panel-loading"></div>').html("loading..."));
			this._getItems();
		}
		this._setItems(o.items);
	},
	
	_getItems : function() {
		var o = this.options;
		$.ajax({
			url : o.widgetUrl,
			type : "POST",
			cache : false,
			async : false,
			complete : function(res) {
				if (!FR.versionRemind(res.responseText)) return;
	        	o.items = FR.jsonDecode(res.responseText) || [];			
			}
		});	
	},
	_setItems : function(items) {
		var self = this;
		this.listBody.empty();
		$.each(items, function(idx, it) {
    		self._addItemContent(idx, it);
    	});
	},	
	_addItemContent : function(idx, item) {
		var self = this;
		$('<div>').appendTo(self.listBody)
			.height(20).text(item.text)
    		.attr("title", item.text)
    		.addClass('x-combo-list-item')
    		.hover(function(){
					$(this).addClass("fr-list-node-over ");
				}, function(){
					$(this).removeClass("fr-list-node-over ");
				})
    		.click(function(e) {
    			// סctrlԶѡ
    			//if (!e.ctrlKey) {
    			self.listBody.find(">div.fr-list-node-selected").removeClass("fr-list-node-selected");
    			//}		
				$(this).addClass("fr-list-node-selected");
				self.options.currentItem = item;
    		}).data("item", item);
	},
	addItem : function(item) {
		var items = this.options.items;
		var len = items.length;
		items.push(item);
		// עⰡ,ʹõԭitemsĳ
		this._addItemContent(len, item);
	},
	remove : function(item) {
		var items = this.options.items;
		items.remove(item);
		$(".x-combo-list-item", this.element).each(function(i, it){
			var data = $(this).data("item");
			if (data == item) {
				$(this).remove();
			}
		});
	},
	removeAll : function() {
		this.options.items = [];
		this.listBody.empty();
	},
	getText : function() {
		return this.options.currentItem.text;
	},
	getValue : function() {
		return this.options.currentItem.value;
	},
	doResize : function(give) {
		this.content.doResize(give);
	}
});
// FR.List .end




