// jquery.ux.js
;$.extend(Array.prototype, {
    /**
     * Checks whether or not the specified object exists in the array.
     * @param {Object} o The object to check for
     * @return {Number} The index of o in the array (or -1 if it is not found)
     */
    indexOf : function(o){
       for (var i = 0, len = this.length; i < len; i++){
 	      if(this[i] == o) return i;
       }
 	   return -1;
    },
    
    /**
     * Removes the specified object from the array.  If the object is not found nothing happens.
     * @param {Object} o The object to remove
     * @return {Array} this array
     */
    remove : function(o){
       var index = this.indexOf(o);
       if(index != -1) {
           this.splice(index, 1);
       }
       return this;
    }
});

// richer:jQueryӵ÷
$.fn.swapClass = function(c1, c2) {
   return this.removeClass(c1).addClass(c2);
}
$.fn.switchClass = function(c1, c2) {
   if (this.hasClass(c1)) {
       return this.swapClass(c1, c2);
   } else { 
        return this.swapClass(c2, c1);
   }
}

//String methods
$.extend(String, {

    /**
     * Escapes the passed string for ' and \
     * @param {String} string The string to escape
     * @return {String} The escaped string
     * @static
     */
    escape : function(string) {
        return string.replace(/('|\\)/g, "\\$1");
    },

    /**
     * Pads the left side of a string with a specified character.  This is especially useful
     * for normalizing number and date strings.  Example usage:
     * <pre><code>
var s = String.leftPad('123', 5, '0');
// s now contains the string: '00123'
</code></pre>
     * @param {String} string The original string
     * @param {Number} size The total length of the output string
     * @param {String} char (optional) The character with which to pad the original string (defaults to empty string " ")
     * @return {String} The padded string
     * @static
     */
    leftPad : function (val, size, ch) {
        var result = new String(val);
        if(!ch) {
            ch = " ";
        }
        while (result.length < size) {
            result = ch + result;
        }
        return result.toString();
    },

    /**
     * Allows you to define a tokenized string and pass an arbitrary number of arguments to replace the tokens.  Each
     * token must be unique, and must increment in the format {0}, {1}, etc.  Example usage:
     * <pre><code>
var cls = 'my-class', text = 'Some text';
var s = String.format('<div class="{0}">{1}</div>', cls, text);
// s now contains the string: '<div class="my-class">Some text</div>'
</code></pre>
     * @param {String} string The tokenized string to be formatted
     * @param {String} value1 The value to replace token {0}
     * @param {String} value2 Etc...
     * @return {String} The formatted string
     * @static
     */
    format : function(format){
        var args = Array.prototype.slice.call(arguments, 1);
        return format.replace(/\{(\d+)\}/g, function(m, i){
            return args[i];
        });
    }
});
$.extend(String.prototype, {
    indexReg : function(f, m) {
		var mm = (m == false) ? "i":"";
		var re = eval("/"+ f +"/"+mm);
		var rt = this.match(re);
		return (rt == null) ? -1:rt.index; 
	},
    startWith : function(str) {
		if(str==null||str==""||this.length==0||str.length>this.length) {
			 return false;
		}
	    if(this.substr(0,str.length)==str) {
		     return true;
	    } else {
		     return false;
		}
		return true;
    },
    endWith : function(str){
    	if(str==null||str==""||this.length==0||str.length>this.length) {
   	     	return false;
    	}
    	if(this.substring(this.length-str.length)==str) {
   	     	return true;
    	} else {
    		return false;
    	}
    	return true; 
    }, 
    // richer:ȡַеĲ
    getQuery : function(name){
             var reg = new RegExp("(^|&)"+ name +"=([^&]*)(&|$)");  
           var r = this.substr(this.indexOf("\?")+1).match(reg);  
           if (r!=null) return unescape(r[2]); return null;  
    }
});

// Function
// richer:ʹ÷Բοhttp://www.extjs.com/learn/Manual:Utilities:Function_(Chinese)
$.extend(Function.prototype, {
/**
 * Creates a callback that passes arguments[0], arguments[1], arguments[2], ...
 * Call directly on any function. Example: <code>myFunction.createCallback(myarg, myarg2)</code>
 * Will create a function that is bound to those 2 args.
 * @return {Function} The new function
 */
    createCallback : function(/*args...*/) {
        // make args available, in function below
        var args = arguments;
        var method = this;
        return function() {
            return method.apply(window, args);
        };
    },

/**
 * Creates a delegate (callback) that sets the scope to obj.
 * Call directly on any function. Example: <code>this.myFunction.createDelegate(this)</code>
 * Will create a function that is automatically scoped to this.
 * @param {Object} obj (optional) The object for which the scope is set
 * @param {Array} args (optional) Overrides arguments for the call. (Defaults to the arguments passed by the caller)
 * @param {Boolean/Number} appendArgs (optional) if True args are appended to call args instead of overriding,
 *                                             if a number the args are inserted at the specified position
 * @return {Function} The new function
 */
    createDelegate : function(obj, args, appendArgs) {
        var method = this;
        return function() {
            var callArgs = args || arguments;
            if (appendArgs === true) {
                callArgs = Array.prototype.slice.call(arguments, 0);
                callArgs = callArgs.concat(args);
            } else if (typeof appendArgs == "number") {
                callArgs = Array.prototype.slice.call(arguments, 0);
                // copy arguments first
                var applyArgs = [appendArgs, 0].concat(args);
                // create method call params
                Array.prototype.splice.apply(callArgs, applyArgs);
                // splice them in
            }
            return method.apply(obj || window, callArgs);
        };
    },

    /**
     * Creates an interceptor function. The passed fcn is called before the original one. If it returns false, the original one is not called.
     * The resulting function returns the results of the original function.
     * The passed fcn is called with the parameters of the original function.
     * @addon
     * @param {Function} fcn The function to call before the original
     * @param {Object} scope (optional) The scope of the passed fcn (Defaults to scope of original function or window)
     * @return {Function} The new function
     */
    createInterceptor : function(fcn, scope){
        if(typeof fcn != "function"){
            return this;
        }
        var method = this;
        return function() {
            fcn.target = this;
            fcn.method = method;
            if(fcn.apply(scope || this || window, arguments) === false){
                return;
            }
            return method.apply(this || window, arguments);
        };
    },

    /**
     * Calls this function after the number of millseconds specified.
     * @param {Number} millis The number of milliseconds for the setTimeout call (if 0 the function is executed immediately)
     * @param {Object} obj (optional) The object for which the scope is set
     * @param {Array} args (optional) Overrides arguments for the call. (Defaults to the arguments passed by the caller)
     * @param {Boolean/Number} appendArgs (optional) if True args are appended to call args instead of overriding,
     *                                             if a number the args are inserted at the specified position
     * @return {Number} The timeout id that can be used with clearTimeout
     */
    defer : function(millis, obj, args, appendArgs){
        var fn = this.createDelegate(obj, args, appendArgs);
        if(millis){
            return setTimeout(fn, millis);
        }
        fn();
        return 0;
    },
    /**
     * Create a combined function call sequence of the original function + the passed function.
     * The resulting function returns the results of the original function.
     * The passed fcn is called with the parameters of the original function
     * @param {Function} fcn The function to sequence
     * @param {Object} scope (optional) The scope of the passed fcn (Defaults to scope of original function or window)
     * @return {Function} The new function
     */
    createSequence : function(fcn, scope){
        if(typeof fcn != "function"){
            return this; 
        }
        var method = this;
        return function() {
            var retval = method.apply(this || window, arguments);
            fcn.apply(scope || this || window, arguments);
            return retval;
        };
    }
});

// FR
if (window.FR == null) {
	window.FR = {};
}
$.extend(FR, {
    emptyFn : function() {},
    
    // FR.constantһЩ
    constant : {
    	success : "success",
    	failure : "failure"
    },
    
    isArray : function(a) {
    	return Object.prototype.toString.call(a) == '[object Array]' || a instanceof jQuery
    },
    
    applyStyles : function($el, styles) {
		if (styles) {
			if (typeof styles == "string") {
				var re = /\s?([a-z\-]*)\:\s?([^;]*);?/gi;
				var matches;
				while ((matches = re.exec(styles)) != null) {
					$el.css(matches[1], matches[2]);
				}
			} else if (typeof styles == "object") {
				$el.css(styles);
			} else if (typeof styles == "function") {
				FR.applyStyles(dom, styles.call());
			}
		}
	},
	
	/*
	 * alex:Լevt(ڶλ)ɲ˵
	 * 
	 * evtPosition:
	 * 		true---evtλýжλ
	 * 		false--evttargetλýжλ
	 */
	showMenuByEvent : function(o, evt, evtPosition) {
		if (evtPosition === true) {
			FR.showMenuByOffset(o, {
				left : evt.clientX, top : evt.clientY + 10
			});
		} 
		// alex:evt.targetλýжλ
		else if (evt.target) {
			FR.showMenuByEl(o, $(evt.target));
		} else {
			// james:IEõevtmouseEvent,ֻһͨEventûtarget
			FR.showMenuByOffset(o, {
				left : evt.clientX, top : evt.clientY + 10
			})
		}
	},
    
	/*
	 * richer:ɲ˵ʾ
	 */
	showMenuByEl : function(o, $el) {
		FR.showMenuByOffset(o, {
			left : $el.offset().left, top : $el.offset().top + $el.height() + 1
		});
	},
	
	/*
	 * alex:lefttopʾ˵
	 * offset : {left, top}
	 */
	showMenuByOffset : function(o, offset) {
	    var menu = FR.createMenu(o);
		menu.show();
		menu.$eDIV.css({left : offset.left, top : offset.top})
	},
	
	versionRemind : function(o) {
		if (o == "failpass") {
			this.Msg.alert(this.i18n.Info, this.i18n.failpass);
			return false;
		}
		return true;
	},
	
    /*
	 * ɲ˵,ڵ[Excel, PDF, Word],Լ೬ minWidth 
	 * items : [{src:ʾ, handler:Ӧĵ¼}] 
	 * destroyOnClose : true or false
	 */
    createMenu : function(o) {
    	o = $.extend({
    		minWidth : 80,
    		destroyOnClose : true
    	}, o);
    	
    	// richer:ÿ˵Ӹı	
    	for (var i = 0; i < o.items.length; i ++){
    		o.items[i].menuIndex = i;
    	}
    	var menuItems = o.items;
    	
    	var options = {
			minWidth : o.minWidth,
			onClick : function(e, item) {
				$.each(menuItems, function(idx, menuItem) {
					// richer:ձclick¼
					if (idx == item.menuIndex) {
						menuItem.handler.call(this, e, item);
						item.parentMenu.hide();
						return false;
					}
				});
			},
			
			onClose : function() {
				o.destroyOnClose && this.destroy();
			}
		};
		return new $.Menu($("<div/>"), menuItems, options);
    },
    
    /*
	 * ,ֻһ,ֱȥ,ж,Ҫ˵
	 */
    doHyperlink : function() {
    	function _doHyperlink(data) {
    		// carl:ﲻdecode˰,򴫵Ķ
    		eval(unescape(data));
		}

		/*
		 * evt¼,λ˵λ
		 * obj [{url, targetFrame, features}] ڳ
		 */
		// carl:ӸevtPositionȷmenu
		return function(evt, obj, evtPosition) {
			if (FR.isArray(obj)) {
				switch(obj.length) {
					case 0:
						return;
					// alex:,ҳֻ1,ҪԵmenuķʽ
					case 1:
						FR.doHyperlink(evt, obj[0]);
						break;
					// alex:,ҳֻ1,ҪԵmenuķʽ
					default:
			    		FR.showMenuByEvent({
			    			items : $.map(obj, function(cfg) {
				    			return {
				    				src : cfg.name,
				    				handler : _doHyperlink.createCallback(cfg.data)
				    			}
				    		})
			    		}, evt, evtPosition || false);
				}
			} else {
				_doHyperlink(obj.data)
			}
		}
    }(),
    
 
    doHyperlinkByGet : function(url, para, target, feature) {
    	if(url.indexOf("?") == -1){
    		url += "?";
    	}
    	var pString = "";
    	if (para){
    		$.each(para, function(pName, pValue) {
    			pString += "&" + pName + "=" + pValue;
    		});
    	}
    	url += pString.substring(0);
    	window.open(url, target, feature);
    },
    doHyperlinkByPost : function(url, para, target, feature) {  
    	var jsonstr = FR.json2str(para);
    	if (this.$hyperlinkForm) {
    		this.$hyperlinkForm.html("");
    	} else {
    		this.$hyperlinkForm = ($("<div>").appendTo($(document.body))).css({"display":"none", "position":"absolute"});
    	}
    	// עд$("<form></form>"),IE޷ύ
    	var submitForm = $("<form method='post' target='" + target + "' action='" + url + "'></form>").appendTo(this.$hyperlinkForm); 
    	var html = "";
    	html += "<input type=\"hidden\" name=\"__parameters__\" value=\""+ FR.json2str(para)+ "\"/>";
    	submitForm.html(html);
    	submitForm.submit();  	
    },
    sentEMail : function(mail) {
    	 window.location = mail;
         return;
    },  
    // ע⣺ʹõת {p1 : "value1", p2 : "valu2"}תΪַʱתΪ"{'p1':value1,'p2':value2}"
    json2str : function(o) {
    	var arr = [];
   	 	var fmt = function(s) {
   	 		if (typeof s == 'object' && s != null) return FR.json2str(s);
   	 		if (typeof s == 'string') {
   	 			// carl:Լת
   	 			s = s.replace(/'/g, "%fr27");
   	 			s = s.replace(/"/g, '%fr22');
   	 			return "'" + s + "'";
   	 		}
   	        return s;
   	 	}
   	 // richer:esapseһҪ,"'""""
   	 for (var i in o) arr.push("'" + i + "':" + fmt(o[i]));
   	         return '{' + arr.join(',') + '}';
    },

    /*
     * תʽString
     * {abc}str = \{abc\},new Regex(str)ƥ{abc}ʽ
     */
    toRE : function(str) {
        return str.replace(/\\/g, "\\\\")
                .replace(/\[/g, "\\[")
                .replace(/\]/g, "\\]")
                .replace(/\(/g, "\\(")
                .replace(/\)/g, "\\)")
                .replace(/\{/g, "\\{")
                .replace(/\}/g, "\\}")
                .replace(/\*/g, "\\*")
                .replace(/\|/g, "\\|")
                .replace(/\?/g, "\\?")
                .replace(/\$/g, "\\$")
                .replace(/\^/g, "\\^")
    },

    /*
     * JSļ̳
     * 
     * FR.extend(ClassA, ClassB, {
     *     a1 : v1,
     *     a2 : v2
     * })
     * 
     * ClassBClassAsuperclass
     */
    extend : function() {
        // inline overrides
        var io = function(o) {
            for (var m in o) {
                this[m] = o[m];
            }
        };
        return function(sb, sp, overrides) {
            if (typeof sp == 'object') {
                overrides = sp;
                sp = sb;
                sb = function() {
                    sp.apply(this, arguments);
                };
            }
            var F = function() {
            }, sbp, spp = sp.prototype;
            F.prototype = spp;
            sbp = sb.prototype = new F();
            sbp.constructor = sb;
            sb.superclass = spp;
            if (spp.constructor == Object.prototype.constructor) {
                spp.constructor = sp;
            }
            $.extend(sb.prototype, overrides);
            return sb;
        };
    }(),
    
    /*
     * htmlҳеSessionID -> ReportPane
     */
    SessionMgr : function() {
    	var m = {};
	    
	    /*
	     * alex:unloadʱصsession TODO ϴûasync:false + unbindʱie
	     */
	    $(window).unload(function() {
	    	$(window).unbind('unload', arguments.callee);
	    	
	    	for(var id in m) {
	    		if (m[id].servletURL) {
		    		$.ajax({
						async : false,
		    			url : m[id].servletURL,
		    			data : {op : 'closesessionid', sessionID : id}
		    		})
	    		}
	    	}
	    })
	    
    	return {
    		get : function(id) {
    			return m[id]
    		},
    		register : function(id, s) {
    			m[id] = s;
    		},
    		unregister : function(id) {
    			delete m[id];
    		},
    		clear : function() {
    			m = {};
    		},
    		all : m
    	}
    }(),

    //james: cjkEncode
    cjkEncode : function(text) {
    	// alex:ַ,䱾(cjkEncode(234)  ""ǲԵ)
    	if (typeof text !== 'string') {
    		return text;
    	}

        var newText = "";
        for (var i = 0; i < text.length; i++) {
            var code = text.charCodeAt(i);
            if (code >= 128 || code == 91 || code == 93) {//91 is "[", 93 is "]".
                newText += "[" + code.toString(16) + "]";
            } else {
                newText += text.charAt(i);
            }
        }

        return newText
    },
    //james: cjkDecode
    cjkDecode : function(text) {
         if (text == null) {
            return "";
        }
        //û "[", ֱӷ.
        if(text.indexOf('[') == -1) {
            return text;
        }

        var newText = "";
        for (var i = 0; i < text.length; i++) {
            var ch = text.charAt(i);
            if(ch == '[') {
                var rightIdx = text.indexOf(']', i + 1);
                if (rightIdx > i + 1) {
                    var subText = text.substring(i + 1, rightIdx);
                    //jamesҪǿ[CDATA[]]ֵĳ
                    if(subText.length > 0) {
                        ch = String.fromCharCode(eval("0x"+ subText));
                    }

                    i = rightIdx;
                }
            }

            newText += ch;
        }

        return newText;
    },

    //replace the space(&nbsp;) of html with " "
    //Only "&nbsp;" need to be decoded, because "&amp;", "&lt;", "&gt;", "&apos;" and "&quot;"
    //can be paresed correctly by the org.w3c.dom to the eaxctly values '&', "<", ">", "'", """
    htmlSpaceDecode : function(text) {
        return (text == null) ? '' : String(text).replace(/&nbsp;/, ' ');
    },
    //replace the html special tags
	htmlEncode : function(text) {
        return (text == null) ? '' : String(text).replace(/&/g,'&amp;').replace(/\"/g,'&quot;').replace(/</g,'&lt;').replace(/>/g,'&gt;');
	},
    //html decode
	htmlDecode : function(text) {
        return (text == null) ? '' : String(text).replace(/&amp;/g,'&').replace(/&quot;/g,'\"').replace(/&lt;/g,'<').replace(/&gt;/g,'>').replace(/&nbsp;/g,' ');
	},
    //json encode
    jsonEncode : function(o) {
        //james:EncodeǳEXT
        var useHasOwn = {}.hasOwnProperty ? true : false;

        // crashes Safari in some instances
        //var validRE = /^("(\\.|[^"\\\n\r])*?"|[,:{}\[\]0-9.\-+Eaeflnr-u \n\r\t])+?$/;

        var m = {
            "\b": '\\b',
            "\t": '\\t',
            "\n": '\\n',
            "\f": '\\f',
            "\r": '\\r',
            '"' : '\\"',
            "\\": '\\\\'
        };

        var encodeString = function(s){
            if (/["\\\x00-\x1f]/.test(s)) {
                return '"' + s.replace(/([\x00-\x1f\\"])/g, function(a, b) {
                    var c = m[b];
                    if(c){
                        return c;
                    }
                    c = b.charCodeAt();
                    return "\\u00" +
                        Math.floor(c / 16).toString(16) +
                        (c % 16).toString(16);
                }) + '"';
            }
            return '"' + s + '"';
        };

        var encodeArray = function(o){
            var a = ["["], b, i, l = o.length, v;
                for (i = 0; i < l; i += 1) {
                    v = o[i];
                    switch (typeof v) {
                        case "undefined":
                        case "function":
                        case "unknown":
                            break;
                        default:
                            if (b) {
                                a.push(',');
                            }
                            a.push(v === null ? "null" : FR.jsonEncode(v));
                            b = true;
                    }
                }
                a.push("]");
                return a.join("");
        };

        if(typeof o == "undefined" || o === null){
            return "null";
        }else if(FR.isArray(o)){
            return encodeArray(o);
        }else if(o instanceof Date){
			/*
			 * alex:ԭֻǰʱ򵥵ƴһString,޷decode
			 * ôͿdecode,JS.jsonDecodeJava.JSONObjectҲҪŸһ
			 */
            return FR.jsonEncode({__time__ : o.getTime()})
        }else if(typeof o == "string"){
            return encodeString(o);
        }else if(typeof o == "number"){
            return isFinite(o) ? String(o) : "null";
        }else if(typeof o == "boolean"){
            return String(o);
        }else if ($.isFunction(o)) {
        	return String(o);
        }else {
            var a = ["{"], b, i, v;
            for (i in o) {
                if(!useHasOwn || o.hasOwnProperty(i)) {
                    v = o[i];
                    switch (typeof v) {
                    case "undefined":
                    case "unknown":
                        break;
                    default:
                        if(b){
                            a.push(',');
                        }
                        a.push(FR.jsonEncode(i), ":",
                                v === null ? "null" : FR.jsonEncode(v));
                        b = true;
                    }
                }
            }
            a.push("}");
            return a.join("");
        }
    },
    //json decode
    jsonDecode : function(text) {
    	if (text == null) {
    		return {};//jamesûݷһ
    	}
    	try {
    		return (function(o) {
    			if (o.__time__ != null) {
    				return new Date(o.__time__);
    			}
    			
    			for (var a in o) {
    				// richer:ѭ磺oΪ's'ʱarguments.callee(o[a])Ȼ's'Ȼѭ
    				// carl:ȡ󼴿ɣȥ
    				if (o[a] == o || typeof o[a] == 'object' || $.isFunction(o[a])) {
    					break;
    				}
    				o[a] = arguments.callee(o[a]);
    			}
    			
    			return o;
    		})(eval('(' + text + ')'));
    	} catch (e) {
    		//дʱ򣬷һյĶ󣬲ȻĳЩʱӷ˲ܷʱͻᱨJS󣬸ûо
    		//jamesΣҲͲ
    		return [];//evalһյ飬òjsonDecodeʱ򣬴ӷ˴αȽ϶ЩҲtext==null
    	}
    },
	
    convertJavaDateFormat2JS : function(fmt) {
        if (!fmt) return '';
        //
        fmt =  String(fmt)
                //
                .replace(/y{4,}/g, 'Y')//yyyyʱ滻ΪY
                .replace(/y{2}/g, 'y')//yyʱ滻Ϊy
                //
        if (new RegExp('M{2,}', 'g').test(fmt)){
        	fmt = fmt.replace(/M{4,}/g, 'M')//MMMMʱ滻ΪM
                	 .replace(/M{2}/g, 'm')//MMʱ滻Ϊm               
       	 } else {
       	 	fmt = fmt.replace(/M{1}/g, 'n') // M滻Ϊ·ݣλ
       	 }
                
         //
        fmt = fmt.replace(/E{4,}/g, 'l');//EEEEʱ滻lʾڼ
        //
        if (new RegExp('d{2,}', 'g').test(fmt)) {
            fmt = fmt.replace(/d{2,}/g, 'd');//ddʱ滻Ϊd
        } else {
            fmt = fmt.replace(/d{1}/g, 'j');//dʱ滻Ϊj
        }
        //ʱ
        if (new RegExp('h{2,}', 'g').test(fmt)) {//12Сʱ
            fmt = fmt.replace(/h{2,}/g, 'h');
        } else {
            fmt = fmt.replace(/h{1}/g, 'g');
        }
        if (new RegExp('H{2,}', 'g').test(fmt)) {//24Сʱ
            fmt = fmt.replace(/H{2,}/g, 'H');
        } else {
            fmt = fmt.replace(/H{1}/g, 'G');
        }
        fmt = fmt.replace(/m{2,}/g, 'i')//
                //
                .replace(/s{2,}/g, 's')
                //
                .replace(/z+/g, 'T');
        
        return fmt;
    },
    // richer:Ŀǰڿؼpaser,jquery.ux.date.jsformat̫
    parseFmt : function(fmt){
		 if (!fmt) return '';
        //
        fmt =  String(fmt)
                //
                .replace(/y{4,}/g, '%Y')//yyyyʱ滻ΪY
                .replace(/y{2}/g, '%y')//yyʱ滻Ϊy
                //
                .replace(/M{4,}/g, '%b')//MMMMʱ滻Ϊb
                .replace(/M{3}/g, '%B')//MMMʱ滻ΪM
                .replace(/M{2}/g, '%X')//MMʱ滻ΪX08
                .replace(/M{1}/g,'%x')//Mʱ滻Ϊx8
                .replace(/a{1}/g, '%p')
        //
        if (new RegExp('d{2,}', 'g').test(fmt)) {
            fmt = fmt.replace(/d{2,}/g, '%d');//ddʱ滻Ϊd
        } else {
            fmt = fmt.replace(/d{1}/g, '%e');//dʱ滻Ϊj
        }
        //ʱ
        if (new RegExp('h{2,}', 'g').test(fmt)) {//12Сʱ
            fmt = fmt.replace(/h{2,}/g, '%I');
        } else {
            fmt = fmt.replace(/h{1}/g, '%I');
        }
        if (new RegExp('H{2,}', 'g').test(fmt)) {//24Сʱ
            fmt = fmt.replace(/H{2,}/g, '%H');
        } else {
            fmt = fmt.replace(/H{1}/g, '%G');
        }
        fmt = fmt.replace(/m{2,}/g, '%M')//
                //
                .replace(/s{2,}/g, '%S')
        
        return fmt;
	},
    
    //jamesжcǷpУp==cʱҲʾ
    contains : function(p, c) {
    	return FR.isAncestor(p, c) ? true : ((!p || !c) ? false : p == c);
    },
    
    //jamesжpǲc,p,cDOM
    isAncestor : function(p, c) {
    	//p = $(p);
        //c = $(c);
        if (!p || !c) {return false;}

        if(p.contains && !$.browser.safari) {
        	try {
            	return p.contains(c);//james:IEлᱨno such interface supported
        	} catch (e) {
        		//do nothing
            }
        }
        if(p.compareDocumentPosition) {
            return !!(p.compareDocumentPosition(c) & 16);
        } else {
            var parent = c.parentNode;
            while (parent) {
                if (parent == p) {
                    return true;
                }
                else if (!parent.tagName || parent.tagName.toUpperCase() == "HTML") {
                    return false;
                }
                parent = parent.parentNode;
            }
            return false;
        }
    },
    
    isNavKeyPress : function(event){
    	if (!event) return false;
    	var safariKeys = {
	        63234 : 37, // left
	        63235 : 39, // right
	        63232 : 38, // up
	        63233 : 40, // down
	        63276 : 33, // page up
	        63277 : 34, // page down
	        63272 : 46, // delete
	        63273 : 36, // home
	        63275 : 35  // end
	    };
        var k = event.keyCode;
        k = $.browser.safari ? (safariKeys[k] || k) : k;
        return (k >= 33 && k <= 40) || k == 13 || k == $.keyCode.TAB || k == $.keyCode.ESCAPE;
    },
    
    isSpecialKey : function(e){
    		if (!e) return false;
            var k = e.keyCode;
            return (e.type == 'keypress' && e.ctrlKey) || k == 9 || k == 13  || k == 40 || k == 27 ||
            (k == 16) || (k == 17) ||
            (k >= 18 && k <= 20) ||
            (k >= 33 && k <= 35) ||
            (k >= 36 && k <= 39) ||
            k == 44 || (k == 13 || k == 229);//richer:뷨ֱ༭ֵbug
    },
    //jamesһObjectStringJSONĸʽдһStringObjecttoString
    object2String : function(obj) {
    	if (obj == null) {
    		return '';
    	}
    	if (typeof obj == 'object') {
    		var str = '';
    		for (var key in obj) {
    			if (str) {
    				str += ',';
    			}
    			var value = obj[key];
    			if (typeof value == 'object') {
    				value = FR.object2String(value);
    			}
    			str += key + ':' + FR.jsonEncode(value);
    		}
    		if (str) {
    			str = '{' + str + '}';
    		}
    		
    		return str;
    	}
    	
    	return obj;
    },
	
	equals : function(v1, v2) {
		if (!v1 || !v2) {
			return (!v1 && !v2);
		}
		if (v1 == v2) {
			return true;
		} else if (FR.isArray(v1)) {
	    	if (v1.length == v2.length) {
	    		for (var i = 0; i < v1.length; i++) {
	    			if (!FR.equals(v1[i], v2[i])) {
	    				return false;
	    			}
	    		}
	    	} else {
	    		return false;
	    	}
	    } else if (typeof v1 == 'object') {
	    	for (var a in v1) {
	    		if (!FR.equals(v1[a], v2[a])) {
	    			return false;
	    		}
	    	}
	    } else {
	    	return v1 === v2
	    }
	    
	    return true;
	},
	
	/*
 	 * ԪString, Object֮ת
 	 * carlwriteǱ߰
 	 */
	// "A3-1"->"A3"
	id2ColumnRowStr : function(id) {
		return id.replace(/([A-Z]+\d+)-\d+/, "$1");
	},
	
	// "A2-2"->{col, row}
	id2ColumnRow : function(id) {
		return FR.cellStr2ColumnRow(FR.id2ColumnRowStr(id));
	},
	
	// "A3-4"{rptIdx, col, row}
	id2Location : function(id) {
		var rt = FR.id2ColumnRow(id);
	    var arr = id.split("-");
	    rt.rptIdx = arr[1];
	    return rt
	},
	
	// "A3"->{col, row}
	cellStr2ColumnRow : function(name) {
	    name = $.trim(name.toUpperCase());
	    if (name.match(/^[A-Z]+\d+$/) == null)
	        return null;
		var colStr = name.replace(/([A-Z]+)\d+/, "$1")
		var rowStr = name.replace(/[A-Z]+(\d+)/, "$1")
		var len = colStr.length;
		var col = FR.letter2Digit(colStr) - 1;
	
		var row = parseInt(rowStr) - 1;
	
	    return {col:col, row:row}
	},
	
	// {col, row}->"A3"
	columnRow2CellStr : function(cr) {
	    var col = parseInt(cr.col);
	    var row = parseInt(cr.row);
	    
	    if(typeof col != "number" || typeof row != "number") {
	        return "";
	    }
	
	    return FR.digit2Letter(col + 1) + (row + 1);
	}, 
	
	// "A"->1
	letter2Digit : function(abc) {
    	var len = abc.length;
		var col = 0;
		for(var i = len - 1; i >=0; i--) {
			var c = abc.charAt(i);
			col += (COL_IDS.indexOf(c) + 1) * Math.pow(26, len - 1 - i);
		}
	    return col;
	},
	
	// 1->"A"
	digit2Letter : function(k) {
	    var c, abcBuf = "";
	
	    if (typeof k != 'number' || k == 0 || isNaN(k) || !isFinite(k)) {
	        return abcBuf;
	    }
	
	    for (; k != 0;) {
	        c = k % 26;
	        if (c == 0) {
	            c = 26;
	        }
	        abcBuf = COL_IDS.charAt(c - 1) + abcBuf;
	        k = (k - c) / 26;
	    }
	
	    return abcBuf;
	}
});

var COL_IDS = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";

// FR.SessionMgr.get
if (window._g == null) {
	window._g = FR.SessionMgr.get;	
}

/*
 * Ӽ˳ľȷĶ
 * 
 * marks:Ϊ˾ȷ
 */
$.extend(FR, {
	accDiv : function(arg1, arg2) {
		var t1 = 0, t2 = 0, r1, r2;
		try {
			t1 = arg1.toString().split(".")[1].length
		} catch (e) {
		}
		try {
			t2 = arg2.toString().split(".")[1].length
		} catch (e) {
		}
		with (Math) {
			r1 = Number(arg1.toString().replace(".", ""))
			r2 = Number(arg2.toString().replace(".", ""))
			return (r1 / r2) * pow(10, t2 - t1);
		}
	},
	
	accMul : function(arg1, arg2) {
		var m = 0, s1 = arg1.toString(), s2 = arg2.toString();
		try {
			m += s1.split(".")[1].length
		} catch (e) {
		}
		try {
			m += s2.split(".")[1].length
		} catch (e) {
		}
		return Number(s1.replace(".", "")) * Number(s2.replace(".", "")) / Math.pow(10, m);
	},
		
	accAdd : function(arg1, arg2) {
		var r1, r2, m;
		try {
			r1 = arg1.toString().split(".")[1].length
		} catch (e) {
			r1 = 0
		}
		try {
			r2 = arg2.toString().split(".")[1].length
		} catch (e) {
			r2 = 0
		}
		m = Math.pow(10, Math.max(r1, r2))
		return (FR.accMul(arg1, m) + FR.accMul(arg2, m)) / m
	},
	
	accMin : function(arg1, arg2) {
		var r1, r2, m;
		try {
			r1 = arg1.toString().split(".")[1].length
		} catch (e) {
			r1 = 0
		}
		try {
			r2 = arg2.toString().split(".")[1].length
		} catch (e) {
			r2 = 0
		}
		m = Math.pow(10, Math.max(r1, r2))
		return (FR.accMul(arg1, m) - FR.accMul(arg2, m)) / m
	},
	
	/*
	 * 2, 4, 7, 3-6, 8-9, 12תint[]
	 */
	string2ints : function(str) {
		var res_array = []
		var ints_str_array = str.split(",");
		for (var i = 0; i < ints_str_array.length; i++) {
			var ints_str = ints_str_array[i]; // 3-6 or 7
			var se = ints_str.split("-");
			var start = parseInt(se[0]), end = start
			if (se.length > 1) {
				end = parseInt(se[1])
			}
			
			for (var x = start; x <= end; x++) {
				res_array.push(x);
			}
		}
		
		return res_array
	}
});

/*
 * ԻصһЩ
 */
(function() {
	var $fly = null, flyEl = null, $loading = null, $fileUpload = null;// ĶԻ
	// alex:һDialogprivaterķ
	create$D = function(o) {
		return $("<span>").appendTo("body").dialog($.extend({
			autoOpen : false,
			modal : true,
			overlay : {
				opacity : 0.5,
				background : "black"
			}
        }, o));
	}
	
	$.extend(FR, {
	    /*
		 * Ի,ĸ,ֱtitle, width, height &
		 * contentcontenthtmlƬΣҲJQuery,width & height < 0ʱԶС(ps:jQuery)
		 */
		showDialog : function(title, width, height, innerContent) {
	    	if ($fly == null) {
				$fly = create$D();
				flyEl = $fly.data("dialog");
			  }	    
	    
	    	flyEl.setData("title", title + '${fr_right}');//james:right еĶԻͶ
	    	// carl:widthheight0ʱĬӦΪ-1openʱִӦС
	    	// ｨܲӦͲãֵڲԪȫչֵС߿Խա߿ԸԪһ߿
	    	// ԶСʱʵһЩ߶autoΪͬЧһ
            flyEl.setData("width", width <= 0 ? -1 : width);
            flyEl.setData("height", height <= 0 ? -1 : height);
	    	// ֧innerContentһ,,һӽȥ
	    	function appendContent(content) {
	    		if (FR.isArray(content)) {
	    			$.each(content, function(idx, item) {
	    				appendContent(item);
	    			});
	    		} else {
	    			$fly.append(content);
	    		}
	    	}
	    	// alex:jQueryַ,ֱhtml
	    	$fly.empty();
	    	appendContent(innerContent);
            flyEl.open();
	   	},
	   	
	   	showIframeDialog : function(o) {
	   		if (typeof o == 'string'){
	   			o = {url : o}
	   		}
	   		
	   		var $iframe = $("<iframe width='100%' height='100%' scrolling='no'>");
			$iframe.attr("src", o.url);
	   		
	   		FR.showDialog(o.title, o.width || 350, o.height || 480, $iframe);
	   	},
		
	    /*
	     * {title, width, height, url}
	     * urlȡshowDialoginnerContent
	     */
	   	showRemoteDialog : function(o) {
	    	if (typeof o == 'string') {
	    		o = {url : o}
	    	}
	    	
	    	FR.showLoadingDialog();
	    	
	    	$.ajax($.extend({
	    		type : 'POST',
	    		complete : function(res, status) {
	    			FR.showDialog(o.title, o.width || 350, o.height || 480, res.responseText);
	    			FR.hideLoadingDialog();
	    		}
	    	}, o));
	    },
	    
	    /*
	     * loadingԻ
	     * o:{width: , height : }
	     */
	    showLoadingDialog : function(o) {
	    	o = o || {};
	    	var width = o.width || 200;
	    	var height = o.height || 100;
	    	if ($loading == null) {
	    		$loading = create$D();
	    		var loadingEl = $loading.data("dialog");
	    		
		    	loadingEl.setData("title", FR.i18n.Loading);
	            loadingEl.setData("width", width);
	            loadingEl.setData("height", height);
	            
	            $loading.html("<div class='loading-indicator'>" + FR.i18n.Loading + "</div>");
	    	} else {
	    		var loadingEl = $loading.data("dialog");
	    		loadingEl.setData("width", width);
	        	loadingEl.setData("height", height);
	    	}
	    	
	    	$loading.dialog("open", o.overlay_immediately || false);
	    },
	    
	    /*
	     * loadingԻ
	     */
	    hideLoadingDialog : function() {
	    	if ($loading != null) {
	    		$loading.dialog("close");
	    	}
	    },
	    
	   	/*
	   	 * صԻ
	   	 */
	    closeDialog : function() {
	   		if ($fly != null) {
	   			$fly.dialog("close");
	   		}
	   	},
	   	distroyDialog : function() {
	   	    FR.closeDialog();
	   	    $fly = null;
	   	},
	   	
	   	/*
	   	 * FR.Msg.alert
	   	 */
	   	Msg : function() {
	   		return {
//	   			alert : function(title, text, handler, scope) {
//	   				var $box = create$D({
//	   					closable : false
//	   				});
//	   				var boxEl = $box.data("dialog");
//	   				boxEl.setData("title", title + '${fr_right}');
//	   				boxEl.setData("width", "250px");
//	   				boxEl.setData("height", "115px");
//	   				
//	   				var $btn = $("<button type='button'></button>");
//	   				$box.append($("<div>").addClass("alert-information").text(text))
//	   				.append("<br>")
//	   				.append($("<div>").addClass("alert-btn").attr('align', 'center').append($btn));
//	   				
//	   				$btn.Button({
//	   					text : FR.i18n.OK,
//	   					handler : (handler || FR.emptyFn).createSequence(function() {
//	   						$box.dialog("destroy");
//	   						$box.remove();
//		   				}),
//		   				scope : scope
//	   				})
//					
//					FR.Keys.reg(function(e) {
//						if (e.keyCode == $.keyCode.ENTER) {
//	   						$btn.triggerHandler('click');
//							FR.Keys.unreg(arguments.callee);
//	   					}
//					})
//	   				
//	   				boxEl.open();
//	   			}
	   			// carl: jquery.alerts.js,ʽԭǻҰ׵ġ
	   			// These properties can be read/written by accessing FR.Msg.propertyName from your scripts at any time
				
				// carl:Ūƻƽм䲻
				verticalOffset: 0.77,                // vertical offset of the dialog from center screen
				horizontalOffset: 1,                // horizontal offset of the dialog from center screen\
				repositionOnResize: true,           // re-centers the dialog on window resize
				overlayOpacity: .01,                // transparency level of overlay
				overlayColor: '#FFF',               // base color of overlay
				draggable: true,                    // make the dialogs draggable (requires UI Draggables plugin)
				okButton: FR.i18n.OK,         // text for the OK button
				cancelButton: FR.i18n.Cancel, // text for the Cancel button
				dialogClass: null,                  // if specified, this class will be applied to all dialogs
				
				// Public methods
				
				alert: function(title, message, callback) {
					FR.Keys.enable(false);
					if( title == null ) title = 'Alert';
					this._show(title, message, null, 'alert', function(result) {
						FR.Keys.enable(true);
						if( callback ) callback(result);
					});
				},
				
				confirm: function(title, message, callback) {
					FR.Keys.enable(false);
					if( title == null ) title = 'Confirm';
					this._show(title, message, null, 'confirm', function(result) {
						FR.Keys.enable(true);
						if( callback ) callback(result);
					});
				},
					
				prompt: function(title, message, value, callback) {
					FR.Keys.enable(false);
					if( title == null ) title = 'Prompt';
					this._show(title, message, value, 'prompt', function(result) {
						FR.Keys.enable(true);
						if( callback ) callback(result);
					});
				},
				
				// Private methods
				
				_show: function(title, msg, value, type, callback) {
					
					this._hide();
					this._overlay('show');
					
					$("BODY").append(
					  '<div id="popup_container">' +
					    '<h1 id="popup_title"></h1>' +
					    '<div id="popup_content">' +
					      '<div id="popup_message"></div>' +
						'</div>' +
					  '</div>');
					
					if( this.dialogClass ) $("#popup_container").addClass(this.dialogClass);
					
					// carlhtml IEabsolute
					var pos = ($.browser.msie) ? 'absolute' : 'fixed'; 
					
					$("#popup_container").css({
						position: pos,
						zIndex: 99999,
						padding: 0,
						margin: 0
					});
					
					title += '${fr_right}';//"-<a style='text-decoration: none;' target='_blank' href='http://www.finereport.com'>FineReport Software</a>";
					$("#popup_title").html(title);
					$("#popup_content").addClass(type);
					$("#popup_message").text(msg);
					$("#popup_message").html( $("#popup_message").text().replace(/\n/g, '<br />') );
					
					$("#popup_container").css({
						minWidth: $("#popup_container").outerWidth(),
						maxWidth: $("#popup_container").outerWidth()
					});
					
					this._reposition();
					this._maintainPosition(true);
					
					switch( type ) {
						case 'alert':
							var $popup_panel = $("<div id='popup_panel'>").appendTo("#popup_content");
							var $ok_button = $("<button type='button'>").appendTo($("<span style='display:inline-block;'></span>").appendTo($popup_panel)).Button({
								tablable : true,
								text : this.okButton,
								handler : function() {
									FR.Msg._hide();
									callback(true);
								}
							});			
							$ok_button.focus();
							$ok_button.keydown( function(e) {
								if( e.keyCode == 13 || e.keyCode == 27 ) $ok_button.trigger('click');
							});
						break;
						case 'confirm':
							var $popup_panel = $("<div id='popup_panel'>").appendTo("#popup_content");
							var $ok_button = $("<button type='button'>").appendTo($("<span style='display:inline-block;margin-right:10px;'></span>").appendTo($popup_panel)).Button({
								tablable : true,
								text : this.okButton,
								handler : function() {
									FR.Msg._hide();
									callback(true);
								}
							});
							var $cancel_button = $("<button type='button'>").appendTo($("<span style='display:inline-block;'></span>").appendTo($popup_panel)).Button({
								tablable : true,
								text : this.cancelButton,
								handler : function() {
									FR.Msg._hide();
									callback(false);
								}
							});
							$("#popup_ok").focus();
						break;
						case 'prompt':
							$("#popup_message").append('<br /><input type="text" size="30" id="popup_prompt" />');
							var $popup_panel = $("<div id ='popup_panel'>").appendTo("#popup_content");
							var $ok_button = $("<button type='button'>").appendTo($("<span style='display:inline-block;margin-right:10px;'></span>").appendTo($popup_panel)).Button({
								tablable : true,
								text : this.okButton,
								handler : function() {
									var val = $("#popup_prompt").val();
									FR.Msg._hide();
									if( callback ) callback( val );
								}
							});
							var $cancel_button = $("<button type='button'>").appendTo($("<span style='display:inline-block;'></span>").appendTo($popup_panel)).Button({
								tablable : true,
								text : this.cancelButton,
								handler : function() {
									FR.Msg._hide();
									if( callback ) callback( null );
								}
							});
							$("#popup_prompt").width( $("#popup_message").width() );
							if( value ) $("#popup_prompt").val(value);
							$("#popup_prompt").focus().select();
						break;
					}
					
					// Make draggable
					if( this.draggable ) {
						try {
							$("#popup_container").draggable({ handle: $("#popup_title") });
							$("#popup_title").css({ cursor: 'move' });
						} catch(e) { /* requires jQuery UI draggables */ }
					}
				},
				
				_hide: function() {
					$("#popup_container").remove();
					this._overlay('hide');
					this._maintainPosition(false);
				},
				
				_overlay: function(status) {
					switch( status ) {
						case 'show':
							this._overlay('hide');
							$("BODY").append('<div id="popup_overlay"></div>');
							$("#popup_overlay").css({
								position: 'absolute',
								zIndex: 99998,
								top: '0px',
								left: '0px',
								width: '100%',
								height: $(document).height(),
								background: this.overlayColor,
								opacity: this.overlayOpacity
							});
						break;
						case 'hide':
							$("#popup_overlay").remove();
						break;
					}
				},
				
				_reposition: function() {
					var top = (($(window).height() / 2) - ($("#popup_container").outerHeight() / 2)) + this.verticalOffset;
					top = top * this.verticalOffset;
					var left = (($(window).width() / 2) - ($("#popup_container").outerWidth() / 2)) + this.horizontalOffset;
					left = left * this.horizontalOffset;
					if( top < 0 ) top = 0;
					if( left < 0 ) left = 0;
					
					// IE fix
					if( $.browser.msie) top = top + $(window).scrollTop();
					
					$("#popup_container").css({
						top: top + 'px',
						left: left + 'px'
					});
					$("#popup_overlay").height( $(document).height() );
				},
				
				_maintainPosition: function(status) {
					if( this.repositionOnResize ) {
						switch(status) {
							case true:
								$(window).bind('resize', function() {
									FR.Msg._reposition();
								});
							break;
							case false:
								$(window).unbind('resize');
							break;
						}
					}
				}
	   		};
	   	}(),
	   	
	   	showUploadDialog : function(o) {
	   		this.options = $.extend({
	        	url : '',//james:Զ̴URL
	        	el : this,
	        	allowTypes : '',
	        	err : '',
	            callback : FR.emptyFn,//jamesɺcallback
	            autoUpload : true
	        }, o);
	        
	   		if ($fileUpload == null) {
	   			$fileUpload = create$D();
	   		}
	   		
	   		$fileUpload.empty();//
	   		
	   		var fileUploadEl = $fileUpload.data("dialog");
	    	// carl:첽ϴļḴãtitleҲŪɿ
	   		if (this.options.title) {
	   			fileUploadEl.setData("title", this.options.title + '${fr_right}');
	   		} else {
	    		fileUploadEl.setData("title", FR.i18n.File_Upload + '${fr_right}');
	   		}
            fileUploadEl.setData("width", 350);
            //jamesûоjQuery$('<form>').append(XXXXX);ķʽܳɹ
            // carl:ŪisAutoSubmitжǷһѡļԶύҪǵexcelʱŪťȫһЩŪƯ㡣
            if (this.options.autoUpload) {
            	fileUploadEl.setData("height", 80);
	            this.$form = $('<form enctype="multipart/form-data" style="padding:10px">'
	            	+ '<input type="file" name="file" onchange="FR.autoSubmit()" size="35" />'//jamesһҪname
	//            	+ '<input type="button" value="' + FR.i18n.Upload + '">'//jamesHTMLԴBUTTONfileǸBUTTONԵһ
	            	+ '</form>');
	        } else {
	        	fileUploadEl.setData("height", 110);
	        	this.$form = $('<form enctype="multipart/form-data" style="padding:10px">'
	        		+ '<input name="file" type="file" size="35"/>'
	        		+ '<input type="button" value="' + FR.i18n.OK + '" style="width:80px;margin-top:10px;" onclick="FR.autoSubmit()"/>'
	        		+ '</form>');
	        }
            $fileUpload.append(this.$form);		        	
        	$fileUpload.dialog('open');
	   	},
	   	
	   	// richer:ѡļԶύ
	   	autoSubmit : function(){
	   		var $file = $('input:file', this.$form);
	   		// carl:ļŪ˸ˣinput file acceptǻֶֻ֧֣ύʱ
	   		// filter ļ׺ xlsŪɶ֣飬ݲҪ
	   		if (!$file.val()) {
				FR.Msg.alert(FR.i18n.Alert, FR.i18n.No_File_Warning + '!');
				return;
	   		} else if (this.options.allowTypes) {
	   			var fileType = $file.val().substring($file.val().lastIndexOf(".") + 1);
	   			// richer:ļ
	   			if (this.options.allowTypes && this.options.allowTypes.indexOf(fileType) == -1) {
	   				FR.Msg.alert(FR.i18n.Alert, this.options.err ? this.options.err : (fileType + FR.i18n.Not_Allow_To_Upload_File + "," + FR.i18n.Allow_To_Upload_Contains + this.options.allowTypes));
	   				return false;
	   			}	   				   			
	   		} else if (this.options.filter) {
	   			if ($file.val().toLowerCase().indexOf('.' + this.options.filter) == -1) {
	   				FR.Msg.alert(FR.i18n.Alert, FR.i18n.Import_Excel_Message);
	   				return;
	   			}
	   		}
	   		FR.showLoadingDialog({width : 310, height : 80});
	    	FR.domFormSubmit(this.$form , {url : this.options.url, timeout : 3000000}
			, function(res, status) {
				FR.hideLoadingDialog();
				$fileUpload.dialog('close');							
				if ($.isFunction(this.options.callback)) this.options.callback(res, status, this.options.el);
			});	   		
	   	}
	});
})();

/*
 * formύصһЩ
 */
$.extend(FR, {
	/*
	 * ajaxķʽύformIDӦForm
	 * selector to get jQuery,ҲԾһjQuery
	 * paramsΪformύеҪĲ{context : '', url:''},formIDûĬϵaction,öurl,contextʾformڵķΧ
	 * callbackΪformύĲύɹʧ,:callback = function(res, status, options);//resΪݣstatusΪ״̬success,notmodifiedʾɹ
	 * optionsΪcallbackĲ{scope: ''}ָcallbackthisΧ
	 */
	domFormSubmit : function(selector, params, callback, options) {
   		FR.closeDialog();
   		
        params = $.extend({cjkEncode : true}, params);
        var $form;
        if (params.context) {
            $form = $(selector, params.context);
        } else {
            $form = $(selector);
        }
        if ($form.length == 0) {
   			return;
   		}

        options = $.extend({
            scope : this
   		}, options);

        //james:formύcjkEncode
        /**
        * !!!!!!ע!!!!!!formҪύĿؼҪnameAttributeserializeArrayǲɹ
        */
        var rawParams = $form.serializeArray();//jamesֵ[{name: paramName, value: paramValue},...]ʽ
        var ripeParams = {};
        for (var i = 0; i < rawParams.length; i++) {
            var rawParam = rawParams[i];
            if (params.cjkEncode === true) {
                //james:cjkEncode
                ripeParams[FR.cjkEncode(rawParam.name)] = FR.cjkEncode(rawParam.value);
            } else {
                ripeParams[rawParam.name] = rawParam.value;//james:һ{paramName:paramValue,...}ʽ
            }
        }
        $.extend(ripeParams, params);//jamesҪ

        var ajax_op = {
	        type : 'POST',
	        data : ripeParams,//
	        url : $form[0].action || params.url,//james:ûĬϵaction򿴿optionsǲurl
	        complete : function(res, status) {
	            $.isFunction(callback) && callback.call(options.scope, res, status, options);
	        }
   		};
   		//james֧fileύ
   		var $files = $('input:file', $form);
   		if ($files.length > 0) {//jamesTODOJҪжûֵȲжϰ
   			//jamesfileʱҪiframeʽд䣬ΪAJAX֪ļĴ
   			// hack to fix Safari hang (thanks to Tim Molendijk for this)
	       // see:  http://groups.google.com/group/jquery-dev/browse_thread/thread/36395b7ab510dd5d
   			if ($.browser.safari && ajax_op.closeKeepAlive)//james:closeKeepAlive֪
	           $.get(ajax_op.closeKeepAlive, fileUpload);
	       	else
	           fileUpload();
   		} else {
   			//jamesͨģʽ
        	$.ajax(ajax_op);
   		}
   		//james:iframeʵAJAXЧļϴ
   		//Examples and documentation at: http://malsup.com/jquery/form/
   		function fileUpload() {
	        var form = $form[0];
	        
	        if ($(':input[name=submit]', form).length) {
	            alert('Error: Form elements must not be named "submit".');
	            return;
	        }
	        
	        //james:successȻᱨģΪsucessֶ֧callback
	        ajax_op.success = ajax_op.success || FR.emptyFn;
	        
	        var opts = $.extend({}, $.ajaxSettings, ajax_op);
			var s = jQuery.extend(true, {}, $.extend(true, {}, $.ajaxSettings), opts);
	
	        var id = 'jqFormIO' + (new Date().getTime());
	        var $io = $('<iframe id="' + id + '" name="' + id + '" />');
	        var io = $io[0];
	
	        if ($.browser.msie || $.browser.opera) 
	            io.src = 'javascript:false;document.write("");';
	        $io.css({ position: 'absolute', top: '-1000px', left: '-1000px' });
	
	        var xhr = { // mock object
	            aborted: 0,
	            responseText: null,
	            responseXML: null,
	            status: 0,
	            statusText: 'n/a',
	            getAllResponseHeaders: function() {},
	            getResponseHeader: function() {},
	            setRequestHeader: function() {},
	            abort: function() { 
	                this.aborted = 1; 
	                $io.attr('src','about:blank'); // abort op in progress
	            }
	        };
	
	        var g = opts.global;
	        // trigger ajax global events so that activity/block indicators work like normal
	        if (g && ! $.active++) $.event.trigger("ajaxStart");
	        if (g) $.event.trigger("ajaxSend", [xhr, opts]);
	
			if (s.beforeSend && s.beforeSend(xhr, s) === false) {
				s.global && jQuery.active--;
				return;
	        }
	        if (xhr.aborted)
	            return;
	        
	        var cbInvoked = 0;
	        var timedOut = 0;
	        
	        // add submitting element to data if we know it
	        var sub = form.clk;
	        if (sub) {
	            var n = sub.name;
	            if (n && !sub.disabled) {
	                ajax_op.extraData = ajax_op.extraData || {};
	                ajax_op.extraData[n] = sub.value;
	                if (sub.type == "image") {
	                    ajax_op.extraData[name+'.x'] = form.clk_x;
	                    ajax_op.extraData[name+'.y'] = form.clk_y;
	                }
	            }
	        }
	
	        // take a breath so that pending repaints get some cpu time before the upload starts
	        setTimeout(function() {
	            // make sure form attrs are set
	            var t = $form.attr('target'), a = $form.attr('action');
	            $form.attr({
	                target:   id,
	                method:   'POST',
	                action:   opts.url
	            });
	            
	            // ie borks in some cases when setting encoding
	            if (! ajax_op.skipEncodingOverride) {
	                $form.attr({
	                    encoding: 'multipart/form-data',
	                    enctype:  'multipart/form-data'
	                });
	            }
	
	            // support timout
	            if (opts.timeout)
	                setTimeout(function() { timedOut = true; cb(); }, opts.timeout);
	
	            // add "extra" data to form if provided in ajax_op
	            var extraInputs = [];
	            try {
	                if (ajax_op.extraData)
	                    for (var n in ajax_op.extraData)
	                        extraInputs.push(
	                            $('<input type="hidden" name="'+n+'" value="'+ajax_op.extraData[n]+'" />')
	                                .appendTo(form)[0]);
	            
	                // add iframe to doc and submit the form
	                $io.appendTo('body');
	                io.attachEvent ? io.attachEvent('onload', cb) : io.addEventListener('load', cb, false);
	                form.submit();
	            }
	            finally {
	                // reset attrs and remove "extra" input elements
	                $form.attr('action', a);
	                t ? $form.attr('target', t) : $form.removeAttr('target');
	                $(extraInputs).remove();
	            }
	        }, 10);
	
	        function cb() {
	            if (cbInvoked++) return;
	            
	            io.detachEvent ? io.detachEvent('onload', cb) : io.removeEventListener('load', cb, false);
	
	            var operaHack = 0;
	            var ok = true;
	            try {
	                if (timedOut) throw 'timeout';
	                // extract the server response from the iframe
	                var data, doc;
	
	                doc = io.contentWindow ? io.contentWindow.document : io.contentDocument ? io.contentDocument : io.document;
	                
	                if (doc.body == null && !operaHack && $.browser.opera) {
	                    // In Opera 9.2.x the iframe DOM is not always traversable when
	                    // the onload callback fires so we give Opera 100ms to right itself
	                    operaHack = 1;
	                    cbInvoked--;
	                    setTimeout(cb, 100);
	                    return;
	                }
	                
	                xhr.responseText = doc.body ? doc.body.innerHTML : null;
	                xhr.responseXML = doc.XMLDocument ? doc.XMLDocument : doc;
	                xhr.getResponseHeader = function(header){
	                    var headers = {'content-type': opts.dataType};
	                    return headers[header];
	                };
	
	                if (opts.dataType == 'json' || opts.dataType == 'script') {
	                    var ta = doc.getElementsByTagName('textarea')[0];
	                    xhr.responseText = ta ? ta.value : xhr.responseText;
	                }
	                else if (opts.dataType == 'xml' && !xhr.responseXML && xhr.responseText != null) {
	                    xhr.responseXML = toXml(xhr.responseText);
	                }
	                data = $.httpData(xhr, opts.dataType);
	            }
	            catch(e){
	                ok = false;
	                $.handleError(opts, xhr, 'error', e);
	            }
	
	            // ordering of these callbacks/triggers is odd, but that's how $.ajax does it
	            if (ok) {
	                opts.success(data, 'success');
	                if (g) $.event.trigger("ajaxSuccess", [xhr, opts]);
	            }
	            if (g) $.event.trigger("ajaxComplete", [xhr, opts]);
	            if (g && ! --$.active) $.event.trigger("ajaxStop");
	            if (opts.complete) opts.complete(xhr, ok ? 'success' : 'error');
	
	            // clean up
	            setTimeout(function() {
	                $io.remove();
	                xhr.responseXML = null;
	            }, 100);
	        };
	
	        function toXml(s, doc) {
	            if (window.ActiveXObject) {
	                doc = new ActiveXObject('Microsoft.XMLDOM');
	                doc.async = 'false';
	                doc.loadXML(s);
	            }
	            else
	                doc = (new DOMParser()).parseFromString(s, 'text/xml');
	            return (doc && doc.documentElement && doc.documentElement.tagName != 'parsererror') ? doc : null;
	        };
	    }
   	},
   	
   	/*
   	 * formύ򵥵ʾɹʧܵcallback
   	 * com/fr/web/core/dialog/printServer.html
   	 *   &com/fr/web/core/dialog/email.html
   	 */
   	formSubmitCallback : function(res, status, options) {
   		FR.Msg.alert(status == 'success' && res.responseText == "true"
   			? FR.i18n.HJS_Send_Successfully + '!' 
   			: FR.i18n.HJS_Send_Failed + '!'
   		);
   	},
   	
   	/*
   	 * ҳύˢҳ
   	 * com/fr/web/core/dialog/pageSetup.html
   	 */
   	pagesetupSubmitCallback : function(res, status, options) {
   		FR.closeDialog();
   		
	    var sessionID = options.sessionID;
	    var wbPane = FR.SessionMgr.get(sessionID);
	    if(wbPane != null)wbPane.loadContentPane();
   	}
});

/*
 * ӡصһЩ
 */
(function() {
	var $PrintDiv, $PDFReader, $flashIframe, $appletDiv, showFlashPrintSetting = null;
	
	// alex:flashӡʱǷʾӡõĶԻ
	function isShowFlashPrintSetting() {
		if (typeof showFlashPrintSetting != 'boolean') {
			// alex:ȥ̨һ,ҪҪshowFlashPrintSetting
			$(function() {
				$.ajax({
					url : '${servletURL}',
					data : {op : 'flash_getFlashPrintSetting'},
					async : false,
					complete : function(res, status) {
						if (status == 'success') {
							showFlashPrintSetting = res.responseText == 'true'
						}
					}
				})
			});
		}
		
		return showFlashPrintSetting;
	}
	
	/*
	 * ǷڵPDF
	 */
	function checkPDFPrint(sessionID, nopopup) {
		
		$.ajax({
			url : FR.i18n.servletURL,
			type : 'POST',
			data : {op : 'fr_CheckPDFPrint', sessionID : sessionID},
			complete : function(res, status) {
				var resText = res.responseText;
				
				// ,ͿԴӡ
				if ('ok' == resText) {
					FR.closeDialog();
					(function() {
						// alex:ֻеnopopuptrueʱŵӡԻ
						if (nopopup === true) {
							$PDFReader[0].print();
							// richer:òÿȷʱ¼
							_g(sessionID).fireEvent("afterpdfprint");
						} else {
							// richer:ȡ100000,ie8Number.MAX_VALUE
							$PDFReader[0].printPages(1, 100000);
							// richer:òÿȷʱ¼
							_g(sessionID).fireEvent("afterpdfprint");
						}
					}).defer(400);
				}
				// ,ٴcheck
				else if ('gening' == resText) {
					checkPDFPrint.defer(300, this, [sessionID,nopopup]);
				} else {
					FR.Msg.alert(resText);
				}
			}
		});
	}
		
	// ȡurlӦsessionID
	function __getSessionID__(url) {
		var sessionID = null;
		$.ajax({
			url : url,
			data : {op : 'getSessionID'},
			async : false,
			complete : function(res, status) {
				if (status == 'success') {
					sessionID = res.responseText;
				}
			}
		})
		return sessionID;
	}
	
	$.extend(FR, {
		/*
		 * PDFӡ
		 */
		doPDFPrint : function(sessionID, nopopup) {
			FR.doPrintURL_PDF(FR.i18n.servletURL +'?sessionID=' + sessionID, nopopup == "true" ? true : false);
		},
        
		/**
		 * @deprecated use doURLPDFPrint
		 */
		doPrintURL_PDF : function(url, nopopup) {
			FR.doURLPDFPrint(url, nopopup);
		},
		
		/*
		 * ֱPDFӡ
		 */
		doURLPDFPrint : function(url, nopopup) {
			if ($PrintDiv == null) {
				$PrintDiv = $("<div>").appendTo("body");
			}
			FR.showDialog(FR.i18n.Printing, 250, 100, FR.i18n.Loading_Component + "...");
			// ȡsessionID
			var sessionID = __getSessionID__(url);
			// carl:ӡʱreportletsҲһͲ
			if (url.indexOf("reportlet") > 0) {
			    url = url.slice(0,url.indexOf("reportlet"));
			    url = url.concat("sessionID=" + sessionID);
			}
			// fr_PDFPrint			
			$.ajax({
				url : url,
				data : {op:'fr_PDFPrint', frandom:Math.random()},
				type : 'POST',
				complete : function(res, status) {
					// һObjectPDFReaderActiveXؼ,Param[src:PDFFilePath]
					if (status == 'success') {
						$PrintDiv[0].innerHTML = res.responseText;
						$PDFReader = $PrintDiv.find("Object");
						try {
							$PDFReader[0].gotoFirstPage();
							//jamesܹgotoFirstPageAdobe Reader ActiveXװ
							FR.showDialog(FR.i18n.Printing, 250, 100, FR.i18n.Loading_PDF + "...");				
							checkPDFPrint.defer(300, this, [sessionID, nopopup]);
                           														
						} catch (e) {
							//jamesܵ˵ûаװAdobeReaderʾûװ
							var content;
							// carl:ȡǷаװļ
							$.ajax({
								type : 'POST',
								url : '${servletURL}?op=pdf_getpdfinstallpath',
								complete : function(res, status) {
									if (status == 'success') {
										var path = res.responseText;
										if (typeof path == 'string' && path.length > 0 && path.length < 150) {
											content = "Please install <a href=\"" + path +"\" target=\"_blank\">Adobe Reader</a>.";
										}
									}
									if (!content) {
										content = "Please install <a href=\"http://www.adobe.com/products/reader/\" target=\"_blank\">Adobe Reader</a>.";
									}
									FR.showDialog(FR.i18n.Alert, 300, 100, content);
								}
							});
						}
					}
				}
			});
		},
		
		/*
		 * Appletӡ
		 */
		// jamesֱӴӡURL
		doURLAppletPrint : function(url) {
			if ($appletDiv == null) {
				$appletDiv = $("<div>").appendTo("body");
			}
			
			FR.showDialog(FR.i18n.Printing, 250, 100, FR.i18n.Loading_Applet + "...");
			
			// james:reportletʱҪsessionID
			if (url.indexOf("reportlet") != -1) {
				FR.showDialog(FR.i18n.Printing, 250, 100, FR.i18n.Executing_Report + "...");
				url += '&frandom' + Math.random();// jamesӸ֤ÿβsessionһ
				var sessionID = __getSessionID__(url);
				url = FR.i18n.servletURL + "?sessionID=" + sessionID;
			}
			
			// fr_applet_load			
			$.ajax({
				url : url,
				data : {op:'fr_applet_load', frandom:Math.random()},
				type : 'POST',
				complete : function(res, status) {
					if (status == 'success') {
						$appletDiv[0].innerHTML = res.responseText;
						$appletPrinter = $appletDiv.find('Object')[0];
						if ($appletPrinter) {
							FR.showDialog(FR.i18n.Printing, 250, 100, FR.i18n.Loading_Data + "...");
							FR.closeDialog.defer(1000);// 1sر
						} else {
							FR.showDialog(FR.i18n.Alert, 250, 100, $appletDiv[0].innerHTML);
						}
					}
				}
			});
		
		},
		
		//p: applet print
		doAppletPrint : function(sessionID) {
			var url = FR.i18n.servletURL + "?sessionID=" + sessionID;
			if(_g(sessionID).fireEvent("beforeappletprint") === false) {
    			return;
    		}
			FR.doURLAppletPrint(url);
			_g(sessionID).fireEvent("afterappletprint");
		},
		
		/*
		 * Flashӡ,currentPageIndex1Ϊʼ
		 */
		doFlashPrint : function(sessionID, currentPageIndex) {
			if(_g(sessionID).fireEvent("beforeflashprint") === false) {
    			return;
    		}
			FR.doPrintURL(FR.i18n.servletURL + "?sessionID=" + sessionID, currentPageIndex);
			_g(sessionID).fireEvent("afterflashprint");
		},
		
		/**
		 * @deprecated use doURLFlashPrint
		 */
		doPrintURL : function(url, currentPageIndex) {
			FR.doURLFlashPrint(url, currentPageIndex);
		},
		
		/**
		 *жǷװflash
		 */
		isInstalledFlash : function() {
			if (this.$i_flash === true) {
				return true;
			}
			var i_flash = false;
			var n=navigator;
			if (n.plugins && n.plugins.length) {
				for (var ii=0;ii<n.plugins.length;ii++) {
					if (n.plugins[ii] && n.plugins[ii].name.indexOf('Shockwave Flash')!=-1) {
						i_flash = true;
						break;
					}
				}
			} else if (window.ActiveXObject) {
				for (var ii=10;ii>=2;ii--) {
					try {
						var fl=eval("new ActiveXObject('ShockwaveFlash.ShockwaveFlash."+ii+"');");
						if (fl) {i_flash = true; break; }
					}
					catch(e) {}
				}
			}
			this.$i_flash = i_flash;
			return i_flash;
		},
		
		// ʾûװflash
		flashInstall : function() {
			// james:ûаװFlashplayerʱҪʾû
			var content;
			// carl:ȡǷаװļ
			$.ajax({
				type : 'POST',
				url : '${servletURL}?op=flash_getflashinstallpath',
				complete : function(res, status) {
					if (status == 'success') {
						var path = res.responseText;
						if (typeof path == 'string' && path.length > 0 && path.length < 150) {
							content = "Please install <a href=\"" + path + "\">FlashPlayer</a>.<br><br>After installation please refresh the html page.";
						}
					}
					if (!content) {
						content = "Please install <a href=\"http://get.adobe.com/flashplayer/\" target=\"_blank\">FlashPlayer</a>.<br><br>After installation please refresh the html page.";
					}
					FR.showDialog(FR.i18n.Alert, 300, 100, content);
				}
			});
		},
		
		/*
		 * ֱӴӡһreportletӦĵַ
		 * 
		 * eg.http://localhost:8080/WebReport/ReportServer?reportlet=abc.cpt
		 * http://localhost:8080/WebReport/ReportServer?sessionID=1245323546335_1242
		 */
		doURLFlashPrint : function(url, currentPageIndex) {
			if (FR.isInstalledFlash() === true) {
				if ($flashIframe == null) {
					FR.__flash__ = function() {
						FR.doPrintURL.call(this, url, currentPageIndex);
						delete FR.__flash__;
					}; // ʱһ,flash
					$flashIframe = $("<iframe>").css({position:'absolute', left : -1000, top : -1000})
					.attr('src', FR.i18n.servletURL + '?op=resource&resource=/com/fr/web/core/printer.html').appendTo('body');
				} else {
					var fm = $.browser.msie ? $flashIframe[0].contentWindow["flashMovie"] : $flashIframe[0].contentDocument["flashMovie"];
					
					if (fm != null && fm.doLoadFlash != null) {
						var servletURL = url.split('?')[0];
						currentPageIndex = currentPageIndex || 1
						
						var sessionID = __getSessionID__(url);
						
						$.ajax({
					 		type : 'POST',
							url : servletURL, data : {sessionID : sessionID, op : 'flash_getpageinfo'},
							complete : function(res, status) {
								//b:falshӡʾϢ
								if (!FR.versionRemind(res.responseText)) {
									return;
								}
								// صϢΪ 100;0:200,200&20:300,300 ʾ100ҳǰ20ҳ200200300300
								var info_array = res.responseText.split(";");
								// alex:ʼҳ,ӵһҳһҳ
								var init_page_setting = "1-" + info_array[0];
							
								// alex:ҳӡ
								var print_fn = function(page_setting, fit_paper, paperinfo) {
									FR.showDialog(FR.i18n.Print, 250, 100, FR.i18n.Start_Print + '...');
									fm.doLoadFlash(servletURL, sessionID, FR.string2ints(page_setting).join(","), fit_paper, paperinfo);
									_g(sessionID).fireEvent("afterflashprint");
								}
							
								// alex:ǷҪҳѡĶԻ
								if (isShowFlashPrintSetting()) {
									var $content = $("<div>").appendTo('body').css("padding", 10);
								
									$("<table border=\"0\">" + 
									"<tr><td colspan='3' valign='middle' class='fh-nopadding'><input type='radio' name='range' value='all' checked>" +
									FR.i18n.HJS_All_Pages +
									"</td></tr>" +
									"<tr><td colspan='3' valign='middle' class='fh-nopadding'><input type='radio' name='range' value='current'>" +
									FR.i18n.HJS_Current_Page +
									":" +
									FR.i18n.HF_The_Page_Number +
													' ' + FR.i18n.is + ' ' + (currentPageIndex) + "</td></tr>" +
									"<tr><td colspan='3' valign='middle' class='fh-nopadding'><input type='radio' name='range' value='specify'>" +
									FR.i18n.HJS_Specified_Pages +
											":<input type='text' name='specify' value=''>(" +
											FR.i18n.Example +
													": 2,5,7-10,12)</td></tr>" +
									"<tr style='height:10px'><td colspan='3'/></tr>" +
									"<tr><td style='height:20px;'><div></div></td></tr>" +
									"<tr><td style='width:250px'></td><td class='yes-btn'></td><td class='cancel-btn'></td></tr>" +
									"</table>").appendTo($content)
									
									var specify_editor = $("input:text", $content).val(init_page_setting)
									var fit_paper_checkboxEl = $("div", $content).asComponent("checkbox", {text:FR.i18n.Print_To_Fit_Paper_Size, selected : false, disabled : false});

									$("<button type='button'>").appendTo($(".yes-btn", $content))
									.Button({text:FR.i18n.OK, render : false, handler: function() {
										FR.closeDialog();
									
										switch($("input:checked", $content).val()) {
											case 'current' : {
												init_page_setting = (currentPageIndex) + "";break; // alex:תַ
											};
											case 'specify' : {
												init_page_setting = specify_editor.val();break;
											};
										}
									
										print_fn(init_page_setting, fit_paper_checkboxEl.selected(), info_array[1] ? info_array[1] : "");
									}});
									$("<button type='button'>").appendTo($(".cancel-btn", $content))
									.Button({text:FR.i18n.Cancel, render : false, handler : function() {
										FR.closeDialog();
									}});
								
									FR.showDialog(FR.i18n.Setting, 400, 200, $content);
								} else {
									print_fn(init_page_setting, false, info_array[1] ? info_array[1] : "");
								}
							}
						})
					} else {
						FR.flashInstall();
					}
				}
			} else {
				FR.flashInstall();
			}
		}
	});
})()


// jQuery.fnһЩõķ
jQuery.fn.extend({    
    /*
     * jQuery.fn.loadһ,jQueryĺ,ΪǽExt,Ǻ
     * panel.load({
		    url: "your-url.php",
		    params: {param1: "foo", param2: "bar"}, // or a URL encoded string
		    callback: yourFunction,
		    scope: yourObject, // optional scope for the callback
		    discardUrl: false,
		    nocache: false,
		    text: "Loading...",
		    timeout: 30,
		    scripts: false
		});
		
		TODO alex:timeoutǷص,Ҫʾ
     */
    __load__ : function(o) {
    	var cfg = $.extend({
    		type : "GET",
    		timeout : 30000
    	}, o || {});
    	
    	if (cfg.params) {
    		cfg.type = "POST";
    	}
    	
    	cfg.callback = cfg.callback || FR.emptyFn;		
    	var self = this;
    	$.ajax({
    		url : cfg.url,
    		type : cfg.type,
    		dataType : 'html',
    		data : cfg.params,
    		timeout : cfg.timeout,
    		beforeSend : function() {
    			self.__loading__(true, cfg.forceDisplay);
    		},
    		complete : function(res, status) {
    			var html = res.responseText;
    			if (cfg.scripts === true) {
    				/*
    				 * copy from Ext.Element.update
    				 */
    				var hd = document.getElementsByTagName("head")[0];
		            var re = /(?:<script([^>]*)?>)((\n|\r|.)*?)(?:<\/script>)/ig;
		            var srcRe = /\ssrc=([\'\"])(.*?)\1/i;
		            var typeRe = /\stype=([\'\"])(.*?)\1/i;
		            
		            var match;
		            while(match = re.exec(html)){
		                var attrs = match[1];
		                var srcMatch = attrs ? attrs.match(srcRe) : false;
		                if(srcMatch && srcMatch[2]){
		                   var s = document.createElement("script");
		                   s.src = srcMatch[2];
		                   var typeMatch = attrs.match(typeRe);
		                   if(typeMatch && typeMatch[2]){
		                       s.type = typeMatch[2];
		                   }
		                   hd.appendChild(s);
		                }else if(match[2] && match[2].length > 0){
		                    if(window.execScript) {
		                       window.execScript(match[2]);
		                    } else {
		                       window.eval(match[2]);
		                    }
		                }
		            }
		            
		            html = html.replace(/(?:<script.*?>)((\n|\r|.)*?)(?:<\/script>)/ig, "");
    			}
    			
    			self.html(html);
    			
    			self.each( cfg.callback, [res.responseText, status, res] );
    			
    			self.__loading__(false);
    		}
    	});
    	
    	return this;
    },
    
    /*
     * loading-indicator
     * forceDisplay : ǿԵʾloadingͼ
     */
    __loading__ : function(show, forceDisplay) {
		var $indicator = this.find(".loading-indicator");
		if ($indicator.length == 0) {
			$indicator = $("<div class='loading-indicator'>" + FR.i18n.Loading + "</div>")
				.css({position:'absolute', left:0, top:0}).appendTo(this);
		}
		if (show && $indicator.is(':visible')) {
			return;
		}
		
		// 1.5ʾLoading,ȻÿμʱҪloadingתת,÷
		if (show) {
			var timer = $indicator.fadeIn.defer(typeof show == 'number' ? show : 1500, $indicator, ["slow"]);
			if (forceDisplay){
				var timer = $indicator.fadeIn.defer(0, $indicator, ["slow"]);
			}
			this.data("__timer__", timer);
		} else {
			var timer = this.data("__timer__");
			if (timer != null) {
				clearTimeout(timer);
				this.data("__timer__", null);
			}
			$indicator.hide();
		}
		
		return this;
	},
	
	/*
	 * containerĹʹthis2view
	 * hscroll true -> ˮƽ; false -> ˮƽ(ֱalways)
	 * 
	 * copy from Ext
	 */
	__scroll2View__ : function(container, hscroll) {
		var c = $(container)[0];
		
		return $.each(this, function(idx, el) {
			var el_os = $(el).offset();
			var c_os = $(c).offset();
	        var l = el_os.left - c_os.left + c.scrollLeft,
	            t = el_os.top - c_os.top + c.scrollTop,
	            b = t+el.offsetHeight,
	            r = l+el.offsetWidth;
	
	        var ch = c.clientHeight;
	        var ct = parseInt(c.scrollTop, 10);
	        var cl = parseInt(c.scrollLeft, 10);
	        var cb = ct + ch;
	        var cr = cl + c.clientWidth;
	
	        if(el.offsetHeight > ch || t < ct){
	        	c.scrollTop = t;
	        }else if(b > cb){
	            c.scrollTop = b-ch;
	        }
//	        c.scrollTop = c.scrollTop; // corrects IE, other browsers will ignore(alex:ǰעExtд,ûʲôⰡ)
	
	        if(hscroll !== false){
				if(el.offsetWidth > c.clientWidth || l < cl){
	                c.scrollLeft = l;
	            }else if(r > cr){
	                c.scrollLeft = r-c.clientWidth;
	            }
	            c.scrollLeft = c.scrollLeft;
	        }
		});
	}
});

/*
 * jQueryעؼ
 * jQueryɿؼķ
 */
(function() {
	var kv = {};  // alex:(༭,text)ֵ(Ҳһַ,$.FR.TextEditor)
	$.shortcut = function(xtype, className) {
		kv[xtype] = className;
	};
	
	/*
	 * alex:elԪصĻ,config(not necessary)ΪxtypeӦĿؼ
	 * $el.asComponent("toolbar", config);
	 * ı$el.asComponent("text", config);
	 * ı$el.asComponent("number", config);
	 * ť$el.asComponent("button", config);
	 * ѡť$el.asComponent("radio", config);
	 * ѡť$el.asComponent("checkbox", config);
	 * $el.asComponent("combo", config);
	 * ѡ$el.asComponent("combocheckbox", config);
	 * ʱؼ$el.asComponent("datetime", config);
	 * ļؼ$el.asComponent("file", config);
	 */
	$.fn.extend({
		asComponent:function(xtype, config) {
			/*
			 * $el.create({type:"text", width:120...})
			 */
			if (typeof xtype == 'object') {
				config = xtype;
				xtype = xtype.type;
			}
			if (xtype == null) {
				throw new Error("type is need")
			}
		
			var className = kv[xtype]
			if (className == null) {
				className = xtype;
			}
			var fnName = className;
			// alex:$.FR.TextEditor -> TextEditor
			var dot_index = fnName.indexOf(".")
			while(dot_index >= 0) {
				fnName = fnName.substring(dot_index + 1);
				dot_index = fnName.indexOf(".");
			}
			
			if ($.fn[fnName] == null) {
				throw new Error("unresolvable type:" + xtype)
			}
			
			var ret = this[fnName](config).data(fnName);
			if (ret != null) {
				this.removeData(fnName);
				return ret;
			}
			
			throw new Error("component " + fnName + " can not be unresolvable")
		}
	});
})();

// $.FR.OB.start
$.widget("FR.OB", {
	/**
	 * ʼ,¼
	 */
	init : function() {
		var self = this;
		if (this.options.listeners != null) {
			$.each(this.options.listeners, function(i, lis) {
				(lis.target ? lis.target : self)[lis.once ? 'once' : 'on'](lis.eventName, lis.action.createDelegate(self))
			})
			delete this.options.listeners;
		}
	},
	
	// alex:¼¼һ[{name:[fn]}]
	__getEvents : function() {
		if (!FR.isArray(this.events)) {
			this.events = []
		}
		
		return this.events;
	},
	
	////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//////Ϊ$.event¼ϵͳfireEventֵַ֧(Ҫֵ===falseʱĲ),ԻǳExt¼ϵͳ /////////////
	////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	
    /**
     * Fires the specified event with the passed parameters (minus the event name).
     * @param {String} eventName
     * @param {Object...} args Variable number of parameters are passed to handlers
     * @return {Boolean} returns false if any of the handlers return false otherwise it returns true
       $("<div>").appendTo("body").OB().OB("on", "dodo", function(e, arg1, arg2) {
		    // e.type = 'dodo', e.data = 444, arg1 = 4, arg2 = 3
		}, 444).OB("fireEvent", "dodo", 4,3)
	 *
	 * ֵfalseʱĲ
     */
    fireEvent : function() {
    	var eventName = arguments[0].toLowerCase();
    	var fns = this.__getEvents()[eventName];
    	if (FR.isArray(fns)) {
    		var args = Array.prototype.slice.call(arguments, 1)
    		for (var i = 0; i < fns.length; i++) {
    			if (fns[i].apply(this, args) === false) {
    				return false;
    			}
    		}
    	}
    	
    	return true;
    	// alex:һfalse,ʾöӦķ
        // return $.event.trigger(arguments[0], Array.prototype.slice.call(arguments, 1), this, false)
    },
    
    /**
     * Adds a listener
     */
    on : function(eventName, fn) {
    	eventName = eventName.toLowerCase();
    	var fns = this.__getEvents()[eventName];
    	if (!FR.isArray(fns)) {
    		fns = [];
    		this.__getEvents()[eventName] = fns;
    	}
    	fns.push(fn);
    },
    
    /**
     * invoke only once
     */
    once : function(eventName, fn) {
    	var proxy = function() {
    		fn.apply(this, arguments);
    		this.un(eventName, proxy);
    	}
    	this.on(eventName, proxy);
    },

    /**
     * Removes a listener
     * @param {String}   eventName     The type of event to listen for
     * @param {Function} handler        The handler to remove
     */
    un : function(eventName, fn) {
    	// alex:fnnull,ǰeventNameзun
    	if (fn == null) {
    		delete this.__getEvents()[eventName];
    	} else {
	    	var fns = this.__getEvents()[eventName];
	    	if (FR.isArray(fns)) {
	    		/*
	    		 * alex:ÿķʽ,spliceֱɾfnsеԪ
	    		 * ΪfireEventʱ,Ӧķonceȥ,ִ֮fnsĳ,ᵼЩfn޷ִ
	    		 * ķʽonceһfn,onһfn,ôfireEventᵼonfnûִ
	    		 */
	    		var newFns = [];
	    		$.each(fns, function(idx, ifn) {
	    			if(ifn != fn) {
	    				newFns.push(ifn);
	    			}
	    		})
	    		this.__getEvents()[eventName] = newFns;
	    	} 
    	}
    },

    /**
     * Removes all listeners for this object
     */
    purgeListeners : function() {
    	// alex:events
    	this.events = [];
    }
});
// alex:׽¼
$.FR.OB.capture = function(o, fn, scope) {
	o.fireEvent = o.fireEvent.createInterceptor(fn, scope);
}
// alex:ͷ¼Ĳ׽
$.FR.OB.releaseCapture = function(o) {
	o.fireEvent = $.FR.OB.prototype.fireEvent;
}
// $.FR.OB.end

// $.FR.Widget start
$.widget("FR.Widget");
FR.extend($.FR.Widget, $.FR.OB, {
	init : function() {
		$.FR.Widget.superclass.init.apply(this, arguments);
		
		// alex:Ҫdisableʱ,disable
		this[this.options.disabled ? 'disable' : 'enable']();
		this[this.options.invisible ? 'invisible' : 'visible']();
	},
	
	/*
	 * ȡؼdisable״̬
	 */
	isEnabled : function() {
		return this.getData("disabled") === false;
	},
	
	/*
	 * ȡؼvisible״̬
	 */
	isVisible : function(){
		return this.getData('invisible') == false;
	}
});

// $.FR.BorderLayout start
/*
 $el.asComponent("borderlayout", {
     items:[{
     	region:'north',
     	el : $el1, // $el1
     	draggable:true
     }, {
     	region:'south',
     	contentEl:$cel // $celһdiv
     }, {
     	region:'center',
     	el : $el2
     }]
 })
 */
$.widget("FR.BorderLayout");$.shortcut("borderlayout", "$.FR.BorderLayout");
FR.extend($.FR.BorderLayout, $.FR.OB, {
	// richer:пͻõʱ,ʱԭдɾsvn֮ǰԴļ
	init : function() {
		$.FR.BorderLayout.superclass.init.apply(this, arguments);
		
		if (!$.isArray(this.options.items)) {
			this.options.items = [];
		}
		this.refreshLayout();
	},
	
	refreshLayout : function() {
		var jLayoutConf = {};
		var $thisEl = this.element;
		var regionsAvailable = ["center", "north", "south", "east", "west"];
		for (var ri = 0; ri < regionsAvailable.length; ri++) {
			var region = regionsAvailable[ri];
			var regionField = region + "El", foundMatched = false;
			
			// alex:this.options.itemsҷϵǰregionitem
			for (var ii = 0; ii < this.options.items.length; ii++) {
				var itemConf = this.options.items[ii];
				if (itemConf.region != region) {
					continue;
				}
				
				if (this[regionField] != null) {
					this[regionField].remove();
				}
				
				this[regionField] = itemConf.el;
				if (this[regionField] == null && itemConf.contentEl) {
					this[regionField] = $("<div class=\"wrap\"></div>").append(itemConf.contentEl);
				}
				// alex:ֻеregionEl.parent()containerŵappendTo,ԭappendToıregionElλ
                if (this[regionField].parent()[0] != $thisEl[0]) {
                	this[regionField].appendTo($thisEl);
                }
                
                jLayoutConf[region] = this[regionField];
                foundMatched = true;
                break;
			}
			
			if (!foundMatched) {
				
			}
			
		}
			
		$thisEl.data('jlayout', jLayout.border(jLayoutConf));
        // layout,ôoverflowȻҪΪhidden
        $thisEl.css("overflow", "hidden");
	},
	
	doLayout : function() {
		this.element.doLayout();
	}
});

/*
 * BorderLayoutsetElsetContentEl
 */
$.extend($.FR.BorderLayout.prototype, function() {
	function pushAnotherBlock(asEl, el, position) {
		var items = this.options.items, foundMatch = false;
		for (var i = 0; i < items.length; i++) {
			if (items[i].region == position) {
				items[i][asEl ? "el" : "contentEl"] = el;
				foundMatch = true;
				break;
			}
		}
		
		if (!foundMatch) {
			var block = {region : position};
			block[asEl ? "el" : "contentEl"] = el;
			items.push(block);
		}
		
		this.refreshLayout();
	}
	
	return {
		/*
		 * position : ֱӰ{region : position, el : el}ӵitems,
		 */
		setEl : function(el, position) {
			pushAnotherBlock.call(this, true, el, position);
		},
		
		/*
		 * setEl,һdivresizeʱıСõ
		 */
		setContentEl : function(contentEl, position) {
			pushAnotherBlock.call(this, false, contentEl, position);
		}
	};
}());

/*
 $el.asComponent("gridlayout", {
 	rows : 2, columns : 2,
 	widths : [0, 200], // ʾеĿΪ0200 
 	heights:[-1, 100]  // ʾڶи߶Ϊ100,ʣµΪһеĸ߶
 	items : [
 		$("<div>").text("no 2").css('height',100).css('overflow', 'hidden'),
		$("<div>").text("no 3").css('overflow', 'hidden'),
		$("<div>").text("no 4").css('overflow', 'hidden'),
		$("<div>").text("no 1").css('overflow', 'hidden')
 	]
 })
 */
$.widget("FR.GridLayout");$.shortcut("gridlayout", "$.FR.GridLayout");
FR.extend($.FR.GridLayout, $.FR.OB, {
	init:function() {
		$.FR.GridLayout.superclass.init.apply(this, arguments);
		this.refreshLayout();
	},
	
	refreshLayout : function() {
		var $thisEl = this.element;
		var o = this.options;
        $.each(o.items || [], function(idx, item) {
        	// alex:ֻеregionEl.parent()containerŵappendTo,ԭappendToıregionElλ
            if (item.parent()[0] != $thisEl[0]) {
            	item.appendTo($thisEl);
            }
        });

        $thisEl.data('jlayout', jLayout.grid(o));
        // layout,ôoverflowȻҪΪhidden
        $thisEl.css("overflow", "hidden");
	},
	
	doLayout : function() {
		this.element.doLayout();
	}
});

/*
 demo:
      $el.asComponent("flowlayout", {
      }); 
 */
$.widget("FR.FlowLayout");$.shortcut("flowlayout", "$.FR.FlowLayout");
FR.extend($.FR.FlowLayout, $.FR.OB, {
	init:function() {
		$.FR.FlowLayout.superclass.init.apply(this, arguments);
		this.refreshLayout();
	},
	refreshLayout:function(){
		
	},
	doLayout:function(){
		
	}
});
/*
 * $.FR.Form selector:ѡеĿؼ
 * 
 * editor : editor$domɵĿؼ,ûеĻ½һ$divӵdom
 * resolveVariable : ,ҪǵԪ
 * 
 * events:[afterinit, submitsuccess, submitfailure, submitcomplete]
 */
$.widget("FR.Form");
$.shortcut("fr_form", "$.FR.Form")
FR.extend($.FR.Form, $.FR.OB, {
	init : function() {
		$.FR.Form.superclass.init.apply(this, arguments);

		var formO = {
			form : this
		}
		this.name_widgets = {};
		this.location_widgets = {};
		
		/*
		 * alex:תelementеĿؼ selectorַʱ
		 */
		var self = this;
		if (typeof this.options.selector == 'string') {
			$(this.options.selector, this.element).each(
				function(idx, dom) {
					var $dom = $(dom);
					
					var attr = 'editor';
					var text = $dom.attr(attr);
					if (text == null) {
						attr = 'widget'
						text = $dom.attr(attr);
					}
					// carl:ҪĻس<br>decodeʱ쳣
					text = text.replace(/<br>/g,"");
					var editorO = FR.jsonDecode(text);
					/*
					 * alex:дcss("height")ķʽ,ֱheight()
					 * ΪڹϵPageNaviֱheightʱȡ0
					 */
					editorO.width = $dom.attr("width");
					editorO.height = $dom.attr("height");
					$.extend(editorO, formO);
					
					/*
					 * ȿļǷeditor
					 * ,֮,op=writeʱ
					 * ,½һӵdom
					 * carl:button ⴦,ںܻ
					 */
					var $editor = self.options.editor;
					if (attr != 'editor' || $editor == null) {
						$editor = $("<div>").appendTo(dom);
					}
					
					// james:editorOjspathԣjsļĿǰԶ༭õ
					// @see com.fr.report.web.ui.WidgetManager
					if (editorO.jspath) {
						var arr = editorO.jspath.split(";");
						$.each(arr, function(i, item){
							FR.$import(item, "js");
						});
					}
					if (editorO.csspath) {
						var arr = editorO.csspath.split(";");
						$.each(arr, function(i, item){
							FR.$import(item, "css");
						});
					}
						
					var editorEl = $editor.asComponent(editorO);
					
					/*
					 * alex:editorԵĻ,Ҫɱ༭ֹͣ༭hide
					 * Ȼһ˫ʱ,ʾеĿؼ
					 */
					if (attr == 'editor') {
						editorEl.stopEditing();
					}
					
					/*
					 * alex:ɱ༭,fieldName & cell֮
					 * ۴ַʽҵӦı༭
					 */
					/*
					 * alex:fieldNameeditor
					 * ΪdependenceصֵǴд,ҲΪ˲ִСд,fieldNametoUpperCase
					 */
					if (editorO.fieldName) {
						self.name_widgets["$" + editorO.fieldName.toUpperCase()] = editorEl;
					}
					
					// alex:ݵԪλٱһeditor
					
					// carl:һָͬһwidgetsظ
					// 
					if (editorO.location) {
						self.location_widgets[editorO.location] = editorEl;
					}
				}
			)
		}
		
		// richer:Ǵ
		var combi = function(widgets){
			for (var num in widgets){
			var widget = widgets[num];
			// carl:ֻпؼֱӿdependenceˣҪdependenceMapӳ
			var dependence = widget.options.dependence;
			if (FR.isArray(dependence)) {
				$.each(dependence, function(idx, p) {
					// alex:pӦwidgetsܲ
					if (widgets[p.toUpperCase()] != null && num.toUpperCase() != p.toUpperCase()) {
						widgets[p.toUpperCase()].on(FR.Events.AFTEREDIT, function() {
							this.reset();
						}.createDelegate(widget));
					}
				})
				}
			}	
		};
		
		combi(this.name_widgets);
		combi(this.location_widgets);

		this.fireEvent(FR.Events.AFTERINIT);
	},
	
	/*
	 * ,ΪA1Ԫʽ$P1ʽ
	 */
	resolveVariable : function(variable) {
		var res;
		if ($.isFunction(this.options.resolveVariable)) {
			res = this.options.resolveVariable(variable);
		}
		if (res == null) {			
			var depWidget = this.location_widgets[variable];
			if (depWidget == null) {
				depWidget = this.name_widgets[variable];
			}
			res = depWidget == null ? null : depWidget.getValue();
		}
		
		return res;
	},
	
	verify : function(){
		var self = this;
		var isValidate = true
		$.each(this.name_widgets, function(index, widget) {
			if (!widget.isValidate()){
				FR.Msg.alert(FR.i18n.Info, widget.errorMsg);				
				isValidate = false;				
			}
		});
		
		return isValidate;
	},
	
	// richer:ռfr_formֵwidgetֵ
	// dataӽȥĲֵ
	collectionValue : function(data) {
		var collection = {};
		for (var w in this.location_widgets) {
			var editor = this.location_widgets[w];
			var fieldName = editor.options.fieldName;
			// alex:fieldNameĲżӵparamsȥ
			if (fieldName) {
				var val = editor.getValue();
				if (FR.isArray(val)){
					val = val.join(",").toString();
					val = "[".concat(val);
					val = val.concat("]");
				}
				collection[FR.cjkEncode(fieldName)] = FR.cjkEncode(val);
			}
		}
		if (data){
			$.each(data, function(i, item){
				collection[FR.cjkEncode(i)] = FR.cjkEncode(item);
			});
		}
		
		return collection;
	},
	
	/*
	 * 
	 * 
	 * this.dbCommit({
	 *     xmlconf : ""
	 *     callback : fn
	 * })
	 */
	dbCommit : function(o) {
		this.formSubmit({
			url : FR.i18n.servletURL + "?op=dbcommit",
			data : {xmlconf:o.xmlconf},
			callback : o.callback || FR.emptyFn
		});
	},
	
	/*
	 * ύָurl
	 * 
	 * this.formSubmit({
	 *     callback:fn,
	 *     url : "",
	 *     asyn : true,
	 *     data : {}
	 * })
	 */
	formSubmit : function(){
		if (!this.verify()){
			// richer:УϢʱѯťõbug
			$.each(this.location_widgets, function(index, item) {
				item.enable();
			});
			return;
		}
		var config = arguments[0];
		if (config.url == null){
			return;
		}
		var o = this.config = $.extend({
			asyn : true			
		}, config);
		this.$sform = $($('.form-submit', this.element)[0]);
		var callback  = o.callback;
		var self = this;
		// 첽ύ
		if (o.asyn) {
			$.ajax({
				url : o.url,
				type : "POST",
				data : {__parameters__ : FR.jsonEncode(this.collectionValue(o.data))},
				complete : function(res, status) {
					callback.call(self, res, status)			
					if (status == 'success') {
						self.fireEvent(FR.Events.SS);
					} else {
						self.fireEvent(FR.Events.SF);
					}
					self.fireEvent(FR.Events.SC);
				}
			});
		// ͬύ
		} else {
			this.$sform.attr('method', 'post');
    		this.$sform.attr('action', config.url);
    		if (config.target) this.$sform.attr('target', config.target);
    		
    		if (!this.$sform_hidden) {
    			this.$sform_hidden = $("<input name = 'form_value' type='hidden'/>").appendTo(this.$sform);
    			this.$sform_hidden.attr('value', FR.jsonEncode(this.collectionValue(o.data)));
    		}    		
    		this.$sform.submit();
		}
	},
	// carl:ȡֵ
	getValueByName : function(fieldName) {
		if (!this.name_widgets || !fieldName) return null;
		if (fieldName.indexOf("$") != 0){
			fieldName = "$" + fieldName;
		}
		fieldName = fieldName.toUpperCase();
		var widget = this.name_widgets[fieldName];
        if (widget && widget.getValue) {
            return widget.getValue();
        } else {
            return null;
        }
	},
	
	// richer:ȡwidget
	getWidgetByName : function(widgetName){
		if (widgetName.indexOf("$") != 0) {
			widgetName = "$" + widgetName;
		}
		widgetName = widgetName.toUpperCase();
		if (!this.name_widgets || !widgetName) {
			return null;
		}
		return this.name_widgets[widgetName];       
	},
	getWidgetByCell : function(location){
		if (!this.location_widgets || !location){
			return null;
		}
		return this.location_widgets[location];
	}
});

/*
 * alex:򵥵ͼƬл
 */
$.widget("FR.SimpleChart");
$.shortcut("simplechart", "$.FR.SimpleChart")
FR.extend($.FR.SimpleChart, $.FR.OB, {	
	imgClass : 'x-chart-img',
	topmenuClass : 'x-chart-topmenu',
	topmenuitemClass : 'x-chart-topmenuitem',
	chartlistClass : 'x-chart-menu',
	menuitemClass : 'x-chart-menuitem',
	menuitemHoverClass : 'x-chart-menuitem-hover',
	menuitemVisitedClass : 'x-chart-menuitem-visited',
	menuitemCurrentClass : 'x-chart-menuitem-current',
	menuitemCurrentClass_msie6 : 'x-chart-menuitem-current-msie6',
	
	init : function() {
		$.FR.SimpleChart.superclass.init.apply(this, arguments);
		
		var o = this.options;
		// ǰimgǩ
		this.curChart = null;
		// carl:imgǩ
		this.chartArray = [];
		
		var width = o.chartWidth || 0;
		var height = o.chartHeight || 0;
		this.$imgbox = $("<div></div>").css("position", "relative").css("width", width).css("height", height).appendTo(this.element);
		// create menu
		var self = this;
		
		// carl:ie6,һΪ״ģͲͬһΪpng
		var ua = navigator.userAgent.toLowerCase();
		var ismsie6 = false;
		if(ua.indexOf('msie 6.0') != -1) ismsie6 = true;
		
		this.$topmenu = $("<div></div>").addClass(this.topmenuClass).css("height", 22).css('display', 'none').appendTo(this.$imgbox);
		if (o.isfloat) {
			// floatı߿ǻȥģҪʱ򵥴
			this.$topmenu.css("width", width - 2).css("margin", "1px 0px 0px 1px");
		} else {
			this.$topmenu.css("width", width);
		}
		this.$topmenuitem = $("<div></div>").addClass(this.topmenuitemClass)
			.css("height", $.browser.msie ? 22 : 20).css("width", $.browser.msie ? 100 : 80).appendTo(this.$topmenu);
		this.$topmenutext = $("<a>" + FR.i18n.Choose + FR.i18n.Chart + "</a>").addClass(ismsie6 ? 'x-chart-topmenuitem-a-msie6' : 'x-chart-topmenuitem-a').appendTo(this.$topmenuitem);
		this.$topmenutext.mouseover(function(){
			if (!self.$topmenuitem.hasClass(self.menuitemVisitedClass)) {
				self.$topmenuitem.addClass(self.menuitemHoverClass);
				if (!ismsie6) self.$topmenutext.addClass('x-chart-topmenuitem-a-hover');
			}
		});
		this.$topmenutext.mouseout(function(){
			self.$topmenuitem.removeClass(self.menuitemHoverClass);
			if (!ismsie6) self.$topmenutext.removeClass('x-chart-topmenuitem-a-hover');
		});
		
		// carl:ô¼ԼҲ
		this.$chartlistmenu = $("<div></div>").css('top', 22).css('display', 'none').addClass(this.chartlistClass).appendTo(this.$imgbox);
		$.each(this.options.items, function(idx, item){
			var text = ismsie6 ? item.name + "&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp" : item.name;
			var button = $("<div></div>").addClass(self.menuitemClass).appendTo(self.$chartlistmenu);
			var button_text = $("<div>" + text + "</div>").addClass('x-chart-menuitem-text').css("padding", ismsie6 ? "5px 5px 2px 24px" : "2px 80px 2px 24px")
				.css("padding-top", $.browser.msie ? "5px" : "2px").appendTo(button);
			button.click(function(){
				self.changeChartImage(idx);
				self.$chartlistmenu.hide();
				self.$topmenuitem.removeClass(self.menuitemVisitedClass);
				if (!ismsie6) self.$topmenutext.removeClass('x-chart-topmenuitem-a-visited');
				if (ismsie6) {
					$($('.' + self.menuitemCurrentClass_msie6, self.$chartlistmenu)[0]).removeClass(self.menuitemCurrentClass_msie6);
					button_text.addClass(self.menuitemCurrentClass_msie6);
				} else {
					$($('.' + self.menuitemCurrentClass, self.$chartlistmenu)[0]).removeClass(self.menuitemCurrentClass);
					button_text.addClass(self.menuitemCurrentClass);
				}
			}.createDelegate(self));
			
			button.mouseover(function(){
				button.addClass(self.menuitemHoverClass);
			});
			
			button.mouseout(function(){
				button.removeClass(self.menuitemHoverClass);
			});
		});
		
		this.$topmenuitem.click(function(){
			self.$chartlistmenu.show();
			self.$topmenuitem.addClass(self.menuitemVisitedClass);
			self.$topmenuitem.removeClass(self.menuitemHoverClass);
			if (!ismsie6) {
				self.$topmenutext.addClass('x-chart-topmenuitem-a-visited');
				self.$topmenutext.removeClass('x-chart-topmenuitem-a-hover');
			}
		});
		// ŪһimgBoxlistmenuʱlistʧ
		this.$chartlistmenu.mouseover(function(){
			self.$chartlistmenu.show();
			self.$topmenuitem.addClass(self.menuitemVisitedClass);
			self.$topmenuitem.removeClass(self.menuitemHoverClass);
			if (!ismsie6) {
				self.$topmenutext.addClass('x-chart-topmenuitem-a-visited');
				self.$topmenutext.removeClass('x-chart-topmenuitem-a-hover');
			}
		});
		
		this.$imgbox.mouseover(function(){
			self.$topmenu.show();
		});

		this.$imgbox.mouseout(function(e){
			if (e.target.tagName == 'IMG') {
				self.$topmenu.hide();
				self.$chartlistmenu.hide();
				self.$topmenuitem.removeClass(self.menuitemVisitedClass);
				if (!ismsie6) self.$topmenutext.removeClass('x-chart-topmenuitem-a-visited');
			}
		});
		
		this.$imgbox.click(function(e){
			if (e.target.tagName == 'IMG') {
				self.$chartlistmenu.hide();
				self.$topmenuitem.removeClass(self.menuitemVisitedClass);
				if (!ismsie6) self.$topmenutext.removeClass('x-chart-topmenuitem-a-visited');
			}
		});
		
//		$.each(this.options.items, function(idx, item){
//			self.menuitems[idx] = {src : item.name, handler : function(){
//				this.changeChartImage(idx);
//			}.createDelegate(self)};
//		});
		$($('.x-chart-menuitem-text', self.$chartlistmenu)[0]).addClass(ismsie6 ? self.menuitemCurrentClass_msie6 : self.menuitemCurrentClass);
		this.changeChartImage(0);
	},
	
//	rightClickEvent : function(event) {
//		var config = {
//			items : this.menuitems
//		};
//		
//		FR.showMenuByEvent(config, event, true);
//	},
	
	changeChartImage : function(idx) {
		// carl:µĴܺĵԴòþע͵ġ
		if (idx < 0) return;
		if (!this.chartArray[idx]) {
			var name = this.options.items[idx].name;
			var url = this.options.items[idx].url;
			// carl:ie⣬imgmapҪһhtmlķʽء⴦Ȼѡȥõ
			if ($.browser.msie) {
				var $msbox = $("<div>");
				this.chartArray[idx] = $("<img src='" + url + "'/>").attr("idx",idx).addClass(this.imgClass).appendTo($msbox);
			} else {
				this.chartArray[idx] = $("<img src='" + url + "'/>").attr("idx",idx).addClass(this.imgClass).appendTo(this.$imgbox);
			}
			// ȵͼ
			if (this.options.items[idx].usemap && this.options.items[idx].mapHtml) {
				this.chartArray[idx].attr("usemap", this.options.items[idx].usemap);
				if ($.browser.msie) {
					$msbox.append(this.options.items[idx].mapHtml);
				} else {
					this.$imgbox.append(this.options.items[idx].mapHtml);
				}
			}
			if ($.browser.msie) {
				this.$imgbox.append($msbox.html());
				this.chartArray[idx] = $("img[idx='" + idx + "']",this.$imgbox);
			}
//			alert(this.chartArray[idx].html());
		}
		if (this.curChart == this.chartArray[idx]) return;
		var next = this.chartArray[idx];
		if (this.curChart) {
			this.curChart.css('z-index', 8);
//			this.curChart.animate({opacity : 0.0}, 1000);
			next.css('z-index', 10).css({opacity : 0.0}).animate({opacity : 1.0}, 1000, function(){
				this.curChart.css('z-index', 5);
				this.curChart = next;
			}.createDelegate(this));
		} else {
			next.css('z-index', 10).css({opacity : 1.0});
			this.curChart = next;
		}
	}
});

/*
 * richer:tooltip start
 * <class='tooltip' title='tooltip content'>
 */
FR.tooltip = function() {
	/* config */		
	xOffset = 10;
	yOffset = 20;		
	// these 2 variable determine popup's distance from the cursor
	// you might want to adjust to get the right result		
	/* end config */		
	$(".tooltip").hover(
		function(e){											  
			this.t = this.title;
			this.title = "";									  
			$("body").append("<p id='tooltip'>"+ this.t +"</p>");
			$("#tooltip").css("top",(e.pageY - xOffset) + "px").css("left",(e.pageX + yOffset) + "px").fadeIn("fast");		
    },
		function(){
			this.title = this.t;		
			$("#tooltip").remove();
    });	
	$(".tooltip").mousemove(function(e){
		$("#tooltip").css("top",(e.pageY - xOffset) + "px").css("left",(e.pageX + yOffset) + "px");
	});	
}()

/*
 * tooltip end
 */

/*
 * alex:ݶԶcontainerв
 */
FR.layoutFrozen = function($container) {
	var $center = $('.frozen-center', $container);
	var $corner = $('.frozen-corner', $container);
	var $north = $('.frozen-north', $container);
	var $west = $('.frozen-west', $container);
	if ($center.length > 0 || $corner.length > 0 || $north.length > 0 || $west.length > 0) {
			var corner_width = 0, corner_height = 0;
			// richer:westĿʾcornerĿ
			$west.find("colgroup:eq(0)").children().each(function(idx, col) {
				corner_width += parseInt($(col).css("width"));
			 })
			// richer:northĸ߶ʾcornerĸ߶
			$north.find("tbody:eq(0)").children().each(function(idx, tr) {
				corner_height += parseInt($(tr).css("height"));
			 })
	        	
			$container.asComponent("gridlayout", {
				rows : 2, columns : 2,
				items : [
					$corner,
					$north,
					$west,
					$center									    
				],
				widths : [corner_width + 3, -1],
				heights : [corner_height + 3, -1]
			 });
			// alex:$center_blockʱ,north & westҲҪŹ
			$center.scroll(function() {
				$north.scrollLeft($center.scrollLeft());
			 	$west.scrollTop($center.scrollTop());
			}.createDelegate(this))
		} 
}

// $.FR.BasePane.start
$.widget("FR.BasePane");
FR.extend($.FR.BasePane, $.FR.Widget, {
    init : function() {
    	$.FR.BasePane.superclass.init.apply(this, arguments);
        $.extend(this, this.option || {});
    },

    // start loading
    load : function(o) {
        var callee = this;
        var ro = {
            type:'POST',
            complete:function(res, status) {
                var text = res.responseText;
                if (text.charAt(0) == "<") { //alex:˵صһϢhtml
                    callee.element.html(text);
                } else {
                	(function() {
                		eval(text);
                	}).apply(callee);
                }
            }
        }

        // oһַ,Ǿһurl
        if (o.constructor == String) {
            $.extend(ro, {url:o})
        } else if (typeof o == "object") {
            $.extend(ro, o);
        }
        
        if (ro.form != null) {
        	var $form = $(ro.form);
        	ro.data = $.param($form.serializeArray().concat([{name:'__rtype__', value:this.rtype || 'page'}]));
        	ro.url = $form.attr('action');
        } else {
        	ro.data = $.extend(ro.params || {}, {__rtype__ : this.rtype || "page"});
        }

        $.ajax(ro);
    },
    
    /*
     * ļReportPane
     * в,ҲǶʽ,ReportPane.asComponent("borderlayout", {items:[north:ParameterPane, center:ContentPane]})
     *          ReportPaneһContentPane
     * в,Ҳǵʽ,ҪԻ...
     * 
     * ReportPane = ParameterFormPane + ContentPane
     */
    loadReportPane : function(options) {
        this.fireEvent(FR.Events.INIT);
    	options = options || {};
        options.param = $.extend({showType:1}, options.param); // Ĭϲʾ,showTypeΪ1:embed
        
        var items = [];

        var parameterEl = this._createParameterFormPane(options.param, items);
        
        this.$contentPane = this._createContentPane(options.sheets, options.browserbg);
        items.push({
        	region : 'center',
        	el : this.$contentPane
        })
        
        // alex:òΪBorderLayout
        this.element.asComponent("borderlayout", {items:items});
        this.element.doLayout();

        // james:ʼContentPaneһЩ¼ĿǰҪTabһЩл
        this.initContentPane();
        
		// loadContentPane
        if (parameterEl == null || options.param.delay === false) {
        	this.loadContentPane();
        }
        
        // carl:Ӹ<a> ˵վⲿӣ֪ǲôŪ
		this.element.append('<a href="http://www.finereport.com" title="FineReport߹">   </a>');
    },
    
    /*
     * ContentPane
     */
    _createContentPane : function(sheetsO,browserbg) {
    	sheetsO = sheetsO || [];
    	
    	/*
    	 * alex:contentPaneѾthis.element
    	 * BUG0001664 ֱ$("<div>"),ǻֶᷢdivthis.element
    	 */
    	var $contentPane = $("div.content-container");
    	if ($contentPane.length != 1) {
    		$contentPane = $("<div>").appendTo(this.element).addClass("content-container");
    	}

        if (sheetsO && sheetsO.length > 1) {
        	$contentPane.TabPane({tabs : sheetsO}).TabPane('on', 'tabchange', function() {
        		$contentPane.doLayout();
        	});
        } else {// ͨĵSheetͲҪtabs
        	// alex: overflow:auto ʾ鿴б
        	//p: '0px solid #97A5B0'Ҹĳ0px,ȥϱ߿,Ҳܹʾ.
        	$contentPane.css('overflow','auto').css('border-top', '0px');
        }
				// ҳ
				// Ϊʹ̶Բͬʹòͬ
        if(browserbg.background != null) {
			if($.browser.msie) {
				$contentPane.css('background',browserbg.background+" fixed");
				var ua = navigator.userAgent.toLowerCase();
				if(ua.indexOf('msie 6.0') == -1 && $('.parameter-container').length > 0) {
					$contentPane.css('background-position','0px '+$('.parameter-container').height()+'px 0px 0px');
				}
			} else {
				$contentPane.css('background',browserbg.background);
			}
        }
        return $contentPane;
    },
    
    /*
     * ParameterFormPane
     */
    _createParameterFormPane : function(paramO, layout) {
    	// alex:ûhtml,ֱӷ
    	if (paramO.html == null) {
    		return null;
    	}
    	
    	/*
    	 * alex:,һdiv.parameter-containerǷ,ڵĻ
    	 * ڵĻ,½һdivӵelementȥ
    	 */
        var $paramPane = $("div.parameter-container");
        if ($paramPane.length == 0) {
			$paramPane = $("<div>").appendTo(this.element).addClass("parameter-container");
			var bg;
			if (paramO.parambg != null) {
				bg = paramO.parambg.background
			}
			if (bg != null) {
				$paramPane.css('background', bg)
			}
			/*
			 * alex:Ƕʽ,ӵlayout.north
			 * 0-pop, 1-embbed
			 * $paramPaneѴ,ҲҪlayout.north
			 */
			if (paramO.showType == 1) {
				layout.push({
					region : 'north',
					el : $paramPane
				});
			}
		}
		$paramPane.html(paramO.html);
		
        // alex:popup
		var config = {
			selector : 'td[widget]'
		}
		var $table = $($paramPane.find("table")[0]);
		
		var self = this;
		// ģʽĲ,ҪshowDialog & closeDialog¼
        if (paramO.showType == 0) {
        	config.listeners = [{
        		once : true,
        		eventName : 'afterinit',
        		action : function() {
        			FR.showDialog(paramO.paramWindowTitle, -1 , -1, this.element)
        		}
        	}, {
        		once : true,
        		eventName : 'submitcomplete',
        		action : function() {
        			FR.closeDialog();
        		}
        	}];
			FR.Keys.reg(function(e){
				if (e.keyCode == $.keyCode.ENTER){
					
				}
			});														
        } 		
		
        // ǶģʽĶԻ,Ҫ$tablewrapһdiv,ʵ$tableľеЧ
        else {
        	// alex:divwidth,Ȼmargin:auto
        	$table.wrapAll($("<div>").addClass("x-table-wrapper").width($table.width()));
            $paramPane.css("text-align", "center");
            if (paramO.alignLocation == 0) {
                if ($.browser.msie) {
                    $paramPane.css("text-align", "left");
                }else {
                    $paramPane.children(".x-table-wrapper").css("margin", "0px auto 0px 0px");
                }
            } else if (paramO.alignLocation == 1) {
                if ($.browser.msie) {
                    $paramPane.css("text-align", "center");
                }else {
                    $paramPane.children(".x-table-wrapper").css("margin", "auto");
                } 
            } else if (paramO.alignLocation == 2) {
                if ($.browser.msie) {
                    $paramPane.css("text-align", "right");
                }else {
                    $paramPane.children(".x-table-wrapper").css("margin", "0px 0px 0px auto");
                }
            }
        }
		
		return $paramPane.asComponent("fr_form", config);
    }
});
// $.FR.BasePane end


$.widget("FR.PagePane");$.shortcut("page", "$.FR.PagePane")
FR.extend($.FR.PagePane, $.FR.BasePane, {
    rtype:"page",
    init : function() {
        $.FR.PagePane.superclass.init.apply(this, arguments);
    }
});
$.widget("FR.FormPane");$.shortcut("form", "$.FR.FormPane")
FR.extend($.FR.FormPane, $.FR.BasePane, {
    rtype:"form",
    init : function() {
        $.FR.FormPane.superclass.init.apply(this, arguments);
    }
});
$.widget("FR.WritePane");$.shortcut("write", "$.FR.WritePane")
FR.extend($.FR.WritePane, $.FR.BasePane, {
    rtype:"write",
    init : function() {
        $.FR.WritePane.superclass.init.apply(this, arguments);
    }
});

// $.FR.Composite.js

$.widget("FR.Composite");$.shortcut("composite", "$.FR.Composite")
FR.extend($.FR.Composite, $.FR.Widget, {
	init: function () {
		$.FR.Composite.superclass.init.apply(this, arguments);
		
		var o = this.options = $.extend({
			html : ""
		}, this.options);

		this.element.html(o.html);
		
		this.element.asComponent("fr_form", {
			selector : 'td[editor],td[widget]'
		})
		
		this.fireEvent(FR.Events.AFTERINIT);
	}
});


// $.FR.ToolBar.js
/*
 * $("<div>").ToolBar()
 * render
 * 
 * items : [{type + config}]
 */
$.widget("FR.ToolBar");$.shortcut("toolbar", "$.FR.ToolBar")
FR.extend($.FR.ToolBar, $.FR.Widget, {
	init : function() {
		$.FR.ToolBar.superclass.init.apply(this, arguments);
		var o = this.options = $.extend({
			items : []
		}, this.options)
        
		this.element.addClass("x-toolbar");
		
		// carl:ñĬϵľûtoolbarbg
		if(o.toolbarbg) {
			if (o.toolbarbg.background) {
				if($.browser.msie) {
					var ua = navigator.userAgent.toLowerCase();
					if(ua.indexOf('msie 6.0') == -1) {
						this.element.css('background',o.toolbarbg.background);
					} else {
						this.element.css('background',o.toolbarbg.background+" fixed");
					}
				} else {
					this.element.css('background',o.toolbarbg.background);
				}
			} else {
				this.element.css("background", "none");
			}
        }
		
		this.$tr = $("<tr>");
		this.$tr.appendTo($("<tbody>").appendTo($("<table cellspacing=0>").appendTo(this.element)));
		
		/*
		 * alex:ؼ
		 */
		if (o.items != null) {
			if (!FR.isArray(o.items)) {
				o.items = [o.items];
			}
			
			for (var i = 0; i < o.items.length; i++) {
				if (i > 0) {
					this.addSep();
				}
				var $dv = $("<div>")
				$dv.asComponent(o.items[i].type, o.items[i]);
				this.addJQuery($dv);
			}
		}
		
		// carl:Ӹ<a> ˵վⲿӣ֪ǲôŪ
		this.element.append('<a href="http://www.finereport.com" title="FineReport߹">   </a>');
	},
	
	/*
	 * JQueryToolBar
	 */
	addJQuery : function($jq) {
		if ($jq != null) {
			this.$tr.append($("<td>").append($jq))
		}
	},
	
	/*
	 * רŸ,ӷָ
	 */
	addSep : function() {
		this.addJQuery("<span class='sep'> </span>")
	}
});
// $.FR.ToolBar

// $.FR.Label
$.widget("FR.Label");$.shortcut("label", "$.FR.Label");
FR.extend($.FR.Label, $.FR.Widget, {
	init : function() {
		$.FR.Label.superclass.init.apply(this, arguments);
		var o = this.options = $.extend({
			tablable : true,
			render : false,
			prefix : 'x-lab' // Ĭcssʽǰ׺
		}, this.options)
		
		// renderΪfalseʱ,䱾һؼ,Ҫӽȥ
		if (o.render === true) {
			// carl:$("<label>")ieû
			this.$label = $("<label class=\"x-btn x-lab\"></label>").appendTo(this.element);
		} else {
			this.$label = this.element;
		}

		// richer:labelͼ
		this.$label.text(o.text);		
	},
		
	setText : function(text) {
		this.$label.text(text);
	},
	
	destroy : function() {
        this.element.empty();
    }	
});

/*
 * $.FR.Button
 * $("<div>").Button()
 * handler : onClick¼
 * scope : handler.scope
 * render : false:һbutton;true:һdiv
 * 
 * text : buttonʾ
 * icon : buttonʾͼ,һָiconͼurl·css:x-emb-pdfַ
 * 
 * @event
 * click
 * afterinit
 */
$.widget("FR.Button");$.shortcut("button", "$.FR.Button")
FR.extend($.FR.Button, $.FR.Widget, {
	init : function() {
		$.FR.Button.superclass.init.apply(this, arguments);
		var o = this.options = $.extend({
			tablable : true,
			render : false,
			prefix : 'x-btn' // Ĭcssʽǰ׺
		}, this.options)
		
		// renderΪfalseʱ,䱾һؼ,Ҫӽȥ
		if (o.render === true) {
			this.$btn = $("<div></div>").appendTo(this.element);
		} else {
			this.$btn = this.element;
		}
		
		this.$wrapper = this.element;
		
		if (o.tablable === true) {
			this.$btn.wrap("<table cellspacing=0 cellpadding=0 border=0><tbody><tr><td class='" + o.prefix + "-center'>");
			
			/*
			 * alex:Ϊie$btnһdiv,ﲻֱthis.$btn.parent(),һҪ$btn_center.htmldiv
			 */
			var $btn_center = this.$btn.parents('.' + o.prefix + '-center:eq(0)');
			$btn_center.html(this.$btn);
			
			var $btn_left = $("<td>").addClass(o.prefix + "-left").append("<i> </i>").insertBefore($btn_center);
			var $btn_right = $("<td>").addClass(o.prefix + "-right").append("<i> </i>").insertAfter($btn_center);
			// carl:Ϊΰ19px21pxһ,ieͲˣ˼һѸġ ǵborderʱ1
			if (!$.browser.ie && this.options.height && typeof this.options.height == 'number' && this.options.height < 22) {
				$btn_left.css("height", this.options.height - 1);
				$btn_right.css("height", this.options.height - 1);
			}
			
			this.$wrapper = this.$btn.parents('table:eq(0)'); // ȡ$btntableΪthis.$wrapper
		}
		
		// alex:$btncss
		this.$btn.addClass(o.prefix);
		//var text_icon_class = o.prefix;
		
		$icon_tr = $("<tr>").appendTo($("<table cellspacing=0 cellpadding=0 border=0>").appendTo(this.$btn));
		if (o.icon) {
			// carl:divûieͲϣӸո
			$icon_image = $("<div>").appendTo($("<td>").appendTo($icon_tr)).addClass("x-btn-image").text(" ");
			/*
		 	* alex:iconһurlַ,Ҳcss:/style:ͷַ
		 	*/
		
			if (o.icon) {
				// alex:css:ͷ,ʾ汣һcls
				if (o.icon.substring(0, 4) == "css:") {
					$icon_image.addClass(o.icon.substring(4));
				}
				// carl:ʹcssͼƬȡֱcss䣬ΪstyleͷʱΪcss
				else if (o.icon.substring(0, 6) == "style:") {
					$icon_image.css({background:o.icon.substring(6)});
				}
				// 򱣴ľһurl·
				else {
					$icon_image.css("background-image", "url(" + o.icon + ")");
				}
				
				//text_icon_class += "-icon";
			}
		}
		if (o.text) {
			$icon_text = $("<div>").appendTo($("<td>").appendTo($icon_tr)).addClass("x-btn-text");
			// alex:text,ӵ$btntext
			if (o.text) {
				$icon_text.text(o.text);
				//text_icon_class += "-text";
				//$icon_text.addClass(text_icon_class);
			}
		}
		
		// mouse event
		var self = this;
		var M = {
			onMouseOver : function(e) {
				self.$wrapper.addClass(o.prefix + "-over");
			},
			onMouseOut : function(e) {
				self.$wrapper.removeClass(o.prefix + "-over");
				self.$wrapper.removeClass(o.prefix + "-click");
			},
			onMouseDown : function(e) {
				self.$wrapper.addClass(o.prefix + "-click");
				$(document).bind("mouseup", M.onMouseUp);
			},
			onMouseUp : function(e) {
				self.$wrapper.removeClass(o.prefix + "-click");
				$(document).unbind("mouseup", M.onMouseUp);
			}
		}
		
		this.$btn.mouseover(M.onMouseOver.createInterceptor(this.isEnabled, this))
			.mouseout(M.onMouseOut)
			.mousedown(M.onMouseDown.createInterceptor(this.isEnabled, this))
			.mouseup(M.onMouseUp);
		
		this.$btn.click(function() {
			if (self.isEnabled()) {
				self.fireEvent(FR.Events.CLICK);
			}
		});
		
		// alex:¼Ļʵhandler
		if ($.isFunction(o.handler)) {
			this.on(FR.Events.CLICK, o.handler.createDelegate(o.scope || this));
		}
		
		this.fireEvent(FR.Events.AFTERINIT);
	},
	submit : function(){
		
	},	
	
    destroy : function() {
        this.element.empty();
    }
});

/*
 * menu:[{src, iconSrc, handler}]
 */
$.widget("FR.MenuButton");$.shortcut("menubutton", "$.FR.MenuButton")
FR.extend($.FR.MenuButton, $.FR.Button, {
	init : function() {
		$.FR.MenuButton.superclass.init.apply(this, arguments);
		
		/*
		 * alex:menuһĻ,clickʱ˵
		 * Ժ֧hoverʱ͵
		 */
		var menu = this.options.menu;
		if (FR.isArray(menu)) {
			this.on("click", function() {
				FR.showMenuByEl({
					destroyOnClose : true,
					items : menu
				}, this.element)
			}.createDelegate(this))
		}
        this.fireEvent(FR.Events.AFTERINIT);
	}
});

// $.FR.BaseEditor.start
$.widget("FR.BaseEditor");
FR.extend($.FR.BaseEditor, $.FR.Widget, {
	init : function() {
		$.FR.BaseEditor.superclass.init.apply(this, arguments);
        //ʼ༭Ŀؼ
		this.options = $.extend({
			render : true
		}, this.options);
		
    },

    getValue : function() {
       //ȡ༭ֵ
    },

    setValue : function(value) {
        //ñ༭ֵ
    },
    
    getText : function() {
    	// ȡ༭ʾֵ
    	return this.getValue();
    },
    
    reset : function() {
    	// ,ĿǰҪʱ,뵱ǰؼصĿؼֵıʱ,Ҫò
    	this.setValue("");
    },
    
    /*
     * copy style
     */
    cssFrom : function(dom) {
    },

    /**
	 * жϵǰEditorеֵȷ
	 */
    isValidate : function() {
        return true;
    },
    
    getErrorMsg : function() {
    	return '';
    },

    destroy : function() {
        //james:ݣshowDialogʱõ
        this.element.empty();
    },

    focus : function() {
        //jamesý
    },

    isDirty : function() {
    	return !FR.equals(this.options.value, this.getValue()); // Ƚԭʼֵ͵ǰֵ
    },
	
	/*
	 * ʼ༭
	 */
	startEditing : function() {
    	// james:Ҫsuperclassû TODOJ
    	this.fireEvent(FR.Events.BEFOREDIT);
	},
	
	/*
	 * ༭
	 */
	stopEditing : function() {
    	// james:Ҫsuperclassû TODOJ
		this.fireEvent(FR.Events.AFTEREDIT);
	}
});
// $.FR.BaseEditor.end

//FR.IframeEditor.start
$.widget("FR.IframeEditor");$.shortcut("iframe", "$.FR.IframeEditor")
FR.extend($.FR.IframeEditor, $.FR.BaseEditor, {
    init : function() {
        $.FR.IframeEditor.superclass.init.apply(this, arguments);
        //ؼ
        var o = this.options = $.extend({
            fieldName : "",//ؼ֣Ҫ
            src : "",// iframesrc
            //james-1ʾĬ
            width : 120,     //ؼĿ
            height : 19     //ؼĸ߶
        }, this.options);
        this.$editorComponent = this.element;
        this.$iframe = $("<iframe>").attr("scrolling", "no").attr("src", o.src).width(o.width).height(o.height).appendTo(this.$editorComponent);       
    },
    getValue : function(){
        return this.$iframe.attr("src");
    },
    setValue : function(src){
        this.$iframe.attr("src", src);
    } //Ϊһ,IEҳ涼Ŷðҵ
});
//FR.IframeEditor.end

/*
 * alex:!important ڱڱ༭ֵ,$editorComponent.val(),ıĵطһvalue
 * ,Ա֤ȡֵ$editorComponentʵʱı
 * ͬʱҲһЩС,ʾ$editorComponentֵ,ҪһЩֵ
 * NumberEditor֮String2Number, Combo֮Map
 */
//FR.TextEditor.start
/**
* Example:
* config = {
* width : -1,//ؼĳȣ-1ʾĬ
* height : -1,//ؼĸ߶ȣ-1ʾĬ
* minLength : -1,//ַ-1ʾĬ
* maxLength : -1,//ַ-1ʾĬ
* value : '',//Ĭֵ
* allowBlank : true|false,//ǷΪ
* regex : ''//д
* errorMsg : ''//дʱıϢ
* style : "display:none;vertical-align:center" || {display:'none', vertical-align:'center'}
* }
* @param Number width The length of the widget
* @param Number height The height of the widget
* @param Number minLength The minimum length of characters needed
* @param Number maxLength The maximum length of characters needed
* @param Object value The default value of the widget
* @param Boolean allowBlank Does the widget allow blank
* @param String regex The regex used to verify the value of the widget
* @param String errorMsg The error message of the widget
* 
* @event
* contentchange ıڱ༭ʱ¼
* change TextEditorӦvalueı¼
*/
$.widget("FR.TextEditor");$.shortcut("text", "$.FR.TextEditor")
FR.extend($.FR.TextEditor, $.FR.BaseEditor, {
    init : function() {
        $.FR.TextEditor.superclass.init.apply(this, arguments);

        //ؼ
        var o = this.options = $.extend({
            cls : 'x-form-field x-form-text', //ؼcss
            fieldName : "",//ؼ֣Ҫ
            //james-1ʾĬ
            width : 120,     //ؼĿ
            height : 19,     //ؼĸ߶
            editable : true, //james:ǷԱ༭
            autoVerify : false, //ʵʱУ
            multiline : false //Ƿ
        }, this.options);
        
        //ӿؼ
        if (o.render === true) {
        	if(o.passwordText === true) {
        		this.$editorComponent = $("<input type=\"password\"/>").appendTo(this.element);	
        	} else {
        		var self = this;
        		var $textarea = $("<textarea>").keydown(function(e){
        		    var eel = this;
    				if (e.ctrlKey && e.keyCode == 13){
    				     e.ctrlKey = false;
    				     eel.value += "\n";  
    				     // richer:IE¹			     
    				     if(this.createTextRange){  
    				        var pos = eel.value.length;
    				        var rng = eel.createTextRange(); //½textRange  
                            rng.moveStart('character', pos); //rngĿʼλ  
                            rng.collapse( true ); //ƶΧβ  
                            rng.select();//ѡ  
                            eel.focus();
    				     }
    				}
        		});
        		this.$editorComponent = (o.multiline === true ? $textarea : $("<input type=\"text\"/>")).appendTo(this.element);
        		// richer:ieĪĲһ</div>,ȥ
        		if (!this.options.value) {
        			  this.$editorComponent.val("");
        		}
        	}
        } else {
            this.$editorComponent = this.element;
        }
        if (o.id) {
            this.$editorComponent.attr('id', o.id);
        }
        if (o.editable !== true) {//ɱ༭Ļֻ
        	this.$editorComponent.attr('readonly', true);
        }
        if (o.disabled == true) {
        	this.$editorComponent.attr("disabled", "disabled");
        }
        
        this.errorMsg = this.options.errorMsg || '';//james:ERROR MessageҪ
        this.$editorComponent.removeClass('x-form-invalid');//ʼʱƳʶ
        this.$editorComponent.removeAttr('title');
        
        this.$editorComponent.attr("name", o.fieldName).addClass(o.cls);
        if (o.width > -1) {
            this.$editorComponent.css("width", o.width);
            this.element.css("width", o.width);
        }
        if (o.height > -1) {
        	this.element.css("height", o.height);
//        	if ($.browser.msie) {
//        		//carl:tr߼ȥ2pxieвãҪĬи19ҰҲˡ
//        		this.$editorComponent.css("height", o.height - 2); 
//        	} else {
                this.$editorComponent.css("height", o.height - 2); // alex:ȥ±߿ĸ߶
//          }
        }
        // alex:styleΪ
        FR.applyStyles(this.$editorComponent, o.style);
        if (o.value) {
        	//james:setValueԼݲֵͬ
        	this.setValue(o.value);
        }

        var self = this;
        //ӿؼԪ
        this.$editorComponent.focus(function() {//ýʱ
//        	self.$editorComponent.removeClass('x-form-text').addClass('x-form-text-focus');
        }).blur(function () {//ʧȥʱ
//	       	self.$editorComponent.removeClass('x-form-text-focus').addClass('x-form-text');
	       	//jamesû壬ǷУ
	       	if (o.autoVerify && !self.isValidate()) {//ԶУֵУδͨ
	       		self.$editorComponent.addClass('x-form-invalid');
	       		self.$editorComponent.attr('title', self.getErrorMsg());
	       		//Уδͨʱʾԭֵ԰ɣӦûʾֵ
	       		//self.$editorComponent.val(o.value);
	       	} else {
				self.$editorComponent.removeClass('x-form-invalid');
				self.$editorComponent.removeAttr('title');
	        }
	        //richer:
//	        self.fireEvent(FR.Events.AFTEREDIT, e);
        }).keyup(function(e) {
			self.fireEvent(FR.Events.AFTEREDIT, e);
        });
    },
    
    /*
     * fire value change
     */
    setValue : function(value) {
    	this.$editorComponent.val(value);
    	
    	// alex:ϵֵthis.options.value,жisDirty
    	var oldValue = this.options.value;
    	this.options.value = value;
        
    	this.fireEvent(FR.Events.CHANGE, value, oldValue); // fire value change event, newValue & oldValue
    },
    
    getValue : function() {
    	return this.$editorComponent.val();
    },
    
    cssFrom : function(dom) {
    	var $dom = $(dom);
		var $comp = this.$editorComponent;
    	$comp.removeClass().addClass($dom.attr("class"));
    	// richer:ʱ༭Ӹͼõ
    	if ($dom.attr("editor").indexOf('"type":"datetime"') > 0){
    		$comp.addClass("dpPicker");
    	}
    	   	  	
		// alex:$domĲstyle
    	$.each(['fontFamily', 'fontVariant', 'fontStyle', 'fontWeight', 'fontSize',
			'paddingTop', 'paddingBottom', 'paddingLeft', 'paddingRight', 'backgroundColor'], function(idx, el) {
    		$comp.css(el, $dom.css(el));
    	})
		if ((/transparent|rgba\(0, 0, 0, 0\)/).test($comp.css('backgroundColor'))) {
			$comp.css('backgroundColor', 'white')
		}
    },

    isValidate : function(cValue) {
        var allowBlank = this.options.allowBlank != false; // james:ĬΪ

		var minLength = this.options.minLength;

		var value = cValue ? cValue : this.getValue();
		var regex = this.options.regex;
		// richer:жд
		if (regex) {
            if (typeof regex == 'string') {//Stringʱ򣬹һRegExp
                regex = new RegExp(regex);                         
            }
            if (!regex.test(value)) {
            	this.errorMsg = this.options.errorMsg || FR.i18n.Error_Input_Value;
                return false;
            }
        }
        
        if ((!value || value.length <= 0)) {//ֵΪյʱ
            if (allowBlank != false) {//ΪգͷTRUE
            	return true;
            } else {//ΪգǾͼ
            	this.errorMsg = this.options.errorMsg || FR.i18n.NOT_NULL;
            	return false;
            }
        }
        
        return true;
    },
    
    getErrorMsg : function() {
    	return this.errorMsg;
    },

    /**
     * Selects text in this field
     * @param {Number} start (optional) The index where the selection should start (defaults to 0)
     * @param {Number} end (optional) The index where the selection should end (defaults to the text length)
     */
    selectText : function(start, end) {
        //james:Ext
        var cv = this.$editorComponent.val();
        if (cv && cv.length > 0) {
            start = start === undefined ? 0 : start;
            end = end === undefined ? cv.length : end;
            var d = this.$editorComponent[0];
            if(d.setSelectionRange){
                d.setSelectionRange(start, end);
            }else if(d.createTextRange){
                var range = d.createTextRange();
                range.moveStart("character", start);
                range.moveEnd("character", end - cv.length);
                range.select();
            }
        }
    },
	// richer:ͱ༭isDirtyҪж,ΪֵparserҲ0
    isDirty : function() {
    	if (this.getValue() == 0) {
    		return true;
    	}
    	return !FR.equals(this.options.value, this.getValue()); // Ƚԭʼֵ͵ǰֵ
    },
	/*
	 * ʼ༭
	 */
	startEditing : function() {
    	this.fireEvent(FR.Events.BEFOREEDIT, this);
		this.$editorComponent.show().focus();
		this.selectText();
	},
	
	/*
	 * ༭
	 */
	stopEditing : function() {
		this.fireEvent(FR.Events.AFTEREDIT, this);
		this.$editorComponent.blur().hide();
	}
});
//FR.TextEditor.end

//FR.NumberEditor.start
$.widget("FR.NumberEditor");$.shortcut("number", "$.FR.NumberEditor")
FR.extend($.FR.NumberEditor, $.FR.TextEditor, {
    init : function() {
        $.FR.NumberEditor.superclass.init.apply(this, arguments);

        var o = this.options = $.extend({
            allowDecimals : true,
            allowNegative : true,
            decimalPrecision : -1,
            decimalSeparator : '.'//decimalķָ
            // alex:value:0ΪĬֵ,ᵼBS༭ʱ,д0,isDirty == false,ֵ
        }, this.options);
        var baseChars = '0123456789';

        var allowed = baseChars+'';
        if(o.allowDecimals){
            allowed += '.';
        }
        if(o.allowNegative){
            allowed += "-";
        }
        
        this.setValue(o.value);
        //b:뷨
        this.$editorComponent.css("ime-mode", "disabled");
        var errorMsg = this.options.errorMsg || FR.i18n.Value_Not_Match;
        this.$editorComponent.keypress(function(e) {
            //james:ǳExt
            var k = e.keyCode;
            if(!$.browser.msie &&
              (FR.isNavKeyPress(e)
                    || FR.isSpecialKey(e)
                    || k == $.keyCode.BACKSPACE
                    || k == $.keyCode.DELETE)){
                return;
            }
            var c = e.charCode || e.keyCode;//jamesIEҪȡkeyCode
            var cc = String.fromCharCode(c);
            if($.browser.msie && (FR.isSpecialKey(e) || !cc)){
	            return;	            
	        }
            
            if(allowed.indexOf(cc) === -1){
            	FR.Msg.alert(FR.i18n.Alert, errorMsg);
            	e.preventDefault();           	
            }
            
            if (this.value.indexOf('.') > -1 && cc == '.') {
            	FR.Msg.alert(FR.i18n.Alert, errorMsg);
            	e.preventDefault();
            }
        });
    },
    
    /*
     * fire value change
     */
    setValue : function(value) {
    	var oldValue = this.getValue();
        
        value = parseFloat(value);
    	this.$editorComponent.val(
    		isNaN(value) ? '' : String(value).replace(".", this.options.decimalSeparator)
    	);
    	
    	// alex:ϵֵthis.options.value,жisDirty
    	var oldValue = this.options.value;
    	this.options.value = value;
        
    	this.fireEvent(FR.Events.CHANGE, value, oldValue); // fire value change event, newValue & oldValue
        
    },
    /**EXT**/
    _fixPrecision : function(value){
        var nan = isNaN(value);
        if(!this.options.allowDecimals || this.options.decimalPrecision == -1 || nan || !value){
           return nan ? '' : value;
        }
        return parseFloat(parseFloat(value).toFixed(this.options.decimalPrecision));
    },
    /**EXT**/
    _parseValue : function(value){
        value = parseFloat(String(value).replace(this.options.decimalSeparator, "."));
        return isNaN(value) ? '' : value;
    },
    //jamesֱ༭ķֵûֵͷ''0ͷ0
    //طҪûķǷҪṩõĵط
    getValue : function() {
    	var number = this._fixPrecision(this._parseValue(this.$editorComponent.val()));
        return number;
    },
    
     verifyDedimals : function() {
	 	if (typeof this.$editorComponent.reg == "undefined") {
			 this.$editorComponent.reg = (this.options.allowNegative ? "\-?" : "") + "\\d+" + (this.options.allowDecimals ? ("(\\.\\d{0," + this.options.maxDecLength + "})?") : "");
	 	}
		var pattern = new RegExp(this.$editorComponent.reg);
	 	var result = pattern.exec(this.$editorComponent.val());
	 	if (result != null) {
	 		return result[0];
 		}
 		return "";
	}, 
	
	recoveryValue : function() {
		this.$editorComponent.val(
    		isNaN(this.options.value) ? '' : String(this.options.value).replace(".", this.options.decimalSeparator)
    	);
	},

    isValidate : function(cValue) {
        var value = cValue ? cValue : this.$editorComponent.val();     
        // richer:Ϊ
        //b: ȷôû
        if (value == "" || value == null || value == undefined ) {
        	if (this.options.allowBlank != false) {
        		return true;
        	} else {
        		this.errorMsg = this.options.errorMsg || FR.i18n.NOT_NULL;
        		return false;
        	}
        }
       
        value = String(value).replace(this.options.decimalSeparator, ".");
        if(isNaN(value)){
            this.errorMsg = this.options.errorMsg || FR.i18n.Value_Must_Be_A_Number;
            return false;
        }
        // ΪС
        if (value.indexOf(this.options.decimalSeparator) > 0) {
        	if (!this.options.allowDecimals ) {
        		this.errorMsg = this.options.errorMsg || FR.i18n.Value_Cannot_Be_Decimal;
        		return false;
        	} else if (this.options.allowDecimals && (value.length - value.indexOf(this.options.decimalSeparator) > this.options.maxDecLength + 1)) {
        		this.errorMsg = this.options.errorMsg || FR.i18n.Value_DecimalNumber_Out;
        		return false;
        	}

        }

        var num = this._parseValue(value);
                // ΪС
        if (num.toString().indexOf(this.options.decimalSeparator) > 0) {
        	if (!this.options.allowDecimals ) {
        		this.errorMsg = this.options.errorMsg || FR.i18n.Value_Cannot_Be_Decimal;
        		return false;
        	} else if (this.options.allowDecimals && (num.toString().length - num.toString().indexOf(this.options.decimalSeparator) > this.options.maxDecLength + 1)) {
        		this.errorMsg = this.options.errorMsg || FR.i18n.Value_DecimalNumber_Out;
        		return false;
        	}

        }
        // Ϊ
        if (!this.options.allowNegative && num < 0){
        	this.errorMsg = this.options.errorMsg || FR.i18n.Value_Cannot_Be_Negative;
        	return false;
        }
        if (this.options.minValue && num < this.options.minValue) {
            this.errorMsg = this.options.errorMsg || FR.i18n.Value_Is_Less_Than_Minimum + this.options.minValue;
            return false;
        }
        if (this.options.maxValue && num > this.options.maxValue) {
            this.errorMsg = this.options.errorMsg || FR.i18n.Value_Is_Larger_Than_Maximum + this.options.maxValue;
            return false;
        }
        return true;
    }
});
//FR.NumberEditor.end

//TriggerEditor.start
$.widget('FR.TriggerEditor');
FR.extend($.FR.TriggerEditor, $.FR.TextEditor, {
	init : function() {
		$.FR.TriggerEditor.superclass.init.apply(this, arguments);
		
		var o = this.options;
		
		//james:widthheightĬֵɣȻTriggerEditorʱ򣬲ֵIEлᱨ
		//ΪTextEditorеĬֵΪ-1;-1ֵIEǻᱨ
		// alex:TextEditorѾĬֵ,ͲҪ
//		o.width = (o.width == -1) ? 125 : o.width;
//		o.height = (o.height == -1) ? 21 : o.height;
		
		//alex:Ҫelementpositionrelative,ΪimgҪԶλ
		//jamesҪҪwidthȻIEУڶʹTriggerEditorʱTriggerλ
        //james:ıinputĳȣոimg17imgĿ
		this.$editorComponent.wrapAll($('<div>').css({position:'relative', width : o.width})).width(o.width - 17);
		//ȡwrappertriggerӽȥ
		this.$wrapper = this.$editorComponent.parent();
		
		var triggerFn = this.onTriggerClick.createDelegate(this);
		var $triggerDiv = $("<img src='" + FR.i18n.servletURL + "?op=resource&resource=/com/fr/web/images/s.gif'>");
		if ($.browser.msie){
			$triggerDiv = $("<div>");
		} 
		this.$trigger = $triggerDiv
		.appendTo(this.$wrapper).Button({
                tablable : false,
                icon : FR.i18n.servletURL + '?op=resource&resource=/com/fr/web/images/jquery/trigger.gif',
                render : false,
                prefix : 'x-trigger',
                handler : triggerFn
        }).css({width:17, height: (o.height - ($.browser.msie ? 2 : 3))});  //-1Ϊtriggerһheight
        															// carl:ie - 2 ff -3 texteditorŵ
        var ua = document.documentMode;
        //ben: ie 8ں˰汾ie7Ȼie8вõuaôʱ
        if ($.browser.msie && ua == undefined) {
        	//IEУͼtopλҪ1pxȻtextFieldԲ
        	// carl:ҪΪʲôҺ֪ܰ
			this.$trigger.css("top", (o.height % 2 == 0 ? 1 : 2));
		}
    	
    	if (o.editable !== true) {
    		// jamesֻĻeditorComponenetֱӵcontent
    		this.$editorComponent.css('cursor', 'pointer').mousedown(triggerFn);
		}

		// alex:$editorComponent.keydown
		this.$editorComponent.bind('keydown', this, this._onKeyDown);
    },
    
    /*
     * alex: trigger clickʱ򴥷¼
     */
    onTriggerClick : function() {
    	
    },
    
    // richer:ȡ༭ʾֵ(һؼĲ˵ʹõֵ䣬Ҳ漰ʵֵʾֵ)
    // صʾֵҲthis.$editorComponent.val()
    getText : function() {
    	return this.$editorComponent.val();
    },
    
    //james:ͨtriggerICON
    setIcon : function(iPath) {
    	if (this.$trigger && iPath) {
    		this.$trigger.css('background-image', 'url(' + iPath + ')');
    	}
    },
    
    isValidate : function(cValue) {
    	var allowBlank = this.options.allowBlank != false; // james:ĬΪ

		var value = cValue ? cValue : this.getValue();
//		if (FR.isArray(value)){
//			value = value[0];
//		}
		var regex = this.options.regex;
		// richer:жд
		if (regex) {
            if (typeof regex == 'string') {//Stringʱ򣬹һRegExp
                regex = new RegExp(regex);                         
            }
            if (!regex.test(value)) {
            	this.errorMsg = this.options.errorMsg || FR.i18n.Error_Input_Value;
                return false;
            }
        }
        if ((!value) || FR.isEmptyArray(value)) {//ֵΪյʱ
            if (allowBlank) {//ΪգͷTRUE
            	return true;
            } else {//ΪգǾͼ
            	this.errorMsg = this.options.errorMsg || FR.i18n.NOT_NULL;
            	return false;
            }
        }
        return true;
    },
	/*
	 * ʼ༭
	 */
	startEditing : function() {
    	this.fireEvent(FR.Events.BEFOREEDIT);
    	this.$wrapper.show();
    	$.FR.TriggerEditor.superclass.startEditing.apply(this, arguments);
	},
	
	/*
	 * ༭
	 */
	stopEditing : function() {
		this.fireEvent(FR.Events.AFTEREDIT);
    	this.$wrapper.hide();
    	$.FR.TriggerEditor.superclass.stopEditing.apply(this, arguments);
	}
});
//TriggerEditor.end

//FR.ComboBoxEditor.start
/**
* Example:
* config = {
*   allowBlank : true,
*   filter : "",
*   items : [{text:'', value:''},...],//ȼURLݵȻõǰʾ
*   value : "",
*   url : "",//̬ʱãֵӦǡdataĸʽ
* }
*/
$.widget("FR.ComboBoxEditor");$.shortcut("combo", "$.FR.ComboBoxEditor")
$.FR.ComboBoxEditor.$view_container = $("<div class='view-container'>"); // alex:ͳһذ$view
// TODOJ jamesطĬϾdivӵbodyУð???
$(function() {
	$.FR.ComboBoxEditor.$view_container.appendTo('body');
})
FR.extend($.FR.ComboBoxEditor, $.FR.TriggerEditor, {
	init : function() {
		$.FR.ComboBoxEditor.superclass.init.apply(this, arguments);

        // ؼ
        var o = this.options = $.extend({
        	maxCount : 10,//һҳʾļ¼
        	mode : 'remote', //[localremote]һʹõʱremoteģҲҪԶȡȡԺ󣬾ΪlocalٴδԶȡ
            url : this.options.url,
            autoMode : true,//james:ɺԶmodeΪfalseǽһֱömodeȡ
            value : ''
        }, this.options);
        
        // ÿComboӦһdiv -> $view
        var self = this;
        this.$view = $('<div>').appendTo($.FR.ComboBoxEditor.$view_container).height(20);
      	this.$editorComponent.keyup(function(event){
      		// richer:Ҫֱӱ༭ʱṩٶλ
      		if (!FR.isNavKeyPress(event) && self.options.editable){
      			self.quickSearch(self.$editorComponent.val());
      		}
      	});
    	this.$view.hide();//james:
		/*
		 * alex:BUG0001369,ԭûnullж,ᵼitemsʼĻʹitemsΪ[]
		 * ôԭֵΪF,ΪitemsΪnull,Ͳ_getItems,ô$editorComponentлʾF
		 */ 
    	// alex:ʼo.items
		if (o.items != null) {
    		this._setItems(o.items);
		}
    },
    
    // richer:ٶλ
    quickSearch : function(value){
    	// richer:ûд
    	if (!this.isExpanded()) {
    		this.onTriggerClick();
    	}
    	var children = this.$view.children('.x-combo-list-item');
    	$.each(children, function(i, item){
    		var text = $(item).text();
    		if(!value) {
    			$(item).css("display", "block");
    			return;
    		}
    		if (text.indexReg(value, true) > -1 || text == ""){
    			$(item).css("display", "block");
    		} else {
    			$(item).css("display", "none");
    		}
    	});
    },
    _onKeyDown : function(e) {
    	var self = e.data;
    	switch (e.keyCode) {
    		case $.keyCode.DOWN : {
	    		if (!self.isExpanded()) {
	    			self.onTriggerClick();
	    		} else {
	    			var selected = self._getSelectedIndex();
	    			var nextIndex = 0;
	    			if (selected.length > 0) {
	    				nextIndex = selected[0] + 1;
	    			}
	    			
	    			if (nextIndex < self.options.items.length) {
	    				self._setSelectedIndex(nextIndex);
	    			}
	    		}
	    		e.stopEvent();
    			break;
    		}
    		case $.keyCode.UP : {
    			if (self.isExpanded()) {
    				var selected = self._getSelectedIndex();
    				var nextIndex = 0;
    				if (selected.length > 0) {
    					nextIndex = selected[0] - 1;
    				}
    				
    				if (nextIndex >= 0) {
    					self._setSelectedIndex(nextIndex);
    				}
	    			e.stopEvent();
    			}
    			break;
    		}
    		case $.keyCode.ENTER: case $.keyCode.TAB : {
    			if (self.isExpanded()) {
					self._onEnterPressed();
    				e.stopEvent();
    			}
    			break;
    		}
    	}
    },
    
    onTriggerClick : function() {
    	// richer:һµť¼
    	if (this.fireEvent(FR.Events.CLICK) === false) {
    		return false;
    	}
    	
    	if (!this.isEnabled()) {
    		return;
    	}
    	
    	if (this.isExpanded()) {
    		this.collapse();
    	} else {
    		// richer:ҪȰеviewص
    		$(".x-combo-list-inner").hide();
	    	var o = this.options
	       	//jamesãΪ_getOffsetҪ$editorComponentԺ
    		var os = this.$editorComponent.offset();
			this.$view.addClass('x-combo-list x-combo-list-inner')
	   			.css({
	   				position: 'absolute', 
	   				top : parseInt(os.top) + parseInt(o.height), 
	   				left : os.left, 
	   				width: o.width, 
	   				overflow : 'auto',
	   				'z-index' : '1010'
	   			})
	   		if (o.mode == 'local') {
	   			// richer:this.modifyPosition()ʱҪthis.tH治ڣֿ
	   			this.modifyPosition();
	   			this.expand();//localʾѾعˣҪ¼أֱʾͿ
	   		} else if (o.mode == 'remote' && o.widgetUrl != null) {
	   			this.$view.empty();//
	            this.$view.height(20).show();//߶ȣʾloadingͼ갡
	            this.$view.__loading__(true);
	            this._getItems();
		    	this.$view.__loading__(false).hide();
	            this._setItems(o.items);
	            this.modifyPosition();
	            if (o.autoMode === true) {//ԶmodeʱŸ
					o.mode = 'local';//modeΪlocalٴμ
				}
				/*
				 * alex:__loading__ʱexpand,expandʱҪpopǰֵ,ԱҪȡ
				 */
				this.expand();
	    	}
    	}
    },

    // alex:ȡitems
    _getItems : function() {
    	var o = this.options;
    	// carl׼ûչģdependenceŪ
    	// չҪdependenceMapӳ֪Ӧչĸ
    	var depO = {};
    	if(o.dependenceMap){
    		var self = this;
    		$.each(o.dependenceMap, function(key, item){
    			if (self.options.form) {
    				// richer:ͬFR_FORMһ£ֲĴСд
    				depO[key] = self.options.form.resolveVariable(item.toUpperCase());
    			} else {
    				// richer:״̬
    				depO[key] = contentPane.curLGP.getCellValue(item.toUpperCase().startWith("$") ? item.toUpperCase().substring(1) : item.toUpperCase());
    			}
    		});
    	} else if (FR.isArray(o.dependence)) {
    		for (var idx = 0; idx < o.dependence.length; idx++) {
    			var dep = o.dependence[idx];
    			if (this.options.form) {
    				// richer:ͬFR_FORMһ£ֲĴСд
    				depO[dep] = this.options.form.resolveVariable(dep.toUpperCase());
    			} else {
    				// richer:״̬
    				depO[dep] = contentPane.curLGP.getCellValue(dep.toUpperCase().startWith("$") ? dep.toUpperCase().substring(1) : dep.toUpperCase());
    			}
    		}
    	}
        $.ajax({
		    url : o.widgetUrl,
		    data : {
		    	// alex:˵ҪcjkEncodeԱ
		    	dependence : FR.cjkEncode(FR.jsonEncode(depO))
		    },
        	cache : false,
			async : false,
	        complete: function(res) {
	        	if (!FR.versionRemind(res.responseText)) return;
	        	o.items = FR.jsonDecode(res.responseText) || [];
	        }
	    })
    },
    
    // MODE,ǿ¼
    setMode : function(mode) {
    	if (this.options.autoMode === true) {//autoModeʱָ֧mode޸
    		this.options.mode = (mode == 'local') ? 'local' : 'remote';
    	}
    },
    
    /*
     * 
     */
    _setItems : function(items, filter) {
    	items = items || [];
    	// richer:ڹ˵ĻͲҪıԭitems
    	if (!filter) {
    		this.options.items = items;
    	}
    	var self = this;
    	if (!(this.options.allowBlank === false)){
    		items = [{value : '', text : this.options.name4Empty == null ? '' : this.options.name4Empty}].concat(items);
    	}
    	if (this.options.name4Empty) {
    	// richer:ֵøʾֵ
    		$.each(items, function(i, item){
    			if (!item.value) {
    				items[i].text = self.options.name4Empty;
    			}
    		});
    	}
    	  	
    	this.$view.empty();
    	
    	// itemsĸ,̬ø߶
    	var sH = 18; // james:߶
    	var count = this.options.maxCount || 10; //Ĭʾ10
    	this.tH = items.length > count ? (sH + 2) * count : (sH + 2) * items.length; // 2padding=Border
		this.$view.height(this.tH);// heightaddItemsʱ
		this.modifyPosition();		
    	$.each(items, function(idx, it) {
    		$('<div>').appendTo(self.$view).height(sH).text(it.text)
    		.attr("title", it.text)
    		.addClass('x-combo-list-item')
    		.mouseover(function() {
    			self._setSelectedIndex(idx);
    		})
    		.click(function() {
				self._onEnterPressed();
    		});
    	});
    },
	
	// alex:ѡĳItem...
	_onEnterPressed : function() {
		// alex:ֻı$editorComponent.val,setValueıthis.options.value(for isDirtyж)
    	this.$editorComponent.val(this._getSelectedItem().text());
    	this.collapse();
    	
    	//richer:
        this.fireEvent(FR.Events.AFTEREDIT, this._getSelectedItem().text());
	},
    
    // $viewǷڴ״̬
    isExpanded : function() {
    	return this.$view && this.$view.is(":visible");
    },
    
    /*
     * alex:ע,ͨe.dataķʽthis,Ϊjqueryôһ¼ģʽ, differ from Ext
     */
    collapseIf : function(e) {
    	var target = e.target, self = e.data;
    	if (!FR.contains(self.$view[0], target) && !FR.contains(self.$wrapper[0], target)) {
    		self.collapse();
    	}
    },
    
    // $view
    expand : function() {
    	if (this.isExpanded()) {
    		return;
    	}
    	
    	this._showView();
    	
    	$(document).bind('mousedown', this, this.collapseIf).bind('mousewheel', this, this.collapseIf);
    	this.$editorComponent.focus();
    	this.fireEvent(FR.Events.EXPAND);
    },
    
    _showView : function() {
    	this.$view.show(); // show,_setSelectedIndex,Ϊ_setSelectedIndexʱҪscroll,ҲҪshow
    	
    	var currentValue = this.getValue(), self = this;
    	this.$view.children('.x-combo-list-item').each(function(idx, it) {
    		if (currentValue == $(it).data("_value")) {
    			self._setSelectedIndex(idx);
    			return false;
    		}
    	});
    },
    
    _getSelectedItem : function() {
    	return this.$view.children('.x-combo-selected');
    },
    
    _getSelectedIndex : function() {
    	var children = this.$view.children('.x-combo-list-item');
    	return this.$view.children('.x-combo-selected').map(function() {
    		return $.inArray(this, children);
    	});
    },
    
    _setSelectedIndex : function(idx) {
    	/*
    	 * alex:ԭ$view.childrent('eq(0)').addClass().__scroll__().siblings().removeClass()
    	 * ieйһЩ,ĳַʽͲ
    	 */
    	this.$view.children('.x-combo-list-item').removeClass('x-combo-selected');
    	this.$view.children('.x-combo-list-item:eq(' + idx + ")")
    	.addClass('x-combo-selected')
    	.__scroll2View__(this.$view, false)
    },
    
    // $viewص
    collapse : function() {
    	if (!this.isExpanded()) {
    		return;
    	}
    	
    	this.$view.hide();
    	$(document).unbind('mousedown', this.collapseIf).unbind('mousewheel', this.collapseIf);
    	this.$editorComponent.focus();
    	this.fireEvent(FR.Events.COLLAPSE);
    },
    
	// ֵ
	setValue : function(value) {
		var fn = function() {
			var items = this.options.items, dp = value;
			for (var i = 0; i < items.length; i++) {
				if (items[i].value == value) {
					dp = items[i].text;
					break;
				}
			}
			
			this.$editorComponent.val(dp);
    	
	    	// alex:ϵֵthis.options.value,жisDirty
	    	var oldValue = this.options.value;
	    	this.options.value = value;
	        
	    	this.fireEvent(FR.Events.CHANGE, value, oldValue); // fire value change event, newValue & oldValue
		}
		
		// alex:this.options.itemsΪnullʱҪ_getItems
		if (this.options.items == null) {
			this._getItems();
		} 
		fn.call(this);
	},
	
	// ȡֵ
	getValue : function() {
		var dp = this.$editorComponent.val();				
		var items = this.options.items, val = dp;
		if (dp == this.options.name4Empty){
			val = "";
		}
		
		var index = this._getSelectedIndex()[0];

		// richer:ΪյʱбҲûпֵ
		//b:Ӧȡeditorֵindexı仯һıֵbugstopedtingʱǷΪ
		if (this.options.allowBlank === false) {
			index++;
		}
        // richer:˵ѡǿֵ
		if (index == 0){
			return "";
		} else if (this.options.items) {
			if (typeof index == "number" && !isNaN(index) && this.options.items[index - 1].text == dp) {
				return this.options.items[index - 1].value;
			} else if (FR.isArray(items) && items.length > 0) {
				for (var i = 0, len = items.length; i < len; i++) {
					if (items[i].text == dp) {
						val = items[i].value;
						break;
					}
				}
				return val;
			}
			return val;
		}
	},
	
    reset : function() {
    	// ,ĿǰҪʱ,뵱ǰؼصĿؼֵıʱ,Ҫò
    	$.FR.ComboBoxEditor.superclass.reset.apply(this, arguments);
    	
    	this.setMode("remote");
    },
    // richer:popupλ
    modifyPosition : function(){
    	var cH = document.body.clientHeight - $(".x-toolbar").height();// ȥĸ߶
    	var eH = this.$editorComponent.offset().top;// ༭ĸ߶
    	var wH = this.options.height;// ༭ĸ߶
    	
    	if (cH < eH + parseInt(wH)) {
    		this.$view[0].style.top = eH - this.tH;
    	}
    	if (this.options.popupWidth) {
    		this.$view.width(this.options.popupWidth);
    	}
    	if (this.options.popupHeight){
    		this.$view.height(this.options.popupHeight);
    	}
    }
});
//FR.ComboBoxEditor.end

//FR.CheckBoxEditor.start
$.widget("FR.CheckBoxEditor");$.shortcut("combocheckbox", "$.FR.CheckBoxEditor")
FR.extend($.FR.CheckBoxEditor, $.FR.ComboBoxEditor, {
	init : function() {
		$.FR.CheckBoxEditor.superclass.init.apply(this, arguments);
		
		this.options = $.extend({
			// ƴַķָ
			delimiter : ',', 
			// richer:ʾʱķָ
			des : ',',
			startSymbol : '',
			endSymbol : ''
		}, this.options);
		// richer:ΪFR.jsonDecode()ȷĽԷ
		this.options.delimiter = this.options.delimiter.replace(/\\r/g, "\n");
	},
	// richer:ѡԶȲдоûҪ
	quickSearch : function(value){
	 	
	},
	/*
	 * ComboBoxEditorĻ,һSPACE¼
	 */
	_onKeyDown : function(e) {
		$.FR.CheckBoxEditor.superclass._onKeyDown.apply(this, arguments);
		
    	var k = e.keyCode;
    	var self = e.data;
		if (self.isExpanded() && k == $.keyCode.SPACE) {
			var selected = self._getSelectedIndex();
			if (selected.length > 0 && selected[0] >= 0) {
				var ck_el = self.ck_el_array[selected[0]]
				ck_el.selected(!ck_el.selected());
				
				e.stopEvent();
			}
		}
	},
    
    /*
     * 
     */
    _setItems : function(items) {
    	items = items || [];
    	this.options.items = items;
    	
    	this.$view.empty();
		this.ck_el_array = []; // alex:³ʼck_el_array
    	
    	// itemsĸ,̬ø߶
    	var sH = 18; // james:߶
    	var count = this.options.maxCount || 10; //Ĭʾ10
    	var th = items.length > count ? (sH + 2) * count : (sH + 2) * items.length; // 2padding=Border
		if ($.browser.msie) {
			this.$view.height(th + 18);// heightaddItemsʱ
			this.tH = th + 8;
		} else {
			this.$view.height(th + sH);
			this.tH = th + sH;
		}
		this.modifyPosition();
		var self = this;
		// richer:Ϊѡȫѡ
		this.$controlPane = $("<div style='display:inline padding-right:20px'>").addClass('x-checkbox-control').CheckBox({text : FR.i18n.Choose_All + "/" + FR.i18n.Deselect_All})
		var controlBox = $.data(this.$controlPane[0], "CheckBox");
		this.$controlPane.click(function(){
			// ȫѡ
			if (controlBox.selected()) {
				self.doSelectAll(items);
		    // ѡ	
			} else {
				self.deSelectAll(items);
			}
			self.fireEvent(FR.Events.AFTEREDIT);
		});
		
		this.$view.append(this.$controlPane);
		
    	$.each(items, function(idx, it) {
    		self.ck_el_array[idx] = $('<div>').appendTo(self.$view).height(sH)
			.CheckBox({text : it.text})
			.attr("title", it.text)
    		.addClass('x-combo-list-item')
			.CheckBox('on', FR.Events.STATECHANGE, function() {	
				if (!this.selected()) {
					controlBox.selected(false);
				}		
				self._refreshComponentValue();
			}).data("CheckBox");
    	});	
    	var initArray = this.$editorComponent.val().split(this.options.des);
    	// richer:ѡĳʼ
    	$.each(this.ck_el_array, function(idx, item) {
    		if ($.inArray(item.options.text, initArray) > -1){
    			item.selected(true);
    		}
    	});
    },
	
	// alex:ѡĳItem...
	_onEnterPressed : function() {
		// alex:ֻı$editorComponent.val,setValueıthis.options.value(for isDirtyж)
    	this._refreshComponentValue();
    	this.collapse();
    	//richer:
        this.fireEvent(FR.Events.AFTEREDIT);
	},
	
	/*
	 * ˢ$editorComponent.val
	 */
	_refreshComponentValue : function() {
		var value = $.map($.grep(this.ck_el_array, function(ck_el) {
			return ck_el.selected();
		}), function(ck_el) {
			return ck_el.element.text();
		}).join(this.options.des);

		this.$editorComponent.val(value);
		this.fireEvent(FR.Events.AFTEREDIT);
	},
    
	// richer:Ϊȫѡ͸ѡܣ԰
	// richer:ȫѡ
	doSelectAll : function(items){
		var arr = [];
		$.each(items, function(idx, item){
			arr.push(item.text);
		});
		var self = this;
		this.$editorComponent.val(arr.join(this.options.des));
		$.each(items, function(idx, it) {							
			self.ck_el_array[idx].selected(true, "noFireEvent");
	    });
	},
	
	// ѡ
	deSelectAll : function(items){
		this.$editorComponent.val("");
		var self = this;
		$.each(items, function(idx, it) {							
			self.ck_el_array[idx].selected(false, "noFireEvent");
	    });
	},
	
	// ֵ,value is array
	setValue : function(value) {
		var fn = function() {
			// 鲼items,valuetext
			var value_array = $.makeArray(value);
			
			var items = this.options.items;
			$.each(value_array, function(idx, v) {
				for (var i = 0; i < items.length; i++) {
					if (items[i].value == v) {
						value_array[idx] = items[i].text;
						break;
					}
				}
			})
			
			this.$editorComponent.val(value_array.join(this.options.des));
    	
	    	// alex:ϵֵthis.options.value,жisDirty
	    	var oldValue = this.options.value;
	    	this.options.value = value;
	        
	    	this.fireEvent(FR.Events.CHANGE, value, oldValue); // fire value change event, newValue & oldValue
		}
		
		// alex:this.options.itemsΪnullʱҪ_getItems
		if (this.options.items == null) {
			this._getItems();
		} 
		fn.call(this);
	},

	// ȡֵ, return an array
	getValue : function() {
		// items,textvalue
		var text_array = this.$editorComponent.val().split(this.options.des)
		
		var items = this.options.items;

		// james_mod:BUG0001640itemsпûУûѡκݵʱǿհ
		if (FR.isArray(items) && items.length > 0) {
			$.each(text_array, function(idx, text) {
				for (var i = 0; i < items.length; i++) {
					if (items[i].text == text) {
						text_array[idx] = items[i].value;
						break;
					}
				}
			})
		}
		if (this.options.returnArray){
			return text_array;
			
		}
		var resultStr = this.options.startSymbol + text_array.join(this.options.delimiter) + this.options.endSymbol;
		return resultStr;
	}
});
//FR.CheckBoxEditor.end
$.widget('FR.TreeComboBoxEditor');$.shortcut('treeComboBox', '$.FR.TreeComboBoxEditor');
FR.extend($.FR.TreeComboBoxEditor, $.FR.CheckBoxEditor, {
	init : function(){
		$.FR.TreeComboBoxEditor.superclass.init.apply(this, arguments);
		var o = this.options = $.extend({
			width : 120,
			height : 300,
			returnArray : true,
			delimiter : ',',
			startSymbol : '',
			endSymbol : '',
			cascadecheck:true
		}, this.options);
		this.$view.attr("id", o.location);
		
		var self = this;
		this.$editorComponent.keyup(function(event){
      		// ģѯ
      		if (!FR.isNavKeyPress(event) && self.options.editable){
      			self.quickSearch(self.$editorComponent.val());
      		}
      	});
	},
	
	/*
     * 
     */
    _setItems : function(nodes) {
    	FR.$import('${servletURL}?op=resource&resource=/com/fr/web/core/js/jquerytree/tree.js', 'js');
    	FR.$import('${servletURL}?op=resource&resource=/com/fr/web/core/js/jquerytree/common.js', 'js');	
    	FR.$import('${servletURL}?op=resource&resource=/com/fr/web/core/js/jquerytree/tree.css', 'css');
    	
    	if(this.options.widgetCss && this.options.widgetCss.length != 0){
    		$.each(this.options.widgetCss, function(i, item){
    			FR.$import(item, 'css', true);
    		});
    	}  

    	nodes = nodes || [];
		
    	this.options.nodes = nodes;
    	
    	this.$view.empty();
    	var self = this;
    	this.$view.width(this.options.popupWidth);
    	this.$view.height(this.options.popupHeight ? this.options.popupHeight : 150);
    	this.tH = 150;
    	this.modifyPosition();
    	var self = this;
    	if (this.options.mutiSelection){
    		this.on(FR.Events.COLLAPSE, function() {
    			self._onEnterPressed()
    		})
    	}
    	var o = this.options;
    	var depO = {};
    	if(o.dependenceMap){
    		var self = thi2s;
    		$.each(o.dependenceMap, function(key, item){
    			if (self.options.form) {
    				// richer:ͬFR_FORMһ£ֲĴСд
    				depO[key] = this.options.form.resolveVariable(item.toUpperCase());
    			}
    		});
    	} else if (FR.isArray(o.dependence)) {
    		for (var idx = 0; idx < o.dependence.length; idx++) {
    			var dep = o.dependence[idx];
    			if (this.options.form) {
    				// richer:ͬFR_FORMһ£ֲĴСд
    				depO[dep] = this.options.form.resolveVariable(dep.toUpperCase());
    			}
    		}
    	}
    	 var o = { 
    	 		showcheck: self.options.mutiSelection,
            	onnodeclick:function(item){self._onEnterPressed()}, 
            	cascadecheck: self.options.cascadecheck,
            	url: this.options.widgetUrl
            };
        o.data = nodes;
    	this.$view.treeview(o);
    },
    
    // richer:Ĺ
    quickSearch : function(value){
    	//this.options.currentValue = value;
    	if (!this.isExpanded()) {
    		this.onTriggerClick();
    	}
    	var children = this.$view.find('.bbit-tree-node-el');
    	$.each(children, function(i, item){
    		var text = $(item).text();
    		if(!value) {
    			$(item).css("display", "block");
    			return;
    		}
    		if (text.indexReg(value, true) > -1 || text == ""){
    			$(item).css("display", "block");
    		} else {
    			$(item).css("display", "none");
    		}
    	});
    },
    _onEnterPressed : function() {
    	if (!this.options.mutiSelection) {
    		var result = this.$view.getTCT();
    		this.options.currentValue = result.value;
    		this.$editorComponent.val(result.text);
    	} else {
    		var result = this.$view.getTSTs();
    		if (FR.isArray(result)){
    			var arr = result.join(this.options.delimiter);
    			this.$editorComponent.val(arr);   	
    		}
    		var current = this.$view.getTSVs();
    		// 
			if (this.options.returnArray){
				this.options.currentValue = current;
			} else {
				var resultStr = this.options.startSymbol + current.join(this.options.delimiter) + this.options.endSymbol;
				this.options.currentValue = resultStr;
			}
    	} 	
 		this.fireEvent(FR.Events.AFTEREDIT);
		this.collapse();
    },
    getValue : function(){
    	return this.options.currentValue;
    },
    _getItems : function(){
    	$.FR.TreeComboBoxEditor.superclass._getItems.apply(this, arguments);
    },
    reset : function(){
    	// ,ĿǰҪʱ,뵱ǰؼصĿؼֵıʱ,Ҫò
    	$.FR.TreeComboBoxEditor.superclass.reset.apply(this, arguments);   	
    	this.setMode("remote");
    }
});

//FR.TreeEditor.Start
$.widget('FR.TreeEditor');$.shortcut('tree', '$.FR.TreeEditor');
FR.extend($.FR.TreeEditor, $.FR.CheckBoxEditor, {
	init : function(){
		$.FR.TreeEditor.superclass.init.apply(this, arguments);
		FR.$import('${servletURL}?op=resource&resource=/com/fr/web/core/js/jquerytree/tree.js', 'js');
    	FR.$import('${servletURL}?op=resource&resource=/com/fr/web/core/js/jquerytree/common.js', 'js');	
    	FR.$import('${servletURL}?op=resource&resource=/com/fr/web/core/js/jquerytree/tree.css', 'css');
		// treeĳʼ߶ȺͿ
        var o = this.options = $.extend({
            width : 120,    
            height : 200 
        }, this.options);
		var self = this;
		this.$treeDiv = this.element.attr("id", o.location);
		if (o.width > -1){
			this.$treeDiv.css("width", o.width);
		}
		if (o.height > -1){
			this.$treeDiv.css("height", o.height);
		}
		this._getItems();
		var o = { 
    	 		showcheck: self.options.mutiSelection,
            	onnodeclick:function(item){self._onEnterPressed()}, 
            	url: this.options.widgetUrl,
            	data:o.items
            };
    	this.$treeDiv.treeview(o);
	},	
	
	_onEnterPressed : function(){
		this.fireEvent(FR.Events.CLICK)
	},
	
	getValue : function() {
       return this.$treeDiv.getTCT().value;
    },

    setValue : function(value) {
        //ñ༭ֵ
    },  
    _getItems : function(){
        $.FR.TreeEditor.superclass._getItems.apply(this, arguments);
    }, 
    reset : function() {
    	// ,ĿǰҪʱ,뵱ǰؼصĿؼֵıʱ,Ҫò
    	this.setValue("");
    }
});
//FR.TreeEditor.End

//FR.TableTree.Start
$.widget('FR.TableTree');$.shortcut("tabletree", "$.FR.TableTree");
FR.extend($.FR.TableTree, $.FR.ComboBoxEditor, {
    init : function(){
       $.FR.TableTree.superclass.init.apply(this, arguments);
       FR.$import('${servletURL}?op=resource&resource=/com/fr/web/platform/js/jquery.tabletree.js', 'js');
	   FR.$import('${servletURL}?op=resource&resource=/com/fr/web/platform/css/jquery.tabletree.css', 'css');
	   var o = this.options = $.extend({
            width : 120,    
            height : 200 
        }, this.options);
        
        this.$TableTreeDiv = this.element;
		if (o.width > -1){
			this.$TableTreeDiv.css("width", o.width);
		}
		if (o.height > -1){
			this.$TableTreeDiv.css("height", o.height);
		}
        var self = this;   
        // ȡһֵ    
        this._getItems();
        var cvns = o.items;
        
        o.widgetUrl = o.url;
        this._getItems();
        this.$TableTreeDiv.tabletree({
             data : o.items,
             cvns : cvns
        });
    },
    getValue : function(){
        return this.$TableTreeDiv.getTableTreeValue();
    },
    setValue : function(value){
        this.$TableTreeDiv.setTableTreeValue(value);
    }
});
//FR.TableTree.End

//FR.RoleTableTree.Start
$.widget('FR.RoleTableTree');$.shortcut("roletabletree", "$.FR.RoleTableTree");
FR.extend($.FR.RoleTableTree, $.FR.TableTree, {
    _init : function(){
       $.FR.RoleTableTree.superclass.init.apply(this, arguments);
       FR.$import('${servletURL}?op=resource&resource=/com/fr/web/platform/js/jquery.roletabletree.js', 'js');
	   var o = this.options = $.extend({
            width : 120,    
            height : 200 
        }, this.options);
        
        this.$RoleTableTreeDiv = this.element;
		if (o.width > -1){
			this.$RoleTableTreeDiv.css("width", o.width);
		}
		if (o.height > -1){
			this.$RoleTableTreeDiv.css("height", o.height);
		}
        var self = this;
        o.widgetUrl = o.url;
        this._getItems();
        this.$RoleTableTreeDiv.roletabletree({
             data : o.items
        });
    },
    getValue : function(){
        return this.$RoleTableTreeDiv.getRoles();
    },
    setValue : function(value){
        this.$RoleTableTreeDiv.setRoles(value);
    }
});

//FR.ListEditor.Start
// б
$.widget('FR.ListEditor');$.shortcut("list", "$.FR.ListEditor");
FR.extend($.FR.ListEditor, $.FR.ComboBoxEditor, {
	init : function(){
		$.FR.ListEditor.superclass.init.apply(this, arguments);	
		FR.$import('${servletURL}?op=resource&resource=/com/fr/web/platform/js/jquery.jlist.js', 'js');
		FR.$import('${servletURL}?op=resource&resource=/com/fr/web/platform/css/jquery.jlist.css', 'css');
		var o = this.options = $.extend({
            width : 120,    
            height : 200 
        }, this.options);
        
        this.$ListDiv = this.element;
		if (o.width > -1){
			this.$ListDiv.css("width", o.width);
		}
		if (o.height > -1){
			this.$ListDiv.css("height", o.height);
		}
        var self = this;
        this._getItems();
        this.$ListDiv.jlist(
        {
       	    data: o.items,  
       	    needhead:o.needHead,
       	    onnodeclick : function(index, newItem, oldItem){
       	    	self.fireEvent(FR.Events.CLICK, index, newItem, oldItem);
       	    },
       	    initaction : function(){
       	        self.fireEvent(FR.Events.AFTERINIT);
       	    }    	
        }         
       );
	},
	getValue : function(){
		return this.$ListDiv.getListValue();
	},
	
	setValue : function(value, item){
		this.$ListDiv.setListValue(value, item);
	},
	getAll : function(){
	    return this.$ListDiv.getListAll();
	},
	setAll : function(val){
		this.$ListDiv.setListAll(val);
	},
	startEditing : function(){
		this.fireEvent(FR.Events.BEFOREEDIT);
	},
	stopEditing : function(){
		this.fireEvent(FR.Events.AFTEREDIT);
	}
});
//FR.ListEditor.End

$.widget('FR.DateTimeEditor');$.shortcut("datetime", "$.FR.DateTimeEditor");
FR.extend($.FR.DateTimeEditor, $.FR.TextEditor, {
	init : function(){
		$.FR.DateTimeEditor.superclass.init.apply(this, arguments);
		FR.$import('${servletURL}?op=resource&resource=/com/fr/web/core/js/jsCal/jquery.dynDateTime.js', 'js');
		FR.$import('${servletURL}?op=resource&resource=/com/fr/web/core/js/jsCal/lang/calendar-lang.js', 'js');
		FR.$import('${servletURL}?op=resource&resource=/com/fr/web/core/js/jsCal/css/calendar-blue.css', 'css');
		if(this.options.widgetCss && this.options.widgetCss.length != 0){
    		$.each(this.options.widgetCss, function(i, item){
    			FR.$import(item, 'css', true);
    		});
    	}
		var o = this.options = $.extend({
			format : 'yyyy-MM-dd',
			editable: true			
		}, this.options);
		this.std = new Date(o.startDate);
		this.edd = new Date(o.endDate);
		var self = this;
		this.$editorComponent.addClass("dpPicker");
		
		var isShowTime = (o.format.indexOf("H") != -1 || o.format.indexOf("h") != -1) ? true : false;
		this.$editorComponent.dynDateTime({
				showsTime: isShowTime,
				ifFormat: FR.parseFmt(o.format),
				startDate: o.startDate,
				endDate: o.endDate
		}).keydown(function(e){
			Calendar.finish();
		});		
	},
		
	setValue : function(value) {
		var dp = value || '';
		var format = this.options.format;
		if (dp.date_milliseconds){
			dp = new Date(dp.date_milliseconds);
		} else {
			value = value.replace(/-/g, "/");
			dp = new Date(value);
		}
        // richer:ffnew Date("")"Invalid Date"ie"NaN"
		if (dp == "Invalid Date" || dp == "NaN"){
			dp = '';
		} else if (dp instanceof Date) {
			// richer:Ҫͨõjava͵ʱתΪjsʱ
			dp = '' + dp.format(FR.convertJavaDateFormat2JS(format));
			this.options.value = dp;
		} else if ( !Date.parseDate(String(dp), format)) {// formatĻͱΪհ
			dp = '';
		}
		this.$editorComponent.val(dp);
				
		// alex:ϵֵthis.options.value,жisDirty
		var oldValue = this.options.value;
		this.options.value = value;

		this.fireEvent(FR.Events.CHANGE, value, oldValue);
	},
	getValue : function(){
		var format = this.options.format;
		// richer:ֱӱ༭ڵ
		this.currentValue = this.$editorComponent.val();
        //jamesֵǲȷ
		if (!this.currentValue){
			return '';
		}
		if (!this.options.returnDate) {
			return this.currentValue;
		}
        var returnDate = Date.parseDate(this.currentValue, FR.convertJavaDateFormat2JS(format));
        // jamesؼͳһDate͵ֵDateͷؿգûзundefined
        return (returnDate == null) ? '' : returnDate;
	},
	isValidate : function(cValue) {
		var allowBlank = this.options.allowBlank != false; // james:ĬΪ
		var format = this.options.format;
		var startDate = this.std;
		var endDate = this.edd;
		
		var value = cValue ? cValue : this.getValue();
		var regex = this.options.regex;
		// richer:жд
		if (regex) {
            if (typeof regex == 'string') {//Stringʱ򣬹һRegExp
                regex = new RegExp(regex);                         
            }
            if (!regex.test(value)) {
            	this.errorMsg = this.options.errorMsg || FR.i18n.Error_Input_Value;
                return false;
            }
        }
        if ((!value)) {//ֵΪյʱ
            if (allowBlank) {//ΪգͷTRUE
            	return true;
            } else {//ΪգǾͼ
            	this.errorMsg = this.options.errorMsg || FR.i18n.NOT_NULL;
            	return false;
            }
        }

        if (value < startDate) {
        	this.errorMsg = this.options.errorMsg || FR.i18n.Value_Is_Less_Than_Minimum + startDate.format(FR.convertJavaDateFormat2JS(format));
        	return false;
        }
        if (value > endDate){
        	this.errorMsg = this.options.errorMsg || FR.i18n.Value_Is_Larger_Than_Maximum + endDate.format(FR.convertJavaDateFormat2JS(format));
        	return false;
        }
        	
        return true;
	}
});

$.widget("FR.FileUploadEditor");$.shortcut("file", "$.FR.FileUploadEditor")
/*
 * url : ļύurlַ
 * callback : ṩ֮callback
 */
FR.extend($.FR.FileUploadEditor, $.FR.BaseEditor, {
	init : function() {
		$.FR.FileUploadEditor.superclass.init.apply(this, arguments);
        // Ԥ
        var o = this.options = $.extend({
            width : 120,     // ԤĿ
            height : 20     // Ԥĸ߶
        }, this.options);
        
        var self = this;
        // Ԥ
        if (o.render === true) {
			this.$preview = $("<img>").attr("src", "${servletURL}?op=resource&resource=/com/fr/web/images/s.gif")
			.appendTo(this.element)
			.addClass("x-fileupload")
			.bind("click", o.disabled ? "" : function(){self._showDialog()})
        } else {
            this.$preview = this.element;
        }
		
		this.$preview.css({width : o.width, height : o.height});
		if (o.value != null) {
			this.setValue(o.value);
		}
	},
	// richer:ҪжļǷҪ
	isValidate : function(){
		return true;
	},
	
	/*
	 * ʼ༭
	 */
	startEditing : function() {
		this.fireEvent(FR.Events.BEFOREEDIT);
		this.$preview.show();
		// richer:ļenableҪ
		if (this.options.disabled){
			this.$preview.unbind("click");
		} else {
			this._showDialog();
		}		
	},
	
	/*
	 * ༭
	 */
	stopEditing : function() {
		this.fireEvent(FR.Events.AFTEREDIT);
		this.$preview.hide();
		this._focusPreviewPane(false);
	},
	
	/*
	 * ѡļĶԻ
	 */
	_showDialog : function() {
		var self = this;
		// carl:ǵwindowsȺϴڲڼsessionID
		FR.showUploadDialog({url : this.options.url ? this.options.url : "${servletURL}?op=attach_upload", autoUpload : this.options.autoUpload, 
			allowTypes : this.options.allowTypes,
			err : this.options.errorMsg,
			el: self, callback : function(res, status, widget) {
           	 if (status == 'success') {
				self._preview(FR.jsonDecode(res.responseText));
				widget.fireEvent(FR.Events.CALLBACK, res);
			 }
			
			self._focusPreviewPane(true);
		}});
		
		this._focusPreviewPane(false);
	},
	
	/*
	 * alex:$preview߽,Ҳǰ¿ոʱ,ҪԻ
	 */
	_focusPreviewPane : function(b) {
		$(document)[b ? 'bind' : 'unbind']('keydown', this, this._onKeyDown)
	},
	
	/*
	 * ¿ոʱ,ҪԻ
	 */
	_onKeyDown : function(e) {
		var self = e.data;
		if (e.ctrlKey && e.keyCode == $.keyCode.SPACE) {
			self._showDialog();
		}
	},
	
	setValue : function(value) {
    	// alex:ϵֵthis.options.value,жisDirty
    	var oldValue = this.options.value;
    	this.options.value = value;
        
    	this.fireEvent(FR.Events.CHANGE, value, oldValue); // fire value change event, newValue & oldValue
		
		this._preview(value)
	},
	
	getValue : function() {
		return this.$preview.data("_cv")
	},
	
	/*
	 * alex:$previewԤ,Ҫ,һǸı$preview.background,Ҫvalue$preview,ֵܰthis.options.value
	 */
	_preview : function(value) {
		this.$preview.data("_cv", value)
		
		if (value.attach_type != null && value.attach_id != null) {
			FR.previewAttachment(this.$preview, value)
		}
	}	
})

/*
 * alex:ԤAttachment,ͼƬʱʾһͼƬ,ͼƬʱ
 */
$.extend(FR, {
	previewAttachment : function() {
		function download(e) {
			window.open("${servletURL}?op=attach_download&id=" + e.data);
		}
		
		return function(target, attach) {
			var $target = $(target);
			if (attach.attach_type == 'image') {
				var im_url = '${servletURL}?op=attach_image&id=' + attach.attach_id
				// alex:ieҪֶpng͸ͨ
				if ($.browser.msie) {
					$target.css("filter", "progid:DXImageTransform.Microsoft.AlphaImageLoader(src='" + im_url + "')")
				} else {
					$target.css('background', 'transparent url(' + im_url + ") 0 0 no-repeat")
				}
				$target.css("cursor", "default").unbind("click", download)
			} else {
				$target.css('background', 'transparent url(${servletURL}?op=resource&resource=/com/fr/web/images/download.gif) center center no-repeat')
				.css("cursor", "pointer")
				.bind('click', attach.attach_id, download);
			}
		}
	}()
})

//FR.TabPane start
$.widget('FR.TabPane');$.shortcut("tab", "$.FR.TabPane")
FR.extend($.FR.TabPane, $.FR.Widget, {
    init : function() {
    	$.FR.TabPane.superclass.init.apply(this, arguments);
        var o = this.options = $.extend({
            tabPrefix : 'x-tab-',
            navCls: 'tabs-nav',
            selectedCls: 'tabs-selected',
            disabledCls: 'tabs-disabled',
            containerCls: 'tabs-container',
            hideCls: 'tabs-hide',
            initial : 0,//һʾtab
            position : 'south',// north/south
            tabs : []
        }, this.options);

        //james:׼
        this.$tabControl = $('<div>');//tabĿ
        this.$tabContainer = $('<div>');//tabľ

        var $ul = $('<ul>').addClass(o.navCls).appendTo(this.$tabControl);
        for (var i = 0; i < o.tabs.length; i++) {
            var html = '<li>'
                    + '<a _href=' + i +'>'
                    + '<span>' + FR.htmlEncode(o.tabs[i].title) + '</span>'
                    + '</a>';
            $ul.append($(html));
            //jamesȫأӵʱʾ
            $('<div>').appendTo(this.$tabContainer)
                    .attr('id', o.tabPrefix + i)//Ӹid鿴
                    .addClass(o.containerCls).addClass(o.hideCls);
        }

        //ؽؼв
        this.element.asComponent("borderlayout", {items:[{
            region : o.position,
            el : this.$tabControl
        }, {
            region : 'center',
            el : this.$tabContainer
        }]});

        //һЩ¼
        var self = this;
        $('a', this.$tabControl).each(function(idx, tabCtl) {
            $(this).bind('click', function(e) {
                //jamesȡaĸ׽ڵliΪselectedClsliڵ
                var li = $(this).parents('li:eq(0)');
                //james:liڵѾѡл߲ѡУֱ˳
                if (li.is('.' + o.selectedCls) || li.is('.' + o.disabledCls)) {
                    return false;
                }
                
                self._onTabChange(self.showingIndex, $(this).attr('_href'));

                return true;
            });
        });
        
        // ʾo.initialindexPanel
        this._onTabChange(-1, o.initial);
    },
    
    /*
     * Change Tab, from oIdx to nIdx
     */
    _onTabChange : function(oIdx, nIdx) {
    	var o = this.options;
    	this.fireEvent(FR.Events.TABCHANGESTART);
    	// ؾɵTAB & ʾµTAB
    	$("#" + o.tabPrefix + oIdx, this.$tabContainer).addClass(o.hideCls);
    	var $showTab = $("#" + o.tabPrefix + nIdx, this.$tabContainer).removeClass(o.hideCls);
    	
    	// jamesѡеĽڵ㣬վɵѡнڵ
    	$("li:eq(" + nIdx + ")", this.$tabControl).addClass(o.selectedCls).siblings().removeClass(o.selectedCls);
    	
    	this.$tabContainer.asComponent("borderlayout", {items:[{
            region : 'center',
            el : $showTab
        }]});
    	
    	// ִtabchange¼ܶʵʵֵ
    	this.fireEvent(FR.Events.TABCHANGE, this, nIdx);
        
        this.showingIndex = nIdx; // ʶǰʾindexnIdx
    }
});
//FR.TabPane end

// richer:İť
$.extend(FR, {
	dealWidthGroup : function(sessionID, selfWidget) {
		var writePane = _g(sessionID);
		// richer:˵ҳ
		if (writePane.widgetName != "WritePane") {
			return false;
		}
		//b:һformû
		if (!writePane.curLGP.form) {
			return;
		}
		
		var widgets = writePane.curLGP.form.location_widgets;

		$.each(widgets, function(idx, item){
			//richer:
			if (item == selfWidget){
				var location = item.options.location;
				var value = item.getValue();
				if (item.options.allowBlank == false && (!value || FR.isEmptyArray(value))) {
					FR.Msg.alert(FR.i18n.Alert, item.getErrorMessage());
					return false;
				}
				//b:ӸǷʾvalue
				writePane.curLGP.setCellValue(location, null, item.getValue(), true);
				var cell = $("#" + location + "-" + writePane.curLGP.idx)[0];
				writePane.curLGP.fireCellValueChange(cell, value);
			}
		});		
	},
	isEmptyArray : function(array) {
    	if (array instanceof Array) {
    		if (array.length == 0) {
    			return true;
    		} else if (array.length == 1) {
    			return array[0] === "";
    		}
    	}
    	return false;
    }
});
// checkboxgroup start
$.widget("FR.CheckBoxGroup");$.shortcut("checkboxgroup", "$.FR.CheckBoxGroup")
FR.extend($.FR.CheckBoxGroup, $.FR.BaseEditor, {
	lbox_class : 'x-group-box',
	sbox_class : 'x-group-span', 
	
	init : function() {
		$.FR.CheckBoxGroup.superclass.init.apply(this, arguments);
		
		this.options = $.extend({
			delimiter : ',', // ƴַķָ
			startSymbol : '',
			endSymbol : ''			
		}, this.options);
		
		var o = this.options;
		
		this.checkboxArray = [];
		var width = o.width > 0 ? o.width : 0;
		var height = o.height > 0 ? o.height : 0;

		// carl:ʱȥֵ
		var dd = this.element.parent();
		dd.html("");
		this.element = dd;
		
		this.$box = $("<div></div>").appendTo(this.element)
			.css("width", width).css("height", height).addClass(this.lbox_class);
		
		this._refreshItems();
		if (o.value){
		   this.setValue(o.value);
		}
	},
	
	reset : function() {
		this.setValue("");
	},
	
	_refreshItems : function() {
		this.$box.html("");
		var o = this.options;
		var self = this;
    	var depO = {};
    	if(o.dependenceMap){
    		var self = this;
    		$.each(o.dependenceMap, function(key, item){
    			if (self.options.form) {
    				// richer:ͬFR_FORMһ£ֲĴСд
    				depO[key] = this.options.form.resolveVariable(item.toUpperCase());
    			}
    		});
    	} else if (FR.isArray(o.dependence)) {
    		for (var idx = 0; idx < o.dependence.length; idx++) {
    			var dep = o.dependence[idx];
    			if (this.options.form) {
    				depO[dep] = this.options.form.resolveVariable(dep.toUpperCase());
    			}
    		}
    	}
    	// carl:ʱҪͬһʼsetValueformʱһʼsetValueΪٶ첽
    	var cur_async = (o.sessionID && _g(o.sessionID).rtype == 'form') ? true : false;
        $.ajax({
		    url : o.widgetUrl,
		    data : {
		    	dependence : FR.jsonEncode(depO)
		    },
		    async : cur_async,
        	cache : false,
	        complete: function(res) {
	        	o.items = FR.jsonDecode(res.responseText) || [];
	        	self._setItems(o.items);
	        }
	    })
	},
	
	_setItems : function(items) {
		items = items || [];
		
		this.checkboxArray = [];
		var self = this;
    	$.each(items, function(idx, it) {
    		var outter = $("<span></span>").addClass(self.sbox_class).appendTo(self.$box);
    		self.checkboxArray[idx] = outter.asComponent("checkbox", {text : it.text, fieldValue : it.value, sessionID : self.options.sessionID, fieldName : self.options.fieldName});
    		// carl:Ĭֵ
    		if (self.checkValue(it.value))  {
    			self.checkboxArray[idx].selected(true);
    		}
    		var checkbox = self.checkboxArray[idx];
    		self.checkboxArray[idx].$btn.unbind("click");
    		self.checkboxArray[idx].$btn.click(function() {
    			if (checkbox.isEnabled()) {
					var pane = _g(checkbox.options.sessionID);
					if (pane.widgetName == "WritePane" && !pane.curLGP.stopCellEditing()) {
						return;
					}
				 	checkbox.selected(!checkbox.selected())
				 }
    		});
			 		
    		self.checkboxArray[idx].on(FR.Events.STATECHANGE, function(){
    			FR.dealWidthGroup(self.options.sessionID, self);
    			self.fireEvent(FR.Events.STATECHANGE, idx, this.selected());
    		})
    	});
	},
	
	checkValue : function(value) {
		var cv = this.options.value;
		if (!cv) {
			return false;
		}
		
		if (!this.options.returnArray) {
			cv = cv.substring(this.options.startSymbol.length, cv.length - this.options.endSymbol.length).split(this.options.delimiter);	
		}

		var isIn = false;
		$.each(cv, function(i, v) {
			if (v == value) {
				isIn = true;
				return false;
			}
		});
		return isIn;
	},
	
	startEditing : function() {
    	this.fireEvent(FR.Events.BEFOREEDIT);
    	this.$box.show().focus();
	},
	
	stopEditing : function() {
		this.fireEvent(FR.Events.AFTEREDIT);
		this.$box.blur().hide();
	},
	
	getValue : function() {
		var self = this;
		var valueArray = [];
		var items = this.options.items;
		var noSelectedObject = this.options.noSelected;
		$.each(self.checkboxArray, function(idx, it) {
			if (noSelectedObject){
				if (it.selected()) {
					valueArray[idx] = items[idx].value;
				} else {
					valueArray[idx] = noSelectedObject;
				}
			} else if (it.selected()) {
				valueArray[valueArray.length] = items[idx].value;
			} 
		});
		
		if (this.options.returnArray){
			return valueArray;		
		}
		var resultStr = this.options.startSymbol + valueArray.join(this.options.delimiter) + this.options.endSymbol;
		return resultStr;
	},
	
	// ֵ,value is array
	setValue : function(value) {		
		var fn = function() {
			var value_array = value;
			if (!this.options.returnArray) {
				value_array = value_array.substring(this.options.startSymbol.length, value_array.length - this.options.endSymbol.length).split(this.options.delimiter);	
			}
			// carl:״̬
			for (var i =0; i < this.checkboxArray.length; i++) {
				this.checkboxArray[i].selected(false);
			}
			var items = this.options.items;
			var self = this;
			$.each(value_array, function(idx, v) {
				for (var i = 0; i < items.length; i++) {
					if (items[i].value == v) {
						self.checkboxArray[i].selected(true);
						break;
					}
				}
			})
    	
	    	// alex:ϵֵthis.options.value,жisDirty
	    	var oldValue = this.options.value;
	    	this.options.value = value;
	        
	    	this.fireEvent(FR.Events.CHANGE, value, oldValue); // fire value change event, newValue & oldValue
		}
		
		if (this.options.items == null) {
			this._refreshItems();
		}
		
		fn.call(this);
	},
	
	getErrorMessage : function() {
		return this.options.errorMsg || FR.i18n.NOT_NULL;
	}
});
// checkboxgroup end

// radiogroup start
$.widget("FR.RadioGroup");$.shortcut("radiogroup", "$.FR.RadioGroup")
FR.extend($.FR.RadioGroup, $.FR.BaseEditor, {
	lbox_class : 'x-group-box',
	sbox_class : 'x-group-span', 
	
	init : function() {
		$.FR.RadioGroup.superclass.init.apply(this, arguments);
		
		var o = this.options;
		
		this.radioArray = [];
		var width = o.width > 0 ? o.width : 0;
		var height = o.height > 0 ? o.height : 0;

		this.$box = $("<div></div>").appendTo(this.element)
			.css("width", width).css("height", height).addClass(this.lbox_class);
		
		this._refreshItems();
	},
	
	reset : function() {
		this._refreshItems();
	},
	
	_refreshItems : function() {
		this.$box.html("");
		var o = this.options;
		var self = this;
    	var depO = {};
    	if(o.dependenceMap){
    		var self = this;
    		$.each(o.dependenceMap, function(key, item){
    			if (self.options.form) {
    				// richer:ͬFR_FORMһ£ֲĴСд
    				depO[key] = this.options.form.resolveVariable(item.toUpperCase());
    			}
    		});
    	} else if (FR.isArray(o.dependence)) {
    		for (var idx = 0; idx < o.dependence.length; idx++) {
    			var dep = o.dependence[idx];
    			if (this.options.form) {
    				depO[dep] = this.options.form.resolveVariable(dep.toUpperCase());
    			}
    		}
    	}
    	var cur_async = (o.sessionID && _g(o.sessionID).rtype == 'form') ? true : false;
        $.ajax({
		    url : o.widgetUrl,
		    data : {
		    	dependence : FR.jsonEncode(depO)
		    },
		    async : cur_async,
        	cache : false,
	        complete: function(res) {
	        	o.items = FR.jsonDecode(res.responseText) || [];
	        	self._setItems(o.items);
	        }
	    });
	},
	
	_setItems : function(items) {
		items = items || [];
		
		this.radioArray = [];
		var rname;
		if (this.options.fieldName) {
			rname = this.options.fieldName;
		} else {
			// ûֵ¸ĬŪһ
			rname = "noNameChild";
		}
		var self = this;
    	$.each(items, function(idx, it) {
    		var outter = $("<span></span>")
   		    .addClass(self.sbox_class)
    		.appendTo(self.$box);
    		self.radioArray[idx] = outter.asComponent("radio", {text : it.text, fieldValue : it.value, sessionID : self.options.sessionID, name : rname});
    		// carl:Ĭֵ
    		if (it.value == self.options.value) self.radioArray[idx].selected(true);
    		self.radioArray[idx].on(FR.Events.STATECHANGE, function(){

    			FR.dealWidthGroup(self.options.sessionID, self);
    			self.fireEvent(FR.Events.STATECHANGE, idx, this.selected());
    		})
    	});
	},
	
	startEditing : function() {
    	this.fireEvent(FR.Events.BEFOREDIT);
    	this.$box.show().focus();
	},
	
	stopEditing : function() {
		this.fireEvent(FR.Events.AFTEREDIT);
		this.$box.blur().hide();
	},
	
	getValue : function() {
		var self = this;
		var value = null;
		var items = this.options.items;
		$.each(self.radioArray, function(idx, it) {
			if (it.selected()) {
				value = items[idx].value;
			}
		});
		return value;
	},
	
	setValue : function(value) {
		var fn = function() {
		    // richer:עҪ0ȥֵʱ		
			if (!value && value != 0) return; 
			// carl:״̬
			for (var i =0; i < this.radioArray.length; i++) {
				this.radioArray[i].reset();
			}
			var items = this.options.items;
			for (var i = 0; i < items.length; i++) {
				if (items[i].value == value) {
					this.radioArray[i].selected(true);
					break;
				}
			}
    	
	    	// alex:ϵֵthis.options.value,жisDirty
	    	var oldValue = this.options.value;
	    	this.options.value = value;
	        
	    	this.fireEvent(FR.Events.CHANGE, value, oldValue); // fire value change event, newValue & oldValue
		}
		
		if (this.options.items == null) {
			this._refreshItems();
		}
		
		fn.call(this);
	},
	
	getErrorMessage : function() {
		return this.options.errorMsg || FR.i18n.NOT_NULL;
	}
});
// radiogroup end

/*
 * ToogleButtonΪ״̬Button,CheckBox, RadioButton, ToogleButton
 * 
 * selected : ʼ״̬Ƿѡ
 * text : ʾı
 * enabled: ʼ״̬趨ǷԸı״̬
 */
$.widget("FR.ToogleButton");
FR.extend($.FR.ToogleButton, $.FR.BaseEditor, {
	// ѡѡ״̬Ӧclass
	selected_class : 'x-checkbox-checkon',
	unselected_class : 'x-checkbox-checkoff',
	selected_disable_class : 'x-checkbox-checkon-disable',
	unselected_disable_class : 'x-checkbox-checkoff-disable',
	init : function() {
		$.FR.ToogleButton.superclass.init.apply(this, arguments);
		
		var o = this.options = $.extend({
			selected : false,
			scope : this,
			render : true
		}, this.options);
		
		if (o.render == true) {
			/*
			 * alex:ԭ$("<div>"),ieͼ괦ȥȴûдclick¼,ĳspanͿ
			 * $("<span>").text(o.text)ieǲspan
			 */
			this.$btn = $("<span>" + (o.text || "&nbsp;") + "</span>").appendTo(this.element).addClass('x-toogle-text')
			.css('cursor', this.isEnabled() ? 'pointer' : 'default').click(function() {
				//james_modֻenabledʱ򣬲ܹı״̬
				 if (this.isEnabled()) {
				 	this.selected(!this.selected())
				 }
			}.createDelegate(this));
		} else {
			this.$btn = this.element;
			if (o.text !== null) {
				$("<span>" + o.text + "</span>").insertAfter(this.$btn);
			}
		}
		
		this.selected(o.selected)
		
		if ($.isFunction(o.handler)) {			
			this.$btn.click(o.handler.createDelegate(o.scope || this)
					.createInterceptor(this.isEnabled, this));
		}
	},
	
	/*
	 * Ƿѡ
	 * ûв,get;в,set
	 */
	selected : function() {
		if (arguments.length == 0) {
			// james:Ӧ״̬¶True
			return this.$btn.is('.' + this.selected_class) || this.$btn.is('.' + this.selected_disable_class);
		} else {
			var b = arguments[0] !== false
			this.$btn[b ? 'addClass' : 'removeClass'](this.isEnabled() ? this.selected_class : this.selected_disable_class)
			[b ? 'removeClass' : 'addClass'](this.isEnabled() ? this.unselected_class : this.unselected_disable_class)
			
			// richer:ݵڶҪҪstatechange¼
			if (arguments[1] != "noFireEvent"){
				// alex:״̬ı,ȻҪfireһ
				 this.fireEvent(FR.Events.STATECHANGE, this.selected());
			}
		}
	},
	
    destroy : function() {
        this.element.empty();
    }
});

//FR.TreeNodeToogleButton start
$.widget("FR.TreeNodeToogleButton");$.shortcut("treenode", "$.FR.TreeNodeToogleButton")
FR.extend($.FR.TreeNodeToogleButton, $.FR.ToogleButton, {
	selected_class : 'x-treenode-unexpand',
	unselected_class : 'x-treenode-expand',
	son_array : undefined,
	
	init : function() {
		$.FR.TreeNodeToogleButton.superclass.init.apply(this, arguments);
		
		var o = this.options = $.extend({
			expand : false,
			grade : 1
		}, this.options);
		
		this.$btn.click(function(){
			this.treeNodeClick();
		}.createDelegate(this));
		
		if (!o.expand) {
			this.$btn.click();
		}
	},
	
	// ڵĵ
	treeNodeClick : function() {
		if (!this.son_rows) {
			var location = FR.id2Location(this.options.location);
			var self = this;
			$.ajax({
				url : _g(self.options.sessionID).servletURL,
			    data : {
			    	op : "form_sonRowList",
			    	sessionID : self.options.sessionID,
			    	row : location.row,
			    	column : location.col,
			    	reportIndex : self.options.reportIndex
			    },
			    async : true,
	        	cache : false,
		        complete: function(res) {
		        	self.son_array = FR.jsonDecode(res.responseText) || [];
		        	self.TreeNodeAction();
		        }
			});
		} else {
			TreeNodeAction();
		}
	},
	
	// 
	TreeNodeAction : function() {
		if (this.son_array.length > 1) {
			var grade = Math.pow(2, this.options.grade);
			var attr;
			if (this.son_array[0] == -1) {
				var tr;
				for (var i = 1; i < this.son_array.length; i++) {
					tr = $("tr#r-" + this.son_array[i] + "-" + this.options.reportIndex);
					if (!tr) continue;
					attr = tr.attr("nodestate");
					if (attr) {
						// carl:˵һ
						if ((attr & grade) != 0) {
							attr &= ~grade;
							if (attr == 0) tr.css("display", "");
							tr.attr("nodestate", attr);
							// ie,ҪtdҲأ߿򲻻ʧ
							if ($.browser.msie) {
								$.each($("td", tr), function(index, item){
									var td = $(item);
									if (td.hasClass("treenodetd")) {
										td.css("display", "");
									}
								});
							}
						} else {
							attr |= grade;
							tr.attr("nodestate", attr).css("display", "none");
							// ie,ҪtdҲأ߿򲻻ʧ
							if ($.browser.msie) {
								$.each($("td", tr), function(index, item){
									var td = $(item);
									if (td.hasClass("treenodetd")) {
										td.css("display", "none");
									}
								});
							}
						}
					} else {
						// ĬصľͲڹϽΧ
						if (tr.css("display") != "none") {
							tr.attr("nodestate", grade).css("display", "none");
						}
						// ie,ҪtdҲأ߿򲻻ʧ
						if ($.browser.msie) {
							$.each($("td", tr), function(index, item){
								var td = $(item);
								if (td.css("display") != "none") {
									td.addClass("treenodetd").css("display", "none");
								}
							});
						}
					}
				}
			} else {
				var rowcount = this.son_array[0];
				var td;
				for (var i = 1; i < this.son_array.length; i++) {
					for (var j = 0; j < rowcount; j++) {
						td = $("td#" + FR.columnRow2CellStr({col: this.son_array[i], row: j}) + "-" + this.options.reportIndex);
						if (!td) continue;
						attr = td.attr("nodestate");
						if (attr) {
							// carl:˵һ
							if ((attr & grade) != 0) {
								attr &= ~grade;
								if (attr == 0) td.css("display", "");
								td.attr("nodestate", attr);
							} else {
								attr |= grade;
								td.attr("nodestate", attr).css("display", "none");
							}
						} else {
							// ĬصľͲڹϽΧ
							if (td.css("display") != "none") {
								td.attr("nodestate", grade).css("display", "none");
							}
						}
					}
				}
			}
		}
	}
});

// FR.CheckBox start
$.widget("FR.CheckBox");$.shortcut("checkbox", "$.FR.CheckBox")
FR.extend($.FR.CheckBox, $.FR.ToogleButton, {
	// ѡѡ״̬Ӧclass
	selected_class : 'x-checkbox-checkon',
	unselected_class : 'x-checkbox-checkoff',
	
	init : function() {
		$.FR.CheckBox.superclass.init.apply(this, arguments);
		
		var o = this.options = $.extend({
			fieldName : ""
		}, this.options);

		this.$btn.css('margin-left', 5);
		// carl:һinput checkboxformύ
		if (o.sessionID){
			if (_g(o.sessionID).rtype == 'form') {
				var $par = $(this.$btn.parent());
				$par.css("background-color", "white");
				this.$box = $("<input type='checkbox'/>").css("display", "none").attr("name", o.fieldName).appendTo($par);
				this.$box.attr("value", o.fieldValue || o.value || '');
			}
		}
		// carl:ѡ鴫ֵfieldValue
		if (o.fieldValue) this.$btn.attr("value", o.fieldValue);
		// carlvalueǷǱߴ  ӵֵⲽҪ
		if (o.value == true || o.value == 'true') this.selected(true);
	},
	
	getValue : function() {
		return '' + this.selected();
	},
	
	setValue : function(state) {
		if (typeof state == 'boolean') {
			this.selected(state);
		} else if (state == 'true') {
			this.selected(true);
		} else if (state == 'false') {
			this.selected(false);
		}
	},
	
	startEditing : function() {
    	this.fireEvent(FR.Events.BEFOREDIT);
    	this.$btn.show().focus();
	},
	
	stopEditing : function() {
		this.fireEvent(FR.Events.AFTEREDIT);
		this.$btn.blur().hide();
	},
	
	reset : function() {
		this.selected(false);
	},
	
	selected : function() {
		if (arguments.length != 0) {
			var b = arguments[0] !== false
			if (this.$box) this.$box.attr("checked", b);
		}
		return $.FR.CheckBox.superclass.selected.apply(this, arguments);
	}
});
// FR.CheckBox end

// FR.Radio start
$.widget("FR.Radio");$.shortcut("radio", "$.FR.Radio")
$.extend($.FR.Radio, {
	RadioButtonGroup : {}
});
FR.extend($.FR.Radio, $.FR.ToogleButton, {
	// ѡѡ״̬Ӧclass
	selected_class : 'x-radio-radioon',
	unselected_class : 'x-radio-radiooff',
	
	init : function() {
		$.FR.CheckBox.superclass.init.apply(this, arguments);
		
		var o = this.options = $.extend({
			fieldName : ""
		}, this.options);
		
		if (o.sessionID){
			// carl:һinput radioformύ
			if (_g(o.sessionID).rtype == 'form') {
				var $par = $(this.$btn.parent());
				$par.css("background-color", "white");
				this.$radio = $("<input type='radio'/>").css("display", "none").attr("name", o.name || o.fieldName).appendTo($par);
				this.$radio.attr("value", o.fieldValue || o.value || '');
			}
		}
		// carl:ѡ鴫ֵfieldValue
		if (o.fieldValue) this.$btn.attr("value", o.fieldValue);
		// carlvalueǷǱߴ  ӵֵⲽҪ
		if (o.value == 'true' || o.value == true) this.$btn.selected(true);
	},
	
	getValue : function() {
		return '' + this.selected();
	},
	
	setValue : function(state) {
		if (typeof state == 'boolean') {
			this.selected(state);
		} else if (state == 'true') {
			this.selected(true);
		} else if (state == 'false') {
			this.selected(false);
		}
	},
	
	startEditing : function() {
    	this.fireEvent(FR.Events.BEFOREEDIT);
    	this.$btn.show().focus();
	},
	
	stopEditing : function() {
		this.fireEvent(FR.Events.AFTEREDIT);
		this.$btn.blur().hide();
	},
	
	// select(false)ûЧģҪreset
	reset : function() {
		this.$btn.removeClass(this.selected_class).addClass(this.unselected_class);
	},
	
	/*
	 * Ƿѡ
	 * ûв,get;в,set
	 */
	selected : function() {
		if (arguments.length == 0) {
			return this.$btn.is('.' + this.selected_class)
		} else {
			/*
			 * alex:ѡ״̬,ҪԼѡ,Ҫ$.FR.Radio.RadioButtonGroupͬRadioButton䲻ѡ
			 */
			if (arguments[0] !== false) {
				var n = this.options.name;
				if (n != null) {
					$.each(this._belongs(), function(idx, rb_el) {
						rb_el.$btn.removeClass(this.selected_class).addClass(this.unselected_class)
					})
				}
				this.$btn.addClass(this.selected_class).removeClass(this.unselected_class);
				if (this.$radio) this.$radio.attr("checked", true);
			
				// alex:״̬ı,ȻҪfireһ
				this.fireEvent(FR.Events.STATECHANGE);
			} 
			// alex:ǰ״̬ѡ״̬,ù,ֻΪ˳ʼΪfalseʱ
			else if (!this.selected()) {
				this.$btn.addClass(this.unselected_class)
			}
		}
	},
	
	/*
	 * ȡøRadioButtonButtonGroup
	 */
	_belongs : function() {
		var n = this.options.name;
		if (n != null) {
			var g = $.FR.Radio.RadioButtonGroup;
			if (g[n] == null) {
				g[n] = []
			}
			
			if ($.inArray(this, g[n]) < 0) {
				g[n].push(this)
			}
			
			return g[n]
		}
		
		// alex:֤null
		return [];
	}
});
// FR.Radio end

/*
 * alex:$(document)keydown¼,ͳһFR.Keysͳһ
 */
$.extend(FR, {
	Keys : function() {
		// alex:$(document).keydownʱֻһfn_array
		var fn_array = []; // ԪFunction{scope, fn}
		var enabled = true;
		$(document).keydown(function(e) {
			if (enabled) {
				if (fn_array.length > 0) {
					var fn = fn_array[0];
					if ($.isFunction(fn)) {
						fn.call(window, e)
					} else if ($.isFunction(fn.fn)) {
						fn.fn.call(fn.scope || window, e)
					}
				}
			}
		})
		return {
			reg : function(fn) {
				// carl:Ūͬ
				fn_array.remove(fn);
				fn_array.unshift(fn);
			},
			
			unreg : function(fn) {
				fn_array.remove(fn)
			},
			
			// carl:һؼ¼ķ
			enable : function(state) {
				if (typeof state == 'boolean') {
					enabled = state;
				} else {
					return enabled;
				}
			}
		}
	}()
});
// especial