/*
 * Calendar EN language
 * Author: Mihai Bazon, <mihai_bazon@yahoo.com>
 */

// Encoding: any
// Distributed under the same terms as the calendar itself.

// For translators: please use UTF-8 if possible.  We strongly believe that
// Unicode is the answer to a real internationalized world.  Also please
// include your contact information in the header, as can be seen above.

// full day names
Calendar._DN = new Array
(FR.i18n.Sunday,
 FR.i18n.Monday,
 FR.i18n.Tuesday,
 FR.i18n.Wednesday,
 FR.i18n.Thursday,
 FR.i18n.Friday,
 FR.i18n.Saturday,
 FR.i18n.Sunday);

// Please note that the following array of short day names (and the same goes
// for short month names, _SMN) isn't absolutely necessary.  We give it here
// for exemplification on how one can customize the short day names, but if
// they are simply the first N letters of the full name you can simply say:
//
//   Calendar._SDN_len = N; // short day name length
//   Calendar._SMN_len = N; // short month name length
//
// If N = 3 then this is not needed either since we assume a value of 3 if not
// present, to be compatible with translation files that were written before
// this feature.

// short day names
Calendar._SDN = new Array
(FR.i18n.Sun,
 FR.i18n.Mon,
 FR.i18n.Tue,
 FR.i18n.Wed,
 FR.i18n.Thu,
 FR.i18n.Fri,
 FR.i18n.Sat,
 FR.i18n.Sun);

// First day of the week. "0" means display Sunday first, "1" means display
// Monday first, etc.
Calendar._FD = 0;

// full month names
Calendar._MN = new Array
(FR.i18n.January,
 FR.i18n.February,
 FR.i18n.March,
 FR.i18n.April,
 FR.i18n.May,
 FR.i18n.June,
 FR.i18n.July,
 FR.i18n.August,
 FR.i18n.September,
 FR.i18n.October,
 FR.i18n.November,
 FR.i18n.December);

// short month names
Calendar._SMN = new Array
(FR.i18n.Jan,
 FR.i18n.Feb,
 FR.i18n.Mar,
 FR.i18n.Apr,
 FR.i18n.Short_May,
 FR.i18n.Jun,
 FR.i18n.Jul,
 FR.i18n.Aug,
 FR.i18n.Sep,
 FR.i18n.Oct,
 FR.i18n.Nov,
 FR.i18n.Dec);

// tooltips
Calendar._TT = {};
Calendar._TT["INFO"] = "";

Calendar._TT["ABOUT"] =
"DHTML Date/Time Selector\n" +
"(c) dynarch.com 2002-2005 / Author: Mihai Bazon\n" + // don't translate this this ;-)
"\n\n" +
"Date selection:\n" +
"- Use the \xab, \xbb buttons to select year\n" +
"- Use the " + String.fromCharCode(0x2039) + ", " + String.fromCharCode(0x203a) + " buttons to select month\n" +
"- Hold mouse button on any of the above buttons for faster selection.";
Calendar._TT["ABOUT_TIME"] = "\n\n" +
"Time selection:\n" +
"- Click on any of the time parts to increase it\n" +
"- or Shift-click to decrease it\n" +
"- or click and drag for faster selection.";

Calendar._TT["PREV_YEAR"] = FR.i18n.Prev_Year;
Calendar._TT["PREV_MONTH"] = FR.i18n.Prev_Month;
Calendar._TT["GO_TODAY"] = "";
Calendar._TT["NEXT_MONTH"] = FR.i18n.Next_Month;
Calendar._TT["NEXT_YEAR"] = FR.i18n.Next_Year;
Calendar._TT["SEL_DATE"] = FR.i18n.Select_Date;
Calendar._TT["DRAG_TO_MOVE"] = FR.i18n.Drag_To_Move;
Calendar._TT["PART_TODAY"] = FR.i18n.Today;
Calendar._TT["OK"] = FR.i18n.OK;
Calendar._TT["Clear"] = FR.i18n.Clear;


// the following is to inform that "%s" is to be the first day of week
// %s will be replaced with the day name.
Calendar._TT["DAY_FIRST"] = "%s " + FR.i18n.First_Of_Week;

// This may be locale-dependent.  It specifies the week-end days, as an array
// of comma-separated numbers.  The numbers are from 0 to 6: 0 means Sunday, 1
// means Monday, etc.
Calendar._TT["WEEKEND"] = "0,6";

Calendar._TT["CLOSE"] = FR.i18n.Close;
Calendar._TT["TODAY"] = FR.i18n.Today;
Calendar._TT["TIME_PART"] = "(Shift-)" + FR.i18n.Click_To_Change_Value;

// date formats
Calendar._TT["DEF_DATE_FORMAT"] = "%Y-%m-%d";
Calendar._TT["TT_DATE_FORMAT"] = "%a, %b %e";

Calendar._TT["WK"] = FR.i18n.Week;
Calendar._TT["TIME"] = FR.i18n.Time + ":";
