//preview.js
$.extend($.FR.PreviewPane.prototype, {
    currentPageIndex:0, // ReportPageReportPageе
    reportTotalPage:0, // ReportPageReportPageɵܵReportPageĸ
    ownerIndex:0, // alex:ReportPageReportindex
    isLoadingPage:-1,
    gotoFirstPage:function() {
        this.gotoPage(1);
    },
    gotoPreviousPage:function () {
        if (this.currentPageIndex <= 1) {
            return;
        }
        this.gotoPage(this.currentPageIndex - 1);
    },
    gotoNextPage:function() {
        this.gotoPage(this.currentPageIndex + 1);
    },
    gotoLastPage:function() {
        this.gotoPage(2147483640)
    },
    gotoPage:function(pn) {
    	if (typeof pn != 'number' || isNaN(pn)) {
    		return;
    	}
    	if (pn < 1){
    		pn = 1;
    	}
    	// ʾڼҳ
    	if (this.isLoadingPage >= 0) {
    		return;
    	}
    	this.fireEvent(FR.Events.STARTLOAD);
    	
    	// ڼҳ
    	this.isLoadingPage = pn;
    	
    	// alex:ǿinnerHTMLΪַ,jQuery.html()empty(),ܷʱ
//    	this.$contentPane[0].innerHTML = "";
		this.$contentPane.__load__({
			url : this.servletURL,
			params : {op : "printpreview_content",sessionID : this.currentSessionID, pn:pn},
			scripts : true,
			forceDisplay : true,
			timeout : 3600000,
			callback : function() {
				this.fireEvent(FR.Events.AFTERLOAD);
				
				// ȡڼҳı
			    this.isLoadingPage = -1;
			}.createDelegate(this)
		});
    },
		
    pageSetup:function () {
    	  FR.showIframeDialog({
    	  	title : FR.i18n.PageSetup_Page_Setup,
        	width : 620,
        	height : 370,
        	url:this.servletURL + "?op=dialog_readPageSetupDialog&sessionID=" + this.currentSessionID
    	  });
    },
    printReportServer:function() {
    	FR.showRemoteDialog({
    		title : FR.i18n.ReportServerP_Print_Server,
    		width : 540,
    		height : 300,
    		url : this.servletURL + "?op=dialog_readPrintServerDialog&sessionID=" + this.currentSessionID + "&pn=" + this.currentPageIndex
    	});
    },
    pdfPrint:function(isPopup) {
    	if(this.fireEvent(FR.Events.BPDFPRINT) === false) {
    		return;
    	}
        if ($.browser.msie) {
            FR.doPDFPrint(this.currentSessionID, isPopup);
        } else {
        	// jamespdfPrintҪformat=pdfPrintʶΪǴӡ״̬
        	window.location = this.servletURL + "?op=export&sessionID=" + this.currentSessionID + "&format=pdf&isPDFPrint=true&extype=ori";
        	this.fireEvent(FR.Events.APDFPRINT);
        }
    },
    appletPrint:function() {   	
    	FR.doAppletPrint(this.currentSessionID);   	
    },
    flashPrint:function() {
    	FR.doFlashPrint(this.currentSessionID, this.currentPageIndex);
    },
    exportReportToPDF:function(extype) {
    	if(this.fireEvent(FR.Events.BTOPDF) === false) {
    		return;
    	}
        window.location = this.servletURL + "?op=export&sessionID=" + this.currentSessionID + "&format=pdf&extype=" + extype;
    	this.fireEvent(FR.Events.ATOPDF);
    },
    exportReportToExcel:function(extype) {
    	if(this.fireEvent(FR.Events.BTOEXCEL) === false) {
    		return;
    	}
    	// carl:Ūʾ
    	if (extype == 'ldpage') {
    		FR.Msg.alert(FR.i18n.Tooltips, FR.i18n.LargeData_Page_Info);
    	}
        window.location = this.servletURL + "?op=export&sessionID=" + this.currentSessionID + "&format=excel&extype=" + extype;
    	this.fireEvent(FR.Events.ATOEXCEL);
    },
    exportReportToWord:function() {
    	if(this.fireEvent(FR.Events.BTOWORD) === false){
    		return;
    	}
        window.location = this.servletURL + "?op=export&sessionID=" + this.currentSessionID + "&format=word";
    	this.fireEvent(FR.Events.ATOWORD);
    },
	initContentPane : function() {
		
	},
	loadContentPane : function() {
		this.gotoPage(1);
	}
});
