//simplesheet.js
;$.extend($.FR.SimpleSheetPane.prototype, {
    isLoadingPage:-1,
    printReportServer:function() {
    	if(this.fireEent("beforeserverprint") === false) {
        		return;
        	}
    	FR.showRemoteDialog({
    		title : FR.i18n.ReportServerP_Print_Server,
    		width : 540,
    		height : 300,
    		url : this.servletURL + "?op=dialog_readPrintServerDialog&sessionID=" + this.currentSessionID + "&pn=" + this.currentPageIndex
    	});
    	this.fireEvent("afterserverprint");
    },
    emailReport:function() {
    	if(this.fireEvent("beforeemail") === false){
        		return;
        }
    	FR.showRemoteDialog({
    		title : FR.i18n.Email,
    		width : 540,
    		height : 500,
    		url : this.servletURL + "?op=dialog_writeEmailDialog&sessionID=" + this.currentSessionID
    	});
    	this.fireEvent("afteremail");
    },
    pdfPrint:function(isPopup) {
    	if (this.fireEvent("beforepdfprint") === false) {
        		return;
        	};
        if ($.browser.msie) {
            FR.doPDFPrint(this.currentSessionID, isPopup);
        } else {
        	// jamespdfPrintҪformat=pdfPrintʶΪǴӡ״̬
        	window.location = this.servletURL + "?op=export&sessionID=" + this.currentSessionID + "&format=pdf&isPDFPrint=true&extype=ori";
        }
        this.fireEvent("afterpdfprint");
    },
    appletPrint:function() {
    	FR.doAppletPrint(this.currentSessionID);
    },
    flashPrint:function() {
    	FR.doFlashPrint(this.currentSessionID);;
    },
    exportReportToPDF:function(extype) {
    	if(this.fireEvent("beforetopdf") === false) {
        		return;
        }
        window.location = this.servletURL + "?op=export&sessionID=" + this.currentSessionID + "&format=pdf&extype=" + extype;
   		this.fireEvent("aftertopdf");
    },
    exportReportToExcel:function(extype) {
    	if (this.fireEvent("beforetoexcel") === false) {
    			return;
    	}
     	window.location = this.servletURL + "?op=export&sessionID=" + this.currentSessionID + "&format=excel&extype=" + extype;
    	this.fireEvent("aftertoexcel");   	
    },
    exportReportToWord:function() {
    	if (this.fireEvent("beforetoword") === false) {
        		return;
        }
        window.location = this.servletURL + "?op=export&sessionID=" + this.currentSessionID + "&format=word";
  		 this.fireEvent("aftertoword");	
    },
    
    /*
     * alex:ʼContentPane
     */
	initContentPane : function() {
        //alex:write.css
        FR.$import(this.servletURL + '?op=resource&resource=/com/fr/web/core/css/form.css', 'css');

        var tabPane = this.$contentPane.data("TabPane");
        var self = this;
        if (tabPane) {//jamesTabPane
            //jamesTabPanetabchange¼
            tabPane.on('tabchange', function(eventObj, tabPane, tabIndex) {
               self.fireEvent("tabchange", tabPane, tabIndex);
            });
            //jamesǰFormPanetabchange¼ִtabchange
            this.on("tabchange", function(tabIndex) {
                var lgp = self.lgps[tabIndex];
                if(lgp.loaded === false) {
                    lgp.loadLGPPane();
                }
            });

            var tabs = $('div', tabPane.$tabContainer);//jamesȡtabsĸ
            this.lgps = new Array(tabs.length);
            for (var i = 0, count = tabs.length; i < count; i++) {
                this.lgps[i] = new FR.FLGP({idx:i, $container:$(tabs[i]), formPane:this});
            }
            
            tabPane.invisible();
        } else {
            this.lgps = [new FR.FLGP({idx:0, $container:this.$contentPane, formPane:this})];
        }
    },
    
    /*
     * ʼContentPane
     */
	loadContentPane : function() {
		var tabPane = this.$contentPane.data("TabPane");
		if (tabPane) {
			tabPane.visible();
		}
	
        if(this.lgps == null || this.lgps.length == 0) return;
        $.each(this.lgps, function(idx, lgp) {
            lgp.loaded = false;
        });
        if(this.curLGP == null) this.curLGP = this.lgps[0];
        this.curLGP.loadLGPPane();
    },
    
    // carlťύ
    buttonSubmit : function(config) {
    	if(this.lgps == null || this.lgps.length == 0) return;
    	if (this.curLGP == null) this.curLGP = this.lgps[0];
    	if (this.curLGP.form) {
    		this.curLGP.form.formSubmit(config);
    	}
    },
    getWidgetByName : function(name) {
    	if(this.lgps == null || this.lgps.length == 0) return;
    	if (this.curLGP == null) this.curLGP = this.lgps[0];
    	if (this.curLGP.form) {
    		return this.curLGP.form.name_widgets[name];
    	}
    }   
})

/*
 * alex:SheetLoGicalPane
 */
FR.FLGP = function(config) {
    config = config || {};
    this.initialConfig = config;
    $.extend(this, config);

    this.loaded = false;
}

FR.extend(FR.FLGP, $.FR.OB, {
	$container : null,
	formPane : null,
	idx : 0,
	loadLGPPane : function() {
        if(this.formPane.isLoadingPage == this.idx) {
            return;
        }
        this.formPane.isLoadingPane = this.idx;
	    //this.initLGPComponent();
	    this.formPane.curLGP = this;

        //fire sheetPaneafterload¼,thisΪȥ
        this.formPane.fireEvent("afterload", this);
		
        this.formPane.isLoadingPage = -1;
            
        delete this.loaded;
	},
	
    /*
     * ʼLGPComponent
     */
    initLGPComponent: function() {
		// james:ʼؼ
		var config = {
			selector : 'td[widget]'
		}
		this.form = this.$container.asComponent("fr_form", config);
		
		// jamesʼ
		var $frozenPage = $(".frozen-page", this.$container);
		if ($frozenPage.length > 0) {
			var $reportPane = $(".reportPane");
			// richer:reportPane
			$reportPane.asComponent("borderlayout", {items:[{
				region: 'center',
				el: this.$container
			}]});
						
			var $contenDIV = $(".formContentDIV",  this.$container);
			// richer:contentContainer
			this.$container.asComponent("gridlayout", {
				rows: 2, columns: 2,
				items: [$("<div>"), $("<div>"), $("<div>"), $contenDIV],
				widths: [71, -1],
				heights: [25, -1]
			});
			
			var regions = [{
				region: 'center',
				el: $frozenPage
			}];
			var $header = $(".HF-header", this.$container);
			if ($header.length > 0) {
				regions.push({
					region: 'north',
					el:$header
				});
			}
			
			var $footer = $(".HF-footer", this.$container);
			if ($footer.length > 0) {
				regions.push({
					region: 'south',
					el: $footer
				});
			}
			
			$contenDIV.asComponent("borderlayout", {items : regions});
			FR.layoutFrozen($frozenPage);
			$reportPane.doLayout();
		}
	}															
});
