//view.js
$.extend($.FR.ViewPane.prototype, {
	isLoadingPage:-1,
	selectedIndex : - 1, // alex:ǰѡеWLGP
    gotoFirstPage:function() {
        this.curLGP.gotoFirstPage();
    },
    gotoPreviousPage:function () {
        this.curLGP.gotoPreviousPage();
    },
    gotoNextPage:function() {
        this.curLGP.gotoNextPage();
    },
    gotoLastPage:function() {
        this.curLGP.gotoLastPage();
    },
    gotoPage:function(pn) {
    	this.curLGP.gotoPage(pn);
    },
		
    pageSetup:function () {
    	  this.curLGP.pageSetup();
    },
    printReportServer:function() {
    	FR.showRemoteDialog({
    		title : FR.i18n.ReportServerP_Print_Server,
    		width : 540,
    		height : 300,
    		url : this.servletURL + "?op=dialog_readPrintServerDialog&sessionID=" + this.currentSessionID + "&pn=" + this.currentPageIndex
    	});
    },
    emailReport:function() {
    	if (this.fireEvent(FR.Events.BEMAIL) === false) {
    		return;
    	}
    	FR.showIframeDialog({
    		title : FR.i18n.Email,
    		width : 540,
    		height : 500,
    		url : this.servletURL + "?op=dialog_writeEmailDialog&sessionID=" + this.currentSessionID
    	});
    	this.fireEvent(FR.Events.AEMAIL);  	
    },
    pdfPrint:function(isPopup) {
    	if(this.fireEvent(FR.Events.BPDFPRINT) === false) {
    		return;
    	}
        if ($.browser.msie) {
            FR.doPDFPrint(this.currentSessionID, isPopup);
        } else {
        	// jamespdfPrintҪformat=pdfPrintʶΪǴӡ״̬
        	window.location = this.servletURL + "?op=export&sessionID=" + this.currentSessionID + "&format=pdf&isPDFPrint=true&extype=ori";
        	this.fireEvent(FR.Events.APDFPRINT);
        }
    },
    appletPrint:function() {   	
    	FR.doAppletPrint(this.currentSessionID);   	
    },
    flashPrint:function() {
    	FR.doFlashPrint(this.currentSessionID, this.currentPageIndex);
    },
    exportReportToPDF:function(extype) {
    	if(this.fireEvent(FR.Events.BTOPDF) === false) {
    		return;
    	}
        window.location = this.servletURL + "?op=export&sessionID=" + this.currentSessionID + "&format=pdf&extype=" + extype;
    	this.fireEvent(FR.Events.ATOPDF);
    },
    exportReportToExcel:function(extype) {
    	if(this.fireEvent(FR.Events.BTOEXCEL) === false) {
    		return;
    	}
    	// carl:Ūʾ
    	if (extype == 'ldpage') {
    		FR.Msg.alert(FR.i18n.Tooltips, FR.i18n.LargeData_Page_Info);
    	}
        window.location = this.servletURL + "?op=export&sessionID=" + this.currentSessionID + "&format=excel&extype=" + extype;
    	this.fireEvent(FR.Events.ATOEXCEL);
    },
    exportReportToWord:function() {
    	if(this.fireEvent(FR.Events.BTOWORD) === false){
    		return;
    	}
        window.location = this.servletURL + "?op=export&sessionID=" + this.currentSessionID + "&format=word";
    	this.fireEvent(FR.Events.ATOWORD);
    },
    printPreview : function() {
    	window.open(this.servletURL + "?op=printpreview&__pi__=false&sessionID=" + this.currentSessionID ,"_blank", "Scrollbar=yes,Resizable=yes,fullscreean=yes");
    },
    edit : function() {
    	FR.SessionMgr.unregister(this.currentSessionID); // ȡ󶨣ɾsession
    	window.location.href = this.servletURL + "?op=edit_init&sessionID=" + this.currentSessionID;
    },
	initContentPane : function() {
        var tabPane = this.$contentPane.data("TabPane");
        var self = this;
        if (tabPane) {
            //jamesTabPanetabchange¼
            tabPane.on(FR.Events.TABCHANGE, function(tabPane, tabIndex) {
               self.fireEvent(FR.Events.TABCHANGE, tabPane, tabIndex);
            });
            //jamesǰFormPanetabchange¼ִtabchange
            this.on(FR.Events.TABCHANGE, function(tabPane, tabIndex) {
                var lgp = self.lgps[tabIndex];
                if(lgp.loaded === false) {
                    lgp.loadLGPPane();
                } else {
                 	// Carlôܲ
                  	self.curLGP = lgp;
                }
                    
                self.selectedIndex = lgp.idx;
            });

            var tabs = $('div', tabPane.$tabContainer);//jamesȡtabsĸ
            this.lgps = new Array(tabs.length);
            for (var i = 0, count = tabs.length; i < count; i++) {
                this.lgps[i] = new FR.VLGP({idx:i, $container:$(tabs[i]), viewPane:this});
            }
            
            tabPane.invisible();
        } else {
            this.lgps = [new FR.VLGP({idx:0, $container:this.$contentPane, viewPane:this})];
        }
	},
	loadContentPane : function() {
		var tabPane = this.$contentPane.data("TabPane");
		if (tabPane) {
			tabPane.visible();
		}
	
		if(this.lgps == null || this.lgps.length == 0) return;
        $.each(this.lgps, function(idx, lgp) {
            lgp.loaded = false;
        });
        if(this.curLGP == null) this.curLGP = this.lgps[0];
        this.curLGP.loadLGPPane();
	}
});

/*
 * carl:ȳwrite.js ṹһ
 */
FR.VLGP = function(config) {
    config = config || {};
    this.initialConfig = config;
    $.extend(this, config);

    this.loaded = false;
}

FR.extend(FR.VLGP, $.FR.OB, function() {
    return {
    	        /**
         * $container, content actually be added, which is a jQuery Object, the contentPane or the selected tab of the TabPane
         */
        $container:null,
        /**
         * writePane:$.FR.WritePane this lgp belongs to
         */
        viewPane:null,
        /*
         * idx in writePane
         */
        idx:0,
        
        currentPageIndex:0, // ReportPageReportPageе
	    reportTotalPage:0, // ReportPageReportPageɵܵReportPageĸ
	    isLoadingPage:-1,
	    
	    $sheet_container:null,
	    
	    gotoFirstPage:function() {
	        this.gotoPage(1);
	    },
	    gotoPreviousPage:function () {
	        if (this.currentPageIndex <= 1) {
	            return;
	        }
	        this.gotoPage(this.currentPageIndex - 1);
	    },
	    gotoNextPage:function() {
	        this.gotoPage(this.currentPageIndex + 1);
	    },
	    gotoLastPage:function() {
	        this.gotoPage(2147483640)
	    },
	    gotoPage:function(pn) {
	    	if (typeof pn != 'number' || isNaN(pn)) {
	    		return;
	    	}
	    	if (pn < 1){
	    		pn = 1;
	    	}
	    	// ʾڼҳ
	    	if(this.viewPane.isLoadingPage == this.idx) {
                return;
            }
	    	this.viewPane.fireEvent(FR.Events.STARTLOAD);
	    	
	    	// ڼҳ
	    	this.viewPane.isLoadingPage = this.idx;
	    	
	    	// alex:ǿinnerHTMLΪַ,jQuery.html()empty(),ܷʱ
	//    	this.$contentPane[0].innerHTML = "";
			this.$container.__load__({
				url : this.viewPane.servletURL,
				params : {op : "view_content",sessionID : this.viewPane.currentSessionID, pn:pn, reportIndex:this.idx},
				scripts : true,
				forceDisplay : true,
				timeout : 3600000,
				callback : function() {
					this.viewPane.curLGP = this;
					
					this.$sheet_container = $('.sheet-container', this.$container);
					// carl:ʱֻͼ
					this.$sheet_container.asComponent("fr_form", {selector : 'td[widget]'});
					
					var $frozenPage = $(".frozen-page", this.$sheet_container);
				
					if ($frozenPage.length > 0) {  	   
				       var $contentDIV = this.$sheet_container;
				       this.$container.asComponent("borderlayout", {items:[{region: 'center',el: $contentDIV}]});		
				       var regions = [{region: 'center', el: $frozenPage}];
				       var $header = $(".HF-header", this.$container);
				       if ($header.length > 0) {
					       regions.push({region: 'north', el:$header});
				       }			
				       var $footer = $(".HF-footer", this.$container);
				       if ($footer.length > 0) {
					       regions.push({region: 'south', el: $footer});
				       }
				       $contentDIV.asComponent("borderlayout", {items:regions});	
				       FR.layoutFrozen($frozenPage);			   
				       this.$container.doLayout();	       
				    }
				    
				    this.viewPane.fireEvent(FR.Events.AFTERLOAD);
					this.viewPane.$currentContentContainer = this.$container;
				    
					// ȡڼҳı
				    this.viewPane.isLoadingPage = -1;
				    
				    delete this.loaded;
				}.createDelegate(this)
			});
	    },
			
	    pageSetup:function () {
	    	  FR.showIframeDialog({
	    	  	title : FR.i18n.PageSetup_Page_Setup,
	        	width : 620,
	        	height : 370,
	        	url:this.viewPane.servletURL + "?op=dialog_readPageSetupDialog&sessionID=" + this.viewPane.currentSessionID + "&reportIndex=" + this.idx
	    	  });
	    },
        
        loadLGPPane : function() {
        	this.gotoPage(1);
        }
	}
}());