/*
 * name: jquery.tinytree.js
 *
 * Copyright (c) 2009
 * Examples and docs at: http://tablesorter.com
 * Dual licensed under the MIT and GPL licenses:
 * http://www.opensource.org/licenses/mit-license.php
 * http://www.gnu.org/licenses/gpl.html
 * 
 * $author: huang weijian(ΰ)$
 * $Date: 2009/04/28 10:27:00 $
 * $Contact: alvin.huang.wj@gmail.com$
 */

 /**
 * һjQuerytreeؼ, ֧첽
 * 
 * @author huang weijian(alvin.huang.wj@gmail.com)
 */

;(function($) {	
	var classNames = {
		root : 'root',
		tinytree : 'tinytree',
		open : "open",
		closed : "closed",
		expandable : "expandable",
		collapsable : "collapsable",
		lastCollapsable : "lastCollapsable",
		lastExpandable : "lastExpandable",
		last : "last",
		file : "file",
		closedfolder : "closedfolder",
		openfolder : "openfolder",
		hitarea : "hitarea",
		checkbox : "checkbox",
		selected : 'selected',
		
		_leafHref : "_leafHref",
		_compositeHref : '_compositeHref'
	};
	// richer:jQueryӵ÷
$.fn.swapClass = function(c1, c2) {
   return this.removeClass(c1).addClass(c2);
}
$.fn.switchClass = function(c1, c2) {
   if (this.hasClass(c1)) {
       return this.swapClass(c1, c2);
   } else { 
        return this.swapClass(c2, c1);
   }
}
	/**
	 * 첽, ͨһεõϢ
	 * 
	 * @param {Element}
	 *            container 첽HTML DOM
	 * @param {Object}
	 *            settings Ϣ
	 */
	$.buildTinyTree = function(container, settings) {
		
		var $container = $(container);
		
		var tipDivIdPrefix = '_tinytree_tip_';
		var nodeIdPrefix = '_tinytree_node_';
		var hasLoadedChildrenCache = [];
		var idPaser = 1;
		
		/**
		 * Ĭ
		 */
		var defaults = {
			showRoot : false,
			rootName : "Root",
			root : $container.attr("id") + '0', // richer:ڵID,Ҫ֤Ψһ,ضʱbug
			
			autoload : true, // ǷԶصһڵ
						
			url : false, // ajax url
			method : 'GET', // POST  GET
			dataType : 'xml', // urlõݸʽ 'xml' or 'json'
			
			loadingMessage : '<font color="red" size="2">ڼ...</font>',			
			timeToShowLoadingMessage : false, // ӳʾʾϢʱ, λΪ: 
			
			// javascriptĸʽjavascript:method, ش(nodeId, nodeName)
			nodeUrl : false, // ڵ㴥¼, ֧httpjavascript:ַʽ
			target : 'contentFrame', // ¼Ŀ		
			
			afterClick:	false, // õĺ
			filter : false, // Ƿʾ˿?
			showChildren : false,	//Ƿͬʱʾ˺Ľڵĺ
			
			closeSameLevel : false, // 򿪸ýڵʱǷرͬĽڵ
			
			radioSupport : false,		//ѡ
    		checkboxSupport : false,	//ѡ
    		inputName : 'tinytreeInputName', //ѡѡinputname
    		selectLeafOnly  : false,	//ֻѡҶڵ
    		
    		alsoCheckParent	: false,	//Ƿͬʱѡڵ
    		alsoCheckChildren : false, //Ƿͬʱѡӽڵ
    
    		openAllNodes : false, // ǷʱеѼعĽڵ?
    		
			onError : false, // Ӻ̨ݳʱfunction onError(nodes)
			
			// private, don't set these values by yourself
			_haveLoaded : false, // ǷѾ˼, ӳʾʾϢ
			_firstLoaded : true // Ƿǵһμ? 
		};
		settings = $.extend({}, defaults, settings);
		
		var $treeDiv = document.createElement('div');
		var $treeDiv = $("<div class='tinytree'>").attr("id", generateNodeId(settings.root));
		if (settings.showRoot){
			var $treeUl = $("<ul>");
			var $treeLi = $("<li class='root'>").append($("<div>").text(settings.rootName));
			$treeLi.appendTo($treeUl);
			$treeUl.appendTo($treeDiv);
		}
				
		$container.append($treeDiv)
		if (settings.filter) {
			$treeDiv.append(createFilterDiv());
			bindFilterEvent();
		}
		$treeDiv.append(createTipDiv(settings.root));
						
		var tinytree = {
			/**
			 * ¼
			 */
			buildLowerTree : function(parentId) {
				if (!settings.url) {
					return;
				}
				var timeout = settings.timeToShowLoadingMessage;
				if (timeout) {
					window.setTimeout(function(parentId) {
						if (!settings._haveLoaded) {
							showTipMessage(parentId);
						}
					}, (timeout * 1000));
				} else {
					showTipMessage(parentId);
				}
				
				//hasLoadedChildrenCache.push(parentId);
				var param = [{name:'parentId', value:parentId}];
				$.ajax({
					type : settings.method,
					url : settings.url,
					data : param,
					dataType : settings.dataType,
					success : function(nodes) {
						settings._haveLoaded = true;
						tinytree.addNodes(parentId, nodes);
						if (settings._firstLoaded && settings.openAllNodes) {
							tinytree.openAll();
						}
						settings._firstLoaded = false;
					},
					error : function(nodes) {
						settings._haveLoaded = true;
						try {
							if (opts.onError) {
								opts.onError(nodes);
							}
						} catch (e) {}
					}
				});
			},
			
			/**
			 * ڵӵָĳڵ
			 */
			addNodes : function(parentId, nodes) {
				hideTipMessage(parentId);
				if (settings.dataType == 'xml') {
					parseXmlNodes(parentId, nodes);
				} else if (settings.dataType == 'json'){
					parseJsonNodes(parentId, nodes);
				}
			},
			
			/**
			 * õradio/checkboxѡеĽڵϢ
			 * 
			 * @return {Object} ѡеĽڵϢ{nodeId:'xx', nodeName:'xx'}
			 */
			getSelecetedNodes : function() {
				var $checkeds = $(':checkbox:checked,:radio:checked', $treeDiv);
				var result = [];
				if ($checkeds.length == 0){
					$active = $(".active", $treeDiv);
					return {nodeName: $active.text(), nodeValue : $active.attr("value")};
				}
				$.each($checkeds, function(i, checked) {
					var $checked = $(checked);
					result.push({
						nodeId : $checked.attr('treeNodeId'),
						nodeName : $checked.attr('treeNodeName'),
						nodeValue : $checked.attr('treeNodeValue')
					});
				});
				return result;
			},
			
			/**
			 * չѱعĽڵ
			 */
			openAll : function() {
				justOpenNodes(hasLoadedChildrenCache);
			},
			/**
			 * رеĽڵ
			 */
			closeAll : function() {
				justCloseNodes(hasLoadedChildrenCache);
			},
			
			/**
			 * ָĽڵ(filterValue)˽ڵ
			 * 
			 * @param {String}
			 *            Ҫй˵Ľڵ
			 */
			doFilter : function(filterValue) {
				filterValue = filterValue ? $.trim(filterValue) : '';
				if (filterValue) {
					// ƥĽڵ
					var $matchedAs = $('li > span > span:contains("' + filterValue + '")', $treeDiv);
					highlight($matchedAs);
					// ʾƥĽڵ㲢ûƥĽڵ
					var $matchedLis = $matchedAs.parent();
					$('li', $treeDiv).not($matchedLis).hide();
					$matchedLis.show();
					
					// չڵ
					var $parents = $matchedLis.parents('li');
					$parents.show();
					tinytree.closeAll();
					justOpenNodes(getNodeIds($parents));
					
					// ʾ˺Ľڵĺ
					if (settings.showChildren) {
						justOpenNodes(getNodeIds($matchedLis));
						$('li', $matchedLis).show();
					}
				} else { // Ϊʱ
					// ȡ, ʾнڵ
					unhighlight();
					$('li', $treeDiv).show();	
				}				
			},
			
			/**
			 * λ, ָĽڵ
			 */
			position : function(nodeId) {
				var $matched = $('#' + generateNodeId(nodeId) + ' > span >span', $treeDiv);
				justOpenNodes(getNodeIds($matched.parents('li')));
				highlight($matched);
			},
			
			/**
			 * ָĽڵ
			 */
			click : function(nodeId) {
				tinytree.position(nodeId);
				var $matched = $('#' + generateNodeId(nodeId) + ' > span >span', $treeDiv);
				$matched.click();
			},
			
			/**
			 * ¼ָĽڵ¼ڵ
			 */
			reload : function(nodeId) {
				delete hasLoadedChildrenCache[$.inArray(nodeId, hasLoadedChildrenCache)];
				var nodeElemId = generateNodeId(nodeId);
				$('#' + nodeElemId + ' ul', $treeDiv).remove();
				tinytree.buildLowerTree(nodeId);
				changeToCollapsableClass(nodeId);
			}
		};
		
		
		//-------------------------------------------------
		if (settings.autoload) {
			tinytree.buildLowerTree(settings.root);
		}
		//make tinytree functions accessible
		container.tinytree = tinytree;
		container.settings = settings;
		
		//--------------------private-----------------------
		/**
		 * Nodeڵ
		 */
		function Node(nodeId, nodeName, parentId, url, checked, disabled, leaf, nodeValue) {
			this.nodeId = nodeId;
			this.nodeName = nodeName;
			this.parentId = parentId;
			this.url = url || false;
			this.checked = checked || false;
			this.disabled = disabled || false;
			this.leaf = leaf || false;
			this.nodeValue = nodeValue;
		}
		
		function createTipDiv(parentId){
			var $tipDiv = $("<div class='tip' style='display:none'>").attr("id", tipDivIdPrefix + parentId)
																	 .html(settings.loadingMessage );
			return $tipDiv;	
		}
		
		function createFilterDiv(){
			var $div = $("<div>");
			var $input = $("<input type='text' id='_tinytree_text_filter_' class='filterText' value='ɸѡ...' title='ڵ, <س>ɸѡ'>");
			$input.focus(function(){this.select()})
			$div.append($input);			
			return $div;
		}		

		function bindFilterEvent() {
			$('#_tinytree_text_filter_', $treeDiv).keyup(function(e) {
				var value = $(this).val();
				if (e.keyCode == 13 || value == '') {
					tinytree.doFilter(value);
				}
			});	
		};
		
		function showTipMessage(parentId) {
			$('#' + tipDivIdPrefix + parentId).show();
		};
		
		function hideTipMessage(parentId) {
			$('#' + tipDivIdPrefix + parentId).hide();
		};
		
		function parseXmlNodes(parentId, xmlNode) {
			var $nodes = $('tree > node', xmlNode);
			var html = parseNodeRecursively(parentId, $nodes, false, true);
			appendHtmlTo(parentId, html);
		};
		
		/**
		 * JSONʽ
		 */
		function parseJsonNodes(parentId, nodes) {
			var html = parseNodeRecursively(parentId, nodes, false, false);
			appendHtmlTo(parentId, html);
		};
		
		function parseNodeRecursively(parentId, nodes, hide, xmlFormat) {
			var len = nodes.length;
			if (len == 0) {
				return '';
			}
			if ($.inArray(parentId, hasLoadedChildrenCache) == -1) {
				hasLoadedChildrenCache.push(parentId);
			}
			
			var $ul = $("<ul>").attr("id", generateFolderId(parentId));
			if (hide){
				$ul.css("display", "none");
			}
			for (var i = 0; i < len; i++) {
				var node = nodes[i];
				// richer:id
				node.id = $container.attr("id")+ "_" + node.id;
								
				var nodeObj = xmlFormat ? parseNodeObjInfoFromXml(parentId, node) 
										: parseNodeObjInfoFromJson(parentId, node);
//				if (!nodeObj.nodeValue){
//					continue;
//				}
				if (nodeObj.leaf) {
					var $leaf = createLeafNode(nodeObj, (i == (len - 1)));;
					$ul.append($leaf);
				} else {
					var children = xmlFormat ? $('> children > node', node): (node.children || []);
					var $node = createCompositeNode(nodeObj, (i == (len - 1)), children, xmlFormat);
					$ul.append($node);
				}
			}

			return $ul;
		};
		
		function parseNodeObjInfoFromXml(parentId, node) {
			return new Node($('> id', node).text(), 
							$('> name', node).text(), 
							parentId,
							$('> url', node).text(), 
							$('> checked', node).text(),
							$('> disabled', node).text(),
							$('leaf', node).text() == 'true'),
							$('> value', node).text();	
		};
		function parseNodeObjInfoFromJson(parentId, node) {
			idPaser ++;
			return new Node(node.id, node.name, parentId, node.url, 
							node.checked, node.disabled, node.leaf, node.value);	
		};
		
		function appendHtmlTo(parentId, html) {
			$('#' + generateNodeId(parentId)).append(html);
			var $folderNode = getFolderNode(parentId);
			addHitAreaEvent($folderNode);
			setHrefOfHyperlink($folderNode);
			radioAndCheckboxEvent($folderNode);
		};
		
		function generateFolderId(parentId) {
			return "_tinytree_folder_" + parentId;
		}
		function getFolderNode(parentId) {
			return $('#' + generateFolderId(parentId));	
		}
		
		function generateNodeId(nodeId) {
			return nodeIdPrefix + nodeId;
		}
		
		function createLeafNode(node, last){
			var $li = $("<li>").attr("id", generateNodeId(node.nodeId));
			if (last){
				$li.removeClass();
				$li.addClass(classNames.last);
			}
			$li.append(getRadioOrCheckbox(node, true));
			// richer:ieºܹ,ҪЩ<span></span>ʾ
			var $span = $("<span></span>").addClass(classNames.file).append(createElements(node, true));
			$li.append($span);
			
			return $li;
		}
				
		function createCompositeNode(node, last, children, xmlFormat) {
			var nodeId = node.nodeId;
			var nodeName = node.nodeName;
			var staticLoad = children.length > 0;
			var $li = $("<li>").attr("id", generateNodeId(nodeId)).addClass(last ? classNames.lastExpandable : classNames.expandable);
			var $div = $("<div>").addClass(classNames.hitarea).attr("nodeId", nodeId);
			$li.append($div);
			$li.append(getRadioOrCheckbox(node, false));
			var $span = $("<span></span>").addClass(classNames.closedfolder).append(createElements(node, false));
			$li.append($span);
			$li.append(parseNodeRecursively(nodeId, children, true, xmlFormat));
			
			return $li;
		}
				
		function addHitAreaEvent(context) {
			$('div.' + classNames.hitarea, context).click(function(e) {
				e.stopPropagation();
				var nodeId = $(this).attr('nodeId');
				openToggleLowerTree(nodeId);
			});	
		};
		
		function openToggleLowerTree(nodeId) {
			if (settings.closeSameLevel) {
				var $node = $('#' + generateNodeId(nodeId));
				justCloseNodes(getNodeIds($node.siblings()));	
			}
			if ($.inArray(nodeId, hasLoadedChildrenCache) == -1) {
				tinytree.buildLowerTree(nodeId);
			}
			nodeShowToggle(nodeId);
		}
		
		function nodeShowToggle(nodeId) {
			toggleParentNodeClass(nodeId);
			var $obj = getFolderNode(nodeId);
			$obj[ $obj.is(":hidden") ? "show" : "hide" ]();
		};
		
		function toggleParentNodeClass(nodeId) {
			changeToCollapsableClass(nodeId) || changeToExpandableClass(nodeId);
		};
		/**
		 * When open children
		 * 
		 * @param {String}
		 *            nodeId
		 * @return true | false Ƿתɹ
		 */
		function changeToCollapsableClass(nodeId) {
			var $node = $('#' + generateNodeId(nodeId));
			if ($node.hasClass(classNames.lastExpandable)) {
				$('> span', $node).removeClass(classNames.closedfolder).addClass(classNames.openfolder);
				$node.removeClass(classNames.lastExpandable).addClass(classNames.lastCollapsable);
				return true;
			} 
			if ($node.hasClass(classNames.expandable)) {
				$('> span', $node).removeClass(classNames.closedfolder).addClass(classNames.openfolder);
				$node.removeClass(classNames.expandable).addClass(classNames.collapsable);
				return true;
			}
			return false;
		};
		/**
		 * When close children
		 * 
		 * @param {String}
		 *            nodeId
		 * @return true | false Ƿתɹ
		 */
		function changeToExpandableClass(nodeId) {
			var $node = $('#' + generateNodeId(nodeId));
			if ($node.hasClass(classNames.lastCollapsable)) {
				$('> span', $node).removeClass(classNames.openfolder).addClass(classNames.closedfolder);
				$node.removeClass(classNames.lastCollapsable).addClass(classNames.lastExpandable);
				return true;
			} 
			if ($node.hasClass(classNames.collapsable)) {
				$('> span', $node).removeClass(classNames.openfolder).addClass(classNames.closedfolder);
				$node.removeClass(classNames.collapsable).addClass(classNames.expandable);
				return true;
			}
			return false;
		};
		
		function justOpenNodes(nodeIds) {
			$.each(nodeIds, function(i, nodeId) {
				if (nodeId == settings.root) {
					return true;
				}
				justToDoNode(nodeId, ':hidden', 'show');
			});
		};
		function justCloseNodes(nodeIds) {
			$.each(nodeIds, function(i, nodeId) {
				if (nodeId == settings.root) {
					return true;
				}
				justToDoNode(nodeId, ':visible', 'hide');
			});
		};
		function justToDoNode(nodeId, filter, operator) {
			var $obj = getFolderNode(nodeId);
			if ($obj && $obj.is(filter)) {
				toggleParentNodeClass(nodeId);
				$obj[operator]();
			}
		};
		
		function getRadioOrCheckbox(node, isLeaf){
			if (settings.radioSupport) {
				return createRadioOrCheckboxHtml("radio", node, isLeaf);
			}
			if (settings.checkboxSupport) {
				return createRadioOrCheckboxHtml("checkbox", node, isLeaf);
			}
			return "";
		}
		
		function createRadioOrCheckboxHtml(type, node, isLeaf) {
			if (settings.selectLeafOnly && !isLeaf) {
				return '';
			}
			return '<input type="' + type
					+'" name="' + settings.inputName + '"'
					+ (node.checked ? ' checked="checked"' : '')
					+ (node.disabled ? ' disabled="disabled"' : '')
					+ ' class="' + classNames.checkbox + '" value="'+ node.nodeId 
					+ '" id="checkboxId' + node.nodeId + '" treeNodeId="' 
					+ node.nodeId + '" treeNodeValue="' + node.nodeValue + '" treeNodeName="' + node.nodeName + '" />';
		};
		
		function radioAndCheckboxEvent(context) {
			$('li :checkbox', context).click(function(e) {
				e.stopPropagation();
				var $this = $(this);
				if (settings.alsoCheckChildren) {
					$children = $this.parent().find(':checkbox');
					if ($this.attr('checked')) {
						$children.attr('checked', 'checked');
					} else {
						$children.attr('checked', '');
					}
				}
				if (settings.alsoCheckParent) {
					$parent = $this.parents('li').find(':checkbox:first');
					if ($this.attr('checked')) {
						$parent.attr('checked', 'checked');
					}
				}
			});
		};
		
		function createElements(node, isLeaf){
			var $span = $("<span></span>").attr("value", node.nodeValue).click(function(e){
				$('.active',$container).removeClass("active");
				$span.addClass("active");
				if(typeof settings.afterClick == 'function')
				{
					settings.afterClick($(this).parent(), e);
				}
			})	
			if (settings.nodeUrl || node.url) {
				var href = node.url || settings.nodeUrl;
				var $a = $("<a></a>").attr("href", href);
				if (settings.target){
					$a.attr("target", settings.target);
				}
				$a.text(node.nodeName);
				$span.append($a);
			} else {
				$span.text(node.nodeName);
			}
			return $span;
		}
		
		function setHrefOfHyperlink(context) {
			$('li span span', context).click(function(e) {
				var $this = $(this);
				e.stopPropagation();
				highlight($this);
				var href = $this.attr('href');
				var isComposite = $this.hasClass(classNames._compositeHref);
				if (/.*#$/.test(href) && isComposite) {
					openToggleLowerTree($this.attr('nodeId'));
				}
			});
		};
		
		function highlight($these) {
			unhighlight();
			$these.addClass(classNames.selected);
		};
		function unhighlight() {
			$('.' + classNames.tinytree + ' li span span').removeClass(classNames.selected);	
		};
		
		function getNodeIds($nodes) {
			var nodeIds = [];
			for (var i = 0, len = $nodes.length; i < len; i++) {
				nodeIds.push($('> span span', $nodes[i]).attr('nodeId'));
			}
			return nodeIds;
		};
	};
	
	// ----------------------------------------------------------------------------
	//-----------------------------չĲ----------------------------
	//-----------------------------------------------------------------------------
	/**
	 * ò 
	 * 
	 * @param {Object}
	 *            settings Ϣ
	 */
	$.fn.tinytree = function(settings) {
		return this.each(function() {
			$.buildTinyTree(this, (settings ? settings : {}));
		});
	};
	/**
	 * ̬tree, ϢͽڵϢ
	 */
	$.fn.addStaticNodes = function(settings, nodes) { 
		settings = $.extend(settings || {}, {autoload:false, url:false});
		return this.each(function() {
			$.buildTinyTree(this, settings);
			this.tinytree.addNodes(this.settings.root, nodes);
		});
	}; 
	/**
	 * ̬ӽڵ㵽ĳڵ
	 */
	//FIXME ûʵ־̬ӽڵ㵽ĳڵ, Ҫǽڵ͵ת
	$.fn.addNodesTo = function(parentId, nodes) { 
		return this.each(function() {
			if (this.tinytree) {
				this.tinytree.addNodes(parentId, nodes);
			}
		});
	}; 
})(jQuery);
$.fn.simpleTree = function(opt){
	return this.each(function(){
		var TREE = this;
		var ROOT = $('.root',this);
		var ajaxCache = Array();

		TREE.option = {
			animate:	false,
			autoclose:	false,
			speed:		'fast',
			afterAjax:	false,
			afterClick:	false
		};
		TREE.option = $.extend(TREE.option,opt);
		$.extend(this, {getSelected: function(){
			return $('span.active', this).parent();
		}});
		TREE.closeNearby = function(obj)
		{
			$(obj).siblings().filter('.folder-open, .folder-open-last').each(function(){
				var childUl = $('>ul',this);
				var className = this.className;
				this.className = className.replace('open','close');
				if(TREE.option.animate)
				{
					childUl.animate({height:"toggle"},TREE.option.speed);
				}else{
					childUl.hide();
				}
			});
		};
		TREE.nodeToggle = function(obj)
		{
			var childUl = $('>ul',obj);
			if(childUl.is(':visible')){
				obj.className = obj.className.replace('open','close');

				if(TREE.option.animate)
				{
					childUl.animate({height:"toggle"},TREE.option.speed);
				}else{
					childUl.hide();
				}
			}else{
				obj.className = obj.className.replace('close','open');
				if(TREE.option.animate)
				{
					childUl.animate({height:"toggle"},TREE.option.speed, function(){
						if(TREE.option.autoclose)TREE.closeNearby(obj);
						if(childUl.is('.ajax'))TREE.setAjaxNodes(childUl, obj.id);
					});
				}else{
					childUl.show();
					if(TREE.option.autoclose)TREE.closeNearby(obj);
					if(childUl.is('.ajax'))TREE.setAjaxNodes(childUl, obj.id);
				}
			}
		};
		TREE.setAjaxNodes = function(node, parentId, callback)
		{
			if($.inArray(parentId,ajaxCache) == -1){
				ajaxCache[ajaxCache.length]=parentId;
				var url = $.trim($('>li', node).text());
				if(url && url.indexOf('url:'))
				{
					url=$.trim(url.replace(/.*\{url:(.*)\}/i ,'$1'));
					$.ajax({
						type: "GET",
						url: url,
						contentType:'html',
						cache:false,
						success: function(responce){
							node.removeAttr('class');
							node.html(responce);
							$.extend(node,{url:url});
							TREE.setTreeNodes(node, true);
							if(typeof TREE.option.afterAjax == 'function')
							{
								TREE.option.afterAjax(node);
							}
							if(typeof callback == 'function')
							{
								callback(node);
							}
						}
					});
				}
				
			}
		};
		TREE.setTreeNodes = function(obj, useParent){
			obj = useParent? obj.parent():obj;
			$('li>span', obj).addClass('text')
			.bind('selectstart', function() {
				return false;
			}).click(function(e){
				$('.active',TREE).attr('class','text');
								alert($(e.target).html());
				if(this.className=='text')
				{
					this.className='active';
				}
				if(typeof TREE.option.afterClick == 'function')
				{
					TREE.option.afterClick($(this).parent(), e);
				}
				return false;
			});
			$('li', obj).each(function(i){
				var className = this.className;
				var open = false;
				var cloneNode=false;
				var LI = this;
				var childNode = $('>ul',this);
				if(childNode.size()>0){
					var setClassName = 'folder-';
					if(className && className.indexOf('open')>=0){
						setClassName=setClassName+'open';
						open=true;
					}else{
						setClassName=setClassName+'close';
					}
					this.className = setClassName + ($(this).is(':last-child')? '-last':'');

					if(!open || className.indexOf('ajax')>=0)childNode.hide();

					TREE.setTrigger(this);
				}else{
					var setClassName = 'doc';
					this.className = setClassName + ($(this).is(':last-child')? '-last':'');
				}
			}).before('<li class="line">&nbsp;</li>')
			  .filter(':last-child').after('<li class="line-last"></li>');
		};
		TREE.setTrigger = function(node){
			$('>span',node).before('<img class="trigger" src="${servletURL}?op=resource&resource=/com/fr/web/images/simple/images/spacer.gif" border=0>');
			var trigger = $('>.trigger', node);
			trigger.click(function(event){
				TREE.nodeToggle(node);
			});
			if(!$.browser.msie)
			{
				trigger.css('float','left');
			}
		};
				
		TREE.init = function(obj)
		{
			TREE.setTreeNodes(obj, false);
		};
		TREE.init(ROOT);
	});
}
