$.fn.platformModuleShow = function() {
	var siblings = this.siblings();
	$.each(siblings, function(i) {
		$(siblings[i]).hide();
	});
	this.show();
	var id = this.attr('id');
	if (id == "platformIntroduce") {
		FR.PLATFORM.platformIntroduceModule._init();
	} else if (id == "catalogDesign") {
		FR.PLATFORM.catalogDesignModule._init();
	} else if (id == "serverConfig") {
		FR.PLATFORM.serverConfigModule._init();
	} else if (id == "authentication") {
		FR.PLATFORM.authenticationModule._init();
	}
}

$.fn.generateButton = function(config) {
	this.config = {};
	$.extend(this.config, config, {editable : false});

	$.extend(this, {
		_initIconButton : function() {
			var self  = this;
			var eventhover = this.config.size == 'big'?'platform_bigmouseover':'platform_smallmouseover';
			var eventclick = this.config.size == 'big'?'platform_bigmousedown':'platform_smallmousedown';
			var width = this.config.size == 'big'?'24px':'16px';
			var height = this.config.size == 'big'?'24px':'16px';
			this.isIESix = $.browser.msie&&$.browser.version<7;
			if(this.isIESix){
				this.filter = "progid:DXImageTransform.Microsoft.AlphaImageLoader(src='"+this.config.img+"')";
				this.filter_grey = "progid:DXImageTransform.Microsoft.AlphaImageLoader(src='"+this.config.img_grey+"')";
				this.img = $('<img/>').css('filter', this.filter).width(width).height(height).attr('src', '${servletURL}?op=resource&resource=/com/fr/web/platform/images/x.gif').attr('alt', this.config.text);
			}else{
				this.img = $('<img/>').width(width).height(height).attr('src', this.config.img).attr('alt', this.config.text);
			}
			this.setEnable(this.config.editable);
			this.attr('title', this.config.text).addClass(this.config.css).append(this.img)
			.mouseover(function(){
				if (self.isEnable()) {
					self.img.addClass(eventhover);
				}				
			}).mouseout(function(){
				if (self.isEnable()) {
					self.img.removeClass(eventhover);
				}
			}).mousedown(function(){
				if (self.isEnable()) {
					self.img.addClass(eventclick);
				}
			}).mouseup(function(){
				if (self.isEnable()) {
					self.img.removeClass(eventclick);
				}
			})
			.click(function() {
				if (!self.isEnable()) {
					return;
				}
				self.config.action();
			}.createDelegate(self));
		},
		
		setEnable : function(editable) {
			this.editable = editable;
			if(editable) {
				if(this.isIESix){
					this.img.css('filter', this.filter);
				}else{
					this.img.attr('src', this.config.img);
				}				
				this.removeClass('platform_button_disable');
			} else{
				if(this.isIESix){
					this.img.css('filter', this.filter_grey);
				}else{
					this.img.attr('src', this.config.img_grey);
				}				
				this.addClass('platform_button_disable');
			}
		},
		
		isEnable : function() {
			return this.editable;
		}
	});
	this._initIconButton();
}

$(function() {
	$.extend(FR.PLATFORM, {
		userinfo : {
			_init : function() {
				try {
					this.getData();
				} catch (e) {
					this.data = {username : 'test', userip : 'localhost'};
				}
				
				if (!this.data) {
					return;
				}
				this.content = $('<div/>').addClass('platform_userinfo').append(this.createul(this.data));
			},
			
			getContent : function(){
				if (!this.content) {
					this._init();
				}
				return this.content;
			},
			
			getData : function() {
				var self = this;
				$.ajax({
					url : '${servletURL}?op=fr_getuserinfo',
					type : 'POST',
					async : false,
					complete : function(res, status) {
						if (!res.responseText) {
							return;
						}
						self.data = FR.jsonDecode(res.responseText);
					}
				});
			},
			
			createul : function(info) {
				var username = info.authSet==false?"δȨޣȽȨ":(info.username==null||info.username=="")?"δ¼":info.username;
				var ul = $('<ul/>').addClass('platform_userinfoul').append($('<li/>').addClass('platform_userinfoli').html("ӭʹFRƽ̨" + "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;" +
				username + "&nbsp;&nbsp;|&nbsp;&nbsp;" + info.userip + "&nbsp;&nbsp;|&nbsp;&nbsp;"));
				ul.append(this.createOutLI(info));
				return ul;
			},
			
			createOutLI : function(info) {
				return $('<li/>').addClass('platform_userinfoli').text("ǳ").click(function() {
					FR.cookieInfor.removeCookie('directEnter');
					if(info.authSet){
						window.location.href = '${servletURL}?op=auth_logout';
					}else{
						alert("δȨãúٵ½");
					}
				});
			}
		},
		
		moduleControls : {
			_init : function() {				
				if($.browser.msie&&$.browser.version>6){
					this.content = $('<div/>').addClass('platform_modulesPLUS').append(this.generateUL());
				}else{
					this.content = $('<div/>').addClass('platform_modules').append(this.generateUL());
				}
			},
			
			getContent : function(){
				if (!this.content) {
					this._init();
				}
				return this.content;
			},
			
			generateUL : function() {
				var data = this.originalData();
				var self = this;
				var ul = $('<ul/>').addClass('platform_modulesul');
				$.each(data, function(i) {
					ul.append(self.generateLI(data[i]));
				});
				return ul;
			},
			
			generateLI : function(data) {
				var self = this;
				var li = $('<li/>').addClass(data.icon).click(function() {
					self.doEvent(this);				
				});
				if($.browser.mozilla){
					li.css('padding-bottom','0');
				}
				li.data('module', data.module);
				if($.browser.msie&&$.browser.version>6){
					li.css('height','36px');
				}
				if($.browser.msie&&$.browser.version<7){
					var filter = "progid:DXImageTransform.Microsoft.AlphaImageLoader(src='${servletURL}?op=resource&resource=/com/fr/web/platform/images/" + data.icon + ".png')";
					var img = $('<img/>').addClass('platform_modules_icon').css('filter',filter).attr('src', '${servletURL}?op=resource&resource=/com/fr/web/platform/images/x.gif');
				}else {
					var img = $('<img/>').addClass('platform_modules_icon').attr('src', '${servletURL}?op=resource&resource=/com/fr/web/platform/images/' + data.icon + '.png');
					
				}
				
				return li.append(img).append($('<span/>').addClass('platform_modules_title').text(data.text));
			},
			
			doEvent : function(li) {
					var li = $(li);
					li.addClass('platform_li_selected');
					var others = li.siblings();
					$.each(others, function(i) {
						$(others[i]).removeClass('platform_li_selected');
					});
					$('#' + li.data('module')).platformModuleShow();	
			},
			
			defaultState : function() {
				this.doEvent($('.platform_smallintro'));
			},
			
			originalData : function() {
				var data = [];
				data[0] = {icon : "platform_smallserver", text : "", module : "serverConfig"};
				data[1] = {icon : "platform_smallauthen", text : "Ȩ", module : "authentication"};				
				data[2] = {icon : "platform_smallcatalog", text : "Ŀ¼", module : "catalogDesign"};
				data[3] = {icon : "platform_smallintro", text : "", module : "platformIntroduce"};
				return data;
			}
		},
		
		platformLogo : function() {
			var logNorth = FR.PLATFORM.loginPage.logNorth;

			var userinfo = this.userinfo.getContent();
					
			if (userinfo) {
				logNorth.append(userinfo);
			}
					
			var modules = this.moduleControls.getContent();
			logNorth.append(modules);
				
			return logNorth;
		},
		
		platformArticle : function() {		
			return FR.PLATFORM.loginPage.logSouth;
		},
		
		_initPlatform : function() {
			var content = $("body");
			content.asComponent("borderlayout", {items:[{
					region : 'north',
					el : this.platformLogo()
				}, {
					region : 'center',
					el : this.platformModules()
				}, {
					region : 'south',
					el : this.platformArticle()
			}]});
			content.doLayout();
			this.moduleControls.defaultState();
			this.catalogDesignModule._initTree();
			window.onresize = function(){
				content.doLayout();
			}
		},
		
		platformModules : function() {
			var platformCenter = $('<div/>').addClass('platform_Center');
			platformCenter.append(this.platformIntroduceModule.getContent())
				.append(this.catalogDesignModule.hide())
				.append(this.serverConfigModule.hide())
				.append(this.authenticationModule.hide());
			
			return platformCenter;
		},
		
		platformIntroduceModule : {
			_init : function() {
				if (this.isFinished) {
					return;
				}				
				this.content = $('<div/>').attr('id', 'platformIntroduce').addClass('platform_introduceModule');
				
				var center = $('<div class = "demo"/>')
					.append($('<div/>').addClass('treeintroduce'))
					.append($('<div/>').addClass('serverintroduce'))
					.append($('<div/>').addClass('roleintroduce'))
					.append($('<div/>').addClass('shadow_right'))
					.append($('<div/>').addClass('shadow_bottom'));
				this.content.append(center);
				this.isFinished = true;
			},
			
			getContent : function(){
				if (!this.content) {
					this._init();
				}
				return this.content;
			}
			
			
		},
		
		catalogDesignModule : $('<div/>').attr('id', 'catalogDesign').addClass('platform_catalogDesignModule'),
		
		serverConfigModule : $('<div/>').attr('id', 'serverConfig').width("100%").height("100%"),
		
		authenticationModule : $('<div/>').attr('id', 'authentication').addClass('platform_authenticationModule')
	});
	
	$.extend(FR.PLATFORM.serverConfigModule, {
		_init : function() {
			
			if (this.serverinitfinish) {
				return;
			}
			var self = this;
			
			var basicsetTable = $('<li>').text("").addClass("platform_server_tableliclick").click(function(){
				basicsetTable.addClass("platform_server_tableliclick");
				mailTable.removeClass().addClass("platform_server_tableli");
				cacheTable.removeClass().addClass("platform_server_tableli");
				regTable.removeClass().addClass("platform_server_tableli");
				srvStatusTable.removeClass().addClass("platform_server_tableli");
				connectionTable.removeClass().addClass("platform_server_tableli");
				self.mail.hide();
				self.cache.hide();
				self.reg.hide();
				self.srvStatus.hide();
				self.connection.hide();
				self.basicset.show();			
			});
			var mailTable = $('<li>').text("ʼ").addClass("platform_server_tableli").click(function(){
				mailTable.addClass("platform_server_tableliclick");
				basicsetTable.removeClass().addClass("platform_server_tableli");
				cacheTable.removeClass().addClass("platform_server_tableli");
				regTable.removeClass().addClass("platform_server_tableli");
				srvStatusTable.removeClass().addClass("platform_server_tableli");
				connectionTable.removeClass().addClass("platform_server_tableli");
				self.basicset.hide();
				self.cache.hide();
				self.reg.hide();
				self.srvStatus.hide();
				self.connection.hide();
				self.mail.show();			
			});
			var cacheTable = $('<li>').text("").addClass("platform_server_tableli").click(function(){
				cacheTable.addClass("platform_server_tableliclick");
				mailTable.removeClass().addClass("platform_server_tableli");
				basicsetTable.removeClass().addClass("platform_server_tableli");
				regTable.removeClass().addClass("platform_server_tableli");
				srvStatusTable.removeClass().addClass("platform_server_tableli");
				connectionTable.removeClass().addClass("platform_server_tableli");
				self.basicset.hide();
				self.mail.hide();
				self.reg.hide();
				self.srvStatus.hide();
				self.connection.hide();
				self.cache.show();
			});
			var regTable = $('<li>').text("עϢ").addClass("platform_server_tableli").click(function(){
				regTable.addClass("platform_server_tableliclick");
				cacheTable.removeClass().addClass("platform_server_tableli");
				mailTable.removeClass().addClass("platform_server_tableli");
				basicsetTable.removeClass().addClass("platform_server_tableli");
				srvStatusTable.removeClass().addClass("platform_server_tableli");
				connectionTable.removeClass().addClass("platform_server_tableli");
				self.basicset.hide();
				self.mail.hide();
				self.cache.hide();
				self.srvStatus.hide();
				self.connection.hide();
				self.reg.show();
			});
			var srvStatusTable = $('<li>').text("״̬").addClass("platform_server_tableli").click(function(){
				srvStatusTable.addClass("platform_server_tableliclick");
				cacheTable.removeClass().addClass("platform_server_tableli");
				mailTable.removeClass().addClass("platform_server_tableli");
				basicsetTable.removeClass().addClass("platform_server_tableli");
				regTable.removeClass().addClass("platform_server_tableli");
				connectionTable.removeClass().addClass("platform_server_tableli");
				self.basicset.hide();
				self.mail.hide();
				self.cache.hide();
				self.reg.hide();
				self.connection.hide();
				self.srvStatus.show();
			});
			var connectionTable = $('<li>').text("").addClass("platform_server_tableli").click(function(){
				connectionTable.addClass("platform_server_tableliclick");
				cacheTable.removeClass().addClass("platform_server_tableli");
				mailTable.removeClass().addClass("platform_server_tableli");
				basicsetTable.removeClass().addClass("platform_server_tableli");
				regTable.removeClass().addClass("platform_server_tableli");
				srvStatusTable.removeClass().addClass("platform_server_tableli");
				self.basicset.hide();
				self.mail.hide();
				self.cache.hide();
				self.reg.hide();
				self.srvStatus.hide();
				self.connection.show();
			});
			
			var tableList = $('<ul>').addClass("platform_server_tableul").append(basicsetTable).append(mailTable).append(cacheTable).append(regTable).append(srvStatusTable).append(connectionTable);
			var titleTable = $('<div style="width: 250px; height: 286px;">').append(tableList);
			
			var content = $('<div/>').addClass('platform_server_content');
			
			
			this.asComponent("borderlayout", {items:[{
				region : 'west',
				el : titleTable
			}, {
				region : 'center',
				el : content
			}]});			
			
			this.basicset = $('<div style="overflow: auto; border: thin solid rgb(214, 215, 216);">').width("99%").height("99%").appendTo(content);
			this.mail = $('<div style="overflow: auto; border: thin solid rgb(214, 215, 216);">').width("99%").height("99%").appendTo(content);
			this.cache = $('<div style="overflow: auto; border: thin solid rgb(214, 215, 216);">').width("99%").height("99%").appendTo(content);
			this.reg = $('<div style="border: thin solid rgb(214, 215, 216);">').width("99%").height("99%").appendTo(content);
			this.srvStatus = $('<div style="overflow: auto; border: thin solid rgb(214, 215, 216);">').width("99%").height("99%").appendTo(content);
			this.connection = $('<div style="overflow: auto; border: thin solid rgb(214, 215, 216);">').width("99%").height("99%").appendTo(content);
			
			$.extend(this.basicset, {
				_init : function() {
					var title = $('<div style="border-bottom: 1px solid rgb(51, 51, 51); padding: 10px; font-size: 12px; color: rgb(85, 170, 237);"/>').text("").appendTo(this);
					var basicsetContent = $('<div id="basicset" style="padding: 20px; overflow: auto;"/>').appendTo(this);
					var table = $('<table style="border-collapse:collapse;" />').appendTo(basicsetContent);
					
					var configAttr = {
						connectionNameArray: null,
						scheduleDatasource: "",
						reportletsName: "",
						resourcesName: "",
						serverCharSet: "",
						encodingArray: null,
						serverLanguageArray: null,
						serverLanguage: "",
						serverletMapping: "",
						isSupportGzip: true,
						isPopupFlashPrintSetting: true,
						isPopupPdfPrintSetting: true,
						LOG_LEVELS: null,
						serverLogLevel: null,
						concurrency: 100,
						concurrencyOnce: 10,
						serverPrinterList: null,
						serverActivePrinterList: null	
					};
					$.ajax({
						url : '${servletURL}?op=fr_server_getconfiginfo',
						type : 'POST',
						async : false,
						complete : function(res, status) {
							if (res.responseText == null||res.responseText == "") {
								return;
							}
							configAttr = FR.jsonDecode(res.responseText);							
						}
					});
										
					$('<tr><td>ƽ̨Դã</td></tr>').addClass('platform_server_areatitle').appendTo(table);
					var scheduleDSTR = $('<tr style="border-bottom: 1px solid rgb(234, 234, 234); padding-bottom: 10px;"/>').appendTo(table);
					var scheduleDSTD = $('<td style="border-bottom: 1px solid rgb(234, 234, 234); padding-bottom: 10px;">').appendTo(scheduleDSTR);					
					var scheduleDSSelect = $('<select name="scheduledatasource" id="scheduledatasouurce" style="width: 170px;">').addClass('platform_server_titlenote').appendTo(scheduleDSTD);
					var DSArray = configAttr.connectionNameArray == null ? {} : configAttr.connectionNameArray ;
					$('<option name="" value=""></option>').appendTo(scheduleDSSelect);
					$.each(DSArray, function(i, value){
						var DS = $('<option name="" value='+ value + '>' + value + '</option>');
						if(value==configAttr.scheduleDatasource) {
							DS.attr("selected","selected");
						}						
						DS.appendTo(scheduleDSSelect);  
					});
					$('<td style="border-bottom: 1px solid rgb(234, 234, 234); padding-bottom: 10px;">ѡһԴͨݿ⣨ʱ֧ACCESSݿ⣩</td>').width("100%").addClass('platform_server_areanote').appendTo(scheduleDSTR);
					
					$('<tr><td><br>籨Ŀ¼</td></tr>').addClass('platform_server_areatitle').appendTo(table);
					var reportletsNameTR = $('<tr style="border-bottom: 1px solid rgb(234, 234, 234); padding-bottom: 10px;"/>').appendTo(table);
					var reportletsNameTD = $('<td style="border-bottom: 1px solid rgb(234, 234, 234); padding-bottom: 10px;">').appendTo(reportletsNameTR);
					var reportletsNameText = $('<input id="reportletsName" disabled="disabled">').addClass('platform_server_titlenote');
					reportletsNameText.attr('value',configAttr.reportletsName);
					reportletsNameText.appendTo(reportletsNameTD);
					$('<td style="border-bottom: 1px solid rgb(234, 234, 234); padding-bottom: 10px;">ıлУװĿ¼WebReport£ҵļУѾԴļн޸ģʹĬֵ</td>').width("100%").addClass('platform_server_areanote').appendTo(reportletsNameTR);
					
					$('<tr><td><br>ԴĿ¼</td></tr>').addClass('platform_server_areatitle').appendTo(table);
					var resourcesNameTR = $('<tr style="border-bottom: 1px solid rgb(234, 234, 234); padding-bottom: 10px;"/>').appendTo(table);
					var resourcesNameTD = $('<td style="border-bottom: 1px solid rgb(234, 234, 234); padding-bottom: 10px;">').appendTo(resourcesNameTR);
					var resourcesNameText = $('<input id="resourcesName" disabled="disabled">').addClass('platform_server_titlenote');
					resourcesNameText.attr('value',configAttr.resourcesName);
					resourcesNameText.appendTo(resourcesNameTD);
					$('<td style="border-bottom: 1px solid rgb(234, 234, 234); padding-bottom: 10px;">ıлҵļУ˺ܶ౨½ıѸĿ¼µĽṹʾģ崰</td>').width("100%").addClass('platform_server_areanote').appendTo(resourcesNameTR);
					
					$('<tr><td><br>ַ룺</td></tr>').addClass('platform_server_areatitle').appendTo(table);
					var serverCSTR = $('<tr style="border-bottom: 1px solid rgb(234, 234, 234); padding-bottom: 10px;"/>').appendTo(table);
					var serverCSTD = $('<td style="border-bottom: 1px solid rgb(234, 234, 234); padding-bottom: 10px;">').appendTo(serverCSTR);
					var serverCSSelect = $('<select name="serverCharSet" id="serverCharSet">').addClass('platform_server_titlenote').appendTo(serverCSTD);
					var CSArray = configAttr.encodingArray==null ? {} : configAttr.encodingArray ;
					$.each(CSArray, function(i, value){
						var CS = $('<option value='+ value + '>' + value + '</option>');
						if(value==configAttr.serverCharSet) {
							CS.attr("selected","selected");
						}						
						CS.appendTo(serverCSSelect);  
					});
					$('<td style="border-bottom: 1px solid rgb(234, 234, 234); padding-bottom: 10px;">ȡķӦóݿãѡǱһ¼</td>').width("100%").addClass('platform_server_areanote').appendTo(serverCSTR);
					
					$('<tr><td><br>ԣ</td></tr>').addClass('platform_server_areatitle').appendTo(table);
					var serverLanguageTR = $('<tr style="border-bottom: 1px solid rgb(234, 234, 234); padding-bottom: 10px;"/>').appendTo(table);
					var serverLanguageTD = $('<td style="border-bottom: 1px solid rgb(234, 234, 234); padding-bottom: 10px;">').appendTo(serverLanguageTR);
					var serverLanguageSelect = $('<select name="serverLanguage" id="serverLanguuage">').addClass('platform_server_titlenote').appendTo(serverLanguageTD);
					var LanguageArray = configAttr.serverLanguageArray == null ? {} : configAttr.serverLanguageArray ;
					$.each(LanguageArray, function(i, value){
						var Language = $('<option value='+ value + '>' + value + '</option>');
						if(value==configAttr.serverLanguage) {
							Language.attr("selected","selected");
						}
						Language.appendTo(serverLanguageSelect);
					});
					$('<td style="border-bottom: 1px solid rgb(234, 234, 234); padding-bottom: 10px;">ϰʹõ</td>').width("100%").addClass('platform_server_areanote').appendTo(serverLanguageTR);
					
					$('<tr><td><br>Servlet·</td></tr>').addClass('platform_server_areatitle').appendTo(table);
					var serverletMappingTR = $('<tr style="border-bottom: 1px solid rgb(234, 234, 234); padding-bottom: 10px;"/>').appendTo(table);
					var serverletMappingTD = $('<td style="border-bottom: 1px solid rgb(234, 234, 234); padding-bottom: 10px;">').appendTo(serverletMappingTR);
					var serverletMappingText = $('<input id="serverletMapping">').addClass('platform_server_titlenote');
					serverletMappingText.attr('value',configAttr.serverletMapping);
					serverletMappingText.appendTo(serverletMappingTD);
					$('<td style="border-bottom: 1px solid rgb(234, 234, 234); padding-bottom: 10px;">޸Ӱ쵽ʱģurlдʽҪʹѡЧͬʱ޸ġл://web.xmlļеurl-patternsԣʹǱһ¡</td>').width("100%").addClass('platform_server_areanote').appendTo(serverletMappingTR);
					
					$('<tr><td><br>Gzipѹ</td></tr>').addClass('platform_server_areatitle').appendTo(table);
					var isSupportGzipSet = true;
					var GzipTR = $('<tr style="border-bottom: 1px solid rgb(234, 234, 234); padding-bottom: 10px;"/>').appendTo(table);
					var GzipTD = $('<td style="border-bottom: 1px solid rgb(234, 234, 234); padding-bottom: 10px; padding-top: 10px;">').appendTo(GzipTR);
					var startGzip = $('<input type="radio" name="isSupportGzip" value="true"/>').click(function() {
						isSupportGzipSet = true;
					});
					if(configAttr.isSupportGzip == true) {
						startGzip.attr('checked','checked');
					}
					var stopGzip = $('<input type="radio" name="isSupportGzip" value="false"/>').click(function() {
						isSupportGzipSet = false;
					});
					if(configAttr.isSupportGzip == false) {
						stopGzip.attr('checked','checked');
					}
					startGzip.appendTo(GzipTD);
					$('<q>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</q>').addClass('platform_server_titlenote').appendTo(GzipTD);
					stopGzip.appendTo(GzipTD);
					$('<q>ֹͣ</q>').addClass('platform_server_titlenote').appendTo(GzipTD);
					$('<td style="border-bottom: 1px solid rgb(234, 234, 234); padding-bottom: 10px;">ùܽӿʱٶȣһǽѡ</td>').width("100%").addClass('platform_server_areanote').appendTo(GzipTR);
					
					$('<tr><td><br>ǷҪflashӡôڣ</td></tr>').addClass('platform_server_areatitle').appendTo(table);
					var isPopupFlashPrintSettingSet = true;
					$('<tr><td><br></td></tr>').appendTo(table);
					var flashTR = $('<tr style="border-bottom: 1px solid rgb(234, 234, 234); padding-bottom: 10px;"/>').appendTo(table);
					var flashTD = $('<td style="border-bottom: 1px solid rgb(234, 234, 234); padding-bottom: 10px; padding-top: 10px;">').appendTo(flashTR);
					var popupFlash = $('<input type="radio" name="isPopupFlashPrintSetting" value="true"/>').click(function() {
						isPopupFlashPrintSettingSet = true;
					});
					if(configAttr.isPopupFlashPrintSetting == true) {
						popupFlash.attr('checked','checked');
					}
					var hideFlash = $('<input type="radio" name="isPopupFlashPrintSetting" value="false"/>').click(function() {
						isPopupFlashPrintSettingSet = false;
					});
					if(configAttr.isPopupFlashPrintSetting == false) {
						hideFlash.attr('checked','checked');
					}
					popupFlash.appendTo(flashTD);
					$('<q>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</q>').addClass('platform_server_titlenote').appendTo(flashTD);
					hideFlash.appendTo(flashTD);
					$('<q></q>').addClass('platform_server_titlenote').appendTo(flashTD);
					$('<td style="border-bottom: 1px solid rgb(234, 234, 234); padding-bottom: 10px;">ѡǡڷʱʱӡťflashӡôڡ</td>').width("100%").addClass('platform_server_areanote').appendTo(flashTR);
					
					$('<tr><td><br>ǷҪpdfĬӡ</td></tr>').addClass('platform_server_areatitle').appendTo(table);
					var isPopupPdfPrintSettingSet = true;
					$('<tr><td><br></td></tr>').appendTo(table);
					var pdfTR = $('<tr style="border-bottom: 1px solid rgb(234, 234, 234); padding-bottom: 10px;"/>').appendTo(table);
					var pdfTD = $('<td style="border-bottom: 1px solid rgb(234, 234, 234); padding-bottom: 10px; padding-top: 10px;">').appendTo(pdfTR);
					var popupPdf = $('<input type="radio" name="isPopupPdfPrintSetting" value="true"/>').click(function() {
						isPopupPdfPrintSettingSet = true;
					});
					if(configAttr.isPopupPdfPrintSetting == true) {
						popupPdf.attr('checked','checked');
					}
					var hidePdf = $('<input type="radio" name="isPopupPdfPrintSetting" value="false"/>').click(function() {
						isPopupPdfPrintSettingSet = false;
					});
					if(configAttr.isPopupPdfPrintSetting == false) {
						hidePdf.attr('checked','checked');
					}
					popupPdf.appendTo(pdfTD);
					$('<q>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</q>').addClass('platform_server_titlenote').appendTo(pdfTD);
					hidePdf.appendTo(pdfTD);
					$('<q></q>').addClass('platform_server_titlenote').appendTo(pdfTD);
					$('<td style="border-bottom: 1px solid rgb(234, 234, 234); padding-bottom: 10px;">ѡǡڷʱʱӦPDFӡİťӡôڣԶѡĬϵĴӡдӡ</td>').width("100%").addClass('platform_server_areanote').appendTo(pdfTR);
									
					$('<tr><td><br>logã</td></tr>').addClass('platform_server_areatitle').appendTo(table);
					var serverLLTR = $('<tr style="border-bottom: 1px solid rgb(234, 234, 234); padding-bottom: 10px;"/>').appendTo(table);
					var serverLLTD = $('<td style="border-bottom: 1px solid rgb(234, 234, 234); padding-bottom: 10px;">').appendTo(serverLLTR);
					var serverLLSelect = $('<select name="serverLogLevel" id="serverLogLevel">').addClass('platform_server_titlenote').appendTo(serverLLTD);
					var LLArray = configAttr.LOG_LEVELS == null ? {} : configAttr.LOG_LEVELS ;
					$.each(LLArray, function(i, value){
						var LL = $('<option value='+ value + '>' + value + '</option>');
						if(value==configAttr.serverLogLevel) {
							LL.attr("selected","selected");
						}						
						LL.appendTo(serverLLSelect);  
					});
					$('<td style="border-bottom: 1px solid rgb(234, 234, 234); padding-bottom: 10px;">ѡʾ־Ϣʾķ̨һĬϼ</td>').width("100%").addClass('platform_server_areanote').appendTo(serverLLTR);
					
					$('<tr><td><br>û</td></tr>').addClass('platform_server_areatitle').appendTo(table);
					var concurrencyTR = $('<tr>').appendTo(table);
					var concurrencyTD = $('<td style="border-bottom: 1px solid rgb(234, 234, 234); padding-bottom: 10px;">').appendTo(concurrencyTR);
					var concurrencyText = $('<input id="concurrency">').addClass('platform_server_titlenote');
					concurrencyText.attr('value',configAttr.concurrency);
					concurrencyText.appendTo(concurrencyTD);
					$('<td style="border-bottom: 1px solid rgb(234, 234, 234); padding-bottom: 10px;">ֵͬʱʷû</td>').width("100%").addClass('platform_server_areanote').appendTo(concurrencyTR);
					
					$('<tr><td>ȷʵĲ</td></tr>').addClass('platform_server_areatitle').appendTo(table);
					var concurrencyOnceTR = $('<tr style="border-bottom: 1px solid rgb(234, 234, 234); padding-bottom: 10px;"/>').appendTo(table);
					var concurrencyOnceTD = $('<td style="border-bottom: 1px solid rgb(234, 234, 234); padding-bottom: 10px;">').appendTo(concurrencyOnceTR);
					var concurrencyOnceText = $('<input id="concurrencyOnce">').addClass('platform_server_titlenote');
					concurrencyOnceText.attr('value',configAttr.concurrencyOnce);
					concurrencyOnceText.appendTo(concurrencyOnceTD);
					
					var printer = $('<tr>').appendTo(table);
					$('<td><br>ҪĴӡ</td>').addClass('platform_server_areatitle').appendTo(printer).appendTo(printer);
					$('<td>ԶطõĴӡǣڿͻ˵ıӡѡѡ</td>').addClass('platform_server_areanote').appendTo(printer)
					var printerList = configAttr.serverPrinterList==null?{}:configAttr.serverPrinterList;
					var activePrinterList = configAttr.serverActivePrinterList==null?{}:configAttr.serverActivePrinterList;										
					$.each(printerList, function(i, value){
						var PL = $('<input type="checkbox" name="serverPrinterList" value="' + value + '"/>');
						$.each(activePrinterList, function(j, value2){
							if(value==value2) {
								PL.attr("checked","checked");
							}
						});							
						var PLTR = $('<tr>').appendTo(table);
						var PLTD = $('<td style="padding-bottom: 10px; padding-top: 10px;">').appendTo(PLTR);
						PL.appendTo(PLTD);
						$('<q>' + value + '</q>').addClass('platform_server_titlenote').appendTo(PLTD);
					});
													
					var buttonTR = $('<tr>').appendTo(table);
					var buttonTD = $('<td>').appendTo(buttonTR);
					$('<br><br><br>').appendTo(buttonTD);
					var submitcontent = $('<div/>').appendTo(buttonTD);			
					var buttonS = $('<input type="submit" value="ύ"/>').addClass('platform_server_titlenote').click(function() {	
						
						var scheduleDatasource = "";
						$($('select[name="scheduledatasource"]')[0].children).each(function(){
							if(this.selected){
								scheduleDatasource =this.value;
							}
						});
						var serverCharSet = "";
						$($('select[name="serverCharSet"]')[0].children).each(function(){
							if(this.selected){
								serverCharSet =this.value;
							}
						});			
						var serverLanguage = "";
						$($('select[name="serverLanguage"]')[0].children).each(function(i){
							if(this.selected){
								serverLanguage =i;
							}
						});
						var serverLogLevel = "";
						$($('select[name="serverLogLevel"]')[0].children).each(function(){
							if(this.selected){
								serverLogLevel =this.value;
							}
						});
						var serverActivePrinterList = "";
						$('input[name="serverPrinterList"]').each(function(){
							if(this.checked){
								serverActivePrinterList += (this.value + ",");
							}
						});	
						var configAttrSub = {
							scheduleDatasource: scheduleDatasource,
							serverCharSet: serverCharSet,
							serverLanguage: serverLanguage,
							serverletMapping: serverletMappingText.val(),
							isSupportGzip: isSupportGzipSet,
							isPopupFlashPrintSetting: isPopupFlashPrintSettingSet,
							isPopupPdfPrintSetting: isPopupPdfPrintSettingSet,
							serverLogLevel: serverLogLevel,
							concurrency: concurrencyText.val(),
							concurrencyOnce: concurrencyOnceText.val(),
							serverActivePrinterList: serverActivePrinterList
						};
						FR.showLoadingDialog({width : 310, height : 80, title : "", text : "ύ"});			
						$.ajax({					
							url : '${servletURL}?op=fr_server_configattrset',
							type : 'POST',
							data : {
								type : 'POST',

								configAttrJson : FR.jsonEncode(configAttrSub)
							},
							complete : function(res, status) {
								FR.hideLoadingDialog();
								var configStatus = res.responseText;
								if (configStatus == 'success') {
									alert("ύɹ!");
								} else{								
									alert("ύʧ" + configStatus);
								}
							}
			    		});
					}).width("50px").appendTo(submitcontent);
					
				}
			})
			
			$.extend(this.mail, {
				_init : function() {
					var title = $('<div style="border-bottom: 1px solid rgb(51, 51, 51); padding: 10px; font-size: 12px; color: rgb(85, 170, 237);"/>').text("ʼ").appendTo(this);			
					var emailAttrDialog = $('<div id="email" style="padding: 20px; font-size: 16px; overflow: auto;"/>').appendTo(this);
					var table = $('<table/>').appendTo(emailAttrDialog);
								
					var emailAttr = {
						serverName: "",
						userName: "",
						passWord: "",
						fromAddress: ""
					};
					$.ajax({
						url : '${servletURL}?op=fr_server_getmailinfo',
						type : 'POST',
						async : false,
						complete : function(res, status) {
							if (res.responseText == null||res.responseText == "") {
								return;
							}
							emailAttr = FR.jsonDecode(res.responseText);
						}
					});
					
					$('<tr><td>ʼ(SMTP)</td></tr>').addClass('platform_server_areatitle').appendTo(table);
					var serverNameTR = $('<tr>').appendTo(table);
					var serverNameTD = $('<td>').appendTo(serverNameTR);
					var serverName = $('<input id="emailServer"/>').addClass('platform_server_titlenote');
					serverName.attr('value', emailAttr.serverName);								
					serverName.appendTo(serverNameTD);			
					
					$('<tr><td>û</td></tr>').addClass('platform_server_areatitle').appendTo(table);
					var userNameTR = $('<tr>').appendTo(table);
					var userNameTD = $('<td>').appendTo(userNameTR);		
					var userName = $('<input id="emailUser"/>').addClass('platform_server_titlenote');
					userName.attr('value', emailAttr.userName);
					userName.appendTo(userNameTD);
					
					$('<tr><td>룺</td></tr>').addClass('platform_server_areatitle').appendTo(table);	
					var passWordTR = $('<tr>').appendTo(table);
					var passWordTD = $('<td>').appendTo(passWordTR);			
					var passWord = $('<input id="emailPassword" type="password"/>').addClass('platform_server_titlenote');
					passWord.attr('value', emailAttr.passWord);
					passWord.appendTo(passWordTD);
					
					$('<tr><td>˵ַ</td></tr>').addClass('platform_server_areatitle').appendTo(table);
					var fromAddressTR = $('<tr>').appendTo(table);
					var fromAddressTD = $('<td>').appendTo(fromAddressTR);
					$('<td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>').appendTo(fromAddressTR);
					var testMailTD = $('<td>').appendTo(fromAddressTR);			
					var fromAddress = $('<input id="emailFrom"/>').addClass('platform_server_titlenote');
					fromAddress.attr('value', emailAttr.fromAddress);
					fromAddress.appendTo(fromAddressTD);
					
					var testmail = $('<div/>').appendTo(testMailTD);
					var buttonT = $('<input type="submit" value="Ͳʼ"/>').addClass('platform_server_titlenote').click(function() {
						var toAddress = prompt("ʼˣ","");
						var emailToAttr = {
							serverName: serverName.val(),
							fromAddress: fromAddress.val(),
							userName: userName.val(),
							passWord: passWord.val(),
							toAddress: toAddress
						};						
						if(toAddress!=null&&toAddress!=""){
							FR.showLoadingDialog({width : 310, height : 80, title : "ʼ", text : "ڷ"});
							$.ajax({
								url : '${servletURL}?op=fr_server_testmail',
								type : 'POST',
								data : {
									type : 'POST',
	
									emailToAttr : FR.jsonEncode(emailToAttr)
								},
								complete : function(res, status) {
									FR.hideLoadingDialog();
									var mailStatus = res.responseText;							
									if(mailStatus=="success"){
										alert("ʼѷ"+toAddress);
									}else{
										alert("ʧܣ\nûռ˵ַԼʼдǷȷȷ糩ͨ");
									}
								}
							});					
						}
					}).width("150px").appendTo(testmail);					
					
					var buttonTR = $('<tr>').appendTo(table);
					var buttonTD = $('<td>').appendTo(buttonTR);
					$('<br><br><br>').appendTo(buttonTD);
					var submitcontent = $('<div/>').appendTo(buttonTD);			
					var buttonS = $('<input type="submit" value="ύ"/>').addClass('platform_server_titlenote').click(function() {	
						var emailAttrSub = {
							serverName: serverName.val(),
							fromAddress: fromAddress.val(),
							userName: userName.val(),
							passWord: passWord.val()
						}
						FR.showLoadingDialog({width : 310, height : 80, title : "ʼ", text : "ύ"});			
						$.ajax({					
							url : '${servletURL}?op=fr_server_emailattrset',
							type : 'POST',
							data : {
								type : 'POST',

								emailAttrJson : FR.jsonEncode(emailAttrSub)
							},
							complete : function(res, status) {
								FR.hideLoadingDialog();
								var mailAttrStatus = res.responseText;							
								if(mailAttrStatus=="success"){
									alert("ύɹ");
								}else{
									alert("ύʧ" + mailAttrStatus);
								}
							}
			    		});
					}).width("50px").appendTo(submitcontent);
				}
			})
			
			$.extend(this.cache, {
				_init : function() {
					var title = $('<div style="border-bottom: 1px solid rgb(51, 51, 51); padding: 10px; font-size: 12px; color: rgb(85, 170, 237);"/>').text("").appendTo(this);
					var cacheContent = $('<div id="cache" style="padding: 20px; font-size: 16px; overflow: auto;"/>').appendTo(this);

					
					var cacheInfo = {
						maxElementsInMemory: 10,
						memoryStoreEvictionPolicy: "LRU",
						timeToIdleSeconds: 0,
						timeToLiveSeconds: 0,
						alwaysReloadTpl: "false"
					};
					$.ajax({
						url : '${servletURL}?op=fr_server_getcacheinfo',
						type : 'POST',
						async : false,
						complete : function(res, status) {
							if (res.responseText == null||res.responseText == "") {
								return;
							}
							cacheInfo = FR.jsonDecode(res.responseText);
						}
					});				
					
					$('<p>ݼã</p>').addClass('platform_server_areatitle').appendTo(cacheContent);
					var dbTable = $('<table style="margin-left: 40px;"/>').appendTo(cacheContent);					
					
					$('<tr><td><br></td></tr>').addClass('platform_server_titlenote').appendTo(dbTable);
					var maxElementsInMemory = $('<input id="maxElementsInMemory"/>').addClass('platform_server_titlenote');					
					maxElementsInMemory.attr('value', cacheInfo.maxElementsInMemory);	
					var maxElementsInMemoryTR = $('<tr/>').appendTo(dbTable);
					var maxElementsInMemoryTD = $('<td>').appendTo(maxElementsInMemoryTR);		
					maxElementsInMemory.appendTo(maxElementsInMemoryTD);
					$('<td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>').appendTo(maxElementsInMemoryTR);
					$('<td>Թݼ</td>').addClass('platform_server_areanote').appendTo(maxElementsInMemoryTR);
					
					$('<tr><td>ԣ</td></tr>').addClass('platform_server_titlenote').appendTo(dbTable);
					var memoryStoreEvictionPolicySet = "LRU";
					
					var LRUTR = $('<tr/>').appendTo(dbTable);
					var LRUTD = $('<td style="padding-bottom: 10px; padding-top: 10px;">');
					var LRU = $('<input type="radio" name="cachepolicy" value="LRU"/>').click(function() {
						memoryStoreEvictionPolicySet = "LRU";
					});
					if(cacheInfo.memoryStoreEvictionPolicy == "LRU") {
						LRU.attr('checked','checked');
					}					
					LRU.appendTo(LRUTD).parent().appendTo(LRUTR);
					$('<q>ʹ</q>').addClass('platform_server_titlenote').appendTo(LRUTD);
					$('<td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>').appendTo(LRUTR);
					$('<td>ʹõݼռû</td>').addClass('platform_server_areanote').appendTo(LRUTR);
					
					var FIFOTR = $('<tr/>').appendTo(dbTable);
					var FIFOTD = $('<td style="padding-bottom: 10px; padding-top: 10px;">');
					var FIFO = $('<input type="radio" name="cachepolicy" value="FIFO"/>').click(function() {
						memoryStoreEvictionPolicySet = "FIFO";
					});
					if(cacheInfo.memoryStoreEvictionPolicy == "FIFO") {
						FIFO.attr('checked','checked');
					}										
					FIFO.appendTo(FIFOTD).parent().appendTo(FIFOTR);
					$('<q>Ƚȳ</q>').addClass('platform_server_titlenote').appendTo(FIFOTD);
					$('<td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>').appendTo(FIFOTR);
					$('<td>ʹõȺ˳ʹõݼȷ</td>').addClass('platform_server_areanote').appendTo(FIFOTR);
					
					var LFUTR = $('<tr/>').appendTo(dbTable);
					var LFUTD = $('<td style="padding-bottom: 10px; padding-top: 10px;">');
					var LFU = $('<input type="radio" name="cachepolicy" value="LFU"/>').click(function() {
						memoryStoreEvictionPolicySet = "LFU";
					});
					if(cacheInfo.memoryStoreEvictionPolicy == "LFU") {
						LFU.attr('checked','checked');
					}										
					LFU.appendTo(LFUTD).parent().appendTo(LFUTR);
					$('<q>ʹ</q>').addClass('platform_server_titlenote').appendTo(LFUTD);
					$('<td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>').appendTo(LFUTR);
					$('<td>ʹõݼʹû</td>').addClass('platform_server_areanote').appendTo(LFUTR);
					
					
					$('<tr><td><br>ʱ䣺</td></tr>').addClass('platform_server_titlenote').appendTo(dbTable);
					var timeToIdleSeconds = $('<input id="timetoidleseconds"/>').addClass('platform_server_titlenote');
					timeToIdleSeconds.attr('value', cacheInfo.timeToIdleSeconds);
					var timeToIdleSecondsTR = $('<tr/>').appendTo(dbTable);
					var timeToIdleSecondsTD = $('<td>').appendTo(timeToIdleSecondsTR);								
					timeToIdleSeconds.appendTo(timeToIdleSecondsTD);
					$('<td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>').appendTo(timeToIdleSecondsTR);
					$('<td>λ롣ʾݼ״̬ܹռûʱ䡣0ʾޡ</td>').addClass('platform_server_areanote').appendTo(timeToIdleSecondsTR);
					
					$('<tr><td>ʱ䣺</td></tr>').addClass('platform_server_titlenote').appendTo(dbTable);
					var timeToLiveSeconds = $('<input id="timetoliveseconds"/>').addClass('platform_server_titlenote');
					timeToLiveSeconds.attr('value', cacheInfo.timeToLiveSeconds);
					var timeToLiveSecondsTR = $('<tr/>').appendTo(dbTable);
					var timeToLiveSecondsTD = $('<td>').appendTo(timeToLiveSecondsTR);								
					timeToLiveSeconds.appendTo(timeToLiveSecondsTD);
					$('<td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>').appendTo(timeToLiveSecondsTR);
					$('<td>λ롣ʾݼڻеʱ䡣0ʾޡ</td>').addClass('platform_server_areanote').appendTo(timeToLiveSecondsTR);					
					
					$('<p>ģ建ã</p>').addClass('platform_server_areatitle').appendTo(cacheContent);
					var cptTable = $('<table style="margin-left: 40px;"/>').appendTo(cacheContent);					
					
					$('<tr><td><br>¶ȡģ壺</td></tr>').addClass('platform_server_titlenote').appendTo(cptTable);
					var alwaysReloadTplSet = true;
					var reloadTR = $('<tr/>').appendTo(cptTable);
					var reloadTD = $('<td style="padding-bottom: 10px; padding-top: 10px;">').appendTo(reloadTR);
					var trueReload = $('<input type="radio" name="alwaysReloadTpl" value="true"/>').click(function() {
						alwaysReloadTplSet = true;
					});
					if(cacheInfo.alwaysReloadTpl == true) {
						trueReload.attr('checked','checked');
					}
					var falseReload = $('<input type="radio" name="alwaysReloadTpl" value="false"/>').click(function() {
						alwaysReloadTplSet = false;
					});
					if(cacheInfo.alwaysReloadTpl == false) {
						falseReload.attr('checked','checked');
					}
					trueReload.appendTo(reloadTD);
					$('<q>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</q>').addClass('platform_server_titlenote').appendTo(reloadTD);
					falseReload.appendTo(reloadTD);
					$('<q></q>').addClass('platform_server_titlenote').addClass('platform_server_titlenote').appendTo(reloadTD);					
										
					$('<br><br><br>').appendTo(cacheContent);
					var submitcontent = $('<div/>').appendTo(cacheContent);									
					var buttonS = $('<input type="submit" value="ύ"/>').addClass('platform_server_titlenote').click(function() {
							
						var cacheInfo = {
							maxElementsInMemory: maxElementsInMemory.val(),
							memoryStoreEvictionPolicy: memoryStoreEvictionPolicySet,
							timeToIdleSeconds: timeToIdleSeconds.val(),
							timeToLiveSeconds: timeToLiveSeconds.val(),
							alwaysReloadTpl: alwaysReloadTplSet
						}
						FR.showLoadingDialog({width : 310, height : 80, title : "", text : "ύ"});			
						$.ajax({					
							url : '${servletURL}?op=fr_server_cacheattrset',
							type : 'POST',
							data : {
								type : 'POST',
								cacheAttrJson : FR.jsonEncode(cacheInfo)
							},
							complete : function(res, status) {
								FR.hideLoadingDialog();
								var cacheAttrStatus = res.responseText;							
								if(cacheAttrStatus=="success"){
									alert("ύɹ");
								}else{
									alert("ύʧ" + cacheAttrStatus);
								}
							}
			    		});
					}).width("50px").appendTo(submitcontent);
					
				}				
			})
			
			$.extend(this.reg, {
				_init : function() {
					
					var title = $('<div style="border-bottom: 1px solid rgb(51, 51, 51); padding: 10px; font-size: 12px; color: rgb(85, 170, 237);"/>').text("עϢ").appendTo(this);
					var cacheContent = $('<iframe id="reg"  src="${servletURL}?op=appserver" style="width: 100%; height: 89%; border-style: none;"/>').appendTo(this);
					
				}
			})
			
			$.extend(this.srvStatus, {
				_init : function() {
					var title = $('<div style="border-bottom: 1px solid rgb(51, 51, 51); padding: 10px; font-size: 12px; color: rgb(85, 170, 237);"/>').text("ʹ״̬").appendTo(this);
					var srvStatusContent = $('<div id="srvStatus" style="padding: 20px; font-size: 16px; overflow: auto;"/>').appendTo(this);
					
					var cptStatusInfo = null;
					var conPoolInfo = null;
					$.ajax({
						url : '${servletURL}?op=server_sessions_view',
						type : 'POST',
						async : false,
						complete : function(res, status) {
							if (res.responseText == null||res.responseText == "") {
								return;
							}
							cptStatusInfo = FR.jsonDecode(res.responseText);
						}
					});	
					$.ajax({
						url : '${servletURL}?op=fr_server_getconpoolinfo',
						type : 'POST',
						async : false,
						complete : function(res, status) {
							if (res.responseText == null||res.responseText == "") {
								return;
							}
							conPoolInfo = FR.jsonDecode(res.responseText);
						}
					});
					
					var cptStatusTable = $('<table>').appendTo(srvStatusContent);
					$('<tr><td>ǰ ϵͳ:<br></br></td></tr>').addClass('platform_server_areatitle').appendTo(cptStatusTable);
					var userNum = 0;
					userNumTR = $('<tr>').appendTo(cptStatusTable);
					userNumTD = $('<td>').appendTo(userNumTR);
					var titleTR = $('<tr>').appendTo(cptStatusTable);
					$('<div style="margin-left: 10px;margin-right: 10px;">ʱ</div>').addClass('platform_server_titlenote').appendTo($('<td style="border: 1px solid rgb(0, 0, 0)">')).parent().appendTo(titleTR);
					$('<div style="margin-left: 10px;margin-right: 10px;">ûIP</div>').addClass('platform_server_titlenote').appendTo($('<td style="border: 1px solid rgb(0, 0, 0)">')).parent().appendTo(titleTR);	
					$('<div style="margin-left: 10px;margin-right: 10px;">û</div>').addClass('platform_server_titlenote').appendTo($('<td style="border: 1px solid rgb(0, 0, 0)">')).parent().appendTo(titleTR);					
					var cptStatus = cptStatusInfo==null?{}:cptStatusInfo;
					$.each(cptStatusInfo, function(i) {
						var j = 0;
						for(;j<i;j++){
							if(cptStatusInfo[j].user==cptStatusInfo[i].user){
								break;
							}
						}
						if(j==i) {
							userNum++;
						}
						var contentTR = $('<tr>').appendTo(cptStatusTable);
						if(cptStatusInfo[i].ip=='0:0:0:0:0:0:0:1'||cptStatusInfo[i].ip=='127.0.0.1'){
							cptStatusInfo[i].ip='localhost';
						}
						$('<div style="margin-left: 10px;margin-right: 10px;">' + cptStatusInfo[i].name + '</div>').addClass('platform_server_titlenote').appendTo($('<td style="border: 1px solid rgb(0, 0, 0)">')).parent().appendTo(contentTR);
						$('<div style="margin-left: 10px;margin-right: 10px;">' + cptStatusInfo[i].ip + '</div>').addClass('platform_server_titlenote').appendTo($('<td style="border: 1px solid rgb(0, 0, 0)">')).parent().appendTo(contentTR);
						$('<div style="margin-left: 10px;margin-right: 10px;">' + cptStatusInfo[i].user + '</div>').addClass('platform_server_titlenote').appendTo($('<td style="border: 1px solid rgb(0, 0, 0)">')).parent().appendTo(contentTR);
					})
					$('<div>ǰϵͳû' + userNum + '</div>').addClass('platform_server_titlenote').appendTo(userNumTD);
					
					var conPoolTable = $('<table>').appendTo(srvStatusContent);
					var conPool = conPoolInfo==null?{}:conPoolInfo;
					$('<tr><td><br>ǰӳϢ:<br></br></td></tr>').addClass('platform_server_areatitle').appendTo(conPoolTable);
					$('<div style="margin-left: 10px;margin-right: 10px;">' + conPool.poolInfo + '</div>').addClass('platform_server_titlenote')
						.appendTo($('<td style="border: 1px solid rgb(0, 0, 0)"></td>')).parent().appendTo($('<tr>')).parent().appendTo(conPoolTable);
					
					if(conPool.runningCon!=null&&conPool.runningCon!=''){
						$('<tr><td><br>:<br></br></td></tr>').addClass('platform_server_areatitle').appendTo(conPoolTable);
						$('<div style="margin-left: 10px;margin-right: 10px;">' + conPool.runningCon + '<br></br></div>').addClass('platform_server_titlenote')
							.appendTo($('<td style="border: 1px solid rgb(0, 0, 0)"></td>')).parent().appendTo($('<tr>')).parent().appendTo(conPoolTable);
					}
				}
			})
			
			$.extend(this.connection, {
				_init : function() {
					var title = $('<div style="border-bottom: 1px solid rgb(51, 51, 51); padding: 10px; font-size: 12px; color: rgb(85, 170, 237);"/>').text("Ӳѯ޸").appendTo(this);
					var connectionContent = $('<div id="connection" style="padding: 20px; font-size: 16px; overflow: auto;"/>').appendTo(this);
					
					var connectionInfo = null;
					$.ajax({
						url : '${servletURL}?op=fr_server_getconnectioninfo',
						type : 'POST',
						async : false,
						complete : function(res, status) {
							if (res.responseText == null||res.responseText == "") {
								return;
							}
							connectionInfo = FR.jsonDecode(res.responseText);
						}
					});
					
					var changedConnectionArray = {};
					var changedConName = new Array(); 
					
					var conTable = $('<table>').appendTo(connectionContent);
					$('<tr><td>ǰб:<br></br></td></tr>').addClass('platform_server_areatitle').appendTo(conTable);
					$.each(connectionInfo, function(i){
						$('<tr><td>:</td><td style="width: 250px;">' + connectionInfo[i].name + '</td></tr>')
								.addClass('platform_server_titlenote').appendTo(conTable)
						
						var driverTR = $('<tr>').appendTo(conTable);
						$('<td>:</td>').addClass('platform_server_titlenote').appendTo(driverTR);
						var driverTD = $('<td>').appendTo(driverTR);
						var driverText =$('<input type="text" style="width: 200px;">').addClass('platform_server_titlenote').blur(function(){
							var connection = changedConnectionArray[connectionInfo[i].name];
							if (connection == null) {
								changedConName.push(connectionInfo[i].name);
								connection = {};
								changedConnectionArray[connectionInfo[i].name] = connection;
							}
							connection['driver'] = driverText.attr('value');
						}).appendTo(driverTD);
						driverText.attr('value', connectionInfo[i].driver);
						
						var urlTR = $('<tr>').appendTo(conTable);
						$('<td>url:</td>').addClass('platform_server_titlenote').appendTo(urlTR);
						var urlTD = $('<td>').appendTo(urlTR);
						var urlText =$('<input type="text" style="width: 800px;">').addClass('platform_server_titlenote').blur(function(){
							var connection = changedConnectionArray[connectionInfo[i].name];
							if (connection == null) {
								changedConName.push(connectionInfo[i].name);
								connection = {};
								changedConnectionArray[connectionInfo[i].name] = connection;
							}
							connection['url'] = urlText.attr('value');
						}).appendTo(urlTD);
						urlText.attr('value', connectionInfo[i].url);
								
						var userTR = $('<tr>').appendTo(conTable);
						$('<td>û:</td>').addClass('platform_server_titlenote').appendTo(userTR);
						var userTD = $('<td>').appendTo(userTR);
						var userText =$('<input type="text">').addClass('platform_server_titlenote').blur(function(){
							var connection = changedConnectionArray[connectionInfo[i].name];
							if (connection == null) {
								changedConName.push(connectionInfo[i].name);
								connection = {};
								changedConnectionArray[connectionInfo[i].name] = connection;
							}
							connection['user'] = userText.attr('value');
						}).appendTo(userTD);
						userText.attr('value', connectionInfo[i].user);
						
						var pwTR = $('<tr>').appendTo(conTable);
						$('<td>:</td>').addClass('platform_server_titlenote').appendTo(pwTR);
						var pwTD = $('<td>').appendTo(pwTR);
						var pwText =$('<input type="password">').addClass('platform_server_titlenote').blur(function(){
							var connection = changedConnectionArray[connectionInfo[i].name];
							if (connection == null) {
								changedConName.push(connectionInfo[i].name);
								connection = {};
								changedConnectionArray[connectionInfo[i].name] = connection;
							}
							connection['password'] = pwText.attr('value');
						}).appendTo(pwTD);
						pwText.attr('value', connectionInfo[i].password);
						
						$('<tr><td><br></br></td></tr>').appendTo(conTable);
					})
					
					$('<br><br><br>').appendTo(connectionContent);
					var submitcontent = $('<div/>').appendTo(connectionContent);									
					var buttonS = $('<input type="submit" value="ύ"/>').addClass('platform_server_titlenote').click(function() {
						
						FR.showLoadingDialog({width : 310, height : 80, title : "޸", text : "ύ"});			
						$.ajax({					
							url : '${servletURL}?op=fr_server_connectionattrset',
							type : 'POST',
							data : {
								type : 'POST',
								connectionAttrJson : FR.jsonEncode(changedConnectionArray),
								changedConName : FR.jsonEncode(changedConName)
							},
							complete : function(res, status) {
								FR.hideLoadingDialog();
								var cacheAttrStatus = res.responseText;							
								if(cacheAttrStatus=="success"){
									alert("ύɹ");
								}else{
									alert("ύʧ" + cacheAttrStatus);
								}
							}
			    		});
					}).width("50px").appendTo(submitcontent);
					
				}
			})
				
			this.basicset._init();
			this.mail._init();
			this.cache._init();
			this.reg._init();
			this.srvStatus._init();
			this.connection._init();
			this.mail.hide();
			this.cache.hide();
			this.reg.hide();
			this.srvStatus.hide();
			this.connection.hide();
			//barry:chromeҪdoLayoutʾҳ棬ֻʾߵwest
			this.doLayout();
			this.doLayout();
			$(window).resize(function() {
				self.doLayout();
			});
			titleTable.addClass("platform_server_tablediv");			
			this.serverinitfinish = true;
		}
	});
	
	$.extend(FR.PLATFORM.authenticationModule, {
		_init : function() {
			this.asComponent("iframe",{
				fieldName : "",
				src : "${servletURL}?op=fr_privilege",
				width : "100%",
				height : "100%"
			})
		}
	});
	
	$.extend(FR.PLATFORM.catalogDesignModule, {
		_initTree : function() {
			$.extend(this.treeArea, {
				_init : function() {
					this.append(this.iconButtons.getContent()).append(this.tree.getContent());
				},
				
				iconButtons : {
					_init : function() {
						this.content = $('<div/>').addClass('platform_catalog_tree_icons');
						this.content.append(this.createButtonTable(this.createButtons()));
					},
					
					getContent : function() {
						if (!this.content) {
							this._init();
						}
						return this.content;
					},
					
					rootState : function() {
						this.addfolderButton.setEnable(true);
						this.editfolderButton.setEnable(false);
						this.removefolderButton.setEnable(false);
						this.addcptButton.setEnable(false);
						this.addurlButton.setEnable(false);
					},
					
					activeState : function() {
						this.addfolderButton.setEnable(true);
						this.editfolderButton.setEnable(true);
						this.removefolderButton.setEnable(true);
						this.addcptButton.setEnable(true);
						this.addurlButton.setEnable(true);
					},
					
					defaultState : function() {
						this.addfolderButton.setEnable(false);
						this.editfolderButton.setEnable(false);
						this.removefolderButton.setEnable(false);
						this.addcptButton.setEnable(false);
						this.addurlButton.setEnable(false);
					}, 
					
					createButtonTable : function(buttons) {
						var tr = $('<tr/>');
						$.each(buttons, function(i) {
							tr.append($('<td/>').append(buttons[i]));
						});
						return $('<table/>').attr('align', 'center').addClass('platform_catalog_tree_icontable').append(tr);
					},
					
					
					//b:action 
					createButtons : function() {
						var imgurl = '${servletURL}?op=resource&resource=/com/fr/web/platform/images/';
						var cs = 'platform_catalog_tree_icon';
						var data = [];
						data[0] = {text : 'Ŀ¼', css : cs, img : imgurl + 'platform_addfolder.png', img_grey : imgurl + 'platform_addfolder_grey.png', size : 'big',
							action : function() {
								FR.showDialog("Ŀ¼",460,-1,SC.addFolderDialog(FR.PLATFORM.catalogDesignModule.treeArea.tree.getContent()));
							}};
						data[1] = {text : '༭Ŀ¼', css : cs, img : imgurl + 'platform_editfolder.png', img_grey : imgurl + 'platform_editfolder_grey.png', size : 'big',
							action : function() {
								FR.showDialog("༭Ŀ¼",460,-1,SC.editFolderDialog(FR.PLATFORM.catalogDesignModule.treeArea.tree.getContent()));			
							}};
						data[2] = {text : 'ɾĿ¼', css : cs, img : imgurl + 'platform_removefolder.png', img_grey : imgurl + 'platform_removefolder_grey.png', size : 'big',
							action : function() {
									var tree = FR.PLATFORM.catalogDesignModule.treeArea.tree.getContent();
									var currentItem = tree.getTCT();
									if(!currentItem || currentItem.id == "0-1"){
										return;
									}
									var confirm = window.confirm("ȷɾļ"+currentItem.text+"ļڵļ");
									if(confirm){
										var folderId = currentItem.id.substr(1);//ȥǰ0
										$.get(
											"${servletURL}",
											{
											op: "fr_schedule_delFolder",
											folderId: folderId
											},
											function callback(){//Ӧ
												tree.delNode(currentItem);
											}
										);
									}
							}};
						data[3] = {text : 'ģ', css : cs, img : imgurl + 'platform_addcpt.png', img_grey : imgurl + 'platform_addcpt_grey.png', size : 'big',
							action : function() {
								FR.showDialog("ģ", 480, -1, SC.addReportDialog(FR.PLATFORM.catalogDesignModule.treeArea.tree.getContent()));				
							}};
						data[4] = {text : '', css : cs, img : imgurl + 'platform_addurl.png', img_grey : imgurl + 'platform_addurl_grey.png', size : 'big',
							action : function() {
								FR.showDialog("ģ", 480, -1, SC.addURLDialog(FR.PLATFORM.catalogDesignModule.treeArea.tree.getContent()));											
							}};	
							
						var buttons = [];
						buttons[0] = this.addfolderButton = $('<div/>');
						this.addfolderButton.generateButton(data[0]);
						buttons[1] = this.editfolderButton = $('<div/>');
						this.editfolderButton.generateButton(data[1]);
						buttons[2] = this.removefolderButton = $('<div/>');
						this.removefolderButton.generateButton(data[2]);
						buttons[3] = this.addcptButton = $('<div/>');
						this.addcptButton.generateButton(data[3]);
						buttons[4] = this.addurlButton = $('<div/>');
						this.addurlButton.generateButton(data[4]);
						
						return buttons;				
					}
				}, 
				
				tree : {
					_init : function() {
						this.content = $('<div/>').addClass('platform_catalog_tree');
						this.initData();
					},
					
					getContent : function() {
						if (!this.content) {
							this._init();
						}
						return this.content;
					},
					
					initData : function() {
						var self = this;
						$.ajax({
							url : "${servletURL}?op=fr_schedule_getFolder",
							type : 'POST',
							complete : function(res, status) {
								self.treedata = FR.jsonDecode(res.responseText);
								var treeconfig = {
									onlyfolder : true,
									data : self.treedata,
									onnodeclick : function() {
										var currentFolder = self.content.getTCT();
										if (!currentFolder) {
											FR.PLATFORM.catalogDesignModule.treeArea.iconButtons.defaultState();
											FR.PLATFORM.SCHEDULE.hide();
											FR.PLATFORM.catalogDesignModule.filesArea.showBlank();
										} else if (currentFolder.id == '0-1') {
											FR.PLATFORM.catalogDesignModule.treeArea.iconButtons.rootState();
											FR.PLATFORM.SCHEDULE.hide();
		 									FR.PLATFORM.catalogDesignModule.filesArea.showBlank();
										} else {
											FR.PLATFORM.catalogDesignModule.treeArea.iconButtons.activeState();
											FR.PLATFORM.SCHEDULE.hide();
											FR.PLATFORM.catalogDesignModule.filesArea.show();
		 									FR.PLATFORM.catalogDesignModule.filesArea.showFiles(currentFolder);
										}
									} 
								};
								//barry:Ƿѡ˶ʱݿ⣬ûеĻѡ
								if(res.responseText == "nullSchDS"){
									FR.PLATFORM.moduleControls.doEvent($('.platform_smallserver'));
									alert("ѡƽ̨Դʱ֧accessݿ⣩");
								}
								self.content.treeview(treeconfig);
							}
						});
					}
					
					
				}
			});
			
			this.treeArea._init();
			
			
			$.extend(this.filesArea, {
				_init : function() {
					this.append(this.chooseFiles.hide())
						.append(this.reportTable.getContent().hide())
						.append(this.URLTable.getContent().hide());
				},
				
				chooseFiles : function() {
					var cf = $('<div/>').addClass('platform_catalog_choosefiles')
						.append($('<span/>').text("ѡ "))
						.append($('<span/>').text("ȫ ").addClass('platform_catalog_choosefiles_span')
						.click(function() {
							FR.PLATFORM.catalogDesignModule.filesArea.showAll();
						}))
						.append($('<span/>').text("ģ ").addClass('platform_catalog_choosefiles_span')
						.click(function() {
							FR.PLATFORM.catalogDesignModule.filesArea.showReport();
						}))
						.append($('<span/>').text("").addClass('platform_catalog_choosefiles_span')
						.click(function() {
							FR.PLATFORM.catalogDesignModule.filesArea.showURL();
						}));
					return cf;
				}(),
				
				reportTable : {
					_init : function() {
						this.content = $('<div/>').addClass('platform_catalog_reports');
						this.table = $('<table/>').attr('align', 'center').attr('cellpadding', '0').attr('cellspacing', '0').addClass('platform_catalog_reportTable').append(this.createTableHead());
						this.content.append(this.table);
					},
					
					getContent : function() {
						if (!this.content) {
							this._init();
						}
						return this.content;
					},
					
					createTableHead : function() {
						return $('<thead/>').append($('<tr/>').addClass('platform_catalog_tablehead')
							.append($('<th/>').attr('nowrap', 'nowrap').css('width', '15%').text(''))
							.append($('<th/>').attr('nowrap', 'nowrap').css('width', '29%').text(''))
							.append($('<th/>').attr('nowrap', 'nowrap').css('width', '15%').text('ʹģ'))
							.append($('<th/>').attr('nowrap', 'nowrap').css('width', '8%').text('ʽ'))
							.append($('<th/>').attr('nowrap', 'nowrap').css('width', '8%').text(''))
							.append($('<th/>').attr('nowrap', 'nowrap').css('width', '25%').text('')));
					},
					
					deleteReport : function(report) {
						var confirm = window.confirm("ȷɾѡģļ");
						var self = this;
						if (confirm) {
							$.ajax({
								url :"${servletURL}?op=fr_schedule_delReports",
								type : 'POST',
								data : {reportIds : report.id},
								complete : function(res, status) {
									if (status) {
										this.reports.remove(report);
										this.updateData(this.reports);
									}
								}.createDelegate(self)
							});
						}				
					},
					
					moveUpReport : function(report) {
						var index = this.reports.indexOf(report);
						if (index == 0 || this.reports.length < 2) {
							return;
						}
						var oldup = this.reports[index - 1];
						this.reports[index - 1] = this.reports[index];
						this.reports[index] = oldup;
						this.updateData(this.reports);
					},
					
					moveDownReport : function(report) {
						var index = this.reports.indexOf(report);
						if (index == this.reports - 1 || this.reports.length < 2) {
							return;
						}
						var olddown = this.reports[index + 1];
						this.reports[index + 1] = this.reports[index];
						this.reports[index] = olddown;
						this.updateData(this.reports);
					},
					
					addReport : function(report) {
						this.reports.push(report);
						this.updateData(this.reports);
					},
					
					editReport : function(report) {
						for (var i = 0, len = this.reports.length; i < len; i++) {
							if (this.reports[i].id == report.id) {
								this.reports[i] = report;
								break;
							}
						}
						this.updateData(this.reports);
					},
					
					editScheduleTask : function(report) {
						FR.PLATFORM.SCHEDULE.loadTask(report);
						FR.PLATFORM.catalogDesignModule.filesArea.hide();
						FR.PLATFORM.SCHEDULE.show();
					},
					
					generateOperationTD : function(report, index) {
						var buttons = this.defaultButtons(report, index);
						var tr = $('<tr/>');
						for(var i = 0, len = buttons.length; i < len; i++) {
							tr.append($('<td/>').append(buttons[i]));
						}
						return $('<td/>').attr('nowrap', 'nowrap').append($('<div/>').append($('<table/>').append(tr)));					
					},
					
					defaultButtons : function(report, index) {
						var buttons = [];
						var len = 5;
						for (var i = 0; i < len; i++) {
							buttons[i] = $('<div/>').data('report', report);
						}
						var imgurl = '${servletURL}?op=resource&resource=/com/fr/web/platform/images/';
						var cs = 'platform_catalog_table_icon';
						var data = [];

						data[0] = {text : '༭ģ', css : cs, img : imgurl + 'platform_editfile.png', img_grey : imgurl + 'platform_editfile.png', size : 'small',
							action : function() {
								FR.showDialog("༭ģ",460,-1,SC.editReportDialog(FR.PLATFORM.catalogDesignModule.treeArea.tree.getContent(), this.data('report')))
							}.createDelegate(buttons[0])};
							
						data[1] = {text : '༭ʱ', css : cs, img : imgurl + 'platform_scheduletask.png', img_grey : imgurl + 'platform_scheduletask_grey.png', size : 'small',
							action : function() {
								FR.PLATFORM.catalogDesignModule.filesArea.reportTable.editScheduleTask(this.data('report'));
							}.createDelegate(buttons[1])};
							
						data[2] = {text : 'ɾģ', css : cs, img : imgurl + 'platform_removefile.png', img_grey : imgurl + 'platform_removefile.png', size : 'small',
							action : function() {
								FR.PLATFORM.catalogDesignModule.filesArea.reportTable.deleteReport(this.data('report'));
							}.createDelegate(buttons[2])};
							
						data[3] = {text : '', css : cs, img : imgurl + 'platform_upfile.png', img_grey : imgurl + 'platform_upfile_grey.png', size : 'small',
							action : function() {
								FR.PLATFORM.catalogDesignModule.filesArea.reportTable.moveUpReport(this.data('report'));
							}.createDelegate(buttons[3])};	
							
						data[4] = {text : '', css : cs, img : imgurl + 'platform_downfile.png', img_grey : imgurl + 'platform_downfile_grey.png', size : 'small',
							action : function() {
								FR.PLATFORM.catalogDesignModule.filesArea.reportTable.moveDownReport(this.data('report'));
							}.createDelegate(buttons[4])};						
						
						$.each(buttons, function(i) {
							buttons[i].generateButton(data[i]);
						});
						
						if (index == 0) {
							buttons[0].setEnable(true);
							buttons[1].setEnable(true);
							buttons[2].setEnable(true);
							buttons[3].setEnable(false);
							buttons[4].setEnable(true);
						} else if (index == -1) {
							buttons[0].setEnable(true);
							buttons[1].setEnable(true);
							buttons[2].setEnable(true);
							buttons[3].setEnable(true);
							buttons[4].setEnable(false);
						} else if (index == -2) {
							buttons[0].setEnable(true);
							buttons[1].setEnable(true);
							buttons[2].setEnable(true);
							buttons[3].setEnable(false);
							buttons[4].setEnable(false);
						} else {
							buttons[0].setEnable(true);
							buttons[1].setEnable(true);
							buttons[2].setEnable(true);
							buttons[3].setEnable(true);
							buttons[4].setEnable(true);
						}
						
						
						return buttons;
					},
					
					generateReportTR : function(report, index) {
						var tr = $('<tr/>');
						tr.append($('<td/>').addClass('platform_tdcontent_hide').attr('nowrap', 'nowrap').text(report.text))
							.append(this.generateDescriptionTD(report.description))
							.append(this.generateLinkReportTD(report))
							.append($('<td/>').attr('nowrap', 'nowrap').text(report.isView ? 'Ԥ' : ''))
							.append($('<td/>').attr('nowrap', 'nowrap').text(report.transmitParameters ? '' : ''))
							.append(this.generateOperationTD(report, index));
							return tr;
					},
					
					generateDescriptionTD : function(description) {
						var td = $('<td/>').addClass('platform_tdcontent_hide');
						td.attr('title', description ? description : '').attr('nowrap', 'nowrap').text(description);
						return td;
					},
					
					generateLinkReportTD : function(report) {
						var td = $('<td/>').attr('nowrap', 'nowrap').addClass('platform_catalog_link');
						var ps = report.path.split("/");
						var parameters = report.transmitParameters==null?{}:report.transmitParameters;
						td.text(ps[ps.length - 1]);						
						td.click(function() {
							var reportpath = '${servletURL}?reportlet=' + report.path;
							$.each(parameters, function(i) {
								reportpath += ('&' + parameters[i].name + '=' + parameters[i].value);
							})
							if(!report.isView){
								reportpath += '&op=write';
							}
							window.open(FR.cjkEncode(reportpath));
						});
						
						return td;
					},
					
					embellishBackground : function() {
						var trs = this.table.children('tbody').children('tr');
						$.each(trs, function(i) {
							if (i%2 == 0) {
								$(trs[i]).addClass('platform_catalog_tre');
							} else {
								$(trs[i]).addClass('platform_catalog_tro');
							}
						});
					},
					
					updateData : function(reports) {
						if (!this.reports) {
							this.reports = [];
						}
						
						this.reports = reports;
						this.updateTable(reports);
						this.embellishBackground();				
					},
					
					updateTable : function(reports) {
						this.table.children('tbody').remove();
						var tbody = $('<tbody/>');
						var self = this;
						$.each(reports, function(i) {
							var index = (i == reports.length - 1) ? -1 : i;
							if (reports.length == 1) {
								index = -2;
							}
							tbody.append(self.generateReportTR(reports[i], index));
						});
						this.table.append(tbody);
					}
				},
				
				URLTable : {
					_init : function() {
						this.content = $('<div/>').addClass('platform_catalog_urls');
						this.table = $('<table/>').attr('align', 'center').attr('cellpadding', '0').attr('cellspacing', '0').addClass('platform_catalog_urlTable').append(this.createTableHead());
						this.content.append(this.table);
					},
					
					getContent : function() {
						if (!this.content) {
							this._init();
						}
						return this.content;
					},
					
					createTableHead : function() {
						return $('<thead/>').append($('<tr/>').addClass('platform_catalog_tablehead')
							.append($('<th/>').attr('nowrap', 'nowrap').css('width', '15%').text(''))
							.append($('<th/>').attr('nowrap', 'nowrap').css('width', '30%').text(''))
							.append($('<th/>').attr('nowrap', 'nowrap').css('width', '30%').text(''))
							.append($('<th/>').attr('nowrap', 'nowrap').css('width', '25%').text('')));
					},
					
					deleteURL : function(url) {
						var confirm = window.confirm("ȷɾѡģļ");
						var self = this;
						if (confirm) {
							$.ajax({
								url :"${servletURL}?op=fr_schedule_delReports",
								type : 'POST',
								data : {reportIds : url.id},
								complete : function(res, status) {
									if (status) {
										this.urls.remove(url);
										this.updateData(this.urls);
									}
								}.createDelegate(self)
							});
						}
					},
					
					moveUpURL : function(url) {
						var index = this.urls.indexOf(url);
						if (index == 0 || this.urls.length < 2) {
							return;
						}
						var oldup = this.urls[index - 1];
						this.urls[index - 1] = this.urls[index];
						this.urls[index] = oldup;
						this.updateData(this.urls);
					},
					
					moveDownURL : function(url) {
						var index = this.urls.indexOf(url);
						if (index == this.urls - 1 || this.urls.length < 2) {
							return;
						}
						var olddown = this.urls[index + 1];
						this.urls[index + 1] = this.urls[index];
						this.urls[index] = olddown;
						this.updateData(this.urls);
					},
					
					addURL : function(url) {
						this.urls.push(url);
						this.updateData(this.urls);
					},
					
					editURL : function(url) {
						for (var i = 0, len = this.urls.length; i < len; i++) {
							if (this.urls[i].id == url.id) {
								this.urls[i] = url;
								break;
							}
						}
						this.updateData(this.urls);
					},
					
					generateOperationTD : function(url, index) {
						var buttons = this.defaultButtons(url, index);
						var tr = $('<tr/>');
						for(var i = 0, len = buttons.length; i < len; i++) {
							tr.append($('<td/>').append(buttons[i]));
						}
						return $('<td/>').attr('nowrap', 'nowrap').append($('<div/>').append($('<table/>').append(tr)));					
					},
					
					defaultButtons : function(url, index) {
						var buttons = [];
						var len = 4;
						for (var i = 0; i < len; i++) {
							buttons[i] = $('<div/>').data('url', url);
						}
						var imgurl = '${servletURL}?op=resource&resource=/com/fr/web/platform/images/';
						var cs = 'platform_catalog_table_icon';
						var data = [];

						data[0] = {text : '༭', css : cs, img : imgurl + 'platform_editfile.png', img_grey : imgurl + 'platform_editfile.png', size : 'small',
							action : function() {
								FR.showDialog("༭ģ",460,-1,SC.editURLDialog(FR.PLATFORM.catalogDesignModule.treeArea.tree.getContent(), this.data('url')))
							}.createDelegate(buttons[0])};
							
						data[1] = {text : 'ɾ', css : cs, img : imgurl + 'platform_removefile.png', img_grey : imgurl + 'platform_removefile.png', size : 'small',
							action : function() {
								FR.PLATFORM.catalogDesignModule.filesArea.URLTable.deleteURL(this.data('url'));
							}.createDelegate(buttons[1])};
							
						data[2] = {text : '', css : cs, img : imgurl + 'platform_upfile.png', img_grey : imgurl + 'platform_upfile_grey.png', size : 'small',
							action : function() {
								FR.PLATFORM.catalogDesignModule.filesArea.URLTable.moveUpURL(this.data('url'));
							}.createDelegate(buttons[2])};	
							
						data[3] = {text : '', css : cs, img : imgurl + 'platform_downfile.png', img_grey : imgurl + 'platform_downfile_grey.png', size : 'small',
							action : function() {
								FR.PLATFORM.catalogDesignModule.filesArea.URLTable.moveDownURL(this.data('url'));
							}.createDelegate(buttons[3])};
							
						$.each(buttons, function(i) {
							buttons[i].generateButton(data[i]);
						});
						
						if (index == 0) {
							buttons[0].setEnable(true);
							buttons[1].setEnable(true);
							buttons[2].setEnable(false);
							buttons[3].setEnable(true);
						} else if (index == -1) {
							buttons[0].setEnable(true);
							buttons[1].setEnable(true);
							buttons[2].setEnable(true);
							buttons[3].setEnable(false);
						} else if (index == -2) {
							buttons[0].setEnable(true);
							buttons[1].setEnable(true);
							buttons[2].setEnable(false);
							buttons[3].setEnable(false);
						} else {
							buttons[0].setEnable(true);
							buttons[1].setEnable(true);
							buttons[2].setEnable(true);
							buttons[3].setEnable(true);
						}
						
						return buttons;
					},
					
					generateReportTR : function(url, index) {
						var tr = $('<tr/>');
						tr.append($('<td/>').addClass('platform_tdcontent_hide').attr('nowrap', 'nowrap').text(url.text))
							.append(this.generateDescriptionTD(url.description))
							.append(this.generateLinkURLTD(url.url))
							.append(this.generateOperationTD(url, index));
							return tr;
					},
					
					generateDescriptionTD : function(description) {
						var td = $('<td/>').addClass('platform_tdcontent_hide');
						td.attr('title', description ? description : '').attr('nowrap', 'nowrap').text(description);
						return td;
					},
					
					generateLinkURLTD : function(path) {
						var td = $('<td/>').attr('title', path).addClass('platform_tdcontent_hide').attr('nowrap', 'nowrap').addClass('platform_catalog_link');
						td.text(path);
						td.click(function() {
							window.open(path);
						});
						
						return td;
					},
					
					embellishBackground : function() {
						var trs = this.table.children('tbody').children('tr');
						$.each(trs, function(i) {
							if (i%2 == 0) {
								$(trs[i]).addClass('platform_catalog_tre');
							} else {
								$(trs[i]).addClass('platform_catalog_tro');
							}
						});
					},
					
					updateData : function(urls) {
						if (!this.urls) {
							this.urls = [];
						}
						
						this.urls = urls;
						this.updateTable(urls);
						this.embellishBackground();				
					},
					
					updateTable : function(urls) {
						this.table.children('tbody').remove();
						var tbody = $('<tbody/>');
						var self = this;
						$.each(urls, function(i) {
							var index = (i == urls.length - 1) ? -1 : i;
							if (urls.length == 1) {
								index = -2;
							}
							tbody.append(self.generateReportTR(urls[i], index));
						});
						this.table.append(tbody);
					}
				},
				
				showFiles : function(folder) {
					var id = folder.id;
					var self = this;
					$.ajax({
						url : '${servletURL}?op=fr_schedule_getfiles',
						type : 'POST',
						data : {folderID : id},
						complete : function(res, status) {
							if (!res.responseText) {
								return;
							}
							var files = FR.jsonDecode(res.responseText);
							self.initData(files);
							self.showAll();
						}
					});
				},				
								
				initData : function(files) {
					var reports = [];
					var urls = [];
					for (var i = 0, len = files.length; i < len; i++) {
						if (files[i].url == undefined) {
							reports.push(files[i]);						
						} else {
							urls.push(files[i]);
						}
					}
					this.reportTable.updateData(reports);
					this.URLTable.updateData(urls);
				},
				
				showAll : function() {
					this.chooseFiles.show();
					this.reportTable.getContent().show();
					this.URLTable.getContent().show();
//					this.parent().doLayout();
				},
								
				showReport : function() {
					this.chooseFiles.show();
					this.reportTable.getContent().show();
					this.URLTable.getContent().hide();
				},
				
				showURL : function() {
					this.chooseFiles.show();
					this.URLTable.getContent().show();
					this.reportTable.getContent().hide();
				},
				
				showBlank : function() {
					this.chooseFiles.hide();
					this.reportTable.getContent().hide();
					this.URLTable.getContent().hide();
				}
			});
			this.filesArea._init();
			
			this.initCenterPane();
					
			this.initTree = true;
		},
		
		initCenterPane : function() {
			this.centerPane = $('<div/>').addClass('platform_catalog_centerPane');
			this.centerPane.append(this.filesArea);
			FR.PLATFORM.SCHEDULE._init();
			FR.PLATFORM.SCHEDULE.hide();
			this.centerPane.append(FR.PLATFORM.SCHEDULE);
		},
		
		_init : function() {
			if (this.initfinish) {
				return;
			}
			if (!this.initTree) {
				this._initTree();
			}
			var content = this;
			content.asComponent("borderlayout", {items:[{
					region : 'west',
					el : this.treeArea
				}, {
					region : 'center',
					el : this.centerPane
				}]});
			//barry:ͷǱһchromeҪdoLayoutʾҳ棬ֻʾߵwest
			content.doLayout();
			content.doLayout();
			$(window).resize(function() {
				content.doLayout();
			});
			this.initfinish = true;
		},
		
		treeArea : $('<div/>').addClass('platform_catalog_treearea'),
		
		filesArea : $('<div/>').addClass('platform_catalog_filesarea')
	});
});