$(function() {
	$.extend(FR, {
		//b:Ҫܴ
		cookieInfor : {										
					getCookies : function() {
						var cookieString = document.cookie
						return unescape(cookieString).split(";");
					},
					
					addCookie : function(name, value) {
						var expires = new Date ();
						expires.setTime(expires.getTime() + (12 * 30 * 24 * 3600 * 1000)); 
						var newCookie = name + "=" + escape(value) + ";expires=" + expires.toGMTString();
						document.cookie = newCookie;
					},
					
					removeCookie : function(name) {
//						var newCookies = name + '=' + escape(value);
//						newCookies = [newCookies + ';', newCookies];
//						$.each(newCookies, function(i) {
//							if (document.cookie.match(new RegExp(newCookies[i]))) {
//								document.cookie = document.cookie.replace(new RegExp(newCookies[i]), '');
//								return false;
//							}
//						});
						var expires = new Date();
						expires.setTime(expires.getTime() - 1);
						document.cookie = name + '=' + ';expires=' + expires.toGMTString();  
					},
					
					platUser : function() {
						var $cookies = this.getCookies();
						var platUser = null;
						$.each($cookies, function(i) {
							if ($cookies[i].match(/platUser=/)) {
								platUser = $cookies[i].split('platUser=')[1];
								//֪return false;ʲô˼
//								return false;
							}
						});
						return platUser;
					},
					
					isDirectEnter : function() {
						var $cookies = this.getCookies();
						var directEnter = null;
						$.each($cookies, function(i) {
							if ($cookies[i].match(/directEnter=/)) {
								directEnter = $cookies[i].split('directEnter=')[1] == 'true';
//								return false;
							}
						});
						return directEnter;
					},
					
					isPWSaved : function() {
						var $cookies = this.getCookies();
						var pwSaved = null;
						$.each($cookies, function(i) {
							if ($cookies[i].match(/pwSaved=/)) {
								pwSaved = $cookies[i].split('pwSaved=')[1] == 'true';
//								return false;
							}
						});
						return pwSaved;
					},
					
					platPW : function() {
						var $cookies = this.getCookies();
						var platPW = null;
						$.each($cookies, function(i) {
							if ($cookies[i].match(/platPW=/)) {
								platPW = $cookies[i].split('platPW=')[1];
//								return false;
							}
						});
						return platPW;
				}
		}
	});	

FR.PLATFORM = {};

$.extend(FR.PLATFORM, {
	loginPage : {
			logNorth : $('<div style="height : 75px"/>').attr('id', 'logo_north').append($('<div><img src="${servletURL}?op=resource&resource=/com/fr/web/platform/images/logo_title.png"></img></div>').addClass('logo_image')),
				
			logCenter : $('<div style="background: rgb(255,255,255)"/>').attr('id', 'logo_center'),
			
			logSouth : function() {
				return _init();
				function _init() {
						var self = $('<div/>').attr('id', 'logo_south');
						//ben:\u00A9 Ȩŵutf8
						self.copyright = $('<p>\u00A9 2010 FineReport</p>').addClass('logo_bottom_right');
						self.copyright.appendTo(self);
						createUL(createLIData()).appendTo(self);
						return self;
				}
								
				function createUL(lis) {
					var ul = $('<ul/>').addClass('logo_bottom_link');
					$.each(lis, function(i) {
						createLI(lis[i], lis.length - i - 1).appendTo(ul);
					});	
					return ul;
				}
				
				function createLI(li, last) {
					var sign = ' | ';
					if (!last) {
						sign = '';
					}
					return $('<li/>').addClass('logo_bottom_link').append($('<a href="' + li.url + '">' + li.name + '</a>')).append($('<span>'+ sign +'</span>'));
				}
									
				function createLIData() {
					var data = [];
					data[0] = {name : '', url : 'http://www.finereport.com'};
//					data[1] = {name : '', url : 'http://www.finereport.com'};
					data[1] = {name : 'ϵ', url : 'http://www.finereport.com/company/contact'};
					return data;
				}
			}(),

			introduceInformation : {					
					_init : function() {
						this.content = this.createIntro();					
						introduceTable = this.content.introduceTable = $('<table/>').addClass('logo_introduceTable').attr('align', 'center');						
						this.content.append(this.generateTitle(introduceTable));
						
						data = this.content.data = this.tableData();
						$.each(this.content.data, function(i) {
							$('<tr/>').append($('<td/>').addClass('logo_intro_image').append($('<div class="' + data[i].image + '"></div>')))
								.append($('<td><b>' + data[i].introtitle + '</b><br/>' + data[i].introcontent + '</td>').addClass('logo_intro_description'))
								.appendTo(introduceTable);							
						});
						this.content.append(introduceTable);
					},
					
					introPart : function() {
						if (!this.content) {
							this._init();
						} 
						return this.content;
					},
					
					createIntro : function() {
						return $('<td/>').addClass('logo_intro');
					},
					
					generateTitle : function(table) {
						$('<tr/>').append($('<td colspan=2><p>FineReportƽ̨ܽ</p></td>').addClass('logo_center_table1_title')).appendTo(table);
					},
					
					tableData : function() {
						var data = [];
						data[0] = {image : 'logo_image_catalog', introtitle : 'Ŀ¼', introcontent : 'Ŀ¼Ŀ¼ӹģ壬ԸЩģӶʱĿ¼ͬʱҲԹⲿӡ'};
						data[1] = {image : 'logo_image_server', introtitle : '', introcontent : 'ڷáͲ鿴FRĸò'};
						data[2] = {image : 'logo_image_authention', introtitle : 'Ȩ', introcontent : 'Ȩ屨ĸȨޣȵȣͬʱ趨ƽ̨Ĺ'};
						return data;
					}				
			},
			
			logoInput : {
					_init : function() {
						this.content = this.createLogoIn();
						this.tableTop = $('<b/>').addClass('login_table')
												.append($('<b/>').addClass('login_table1'))
												.append($('<b/>').addClass('login_table2'))
												.append($('<b/>').addClass('login_table3'))
												.append($('<b/>').addClass('login_table4'));
						this.tableBottom = $('<b/>').addClass('login_table')
												.append($('<b/>').addClass('login_table4'))
												.append($('<b/>').addClass('login_table3'))
												.append($('<b/>').addClass('login_table2'))
												.append($('<b/>').addClass('login_table1'));
						
						this.innerTable = $('<table/>').addClass('logoin_table').attr('align', 'center');
						this.createCompeletTable(this.innerTable);
						this.content.append($('<div/>').addClass('login_innersize').append(this.tableTop).append(this.innerTable).append(this.tableBottom));
						this.content.error.hide();
					},
					
					logoinPart : function() {
						if (!this.content) {
							this._init();
						}
						return this.content;
					},
					
					createLogoIn : function() {
						return $('<td/>').addClass('logoin_outsidetd');
					},
					
					createCompeletTable : function(table) {
						table.append(this.generateLogin_title()).append(this.generateLogin_blank())
							.append(this.generateLogin_user()).append(this.generateLogin_blank())
							.append(this.generateLogin_pw()).append(this.generateLogin_error()).append(this.generateLogin_blank())
							.append(this.generateLogin_pwSave()).append(this.generateLogin_delogin()).append(this.generateLogin_blank()).append(this.generateLogin_submit());
					},
					
					generateLogin_blank : function() {
						return $('<tr/>').append($('<td colspan=2></td>').addClass('login_blanktr'));  
					},
					
					generateLogin_title : function() {
						return this.content.titleTR = $('<tr/>').append($('<td colspan="2">¼ϵͳ</td>').addClass('login_title'));
					},
					
					generateLogin_user : function() {
						this.content.user = $('<input type="text">').addClass('logoin_user');
						if(FR.cookieInfor.isPWSaved()){
							this.content.user.attr('value', FR.cookieInfor.platUser())
						}
						return $('<tr/>').append($('<td/>').attr({'align':'right', 'nowrap':'nowrap'}).addClass('login_text').append($('<span>û</span>'))).append($('<td/>').append(this.content.user));
					},
					
					generateLogin_pw : function() {
						this.content.pw = $('<input type="password">').addClass('logoin_pw');
						if(FR.cookieInfor.isPWSaved()){
							this.content.pw.attr('value', FR.cookieInfor.platPW())
						}
						return $('<tr/>').append($('<td/>').attr({'align':'right', 'nowrap':'nowrap'}).addClass('login_text').append($('<span>룺</span>'))).append($('<td/>').append(this.content.pw));
					},
					
					generateLogin_error : function() {
						this.content.error = $('<div>û</div>').addClass('logoin_error');
						return $('<tr/>').append($('<td/>')).append($('<td/>').addClass('login_text').append(this.content.error));
					},
					
					generateLogin_pwSave : function() {
						this.content.pwSave = $('<input type="checkbox">').addClass('logoin_delogin').click(function(e) {
							if (this.checked == true) {
								FR.cookieInfor.addCookie('pwSaved', true);
							} else {
								FR.cookieInfor.addCookie('pwSaved', false);
							}
						});
						if(FR.cookieInfor.isPWSaved()){
							this.content.pwSave.attr('checked','checked');
						}else{
							this.content.pwSave.attr('checked','');
						}
						
						return $('<tr/>').append($('<td/>').attr('align', 'right').append(this.content.pwSave)).append($('<td><span>û</span></td>').addClass('login_text'));
					},
					
					generateLogin_delogin : function() {
						this.content.delogin = $('<input type="checkbox">').addClass('logoin_delogin').click(function(e) {
							if (this.checked == true) {
								FR.cookieInfor.addCookie('directEnter', true);
							} else {
								FR.cookieInfor.addCookie('directEnter', false);
							}
						});
						if(FR.cookieInfor.isDirectEnter()){
							this.content.delogin.attr('checked','checked');
						}else{
							this.content.delogin.attr('checked','');
						}
											
						return $('<tr/>').append($('<td/>').attr('align', 'right').append(this.content.delogin)).append($('<td><span>Զ¼</span></td>').addClass('login_text'))
							
					},					
					
					generateLogin_submit : function() {						
						this.content.submitButton = $('<div/>');
						
						var buttonTR = $('<tr/>').append($('<td/>')).append($('<td/>').attr('align', 'center').append(this.content.submitButton));
						this.content.submitButton.asComponent('button', {
							text : '¼',
							handler : this.logoinAuth.createDelegate(this)
						});
						return buttonTR;
					},
					
					logoinAuth : function() {
						var self = this;
						FR.cookieInfor.addCookie('platUser', this.content.user.val());
						FR.cookieInfor.addCookie('platPW', this.content.pw.val());
						var o = {
							fr_username : this.content.user.val(), 
							fr_password : this.content.pw.val(),
							showError : "showError"
						};
						
						$.ajax({
							type : 'POST',
							url : '${servletURL}?op=auth_login',
							data : {__parameters__: FR.cjkEncode(FR.jsonEncode(o))},
							complete : function(res, status) {
								var loginRes = FR.jsonDecode(res.responseText);
								if (loginRes.resError == 'showError') {
									self.showError();
								}else {
									window.location.href = loginRes.url;
								} 					
							}
						});
					},
					
					showError : function() {
						this.content.error.show();
					}
			},
			
			_init : function() {
				if (this.checkDirectEnter()) {
					this.doEnter(FR.cookieInfor.platUser(), FR.cookieInfor.platPW());
					return;
				}
				this.generatePage();
			},
			
			_initLogCenter : function(center) {
				center.append($('<table/>').addClass('centerTable').append($('<tr/>').append($('<td/>').attr('colspan', 2).addClass('logcenter_topblank'))).append($('<tr/>').append(this.introduceInformation.introPart())
					.append(this.logoInput.logoinPart())));
			},
			
			generatePage : function(state) {
				if (!this.isPageBuild()) {
					this._initLogCenter(this.logCenter);
					var content = $("body");
					content.asComponent("borderlayout", {items:[{
						region : 'north',
						el : this.logNorth
					}, {
						region : 'center',
						el : this.logCenter
					}, {
						region : 'south',
						el : this.logSouth
					}]});
					content.doLayout();
					
					window.onresize = function(){
						content.doLayout();
					}
				}
				if (state == 'false') {
					this.logoInput.showError();
				}
			},
			
			isPageBuild : function() {
				//b:ַʽ
				return $(".logo_center").length;	
			},
			
			doEnter : function(user, pw) {
				var self = this;
				var o = {
					fr_username : user, 
					fr_password : pw,
					showError : "showError"
				};
				$.ajax({
					type : 'POST',
					url : '${servletURL}?op=auth_login',
					data : {__parameters__: FR.cjkEncode(FR.jsonEncode(o))},
					complete : function(res, status) {
						var loginRes = FR.jsonDecode(res.responseText);
						if (loginRes.resError == 'showError') {
							self.showError();
						}else {
							window.location.href = loginRes.url;
						} 	
	    			}
				});
			},
			
			checkDirectEnter : function() {
				if (FR.cookieInfor.isDirectEnter() && FR.cookieInfor.platUser() &&  FR.cookieInfor.platPW()) {
					return true;
				}
				return false;
			}	
	}
});
});

