$(function() {
	$.extend(FR.PLATFORM, {
		createParameterTable : function(div, cf) {
			if (!div) {
				return;
			}

			var originalConfig = {
				opClass : "platform_parameterTable_head",
				optableClass : "platform_parameterTable_head_table",
				tableClass : "platform_parameterTable",
				thClass : "platform_parameterTable_tableHead",
				firstTdClass : "platform_parameterTable_1td",
				secondTdClass : "platform_parameterTable_2td",
				thirdTdClass : "platform_parameterTable_3td",
				fourthTdClass : "platform_parameterTable_4td"	
			};
			
			var config = {};
			
			$.extend(config, cf, originalConfig);
			
			$.extend(div, {
				_init : function() {
					this.table = $('<table/>').attr('cellspacing', 0).attr('cellpadding', 0).attr('align', 'center').addClass(config.tableClass).append($('<tbody/>'));
					this.table.append(this.createTableHead());
					this.append(this.createOperationPane());
					this.append(this.table);
					this.parameters = [];
				},
				
				getType : function(displayValue) {
					if (!this.data(displayValue)) {
						this.initTypeAndDisplay();
					}
					return this.data(displayValue);
				},
				
				initTypeAndDisplay : function() {
					this.data(FR.i18n.Parameter_String, 'String');
					this.data(FR.i18n.Parameter_Integer, 'Integer');
					this.data(FR.i18n.Parameter_Double, 'Double');
					this.data(FR.i18n.Parameter_Boolean, 'Boolean');
					this.data(FR.i18n.Parameter_Date, 'Date');
					this.data(FR.i18n.Parameter_Formula, 'Formula');
				},
				
				createOperationPane : function() {
					return $('<div/>').addClass(config.opClass).append(this.generateOPTable());					
				},
				
				generateOPTable : function() {
					var optable = $('<table/>').addClass(config.optableClass);
					var self = this;
					var imgurl = '${servletURL}?op=resource&resource=/com/fr/web/platform/images/';
					var cs = 'platform_parametertable_icon';
					var data = [];
					data[0] = {text : '', css : cs, img : imgurl + 'platform_outparameters.png', img_grey : imgurl + 'platform_outparameters.png', size : 'small',
						action : function() {
							this.generateReportParameters();	
						}.createDelegate(self)};
							
					data[1] = {text : 'Ӳ', css : cs, img : imgurl + 'platform_addparameter.png', img_grey : imgurl + 'platform_addparameter.png', size : 'small',
						action : function() {
							this.addParameter();
						}.createDelegate(self)};
							
					data[2] = {text : 'ɾ', css : cs, img : imgurl + 'platform_removeparameter.png', img_grey : imgurl + 'platform_removeparameter_grey.png', size : 'small',
						action : function() {
							this.removeSelectedParameters();
						}.createDelegate(self)};	
							
					var buttons = [];
					$.each(data, function(i) {
						buttons[i] = $('<div/>');
						buttons[i].generateButton(data[i]);
					});
					buttons[0].setEnable(true);
					buttons[1].setEnable(true);
					this.deleteButton = buttons[2];
					
					var ta = $('<tr/>').append($('<td/>').addClass('platform_parameter_head_space').text(':'));
					for (var i = 0, len = buttons.length; i < len; i++) {
						ta.append($('<td/>').append(buttons[i]));
					}
					
					return optable.append(ta);
				},
				
				createTableHead : function() {
					return $('<thead/>').append($('<tr/>').addClass(config.thClass)
						.append(this.selectTH().css('width', '16%'))
						.append($('<th/>').text('').addClass(config.secondTdClass).css('width', '22%'))
						.append($('<th/>').text('').addClass(config.thirdTdClass).css('width', '22%'))
						.append($('<th/>').text('ֵ').addClass(config.fourthTdClass)).css('width', '40%'));
				},
				
				selectTH : function() {
					var self = this;
					return $('<th/>').text('ȫѡ/ѡ').addClass(config.firstTdClass)
						.click(function(e) {
							self.invertAll();
						});
				},
				
				invertAll : function() {
					var trs = this.table.children('tbody').children('tr');
					for (var i = 0, len = trs.length; i < len; i++) {
						$($(trs[i]).children('td')[0]).children('input').attr('checked', !$($(trs[i]).children('td')[0]).children('input').attr('checked'));						
					}
				},
				
				setReport : function(report) {
					this.report = report;
				},
				
				generateReportParameters : function() {
					if (!this.report) {
						return;
					}
					var id = (this.report.id + '').substr(1);
					var path = this.report.path;
					var self = this;
					$.ajax({
						url : "${servletURL}?op=fr_schedule_genParameter",
						type : 'POST',
						asyn : false,
						data : {reportPath : path},
						complete : function(res, status) {
							if (!res.responseText) {
								return;
							}
							var parameters;
							try {
								parameters = FR.jsonDecode(res.responseText);
							} catch(e) {
								FR.Msg.alert("error", "Parameter parse error!");
								return;
							}
							self.updateParameters(parameters);
//							for (var i = 0, len = parameters.length; i < len; i++) {
//								self.updateParameters(parameters[i]);
//							}
						}
					});					
				},
				
				addParameter : function(parameter) {
					this.addParaTR(parameter);
				},
				
				removeSelectedParameters : function() {
					var confirm = window.confirm("ȷɾѡ");
					if (confirm !== true) {
						return;
					}
					var trs = this.table.children('tbody').children();
					for (var i = 0, len = trs.length; i < len; i++) {
						if ($($(trs[i]).children('td')[0]).children('input').attr('checked')) {
							this.removeParameter($(trs[i]));
						}
					}
					this.checkDeleteButton();
				},
				
				removeParameter : function(tr) {
					this.removeParaTR(tr);
				},
				
				addParaTR : function(parameter) {
					var tr = $('<tr/>').append(this.generateCheckTD())
						.append(this.generateNameTD(parameter ? parameter.name : undefined))
						.append(this.generateTypeTD(parameter ? eval('FR.i18n.Parameter_' + parameter.type) : undefined))
						.append(this.generateValueTD(parameter ? parameter.value : undefined));
					this.table.children('tbody').append(tr);
					this.embellishTable();
				},
				
				generateCheckTD : function() {
					var self = this;
					var check = $('<input/>').attr('type', 'checkbox').click(function() {
						self.checkDeleteButton();
					});
					return $('<td/>').addClass('platform_parameter_checkboxtd').append(check);
				},
				
				checkDeleteButton : function() {
					if (!this.deleteButton) {
						return;
					}
					var trs = this.table.children('tbody').children();
					var cando = false;
					for (var i = 0, len = trs.length; i < len; i++) {
						if ($($(trs[i]).children('td')[0]).children('input').attr('checked')) {
							cando = true;
							break;
						}
					}
					this.deleteButton.setEnable(cando);
				},
				
				generateNameTD : function(name) {
					var self = this;
					var td = $('<td/>').addClass('platform_parameter_nametd');
					if (name != undefined) {
						td[0].showValue = $('<span/>').text(name);
						td.append(td[0].showValue);
					}
					
					td.click(function(e) {
						if (self.editingCell == this) {
							return;
						}
						if (this.showValue) {
							this.showValue.hide();
						}
						if (!this.editor) {
							this.editor = $('<div/>');
							$(this).append(this.editor);
							 var config = {width : this.offsetWidth,
							 	 height : this.offsetHeight };
							this.editorObject = this.editor.asComponent('text', config);
							this.editorObject.$editorComponent.blur(function() {
								self.stopEditing();
							});						
						}
						self.stopEditing();
						self.editingCell = this;
						this.editorObject.visible();
						if (this.showValue) {
						this.editorObject.setValue(this.showValue.text());	
						}
							
						this.editorObject.$editorComponent.focus();												
					});
					
					return td;
				},
				
				generateTypeTD : function(type) {
					var self = this;
					var td = $('<td/>').addClass('platform_parameter_typetd');
					if (type != undefined) {
						td[0].showValue = $('<span/>').text(type);
						td.append(td[0].showValue);
					}
					
					td.click(function(e) {
						if (self.editingCell == this) {
							return;
						}
						if (this.showValue) {
							this.showValue.hide();
						}
						
						if (!this.editor) {
							this.editor = $('<div/>');
							$(this).append(this.editor);
							 var config = {width : this.offsetWidth,
							 	 height : this.offsetHeight,
							 	 editable : false,
								 allowBlank : false,
								 mode: 'local',

								 items: [{value: FR.i18n.Parameter_String, text: FR.i18n.Parameter_String},
										{value: FR.i18n.Parameter_Integer, text: FR.i18n.Parameter_Integer},
										{value: FR.i18n.Parameter_Double, text: FR.i18n.Parameter_Double},
										{value: FR.i18n.Parameter_Boolean, text: FR.i18n.Parameter_Boolean},
										{value: FR.i18n.Parameter_Formula, text: FR.i18n.Parameter_Formula}]};
							this.editorObject = this.editor.asComponent('combo', config);						
						}
						self.stopEditing();
						self.editingCell = this;
						this.editorObject.visible();
						if (this.showValue) {
							this.editorObject.setValue(this.showValue.text());	
						}	
												
					});
					
					return td;
				},
				
				generateValueTD : function(value) {
					var self = this;
					var td = $('<td/>').addClass('platform_parameter_valuetd');
					if (value != undefined) {
						td[0].showValue = $('<span/>').text(value);
						td.append(td[0].showValue);
					}
					
					
					td.click(function(e) {
						if (self.editingCell == this) {
							return;
						}
						if (this.showValue) {
							this.showValue.hide();
						}
						if (!this.editor) {
							this.editor = $('<div/>');
							$(this).append(this.editor);
							 var config = {width : this.offsetWidth,
							 	 height : this.offsetHeight };
							this.editorObject = this.editor.asComponent('text', config);
							this.editorObject.$editorComponent.blur(function() {
								self.stopEditing();
							});								
						}
						self.stopEditing();
						self.editingCell = this;
						this.editorObject.visible();
						if (this.showValue) {
							this.editorObject.setValue(this.showValue.text());	
						}	
						this.editorObject.$editorComponent.focus();											
					});
					
					return td;
				},
				
				removeParaTR : function(tr) {
					tr.remove();
					this.embellishTable();
				},
				
				matchTR : function(tr, parameter) {
					if (tr.children().length < 4) {
						return;
					}
					if ($(tr.children()[1]).text() == parameter.name
						&& this.getType($(tr.children()[2]).text()) == parameter.type
						&& $(tr.children()[3]).text() == parameter.value) {
						return true;
					}
				},
				
				removeAll : function() {
					this.table.children('tbody').children().remove();
				},
				
				updateParameters : function(parameters) {				
					this.removeAll();
					if (!parameters) {
						return;
					}
					for (var i = 0, len = parameters.length; i < len; i++) {
						this.addParameter(parameters[i]);
					}
				},
				
				getParameters : function() {
					var trs = this.table.children('tbody').children('tr');
					var parameters = [];
					for (var i = 0, len = trs.length; i < len; i++) {
						var tdname = $($(trs[i]).children('td')[1]).children('span').text();
						var tdtype = this.getType($($(trs[i]).children('td')[2]).children('span').text());
						var tdvalue = $($(trs[i]).children('td')[3]).children('span').text();
						parameters.push({name: tdname, type : tdtype, value : tdvalue});
					}
					return parameters;
				},
				
				embellishTable : function() {
					var trs = this.table.children('tbody').children('tr');
					$.each(trs, function(i) {
						if (i%2 == 0) {
							$(trs[i]).addClass('platform_catalog_tre');
						} else {
							$(trs[i]).addClass('platform_catalog_tro');
						}
					});
				}, 
				
				stopEditing : function() {
					if (!this.editingCell || !this.editingCell.editorObject) {
						return;
					}
					this.editingCell.editorObject.invisible();
					if (!this.editingCell.showValue) {
						this.editingCell.showValue = $('<span/>');
						$(this.editingCell).append(this.editingCell.showValue);
					}
					this.editingCell.showValue.show();
					this.editingCell.showValue.text(this.editingCell.editorObject.getValue());
					this.editingCell = null;
				}
			});
			
			div._init();
		},
		
		platformButton : {
			
		}
	});
});