/*
 * b/sʵֵJControlPane
 */
(function($){
	$.fn.jlist = function(opts){
		var op = {
			needhead:false,// ǷҪʾӡɾȲ˵ť
			onnodeclick:false,// һѡǴ
			initaction:false,
			// ִж              ɾ                 
			operation : {addaction:false, deleteaction:false, renameaction:false},
			cpPrefix: "_list_",
			url:false,
			iconpath:"${servletURL}?op=resource&resource=/com/fr/web/platform/images/jlist/user.png",
			addiconpath:"${servletURL}?op=resource&resource=/com/fr/web/platform/images/jlist/add.png",
			deleteiconpath:"${servletURL}?op=resource&resource=/com/fr/web/platform/images/jlist/delete.png",
			editiconpath:"${servletURL}?op=resource&resource=/com/fr/web/platform/images/jlist/user_edit.png",
			data:[]
		}
		$.extend(op, opts);
		if (op.url){
			$.ajax({
				url : op.url,
				type : "POST",
				async : false,
				dataType : "json",
				success: function(res){
					op.data = res;
				},
                error: function(e) { alert("error occur!"); }
			});
		}
		
		var me = $(this);
        var meid = me.attr("id");
        if (meid == null || meid == "") {
            meid = "jquery_jlist" + new Date().getTime();
            me.attr("id", meid);
        }

        var html = [];
        buildControlList(op.data, html);
        me.addClass("bbit-cp-bwrap").html(html.join(""));	
        initEvent(me);
        
        function buildControlList(data, ht){
        	ht.push("<div class='bbit-cp-body'>");
        	if (op.needhead) {
        	   createHeader(ht);
        	}
        	ht.push("<ul class='available bbit-cp-content'>");
        	var len = data.length;
        	for (var i = 0; i < len; i ++){
        		addItem(data[i], ht, i);
        	} 
        	ht.push("</ul>");
        	ht.push("</div>");     	
        }
        
        function createHeader(ht){
        	ht.push("<div class='bbit-cp-header'>");
        	ht.push("<span class='bbit-cp-operation'>", "<img class='bbit-cp-operation-add' src='", op.addiconpath, "'>", "</span>");
        	ht.push("<span class='bbit-cp-operation'>", "<img class='bbit-cp-operation-delete' src='", op.deleteiconpath, "'>", "</span>");
        	ht.push("<span class='bbit-cp-operation'>", "<img class='bbit-cp-operation-edit' src='", op.editiconpath, "'>", "</span>");
        	ht.push("</div>");
        }
        
		function addItem(item, ht, index){
			ht.push("<li class='bbit-cp-node' id='", meid, op.cpPrefix,index,"'>");
			ht.push("<div class='bbit-cp-node-el'>");
			//ht.push("<img class='bbit-cp-node-icon' src='", op.iconpath, "'>");
			ht.push("<a hideFocus class='bbit-cp-node-anchor' tabIndex=1>");
            ht.push("<span unselectable='on'>", item.text, "</span>");
            ht.push("</a>");
			ht.push("</div>");
			ht.push("</li>");
		}
		
		function initEvent(parent){
			var nodes = $("li.bbit-cp-node", me);
			nodes.each(function(i, item){
				$(this).hover(function(){
					$(this).addClass("bbit-cp-node-over");
				}, function(){
					$(this).removeClass("bbit-cp-node-over");
				}).unbind("click", doSelected).bind("click", doSelected)
			});
			var operations = $(".bbit-cp-header .bbit-cp-operation", me);
			operations.each(function(e){
				$(this).unbind("click", operation).bind("click", operation);
			});
			// richer:гʼҪ¼ôʼִ
			if (op.initaction){
			    op.initaction.apply(this, arguments);
			}
		}
		
		function doSelected(e){
			var id = $(this).attr("id");      
            if (op.cindex){
            	$("#"+ meid + op.cpPrefix + op.cindex).removeClass("bbit-cp-node-selected");
            }
            var oldItem = op.cindex ? op.data[op.cindex] : null; 
            var index = getItemIndex(id);
            var newItem = op.data[index];
            
            op.cindex = index;
            $(this).addClass("bbit-cp-node-selected");
            if (op.onnodeclick){
            	op.onnodeclick.call(this, index, newItem, oldItem);
            }                
		}
		
		function getItemIndex(id){			
			id = id.replace(meid + op.cpPrefix, "");
			return id;
		}
		
		function operation(e){
			var et = e.target || e.srcElement;
			if (et.tagName == "IMG") {
				if ($(et).hasClass("bbit-cp-operation-add")){
					var name = prompt(FR.i18n.Privilege_Input_A_Name);
			        if (!name){
			        	FR.Msg.alert(FR.i18n.Info, FR.i18n.Privilege_Name_Cannot_Be_Null);				  
			        } else {
			           var item = {};
			           item.text = name;
			           doAddItem(item);
			        }
				} else if ($(et).hasClass("bbit-cp-operation-delete")){
					doDeleteItem();
				} else {
					doEditItem();
				}
			}
		}
		// 
		function doAddItem(item){
			op.data.push(item);
			var ht = [];
			addItem(item, ht, op.data.length - 1);
			$("ul.bbit-cp-content", me).append(ht.join(""));
			initEvent(me);
			if (op.operation.addaction && op.needhead){
				op.operation.addaction.call(this, item);
			}
						
		}
		// ɾ
		function doDeleteItem(){
			var currentIndex = getSelectedIndex();
			var item = getSelectedItem();
			if (currentIndex == -1){
				FR.Msg.alert(FR.i18n.Info, FR.i18n.Privilege_Selected_None_Of_Any_Items + "!");
				return false;
			}
			var orgLen = op.data.length;
			// richer:ɾԪ
			op.data.splice(currentIndex, 1);
			// richer:idҪӦı仯
			$("#" + meid + op.cpPrefix + currentIndex, me).remove();
			for (var i = currentIndex; i < orgLen; i ++){
				var cid = meid + op.cpPrefix + i;
				var nid = meid + op.cpPrefix + (i - 1);
				$("#" + cid, me).attr("id", nid);
			}
			var next = $("#" + meid + op.cpPrefix + currentIndex);		
			if (next.length != 0){
				next.addClass("bbit-cp-node-selected");
			}
			if (op.operation.deleteaction && op.needhead){
				op.operation.deleteaction.call(this, item);
			}
		}
		// ༭
		function doEditItem(){
			var item = getSelectedItem();
			if (!item){
				FR.Msg.alert(FR.i18n.Info, FR.i18n.Privilege_Selected_None_Of_Any_Items + "!");
				return false;
			}
			var oldname = item.text;
			var newname = prompt("Rename", oldname);
			item.text = newname;
			// richer:Ҫıʾֵ
			var li = $("#" + meid + op.cpPrefix + getSelectedIndex());
			$("span", li).text(v);
			if (op.operation.renameaction && oldname != newname && op.needhead){
				op.operation.renameaction.call(this, item, oldname);
			}
		}
		
		function doClear(){
			op.data = [];
			$(".bbit-cp-node", me).remove();
		}
		
		// null:none selected
		function getSelectedItem(){
			var index = getSelectedIndex();
			return index != -1 ? op.data[index] : null;
		}
		
		// -1:none selected
		function getSelectedIndex(){
			var currentLi = $("li.bbit-cp-node-selected", me);
			var index = currentLi.length != 0 ? currentLi.attr("id").replace(meid + op.cpPrefix, "") : -1;
			return index;
		}

		me[0].t = {
			addItem : function(item){
				doAddItem(item);
			},
			clear : function(){
				doClear();
			},
			getText : function(){
				var item = getSelectedItem();
				return item != null ? item.text : null;
			},
			getValue : function(){
				var item = getSelectedItem();
				return item != null ? FR.jsonDecode(item.value) : null;
			},
			getAll : function(){
			    var all = [];
			    for (var i = 0, len = op.data.length; i < len; i ++){
			       var data = {};
			       var nd = op.data[i];
			       var text = nd.text;
			       data.text = text;			   
			       var val = nd.value;
			       data.value = val ? FR.jsonDecode(val) : text;
			       all.push(data);
			    }
			    return all;
			},
			setAll : function(val){
				var self = this;
				var len = op.data.length;
				if (len == 0) {
					$.each(val, function(name, nd){
						// richer:д,ĵķҵ
						if (typeof nd == "string") {
							var item = {};
							item.text = name;
							doAddItem(item);
						} else {
						    nd[0].text = name;
						    doAddItem(nd[0]);
						}
					})
					return;
				}
				for (var index = 0, len = op.data.length; index < len; index ++){
			         var dt = op.data[index];
			         $.each(val, function(name, nd){
			         	if (name == dt.text) {
			               dt.value = FR.jsonEncode(nd);
			            }
			         })
				}
			},
			getItem : function(){
				var item = getSelectedItem();
				return item;
			},
			setValue : function(val, it){
				var currentText = this.getText();
			    for (var index = 0, len = op.data.length; index < len; index ++){
			         var dt = op.data[index];
			         if (it){
			         	if (it.text == dt.text){
			         		dt.value = FR.jsonEncode(val);
			                break;
			         	}
			         } else if (dt.text == currentText){
			         	  dt.value = FR.jsonEncode(val);
			         }
			    }		  
			}
		};
		
		return me;
	}
	
	$.fn.getListText = function() {
        if (this[0].t) {
            return this[0].t.getText();
        }
        return null;
    }
    $.fn.getListValue = function() {
        if (this[0].t) {
            return this[0].t.getValue();
        }
        return null;
    }
    $.fn.getListAll = function() {
       if (this[0].t) {
            return this[0].t.getAll();
        }
       return null;
    }
    $.fn.getListItem = function() {
        if (this[0].t) {
            return this[0].t.getItem();
        }
        return null;
    }
    $.fn.addListItem = function(item){
    	if (this[0].t) {
    		return this[0].t.addItem(item);
    	}
    }
    $.fn.setListValue = function(value, item) {
        if (this[0].t) {
            this[0].t.setValue(value, item);
        }
    }
    $.fn.setListAll = function(val){
    	if (this[0].t){
    		this[0].t.setAll(val);
    	}
    }
    $.fn.clearList = function(){
    	if (this[0].t){
    		this[0].t.clear();
    	}
    }
    
})(jQuery);