/*
 * Decompiled with CFR 0.152.
 */
package com.esms;

import com.esms.ConfigInfo;
import com.esms.HostInfo;
import com.esms.MOMsg;
import com.esms.MessageData;
import com.esms.ProxyServer;
import com.esms.common.MTSupport;
import com.esms.common.entity.Account;
import com.esms.common.entity.AccountInfo;
import com.esms.common.entity.BindChannel;
import com.esms.common.entity.BusinessType;
import com.esms.common.entity.GsmsResponse;
import com.esms.common.entity.MTPack;
import com.esms.common.entity.MTReport;
import com.esms.common.entity.MTResponse;
import com.esms.common.entity.TicketInfo;
import com.esms.common.util.CommonUtil;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.UUID;

public class PostMsg {
    public static boolean needConfirm = true;
    private HostInfo wsHost = new HostInfo("211.147.224.154", 8080);
    private HostInfo gwHost = new HostInfo("211.147.224.154", 18013);
    private ProxyServer proxy;
    public static final int E_INVALID_USER_PASSWORD = -6;
    public static final int E_FAILED_CONNECTED_TO_SERVER = -3;
    public static final int E_FAILED_TO_POST_MESSAGE = -99;
    public static final int E_INVALID_MESSAGE_DATA = -5;
    private Account account;

    public PostMsg() {
        this(false);
    }

    public PostMsg(boolean isInShortMode) {
        this(isInShortMode, 50000);
    }

    public PostMsg(boolean isInShortMode, int soTimeout) {
        this.proxy = new ProxyServer(this.gwHost, this.wsHost, isInShortMode, soTimeout);
    }

    public HostInfo getCmHost() {
        return this.gwHost;
    }

    public HostInfo getWsHost() {
        return this.wsHost;
    }

    public ProxyServer getProxy() {
        return this.proxy;
    }

    public GsmsResponse post(Account account, MTPack pack) throws Exception {
        MTSupport.verifyPack(pack);
        return this.proxy.sendMessage(account, pack);
    }

    public AccountInfo getAccountInfo(Account account) throws Exception {
        return this.proxy.getAccountInfo(account);
    }

    public MOMsg[] getMOMsgs(Account account, int fetchSize) throws Exception {
        if (fetchSize <= 0) {
            return null;
        }
        return this.proxy.getMOMsgs(account, fetchSize);
    }

    public MTResponse[] getResps(Account account, int fetchSize) throws Exception {
        if (fetchSize <= 0) {
            return null;
        }
        return this.proxy.getResps(account, fetchSize, 3);
    }

    public MTResponse[] findResps(Account account, int pageIndex, UUID batchID, String phone, int method) throws Exception {
        if (pageIndex <= 0) {
            return null;
        }
        if (batchID == null && CommonUtil.isBlank(phone)) {
            throw new IllegalArgumentException("\u53c2\u6570\u65e0\u6548\uff08\u6279\u6b21ID\u548c\u624b\u673a\u53f7\u7801\u5176\u4e2d\u4e00\u9879\u4e0d\u80fd\u4e3a\u7a7a\uff09");
        }
        return this.proxy.findResps(account, pageIndex, batchID, phone, method != 1);
    }

    public TicketInfo findTickets(Account account, String phone, Date startTime, Date endTime, String userName, int pageIndex) throws Exception {
        if (pageIndex <= 0) {
            return null;
        }
        TicketInfo resp = this.proxy.findTickets(account, phone, startTime, endTime, userName, pageIndex);
        return resp;
    }

    public MTReport[] getReports(Account account, int fetchSize) throws Exception {
        if (fetchSize <= 0) {
            return null;
        }
        return this.proxy.getReports(account, fetchSize, 3);
    }

    public MTReport[] findReports(Account account, int pageIndex, UUID batchID, String phone, int method) throws Exception {
        if (pageIndex <= 0) {
            return null;
        }
        if (batchID == null && CommonUtil.isBlank(phone)) {
            throw new IllegalArgumentException("\u53c2\u6570\u65e0\u6548\uff08\u6279\u6b21ID\u548c\u624b\u673a\u53f7\u7801\u5176\u4e2d\u4e00\u9879\u4e0d\u80fd\u4e3a\u7a7a\uff09");
        }
        return this.proxy.findReports(account, pageIndex, batchID, phone, method != 1);
    }

    public int modifyPassword(Account account, String newPwd) throws Exception {
        if (CommonUtil.isBlank(newPwd)) {
            throw new IllegalArgumentException("\u53c2\u6570\u65e0\u6548(newPwd:\u53c2\u6570\u503c\u9519\u8bef,\u8981\u6c42\u4e3aString(50),\u4e14\u4e0d\u80fd\u4e3a\u7a7a)");
        }
        return this.proxy.modifyPassword(account, newPwd);
    }

    public BusinessType[] getBizTypes(Account account) throws Exception {
        return this.proxy.getBizTypes(account);
    }

    @Deprecated
    public PostMsg(String name, String password) {
        this(false);
        this.setUser(name, password);
    }

    @Deprecated
    public void setUser(String name, String password) {
        this.account = new Account(name, password);
    }

    @Deprecated
    public void getUser(StringBuilder name, StringBuilder password) {
        name.replace(0, name.length(), this.account.getName());
        password.replace(0, password.length(), this.account.getPassword());
    }

    @Deprecated
    public int getRemainFee() {
        try {
            AccountInfo acInfo = this.getAccountInfo(this.account);
            return acInfo == null ? 0 : (int)acInfo.getBalance();
        }
        catch (Exception e) {
            if (e instanceof ConnectException) {
                return -3;
            }
            throw new RuntimeException(e.getMessage());
        }
    }

    @Deprecated
    public MOMsg[] getMOMsg() throws ConnectException {
        try {
            return this.getMOMsgs(this.account, 100);
        }
        catch (Exception e) {
            if (e instanceof ConnectException) {
                throw new ConnectException(e.getMessage());
            }
            throw new RuntimeException(e.getMessage());
        }
    }

    @Deprecated
    public ConfigInfo getConfigInfo() throws ConnectException {
        try {
            ConfigInfo cInfo = new ConfigInfo(this.getAccountInfo(this.account));
            BusinessType[] bizTypes = this.getBizTypes(this.account);
            if (bizTypes != null) {
                HashSet<String> specNums = new HashSet<String>();
                for (BusinessType bizType : bizTypes) {
                    if (bizType.getBindChs() == null) continue;
                    for (BindChannel bindCh : bizType.getBindChs()) {
                        specNums.add(bindCh.getSpecNumber());
                    }
                }
                cInfo.setCanumber(specNums.toArray(new String[specNums.size()]));
            }
            return cInfo;
        }
        catch (Exception e) {
            if (e instanceof ConnectException) {
                throw new ConnectException(e.getMessage());
            }
            throw new RuntimeException(e.getMessage());
        }
    }

    @Deprecated
    public int modifyPassword(String newPwd) {
        try {
            return this.modifyPassword(this.account, newPwd);
        }
        catch (Exception e) {
            if (e instanceof ConnectException) {
                return -3;
            }
            throw new RuntimeException(e.getMessage());
        }
    }

    @Deprecated
    private int finalPost(Account account, MTPack pack) {
        GsmsResponse resp = null;
        pack.setBatchID(UUID.randomUUID());
        pack.setMsgType(MTPack.MsgType.SMS);
        try {
            resp = this.post(account, pack);
            return resp.getResult();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    @Deprecated
    public int post(String phone, String content, String subId) {
        MessageData msg = new MessageData(phone, content);
        MTPack pack = new MTPack();
        pack.setSendType(MTPack.SendType.MASS);
        pack.setCustomNum(subId);
        ArrayList<MessageData> msgs = new ArrayList<MessageData>();
        msgs.add(msg);
        pack.setMsgs(msgs);
        return this.finalPost(this.account, pack);
    }

    @Deprecated
    public int post(String[] phones, String content, String subId) {
        if (!CommonUtil.isValidArray(phones)) {
            return -5;
        }
        MTPack pack = new MTPack();
        pack.setSendType(MTPack.SendType.MASS);
        ArrayList<MessageData> msgs = new ArrayList<MessageData>();
        for (String phone : phones) {
            MessageData msg = new MessageData(phone, content);
            msgs.add(msg);
        }
        pack.setMsgs(msgs);
        pack.setCustomNum(subId);
        return this.finalPost(this.account, pack);
    }

    @Deprecated
    public int post(MessageData[] msgs, String subId) {
        if (!CommonUtil.isValidArray(msgs)) {
            return -5;
        }
        MTPack pack = new MTPack();
        pack.setSendType(MTPack.SendType.GROUP);
        pack.setCustomNum(subId);
        ArrayList<MessageData> msgList = new ArrayList<MessageData>();
        for (MessageData msg : msgs) {
            msgList.add(msg);
        }
        pack.setMsgs(msgList);
        return this.finalPost(this.account, pack);
    }
}

