/*
 * Decompiled with CFR 0.152.
 */
package com.fasc.open.api.client;

import com.fasc.open.api.bean.base.BaseRes;
import com.fasc.open.api.bean.req.corp.AddCorpReq;
import com.fasc.open.api.bean.req.corp.CorpUnbindReq;
import com.fasc.open.api.bean.req.corp.DeleteCorpReq;
import com.fasc.open.api.bean.req.corp.DisableCorpReq;
import com.fasc.open.api.bean.req.corp.EnableCorpReq;
import com.fasc.open.api.bean.req.corp.GetCorpAuthUrlReq;
import com.fasc.open.api.bean.req.corp.GetCorpIdentityInfoReq;
import com.fasc.open.api.bean.req.corp.GetCorpReq;
import com.fasc.open.api.bean.req.corp.UpdateCorpReq;
import com.fasc.open.api.bean.res.common.EUrlRes;
import com.fasc.open.api.bean.res.corp.AddOpenCorpRes;
import com.fasc.open.api.bean.res.corp.CorpIdentityInfoRes;
import com.fasc.open.api.bean.res.corp.CorpRes;
import com.fasc.open.api.client.OpenApiClient;
import com.fasc.open.api.exception.ApiException;

public class CorpClient {
    private OpenApiClient openApiClient;

    public CorpClient(OpenApiClient openApiClient) {
        this.openApiClient = openApiClient;
    }

    public BaseRes<AddOpenCorpRes> add(AddCorpReq req) throws ApiException {
        return this.openApiClient.invokeApi(req, "POST /corp/add", AddOpenCorpRes.class);
    }

    public BaseRes<Void> update(UpdateCorpReq req) throws ApiException {
        return this.openApiClient.invokeApi(req, "POST /corp/update", Void.class);
    }

    public BaseRes<Void> delete(DeleteCorpReq req) throws ApiException {
        return this.openApiClient.invokeApi(req, "POST /corp/delete", Void.class);
    }

    public BaseRes<Void> disable(DisableCorpReq req) throws ApiException {
        return this.openApiClient.invokeApi(req, "POST /corp/disable", Void.class);
    }

    public BaseRes<Void> enable(EnableCorpReq req) throws ApiException {
        return this.openApiClient.invokeApi(req, "POST /corp/enable", Void.class);
    }

    public BaseRes<EUrlRes> getAuthUrl(GetCorpAuthUrlReq req) throws ApiException {
        return this.openApiClient.invokeApi(req, "POST /corp/get-auth-url", EUrlRes.class);
    }

    public BaseRes<CorpRes> get(GetCorpReq req) throws ApiException {
        return this.openApiClient.invokeApi(req, "POST /corp/get", CorpRes.class);
    }

    public BaseRes<CorpIdentityInfoRes> getIdentityInfo(GetCorpIdentityInfoReq req) throws ApiException {
        return this.openApiClient.invokeApi(req, "POST /corp/get-identity-info", CorpIdentityInfoRes.class);
    }

    public BaseRes<Void> unbind(CorpUnbindReq req) throws ApiException {
        return this.openApiClient.invokeApi(req, "POST /corp/unbind", Void.class);
    }
}

