/*
 * Decompiled with CFR 0.152.
 */
package com.fasc.open.api.client;

import com.fasc.open.api.bean.base.BaseRes;
import com.fasc.open.api.bean.req.corpmanage.OpenCorpAuthUrlReq;
import com.fasc.open.api.client.OpenApiClient;
import com.fasc.open.api.enums.common.EuiEnvironmentEnum;
import com.fasc.open.api.utils.crypt.FddCryptUtil;
import java.util.HashMap;

public class EUIClient {
    private OpenApiClient openApiClient;

    public EUIClient(OpenApiClient openApiClient) {
        this.openApiClient = openApiClient;
    }

    public BaseRes<String> getOpenCorpAuthorizeUrl(OpenCorpAuthUrlReq req, EuiEnvironmentEnum environmentEnum) throws Exception {
        String url = "/authorize/list?";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("appId", this.openApiClient.getAppId().toUpperCase());
        params.put("openCorpId", req.getOpenCorpId());
        params.put("corpName", req.getCorpName());
        params.put("redirectUrl", req.getRedirectUrl());
        params.put("authScopes", req.getAuthScopes());
        String timestamp = String.valueOf(System.currentTimeMillis());
        String sortParam = FddCryptUtil.sortParameters(params);
        String signature = FddCryptUtil.sign(sortParam, timestamp, this.openApiClient.getAppSecret());
        params.put("timestamp", timestamp);
        params.put("signature", signature);
        sortParam = FddCryptUtil.sortParameters(params);
        String resultUrl = String.format(environmentEnum.getValueInFact(), this.openApiClient.getAppId()).concat(url).concat(sortParam);
        BaseRes<String> baseRes = new BaseRes<String>();
        baseRes.setData(resultUrl);
        baseRes.setCode("100000");
        baseRes.setHttpStatusCode(200);
        return baseRes;
    }
}

