/*
 * Decompiled with CFR 0.152.
 */
package com.fasc.open.api.client;

import com.fasc.open.api.bean.base.BaseRes;
import com.fasc.open.api.bean.base.BaseResponseEntity;
import com.fasc.open.api.bean.req.signtask.AddActorsReq;
import com.fasc.open.api.bean.req.signtask.AddAttachReq;
import com.fasc.open.api.bean.req.signtask.AddDocReq;
import com.fasc.open.api.bean.req.signtask.AddFieldReq;
import com.fasc.open.api.bean.req.signtask.BlockReq;
import com.fasc.open.api.bean.req.signtask.CreateSignTaskReq;
import com.fasc.open.api.bean.req.signtask.CreateWithTemplateReq;
import com.fasc.open.api.bean.req.signtask.DeleteActorReq;
import com.fasc.open.api.bean.req.signtask.DeleteAttachReq;
import com.fasc.open.api.bean.req.signtask.DeleteDocReq;
import com.fasc.open.api.bean.req.signtask.DeleteFieldReq;
import com.fasc.open.api.bean.req.signtask.DownloadFilesReq;
import com.fasc.open.api.bean.req.signtask.FillFieldValuesReq;
import com.fasc.open.api.bean.req.signtask.GetFieldUrlReq;
import com.fasc.open.api.bean.req.signtask.GetUrlReq;
import com.fasc.open.api.bean.req.signtask.SignTaskBaseReq;
import com.fasc.open.api.bean.req.signtask.UnblockReq;
import com.fasc.open.api.bean.res.common.UrlRes;
import com.fasc.open.api.bean.res.signtask.CreateSignTaskRes;
import com.fasc.open.api.bean.res.signtask.SignTaskDetailRes;
import com.fasc.open.api.client.OpenApiClient;
import com.fasc.open.api.exception.ApiException;

public class SignTaskClient {
    private OpenApiClient openApiClient;

    public SignTaskClient(OpenApiClient openApiClient) {
        this.openApiClient = openApiClient;
    }

    public BaseRes<CreateSignTaskRes> create(CreateSignTaskReq req) throws ApiException {
        return this.openApiClient.invokeApi(req, "POST /sign-task/create", CreateSignTaskRes.class);
    }

    public BaseRes<CreateSignTaskRes> createWithTemplate(CreateWithTemplateReq req) throws ApiException {
        return this.openApiClient.invokeApi(req, "POST /sign-task/create-with-template", CreateSignTaskRes.class);
    }

    public BaseRes<Void> addDoc(AddDocReq req) throws ApiException {
        return this.openApiClient.invokeApi(req, "POST /sign-task/doc/add", Void.class);
    }

    public BaseRes<Void> deleteDoc(DeleteDocReq req) throws ApiException {
        return this.openApiClient.invokeApi(req, "POST /sign-task/doc/delete", Void.class);
    }

    public BaseRes<Void> addField(AddFieldReq req) throws ApiException {
        return this.openApiClient.invokeApi(req, "POST /sign-task/field/add", Void.class);
    }

    public BaseRes<Void> deleteField(DeleteFieldReq req) throws ApiException {
        return this.openApiClient.invokeApi(req, "POST /sign-task/field/delete", Void.class);
    }

    public BaseRes<UrlRes> getFieldUrl(GetFieldUrlReq req) throws ApiException {
        return this.openApiClient.invokeApi(req, "POST /sign-task/field/get-url", UrlRes.class);
    }

    public BaseRes<Void> fillFieldValues(FillFieldValuesReq req) throws ApiException {
        return this.openApiClient.invokeApi(req, "POST /sign-task/field/fill-values", Void.class);
    }

    public BaseRes<Void> addAttach(AddAttachReq req) throws ApiException {
        return this.openApiClient.invokeApi(req, "POST /sign-task/attach/add", Void.class);
    }

    public BaseRes<Void> deleteAttach(DeleteAttachReq req) throws ApiException {
        return this.openApiClient.invokeApi(req, "POST /sign-task/attach/delete", Void.class);
    }

    public BaseRes<Void> addActor(AddActorsReq req) throws ApiException {
        return this.openApiClient.invokeApi(req, "POST /sign-task/actor/add", Void.class);
    }

    public BaseRes<Void> deleteActor(DeleteActorReq req) throws ApiException {
        return this.openApiClient.invokeApi(req, "POST /sign-task/actor/delete", Void.class);
    }

    public BaseRes<Void> initiate(SignTaskBaseReq req) throws ApiException {
        return this.openApiClient.invokeApi(req, "POST /sign-task/initiate", Void.class);
    }

    public BaseRes<Void> cancel(SignTaskBaseReq req) throws ApiException {
        return this.openApiClient.invokeApi(req, "POST /sign-task/cancel", Void.class);
    }

    public BaseRes<Void> finalizeDoc(SignTaskBaseReq req) throws ApiException {
        return this.openApiClient.invokeApi(req, "POST /sign-task/doc/finalize", Void.class);
    }

    public BaseRes<Void> block(BlockReq req) throws ApiException {
        return this.openApiClient.invokeApi(req, "POST /sign-task/block", Void.class);
    }

    public BaseRes<Void> unblock(UnblockReq req) throws ApiException {
        return this.openApiClient.invokeApi(req, "POST /sign-task/unblock", Void.class);
    }

    public BaseRes<Void> urge(SignTaskBaseReq req) throws ApiException {
        return this.openApiClient.invokeApi(req, "POST /sign-task/urge-sign", Void.class);
    }

    public BaseRes<Void> finish(SignTaskBaseReq req) throws ApiException {
        return this.openApiClient.invokeApi(req, "POST /sign-task/finish", Void.class);
    }

    public BaseRes<SignTaskDetailRes> getDetail(SignTaskBaseReq req) throws ApiException {
        return this.openApiClient.invokeApi(req, "POST /sign-task/get-detail", SignTaskDetailRes.class);
    }

    public BaseRes<BaseResponseEntity> downloadFiles(DownloadFilesReq req) throws ApiException {
        return this.openApiClient.invokeApiDownload(req, "POST /sign-task/download-files");
    }

    public BaseRes<UrlRes> getUrl(GetUrlReq req) throws ApiException {
        return this.openApiClient.invokeApi(req, "POST /sign-task/get-url", UrlRes.class);
    }
}

