/*
 * Decompiled with CFR 0.152.
 */
package com.fasc.open.api.client;

import com.fasc.open.api.bean.base.BaseRes;
import com.fasc.open.api.bean.req.user.AddUserReq;
import com.fasc.open.api.bean.req.user.DeleteUserReq;
import com.fasc.open.api.bean.req.user.DisableUserReq;
import com.fasc.open.api.bean.req.user.EnableUserReq;
import com.fasc.open.api.bean.req.user.GetUserAuthUrlReq;
import com.fasc.open.api.bean.req.user.GetUserIdentityInfoReq;
import com.fasc.open.api.bean.req.user.GetUserReq;
import com.fasc.open.api.bean.req.user.UpdateUserReq;
import com.fasc.open.api.bean.req.user.UserUnbindReq;
import com.fasc.open.api.bean.res.common.EUrlRes;
import com.fasc.open.api.bean.res.user.AddOpenUserRes;
import com.fasc.open.api.bean.res.user.UserIdentityInfoRes;
import com.fasc.open.api.bean.res.user.UserRes;
import com.fasc.open.api.client.OpenApiClient;
import com.fasc.open.api.exception.ApiException;

public class UserClient {
    private OpenApiClient openApiClient;

    public UserClient(OpenApiClient openApiClient) {
        this.openApiClient = openApiClient;
    }

    public BaseRes<AddOpenUserRes> add(AddUserReq req) throws ApiException {
        return this.openApiClient.invokeApi(req, "POST /user/add", AddOpenUserRes.class);
    }

    public BaseRes<Void> update(UpdateUserReq req) throws ApiException {
        return this.openApiClient.invokeApi(req, "POST /user/update", Void.class);
    }

    public BaseRes<Void> delete(DeleteUserReq req) throws ApiException {
        return this.openApiClient.invokeApi(req, "POST /user/delete", Void.class);
    }

    public BaseRes<Void> disable(DisableUserReq req) throws ApiException {
        return this.openApiClient.invokeApi(req, "POST /user/disable", Void.class);
    }

    public BaseRes<Void> enable(EnableUserReq req) throws ApiException {
        return this.openApiClient.invokeApi(req, "POST /user/enable", Void.class);
    }

    public BaseRes<EUrlRes> getAuthUrl(GetUserAuthUrlReq req) throws ApiException {
        return this.openApiClient.invokeApi(req, "POST /user/get-auth-url", EUrlRes.class);
    }

    public BaseRes<UserRes> get(GetUserReq req) throws ApiException {
        return this.openApiClient.invokeApi(req, "POST /user/get", UserRes.class);
    }

    public BaseRes<UserIdentityInfoRes> getIdentityInfo(GetUserIdentityInfoReq req) throws ApiException {
        return this.openApiClient.invokeApi(req, "POST /user/get-identity-info", UserIdentityInfoRes.class);
    }

    public BaseRes<Void> unbind(UserUnbindReq req) throws ApiException {
        return this.openApiClient.invokeApi(req, "POST /user/unbind", Void.class);
    }
}

