/*
 * Decompiled with CFR 0.152.
 */
package com.fasc.open.api.utils.http;

import com.fasc.open.api.bean.base.BaseResponseEntity;
import com.fasc.open.api.bean.base.HttpInfoRes;
import com.fasc.open.api.config.HttpConfig;
import com.fasc.open.api.exception.ApiException;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.net.ssl.SSLContext;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtil {
    private static Logger log = LoggerFactory.getLogger(HttpUtil.class);
    private static int DEFAULT_MAX_PER_ROUTE = 350;
    private static int DEFAULT_SOCKET_MAX_TOTAL = 400;
    public static HttpConfig httpConfig;
    private static volatile CloseableHttpClient closeableHttpClient;
    private static Lock lock;

    private HttpUtil() {
    }

    private static HttpGet getHttpGet(String url, Map<String, String> params, String encode) {
        StringBuilder buf = new StringBuilder(url);
        if (params != null) {
            String flag = url.indexOf(63) == -1 ? "?" : "&";
            for (Map.Entry<String, String> entry : params.entrySet()) {
                buf.append(flag);
                buf.append(entry.getKey());
                buf.append("=");
                try {
                    String param = entry.getValue();
                    if (param == null) {
                        param = "";
                    }
                    buf.append(URLEncoder.encode(param, encode));
                }
                catch (UnsupportedEncodingException e) {
                    log.error("URLEncoder Error,encode=" + encode + ",param=" + entry.getValue(), (Throwable)e);
                }
                flag = "&";
            }
        }
        return new HttpGet(buf.toString());
    }

    private static HttpPost getHttpPost(String url, Map<String, String> params, Map<String, File> files) {
        HttpPost httpPost = new HttpPost(url);
        MultipartEntityBuilder multipartEntityBuilder = MultipartEntityBuilder.create();
        if (files != null && !files.isEmpty()) {
            for (Map.Entry<String, Object> entry : files.entrySet()) {
                multipartEntityBuilder.addBinaryBody(entry.getKey(), (File)entry.getValue());
            }
        }
        if (params != null && !params.isEmpty()) {
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                String key = entry.getKey();
                String value = (String)entry.getValue();
                multipartEntityBuilder.addTextBody(key, value, ContentType.TEXT_PLAIN.withCharset("UTF-8"));
            }
            multipartEntityBuilder.setMode(HttpMultipartMode.RFC6532);
        }
        HttpEntity httpEntity = multipartEntityBuilder.build();
        httpPost.setEntity(httpEntity);
        return httpPost;
    }

    private static HttpPost getHttpPost(String url, Map<String, String> params, String charset) throws UnsupportedEncodingException {
        HttpPost httpPost = new HttpPost(url);
        if (params != null && !params.isEmpty()) {
            ArrayList<BasicNameValuePair> list = new ArrayList<BasicNameValuePair>();
            for (Map.Entry<String, String> entry : params.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                BasicNameValuePair basicNameValuePair = new BasicNameValuePair(key, value);
                list.add(basicNameValuePair);
            }
            UrlEncodedFormEntity httpEntity = new UrlEncodedFormEntity(list, charset);
            httpPost.setEntity((HttpEntity)httpEntity);
        }
        return httpPost;
    }

    public static HttpInfoRes post(String url, Map<String, String> reqHeader, Map<String, String> params, Map<String, File> files) throws ApiException {
        try {
            CloseableHttpClient httpClient = HttpUtil.getHttpClient(httpConfig);
            HttpPost httpPost = files == null || files.isEmpty() ? HttpUtil.getHttpPost(url, params, "UTF-8") : HttpUtil.getHttpPost(url, params, files);
            httpPost.setConfig(HttpUtil.getRequestConfig(httpConfig));
            return HttpUtil.executeHttpRequest(httpClient, (HttpUriRequest)httpPost, reqHeader);
        }
        catch (ApiException e) {
            throw e;
        }
        catch (Exception e) {
            log.error("url=[{}] http\u8bf7\u6c42\u5931\u8d25\uff1a{}", new Object[]{url, e.getMessage(), e});
            throw new ApiException("\u8bf7\u6c42\u5931\u8d25");
        }
    }

    public static CloseableHttpClient getHttpClient(HttpConfig httpConfig) throws ApiException {
        if (closeableHttpClient != null) {
            return closeableHttpClient;
        }
        try {
            lock.lock();
            if (closeableHttpClient != null) {
                CloseableHttpClient closeableHttpClient = HttpUtil.closeableHttpClient;
                return closeableHttpClient;
            }
            Registry sfr = null;
            if (httpConfig != null && Boolean.TRUE.equals(httpConfig.getProxyFlag())) {
                sfr = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)SSLConnectionSocketFactory.getSocketFactory()).build();
            } else {
                SSLContext ctx = SSLContexts.custom().setProtocol("TLSv1.2").build();
                SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(ctx);
                sfr = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)(sslsf != null ? sslsf : SSLConnectionSocketFactory.getSocketFactory())).build();
            }
            PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager(sfr);
            Integer defaultMaxPerRoute = DEFAULT_MAX_PER_ROUTE;
            Integer defaultSocketMaxTotal = DEFAULT_SOCKET_MAX_TOTAL;
            if (httpConfig != null && httpConfig.getDefaultMaxPerRoute() != null && httpConfig.getDefaultMaxPerRoute() > 0) {
                defaultMaxPerRoute = httpConfig.getDefaultMaxPerRoute();
            }
            if (httpConfig != null && httpConfig.getDefaultSocketMaxTotal() != null && httpConfig.getDefaultSocketMaxTotal() > 0) {
                defaultSocketMaxTotal = httpConfig.getDefaultSocketMaxTotal();
            }
            connectionManager.setDefaultMaxPerRoute(defaultMaxPerRoute.intValue());
            connectionManager.setMaxTotal(defaultSocketMaxTotal.intValue());
            connectionManager.setValidateAfterInactivity(3000);
            connectionManager.closeExpiredConnections();
            closeableHttpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connectionManager).build();
        }
        catch (Exception e) {
            log.error("HttpClient\u751f\u6210\u5931\u8d25\uff1a{}", (Object)e.getMessage(), (Object)e);
            throw new ApiException("HttpClient\u751f\u6210\u5931\u8d25");
        }
        finally {
            lock.unlock();
        }
        return closeableHttpClient;
    }

    public static HttpInfoRes get(String url, Map<String, String> reqHeader, Map<String, String> params) throws ApiException {
        CloseableHttpClient httpClient = HttpUtil.getHttpClient(httpConfig);
        HttpGet httpGet = HttpUtil.getHttpGet(url, params, "UTF-8");
        httpGet.setConfig(HttpUtil.getRequestConfig(httpConfig));
        return HttpUtil.executeHttpRequest(httpClient, (HttpUriRequest)httpGet, reqHeader);
    }

    public static HttpInfoRes executeHttpRequest(CloseableHttpClient client, HttpUriRequest request, Map<String, String> reqHeader) throws ApiException {
        CloseableHttpResponse response = null;
        try {
            if (reqHeader != null && !reqHeader.isEmpty()) {
                for (Map.Entry<String, String> entry : reqHeader.entrySet()) {
                    request.addHeader(entry.getKey(), entry.getValue());
                }
            }
            response = client.execute(request);
            HttpUtil.reqesutAndResponseLog(request, (HttpResponse)response);
            HttpInfoRes httpInfoRes = HttpInfoRes.getInstance();
            if (response.getEntity() != null) {
                httpInfoRes.setBody(EntityUtils.toString((HttpEntity)response.getEntity()));
            }
            httpInfoRes.setHttpStatusCode(response.getStatusLine().getStatusCode());
            HttpInfoRes httpInfoRes2 = httpInfoRes;
            return httpInfoRes2;
        }
        catch (SocketTimeoutException eto) {
            log.error("\u8bf7\u6c42\u94fe\u63a5\u8d85\u65f6\uff1a{}", (Object)eto.getMessage(), (Object)eto);
            throw new ApiException("\u8bf7\u6c42\u8d85\u65f6");
        }
        catch (Exception e) {
            log.error("executeHttpRequest\u8bf7\u6c42\u5931\u8d25\uff1a{}", (Object)e.getMessage(), (Object)e);
            throw new ApiException("\u8bf7\u6c42\u5931\u8d25");
        }
        finally {
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException e) {
                    log.error("CloseableHttpResponse\u5173\u95ed\u5931\u8d25\uff1a{}", (Object)e.getMessage(), (Object)e);
                }
            }
        }
    }

    public static BaseResponseEntity downLoadFiles(String url, Map<String, String> reqHeader, Map<String, String> params) throws ApiException {
        BaseResponseEntity entity = new BaseResponseEntity();
        CloseableHttpResponse response = null;
        CloseableHttpClient httpClient = HttpUtil.getHttpClient(httpConfig);
        try {
            HttpPost httpPost = HttpUtil.getHttpPost(url, params, "UTF-8");
            if (reqHeader != null) {
                for (Map.Entry<String, String> entry : reqHeader.entrySet()) {
                    httpPost.addHeader(entry.getKey(), entry.getValue());
                }
            }
            httpPost.setConfig(HttpUtil.getRequestConfig(httpConfig));
            response = httpClient.execute((HttpUriRequest)httpPost);
            HttpUtil.reqesutAndResponseLog((HttpUriRequest)httpPost, (HttpResponse)response);
            entity.setHttpStatusCode(response.getStatusLine().getStatusCode());
            HttpEntity respEntity = response.getEntity();
            Header contentType = respEntity.getContentType();
            if (contentType.getValue().contains(ContentType.APPLICATION_JSON.getMimeType())) {
                entity.setData(EntityUtils.toString((HttpEntity)respEntity));
            } else {
                byte[] bytes = EntityUtils.toByteArray((HttpEntity)response.getEntity());
                entity.setContent(bytes);
                entity.setContentType(contentType.getValue());
            }
        }
        catch (Exception e) {
            log.error("\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25\uff1a{}", (Object)e.getMessage(), (Object)e);
            throw new ApiException("\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25");
        }
        finally {
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException e) {
                    log.error("CloseableHttpResponse\u5173\u95ed\u5931\u8d25\uff1a{}", (Object)e.getMessage(), (Object)e);
                }
            }
        }
        return entity;
    }

    private static void reqesutAndResponseLog(HttpUriRequest request, HttpResponse response) {
        Header[] responseHeaders;
        Header[] requestHeaders;
        URI uri = request.getURI();
        if (uri != null) {
            log.info("request url = [{}]", (Object)uri.toString());
        }
        if ((requestHeaders = request.getHeaders("X-FASC-Nonce")) != null && requestHeaders.length > 0) {
            log.info("request header {}= [{}]", (Object)"X-FASC-Nonce", (Object)requestHeaders[0].getValue());
        }
        if ((responseHeaders = response.getHeaders("X-FASC-Request-Id")) != null && responseHeaders.length > 0) {
            log.info("response header {}= [{}]", (Object)"X-FASC-Request-Id", (Object)responseHeaders[0].getValue());
        }
    }

    private static RequestConfig getRequestConfig(HttpConfig httpConfig) {
        RequestConfig.Builder custom = RequestConfig.custom();
        if (httpConfig != null) {
            if (httpConfig.getReadTimeout() != null) {
                custom.setSocketTimeout(httpConfig.getReadTimeout().intValue());
            }
            if (httpConfig.getConnectTimeout() != null) {
                custom.setConnectTimeout(httpConfig.getConnectTimeout().intValue());
            }
            if (Boolean.TRUE.equals(httpConfig.getProxyFlag())) {
                HttpHost proxy = new HttpHost(httpConfig.getProxyHost(), httpConfig.getProxyPort().intValue(), "http");
                custom.setProxy(proxy);
            }
        }
        return custom.build();
    }

    static {
        lock = new ReentrantLock();
    }
}

