/*
 * Decompiled with CFR 0.152.
 */
package com.fasc.open.api.v5_1.client;

import com.fasc.open.api.bean.base.BaseRes;
import com.fasc.open.api.exception.ApiException;
import com.fasc.open.api.v5_1.client.OpenApiClient;
import com.fasc.open.api.v5_1.req.corp.GetCorpAuthResourceUrlReq;
import com.fasc.open.api.v5_1.req.eui.GetAppPageResourceUrlReq;
import com.fasc.open.api.v5_1.req.eui.GetBillUrlReq;
import com.fasc.open.api.v5_1.req.eui.GetUserPageResourceUrlReq;
import com.fasc.open.api.v5_1.req.user.GetUserAuthUrlReq;
import com.fasc.open.api.v5_1.res.common.ECorpAuthUrlRes;
import com.fasc.open.api.v5_1.res.common.EUrlRes;
import com.fasc.open.api.v5_1.res.eui.GetPageResourceUrlRes;

public class EUIClient {
    private OpenApiClient openApiClient;

    public EUIClient(OpenApiClient openApiClient) {
        this.openApiClient = openApiClient;
    }

    public BaseRes<EUrlRes> getUserAuthUrl(GetUserAuthUrlReq req) throws ApiException {
        return this.openApiClient.invokeApi(req, "POST /user/get-auth-url", EUrlRes.class);
    }

    public BaseRes<ECorpAuthUrlRes> getCorpAuthUrl(GetCorpAuthResourceUrlReq req) throws ApiException {
        return this.openApiClient.invokeApi(req, "POST /corp/get-auth-url", ECorpAuthUrlRes.class);
    }

    public BaseRes<EUrlRes> getBillUrl(GetBillUrlReq req) throws ApiException {
        return this.openApiClient.invokeApi(req, "POST /billing/get-bill-url", EUrlRes.class);
    }

    public BaseRes<GetPageResourceUrlRes> getAppPageResourceUrl(GetAppPageResourceUrlReq req) throws ApiException {
        return this.openApiClient.invokeApi(req, "POST /app-page-resource/get-url", GetPageResourceUrlRes.class);
    }

    public BaseRes<GetPageResourceUrlRes> getUserPageResourceUrl(GetUserPageResourceUrlReq req) throws ApiException {
        return this.openApiClient.invokeApi(req, "POST /user-page-resource/get-url", GetPageResourceUrlRes.class);
    }
}

