/*
 * Decompiled with CFR 0.152.
 */
package com.fasc.open.api.v5_1.client;

import com.fasc.open.api.bean.base.BaseRes;
import com.fasc.open.api.exception.ApiException;
import com.fasc.open.api.v5_1.client.OpenApiClient;
import com.fasc.open.api.v5_1.req.signtask.AddActorsReq;
import com.fasc.open.api.v5_1.req.signtask.AddAttachReq;
import com.fasc.open.api.v5_1.req.signtask.AddDocReq;
import com.fasc.open.api.v5_1.req.signtask.AddFieldReq;
import com.fasc.open.api.v5_1.req.signtask.BlockReq;
import com.fasc.open.api.v5_1.req.signtask.CreateSignTaskReq;
import com.fasc.open.api.v5_1.req.signtask.CreateWithTemplateReq;
import com.fasc.open.api.v5_1.req.signtask.DeleteActorReq;
import com.fasc.open.api.v5_1.req.signtask.DeleteAttachReq;
import com.fasc.open.api.v5_1.req.signtask.DeleteDocReq;
import com.fasc.open.api.v5_1.req.signtask.DeleteFieldReq;
import com.fasc.open.api.v5_1.req.signtask.FillFieldValuesReq;
import com.fasc.open.api.v5_1.req.signtask.GetOwnerDownloadUrlReq;
import com.fasc.open.api.v5_1.req.signtask.GetOwnerSignTaskListReq;
import com.fasc.open.api.v5_1.req.signtask.SignTaskBaseReq;
import com.fasc.open.api.v5_1.req.signtask.UnblockReq;
import com.fasc.open.api.v5_1.res.signtask.CreateSignTaskRes;
import com.fasc.open.api.v5_1.res.signtask.GetSignTaskListRes;
import com.fasc.open.api.v5_1.res.signtask.OwnerDownloadUrlRes;
import com.fasc.open.api.v5_1.res.signtask.SignTaskDetailRes;

public class SignTaskClient {
    private OpenApiClient openApiClient;

    public SignTaskClient(OpenApiClient openApiClient) {
        this.openApiClient = openApiClient;
    }

    public BaseRes<CreateSignTaskRes> create(CreateSignTaskReq req) throws ApiException {
        return this.openApiClient.invokeApi(req, "POST /sign-task/create", CreateSignTaskRes.class);
    }

    public BaseRes<CreateSignTaskRes> createWithTemplate(CreateWithTemplateReq req) throws ApiException {
        return this.openApiClient.invokeApi(req, "POST /sign-task/create-with-template", CreateSignTaskRes.class);
    }

    public BaseRes<Void> addDoc(AddDocReq req) throws ApiException {
        return this.openApiClient.invokeApi(req, "POST /sign-task/doc/add", Void.class);
    }

    public BaseRes<Void> deleteDoc(DeleteDocReq req) throws ApiException {
        return this.openApiClient.invokeApi(req, "POST /sign-task/doc/delete", Void.class);
    }

    public BaseRes<Void> addField(AddFieldReq req) throws ApiException {
        return this.openApiClient.invokeApi(req, "POST /sign-task/field/add", Void.class);
    }

    public BaseRes<Void> deleteField(DeleteFieldReq req) throws ApiException {
        return this.openApiClient.invokeApi(req, "POST /sign-task/field/delete", Void.class);
    }

    public BaseRes<Void> addAttach(AddAttachReq req) throws ApiException {
        return this.openApiClient.invokeApi(req, "POST /sign-task/attach/add", Void.class);
    }

    public BaseRes<Void> deleteAttach(DeleteAttachReq req) throws ApiException {
        return this.openApiClient.invokeApi(req, "POST /sign-task/attach/delete", Void.class);
    }

    public BaseRes<Void> addActor(AddActorsReq req) throws ApiException {
        return this.openApiClient.invokeApi(req, "POST /sign-task/actor/add", Void.class);
    }

    public BaseRes<Void> deleteActor(DeleteActorReq req) throws ApiException {
        return this.openApiClient.invokeApi(req, "POST /sign-task/actor/delete", Void.class);
    }

    public BaseRes<Void> start(SignTaskBaseReq req) throws ApiException {
        return this.openApiClient.invokeApi(req, "POST /sign-task/start", Void.class);
    }

    public BaseRes<Void> fillFieldValues(FillFieldValuesReq req) throws ApiException {
        return this.openApiClient.invokeApi(req, "POST /sign-task/field/fill-values", Void.class);
    }

    public BaseRes<Void> finalizeDoc(SignTaskBaseReq req) throws ApiException {
        return this.openApiClient.invokeApi(req, "POST /sign-task/doc-finalize", Void.class);
    }

    public BaseRes<Void> block(BlockReq req) throws ApiException {
        return this.openApiClient.invokeApi(req, "POST /sign-task/block", Void.class);
    }

    public BaseRes<Void> unblock(UnblockReq req) throws ApiException {
        return this.openApiClient.invokeApi(req, "POST /sign-task/unblock", Void.class);
    }

    public BaseRes<Void> cancel(SignTaskBaseReq req) throws ApiException {
        return this.openApiClient.invokeApi(req, "POST /sign-task/cancel", Void.class);
    }

    public BaseRes<SignTaskDetailRes> getDetail(SignTaskBaseReq req) throws ApiException {
        return this.openApiClient.invokeApi(req, "POST /sign-task/app/get-detail", SignTaskDetailRes.class);
    }

    public BaseRes<GetSignTaskListRes> getOwnerList(GetOwnerSignTaskListReq req) throws ApiException {
        return this.openApiClient.invokeApi(req, "POST /sign-task/owner/get-list", GetSignTaskListRes.class);
    }

    public BaseRes<OwnerDownloadUrlRes> getOwnerDownloadUrl(GetOwnerDownloadUrlReq req) throws ApiException {
        return this.openApiClient.invokeApi(req, "POST /sign-task/owner/get-download-url", OwnerDownloadUrlRes.class);
    }
}

