/*
 * Decompiled with CFR 0.152.
 */
package com.umpay.util;

import com.umpay.dto.UMFResponse;
import com.umpay.generic.TypeResult;
import com.umpay.http.UMFHttpClient;
import com.umpay.mer.ConfigContext;
import com.umpay.util.BeanUtil;
import com.umpay.util.RSAUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.http.Header;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UMFUtil {
    private static final Logger log = LoggerFactory.getLogger(UMFUtil.class);

    public static void redirectPost(ConfigContext apicontext, Map<String, Object> reqMap, HttpServletResponse response) throws Exception {
        Map<String, Object> resMap = UMFHttpClient.post(apicontext, reqMap);
        UMFUtil.checkHttpCode(resMap, 302);
        String url = (String)resMap.get("data");
        response.sendRedirect(url);
    }

    public static <R> String getRedirectUrlPost(ConfigContext apicontext, R req) throws Exception {
        Map<String, Object> resMap = UMFHttpClient.post(apicontext, req);
        UMFUtil.checkHttpCode(resMap, 302);
        return (String)resMap.get("data");
    }

    public static void redirectGet(ConfigContext apicontext, Map<String, String> reqMap, HttpServletResponse response) throws Exception {
        Map<String, Object> resMap = UMFHttpClient.get(apicontext, reqMap);
        UMFUtil.checkHttpCode(resMap, 302);
        String url = (String)resMap.get("data");
        response.sendRedirect(url);
    }

    public static <V> UMFResponse.Message<V> get(ConfigContext apicontext, Map<String, String> reqMap, Class<V> clazz) throws Exception {
        Map<String, Object> resMap = UMFHttpClient.get(apicontext, reqMap);
        UMFUtil.checkHttpCode(resMap, 200);
        String data = (String)resMap.get("data");
        if (data == null || data == "") {
            return null;
        }
        Header[] headers = (Header[])resMap.get("header");
        String sign = "";
        Header[] headerArray = headers;
        int n = headers.length;
        int n2 = 0;
        while (n2 < n) {
            Header header = headerArray[n2];
            if (header.getName().equals("Signature")) {
                sign = header.getValue();
            }
            ++n2;
        }
        log.info(String.format("\u54cd\u5e94\u62a5\u6587[%s][sign=%s]", data, sign));
        if (!RSAUtil.verifySign(data, sign, null)) {
            throw new Exception("\u5546\u6237\u9a8c\u7b7e\u5931\u8d25");
        }
        TypeResult typeResult = new TypeResult<UMFResponse.Message<V>>(){};
        Object result = typeResult.getResult(data, clazz);
        return result;
    }

    public static <R, V> UMFResponse.Message<V> get(ConfigContext apicontext, R req, Class<V> clazz) throws Exception {
        Map<String, String> reqMap = BeanUtil.obj2Map(req);
        Map<String, Object> resMap = UMFHttpClient.get(apicontext, reqMap);
        UMFUtil.checkHttpCode(resMap, 200);
        String data = (String)resMap.get("data");
        if (data == null || data == "") {
            return null;
        }
        Header[] headers = (Header[])resMap.get("header");
        String sign = "";
        Header[] headerArray = headers;
        int n = headers.length;
        int n2 = 0;
        while (n2 < n) {
            Header header = headerArray[n2];
            if (header.getName().equals("Signature")) {
                sign = header.getValue();
            }
            ++n2;
        }
        log.info(String.format("\u54cd\u5e94\u62a5\u6587[%s][sign=%s]", data, sign));
        if (!RSAUtil.verifySign(data, sign, null)) {
            throw new Exception("\u5546\u6237\u9a8c\u7b7e\u5931\u8d25");
        }
        TypeResult typeResult = new TypeResult<UMFResponse.Message<V>>(){};
        Object result = typeResult.getResult(data, clazz);
        return result;
    }

    public static <V> UMFResponse.Message<V> post(ConfigContext apicontext, Map<String, Object> reqMap, Class<V> clazz) throws Exception {
        Map<String, Object> resMap = UMFHttpClient.post(apicontext, reqMap);
        UMFUtil.checkHttpCode(resMap, 200);
        String data = (String)resMap.get("data");
        log.info(String.format("\u54cd\u5e94\u62a5\u6587[%s]", data));
        if (data == null || data == "") {
            return null;
        }
        Header[] headers = (Header[])resMap.get("header");
        String sign = "";
        Header[] headerArray = headers;
        int n = headers.length;
        int n2 = 0;
        while (n2 < n) {
            Header header = headerArray[n2];
            if (header.getName().equals("Signature")) {
                sign = header.getValue();
            }
            ++n2;
        }
        if (!RSAUtil.verifySign(data, sign, null)) {
            throw new Exception("\u5546\u6237\u9a8c\u7b7e\u5931\u8d25");
        }
        TypeResult typeResult = new TypeResult<UMFResponse.Message<V>>(){};
        Object result = typeResult.getResult(data, clazz);
        return result;
    }

    public static <R, V> UMFResponse.Message<V> post(ConfigContext apicontext, R req, Class<V> clazz) throws Exception {
        Map<String, Object> resMap = UMFHttpClient.post(apicontext, req);
        UMFUtil.checkHttpCode(resMap, 200);
        String data = (String)resMap.get("data");
        log.info(String.format("\u54cd\u5e94\u62a5\u6587[%s]", data));
        if (data == null || data == "") {
            return null;
        }
        Header[] headers = (Header[])resMap.get("header");
        String sign = "";
        Header[] headerArray = headers;
        int n = headers.length;
        int n2 = 0;
        while (n2 < n) {
            Header header = headerArray[n2];
            if (header.getName().equals("Signature")) {
                sign = header.getValue();
            }
            ++n2;
        }
        if (!RSAUtil.verifySign(data, sign, null)) {
            throw new Exception("\u5546\u6237\u9a8c\u7b7e\u5931\u8d25");
        }
        TypeResult typeResult = new TypeResult<UMFResponse.Message<V>>(){};
        Object result = typeResult.getResult(data, clazz);
        return result;
    }

    public static <R, V> UMFResponse.Message<V> post(String url, R req, Class<V> clazz) throws Exception {
        Map<String, Object> resMap = UMFHttpClient.post(url, req, null);
        UMFUtil.checkHttpCode(resMap, 200);
        String data = (String)resMap.get("data");
        log.info(String.format("\u54cd\u5e94\u62a5\u6587[%s]", data));
        if (data == null || data == "") {
            return null;
        }
        TypeResult typeResult = new TypeResult<UMFResponse.Message<V>>(){};
        Object result = typeResult.getResult(data, clazz);
        return result;
    }

    public static <R> String post(String url, R req) throws Exception {
        Map<String, Object> resMap = UMFHttpClient.post(url, req, null);
        UMFUtil.checkHttpCode(resMap, 200);
        String data = (String)resMap.get("data");
        log.info(String.format("\u54cd\u5e94\u62a5\u6587[%s]", data));
        if (data == null || data == "") {
            return null;
        }
        return data;
    }

    public static <V> UMFResponse.Message<V> get(String url, Map<String, String> reqMap, Class<V> clazz) throws Exception {
        Map<String, Object> resMap = UMFHttpClient.get(url, null, reqMap);
        UMFUtil.checkHttpCode(resMap, 200);
        String data = (String)resMap.get("data");
        log.info(String.format("\u54cd\u5e94\u62a5\u6587[%s]", data));
        if (data == null || data == "") {
            return null;
        }
        TypeResult typeResult = new TypeResult<UMFResponse.Message<V>>(){};
        Object result = typeResult.getResult(data, clazz);
        return result;
    }

    public static <R, V> UMFResponse.Message<V> get(String url, R req, Class<V> clazz) throws Exception {
        Map<String, String> reqMap = BeanUtil.obj2Map(req);
        Map<String, Object> resMap = UMFHttpClient.get(url, null, reqMap);
        UMFUtil.checkHttpCode(resMap, 200);
        String data = (String)resMap.get("data");
        log.info(String.format("\u54cd\u5e94\u62a5\u6587[%s]", data));
        if (data == null || data == "") {
            return null;
        }
        TypeResult typeResult = new TypeResult<UMFResponse.Message<V>>(){};
        Object result = typeResult.getResult(data, clazz);
        return result;
    }

    private static void checkHttpCode(Map<String, Object> resMap, int httpCode) {
        if (resMap == null || resMap.size() == 0) {
            throw new RuntimeException("Connection refused: connect");
        }
        int statusCode = (Integer)resMap.get("statusCode");
        if (statusCode != httpCode) {
            throw new RuntimeException("HttpClient,error status code :" + statusCode);
        }
    }

    public static <V> UMFResponse.Message<V> getBackReqMessage(HttpServletRequest request, Class<V> clazz) throws Exception {
        String plain = UMFUtil.readJSONString(request);
        String sign = request.getHeader("Signature");
        String prefix = "version=4.0&";
        plain = plain.substring(prefix.length(), plain.length());
        log.info(String.format("\u8bf7\u6c42\u62a5\u6587[%s]", plain));
        if (!RSAUtil.verifySign(plain, sign, null)) {
            throw new RuntimeException("Verify UMF signature failure");
        }
        TypeResult typeResult = new TypeResult<UMFResponse.Message<V>>(){};
        Object result = typeResult.getResult(plain, clazz);
        return result;
    }

    public static UMFResponse.Message<Map<String, String>> getFrontReqMessage(HttpServletRequest request) throws Exception {
        if (!"get".equalsIgnoreCase(request.getMethod())) {
            throw new RuntimeException("request method error:" + request.getMethod());
        }
        HashMap<String, String> reqMap = new HashMap<String, String>();
        Enumeration enumeration = request.getParameterNames();
        while (enumeration.hasMoreElements()) {
            String value;
            String fieldName = (String)enumeration.nextElement();
            try {
                value = URLDecoder.decode(request.getParameter(fieldName), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(String.format("field: %s decode error", fieldName));
            }
            reqMap.put(fieldName, value);
        }
        String sign = "";
        try {
            sign = URLDecoder.decode(request.getParameter("Signature"), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(String.format("field: %s decode error", "Signature"));
        }
        String plain = UMFHttpClient.getPlain(reqMap);
        log.info(String.format("\u8bf7\u6c42\u62a5\u6587[%s]", plain));
        if (!RSAUtil.verifySign(plain, sign, null)) {
            throw new RuntimeException("Verify UMF signature failure");
        }
        reqMap.remove("Signature");
        String ret_code = (String)reqMap.get("ret_code");
        reqMap.remove("ret_code");
        String ret_msg = (String)reqMap.get("ret_msg");
        reqMap.remove("ret_msg");
        UMFResponse.Message<Map<String, String>> message = new UMFResponse.Message<Map<String, String>>(new UMFResponse.Message.Meta(ret_code, ret_msg), reqMap, null);
        return message;
    }

    private static String readJSONString(HttpServletRequest request) {
        StringBuilder json;
        block15: {
            json = new StringBuilder();
            String line = null;
            BufferedReader reader = null;
            try {
                try {
                    reader = request.getReader();
                    while ((line = reader.readLine()) != null) {
                        json.append(line);
                    }
                    reader.close();
                }
                catch (Exception exception) {
                    try {
                        if (reader != null) {
                            reader.close();
                        }
                        break block15;
                    }
                    catch (IOException iOException) {}
                    break block15;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return json.toString();
    }
}

