/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.mp.api.impl;

import java.io.IOException;
import me.chanjar.weixin.common.bean.WxOAuth2UserInfo;
import me.chanjar.weixin.common.bean.oauth2.WxOAuth2AccessToken;
import me.chanjar.weixin.common.enums.WxType;
import me.chanjar.weixin.common.error.WxError;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.error.WxRuntimeException;
import me.chanjar.weixin.common.service.WxOAuth2Service;
import me.chanjar.weixin.common.util.http.RequestExecutor;
import me.chanjar.weixin.common.util.http.RequestHttp;
import me.chanjar.weixin.common.util.http.SimpleGetRequestExecutor;
import me.chanjar.weixin.common.util.http.URIUtil;
import me.chanjar.weixin.mp.api.WxMpService;
import me.chanjar.weixin.mp.config.WxMpConfigStorage;
import me.chanjar.weixin.mp.enums.WxMpApiUrl;
import org.apache.commons.lang3.StringUtils;

public class WxMpOAuth2ServiceImpl
implements WxOAuth2Service {
    private final WxMpService wxMpService;

    public String buildAuthorizationUrl(String redirectUri, String scope, String state) {
        return String.format(WxMpApiUrl.OAuth2.CONNECT_OAUTH2_AUTHORIZE_URL.getUrl(this.getMpConfigStorage()), this.getMpConfigStorage().getAppId(), URIUtil.encodeURIComponent((String)redirectUri), scope, StringUtils.trimToEmpty((String)state));
    }

    private WxOAuth2AccessToken getOAuth2AccessToken(String url) throws WxErrorException {
        try {
            RequestExecutor executor = SimpleGetRequestExecutor.create((RequestHttp)this.wxMpService.getRequestHttp());
            String responseText = (String)executor.execute(url, null, WxType.MP);
            return WxOAuth2AccessToken.fromJson((String)responseText);
        }
        catch (IOException e) {
            throw new WxErrorException(WxError.builder().errorCode(99999).errorMsg(e.getMessage()).build(), (Throwable)e);
        }
    }

    public WxOAuth2AccessToken getAccessToken(String code) throws WxErrorException {
        return this.getAccessToken(this.getMpConfigStorage().getAppId(), this.getMpConfigStorage().getSecret(), code);
    }

    public WxOAuth2AccessToken getAccessToken(String appId, String appSecret, String code) throws WxErrorException {
        return this.getOAuth2AccessToken(String.format(WxMpApiUrl.OAuth2.OAUTH2_ACCESS_TOKEN_URL.getUrl(this.getMpConfigStorage()), appId, appSecret, code));
    }

    public WxOAuth2AccessToken refreshAccessToken(String refreshToken) throws WxErrorException {
        String url = String.format(WxMpApiUrl.OAuth2.OAUTH2_REFRESH_TOKEN_URL.getUrl(this.getMpConfigStorage()), this.getMpConfigStorage().getAppId(), refreshToken);
        return this.getOAuth2AccessToken(url);
    }

    protected WxMpConfigStorage getMpConfigStorage() {
        return this.wxMpService.getWxMpConfigStorage();
    }

    public WxOAuth2UserInfo getUserInfo(WxOAuth2AccessToken token, String lang) throws WxErrorException {
        if (lang == null) {
            lang = "zh_CN";
        }
        String url = String.format(WxMpApiUrl.OAuth2.OAUTH2_USERINFO_URL.getUrl(this.getMpConfigStorage()), token.getAccessToken(), token.getOpenId(), lang);
        try {
            RequestExecutor executor = SimpleGetRequestExecutor.create((RequestHttp)this.wxMpService.getRequestHttp());
            String responseText = (String)executor.execute(url, null, WxType.MP);
            return WxOAuth2UserInfo.fromJson((String)responseText);
        }
        catch (IOException e) {
            throw new WxRuntimeException((Throwable)e);
        }
    }

    public boolean validateAccessToken(WxOAuth2AccessToken token) {
        String url = String.format(WxMpApiUrl.OAuth2.OAUTH2_VALIDATE_TOKEN_URL.getUrl(this.getMpConfigStorage()), token.getAccessToken(), token.getOpenId());
        try {
            SimpleGetRequestExecutor.create((RequestHttp)this.wxMpService.getRequestHttp()).execute(url, null, WxType.MP);
        }
        catch (IOException e) {
            throw new WxRuntimeException((Throwable)e);
        }
        catch (WxErrorException e) {
            return false;
        }
        return true;
    }

    public WxMpOAuth2ServiceImpl(WxMpService wxMpService) {
        this.wxMpService = wxMpService;
    }
}

