/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.middleware.dtm.client;

import com.google.protobuf.InvalidProtocolBufferException;
import com.huawei.middleware.dtm.client.DTMClientConfig;
import com.huawei.middleware.dtm.client.callback.CallbackProxy;
import com.huawei.middleware.dtm.client.context.DTMContext;
import com.huawei.middleware.dtm.common.DynamicLoaderUtil;
import com.huawei.middleware.dtm.common.logger.DTMLoggerFactory;
import com.huawei.middleware.dtm.common.protocol.MessageUtil;
import com.huawei.middleware.dtm.common.protocol.message.MessageWrapper;
import com.huawei.middleware.dtm.common.protocol.message.event.TransactionBranchCommitEvent;
import com.huawei.middleware.dtm.common.protocol.message.event.TransactionBranchRollBackEvent;
import com.huawei.middleware.dtm.common.protocol.message.response.Response;
import com.huawei.middleware.dtm.rpc.InvokerProxy;
import com.huawei.middleware.dtm.rpc.api.IInvoker;
import io.netty.channel.Channel;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import org.slf4j.Logger;

public class ClientEventHandlerRunner
implements Runnable {
    private static final Logger LOGGER = DTMLoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private MessageWrapper message;
    private Channel channel;
    private Map<String, CallbackProxy> callbackProxyMap;
    private IInvoker invoker = InvokerProxy.getInstance();

    public ClientEventHandlerRunner(MessageWrapper message, Channel channel) {
        this.message = message;
        this.channel = channel;
        this.callbackProxyMap = DTMClientConfig.CALLBACK_PROXIES;
    }

    @Override
    public void run() {
        DTMContext callbackContext = DTMContext.getDTMContext();
        int statusCode = 200;
        String msg = "";
        try {
            switch (this.message.getMessageCode()) {
                case 7: {
                    TransactionBranchCommitEvent branchCommitEvent = TransactionBranchCommitEvent.parseFrom((byte[])this.message.getMessageBytes());
                    callbackContext.setGlobalTxId(branchCommitEvent.getTransactionGlobalId());
                    callbackContext.setBranchTxId(branchCommitEvent.getTransactionBranchId());
                    callbackContext.setCustomizedData(branchCommitEvent.getCustomizedData());
                    CallbackProxy callbackProxy = this.callbackProxyMap.get(branchCommitEvent.getBranchIdentifier());
                    statusCode = this.handleCommitEvent(callbackContext, branchCommitEvent, callbackProxy, msg);
                    break;
                }
                case 8: {
                    msg = "run second stage advancement branch rollback success.";
                    TransactionBranchRollBackEvent branchRollbackEvent = TransactionBranchRollBackEvent.parseFrom((byte[])this.message.getMessageBytes());
                    callbackContext.setGlobalTxId(branchRollbackEvent.getTransactionGlobalId());
                    callbackContext.setBranchTxId(branchRollbackEvent.getTransactionBranchId());
                    callbackContext.setCustomizedData(branchRollbackEvent.getCustomizedData());
                    CallbackProxy callbackProxy = this.callbackProxyMap.get(branchRollbackEvent.getBranchIdentifier());
                    statusCode = this.handleRollbackEvent(callbackContext, branchRollbackEvent, callbackProxy, msg);
                    break;
                }
                default: {
                    msg = "Invalid message type " + this.message.getMessageCode();
                    LOGGER.error(msg);
                    statusCode = 401;
                    break;
                }
            }
        }
        catch (InvalidProtocolBufferException e) {
            msg = "Invalid protocol consumer exception.error message: " + e.getMessage();
            LOGGER.error("{},error message:{}", (Object)msg, (Object)e.getMessage());
            statusCode = 600;
        }
        Response response = Response.newBuilder().setStatusCode(statusCode).setMessage(msg).build();
        MessageWrapper messageWrapper = MessageUtil.responseMsgWrapperBuild((long)this.message.getInvokeId(), (byte)1, (byte[])response.toByteArray());
        this.invoker.asyncCall(messageWrapper, this.channel);
    }

    private int handleCommitEvent(DTMContext callbackContext, TransactionBranchCommitEvent branchCommitEvent, CallbackProxy callbackProxy, String msg) {
        try {
            if (callbackProxy == null) {
                LOGGER.info("callbackProxy is null. global id: {} branch id:{} BranchIdentifier:{}", new Object[]{branchCommitEvent.getTransactionGlobalId(), branchCommitEvent.getTransactionBranchId(), branchCommitEvent.getBranchIdentifier()});
                DynamicLoaderUtil.getRMInstance().branchCommit(branchCommitEvent.getTransactionGlobalId(), branchCommitEvent.getTransactionBranchId(), branchCommitEvent.getBranchIdentifier(), null);
                return 200;
            }
            callbackProxy.getCommitMethod().invoke(callbackProxy.getObject(), new Object[0]);
            LOGGER.info("Advance commit branch tx event witch global id: {} branch id:{}  method: {} success.", new Object[]{branchCommitEvent.getTransactionGlobalId(), branchCommitEvent.getTransactionBranchId(), callbackProxy.getCommitMethod().getName()});
        }
        catch (IllegalAccessException | NullPointerException | InvocationTargetException e) {
            msg = "Commit method " + (callbackProxy == null ? "" : callbackProxy.getCommitMethod().getName()) + ExceptionState.getExceptionStage(e.getClass()).errorMessage + " callback context: " + callbackContext.toString();
            LOGGER.error("{},error message:{}", (Object)msg, (Object)e.getMessage());
            return 400;
        }
        catch (Throwable throwable) {
            msg = "callback context: " + callbackContext.toString();
            if (callbackProxy != null) {
                msg = msg + "\tCommit method " + callbackProxy.getCommitMethod().getName() + " run failed.";
            }
            LOGGER.error("{},error message:{}", (Object)msg, (Object)throwable.getMessage());
            return 400;
        }
        return 200;
    }

    private int handleRollbackEvent(DTMContext callbackContext, TransactionBranchRollBackEvent branchRollbackEvent, CallbackProxy callbackProxy, String msg) {
        try {
            if (callbackProxy == null) {
                LOGGER.info("callbackProxy is null. global id: {} branch id:{} BranchIdentifier:{}", new Object[]{branchRollbackEvent.getTransactionGlobalId(), branchRollbackEvent.getTransactionBranchId(), branchRollbackEvent.getBranchIdentifier()});
                DynamicLoaderUtil.getRMInstance().branchRollback(branchRollbackEvent.getTransactionGlobalId(), branchRollbackEvent.getTransactionBranchId(), branchRollbackEvent.getBranchIdentifier(), null);
                return 200;
            }
            callbackProxy.getRollbackMethod().invoke(callbackProxy.getObject(), new Object[0]);
            LOGGER.info("Advance rollback branch tx event witch global id: {} branch id:{}  method: {} success.", new Object[]{branchRollbackEvent.getTransactionGlobalId(), branchRollbackEvent.getTransactionBranchId(), callbackProxy.getRollbackMethod().getName()});
        }
        catch (IllegalAccessException | NullPointerException | InvocationTargetException e) {
            msg = "Rollback method " + (callbackProxy == null ? "" : callbackProxy.getRollbackMethod().getName()) + ExceptionState.getExceptionStage(e.getClass()).errorMessage + " callback context: " + callbackContext.toString();
            LOGGER.error("{},error message:{}", (Object)msg, (Object)e.getMessage());
            return 400;
        }
        catch (Throwable throwable) {
            msg = "callback context: " + callbackContext.toString();
            if (callbackProxy != null) {
                msg = msg + "\tRollback method " + callbackProxy.getRollbackMethod().getName() + " run failed.";
            }
            LOGGER.error("{},error message:{}", (Object)msg, (Object)throwable.getMessage());
            return 400;
        }
        return 200;
    }

    private static enum ExceptionState {
        NULL_POINTER(NullPointerException.class, " is not exist."),
        ILLEGAL_ACCESS(IllegalAccessException.class, " is not accessible."),
        INVOCATION_TARGET(InvocationTargetException.class, " run failed."),
        UN_MATCH(ExceptionState.class, " unexpected.");

        Class exceptionClz;
        String errorMessage;

        private ExceptionState(Class exceptionClz, String errorMessage) {
            this.exceptionClz = exceptionClz;
            this.errorMessage = errorMessage;
        }

        static ExceptionState getExceptionStage(Class exceptionClz) {
            for (ExceptionState exceptionState : ExceptionState.values()) {
                if (!exceptionClz.equals(exceptionState.exceptionClz)) continue;
                return exceptionState;
            }
            return UN_MATCH;
        }
    }
}

