/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.middleware.dtm.client;

import com.huawei.middleware.dtm.client.Interceptor.DTMSagaBranchInterceptor;
import com.huawei.middleware.dtm.client.Interceptor.DTMTccBranchInterceptor;
import com.huawei.middleware.dtm.client.Interceptor.DTMTxBeginInterceptor;
import com.huawei.middleware.dtm.client.Interceptor.IInterceptor;
import com.huawei.middleware.dtm.client.aspect.DTMTxBeginAspect;
import com.huawei.middleware.dtm.client.callback.CallbackProxy;
import com.huawei.middleware.dtm.client.callback.DTMCallbackProcessor;
import com.huawei.middleware.dtm.client.callback.entity.DTMSagaBranchEntity;
import com.huawei.middleware.dtm.client.callback.entity.DTMTccBranchEntity;
import com.huawei.middleware.dtm.client.callback.entity.DTMTxBeginEntity;
import com.huawei.middleware.dtm.client.client.Sender.IMessageSender;
import com.huawei.middleware.dtm.client.client.connect.ConnectionManager;
import com.huawei.middleware.dtm.client.client.lb.RoundRobinMessageSender;
import com.huawei.middleware.dtm.common.configuration.PropertiesUtils;
import com.huawei.middleware.dtm.common.module.configuration.IConfigOperator;
import com.huawei.middleware.dtm.common.module.security.ISecurity;
import com.huawei.middleware.dtm.common.module.security.ISecurityImpl;
import com.huawei.middleware.dtm.rpc.InvokerProxy;
import com.huawei.middleware.dtm.rpc.api.IInvoker;
import com.huawei.paas.dtm.client.config.ConfigItems;
import com.huawei.paas.dtm.client.config.ConfigOperatorImpl;
import io.netty.channel.Channel;
import io.netty.util.concurrent.DefaultThreadFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;

@Configuration
public class DTMClientConfig {
    public static final ExecutorService ADVANCE_SHARED_EXECUTOR = new ThreadPoolExecutor(10, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new DefaultThreadFactory("Dtm-Client-Advance-Handler"));
    public static final ScheduledExecutorService RECONNECT_SCHEDULER = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new DefaultThreadFactory("Dtm-Client-Reconnect-Handler"));
    public static final ExecutorService CONNECTION_SHARED_EXECUTOR = new ThreadPoolExecutor(0, 3, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new DefaultThreadFactory("Dtm-Connection-Pool-Handler"));
    public static final Map<String, Channel> RUNNING_CHANNELS = new ConcurrentHashMap<String, Channel>();
    public static final ReentrantReadWriteLock CLIENT_RUNNING_CHANNELS_LOCK = new ReentrantReadWriteLock();
    public static final List<Channel> RUNNING_CHANNELS_LIST = new ArrayList<Channel>();
    public static final IInvoker INVOKER_SENDER = InvokerProxy.getInstance();
    public static volatile Boolean BOOT_WITH_SPRING = true;
    public static final Map<String, CallbackProxy> CALLBACK_PROXIES = new ConcurrentHashMap<String, CallbackProxy>();
    public static Map<String, DTMTxBeginEntity> dtmTxBeginEntities = new ConcurrentHashMap<String, DTMTxBeginEntity>();
    public static Map<String, DTMSagaBranchEntity> dtmSagaBranchEntities = new ConcurrentHashMap<String, DTMSagaBranchEntity>();
    public static Map<String, DTMTccBranchEntity> DtmTccBranchEntities = new ConcurrentHashMap<String, DTMTccBranchEntity>();
    public static ISecurity security = null;
    @Autowired
    private ConfigItems configItems;

    @Bean
    DTMCallbackProcessor dtmCallbackProcessor() {
        return new DTMCallbackProcessor(dtmTxBeginEntities);
    }

    @Bean
    @Order(value=1)
    IConfigOperator dtmConfigClient() throws Throwable {
        PropertiesUtils.setProperty((String)"dtm-app-name", (String)this.configItems.getDtmAppName());
        PropertiesUtils.setProperty((String)"rpc-ssl-switch", (String)(this.configItems.isRpcSslEnabled() ? "on" : "off"));
        PropertiesUtils.setProperty((String)"dtmProxyEndpoint", (String)this.configItems.getDtmProxyEndpoint());
        ConfigOperatorImpl configOperator = new ConfigOperatorImpl();
        configOperator.init();
        return configOperator;
    }

    @Bean
    @Order(value=2)
    ConnectionManager connectionManager() throws Throwable {
        security = new ISecurityImpl();
        return new ConnectionManager();
    }

    @Bean
    IMessageSender messageSender() {
        return RoundRobinMessageSender.getInstance();
    }

    @Bean
    IInterceptor dtmTxBeginInterceptor(IMessageSender messageSender) {
        return new DTMTxBeginInterceptor(messageSender);
    }

    @Bean
    IInterceptor dtmTccBranchInterceptor(IMessageSender messageSender) {
        return new DTMTccBranchInterceptor(messageSender);
    }

    @Bean
    IInterceptor dtmSagaBranchInterceptor(IMessageSender messageSender) {
        return new DTMSagaBranchInterceptor(messageSender);
    }

    @Bean
    DTMTxBeginAspect dtmTxBeginAspect(IInterceptor dtmTxBeginInterceptor) {
        return new DTMTxBeginAspect(dtmTxBeginInterceptor);
    }
}

