/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.middleware.dtm.client.Interceptor;

import com.google.protobuf.InvalidProtocolBufferException;
import com.huawei.middleware.dtm.client.DTMClientConfig;
import com.huawei.middleware.dtm.client.Interceptor.IInterceptor;
import com.huawei.middleware.dtm.client.callback.entity.DTMSagaBranchEntity;
import com.huawei.middleware.dtm.client.client.Sender.IMessageSender;
import com.huawei.middleware.dtm.client.context.DTMContext;
import com.huawei.middleware.dtm.common.exception.DTMClientException;
import com.huawei.middleware.dtm.common.exception.GlobalAdvanceException;
import com.huawei.middleware.dtm.common.exception.RPCException;
import com.huawei.middleware.dtm.common.logger.DTMLoggerFactory;
import com.huawei.middleware.dtm.common.protocol.MessageUtil;
import com.huawei.middleware.dtm.common.protocol.message.event.TransactionBranchEndedEvent;
import com.huawei.middleware.dtm.common.protocol.message.event.TransactionBranchStartedEvent;
import com.huawei.middleware.dtm.common.protocol.message.response.Response;
import com.huawei.middleware.dtm.common.protocol.message.response.TransactionIdResponse;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;

public class DTMSagaBranchInterceptor
implements IInterceptor {
    private static final Logger LOGGER = DTMLoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private IMessageSender sender;

    public DTMSagaBranchInterceptor(IMessageSender messageSender) {
        this.sender = messageSender;
    }

    @Override
    public void preIntercept(String key) throws DTMClientException {
        TransactionIdResponse response;
        DTMContext context = DTMContext.getDTMContext();
        DTMSagaBranchEntity dtmSagaBranch = DTMClientConfig.dtmSagaBranchEntities.get(key);
        if (dtmSagaBranch == null) {
            throw new DTMClientException("Tcc branch identifier " + key + " is not exist,please check.");
        }
        TransactionBranchStartedEvent txEvent = TransactionBranchStartedEvent.newBuilder().setBranchIdentifier(dtmSagaBranch.getIdentifier()).setPattern(1).putAllOptionalData(context.getBranchOptionalData()).setTransactionGlobalId(context.getGlobalTxId()).setTransactionParentId(context.getParentTxId()).setCallbackAsync(dtmSagaBranch.isCallbackAsync()).build();
        try {
            response = TransactionIdResponse.parseFrom((byte[])this.sender.sendMessage(context.getChannelKey(), MessageUtil.eventMsgWrapperBuild((byte)5, (byte[])txEvent.toByteArray())).getMessageBytes());
        }
        catch (RPCException e) {
            throw new DTMClientException(e.getMessage(), (Throwable)e);
        }
        catch (InvalidProtocolBufferException e) {
            LOGGER.error("Invalid Protocol Buffer,error message: {}", (Object)e.getMessage());
            throw new DTMClientException(e.getMessage(), (Throwable)e);
        }
        if (response.getStatusCode() != 200) {
            LOGGER.error("Pre intercept with error response,error message: {}", (Object)response.getMessage());
            throw new DTMClientException(response.getMessage());
        }
        LOGGER.info("Get dtm branch tx id: {} with global tx id: {}", (Object)response.getTransactionId(), (Object)context.getGlobalTxId());
        context.setBranchTxId(response.getTransactionId());
    }

    @Override
    public void globalPostIntercept(boolean status) throws GlobalAdvanceException {
    }

    @Override
    public void branchPostIntercept(boolean status) throws DTMClientException {
        Response response;
        DTMContext context = DTMContext.getDTMContext();
        LOGGER.info(context.toString());
        TransactionBranchEndedEvent txEvent = TransactionBranchEndedEvent.newBuilder().setCustomizedData(context.getCustomizedData()).setTransactionBranchId(context.getBranchTxId()).setTransactionGlobalId(context.getGlobalTxId()).setTransactionStatus(status).build();
        try {
            response = Response.parseFrom((byte[])this.sender.sendMessage(context.getChannelKey(), MessageUtil.eventMsgWrapperBuild((byte)6, (byte[])txEvent.toByteArray())).getMessageBytes());
        }
        catch (RPCException e) {
            throw new DTMClientException(e.getMessage(), (Throwable)e);
        }
        catch (InvalidProtocolBufferException e) {
            LOGGER.error("Invalid Protocol Buffer,error message: {}", (Object)e.getMessage());
            throw new DTMClientException(e.getMessage(), (Throwable)e);
        }
        if (response.getStatusCode() != 200) {
            LOGGER.error("Post intercept with error response,error message: {}", (Object)response.getMessage());
            throw new DTMClientException(response.getMessage());
        }
        LOGGER.info("Handler branch tx event with global tx id: {} branch tx id: {} success.", (Object)context.getGlobalTxId(), (Object)context.getBranchTxId());
    }
}

