/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.middleware.dtm.client.Interceptor;

import com.google.protobuf.InvalidProtocolBufferException;
import com.huawei.middleware.dtm.client.DTMClientConfig;
import com.huawei.middleware.dtm.client.Interceptor.IInterceptor;
import com.huawei.middleware.dtm.client.callback.entity.DTMTccBranchEntity;
import com.huawei.middleware.dtm.client.client.Sender.IMessageSender;
import com.huawei.middleware.dtm.client.context.DTMContext;
import com.huawei.middleware.dtm.common.exception.DTMClientException;
import com.huawei.middleware.dtm.common.exception.GlobalAdvanceException;
import com.huawei.middleware.dtm.common.exception.RPCException;
import com.huawei.middleware.dtm.common.logger.DTMLoggerFactory;
import com.huawei.middleware.dtm.common.protocol.MessageUtil;
import com.huawei.middleware.dtm.common.protocol.message.event.TransactionBranchEndedEvent;
import com.huawei.middleware.dtm.common.protocol.message.event.TransactionBranchStartedEvent;
import com.huawei.middleware.dtm.common.protocol.message.response.Response;
import com.huawei.middleware.dtm.common.protocol.message.response.TransactionIdResponse;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;

public class DTMTccBranchInterceptor
implements IInterceptor {
    private static final Logger LOGGER = DTMLoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private IMessageSender sender;

    public DTMTccBranchInterceptor(IMessageSender messageSender) {
        this.sender = messageSender;
    }

    @Override
    public void preIntercept(String key) throws DTMClientException {
        TransactionIdResponse response;
        DTMContext context = DTMContext.getDTMContext();
        DTMTccBranchEntity dtmTccBranch = DTMClientConfig.DtmTccBranchEntities.get(key);
        if (dtmTccBranch == null) {
            throw new DTMClientException("Tcc branch identifier " + key + " is not exist,please check.");
        }
        TransactionBranchStartedEvent.Builder builder = TransactionBranchStartedEvent.newBuilder().setBranchIdentifier(dtmTccBranch.getIdentifier()).setPattern(0).putAllOptionalData(context.getBranchOptionalData()).setTransactionGlobalId(context.getGlobalTxId()).setTransactionParentId(context.getParentTxId()).setCallbackAsync(dtmTccBranch.isCallbackAsync());
        TransactionBranchStartedEvent txEvent = builder.build();
        try {
            response = TransactionIdResponse.parseFrom((byte[])this.sender.sendMessage(context.getChannelKey(), MessageUtil.eventMsgWrapperBuild((byte)5, (byte[])txEvent.toByteArray())).getMessageBytes());
        }
        catch (RPCException e) {
            throw new DTMClientException(e.getMessage(), (Throwable)e);
        }
        catch (InvalidProtocolBufferException e) {
            LOGGER.error("Invalid Protocol Buffer,error message: {}", (Object)e.getMessage());
            throw new DTMClientException(e.getMessage(), (Throwable)e);
        }
        if (response.getStatusCode() != 200) {
            LOGGER.error("Pre intercept with error response,error message: {}", (Object)response.getMessage());
            throw new DTMClientException(response.getMessage());
        }
        LOGGER.info("Get dtm branch tx id: {} with global tx id: {}", (Object)response.getTransactionId(), (Object)context.getGlobalTxId());
        context.setBranchTxId(response.getTransactionId());
    }

    @Override
    public void globalPostIntercept(boolean status) throws GlobalAdvanceException {
    }

    @Override
    public void branchPostIntercept(boolean status) throws DTMClientException {
        Response response;
        DTMContext context = DTMContext.getDTMContext();
        TransactionBranchEndedEvent txEvent = TransactionBranchEndedEvent.newBuilder().setCustomizedData(context.getCustomizedData()).setTransactionBranchId(context.getBranchTxId()).setTransactionGlobalId(context.getGlobalTxId()).setTransactionStatus(status).build();
        try {
            response = Response.parseFrom((byte[])this.sender.sendMessage(context.getChannelKey(), MessageUtil.eventMsgWrapperBuild((byte)6, (byte[])txEvent.toByteArray())).getMessageBytes());
        }
        catch (RPCException e) {
            throw new DTMClientException(e.getMessage(), (Throwable)e);
        }
        catch (InvalidProtocolBufferException e) {
            LOGGER.error("Invalid Protocol Buffer,error message: {}", (Object)e.getMessage());
            throw new DTMClientException(e.getMessage(), (Throwable)e);
        }
        if (response.getStatusCode() != 200) {
            LOGGER.error("Post intercept with error response,error message: {}", (Object)response.getMessage());
            throw new DTMClientException(response.getMessage());
        }
        LOGGER.info("Handler branch tx event with global tx id: {} branch tx id {} status: {} .", new Object[]{context.getGlobalTxId(), context.getBranchTxId(), status});
    }
}

