/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.middleware.dtm.client.Interceptor;

import com.google.protobuf.InvalidProtocolBufferException;
import com.huawei.middleware.dtm.client.DTMClientConfig;
import com.huawei.middleware.dtm.client.Interceptor.IInterceptor;
import com.huawei.middleware.dtm.client.callback.entity.DTMTxBeginEntity;
import com.huawei.middleware.dtm.client.client.Sender.IMessageSender;
import com.huawei.middleware.dtm.client.context.DTMContext;
import com.huawei.middleware.dtm.common.configuration.DTMClientCenterConfig;
import com.huawei.middleware.dtm.common.exception.DTMClientException;
import com.huawei.middleware.dtm.common.exception.GlobalAdvanceException;
import com.huawei.middleware.dtm.common.logger.DTMLoggerFactory;
import com.huawei.middleware.dtm.common.protocol.MessageUtil;
import com.huawei.middleware.dtm.common.protocol.message.event.TransactionGlobalEndedEvent;
import com.huawei.middleware.dtm.common.protocol.message.event.TransactionGlobalStartedEvent;
import com.huawei.middleware.dtm.common.protocol.message.response.Response;
import com.huawei.middleware.dtm.common.protocol.message.response.TransactionIdResponse;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;

public class DTMTxBeginInterceptor
implements IInterceptor {
    private static final Logger LOGGER = DTMLoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private IMessageSender sender;

    public DTMTxBeginInterceptor(IMessageSender messageSender) {
        this.sender = messageSender;
    }

    @Override
    public void preIntercept(String key) throws DTMClientException {
        TransactionIdResponse response;
        DTMTxBeginEntity dtmTxBegin = DTMClientConfig.dtmTxBeginEntities.get(key);
        if (dtmTxBegin == null) {
            throw new DTMClientException("App name " + key + " is not exist,please check.");
        }
        DTMContext context = DTMContext.getDTMContext();
        TransactionGlobalStartedEvent txEvent = TransactionGlobalStartedEvent.newBuilder().setGlobalAppName(dtmTxBegin.getAppName()).setTimeout(dtmTxBegin.getTimeout()).putAllOptionalData(context.getGlobalOptionalData()).setEnableGlobalSyncType(dtmTxBegin.isEnableGlobalSyncType()).setCallbackAsync(dtmTxBegin.isCallbackAsync()).setDtmAppName(DTMClientCenterConfig.DTM_APP_NAME).build();
        try {
            response = this.sender.sendGlobalStartMessage(MessageUtil.eventMsgWrapperBuild((byte)3, (byte[])txEvent.toByteArray()));
        }
        catch (InvalidProtocolBufferException e) {
            LOGGER.error("Invalid Protocol Buffer,error message: {}", (Object)e.getMessage());
            throw new DTMClientException(e.getMessage(), (Throwable)e);
        }
        if (response.getStatusCode() != 200) {
            LOGGER.error("Pre intercept with error response,error message: {}", (Object)response.getMessage());
            throw new DTMClientException(response.getMessage());
        }
        LOGGER.info("Get dtm global transaction id: {}", (Object)response.getTransactionId());
        context.setGlobalTxId(response.getTransactionId());
        context.setBranchTxId(response.getTransactionId());
    }

    @Override
    public void branchPostIntercept(boolean status) throws DTMClientException {
    }

    @Override
    public void globalPostIntercept(boolean status) throws GlobalAdvanceException {
        Response response;
        DTMContext context = DTMContext.getDTMContext();
        TransactionGlobalEndedEvent txEvent = TransactionGlobalEndedEvent.newBuilder().setTransactionGlobalId(context.getGlobalTxId()).setTransactionStatus(status).build();
        try {
            response = Response.parseFrom((byte[])this.sender.sendGlobalEndMessage(context.getChannelKey(), MessageUtil.eventMsgWrapperBuild((byte)4, (byte[])txEvent.toByteArray()), status).getMessageBytes());
        }
        catch (DTMClientException e) {
            LOGGER.info("channel:{}", (Object)context.getChannelKey());
            throw new GlobalAdvanceException(e.getMessage(), (Throwable)e);
        }
        catch (InvalidProtocolBufferException e) {
            LOGGER.info("channel:{}", (Object)context.getChannelKey());
            LOGGER.error("Invalid Protocol Buffer,error message: {}", (Object)e.getMessage());
            throw new GlobalAdvanceException(e.getMessage(), (Throwable)e);
        }
        if (response.getStatusCode() != 200) {
            LOGGER.info("channel:{}", (Object)context.getChannelKey());
            LOGGER.error("Post intercept with error response,error message: {}", (Object)response.getMessage());
            throw new GlobalAdvanceException(response.getMessage());
        }
        LOGGER.info("Handler global tx event with id: {} success.", (Object)context.getGlobalTxId());
    }
}

