/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.middleware.dtm.client.aspect;

import com.huawei.middleware.dtm.client.Interceptor.IInterceptor;
import com.huawei.middleware.dtm.client.annotations.DTMTxBegin;
import com.huawei.middleware.dtm.client.context.DTMContext;
import com.huawei.middleware.dtm.common.configuration.DTMClientCenterConfig;
import com.huawei.middleware.dtm.common.exception.StackTraceUtil;
import com.huawei.middleware.dtm.common.logger.DTMLoggerFactory;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.UndeclaredThrowableException;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;

@Aspect
public class DTMTxBeginAspect {
    private static final Logger LOGGER = DTMLoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private IInterceptor interceptor;

    public DTMTxBeginAspect(IInterceptor dtmTxBeginInterceptor) {
        this.interceptor = dtmTxBeginInterceptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="execution(@com.huawei.middleware.dtm.client.annotations.DTMTxBegin * *(..)) && @annotation(dtmTxBegin)")
    Object intercept(ProceedingJoinPoint joinPoint, DTMTxBegin dtmTxBegin) throws Throwable {
        if (DTMClientCenterConfig.CLOSE_TRANSACTION_SWITCH.booleanValue()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Transaction switch is close,do not use DTM.");
            }
            return joinPoint.proceed();
        }
        long startTime = System.currentTimeMillis();
        DTMContext dtmContext = DTMContext.getDTMContext();
        if (dtmContext.getGlobalTxId() != -1L) {
            LOGGER.info("This is a nesting transaction. global tx id:{} ", (Object)dtmContext.getGlobalTxId());
            return joinPoint.proceed();
        }
        this.interceptor.preIntercept(dtmTxBegin.appName());
        LOGGER.debug("DTM global transaction begin, annotation DTMTxBegin: {} DTMContext:{}", (Object)dtmTxBegin, (Object)dtmContext);
        try {
            Object result;
            try {
                result = joinPoint.proceed();
            }
            catch (Throwable throwable) {
                if (throwable instanceof UndeclaredThrowableException) {
                    LOGGER.error("DTM global transaction rollback with context: {},error message:{}", (Object)dtmContext, (Object)StackTraceUtil.stackTrace((Throwable)throwable.getCause()));
                } else {
                    LOGGER.error("DTM global transaction rollback with context: {},error message:{}", (Object)dtmContext, (Object)StackTraceUtil.stackTrace((Throwable)throwable));
                }
                this.interceptor.globalPostIntercept(false);
                throw throwable;
            }
            this.interceptor.globalPostIntercept(true);
            Object object = result;
            return object;
        }
        finally {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Global tx event: {} costs {} ms", (Object)dtmContext, (Object)(System.currentTimeMillis() - startTime));
            }
            dtmContext.clearThreadContext();
        }
    }
}

