/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.middleware.dtm.client.callback;

import com.huawei.middleware.dtm.client.annotations.DTMTxBegin;
import com.huawei.middleware.dtm.client.callback.entity.DTMTxBeginEntity;
import com.huawei.middleware.dtm.common.exception.DTMClientInitializeException;
import java.lang.reflect.Method;
import java.util.Map;
import org.springframework.util.ReflectionUtils;

class MethodCheckingCallback
implements ReflectionUtils.MethodCallback {
    private Map<String, DTMTxBeginEntity> dtmTxBeginEntities;

    MethodCheckingCallback(Map<String, DTMTxBeginEntity> dtmTxBeginEntitiesTmp) {
        this.dtmTxBeginEntities = dtmTxBeginEntitiesTmp;
    }

    public void doWith(Method method) {
        if (!method.isAnnotationPresent(DTMTxBegin.class)) {
            return;
        }
        String appName = method.getAnnotation(DTMTxBegin.class).appName();
        if (this.dtmTxBeginEntities.containsKey(appName)) {
            throw new DTMClientInitializeException("Duplicate global app name : " + appName + " ,please check.");
        }
        if (appName.length() > 100) {
            throw new DTMClientInitializeException("global app name : " + appName + "'s length is larger than " + 100 + " ,please check.");
        }
        DTMTxBeginEntity dtmTxBeginEntity = new DTMTxBeginEntity();
        dtmTxBeginEntity.setAppName(appName);
        dtmTxBeginEntity.setTimeout(method.getAnnotation(DTMTxBegin.class).timeout());
        dtmTxBeginEntity.setCallbackAsync(method.getAnnotation(DTMTxBegin.class).callbackAsync());
        dtmTxBeginEntity.setEnableGlobalSyncType(method.getAnnotation(DTMTxBegin.class).enableGlobalSyncType());
        this.dtmTxBeginEntities.put(appName, dtmTxBeginEntity);
    }
}

