/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.middleware.dtm.client.client.connect;

import com.huawei.middleware.dtm.client.ClientEventHandlerRunner;
import com.huawei.middleware.dtm.client.DTMClientConfig;
import com.huawei.middleware.dtm.common.Constants;
import com.huawei.middleware.dtm.common.NetAddressUtils;
import com.huawei.middleware.dtm.common.configuration.DTMClientCenterConfig;
import com.huawei.middleware.dtm.common.entity.ActiveServerAddress;
import com.huawei.middleware.dtm.common.logger.DTMLoggerFactory;
import com.huawei.middleware.dtm.common.protocol.MessageUtil;
import com.huawei.middleware.dtm.common.protocol.message.event.TransactionRegisterEvent;
import com.huawei.middleware.dtm.common.protocol.message.response.Response;
import com.huawei.middleware.dtm.rpc.InvokerProxy;
import com.huawei.middleware.dtm.rpc.NettyClient;
import io.netty.channel.Channel;
import java.lang.invoke.MethodHandles;
import java.net.InetSocketAddress;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.springframework.util.StringUtils;

class ClientConnector {
    private static final Logger LOGGER = DTMLoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    ClientConnector() {
    }

    private static Set<String> buildAllIdentifies(Set<String> globalIdentifies, Set<String> branchIdentifies) {
        HashSet<String> allIdentifies = new HashSet<String>();
        globalIdentifies.forEach(globalIdentify -> allIdentifies.add(globalIdentify + Constants.CLIENT_GLOBAL_IDENTIFY_POSTFIX));
        allIdentifies.addAll(branchIdentifies);
        return allIdentifies;
    }

    private static boolean registerToServerAddress(String address) {
        NettyClient nettyClient = new NettyClient();
        try {
            InetSocketAddress inetSocketAddress = NetAddressUtils.toInetSocketAddress((String)address);
            Channel channel = nettyClient.connectToServer(inetSocketAddress, DTMClientConfig.RUNNING_CHANNELS, DTMClientConfig.RUNNING_CHANNELS_LIST, DTMClientConfig.ADVANCE_SHARED_EXECUTOR, ClientEventHandlerRunner.class, DTMClientConfig.CLIENT_RUNNING_CHANNELS_LOCK);
            InvokerProxy invoker = InvokerProxy.getInstance();
            Response responseMsg = Response.parseFrom((byte[])invoker.syncCall(MessageUtil.eventMsgWrapperBuild((byte)2, (byte[])TransactionRegisterEvent.newBuilder().addAllIdentifiers(ClientConnector.buildAllIdentifies(DTMClientConfig.dtmTxBeginEntities.keySet(), DTMClientConfig.CALLBACK_PROXIES.keySet())).putAllAuthData(DTMClientConfig.security.getClientAuthInfo()).build().toByteArray()), channel).getMessageBytes());
            if (responseMsg.getStatusCode() != 200) {
                LOGGER.error("Register to server server {} failed, error message: {}", (Object)address, (Object)responseMsg.getMessage());
                nettyClient.closeConnection();
                return false;
            }
            LOGGER.info("Register to server server {} success.", (Object)address);
            DTMClientConfig.RUNNING_CHANNELS.put(address, channel);
            ClientConnector.updateRunningChannels(channel);
            ClientConnector.updateAllRunningChannels();
        }
        catch (Throwable e) {
            LOGGER.error("Connect to {} failed. error message: {}", (Object)address, (Object)e.getMessage());
            nettyClient.closeConnection();
            return false;
        }
        return true;
    }

    private static void updateRunningChannels(Channel channel) {
        DTMClientConfig.CLIENT_RUNNING_CHANNELS_LOCK.writeLock().lock();
        try {
            DTMClientConfig.RUNNING_CHANNELS_LIST.removeIf(channelTmp -> NetAddressUtils.toAddressString((InetSocketAddress)((InetSocketAddress)channelTmp.remoteAddress())).equals(NetAddressUtils.toAddressString((InetSocketAddress)((InetSocketAddress)channel.remoteAddress()))));
            DTMClientConfig.RUNNING_CHANNELS_LIST.add(channel);
        }
        finally {
            DTMClientConfig.CLIENT_RUNNING_CHANNELS_LOCK.writeLock().unlock();
        }
    }

    static void updateAllRunningChannels() {
        if (DTMClientCenterConfig.MAP_GROUP_CHANGE) {
            DTMClientConfig.CLIENT_RUNNING_CHANNELS_LOCK.writeLock().lock();
            try {
                DTMClientConfig.RUNNING_CHANNELS_LIST.clear();
                DTMClientCenterConfig.ALL_SERVER_ADDRESS.forEach((key, address) -> {
                    Channel eipChannel;
                    Channel masterChannel = DTMClientConfig.RUNNING_CHANNELS.get(address.getMasterIp());
                    if (masterChannel != null) {
                        DTMClientConfig.RUNNING_CHANNELS_LIST.add(masterChannel);
                    }
                    if ((eipChannel = DTMClientConfig.RUNNING_CHANNELS.get(address.getEip())) != null) {
                        DTMClientConfig.RUNNING_CHANNELS_LIST.add(eipChannel);
                    }
                });
            }
            finally {
                DTMClientConfig.CLIENT_RUNNING_CHANNELS_LOCK.writeLock().unlock();
            }
            LOGGER.warn("Update all running channel list to : {}", DTMClientConfig.RUNNING_CHANNELS_LIST);
            DTMClientCenterConfig.MAP_GROUP_CHANGE = false;
        }
    }

    static boolean registerToServer(ActiveServerAddress address) {
        return ClientConnector.registerToServerAddress(address.getMasterIp()) || !StringUtils.isEmpty((Object)address.getEip()) && ClientConnector.registerToServerAddress(address.getEip());
    }
}

