/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.middleware.dtm.client.client.connect;

import com.huawei.middleware.dtm.client.DTMClientConfig;
import com.huawei.middleware.dtm.client.client.connect.ReconnectServerRunner;
import com.huawei.middleware.dtm.common.logger.DTMLoggerFactory;
import java.lang.invoke.MethodHandles;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;

public class ConnectionManager {
    private static final Logger LOGGER = DTMLoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public ConnectionManager() {
        if (DTMClientConfig.BOOT_WITH_SPRING.booleanValue()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("DTM client boot by spring.");
            }
            this.startConnectionTask();
        }
    }

    public void startConnectionTask() {
        this.scheduleReconnectTask();
    }

    private void scheduleReconnectTask() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Run connection task with interval time: {}", (Object)1000);
        }
        DTMClientConfig.RECONNECT_SCHEDULER.scheduleWithFixedDelay(new ReconnectServerRunner(), 1000L, 1000L, TimeUnit.MILLISECONDS);
    }
}

