/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.middleware.dtm.client.client.connect;

import com.huawei.middleware.dtm.client.DTMClientConfig;
import com.huawei.middleware.dtm.client.client.connect.ClientConnector;
import com.huawei.middleware.dtm.common.NetAddressUtils;
import com.huawei.middleware.dtm.common.configuration.DTMClientCenterConfig;
import com.huawei.middleware.dtm.common.entity.ActiveServerAddress;
import com.huawei.middleware.dtm.common.logger.DTMLoggerFactory;
import java.lang.invoke.MethodHandles;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import org.slf4j.Logger;

class ReconnectServerRunner
implements Runnable {
    private static final Logger LOGGER = DTMLoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final List<ActiveServerAddress> availableAddress = new ArrayList<ActiveServerAddress>();
    private final Set<String> availableChannel = new HashSet<String>();

    ReconnectServerRunner() {
    }

    private void refreshAvailableServer() {
        this.availableChannel.clear();
        DTMClientConfig.CLIENT_RUNNING_CHANNELS_LOCK.readLock().lock();
        try {
            DTMClientConfig.RUNNING_CHANNELS_LIST.forEach(channel -> this.availableChannel.add(NetAddressUtils.toAddressString((InetSocketAddress)((InetSocketAddress)channel.remoteAddress()))));
        }
        finally {
            DTMClientConfig.CLIENT_RUNNING_CHANNELS_LOCK.readLock().unlock();
        }
    }

    @Override
    public void run() {
        try {
            this.refreshAvailableServer();
            DTMClientCenterConfig.ALL_SERVER_ADDRESS.forEach((key, address) -> {
                if (!this.availableChannel.contains(address.getMasterIp()) && !this.availableChannel.contains(address.getEip())) {
                    this.availableAddress.add((ActiveServerAddress)address);
                }
            });
            if (DTMClientCenterConfig.ALL_SERVER_ADDRESS.isEmpty()) {
                ClientConnector.updateAllRunningChannels();
            }
            if (this.availableAddress.size() == 0) {
                return;
            }
            CountDownLatch countDownLatch = new CountDownLatch(this.availableAddress.size());
            this.availableAddress.forEach(address -> DTMClientConfig.CONNECTION_SHARED_EXECUTOR.submit(() -> {
                ClientConnector.registerToServer(address);
                countDownLatch.countDown();
            }));
            countDownLatch.await();
        }
        catch (Throwable throwable) {
            LOGGER.error(throwable.getMessage());
        }
        finally {
            this.availableAddress.clear();
        }
    }
}

