/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.middleware.dtm.client.client.lb;

import com.huawei.middleware.dtm.client.DTMClientConfig;
import com.huawei.middleware.dtm.client.client.Sender.AbstractMessageSender;
import com.huawei.middleware.dtm.client.context.DTMContext;
import com.huawei.middleware.dtm.common.NetAddressUtils;
import com.huawei.middleware.dtm.common.exception.DTMClientException;
import com.huawei.middleware.dtm.common.logger.DTMLoggerFactory;
import io.netty.channel.Channel;
import java.lang.invoke.MethodHandles;
import java.net.InetSocketAddress;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;

public class RoundRobinMessageSender
extends AbstractMessageSender {
    private static final Logger LOGGER = DTMLoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private AtomicInteger idx = new AtomicInteger(0);
    private static RoundRobinMessageSender instance = new RoundRobinMessageSender();

    private RoundRobinMessageSender() {
    }

    public static RoundRobinMessageSender getInstance() {
        return instance;
    }

    @Override
    public Channel chooseNext() throws DTMClientException {
        Channel channel;
        DTMClientConfig.CLIENT_RUNNING_CHANNELS_LOCK.readLock().lock();
        try {
            if (DTMClientConfig.RUNNING_CHANNELS_LIST.size() == 0) {
                throw new DTMClientException("No available server service.");
            }
            channel = DTMClientConfig.RUNNING_CHANNELS_LIST.get(this.idx.incrementAndGet() % DTMClientConfig.RUNNING_CHANNELS_LIST.size());
        }
        finally {
            DTMClientConfig.CLIENT_RUNNING_CHANNELS_LOCK.readLock().unlock();
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Choose an server server channel {}", (Object)channel);
        }
        DTMContext dtmContext = DTMContext.getDTMContext();
        dtmContext.setChannelKey(NetAddressUtils.toAddressString((InetSocketAddress)((InetSocketAddress)channel.remoteAddress())));
        return channel;
    }
}

