/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.middleware.dtm.client.context;

import com.huawei.middleware.dtm.client.DTMClientConfig;
import com.huawei.middleware.dtm.common.exception.ShouldNeverHappenException;
import java.util.HashMap;
import java.util.Map;

public class DTMContext {
    private static final ThreadLocal<DTMContext> CONTEXT_LOCAL = ThreadLocal.withInitial(() -> new DTMContext());
    private static final ThreadLocal<DTMContext> CONTEXT_LOCAL_BACKUP = new ThreadLocal();
    private static final ThreadLocal<DTMContext> CONTEXT_BRANCH_BACKUP = ThreadLocal.withInitial(DTMContext::newContext);
    private String customizedData = "";
    private Map<String, String> globalOptionalData = new HashMap<String, String>();
    private Map<String, String> branchOptionalData = new HashMap<String, String>();
    private long globalTxId = -1L;
    private long branchTxId = -1L;
    private long parentTxId = -1L;
    private String channelKey = "";

    private static DTMContext newContext() {
        return new DTMContext();
    }

    protected DTMContext clone() throws CloneNotSupportedException {
        DTMContext context = (DTMContext)super.clone();
        context.setGlobalOptionalData(new HashMap<String, String>(this.getGlobalOptionalData()));
        context.setBranchOptionalData(new HashMap<String, String>(this.getBranchOptionalData()));
        return context;
    }

    public static void backupBranchContext() {
        DTMContext branchContext = CONTEXT_BRANCH_BACKUP.get();
        DTMContext context = CONTEXT_LOCAL.get();
        branchContext.setGlobalTxId(context.getGlobalTxId());
        branchContext.setParentTxId(context.getParentTxId());
        branchContext.setBranchTxId(context.getBranchTxId());
        branchContext.setChannelKey(context.getChannelKey());
        branchContext.setCustomizedData(context.getCustomizedData());
        branchContext.getGlobalOptionalData().clear();
        branchContext.getBranchOptionalData().clear();
        branchContext.getGlobalOptionalData().putAll(context.getGlobalOptionalData());
        branchContext.getBranchOptionalData().putAll(context.getBranchOptionalData());
    }

    public static void recoverBranchContext() {
        DTMContext branchContext = CONTEXT_BRANCH_BACKUP.get();
        DTMContext context = CONTEXT_LOCAL.get();
        context.setGlobalTxId(branchContext.getGlobalTxId());
        context.setParentTxId(branchContext.getParentTxId());
        context.setBranchTxId(branchContext.getBranchTxId());
        context.setChannelKey(branchContext.getChannelKey());
        context.setCustomizedData(branchContext.getCustomizedData());
        context.getGlobalOptionalData().clear();
        context.getBranchOptionalData().clear();
        context.getGlobalOptionalData().putAll(branchContext.getGlobalOptionalData());
        context.getBranchOptionalData().putAll(branchContext.getBranchOptionalData());
    }

    public static boolean hasAvailableServer() {
        return !DTMClientConfig.RUNNING_CHANNELS_LIST.isEmpty();
    }

    public static String showAvailableServer() {
        return DTMClientConfig.RUNNING_CHANNELS_LIST.toString();
    }

    public static void suspendTransaction() {
        CONTEXT_LOCAL_BACKUP.set(CONTEXT_LOCAL.get());
        CONTEXT_LOCAL.remove();
    }

    public static void resumeTransaction() {
        CONTEXT_LOCAL.set(CONTEXT_LOCAL_BACKUP.get());
    }

    private DTMContext() {
    }

    public static DTMContext getDTMContext() {
        return CONTEXT_LOCAL.get();
    }

    public long getGlobalTxId() {
        return this.globalTxId;
    }

    public void setGlobalTxId(long globalTxId) {
        this.globalTxId = globalTxId;
    }

    public long getBranchTxId() {
        return this.branchTxId;
    }

    public void setBranchTxId(long branchTxId) {
        this.branchTxId = branchTxId;
    }

    public long getParentTxId() {
        return this.parentTxId;
    }

    public void setParentTxId(long parentTxId) {
        this.parentTxId = parentTxId;
    }

    public String getCustomizedData() {
        return this.customizedData;
    }

    public void setCustomizedData(String customizedData) {
        if (customizedData.length() > 100) {
            throw new RuntimeException("dtm custom data's length can not longer than 100");
        }
        if (customizedData.contains(",")) {
            throw new RuntimeException("dtm custom data can not contain ',' 100");
        }
        this.customizedData = customizedData;
    }

    public Map<String, String> getGlobalOptionalData() {
        return this.globalOptionalData;
    }

    public void setGlobalOptionalData(Map<String, String> globalOptionalData) {
        this.globalOptionalData = globalOptionalData;
    }

    public Map<String, String> getBranchOptionalData() {
        return this.branchOptionalData;
    }

    public void setBranchOptionalData(Map<String, String> branchOptionalData) {
        this.branchOptionalData = branchOptionalData;
    }

    public String getChannelKey() {
        return this.channelKey;
    }

    public void setChannelKey(String channelKey) {
        this.channelKey = channelKey;
    }

    public static boolean inGlobalTransaction() {
        return DTMContext.getDTMContext().getGlobalTxId() != -1L;
    }

    public static void assertNotInGlobalTransaction() {
        if (DTMContext.inGlobalTransaction()) {
            throw new ShouldNeverHappenException();
        }
    }

    public void clearThreadContext() {
        if (this.globalOptionalData != null) {
            this.globalOptionalData.clear();
        }
        if (this.branchOptionalData != null) {
            this.branchOptionalData.clear();
        }
        this.customizedData = "";
        this.globalTxId = -1L;
        this.branchTxId = -1L;
        this.parentTxId = -1L;
        this.channelKey = "";
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("GlobalTxId=").append(this.globalTxId).append(", BranchTxId=").append(this.branchTxId).append(", ParentTxId=").append(this.parentTxId).append(", ChannelKey=").append(this.channelKey).append(", CustomizeData=").append(this.customizedData).append(", GlobalOptionalData={ ");
        this.globalOptionalData.forEach((key, value) -> stringBuilder.append((String)key).append(":").append((String)value).append(","));
        stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        stringBuilder.append(" },").append("branchOptionalData={ ");
        this.branchOptionalData.forEach((key, value) -> stringBuilder.append((String)key).append(":").append((String)value).append(","));
        stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        stringBuilder.append(" }");
        return stringBuilder.toString();
    }
}

