/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.middleware.dtm.client.tcc.aspect;

import com.huawei.middleware.dtm.client.Interceptor.IInterceptor;
import com.huawei.middleware.dtm.client.context.DTMContext;
import com.huawei.middleware.dtm.client.tcc.annotations.DTMTccBranch;
import com.huawei.middleware.dtm.common.configuration.DTMClientCenterConfig;
import com.huawei.middleware.dtm.common.exception.StackTraceUtil;
import com.huawei.middleware.dtm.common.logger.DTMLoggerFactory;
import java.lang.invoke.MethodHandles;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;

@Aspect
public class DTMTccBranchAspect {
    private static final Logger LOGGER = DTMLoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private IInterceptor interceptor;

    public DTMTccBranchAspect(IInterceptor dtmTccBranchInterceptor) {
        this.interceptor = dtmTccBranchInterceptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="execution(@com.huawei.middleware.dtm.client.tcc.annotations.DTMTccBranch * *(..)) && @annotation(dtmTccBranch)")
    Object intercept(ProceedingJoinPoint joinPoint, DTMTccBranch dtmTccBranch) throws Throwable {
        DTMContext dtmContext = DTMContext.getDTMContext();
        if (DTMClientCenterConfig.CLOSE_TRANSACTION_SWITCH.booleanValue() || dtmContext.getGlobalTxId() == -1L) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Current transaction switch is close or this tcc branch is not in a global transaction,do not use DTM, globalTxId={}", (Object)dtmContext.getGlobalTxId());
            }
            return joinPoint.proceed();
        }
        try {
            Object result;
            DTMContext.backupBranchContext();
            dtmContext.setParentTxId(dtmContext.getBranchTxId());
            LOGGER.debug("DTM tcc branch transaction begin, annotation DTMSagaBranch: {}", (Object)dtmTccBranch);
            this.interceptor.preIntercept(dtmTccBranch.identifier());
            try {
                result = joinPoint.proceed();
            }
            catch (Throwable throwable) {
                LOGGER.error("DTM tcc branch transaction run failed.context: {},error message:{}", (Object)dtmContext, (Object)StackTraceUtil.stackTrace((Throwable)throwable));
                this.interceptor.branchPostIntercept(false);
                throw throwable;
            }
            this.interceptor.branchPostIntercept(true);
            Object object = result;
            return object;
        }
        finally {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("DTM tcc branch transaction end, DtmContext: {}", (Object)dtmContext);
            }
            DTMContext.recoverBranchContext();
        }
    }
}

