/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.middleware.dtm.client.tcc.callback;

import com.huawei.middleware.dtm.client.callback.CallbackProxy;
import com.huawei.middleware.dtm.client.callback.entity.DTMTccBranchEntity;
import com.huawei.middleware.dtm.client.tcc.annotations.DTMTccBranch;
import com.huawei.middleware.dtm.common.exception.DTMClientInitializeException;
import com.huawei.middleware.dtm.common.logger.DTMLoggerFactory;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.util.Map;
import org.slf4j.Logger;
import org.springframework.util.ReflectionUtils;

class TccMethodCheckingCallback
implements ReflectionUtils.MethodCallback {
    private static final Logger LOGGER = DTMLoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private Map<String, CallbackProxy> CALLBACK_PROXIES;
    private Map<String, DTMTccBranchEntity> DtmTccBranchEntities;
    private Object bean;

    TccMethodCheckingCallback(Object obj, Map<String, CallbackProxy> callbackProxyMap, Map<String, DTMTccBranchEntity> dtmTccBranchEntities) {
        this.bean = obj;
        this.CALLBACK_PROXIES = callbackProxyMap;
        this.DtmTccBranchEntities = dtmTccBranchEntities;
    }

    public void doWith(Method method) {
        if (!method.isAnnotationPresent(DTMTccBranch.class)) {
            return;
        }
        String commitMethod = null;
        String rollbackMethod = null;
        String identifier = "";
        if (method.isAnnotationPresent(DTMTccBranch.class)) {
            commitMethod = method.getAnnotation(DTMTccBranch.class).confirmMethod();
            rollbackMethod = method.getAnnotation(DTMTccBranch.class).cancelMethod();
            identifier = method.getAnnotation(DTMTccBranch.class).identifier();
        }
        if (this.CALLBACK_PROXIES.containsKey(identifier)) {
            throw new DTMClientInitializeException("Duplicate identifier name : " + identifier + " ,please check.");
        }
        if (identifier.length() > 100) {
            throw new DTMClientInitializeException("identifier name : " + identifier + "'s length is larger than " + 100 + " ,please check.");
        }
        Method commit = null;
        Method rollback = null;
        try {
            if (commitMethod != null) {
                commit = this.bean.getClass().getDeclaredMethod(commitMethod, new Class[0]);
                commit.setAccessible(true);
            }
        }
        catch (NoSuchMethodException e) {
            throw new DTMClientInitializeException("No such commit method [" + commitMethod + "()] found in " + this.bean.getClass().getCanonicalName(), (Throwable)e);
        }
        try {
            if (rollbackMethod != null) {
                rollback = this.bean.getClass().getDeclaredMethod(rollbackMethod, new Class[0]);
                rollback.setAccessible(true);
            }
        }
        catch (NoSuchMethodException e) {
            throw new DTMClientInitializeException("No such rollback method [" + rollbackMethod + "()] found in " + this.bean.getClass().getCanonicalName(), (Throwable)e);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Found tcc callback bean with identifier:{}", (Object)identifier);
        }
        DTMTccBranchEntity dtmTccBranchEntity = new DTMTccBranchEntity();
        dtmTccBranchEntity.setAutoInit(true);
        dtmTccBranchEntity.setIdentifier(identifier);
        dtmTccBranchEntity.setCallbackAsync(method.getAnnotation(DTMTccBranch.class).callbackAsync());
        dtmTccBranchEntity.setConfirmMethod(method.getAnnotation(DTMTccBranch.class).confirmMethod());
        dtmTccBranchEntity.setCancelMethod(method.getAnnotation(DTMTccBranch.class).cancelMethod());
        this.DtmTccBranchEntities.put(identifier, dtmTccBranchEntity);
        CallbackProxy callbackProxy = new CallbackProxy(this.bean, commit, rollback);
        this.CALLBACK_PROXIES.put(identifier, callbackProxy);
    }
}

