/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.paas.dtm.client.config;

import com.fasterxml.jackson.core.type.TypeReference;
import com.huawei.middleware.dtm.common.ServerIdUtils;
import com.huawei.middleware.dtm.common.configuration.DTMClientCenterConfig;
import com.huawei.middleware.dtm.common.configuration.PropertiesUtils;
import com.huawei.middleware.dtm.common.exception.ConfigException;
import com.huawei.middleware.dtm.common.logger.DTMLoggerFactory;
import com.huawei.middleware.dtm.common.module.configuration.IConfigOperator;
import com.huawei.paas.dtm.client.config.ActiveServerAddress;
import com.huawei.paas.dtm.client.config.ApiResponse;
import com.huawei.paas.dtm.common.util.HttpUtil;
import io.netty.util.concurrent.DefaultThreadFactory;
import io.vertx.core.json.Json;
import io.vertx.core.json.JsonObject;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.springframework.util.CollectionUtils;

public class ConfigOperatorImpl
implements IConfigOperator {
    private static final Logger LOGGER = DTMLoggerFactory.getLogger(ConfigOperatorImpl.class);
    public static final int PERIOD_REFRESH_SERVERS = 10;
    private static final ExecutorService DTM_CLIENT_CONFIGURATION_WATCHER = Executors.newFixedThreadPool(2, (ThreadFactory)new DefaultThreadFactory("Dtm-Client-Configuration-Update-Thread"));
    private String dtmProxyEndpoint = PropertiesUtils.getProperty((String)"dtmProxyEndpoint");
    private static final ScheduledExecutorService DTM_SERVERS_REFRESH_EXECUTOR = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new DefaultThreadFactory("DTM_SERVERS_REFRESH_THREAD"));

    public void init() throws Throwable {
        this.loadConfig();
        DTM_SERVERS_REFRESH_EXECUTOR.scheduleAtFixedRate(() -> {
            try {
                this.loadActiveServerAddress();
            }
            catch (Throwable throwable) {
                LOGGER.error("failed to refresh servers", throwable);
            }
        }, 0L, 10L, TimeUnit.SECONDS);
    }

    public void loadConfig() throws ConfigException {
        this.loadClientConfiguration();
        this.loadActiveServerAddress();
    }

    private void loadActiveServerAddress() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("serverGroupId", String.valueOf(DTMClientCenterConfig.SERVER_GROUP_ID));
        String activeServersResponse = HttpUtil.get((String)(this.dtmProxyEndpoint + "/config/activeServers"), null, params);
        Set activeServerAddresses = (Set)((ApiResponse)Json.decodeValue((String)activeServersResponse, (TypeReference)new TypeReference<ApiResponse<Set<ActiveServerAddress>>>(){})).getData();
        if (CollectionUtils.isEmpty((Collection)activeServerAddresses)) {
            return;
        }
        Iterator iterator = DTMClientCenterConfig.ALL_SERVER_ADDRESS.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            boolean existed = false;
            for (ActiveServerAddress activeServerAddress : activeServerAddresses) {
                if (ServerIdUtils.getRealServerId((int)DTMClientCenterConfig.SERVER_GROUP_ID, (int)activeServerAddress.getServerLocalId()) != (Integer)entry.getKey()) continue;
                existed = true;
                break;
            }
            if (existed) continue;
            iterator.remove();
        }
        for (ActiveServerAddress activeServerAddress : activeServerAddresses) {
            com.huawei.middleware.dtm.common.entity.ActiveServerAddress serverAddress = new com.huawei.middleware.dtm.common.entity.ActiveServerAddress(activeServerAddress.getMasterIp(), activeServerAddress.getEip());
            int serverId = ServerIdUtils.getRealServerId((int)DTMClientCenterConfig.SERVER_GROUP_ID, (int)activeServerAddress.getServerLocalId());
            if (DTMClientCenterConfig.ALL_SERVER_ADDRESS.containsKey(serverId)) {
                com.huawei.middleware.dtm.common.entity.ActiveServerAddress existedServerAddress = (com.huawei.middleware.dtm.common.entity.ActiveServerAddress)DTMClientCenterConfig.ALL_SERVER_ADDRESS.get(serverId);
                if (this.serverEquals(existedServerAddress, serverAddress)) continue;
                DTMClientCenterConfig.ALL_SERVER_ADDRESS.put(serverId, serverAddress);
                continue;
            }
            DTMClientCenterConfig.ALL_SERVER_ADDRESS.put(serverId, serverAddress);
        }
    }

    private boolean serverEquals(com.huawei.middleware.dtm.common.entity.ActiveServerAddress serverAddress, com.huawei.middleware.dtm.common.entity.ActiveServerAddress otherServerAddress) {
        if (serverAddress.getMasterIp() == null) {
            if (otherServerAddress.getMasterIp() == null) {
                if (serverAddress.getEip() == null) {
                    return otherServerAddress.getEip() == null;
                }
                return serverAddress.getEip().equals(otherServerAddress.getEip());
            }
            return false;
        }
        if (otherServerAddress.getMasterIp() != null) {
            if (!serverAddress.getMasterIp().equals(otherServerAddress.getMasterIp())) {
                return false;
            }
            if (serverAddress.getEip() == null) {
                return otherServerAddress.getEip() == null;
            }
            return serverAddress.getEip().equals(otherServerAddress.getEip());
        }
        return false;
    }

    private void loadClientConfiguration() throws ConfigException {
        DTMClientCenterConfig.DTM_APP_NAME = PropertiesUtils.getProperty((String)"dtm-app-name");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("dtmAppName", DTMClientCenterConfig.DTM_APP_NAME);
        String serverGroupResponse = HttpUtil.get((String)(this.dtmProxyEndpoint + "/config/serverGroupId"), null, params);
        int serverGroupId = new JsonObject(serverGroupResponse).getInteger("data");
        if (!ServerIdUtils.serverGroupIdValid((int)serverGroupId)) {
            throw new ConfigException("server group id is invalid");
        }
        DTMClientCenterConfig.SERVER_GROUP_ID = serverGroupId;
    }

    public void setServerAvailable() throws ConfigException {
    }

    public void setServerUnavailable() throws ConfigException {
    }

    public void watchConfigChange() throws ConfigException {
    }

    public String getOrderDtmAppName(String projectId) throws ConfigException {
        return "";
    }

    public boolean isConnected() {
        return false;
    }
}

