/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import org.apache.commons.codec.binary.Base64;

public class RSASecurityUtil2 {
    private static final String KEY_ALGORITHM = "RSA";
    private static final String SIGNATURE_ALGORITHM = "Md5withRSA";
    private static final int KEYSIZE = 1024;
    public static final String PUBLIC_KEY = "yourname.pub";
    public static final String PRIVATE_KEY = "yourname.pri";
    private static final int LINE_SIZE = 65;
    private static final byte[] NEW_LINE_BYTES = "\r\n".getBytes();
    private static final byte[] KEY_ALGORITHM_HEADER = "key generate algorithm: RSA".getBytes();
    private static final byte[] KEY_SIZE_HEADER = "key size: 1024".getBytes();
    private static final byte[] START_PUBLIC_KEY_BYTES = "##############start public key##############".getBytes();
    private static final byte[] END_PUBLIC_KEY_BYTES = "##############end public key##############".getBytes();
    private static final byte[] START_PRIVATE_KEY_BYTES = "##############start private key##############".getBytes();
    private static final byte[] END_PRIVATE_KEY_BYTES = "##############end private key##############".getBytes();

    public static String sign(byte[] data, byte[] privateKey) throws RSASecurityException {
        byte[] keyBytes = privateKey;
        PKCS8EncodedKeySpec pksc = new PKCS8EncodedKeySpec(keyBytes);
        try {
            KeyFactory keyfactory = KeyFactory.getInstance(KEY_ALGORITHM);
            PrivateKey pk = keyfactory.generatePrivate(pksc);
            Signature signature = Signature.getInstance(SIGNATURE_ALGORITHM);
            signature.initSign(pk);
            signature.update(data);
            return RSASecurityUtil2.encryptBASE64(signature.sign());
        }
        catch (Exception e) {
            throw new RSASecurityException(e);
        }
    }

    public static boolean verify(byte[] data, byte[] publicKey, String sign) throws RSASecurityException {
        byte[] keyBytes = publicKey;
        X509EncodedKeySpec xksc = new X509EncodedKeySpec(keyBytes);
        try {
            KeyFactory keyfactory = KeyFactory.getInstance(KEY_ALGORITHM);
            PublicKey pk = keyfactory.generatePublic(xksc);
            Signature signature = Signature.getInstance(SIGNATURE_ALGORITHM);
            signature.initVerify(pk);
            signature.update(data);
            return signature.verify(RSASecurityUtil2.decryptBASE64(sign));
        }
        catch (Exception e) {
            throw new RSASecurityException(e);
        }
    }

    public static void initKey() throws NoSuchAlgorithmException, FileNotFoundException, RSASecurityException {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(KEY_ALGORITHM);
        keyPairGenerator.initialize(1024);
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        RSAPublicKey publicKey = (RSAPublicKey)keyPair.getPublic();
        RSAPrivateKey privateKey = (RSAPrivateKey)keyPair.getPrivate();
        RSASecurityUtil2.savePublicKey(publicKey);
        RSASecurityUtil2.savePrivateKey(publicKey, privateKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void savePublicKey(Key key) throws FileNotFoundException {
        FileOutputStream os = new FileOutputStream(PUBLIC_KEY);
        try {
            ((OutputStream)os).write(KEY_ALGORITHM_HEADER);
            ((OutputStream)os).write(NEW_LINE_BYTES);
            ((OutputStream)os).write(KEY_SIZE_HEADER);
            ((OutputStream)os).write(NEW_LINE_BYTES);
            ((OutputStream)os).write(START_PUBLIC_KEY_BYTES);
            ((OutputStream)os).write(NEW_LINE_BYTES);
            RSASecurityUtil2.saveBase64KeyToStream(key, os);
            ((OutputStream)os).write(END_PUBLIC_KEY_BYTES);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                os.flush();
                ((OutputStream)os).close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void savePrivateKey(Key pubKey, Key priKey) throws FileNotFoundException {
        FileOutputStream os = new FileOutputStream(PRIVATE_KEY);
        try {
            ((OutputStream)os).write(KEY_ALGORITHM_HEADER);
            ((OutputStream)os).write(NEW_LINE_BYTES);
            ((OutputStream)os).write(KEY_SIZE_HEADER);
            ((OutputStream)os).write(NEW_LINE_BYTES);
            ((OutputStream)os).write(START_PUBLIC_KEY_BYTES);
            ((OutputStream)os).write(NEW_LINE_BYTES);
            RSASecurityUtil2.saveBase64KeyToStream(pubKey, os);
            ((OutputStream)os).write(END_PUBLIC_KEY_BYTES);
            ((OutputStream)os).write(NEW_LINE_BYTES);
            ((OutputStream)os).write(START_PRIVATE_KEY_BYTES);
            ((OutputStream)os).write(NEW_LINE_BYTES);
            RSASecurityUtil2.saveBase64KeyToStream(priKey, os);
            ((OutputStream)os).write(END_PRIVATE_KEY_BYTES);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                os.flush();
                ((OutputStream)os).close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static void saveBase64KeyToStream(Key key, OutputStream out) throws IOException {
        byte[] keyBytes = key.getEncoded();
        byte[] base64Bytes = RSASecurityUtil2.encryptBASE64(keyBytes).getBytes();
        int len = 0;
        for (int start = 0; start < base64Bytes.length; start += len) {
            len = Math.min(65, base64Bytes.length - start);
            out.write(base64Bytes, start, len);
            out.write(NEW_LINE_BYTES);
        }
    }

    public static byte[] loadKeyFromStream(InputStream in, KeyType keyType) throws RSASecurityException {
        try {
            InputStreamReader isr = new InputStreamReader(in);
            BufferedReader rb = new BufferedReader(isr);
            StringBuffer privateKey = new StringBuffer();
            String line = null;
            boolean firstLine = true;
            boolean containsDesc = false;
            boolean start = false;
            while ((line = rb.readLine()) != null) {
                if (firstLine) {
                    if (line.equals(new String(KEY_ALGORITHM_HEADER))) {
                        containsDesc = true;
                    }
                    firstLine = false;
                }
                if (containsDesc && !start) {
                    if (keyType.equals((Object)KeyType.PRIVATE_KEY) && line.equals(new String(START_PRIVATE_KEY_BYTES))) {
                        start = true;
                        continue;
                    }
                    if (!keyType.equals((Object)KeyType.PUBLIC_KEY) || !line.equals(new String(START_PUBLIC_KEY_BYTES))) continue;
                    start = true;
                    continue;
                }
                if (start && (keyType.equals((Object)KeyType.PRIVATE_KEY) && line.equals(new String(END_PRIVATE_KEY_BYTES)) || keyType.equals((Object)KeyType.PUBLIC_KEY) && line.equals(new String(END_PUBLIC_KEY_BYTES)))) break;
                privateKey.append(line);
            }
            return RSASecurityUtil2.decryptBASE64(privateKey.toString());
        }
        catch (Exception e) {
            throw new RSASecurityException(e);
        }
    }

    public static byte[] decryptBASE64(String key) {
        return Base64.decodeBase64((String)key);
    }

    public static String encryptBASE64(byte[] key) {
        return Base64.encodeBase64String((byte[])key);
    }

    public static void main(String[] args) throws NoSuchAlgorithmException, FileNotFoundException, RSASecurityException {
        RSASecurityUtil2.initKey();
    }

    public static class RSASecurityException
    extends Exception {
        private static final long serialVersionUID = -8300595655328202417L;

        public RSASecurityException(String msg) {
            super(msg);
        }

        public RSASecurityException(Throwable t) {
            super(t);
        }

        public RSASecurityException(String msg, Throwable t) {
            super(msg, t);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum KeyType {
        PUBLIC_KEY("public key"),
        PRIVATE_KEY("private key");

        String type;

        private KeyType(String type) {
            this.type = type;
        }
    }
}

