/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.ui;

import com.icbc.api.RSASecurityUtil2;
import com.icbc.api.ui.UiInvoker;
import com.icbc.api.ui.UiUrlComponent;
import java.io.FileNotFoundException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractUiInvoker
implements UiInvoker {
    String uri;
    List<String> params = new ArrayList<String>();

    public String generateUiServiceUrl() throws RSASecurityUtil2.RSASecurityException, FileNotFoundException, UnsupportedEncodingException {
        String appId = this.getAppId();
        String busiParams = this.getParamsStr();
        long currTime = System.currentTimeMillis();
        byte[] data = (appId + busiParams + currTime).getBytes("UTF-8");
        String sign = RSASecurityUtil2.sign((byte[])data, (byte[])this.getPrivateKeyBytes());
        StringBuilder sb = new StringBuilder();
        sb.append(this.getBaseUri());
        sb.append(this.getUri());
        sb.append((Object)UiUrlComponent.QU_MK);
        sb.append((Object)UiUrlComponent.APP_ID);
        sb.append((Object)UiUrlComponent.ES);
        sb.append(appId);
        sb.append((Object)UiUrlComponent.SP_JOINT);
        sb.append((Object)UiUrlComponent.BUSI_PARAMS);
        sb.append((Object)UiUrlComponent.ES);
        sb.append(URLEncoder.encode(busiParams, "UTF-8"));
        sb.append((Object)UiUrlComponent.SP_JOINT);
        sb.append((Object)UiUrlComponent.CURR_TIME);
        sb.append((Object)UiUrlComponent.ES);
        sb.append(currTime);
        sb.append((Object)UiUrlComponent.SP_JOINT);
        sb.append((Object)UiUrlComponent.SIGNATURE);
        sb.append((Object)UiUrlComponent.ES);
        sb.append(URLEncoder.encode(sign, "UTF-8"));
        return sb.toString();
    }

    private String getParamsStr() {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (true) {
            sb.append(this.params.get(i));
            if (++i == this.params.size()) break;
            sb.append((Object)UiUrlComponent.SP_TOKEN);
        }
        return sb.toString();
    }

    public UiInvoker setUri(String uri) {
        this.uri = uri;
        return this;
    }

    public String getUri() {
        return this.uri;
    }

    public UiInvoker addParameter(String value) {
        this.params.add(value);
        return this;
    }
}

